/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.SupplementItemInfo;
import fr.protactile.procaisse.dao.entities.MultiLanguageGSS;
import java.util.ArrayList;
import java.util.List;

public class GroupSubSupplementInfo {
    private int id;
    private String name_group;
    private String title_group;
    private boolean removed;
    private String ref_synchro;
    private boolean has_limit_options;
    private int min_options;
    private int max_options;
    private int option_free;
    private int option_free_tmp;
    private List<SupplementItemInfo> supplements;
    private String id_global;
    private int number_click;
    private List<MultiLanguageGSS> multiLanguageTexts;

    public GroupSubSupplementInfo() {
        this.supplements = new ArrayList<SupplementItemInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageGSS>();
    }

    public GroupSubSupplementInfo(int id) {
        this.id = id;
        this.supplements = new ArrayList<SupplementItemInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageGSS>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTitle_group() {
        return this.title_group;
    }

    public void setTitle_group(String title_group) {
        this.title_group = title_group;
    }

    public String getName_group() {
        return this.name_group;
    }

    public void setName_group(String name_group) {
        this.name_group = name_group;
    }

    public List<SupplementItemInfo> getSupplements() {
        return this.supplements;
    }

    public void setSupplements(List<SupplementItemInfo> supplements) {
        this.supplements = supplements;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public String getRef_synchro() {
        return this.ref_synchro;
    }

    public void setRef_synchro(String ref_synchro) {
        this.ref_synchro = ref_synchro;
    }

    public boolean isHas_limit_options() {
        return this.has_limit_options;
    }

    public void setHas_limit_options(boolean has_limit_options) {
        this.has_limit_options = has_limit_options;
    }

    public int getMin_options() {
        return this.min_options;
    }

    public void setMin_options(int min_options) {
        this.min_options = min_options;
    }

    public int getMax_options() {
        return this.max_options;
    }

    public void setMax_options(int max_options) {
        this.max_options = max_options;
    }

    public int getOption_free() {
        return this.option_free;
    }

    public void setOption_free(int option_free) {
        this.option_free = option_free;
    }

    public int getOption_free_tmp() {
        return this.option_free_tmp;
    }

    public void setOption_free_tmp(int option_free_tmp) {
        this.option_free_tmp = option_free_tmp;
    }

    public static SerializerRead getSerializerRead() {
        return dr -> {
            GroupSubSupplementInfo groupSubSupplement = new GroupSubSupplementInfo();
            groupSubSupplement.id = dr.getInt(1);
            groupSubSupplement.name_group = dr.getString(2);
            groupSubSupplement.title_group = dr.getString(3);
            groupSubSupplement.removed = dr.getBoolean(4);
            groupSubSupplement.has_limit_options = dr.getBoolean(5);
            groupSubSupplement.min_options = dr.getInt(6);
            groupSubSupplement.max_options = dr.getInt(7);
            groupSubSupplement.option_free = dr.getInt(8);
            groupSubSupplement.number_click = dr.getInt(9);
            groupSubSupplement.id_global = dr.getString(10);
            return groupSubSupplement;
        };
    }

    public String toString() {
        return this.name_group;
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public int getNumber_click() {
        return this.number_click;
    }

    public void setNumber_click(int number_click) {
        this.number_click = number_click;
    }

    public List<MultiLanguageGSS> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageGSS> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getDisplayedName() {
        return this.getNameByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getDisplayedTitle() {
        return this.getTitleByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageGSS multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.name_group;
        }
        return nameByLanguage;
    }

    public String getTitleByLanguage(String code_language) {
        String titleByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageGSS multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                titleByLanguage = multiLanguageText.getTitle_group();
                break;
            }
        }
        if (titleByLanguage == null || titleByLanguage.isEmpty()) {
            titleByLanguage = this.title_group;
        }
        return titleByLanguage;
    }
}

