/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;

public class CustomerLoyalty
implements Cloneable {
    private String phone;
    private double cagnote;
    private double used_points;
    private boolean actif;
    private String birthdate;
    private String gender;
    private double earned_points;

    public CustomerLoyalty(String phone, double cagnote, boolean actif, String gender) {
        this.phone = phone;
        this.cagnote = cagnote;
        this.actif = actif;
        this.gender = gender;
        this.used_points = 0.0;
        this.earned_points = 0.0;
    }

    public CustomerLoyalty(String phone, String gender, String birthdate) {
        this.phone = phone;
        this.gender = gender;
        this.birthdate = birthdate;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public double getCagnote() {
        return this.cagnote;
    }

    public void setCagnote(double cagnote) {
        this.cagnote = cagnote;
    }

    public double getUsed_points() {
        return this.used_points;
    }

    public void setUsed_points(double used_points) {
        this.used_points = used_points;
    }

    public double getEarned_points() {
        return this.earned_points;
    }

    public void setEarned_points(double earned_points) {
        this.earned_points = earned_points;
    }

    public double getPoints() {
        return this.cagnote - this.used_points + this.earned_points;
    }

    public boolean isActif() {
        return this.actif;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String printPoints(String separator) {
        double points = this.getPoints();
        StringBuilder textPointBuilder = new StringBuilder();
        if (AppLocal.APP_LANGUAGE != null && AppLocal.APP_LANGUAGE.equals("ar")) {
            textPointBuilder.append(AppLocal.getIntString("Label.cagnotte"));
            textPointBuilder.append(" :");
            textPointBuilder.append(separator);
            textPointBuilder.append(Formats.INT.formatValue(points));
            textPointBuilder.append(" ");
            textPointBuilder.append(AppLocal.getIntString("Text.point"));
        } else {
            String textPoints = points > 1.0 ? AppLocal.getIntString("Text.points") : AppLocal.getIntString("Text.point");
            textPointBuilder.append(" ");
            textPointBuilder.append(AppLocal.getIntString("Label.cagnotte"));
            textPointBuilder.append(separator);
            textPointBuilder.append(Formats.INT.formatValue(points));
            textPointBuilder.append(" ");
            textPointBuilder.append(textPoints);
            textPointBuilder.append(" ");
        }
        return textPointBuilder.toString();
    }

    public String printPoints() {
        return this.printPoints(" ");
    }

    public Object clone() {
        try {
            CustomerLoyalty o = null;
            o = (CustomerLoyalty)super.clone();
            return o;
        }
        catch (CloneNotSupportedException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }
}

