/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CategoryDayAvailable;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ShiftCategory;
import com.openbravo.pos.util.StringUtils;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CategoryInfo
implements IKeyed,
Cloneable {
    private static final long serialVersionUID = 8612449444103L;
    private int importedID;
    private int m_sID;
    private String m_sName;
    private String m_sTextTip;
    private BufferedImage m_Image;
    private String path;
    private Boolean m_bCatShowName;
    private String color;
    private int ordercategory;
    private List<ProductInfoExt> products;
    private String ref_web;
    private boolean removed;
    private boolean hidden;
    private String taxEMP;
    private String taxLV;
    private String taxSP;
    private boolean apply_discount;
    private List<ProductInfoExt> products_sp;
    private List<ProductInfoExt> products_emp;
    private List<ProductInfoExt> products_lv;
    private List<ProductInfoExt> products_bar;
    private List<ProductInfoExt> products_terasse;
    private List<ProductInfoExt> products_happy_hour;
    private boolean hidden_borne;
    private boolean hidden_caisse;
    private List<CategoryInfo> sub_categories;
    private int parent_id;
    private boolean moment_category;
    private boolean removed_by_admin;
    private boolean synchronized_category;
    private boolean raw_material;
    private int printer_id;
    private int printer_label_id;
    private CategoryInfo parentCategory;
    private boolean products_first;
    private boolean sold_out;
    private boolean next_available;
    private boolean has_display_time;
    private int first_period;
    private int end_period;
    private boolean available_caisse;
    private boolean hidden_ubereat;
    private boolean hide_name_in_borne;
    private boolean category_ubereat;
    private boolean hidden_online;
    private boolean has_produts_with_points;
    private boolean show_ubereat;
    private List<TagInfo> tags;
    private boolean show_on;
    private int offset_print_kitchen;
    private String path_category_moment;
    private String type_image_category_moment;
    private String id_global;
    private String parent_id_global;
    private List<CategoryDayAvailable> daysOn;
    private boolean has_timetable;
    private List<ShiftCategory> shiftsCategory;
    private Date dateStartDisplay;
    private Date dateEndDisplay;
    private String imageUrl;
    private List<MultiLanguageCategory> multiLanguageTexts;
    private boolean sold_out_group_products;

    public CategoryInfo(int id, String name, BufferedImage image, String texttip, Boolean catshowname) {
        this.m_sID = id;
        this.m_sName = name;
        this.m_Image = image;
        this.m_sTextTip = texttip;
        this.m_bCatShowName = catshowname;
        this.products = new ArrayList<ProductInfoExt>();
        this.products_sp = new ArrayList<ProductInfoExt>();
        this.products_emp = new ArrayList<ProductInfoExt>();
        this.products_lv = new ArrayList<ProductInfoExt>();
        this.products_bar = new ArrayList<ProductInfoExt>();
        this.products_terasse = new ArrayList<ProductInfoExt>();
        this.products_happy_hour = new ArrayList<ProductInfoExt>();
        this.sub_categories = new ArrayList<CategoryInfo>();
        this.synchronized_category = false;
        this.tags = new ArrayList<TagInfo>();
        this.daysOn = new ArrayList<CategoryDayAvailable>();
        this.shiftsCategory = new ArrayList<ShiftCategory>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
    }

    public CategoryInfo(int m_sID, String m_sName, int ordercategory) {
        this.m_sID = m_sID;
        this.m_sName = m_sName;
        this.ordercategory = ordercategory;
        this.products = new ArrayList<ProductInfoExt>();
        this.products = new ArrayList<ProductInfoExt>();
        this.products_sp = new ArrayList<ProductInfoExt>();
        this.products_emp = new ArrayList<ProductInfoExt>();
        this.products_lv = new ArrayList<ProductInfoExt>();
        this.products_bar = new ArrayList<ProductInfoExt>();
        this.products_terasse = new ArrayList<ProductInfoExt>();
        this.products_happy_hour = new ArrayList<ProductInfoExt>();
        this.sub_categories = new ArrayList<CategoryInfo>();
        this.synchronized_category = false;
        this.tags = new ArrayList<TagInfo>();
        this.daysOn = new ArrayList<CategoryDayAvailable>();
        this.shiftsCategory = new ArrayList<ShiftCategory>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
    }

    public CategoryInfo(int m_sID, String m_sName, int ordercategory, String color, boolean removed, boolean hidden, boolean apply_discount, String path) {
        this.m_sID = m_sID;
        this.m_sName = m_sName;
        this.ordercategory = ordercategory;
        this.color = color;
        this.removed = removed;
        this.hidden = hidden;
        this.apply_discount = apply_discount;
        this.path = path;
        this.products = new ArrayList<ProductInfoExt>();
        this.products = new ArrayList<ProductInfoExt>();
        this.products_sp = new ArrayList<ProductInfoExt>();
        this.products_emp = new ArrayList<ProductInfoExt>();
        this.products_lv = new ArrayList<ProductInfoExt>();
        this.products_bar = new ArrayList<ProductInfoExt>();
        this.products_terasse = new ArrayList<ProductInfoExt>();
        this.products_happy_hour = new ArrayList<ProductInfoExt>();
        this.sub_categories = new ArrayList<CategoryInfo>();
        this.synchronized_category = false;
        this.tags = new ArrayList<TagInfo>();
        this.daysOn = new ArrayList<CategoryDayAvailable>();
        this.shiftsCategory = new ArrayList<ShiftCategory>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
    }

    public CategoryInfo() {
        this.products = new ArrayList<ProductInfoExt>();
        this.products_sp = new ArrayList<ProductInfoExt>();
        this.products_emp = new ArrayList<ProductInfoExt>();
        this.products_lv = new ArrayList<ProductInfoExt>();
        this.products_bar = new ArrayList<ProductInfoExt>();
        this.products_terasse = new ArrayList<ProductInfoExt>();
        this.products_happy_hour = new ArrayList<ProductInfoExt>();
        this.sub_categories = new ArrayList<CategoryInfo>();
        this.synchronized_category = false;
        this.has_produts_with_points = false;
        this.tags = new ArrayList<TagInfo>();
        this.daysOn = new ArrayList<CategoryDayAvailable>();
        this.shiftsCategory = new ArrayList<ShiftCategory>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
    }

    public String getCategorieAsString() {
        return this.m_sID + "," + this.m_sName + "," + this.m_sTextTip + "," + this.path + "," + this.m_bCatShowName + "," + (this.color == null ? null : (this.color.startsWith("#") ? this.color : StringUtils.rGB2Hex(this.color))) + "," + this.ordercategory + "," + this.parent_id;
    }

    public CategoryInfo(String categorieLine) {
        String[] columns = categorieLine.replace(",null,", ",,").replace("null,", ",").replace(",null", ",").split(",");
        this.importedID = Integer.valueOf(columns[0]);
        this.m_sName = columns[1];
        this.m_sTextTip = columns[2];
        this.path = columns[3].isEmpty() ? null : columns[3];
        this.m_bCatShowName = Boolean.valueOf(columns[4]);
        this.color = !columns[5].isEmpty() ? StringUtils.hex2Rgb(columns[5]) : null;
        this.ordercategory = Integer.valueOf(columns[6]);
        this.parent_id = columns.length >= 8 ? Integer.valueOf(columns[7]) : -1;
        this.products = new ArrayList<ProductInfoExt>();
        this.products_sp = new ArrayList<ProductInfoExt>();
        this.products_emp = new ArrayList<ProductInfoExt>();
        this.products_lv = new ArrayList<ProductInfoExt>();
        this.products_bar = new ArrayList<ProductInfoExt>();
        this.products_terasse = new ArrayList<ProductInfoExt>();
        this.products_happy_hour = new ArrayList<ProductInfoExt>();
        this.sub_categories = new ArrayList<CategoryInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
    }

    @Override
    public Object getKey() {
        return this.m_sID;
    }

    public void setID(int sID) {
        this.m_sID = sID;
    }

    public int getID() {
        return this.m_sID;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getTextTip() {
        return this.m_sTextTip;
    }

    public void setTextTip(String sName) {
        this.m_sTextTip = sName;
    }

    public Boolean getCatShowName() {
        return this.m_bCatShowName;
    }

    public void setCatShowName(Boolean bcatshowname) {
        this.m_bCatShowName = bcatshowname;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getOrdercategory() {
        return this.ordercategory;
    }

    public void setOrdercategory(int ordercategory) {
        this.ordercategory = ordercategory;
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }

    public void setImage(BufferedImage img) {
        this.m_Image = img;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getTaxEMP() {
        return this.taxEMP;
    }

    public void setTaxEMP(String taxEMP) {
        this.taxEMP = taxEMP;
    }

    public String getTaxLV() {
        return this.taxLV;
    }

    public void setTaxLV(String taxLV) {
        this.taxLV = taxLV;
    }

    public String getTaxSP() {
        return this.taxSP;
    }

    public void setTaxSP(String taxSP) {
        this.taxSP = taxSP;
    }

    public boolean isApply_discount() {
        return this.apply_discount;
    }

    public void setApply_discount(boolean apply_discount) {
        this.apply_discount = apply_discount;
    }

    public String toString() {
        String name = this.show_ubereat && this.category_ubereat ? this.m_sName + " ( Ubereats )" : this.m_sName;
        return name;
    }

    public String getEntetOfCSV() {
        return "ID,Name,TextTip,  path,CatShowName, color, ordercategory";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CategoryInfo category = new CategoryInfo();
                category.m_sID = dr.getInt(1);
                category.m_sName = dr.getString(2);
                category.path = dr.getString(3);
                category.m_sTextTip = dr.getString(4);
                category.m_bCatShowName = dr.getBoolean(5);
                category.color = dr.getString(6);
                category.ordercategory = dr.getInt(7);
                category.ref_web = dr.getString(8);
                category.removed = dr.getBoolean(9);
                category.hidden = dr.getBoolean(10);
                category.taxEMP = dr.getString(11);
                category.taxLV = dr.getString(12);
                category.taxSP = dr.getString(13);
                category.apply_discount = dr.getBoolean(14);
                category.hidden_borne = dr.getBoolean(15);
                category.hidden_caisse = dr.getBoolean(16);
                category.parent_id = dr.getInt(17);
                category.moment_category = dr.getBoolean(18);
                category.removed_by_admin = dr.getBoolean(19);
                category.raw_material = dr.getBoolean(20);
                category.printer_id = dr.getInt(21);
                category.printer_label_id = dr.getInt(22);
                category.sold_out = dr.getBoolean(23);
                category.products_first = dr.getBoolean(24);
                category.next_available = dr.getBoolean(25);
                category.has_display_time = dr.getBoolean(26);
                category.first_period = dr.getInt(27);
                category.end_period = dr.getInt(28);
                category.available_caisse = dr.getBoolean(29);
                category.hidden_ubereat = dr.getBoolean(30);
                category.hide_name_in_borne = dr.getBoolean(31);
                category.hidden_online = dr.getBoolean(32);
                category.category_ubereat = dr.getBoolean(33);
                category.offset_print_kitchen = dr.getInt(34);
                category.path_category_moment = dr.getString(35);
                category.type_image_category_moment = dr.getString(36);
                category.id_global = dr.getString(37);
                category.has_timetable = dr.getBoolean(38);
                category.dateStartDisplay = dr.getTimestamp(39);
                category.dateEndDisplay = dr.getTimestamp(40);
                category.imageUrl = dr.getString(41);
                category.products = new ArrayList<ProductInfoExt>();
                category.products_sp = new ArrayList<ProductInfoExt>();
                category.products_emp = new ArrayList<ProductInfoExt>();
                category.products_lv = new ArrayList<ProductInfoExt>();
                category.products_bar = new ArrayList<ProductInfoExt>();
                category.products_terasse = new ArrayList<ProductInfoExt>();
                category.products_happy_hour = new ArrayList<ProductInfoExt>();
                category.m_sName = category.m_sName != null && !category.m_sName.isEmpty() ? org.apache.commons.lang3.StringUtils.capitalize((String)category.m_sName.toLowerCase()) : category.m_sName;
                return category;
            }
        };
    }

    public int getImportedID() {
        return this.importedID;
    }

    public void setImportedID(int importedID) {
        this.importedID = importedID;
    }

    public List<ProductInfoExt> getProducts() {
        return this.products;
    }

    public void setProducts(List<ProductInfoExt> products) {
        this.products = products;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public List<ProductInfoExt> getProducts_sp() {
        return this.products_sp;
    }

    public void setProducts_sp(List<ProductInfoExt> products_sp) {
        this.products_sp = products_sp;
    }

    public List<ProductInfoExt> getProducts_emp() {
        return this.products_emp;
    }

    public void setProducts_emp(List<ProductInfoExt> products_emp) {
        this.products_emp = products_emp;
    }

    public List<ProductInfoExt> getProducts_lv() {
        return this.products_lv;
    }

    public void setProducts_lv(List<ProductInfoExt> products_lv) {
        this.products_lv = products_lv;
    }

    public List<ProductInfoExt> getProducts_bar() {
        return this.products_bar;
    }

    public void setProducts_bar(List<ProductInfoExt> products_bar) {
        this.products_bar = products_bar;
    }

    public List<ProductInfoExt> getProducts_terasse() {
        return this.products_terasse;
    }

    public void setProducts_terasse(List<ProductInfoExt> products_terasse) {
        this.products_terasse = products_terasse;
    }

    public List<ProductInfoExt> getProducts_happy_hour() {
        return this.products_happy_hour;
    }

    public void setProducts_happy_hour(List<ProductInfoExt> products_happy_hour) {
        this.products_happy_hour = products_happy_hour;
    }

    public boolean isHidden_borne() {
        return this.hidden_borne;
    }

    public void setHidden_borne(boolean hidden_borne) {
        this.hidden_borne = hidden_borne;
    }

    public boolean isHidden_caisse() {
        return this.hidden_caisse;
    }

    public void setHidden_caisse(boolean hidden_caisse) {
        this.hidden_caisse = hidden_caisse;
    }

    public List<CategoryInfo> getSub_categories() {
        return this.sub_categories;
    }

    public void setSub_categories(List<CategoryInfo> sub_categories) {
        this.sub_categories = sub_categories;
    }

    public int getParent_id() {
        return this.parent_id;
    }

    public void setParent_id(int parent_id) {
        this.parent_id = parent_id;
    }

    public boolean isMoment_category() {
        return this.moment_category;
    }

    public void setMoment_category(boolean moment_category) {
        this.moment_category = moment_category;
    }

    public boolean isRemoved_by_admin() {
        return this.removed_by_admin;
    }

    public void setRemoved_by_admin(boolean removed_by_admin) {
        this.removed_by_admin = removed_by_admin;
    }

    public boolean isSynchronized_category() {
        return this.synchronized_category;
    }

    public void setSynchronized_category(boolean synchronized_category) {
        this.synchronized_category = synchronized_category;
    }

    public boolean isRaw_material() {
        return this.raw_material;
    }

    public void setRaw_material(boolean raw_material) {
        this.raw_material = raw_material;
    }

    public int getPrinter_id() {
        return this.printer_id;
    }

    public void setPrinter_id(int printer_id) {
        this.printer_id = printer_id;
    }

    public int getPrinter_label_id() {
        return this.printer_label_id;
    }

    public void setPrinter_label_id(int printer_label_id) {
        this.printer_label_id = printer_label_id;
    }

    public CategoryInfo getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(CategoryInfo parentCategory) {
        this.parentCategory = parentCategory;
    }

    public boolean isProducts_first() {
        return this.products_first;
    }

    public void setProducts_first(boolean products_first) {
        this.products_first = products_first;
    }

    public Object clone() {
        CategoryInfo o = null;
        try {
            int i;
            o = (CategoryInfo)super.clone();
            if (this.products != null) {
                o.products = new ArrayList<ProductInfoExt>();
                for (i = 0; i < this.products.size(); ++i) {
                    o.products.add((ProductInfoExt)this.products.get(i).clone());
                }
            } else {
                o.products = null;
            }
            if (this.sub_categories != null) {
                o.sub_categories = new ArrayList<CategoryInfo>();
                for (i = 0; i < this.sub_categories.size(); ++i) {
                    o.sub_categories.add((CategoryInfo)this.sub_categories.get(i).clone());
                }
            } else {
                o.sub_categories = null;
            }
            if (this.tags != null) {
                o.tags = new ArrayList<TagInfo>();
                for (i = 0; i < this.tags.size(); ++i) {
                    o.tags.add((TagInfo)this.tags.get(i).clone());
                }
            } else {
                o.tags = null;
            }
            if (this.multiLanguageTexts != null) {
                o.multiLanguageTexts = new ArrayList<MultiLanguageCategory>();
                for (i = 0; i < this.multiLanguageTexts.size(); ++i) {
                    o.multiLanguageTexts.add((MultiLanguageCategory)this.multiLanguageTexts.get(i).clone());
                }
            } else {
                o.multiLanguageTexts = null;
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            cnse.printStackTrace(System.err);
        }
        return o;
    }

    public boolean isSold_out() {
        return this.sold_out;
    }

    public void setSold_out(boolean sold_out) {
        this.sold_out = sold_out;
    }

    public boolean isNext_available() {
        return this.next_available;
    }

    public void setNext_available(boolean next_available) {
        this.next_available = next_available;
    }

    public boolean isHas_display_time() {
        return this.has_display_time;
    }

    public void setHas_display_time(boolean has_display_time) {
        this.has_display_time = has_display_time;
    }

    public int getFirst_period() {
        return this.first_period;
    }

    public void setFirst_period(int first_period) {
        this.first_period = first_period;
    }

    public int getEnd_period() {
        return this.end_period;
    }

    public void setEnd_period(int end_period) {
        this.end_period = end_period;
    }

    public boolean isAvailable_caisse() {
        return this.available_caisse;
    }

    public void setAvailable_caisse(boolean available_caisse) {
        this.available_caisse = available_caisse;
    }

    public boolean isHidden_ubereat() {
        return this.hidden_ubereat;
    }

    public void setHidden_ubereat(boolean hidden_ubereat) {
        this.hidden_ubereat = hidden_ubereat;
    }

    public boolean isHide_name_in_borne() {
        return this.hide_name_in_borne;
    }

    public void setHide_name_in_borne(boolean hide_name_in_borne) {
        this.hide_name_in_borne = hide_name_in_borne;
    }

    public boolean isCategory_ubereat() {
        return this.category_ubereat;
    }

    public void setCategory_ubereat(boolean category_ubereat) {
        this.category_ubereat = category_ubereat;
    }

    public boolean isHidden_online() {
        return this.hidden_online;
    }

    public void setHidden_online(boolean hidden_online) {
        this.hidden_online = hidden_online;
    }

    public boolean isHas_produts_with_points() {
        return this.has_produts_with_points;
    }

    public void setHas_produts_with_points(boolean had_produts_with_points) {
        this.has_produts_with_points = had_produts_with_points;
    }

    public boolean isShow_ubereat() {
        return this.show_ubereat;
    }

    public void setShow_ubereat(boolean show_ubereat) {
        this.show_ubereat = show_ubereat;
    }

    public List<TagInfo> getTags() {
        return this.tags;
    }

    public void setTags(List<TagInfo> tags) {
        this.tags = tags;
    }

    public boolean isShow_on() {
        return this.show_on;
    }

    public void setShow_on(boolean show_on) {
        this.show_on = show_on;
    }

    public int getOffset_print_kitchen() {
        return this.offset_print_kitchen;
    }

    public void setOffset_print_kitchen(int offset_print_kitchen) {
        this.offset_print_kitchen = offset_print_kitchen;
    }

    public String getPath_category_moment() {
        return this.path_category_moment;
    }

    public void setPath_category_moment(String path_category_moment) {
        this.path_category_moment = path_category_moment;
    }

    public String getType_image_category_moment() {
        return this.type_image_category_moment;
    }

    public void setType_image_category_moment(String type_image_category_moment) {
        this.type_image_category_moment = type_image_category_moment;
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public String getParent_id_global() {
        return this.parent_id_global;
    }

    public void setParent_id_global(String parent_id_global) {
        this.parent_id_global = parent_id_global;
    }

    public void setDaysOn(List<CategoryDayAvailable> daysOn) {
        this.daysOn = daysOn;
    }

    public List<CategoryDayAvailable> getDaysOn() {
        return this.daysOn;
    }

    public boolean isHas_timetable() {
        return this.has_timetable;
    }

    public void setHas_timetable(boolean has_timetable) {
        this.has_timetable = has_timetable;
    }

    public List<ShiftCategory> getShiftsCategory() {
        return this.shiftsCategory;
    }

    public void setShiftsCategory(List<ShiftCategory> shiftsCategory) {
        this.shiftsCategory = shiftsCategory;
    }

    public Date getDateStartDisplay() {
        return this.dateStartDisplay;
    }

    public void setDateStartDisplay(Date dateStartDisplay) {
        this.dateStartDisplay = dateStartDisplay;
    }

    public Date getDateEndDisplay() {
        return this.dateEndDisplay;
    }

    public void setDateEndDisplay(Date dateEndDisplay) {
        this.dateEndDisplay = dateEndDisplay;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public List<MultiLanguageCategory> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageCategory> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getDisplayedName() {
        return this.getNameByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageCategory multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.m_sName;
        }
        return nameByLanguage;
    }

    public boolean isSold_out_group_products() {
        return this.sold_out_group_products;
    }

    public void setSold_out_group_products(boolean sold_out_group_products) {
        this.sold_out_group_products = sold_out_group_products;
    }
}

