/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.MultiLanguageCarte;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CarteOrderInfo
implements IKeyed,
Cloneable {
    private int id;
    private String name;
    private int orderCarte;
    private int number_carte;
    private int index_carte;
    private String sizeCarte;
    private String ref_web;
    private List<ProductInfoExt> items;
    private String id_global;
    private List<MultiLanguageCarte> multiLanguageTexts;

    public CarteOrderInfo() {
    }

    public CarteOrderInfo(int id, String name, String sizeCarte, int orderCarte, int number_carte, String ref_web) {
        this.id = id;
        this.name = name;
        this.sizeCarte = sizeCarte;
        this.orderCarte = orderCarte;
        this.number_carte = number_carte;
        this.ref_web = ref_web;
    }

    public CarteOrderInfo(int id, String name, String sizeCarte, int orderCarte, int number_carte) {
        this.id = id;
        this.name = name;
        this.sizeCarte = sizeCarte;
        this.orderCarte = orderCarte;
        this.number_carte = number_carte;
    }

    public CarteOrderInfo(String name, int orderCarte, int number_carte) {
        this.name = name;
        this.orderCarte = orderCarte;
        this.number_carte = number_carte;
    }

    public CarteOrderInfo(int id, String name, int number_carte) {
        this.id = id;
        this.name = name;
        this.number_carte = number_carte;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderCarte() {
        return this.orderCarte;
    }

    public void setOrderCarte(int orderCarte) {
        this.orderCarte = orderCarte;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public int getNumber_carte() {
        return this.number_carte;
    }

    public void setNumber_carte(int number_carte) {
        this.number_carte = number_carte;
    }

    public int getIndex_carte() {
        return this.index_carte;
    }

    public void setIndex_carte(int index_carte) {
        this.index_carte = index_carte;
    }

    public String getSizeCarte() {
        return this.sizeCarte;
    }

    public void setSizeCarte(String sizeCarte) {
        this.sizeCarte = sizeCarte;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public List<ProductInfoExt> getItems() {
        return this.items;
    }

    public void setItems(List<ProductInfoExt> items) {
        this.items = items;
    }

    public String toString() {
        return this.name;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CarteOrderInfo carteOrderInfo = new CarteOrderInfo();
                carteOrderInfo.id = dr.getInt(1);
                carteOrderInfo.name = dr.getString(2);
                carteOrderInfo.sizeCarte = dr.getString(3);
                carteOrderInfo.orderCarte = dr.getInt(4);
                carteOrderInfo.number_carte = dr.getInt(5);
                carteOrderInfo.ref_web = dr.getString(6);
                carteOrderInfo.id_global = dr.getString(7);
                carteOrderInfo.name = carteOrderInfo.name != null && !carteOrderInfo.name.isEmpty() ? StringUtils.capitalize((String)carteOrderInfo.name.toLowerCase()) : carteOrderInfo.name;
                return carteOrderInfo;
            }
        };
    }

    public Object clone() {
        CarteOrderInfo o = null;
        try {
            o = (CarteOrderInfo)super.clone();
            if (this.items != null) {
                o.items = new ArrayList<ProductInfoExt>();
                for (int i = 0; i < this.items.size(); ++i) {
                    o.items.add((ProductInfoExt)this.items.get(i).clone());
                }
            } else {
                o.items = null;
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            cnse.printStackTrace(System.err);
        }
        return o;
    }

    public String getKeyComposed() {
        StringBuilder key_plat = new StringBuilder();
        key_plat.append(String.valueOf(this.id)).append(String.valueOf(this.index_carte));
        return key_plat.toString();
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public List<MultiLanguageCarte> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageCarte> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getDisplayedName() {
        return this.getNameByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageCarte multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.name;
        }
        return nameByLanguage;
    }
}

