/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.procaisse.db.metadata.DataRead;

public class CarteItemInfo
implements IKeyed {
    private int id_carte;
    private int id_item;
    private String ref_item;
    private double price;
    private String id_global_carte;
    private String id_global_item;
    private int order_item;

    public CarteItemInfo() {
    }

    public CarteItemInfo(int id_carte, int id_item, double price) {
        this.id_carte = id_carte;
        this.id_item = id_item;
        this.price = price;
    }

    public CarteItemInfo(int id_carte, String ref_item, double price) {
        this.id_carte = id_carte;
        this.ref_item = ref_item;
        this.price = price;
    }

    public CarteItemInfo(String carteItemLine) {
        String[] columns = carteItemLine.replace(",null,", ",,").replace("null,", ",").replace(",null", ",").split(",");
        this.id_carte = Integer.valueOf(columns[0]);
        this.id_item = Integer.valueOf(columns[1]);
        this.price = Double.valueOf(columns[2]);
    }

    public int getId_carte() {
        return this.id_carte;
    }

    public void setId_carte(int id_carte) {
        this.id_carte = id_carte;
    }

    public int getId_item() {
        return this.id_item;
    }

    public void setId_item(int id_item) {
        this.id_item = id_item;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getRef_item() {
        return this.ref_item;
    }

    public void setRef_item(String ref_item) {
        this.ref_item = ref_item;
    }

    @Override
    public Object getKey() {
        return this.id_carte;
    }

    public String toString() {
        return this.id_carte + " " + this.id_item;
    }

    public String getEntetOfCSV() {
        return "id_carte, id_item, price";
    }

    public String getCartesItemsAsString() {
        return this.id_carte + "," + this.id_item + "," + this.price;
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CarteItemInfo carteItemInfo = new CarteItemInfo();
                carteItemInfo.id_carte = dr.getInt(1);
                carteItemInfo.id_item = dr.getInt(2);
                carteItemInfo.price = dr.getDouble(3);
                carteItemInfo.id_global_item = dr.getString(4);
                carteItemInfo.order_item = dr.getInt(5);
                return carteItemInfo;
            }
        };
    }

    public String getId_global_carte() {
        return this.id_global_carte;
    }

    public void setId_global_carte(String id_global_carte) {
        this.id_global_carte = id_global_carte;
    }

    public String getId_global_item() {
        return this.id_global_item;
    }

    public void setId_global_item(String id_global_item) {
        this.id_global_item = id_global_item;
    }

    public int getOrder_item() {
        return this.order_item;
    }

    public void setOrder_item(int order_item) {
        this.order_item = order_item;
    }
}

