/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.ticket;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.IKeyed;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.procaisse.db.metadata.DataRead;
import fr.protactile.procaisse.dao.entities.MultiLanguageCarte;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CarteInfo
implements IKeyed {
    private int id;
    private int importedId;
    private String name;
    private String sizeCarte;
    private boolean removed;
    private List<CarteItemInfo> carteItems;
    private String ref_web;
    private boolean removed_by_admin;
    private String id_global;
    private List<MultiLanguageCarte> multiLanguageTexts;

    public CarteInfo() {
        this.carteItems = new ArrayList<CarteItemInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCarte>();
    }

    public CarteInfo(int id, String name, String sizeCarte, boolean removed, String ref_web, boolean removed_by_admin) {
        this.id = id;
        this.name = name;
        this.sizeCarte = sizeCarte;
        this.removed = removed;
        this.ref_web = ref_web;
        this.removed_by_admin = removed_by_admin;
        this.carteItems = new ArrayList<CarteItemInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCarte>();
    }

    public CarteInfo(int id, String name) {
        this.id = id;
        this.name = name;
        this.carteItems = new ArrayList<CarteItemInfo>();
        this.multiLanguageTexts = new ArrayList<MultiLanguageCarte>();
    }

    public CarteInfo(String cartLine) {
        String[] column = cartLine.replace(",null,", ",,").replace("null,", ",").replace(",null", ",").split(",");
        this.importedId = Integer.valueOf(column[0]);
        this.name = column[1];
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSizeCarte() {
        return this.sizeCarte;
    }

    public void setSizeCarte(String sizeCarte) {
        this.sizeCarte = sizeCarte;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public String getCarteAsString() {
        return this.id + "," + this.name;
    }

    public String getEntetOfCSV() {
        return "id, name";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                CarteInfo carteInfo = new CarteInfo();
                carteInfo.id = dr.getInt(1);
                carteInfo.name = dr.getString(2);
                carteInfo.sizeCarte = dr.getString(3);
                carteInfo.removed = dr.getBoolean(4);
                carteInfo.ref_web = dr.getString(5);
                carteInfo.removed_by_admin = dr.getBoolean(6);
                carteInfo.id_global = dr.getString(7);
                carteInfo.name = carteInfo.name != null && !carteInfo.name.isEmpty() ? StringUtils.capitalize((String)carteInfo.name.toLowerCase()) : carteInfo.name;
                return carteInfo;
            }
        };
    }

    public int getImportedId() {
        return this.importedId;
    }

    public void setImportedId(int importedId) {
        this.importedId = importedId;
    }

    public List<CarteItemInfo> getCarteItems() {
        return this.carteItems;
    }

    public void setCarteItems(List<CarteItemInfo> carteItems) {
        this.carteItems = carteItems;
    }

    public String getRef_web() {
        return this.ref_web;
    }

    public void setRef_web(String ref_web) {
        this.ref_web = ref_web;
    }

    public boolean isRemoved_by_admin() {
        return this.removed_by_admin;
    }

    public void setRemoved_by_admin(boolean removed_by_admin) {
        this.removed_by_admin = removed_by_admin;
    }

    public String getId_global() {
        return this.id_global;
    }

    public void setId_global(String id_global) {
        this.id_global = id_global;
    }

    public List<MultiLanguageCarte> getMultiLanguageTexts() {
        return this.multiLanguageTexts;
    }

    public void setMultiLanguageTexts(List<MultiLanguageCarte> multiLanguageTexts) {
        this.multiLanguageTexts = multiLanguageTexts;
    }

    public String getDisplayedName() {
        return this.getNameByLanguage(AppLocal.APP_LANGUAGE);
    }

    public String getNameByLanguage(String code_language) {
        String nameByLanguage = "";
        if (this.multiLanguageTexts != null && this.multiLanguageTexts.size() > 0 && code_language != null && !code_language.isEmpty()) {
            for (MultiLanguageCarte multiLanguageText : this.multiLanguageTexts) {
                if (!code_language.equalsIgnoreCase(multiLanguageText.getLanguage())) continue;
                nameByLanguage = multiLanguageText.getName();
                break;
            }
        }
        if (nameByLanguage == null || nameByLanguage.isEmpty()) {
            nameByLanguage = this.name;
        }
        return nameByLanguage;
    }
}

