/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.format.Formats;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankProductDiver;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.sales.DateLabelFormatter;
import com.openbravo.pos.sales.ExportZFileHelper;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.IntegerDateInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.MonthInfo;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.TurnoverInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.ZGlobalInfoDTO;
import fr.protactile.procaisse.dao.entities.ZHostNameDTO;
import fr.protactile.procaisse.orders.export.ExportGeneratorHelper;
import fr.protactile.procaisse.orders.export.ExportTurnoverExcel;
import fr.protactile.procaisse.orders.export.IZDetail;
import fr.protactile.procaisse.orders.export.ZDayDetail;
import fr.protactile.procaisse.orders.export.ZGlobalDetail;
import fr.protactile.procaisse.orders.export.ZMonthDetail;
import fr.protactile.procaisse.services.ZGlobalService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.jdatepicker.DateModel;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class JXCaisse
extends JDialog {
    private AppView app;
    protected DataLogicSales dlSales;
    protected DataLogicStats dlStats;
    protected DefaultTableModel modelOrder;
    private final SimpleDateFormat dateFullFormatter = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDAY_MONTH_YEAR_SLASHES;
    private final SimpleDateFormat dateFormatterInversed = DateUtils.SDF_YYYYMMDD;
    private static final Dimension DIMENSION_PANEL = new Dimension(1200, 500);
    private List<TicketInfo> orders;
    private TicketInfo currentOrder;
    protected List<PrinterInfo> printers;
    private MarqueNFC marqueNF;
    List<TicketLineInfo> productToSend;
    private JFlowPanel panelClose;
    JScrollPane scroll;
    private JLabel labelTitle;
    private JLabel labelFond;
    private JLabel modeTitle;
    private JLabel encaissementTile;
    private JLabel tiroirTitle;
    private JPanel titlePayment;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;
    private JSeparator separator4;
    private JSeparator separator5;
    private CaisseInfo caisse;
    private List<PaymentLine> payments;
    private List<TicketInfo> tickets;
    private List<TaxeLine> taxes;
    private List<TaxeLine> allTaxes;
    private Integer m_iSales;
    private double nbproduct;
    private double nbProductDiver;
    private double allProduct;
    private PaymentsModel m_PaymentsCaisse;
    private double turnoverHT;
    private List<UserCaisseInfo> users;
    private double totalTaxes;
    private double turnover;
    private double caCanceled;
    private static CaisseZ caisseZ;
    private int month;
    private int year;
    private int day;
    private Date currentDate;
    private Date dateStart;
    private Date dateEnd;
    private PaymentLine paymentCash;
    private PaymentLine paymentEspece;
    private List<MonthInfo> listMonths;
    private List<HourInfo> salesByHour;
    private List<IntegerDateInfo> salesByDay;
    private List<TurnoverInfo> salesByUnit = new ArrayList<TurnoverInfo>();
    private static GrandTotalPeriode grandTotalPeriode;
    private boolean firstTime;
    private String xType;
    private String unit;
    private String title;
    private DataLogicAdmin dlUser;
    private String mDialogTitle = "Impression";
    private JPanel paneDate;
    private JDatePickerImpl datePicker;
    private double totalDiscount;
    private double totalDiscountOnLines;
    private List<RankTypeOrder> dataTypeOrders;
    private TicketSharedService mTicketSharedService;
    private static ZGlobalInfoDTO currentperiodeGlobal;
    private ZGlobalService mZGlobalService;
    private String period_value;
    private static List<String> equipements_address;
    private double turnover_deliveroo;
    private String RAPPORT_TITLE_Z_GLOBAL = " Z Global ";
    private double total_ht_taxable = 0.0;
    private double total_ht_no_taxable = 0.0;
    private List<GroupedTax> groupedTaxes;
    private double turnover_ubereat;
    private List<TicketInfo> ordersCanceled;
    private List<TicketInfo> notesCanceled;
    private List<RankTypeOrder> dataTypePlatformOrders;
    private JCheckBox checkCanceled;
    private JCheckBox checkRefund;
    private JCheckBox checkSales;
    private JButton jBtnExportTurnoverExcel;
    private JButton jBtnPrint;
    private JButton jBtnPrintOperations;
    private JButton jBtnPrintPayments;
    private JButton jBtnPrintSynthese;
    private JButton jBtnZCaisse;
    private JComboBox<MonthInfo> jComboMonth;
    private JComboBox<Integer> jComboYear;
    private JPanel jPanelFirst;
    private JPanel jPanelPrint;
    private JPanel paneMonth;

    private JXCaisse(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JXCaisse(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private void init(AppView app, final CaisseZ caisseZ, String typeX, ZGlobalInfoDTO periodeGlobal) throws BasicException {
        this.initComponents();
        this.jBtnPrintOperations.setText(this.getHtmlTitle("le journal des op\u00e9rations"));
        this.jBtnPrintPayments.setText(this.getHtmlTitle("le journal des paiements"));
        this.xType = typeX;
        this.panelClose = new JFlowPanel();
        this.scroll = new JScrollPane(this.panelClose);
        this.scroll = new JScrollPane(this.panelClose);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.getVerticalScrollBar().setPreferredSize(new Dimension(25, 35));
        this.panelClose.setAlignmentY(0.5f);
        this.add((Component)this.scroll, "Center");
        this.app = app;
        this.dlSales = (DataLogicSales)app.getBean("com.openbravo.dao.DataLogicSales");
        this.dlStats = (DataLogicStats)app.getBean("com.openbravo.dao.DataLogicStats");
        this.dlUser = (DataLogicAdmin)app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
        this.caisse = this.dlSales.getCaisse(AppLocal.token);
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mTicketSharedService = TicketSharedService.getInstance();
        }
        this.mZGlobalService = ZGlobalService.getInstance();
        this.firstTime = true;
        if (caisseZ != null) {
            this.jPanelFirst.setVisible(false);
            this.title = " Z caisse ";
        }
        if (typeX != null) {
            switch (typeX) {
                case "caisse": {
                    this.title = " X caisse ";
                    this.jPanelFirst.setVisible(false);
                    break;
                }
                case "day": {
                    this.title = " X Jour ";
                    if (this.currentDate == null) {
                        this.currentDate = new Date();
                    }
                    this.year = this.currentDate.getYear() + 1900;
                    this.month = this.currentDate.getMonth() + 1;
                    this.day = this.currentDate.getDate();
                    this.dateStart = new Date(this.currentDate.getTime());
                    this.dateEnd = new Date();
                    DateUtils.setDateHours(this.dateStart, this.dateEnd);
                    UtilDateModel model = new UtilDateModel();
                    Properties p = new Properties();
                    p.put("text.today", "Aujourd'hui");
                    p.put("text.month", "Mois");
                    p.put("text.year", "Ann\u00e9e");
                    JDatePanelImpl datePanel = new JDatePanelImpl((DateModel)model, p);
                    this.datePicker = new JDatePickerImpl(datePanel, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
                    this.datePicker.getModel().setSelected(true);
                    this.datePicker.getModel().addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent ce) {
                            if (!JXCaisse.this.firstTime) {
                                Date selectedDate;
                                JXCaisse.this.currentDate = selectedDate = (Date)JXCaisse.this.datePicker.getModel().getValue();
                                if (selectedDate != null) {
                                    JXCaisse.this.day = selectedDate.getDate();
                                    JXCaisse.this.month = selectedDate.getMonth() + 1;
                                    JXCaisse.this.year = selectedDate.getYear() + 1900;
                                    try {
                                        JXCaisse.this.load(caisseZ, JXCaisse.this.xType, null);
                                    }
                                    catch (Exception ex) {
                                        LogToFile.log("severe", ex.getMessage(), ex);
                                    }
                                }
                            }
                        }
                    });
                    this.datePicker.setPreferredSize(new Dimension(300, 30));
                    this.paneDate = new JPanel();
                    this.paneDate.setLayout(new FlowLayout(2));
                    this.paneDate.add((Component)this.datePicker);
                    this.jPanelFirst.removeAll();
                    this.jPanelFirst.add((Component)this.paneDate, "Center");
                    this.jPanelFirst.revalidate();
                    this.jPanelFirst.repaint();
                    break;
                }
                case "j": {
                    this.title = " Z Journali\u00e8re ";
                    this.year = grandTotalPeriode.getYear();
                    this.month = grandTotalPeriode.getMonth();
                    this.day = grandTotalPeriode.getDay();
                    this.dateStart = new Date(this.year - 1900, this.month - 1, this.day);
                    this.dateEnd = new Date();
                    this.currentDate = new Date(this.dateStart.getTime());
                    DateUtils.setDateHours(this.dateStart, this.dateEnd);
                    UtilDateModel model1 = new UtilDateModel(this.dateStart);
                    Properties p1 = new Properties();
                    p1.put("text.today", "Aujourd'hui");
                    p1.put("text.month", "Mois");
                    p1.put("text.year", "Ann\u00e9e");
                    JDatePanelImpl datePanel = new JDatePanelImpl((DateModel)model1, p1);
                    this.datePicker = new JDatePickerImpl(datePanel, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
                    this.datePicker.getModel().setSelected(true);
                    this.datePicker.getModel().addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent ce) {
                            if (!JXCaisse.this.firstTime) {
                                Date selectedDate;
                                JXCaisse.this.currentDate = selectedDate = (Date)JXCaisse.this.datePicker.getModel().getValue();
                                if (selectedDate != null) {
                                    JXCaisse.this.day = selectedDate.getDate();
                                    JXCaisse.this.month = selectedDate.getMonth() + 1;
                                    JXCaisse.this.year = selectedDate.getYear() + 1900;
                                    try {
                                        JXCaisse.this.load(caisseZ, JXCaisse.this.xType, null);
                                    }
                                    catch (Exception ex) {
                                        LogToFile.log("severe", ex.getMessage(), ex);
                                    }
                                }
                            }
                        }
                    });
                    this.datePicker.setPreferredSize(new Dimension(300, 30));
                    JPanel paneDate1 = new JPanel();
                    paneDate1.setLayout(new FlowLayout(2));
                    paneDate1.add((Component)this.datePicker);
                    this.jPanelFirst.removeAll();
                    this.jPanelFirst.add((Component)paneDate1, "Center");
                    this.jPanelFirst.revalidate();
                    this.jPanelFirst.repaint();
                    break;
                }
                case "month": {
                    int i;
                    this.title = " X mois ";
                    this.jPanelFirst.removeAll();
                    this.jPanelFirst.add((Component)this.paneMonth, "Center");
                    this.jPanelFirst.revalidate();
                    this.jPanelFirst.repaint();
                    if (this.currentDate == null) {
                        this.currentDate = new Date();
                    }
                    this.year = this.currentDate.getYear() + 1900;
                    this.month = this.currentDate.getMonth() + 1;
                    this.listMonths = new ArrayList<MonthInfo>();
                    this.listMonths.add(new MonthInfo(1, "Janvier"));
                    this.listMonths.add(new MonthInfo(2, "F\u00e9vrier"));
                    this.listMonths.add(new MonthInfo(3, "Mars"));
                    this.listMonths.add(new MonthInfo(4, "Avril"));
                    this.listMonths.add(new MonthInfo(5, "Mai"));
                    this.listMonths.add(new MonthInfo(6, "Juin"));
                    this.listMonths.add(new MonthInfo(7, "Juillet"));
                    this.listMonths.add(new MonthInfo(8, "A\u00f4ut"));
                    this.listMonths.add(new MonthInfo(9, "Septembre"));
                    this.listMonths.add(new MonthInfo(10, "Octobre"));
                    this.listMonths.add(new MonthInfo(11, "Novembre"));
                    this.listMonths.add(new MonthInfo(12, "D\u00e9cembre"));
                    for (i = 2015; i <= 2026; ++i) {
                        this.jComboYear.addItem(i);
                    }
                    for (i = 0; i < 12; ++i) {
                        this.jComboMonth.addItem(this.listMonths.get(i));
                    }
                    this.jComboYear.setSelectedItem(this.currentDate.getYear() + 1900);
                    this.jComboMonth.setSelectedIndex(this.currentDate.getMonth());
                    break;
                }
                case "m": {
                    int i;
                    this.title = " Z mensuel ";
                    this.year = grandTotalPeriode.getYear();
                    this.month = grandTotalPeriode.getMonth();
                    this.day = 1;
                    this.jPanelFirst.setVisible(false);
                    this.listMonths = new ArrayList<MonthInfo>();
                    this.listMonths.add(new MonthInfo(1, "Janvier"));
                    this.listMonths.add(new MonthInfo(2, "F\u00e9vrier"));
                    this.listMonths.add(new MonthInfo(3, "Mars"));
                    this.listMonths.add(new MonthInfo(4, "Avril"));
                    this.listMonths.add(new MonthInfo(5, "Mai"));
                    this.listMonths.add(new MonthInfo(6, "Juin"));
                    this.listMonths.add(new MonthInfo(7, "Juillet"));
                    this.listMonths.add(new MonthInfo(8, "A\u00f4ut"));
                    this.listMonths.add(new MonthInfo(9, "Septembre"));
                    this.listMonths.add(new MonthInfo(10, "Octobre"));
                    this.listMonths.add(new MonthInfo(11, "Novembre"));
                    this.listMonths.add(new MonthInfo(12, "D\u00e9cembre"));
                    for (i = 2015; i <= 2026; ++i) {
                        this.jComboYear.addItem(i);
                    }
                    for (i = 0; i < 12; ++i) {
                        this.jComboMonth.addItem(this.listMonths.get(i));
                    }
                    this.jComboYear.setSelectedItem(this.year);
                    this.jComboMonth.setSelectedIndex(this.month - 1);
                    break;
                }
                case "a": {
                    this.title = " Z Annuel ";
                    this.year = grandTotalPeriode.getYear();
                    this.month = 1;
                    this.day = 1;
                    this.jComboYear.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            JXCaisse.this.changeYear();
                        }
                    });
                    this.jPanelFirst.setVisible(false);
                    for (int i = 2015; i <= 2026; ++i) {
                        this.jComboYear.addItem(i);
                    }
                    this.jComboYear.setSelectedItem(this.year);
                }
            }
        }
        this.load(caisseZ, typeX, periodeGlobal);
        this.firstTime = false;
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JXCaisse.getWindow(parent.getParent());
    }

    public static void showMessage(Component parent, AppView app, CaisseZ caisseZ, String typeX) throws BasicException, IOException {
        grandTotalPeriode = null;
        JXCaisse.caisseZ = caisseZ;
        Window window = JXCaisse.getWindow(parent);
        JXCaisse myMsg = window instanceof Frame ? new JXCaisse((Frame)window, true) : new JXCaisse((Dialog)window, true);
        myMsg.setPreferredSize(DIMENSION_PANEL);
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(app, caisseZ, typeX, null);
    }

    public static void showMessage(Component parent, AppView app, GrandTotalPeriode periode, ZGlobalInfoDTO mZGlobal, List<String> equipements) throws BasicException, IOException {
        grandTotalPeriode = periode;
        currentperiodeGlobal = mZGlobal;
        equipements_address = equipements;
        Window window = JXCaisse.getWindow(parent);
        JXCaisse myMsg = window instanceof Frame ? new JXCaisse((Frame)window, true) : new JXCaisse((Dialog)window, true);
        myMsg.setPreferredSize(DIMENSION_PANEL);
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(app, null, periode != null ? periode.getTypePeriode() : null, mZGlobal);
    }

    public String getHtmlTitle(String title) {
        return "<HTML><BODY align='center'>Imprimer<BR>" + title + "</BODY></HTML>";
    }

    public void load(CaisseZ caisseZ, String typeX, ZGlobalInfoDTO periodeGlobal) throws BasicException {
        JLabel labelTurnoverDeliveroo;
        this.turnover = 0.0;
        TotaleEncaissement totaleEncaissement = null;
        if (periodeGlobal != null) {
            this.payments = periodeGlobal.getPayments();
            this.m_iSales = periodeGlobal.getNumber_orders();
            this.caCanceled = periodeGlobal.getTurnover_canceled();
            this.allTaxes = periodeGlobal.getTaxes();
            this.allProduct = periodeGlobal.getNumber_products_sold();
            this.turnover = periodeGlobal.getTotal();
            this.year = periodeGlobal.getYear();
            this.month = periodeGlobal.getMonth();
            this.day = periodeGlobal.getType_periode() != null && periodeGlobal.getType_periode().equals("j") ? periodeGlobal.getDay() : 1;
            this.turnover_deliveroo = periodeGlobal.getTotal_orders_deliveroo();
            this.turnover_ubereat = periodeGlobal.getTurnover_ubereat();
            if (periodeGlobal.getType_periode() != null && periodeGlobal.getType_periode().equals("j")) {
                this.dateStart = new Date(this.year - 1900, this.month - 1, this.day);
                this.dateEnd = new Date();
                this.currentDate = new Date(this.dateStart.getTime());
                DateUtils.setDateHours(this.dateStart, this.dateEnd);
            } else {
                this.dateStart = new Date(this.year - 1900, this.month - 1, 1);
                this.dateEnd = new Date(this.year - 1900, this.month, 1);
            }
            this.groupedTaxes = periodeGlobal.getGroupedTaxes();
            this.total_ht_taxable = periodeGlobal.getTotal_ht_taxable();
            this.total_ht_no_taxable = periodeGlobal.getTotal_ht_no_taxable();
            this.mDialogTitle = "Rapport";
            this.mDialogTitle = this.mDialogTitle + (currentperiodeGlobal.getRapport_title() != null ? currentperiodeGlobal.getRapport_title() : this.RAPPORT_TITLE_Z_GLOBAL);
            this.jBtnPrint.setText(this.getHtmlTitle("rapport de la fermeture"));
            this.paneMonth.setVisible(false);
            this.jPanelPrint.removeAll();
            this.jPanelPrint.add(this.jBtnPrint);
            this.jPanelPrint.add(this.jBtnExportTurnoverExcel);
            this.jPanelPrint.revalidate();
            this.jPanelPrint.repaint();
        } else if (caisseZ != null) {
            System.out.println("+++++++++++++++++++ historique caisse");
            int idCaisse = caisseZ.getId();
            System.out.println("+++++++++++++++= idCaisse " + idCaisse);
            this.caisse = this.dlSales.getCaisseById(caisseZ.getCaisse());
            this.payments = this.dlSales.loadPaymentByCaisseId(idCaisse);
            this.m_iSales = this.dlSales.getNbOrderByIdCaisse(idCaisse);
            this.caCanceled = this.dlSales.getCACanceledByCaisseId(idCaisse);
            this.nbproduct = this.dlSales.getNbProduitByCaisseId(idCaisse);
            this.nbProductDiver = this.dlSales.getNbProduitDiversByCaisseId(idCaisse);
            this.taxes = this.dlSales.getTaxeByDateByIdCaisse(idCaisse);
            this.dateStart = caisseZ.getDateOpen();
            this.dateEnd = caisseZ.getDateClose();
            this.users = this.dlSales.getCAbyUser(this.dateStart, this.dateEnd);
            this.salesByHour = this.dlStats.loadSatisticByHour(this.dateStart, this.dateEnd);
            this.groupedTaxes = this.dlStats.getGlobalTaxes(this.dateStart, this.dateEnd);
            totaleEncaissement = this.dlStats.getTotalEncaissement(this.dateStart, this.dateEnd);
            this.total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
            this.total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
            this.turnover_deliveroo = this.dlStats.getTurnoverPlatformXDay(this.dateStart, this.dateEnd, "Deliveroo");
            this.turnover_ubereat = this.dlStats.getTurnoverPlatformXDay(this.dateStart, this.dateEnd, "Uber Eats");
            this.salesByUnit.clear();
            this.salesByUnit.addAll(this.salesByHour);
            this.unit = "h";
            this.mDialogTitle = "Rapport Z Caisse";
            this.jBtnPrint.setText(this.getHtmlTitle("rapport de la fermeture"));
            this.jBtnPrintSynthese.setText(this.getHtmlTitle("le synth\u00e8se de la fermeture"));
        } else {
            System.out.println("+++++++++++++++++++++++ typeX : " + typeX);
            switch (typeX) {
                case "caisse": {
                    this.payments = this.dlSales.loadPayment(this.caisse.getDateOpen(), new Date());
                    this.dateStart = this.caisse.getDateOpen();
                    this.dateEnd = new Date();
                    this.m_iSales = this.dlStats.getNbOrderXDay(this.dateStart, this.dateEnd);
                    this.caCanceled = this.dlStats.getCACanceledXDay(this.dateStart, this.dateEnd);
                    this.nbproduct = this.dlStats.getNbProduitXDay(this.dateStart, this.dateEnd);
                    this.nbProductDiver = this.dlStats.getNbProduitDiversXDay(this.dateStart, this.dateEnd);
                    this.taxes = this.dlStats.getTaxeXDay(this.dateStart, this.dateEnd);
                    this.users = this.dlStats.getCAbyUserXDay(this.dateStart, this.dateEnd);
                    this.salesByHour = this.dlStats.loadSatisticByHour(this.dateStart, this.dateEnd);
                    this.groupedTaxes = this.dlStats.getGlobalTaxes(this.dateStart, this.dateEnd);
                    totaleEncaissement = this.dlStats.getTotalEncaissement(this.dateStart, this.dateEnd);
                    this.total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
                    this.total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByHour);
                    this.unit = "h";
                    this.mDialogTitle = "Rapport X de caisse";
                    this.jBtnPrint.setText(this.getHtmlTitle("le X de Caisse"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se de X Caisse"));
                    break;
                }
                case "day": {
                    if (this.currentDate == null) {
                        this.currentDate = new Date();
                    }
                    this.dateStart = new Date(this.currentDate.getTime());
                    this.dateEnd = new Date();
                    DateUtils.setDateHours(this.dateStart, this.dateEnd);
                    this.payments = this.dlStats.loadPaymentXDay(this.dateStart, this.dateEnd);
                    this.caCanceled = this.dlStats.getCACanceledXDay(this.dateStart, this.dateEnd);
                    this.nbproduct = this.dlStats.getNbProduitXDay(this.dateStart, this.dateEnd);
                    this.nbProductDiver = this.dlStats.getNbProduitDiversXDay(this.dateStart, this.dateEnd);
                    this.taxes = this.dlStats.getTaxeXDay(this.dateStart, this.dateEnd);
                    this.users = this.dlStats.getCAbyUserXDay(this.dateStart, this.dateEnd);
                    this.m_iSales = this.dlStats.getNbOrderXDay(this.dateStart, this.dateEnd);
                    this.salesByHour = this.dlStats.loadSatisticByHour(this.dateStart, this.dateEnd);
                    this.groupedTaxes = this.dlStats.getGlobalTaxes(this.dateStart, this.dateEnd);
                    totaleEncaissement = this.dlStats.getTotalEncaissement(this.dateStart, this.dateEnd);
                    this.total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
                    this.total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByHour);
                    this.unit = "h";
                    this.turnover_deliveroo = this.dlStats.getTurnoverPlatformXDay(this.dateStart, this.dateEnd, "Deliveroo");
                    this.turnover_ubereat = this.dlStats.getTurnoverPlatformXDay(this.dateStart, this.dateEnd, "Uber Eats");
                    System.out.println("dateStart : " + this.dateStart);
                    System.out.println("dateEnd : " + this.dateEnd);
                    System.out.println("turnover_ubereat ****************** : " + this.turnover_ubereat);
                    this.mDialogTitle = "Rapport X du Jour";
                    this.jBtnPrint.setText(this.getHtmlTitle("le Rapport Financier du jour"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se du jour"));
                    break;
                }
                case "j": {
                    if (this.currentDate == null) {
                        this.currentDate = new Date();
                    }
                    this.dateStart = new Date(this.currentDate.getTime());
                    this.dateEnd = new Date();
                    DateUtils.setDateHours(this.dateStart, this.dateEnd);
                    System.out.println("historique j dateStart : " + this.dateStart);
                    System.out.println("historique j dateEnd : " + this.dateEnd);
                    System.out.println("+++++++ grandTotalPeriode.isInsert_ficancial_infos() : " + grandTotalPeriode.isInsert_ficancial_infos());
                    if (grandTotalPeriode.isInsert_ficancial_infos()) {
                        this.loadFinancialReportInfo();
                    } else {
                        this.payments = this.dlStats.loadPaymentXDay(this.dateStart, this.dateEnd);
                        this.m_iSales = this.dlStats.getNbOrderXDay(this.dateStart, this.dateEnd);
                        this.caCanceled = this.dlStats.getCACanceledXDay(this.dateStart, this.dateEnd);
                        this.nbproduct = this.dlStats.getNbProduitXDay(this.dateStart, this.dateEnd);
                        this.nbProductDiver = this.dlStats.getNbProduitDiversXDay(this.dateStart, this.dateEnd);
                        this.taxes = this.dlStats.getTaxeXDay(this.dateStart, this.dateEnd);
                    }
                    this.users = this.dlStats.getCAbyUserXDay(this.dateStart, this.dateEnd);
                    this.salesByHour = this.dlStats.loadSatisticByHour(this.dateStart, this.dateEnd);
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByHour);
                    this.unit = "h";
                    this.mDialogTitle = "Rapport de la Cloture Journali\u00e8re";
                    this.jBtnPrint.setText(this.getHtmlTitle("le Rapport Financier du Z jour"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se du Z jour"));
                    break;
                }
                case "month": {
                    this.payments = this.dlSales.loadPaymentByYearAndOrMonth(this.year, this.month);
                    this.m_iSales = this.dlSales.getNbOrderByYearAndOrMonth(this.year, this.month);
                    this.caCanceled = this.dlSales.getCACanceledByYearAndOrMonth(this.year, this.month);
                    this.nbproduct = this.dlSales.getNbProduitByYearAndOrMonth(this.year, this.month);
                    this.nbProductDiver = this.dlSales.getNbProduitDiversByYearAndOrMonth(this.year, this.month);
                    this.taxes = this.dlSales.getTaxesByYearAndOrMonth(this.year, this.month);
                    this.users = this.dlSales.getCAbyUserByYearAndOrMonth(this.year, this.month);
                    this.dateStart = new Date(this.year - 1900, this.month - 1, 1);
                    Date tempDate2 = new Date();
                    this.dateEnd = tempDate2.getMonth() == this.month - 1 ? new Date(this.year - 1900, this.month - 1, tempDate2.getDate(), tempDate2.getHours(), tempDate2.getMinutes(), 0) : new Date(this.year - 1900, this.month, 1);
                    this.salesByDay = this.dlStats.loadSatisticByMonth(this.dateStart, this.dateEnd);
                    this.groupedTaxes = this.dlStats.getGlobalTaxes(this.dateStart, this.dateEnd);
                    totaleEncaissement = this.dlStats.getTotalEncaissement(this.dateStart, this.dateEnd);
                    this.total_ht_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_taxable() : 0.0;
                    this.total_ht_no_taxable = totaleEncaissement != null ? totaleEncaissement.getTotal_ht_no_taxable() : 0.0;
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByDay);
                    this.unit = "j";
                    this.mDialogTitle = "Rapport X Mois";
                    this.jBtnPrint.setText(this.getHtmlTitle("le Rapport Financier du X mois"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se du X mois"));
                    break;
                }
                case "m": {
                    if (grandTotalPeriode.isInsert_ficancial_infos()) {
                        this.loadFinancialReportInfo();
                    } else {
                        this.payments = this.dlSales.loadPaymentByYearAndOrMonth(this.year, this.month);
                        this.m_iSales = this.dlSales.getNbOrderByYearAndOrMonth(this.year, this.month);
                        this.caCanceled = this.dlSales.getCACanceledByYearAndOrMonth(this.year, this.month);
                        this.nbproduct = this.dlSales.getNbProduitByYearAndOrMonth(this.year, this.month);
                        this.nbProductDiver = this.dlSales.getNbProduitDiversByYearAndOrMonth(this.year, this.month);
                        this.taxes = this.dlSales.getTaxesByYearAndOrMonth(this.year, this.month);
                    }
                    this.users = this.dlSales.getCAbyUserByYearAndOrMonth(this.year, this.month);
                    this.dateStart = new Date(this.year - 1900, this.month - 1, 1);
                    this.dateEnd = new Date(this.year - 1900, this.month, 1);
                    System.out.println("historique m year : " + this.year);
                    System.out.println("historique m month : " + this.month);
                    System.out.println("historique m dateStart : " + this.dateStart);
                    System.out.println("historique m dateEnd : " + this.dateEnd);
                    this.salesByDay = this.dlStats.loadSatisticByMonth(this.dateStart, this.dateEnd);
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByDay);
                    this.unit = "j";
                    this.mDialogTitle = "Rapport de Cloture Mensuel";
                    this.jBtnPrint.setText(this.getHtmlTitle("le Rapport Financier du Z mois"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se du Z mois"));
                    break;
                }
                case "a": {
                    if (grandTotalPeriode.isInsert_ficancial_infos()) {
                        this.loadFinancialReportInfo();
                    } else {
                        this.payments = this.dlSales.loadPaymentByYearAndOrMonth(this.year, 0);
                        this.m_iSales = this.dlSales.getNbOrderByYearAndOrMonth(this.year, 0);
                        this.caCanceled = this.dlSales.getCACanceledByYearAndOrMonth(this.year, 0);
                        this.nbproduct = this.dlSales.getNbProduitByYearAndOrMonth(this.year, 0);
                        this.nbProductDiver = this.dlSales.getNbProduitDiversByYearAndOrMonth(this.year, 0);
                        this.taxes = this.dlSales.getTaxesByYearAndOrMonth(this.year, 0);
                    }
                    this.users = this.dlSales.getCAbyUserByYearAndOrMonth(this.year, 0);
                    this.dateStart = new Date(this.year - 1900, 0, 1);
                    this.dateEnd = new Date(this.year - 1900 + 1, 0, 1);
                    System.out.println("historique a year : " + this.year);
                    System.out.println("historique a dateStart : " + this.dateStart);
                    System.out.println("historique a dateEnd : " + this.dateEnd);
                    this.salesByDay = this.dlStats.loadSatisticByYear(this.dateStart, this.dateEnd);
                    this.salesByUnit.clear();
                    this.salesByUnit.addAll(this.salesByDay);
                    this.unit = "m";
                    this.mDialogTitle = "Rapport de Cloture Annuel";
                    this.jBtnPrint.setText(this.getHtmlTitle("le Rapport Financier du Z ann\u00e9e"));
                    this.jBtnPrintSynthese.setText(this.getHtmlTitle("le Synth\u00e8se du Z ann\u00e9e"));
                }
            }
        }
        this.setTitle(this.mDialogTitle);
        System.out.println("++++++++++ grandTotalPeriode : " + grandTotalPeriode);
        if (!(grandTotalPeriode != null && grandTotalPeriode.isInsert_ficancial_infos() || periodeGlobal != null)) {
            this.allProduct = this.nbproduct + this.nbProductDiver;
            this.allTaxes = new ArrayList<TaxeLine>();
            if (this.taxes != null) {
                this.allTaxes.addAll(this.taxes);
            }
        }
        int with = 800;
        this.panelClose.removeAll();
        JPanel panelHeader = new JPanel();
        panelHeader.setPreferredSize(new Dimension(800, 20));
        this.panelClose.add(panelHeader);
        this.labelTitle = new JLabel();
        this.labelTitle.setHorizontalAlignment(2);
        this.labelTitle.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.period_value = "";
        if (typeX != null) {
            switch (typeX) {
                case "caisse": {
                    this.period_value = this.dateFullFormatter.format(new Date());
                    this.labelTitle.setText("Rapport Financier du " + this.dateFullFormatter.format(new Date()));
                    break;
                }
                case "day": {
                    Object valDay = String.valueOf(this.day);
                    Iterator<PaymentLine> valMonth = String.valueOf(this.month);
                    valDay = ((String)valDay).length() < 2 ? "0" + (String)valDay : valDay;
                    valMonth = ((String)((Object)valMonth)).length() < 2 ? "0" + (String)((Object)valMonth) : valMonth;
                    this.period_value = (String)valDay + "-" + (String)((Object)valMonth) + "-" + this.year;
                    this.labelTitle.setText("Rapport Financier du " + (String)valDay + "-" + (String)((Object)valMonth) + "-" + this.year);
                    break;
                }
                case "j": {
                    Object valDay = String.valueOf(this.day);
                    Iterator<PaymentLine> valMonth = String.valueOf(this.month);
                    valDay = ((String)valDay).length() < 2 ? "0" + (String)valDay : valDay;
                    valMonth = ((String)((Object)valMonth)).length() < 2 ? "0" + (String)((Object)valMonth) : valMonth;
                    this.period_value = (String)valDay + "-" + (String)((Object)valMonth) + "-" + this.year;
                    this.labelTitle.setText("Rapport Financier du " + (String)valDay + "-" + (String)((Object)valMonth) + "-" + this.year);
                    break;
                }
                case "month": {
                    this.period_value = ((MonthInfo)this.jComboMonth.getSelectedItem()).getName() + "/" + this.year;
                    this.labelTitle.setText("Rapport Financier du " + ((MonthInfo)this.jComboMonth.getSelectedItem()).getName() + "/" + this.year);
                    break;
                }
                case "m": {
                    this.period_value = ((MonthInfo)this.jComboMonth.getSelectedItem()).getName() + "/" + this.year;
                    this.labelTitle.setText("Rapport Financier du " + ((MonthInfo)this.jComboMonth.getSelectedItem()).getName() + "/" + this.year);
                    break;
                }
                case "a": {
                    this.period_value = "" + this.year;
                    this.labelTitle.setText("Rapport Financier de " + this.year);
                }
            }
        } else if (periodeGlobal != null) {
            if (periodeGlobal.getType_periode() != null && periodeGlobal.getType_periode().equals("m")) {
                this.period_value = DateUtils.getNameOfMonth(this.dateStart.getMonth() + 1) + "/" + this.year;
                this.labelTitle.setText("Rapport Financier du " + DateUtils.getNameOfMonth(this.dateStart.getMonth() + 1) + "/" + this.year);
            } else {
                this.period_value = this.dateFormatter.format(this.dateStart);
                this.labelTitle.setText("Rapport Financier du " + this.dateFormatter.format(this.dateStart));
            }
        } else {
            this.period_value = this.dateFormatter.format(caisseZ.getDateOpen());
            this.labelTitle.setText("Rapport Financier du " + this.dateFormatter.format(caisseZ.getDateOpen()));
        }
        this.labelTitle.setPreferredSize(new Dimension(300, 20));
        this.panelClose.add(this.labelTitle);
        if ("caisse".equals(typeX)) {
            this.labelFond = new JLabel();
            this.labelFond.setHorizontalAlignment(2);
            this.labelFond.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            this.labelFond.setText("Fond du caisse " + Formats.CURRENCY.formatValue(this.caisse.getFondCaisse()));
            this.labelFond.setPreferredSize(new Dimension(500, 20));
            this.panelClose.add(this.labelFond);
        }
        this.titlePayment = new JPanel();
        this.titlePayment.setLayout(new FlowLayout());
        this.titlePayment.setPreferredSize(new Dimension(800, 20));
        this.modeTitle = new JLabel();
        this.modeTitle.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.modeTitle.setText("Mode de paiement");
        this.modeTitle.setPreferredSize(new Dimension(300, 20));
        this.encaissementTile = new JLabel();
        this.encaissementTile.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.encaissementTile.setText("Encaissement");
        this.encaissementTile.setPreferredSize(new Dimension(240, 20));
        this.tiroirTitle = new JLabel();
        this.tiroirTitle.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.tiroirTitle.setText("Dans le tiroir");
        this.tiroirTitle.setPreferredSize(new Dimension(240, 20));
        this.titlePayment.add(this.modeTitle);
        this.titlePayment.add(this.encaissementTile);
        this.titlePayment.add(this.tiroirTitle);
        this.panelClose.add(this.titlePayment);
        if (grandTotalPeriode == null || !grandTotalPeriode.isInsert_ficancial_infos()) {
            this.paymentCash = null;
            this.paymentEspece = null;
            Iterator<Object> listPayments = new ArrayList();
            for (PaymentLine payment : this.payments) {
                if ("cash".equalsIgnoreCase(payment.getM_PaymentType())) {
                    this.paymentCash = payment;
                    continue;
                }
                if ("Espece".equalsIgnoreCase(payment.getM_PaymentType())) {
                    this.paymentEspece = payment;
                    continue;
                }
                listPayments.add(payment);
            }
            this.payments.clear();
            if (this.paymentCash != null && this.paymentEspece != null) {
                this.paymentCash.setM_PaymentValue(this.paymentCash.getM_PaymentValue() + this.paymentEspece.getM_PaymentValue());
                this.payments.add(this.paymentCash);
            }
            if (this.paymentCash != null && this.paymentEspece == null) {
                this.payments.add(this.paymentCash);
            }
            if (this.paymentCash == null && this.paymentEspece != null) {
                this.paymentEspece.setM_PaymentType(AppConstants.PAYMENT_MODE.CASH.getName());
                this.payments.add(this.paymentEspece);
            }
            this.payments.addAll((Collection<PaymentLine>)((Object)listPayments));
        }
        if (!(grandTotalPeriode != null && grandTotalPeriode.isInsert_ficancial_infos() || periodeGlobal != null)) {
            for (PaymentLine payment : this.payments) {
                this.turnover += payment.getM_PaymentValue().doubleValue();
            }
        }
        this.turnoverHT = 0.0;
        this.totalTaxes = 0.0;
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            this.turnoverHT = this.turnover;
            for (GroupedTax taxe : this.groupedTaxes) {
                this.turnoverHT -= taxe.getTotal_tax();
            }
        } else {
            for (TaxeLine allTaxe : this.allTaxes) {
                this.turnoverHT += allTaxe.getHt();
                this.totalTaxes += allTaxe.getTax();
            }
        }
        for (PaymentLine payment : this.payments) {
            JPanel panelPayment = new JPanel();
            panelPayment.setLayout(new FlowLayout());
            panelPayment.setPreferredSize(new Dimension(800, 25));
            JLabel mode = new JLabel();
            String namePayment = "cash".equals(payment.getM_PaymentType()) ? "Espese" : ("Avoir".equals(payment.getM_PaymentType()) && payment.getM_PaymentValue() > 0.0 ? "Avoir Encaiss\u00e9" : ("Avoir".equals(payment.getM_PaymentType()) && payment.getM_PaymentValue() < 0.0 ? "Avoir D\u00e9caiss\u00e9" : payment.getM_PaymentType()));
            mode.setText(namePayment);
            mode.setPreferredSize(new Dimension(300, 25));
            JPanel panelEncaissement = new JPanel();
            panelEncaissement.setLayout(new GridLayout(1, 0, 5, 0));
            panelEncaissement.setPreferredSize(new Dimension(240, 25));
            JLabel valueEncaissement = new JLabel();
            valueEncaissement.setText(Formats.CURRENCY.formatValue(payment.getM_PaymentValue()));
            panelEncaissement.add(valueEncaissement);
            JPanel panelTiroir = new JPanel();
            panelTiroir.setLayout(new GridLayout(1, 0, 5, 0));
            panelTiroir.setPreferredSize(new Dimension(240, 25));
            JLabel valueTiroir = new JLabel();
            double totalTiroir = 0.0;
            totalTiroir = "caisse".equals(typeX) ? ("cash".equals(payment.getM_PaymentType()) ? payment.getM_PaymentValue() + this.caisse.getFondCaisse() : payment.getM_PaymentValue()) : payment.getM_PaymentValue();
            valueTiroir.setText(Formats.CURRENCY.formatValue(totalTiroir));
            panelTiroir.add(valueTiroir);
            panelPayment.add(mode);
            panelPayment.add(panelEncaissement);
            panelPayment.add(panelTiroir);
            this.panelClose.add(panelPayment);
        }
        if (this.turnover_deliveroo != 0.0) {
            JPanel panelDeliveroo = new JPanel();
            panelDeliveroo.setLayout(new FlowLayout(0));
            panelDeliveroo.setPreferredSize(new Dimension(800, 25));
            labelTurnoverDeliveroo = new JLabel();
            labelTurnoverDeliveroo.setText("Deliveroo");
            labelTurnoverDeliveroo.setPreferredSize(new Dimension(300, 25));
            JPanel panelTurnoverDeliveroo = new JPanel();
            panelTurnoverDeliveroo.setLayout(new GridLayout(1, 0, 5, 0));
            panelTurnoverDeliveroo.setPreferredSize(new Dimension(240, 25));
            JLabel valueTurnoverDeliveroo = new JLabel();
            valueTurnoverDeliveroo.setText(Formats.CURRENCY.formatValue(this.turnover_deliveroo));
            panelTurnoverDeliveroo.add(valueTurnoverDeliveroo);
            panelDeliveroo.add(labelTurnoverDeliveroo);
            panelDeliveroo.add(panelTurnoverDeliveroo);
            this.panelClose.add(panelDeliveroo);
        }
        if (this.turnover_ubereat != 0.0) {
            JPanel panelUberEats = new JPanel();
            panelUberEats.setLayout(new FlowLayout(0));
            panelUberEats.setPreferredSize(new Dimension(800, 25));
            labelTurnoverDeliveroo = new JLabel();
            labelTurnoverDeliveroo.setText("Uber Eats");
            labelTurnoverDeliveroo.setPreferredSize(new Dimension(300, 25));
            JPanel panelTurnoverUberEats = new JPanel();
            panelTurnoverUberEats.setLayout(new GridLayout(1, 0, 5, 0));
            panelTurnoverUberEats.setPreferredSize(new Dimension(240, 25));
            JLabel valueTurnoverUberEats = new JLabel();
            valueTurnoverUberEats.setText(Formats.CURRENCY.formatValue(this.turnover_ubereat));
            panelTurnoverUberEats.add(valueTurnoverUberEats);
            panelUberEats.add(labelTurnoverDeliveroo);
            panelUberEats.add(panelTurnoverUberEats);
            this.panelClose.add(panelUberEats);
        }
        this.separator2 = new JSeparator();
        this.separator2.setPreferredSize(new Dimension(800, 2));
        this.panelClose.add(this.separator2);
        JPanel panelCA = new JPanel();
        panelCA.setLayout(new FlowLayout());
        panelCA.setPreferredSize(new Dimension(800, 20));
        JLabel titleCA = new JLabel();
        titleCA.setText("C.A. Brut");
        titleCA.setPreferredSize(new Dimension(300, 20));
        JLabel valueCA = new JLabel();
        valueCA.setText(Formats.CURRENCY.formatValue(this.turnover));
        valueCA.setPreferredSize(new Dimension(120, 20));
        JLabel nbOrder = new JLabel();
        nbOrder.setText(Formats.INT.formatValue(this.m_iSales) + " Clients");
        nbOrder.setPreferredSize(new Dimension(360, 20));
        panelCA.add(titleCA);
        panelCA.add(valueCA);
        panelCA.add(nbOrder);
        this.panelClose.add(panelCA);
        JPanel panelAVGPanier = new JPanel();
        panelAVGPanier.setLayout(new FlowLayout());
        panelAVGPanier.setPreferredSize(new Dimension(800, 20));
        JLabel titlePanier = new JLabel();
        titlePanier.setText("PANIER MOYEN BRUT");
        titlePanier.setPreferredSize(new Dimension(300, 20));
        JLabel valueAVG = new JLabel();
        valueAVG.setText(this.m_iSales == 0 ? " " : Formats.CURRENCY.formatValue(this.turnover / (double)this.m_iSales.intValue()));
        valueAVG.setPreferredSize(new Dimension(480, 20));
        panelAVGPanier.add(titlePanier);
        panelAVGPanier.add(valueAVG);
        this.panelClose.add(panelAVGPanier);
        JPanel panelPanier = new JPanel();
        panelPanier.setLayout(new FlowLayout());
        panelPanier.setPreferredSize(new Dimension(800, 20));
        JLabel titlePanierBrut = new JLabel();
        titlePanierBrut.setText("MOYEN PANIER NET");
        titlePanierBrut.setPreferredSize(new Dimension(300, 20));
        JLabel valuePanieBrut = new JLabel();
        valuePanieBrut.setText(this.m_iSales == 0 ? " " : Formats.CURRENCY.formatValue(this.turnoverHT / (double)this.m_iSales.intValue()));
        valuePanieBrut.setPreferredSize(new Dimension(480, 20));
        panelPanier.add(titlePanierBrut);
        panelPanier.add(valuePanieBrut);
        this.panelClose.add(panelPanier);
        this.separator3 = new JSeparator();
        this.separator3.setPreferredSize(new Dimension(800, 2));
        this.panelClose.add(this.separator3);
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            double total_before_taxes = this.turnover;
            for (GroupedTax taxe : this.groupedTaxes) {
                total_before_taxes -= taxe.getTotal_tax();
            }
            JPanel totalBeforeTaxe = new JPanel();
            totalBeforeTaxe.setLayout(new FlowLayout(0));
            totalBeforeTaxe.setPreferredSize(new Dimension(800, 30));
            JLabel labelTotalBeforeTaxe = new JLabel();
            JLabel valueTotalBeforeTaxe = new JLabel();
            labelTotalBeforeTaxe.setPreferredSize(new Dimension(300, 30));
            valueTotalBeforeTaxe.setPreferredSize(new Dimension(120, 30));
            labelTotalBeforeTaxe.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            valueTotalBeforeTaxe.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            labelTotalBeforeTaxe.setText("Total avant taxes :");
            valueTotalBeforeTaxe.setText(Formats.CURRENCY.formatValue(total_before_taxes));
            totalBeforeTaxe.add(labelTotalBeforeTaxe);
            totalBeforeTaxe.add(valueTotalBeforeTaxe);
            this.panelClose.add(totalBeforeTaxe);
            if (this.total_ht_taxable != 0.0) {
                JPanel totalHtTaxable = new JPanel();
                totalHtTaxable.setLayout(new FlowLayout(0));
                totalHtTaxable.setPreferredSize(new Dimension(800, 30));
                JLabel labelTotalHtTaxable = new JLabel();
                JLabel valueTotalHtTaxable = new JLabel();
                labelTotalHtTaxable.setPreferredSize(new Dimension(300, 30));
                valueTotalHtTaxable.setPreferredSize(new Dimension(120, 30));
                labelTotalHtTaxable.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                valueTotalHtTaxable.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelTotalHtTaxable.setText("Total HT taxable :");
                valueTotalHtTaxable.setText(Formats.CURRENCY.formatValue(this.total_ht_taxable));
                totalHtTaxable.add(labelTotalHtTaxable);
                totalHtTaxable.add(valueTotalHtTaxable);
                this.panelClose.add(totalHtTaxable);
            }
            if (this.total_ht_no_taxable != 0.0) {
                JPanel totalHtNoTaxable = new JPanel();
                totalHtNoTaxable.setLayout(new FlowLayout(0));
                totalHtNoTaxable.setPreferredSize(new Dimension(800, 30));
                JLabel labelTotalHtNoTaxable = new JLabel();
                JLabel valueTotalHtNoTaxable = new JLabel();
                labelTotalHtNoTaxable.setPreferredSize(new Dimension(300, 30));
                valueTotalHtNoTaxable.setPreferredSize(new Dimension(120, 30));
                labelTotalHtNoTaxable.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                valueTotalHtNoTaxable.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelTotalHtNoTaxable.setText("Total HT no taxable :");
                valueTotalHtNoTaxable.setText(Formats.CURRENCY.formatValue(this.total_ht_no_taxable));
                totalHtNoTaxable.add(labelTotalHtNoTaxable);
                totalHtNoTaxable.add(valueTotalHtNoTaxable);
                this.panelClose.add(totalHtNoTaxable);
            }
            for (GroupedTax taxe : this.groupedTaxes) {
                JPanel panelTax = new JPanel();
                panelTax.setLayout(new FlowLayout(0));
                panelTax.setPreferredSize(new Dimension(800, 30));
                JLabel labelTax = new JLabel();
                JLabel valueTax = new JLabel();
                labelTax.setPreferredSize(new Dimension(300, 30));
                valueTax.setPreferredSize(new Dimension(120, 30));
                labelTax.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                valueTax.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelTax.setText(taxe.getName());
                valueTax.setText(Formats.CURRENCY.formatValue(taxe.getTotal_tax()));
                panelTax.add(labelTax);
                panelTax.add(valueTax);
                this.panelClose.add(panelTax);
            }
        } else {
            JPanel titlesTaxe = new JPanel();
            titlesTaxe.setLayout(new FlowLayout());
            titlesTaxe.setPreferredSize(new Dimension(800, 30));
            JLabel titleTaxe = new JLabel();
            JLabel titleTotal = new JLabel();
            JLabel titleHT = new JLabel();
            JLabel titleTVA = new JLabel();
            titleTaxe.setPreferredSize(new Dimension(300, 30));
            titleTotal.setPreferredSize(new Dimension(120, 30));
            titleHT.setPreferredSize(new Dimension(155, 30));
            titleTVA.setPreferredSize(new Dimension(190, 30));
            titleTaxe.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleTotal.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleHT.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleTVA.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleTaxe.setText("TAXES");
            titleTotal.setText("TOTAL TTC");
            titleHT.setText("TOTAL HT");
            titleTVA.setText("TOTAL TVA");
            titlesTaxe.add(titleTaxe);
            titlesTaxe.add(titleTotal);
            titlesTaxe.add(titleHT);
            titlesTaxe.add(titleTVA);
            this.panelClose.add(titlesTaxe);
            double totalTaxes = 0.0;
            double totalHT = 0.0;
            double totalTVA = 0.0;
            for (TaxeLine taxe : this.allTaxes) {
                if (taxe.getTotal() == 0.0) continue;
                totalTaxes += taxe.getTotal();
                totalHT += taxe.getHt();
                totalTVA += taxe.getTax();
                JPanel panelTaxes = new JPanel();
                panelTaxes.setLayout(new FlowLayout());
                panelTaxes.setPreferredSize(new Dimension(800, 20));
                JLabel valTaxe = new JLabel();
                JLabel valTotal = new JLabel();
                JLabel valHT = new JLabel();
                JLabel valTVA = new JLabel();
                valTaxe.setPreferredSize(new Dimension(300, 20));
                valTotal.setPreferredSize(new Dimension(120, 20));
                valHT.setPreferredSize(new Dimension(155, 20));
                valTVA.setPreferredSize(new Dimension(190, 20));
                valTaxe.setText(taxe.getName());
                valTotal.setText(Formats.CURRENCY.formatValue(taxe.getTotal()));
                valHT.setText(Formats.CURRENCY.formatValue(taxe.getHt()));
                valTVA.setText(Formats.CURRENCY.formatValue(taxe.getTax()));
                panelTaxes.add(valTaxe);
                panelTaxes.add(valTotal);
                panelTaxes.add(valHT);
                panelTaxes.add(valTVA);
                this.panelClose.add(panelTaxes);
            }
            JPanel panelTaxesTotal = new JPanel();
            panelTaxesTotal.setLayout(new FlowLayout());
            panelTaxesTotal.setPreferredSize(new Dimension(800, 20));
            JLabel totalTaxe = new JLabel();
            JLabel gTotal = new JLabel();
            JLabel labeltotalHT = new JLabel();
            JLabel labeltotalTVA = new JLabel();
            totalTaxe.setPreferredSize(new Dimension(300, 20));
            gTotal.setPreferredSize(new Dimension(120, 20));
            labeltotalHT.setPreferredSize(new Dimension(155, 20));
            labeltotalTVA.setPreferredSize(new Dimension(190, 20));
            totalTaxe.setText("TOTAL");
            gTotal.setText(Formats.CURRENCY.formatValue(totalTaxes));
            labeltotalHT.setText(Formats.CURRENCY.formatValue(totalHT));
            labeltotalTVA.setText(Formats.CURRENCY.formatValue(totalTVA));
            panelTaxesTotal.add(totalTaxe);
            panelTaxesTotal.add(gTotal);
            panelTaxesTotal.add(labeltotalHT);
            panelTaxesTotal.add(labeltotalTVA);
            this.panelClose.add(panelTaxesTotal);
        }
        this.separator4 = new JSeparator();
        this.separator4.setPreferredSize(new Dimension(800, 2));
        this.panelClose.add(this.separator4);
        JPanel panelDiversTitle = new JPanel();
        panelDiversTitle.setLayout(new FlowLayout());
        panelDiversTitle.setPreferredSize(new Dimension(800, 20));
        JLabel titleDiver = new JLabel();
        JLabel titleMontant = new JLabel();
        JLabel titleQtt = new JLabel();
        titleDiver.setPreferredSize(new Dimension(300, 20));
        titleMontant.setPreferredSize(new Dimension(120, 20));
        titleQtt.setPreferredSize(new Dimension(360, 20));
        titleDiver.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        titleMontant.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        titleQtt.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        titleDiver.setText("Divers");
        titleMontant.setText("Montants");
        titleQtt.setText("Qte");
        panelDiversTitle.add(titleDiver);
        panelDiversTitle.add(titleMontant);
        panelDiversTitle.add(titleQtt);
        this.panelClose.add(panelDiversTitle);
        JPanel panelDiversCA = new JPanel();
        panelDiversCA.setLayout(new FlowLayout());
        panelDiversCA.setPreferredSize(new Dimension(800, 20));
        JLabel caDiver = new JLabel();
        JLabel caMontant = new JLabel();
        JLabel caQtt = new JLabel();
        caDiver.setPreferredSize(new Dimension(300, 20));
        caMontant.setPreferredSize(new Dimension(120, 20));
        caQtt.setPreferredSize(new Dimension(360, 20));
        caDiver.setText("CA NET");
        caMontant.setText(Formats.CURRENCY.formatValue(this.turnoverHT));
        caQtt.setText(Formats.INT.formatValue(this.m_iSales));
        panelDiversCA.add(caDiver);
        panelDiversCA.add(caMontant);
        panelDiversCA.add(caQtt);
        this.panelClose.add(panelDiversCA);
        if (this.caCanceled != 0.0) {
            JPanel panelCanceled = new JPanel();
            panelCanceled.setLayout(new FlowLayout());
            panelCanceled.setPreferredSize(new Dimension(800, 20));
            JLabel titleCancel = new JLabel();
            titleCancel.setText("C.A. Annul\u00e9");
            titleCancel.setPreferredSize(new Dimension(300, 20));
            JLabel valueCancel = new JLabel();
            valueCancel.setText(Formats.CURRENCY.formatValue(this.caCanceled));
            valueCancel.setPreferredSize(new Dimension(480, 20));
            panelCanceled.add(titleCancel);
            panelCanceled.add(valueCancel);
            this.panelClose.add(panelCanceled);
        }
        JPanel panelDiversProducts = new JPanel();
        panelDiversProducts.setLayout(new FlowLayout());
        panelDiversProducts.setPreferredSize(new Dimension(800, 20));
        JLabel productDiver = new JLabel();
        JLabel productMontant = new JLabel();
        JLabel productQtt = new JLabel();
        productDiver.setPreferredSize(new Dimension(300, 20));
        productMontant.setPreferredSize(new Dimension(120, 20));
        productQtt.setPreferredSize(new Dimension(360, 20));
        productDiver.setText("NOMBRE PRODUIT VENDUS");
        productMontant.setText(Formats.CURRENCY.formatValue(this.turnover));
        productQtt.setText(Formats.INT.formatValue(this.allProduct));
        panelDiversProducts.add(productDiver);
        panelDiversProducts.add(productMontant);
        panelDiversProducts.add(productQtt);
        this.panelClose.add(panelDiversProducts);
        this.separator5 = new JSeparator();
        this.separator5.setPreferredSize(new Dimension(800, 2));
        this.panelClose.add(this.separator5);
        if (periodeGlobal != null) {
            JPanel panelEquipementTitle = new JPanel();
            panelEquipementTitle.setLayout(new FlowLayout(0));
            panelEquipementTitle.setPreferredSize(new Dimension(800, 25));
            JLabel titleEquipement = new JLabel();
            JLabel titleTurnoverEquipement = new JLabel();
            titleEquipement.setPreferredSize(new Dimension(300, 25));
            titleTurnoverEquipement.setPreferredSize(new Dimension(240, 25));
            titleEquipement.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleTurnoverEquipement.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleEquipement.setText("Equipement");
            titleTurnoverEquipement.setText("Chiffre d'affaires");
            panelEquipementTitle.add(titleEquipement);
            panelEquipementTitle.add(titleTurnoverEquipement);
            this.panelClose.add(panelEquipementTitle);
            for (ZHostNameDTO mZHostNameDTO : periodeGlobal.getZ_host_name()) {
                JPanel panelEquipement = new JPanel();
                panelEquipement.setLayout(new FlowLayout(0));
                panelEquipement.setPreferredSize(new Dimension(800, 25));
                JLabel labelEquipement = new JLabel();
                labelEquipement.setText(mZHostNameDTO.getHost_name());
                labelEquipement.setPreferredSize(new Dimension(300, 25));
                JPanel panelTurnoverEquipement = new JPanel();
                panelTurnoverEquipement.setLayout(new GridLayout(1, 0, 5, 0));
                panelTurnoverEquipement.setPreferredSize(new Dimension(240, 25));
                JLabel labelTurnoverEquipement = new JLabel();
                labelTurnoverEquipement.setText(Formats.CURRENCY.formatValue(mZHostNameDTO.getTotal()));
                panelTurnoverEquipement.add(labelTurnoverEquipement);
                panelEquipement.add(labelEquipement);
                panelEquipement.add(panelTurnoverEquipement);
                this.panelClose.add(panelEquipement);
            }
        }
        this.panelClose.revalidate();
        this.panelClose.repaint();
    }

    private void initComponents() {
        this.jPanelPrint = new JPanel();
        this.jBtnPrint = new JButton();
        this.jBtnPrintSynthese = new JButton();
        this.jBtnPrintOperations = new JButton();
        this.jBtnPrintPayments = new JButton();
        this.jBtnExportTurnoverExcel = new JButton();
        this.jBtnZCaisse = new JButton();
        this.jPanelFirst = new JPanel();
        this.paneMonth = new JPanel();
        this.jComboYear = new JComboBox();
        this.jComboMonth = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Impression");
        this.jPanelPrint.setPreferredSize(new Dimension(10, 50));
        this.jPanelPrint.setLayout(new GridLayout(1, 0, 5, 0));
        this.jBtnPrint.setBackground(new Color(42, 187, 155));
        this.jBtnPrint.setText("Rapport Financier");
        this.jBtnPrint.setFocusPainted(false);
        this.jBtnPrint.setFocusable(false);
        this.jBtnPrint.setRequestFocusEnabled(false);
        this.jBtnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnPrintActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnPrint);
        this.jBtnPrintSynthese.setBackground(new Color(42, 187, 155));
        this.jBtnPrintSynthese.setText("Journal de Synth\u00e8se");
        this.jBtnPrintSynthese.setFocusPainted(false);
        this.jBtnPrintSynthese.setFocusable(false);
        this.jBtnPrintSynthese.setRequestFocusEnabled(false);
        this.jBtnPrintSynthese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnPrintSyntheseActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnPrintSynthese);
        this.jBtnPrintOperations.setBackground(new Color(42, 187, 155));
        this.jBtnPrintOperations.setText("Journal des op\u00e9rations");
        this.jBtnPrintOperations.setFocusPainted(false);
        this.jBtnPrintOperations.setFocusable(false);
        this.jBtnPrintOperations.setRequestFocusEnabled(false);
        this.jBtnPrintOperations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnPrintOperationsActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnPrintOperations);
        this.jBtnPrintPayments.setBackground(new Color(42, 187, 155));
        this.jBtnPrintPayments.setText("Journal des paiements");
        this.jBtnPrintPayments.setFocusPainted(false);
        this.jBtnPrintPayments.setFocusable(false);
        this.jBtnPrintPayments.setRequestFocusEnabled(false);
        this.jBtnPrintPayments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnPrintPaymentsActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnPrintPayments);
        this.jBtnExportTurnoverExcel.setBackground(new Color(42, 187, 155));
        this.jBtnExportTurnoverExcel.setText("Exporter le CA en Excel");
        this.jBtnExportTurnoverExcel.setFocusPainted(false);
        this.jBtnExportTurnoverExcel.setFocusable(false);
        this.jBtnExportTurnoverExcel.setRequestFocusEnabled(false);
        this.jBtnExportTurnoverExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnExportTurnoverExcelActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnExportTurnoverExcel);
        this.jBtnZCaisse.setBackground(new Color(42, 187, 155));
        this.jBtnZCaisse.setText("Z Caisse");
        this.jBtnZCaisse.setFocusPainted(false);
        this.jBtnZCaisse.setFocusable(false);
        this.jBtnZCaisse.setRequestFocusEnabled(false);
        this.jBtnZCaisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jBtnZCaisseActionPerformed(evt);
            }
        });
        this.jPanelPrint.add(this.jBtnZCaisse);
        this.getContentPane().add((Component)this.jPanelPrint, "South");
        this.jPanelFirst.setPreferredSize(new Dimension(50, 40));
        this.jPanelFirst.setLayout(new BorderLayout());
        this.paneMonth.setLayout(new FlowLayout(2));
        this.jComboYear.setPreferredSize(new Dimension(100, 30));
        this.jComboYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jComboYearActionPerformed(evt);
            }
        });
        this.paneMonth.add(this.jComboYear);
        this.jComboMonth.setPreferredSize(new Dimension(100, 30));
        this.jComboMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXCaisse.this.jComboMonthActionPerformed(evt);
            }
        });
        this.paneMonth.add(this.jComboMonth);
        this.jPanelFirst.add((Component)this.paneMonth, "Center");
        this.getContentPane().add((Component)this.jPanelFirst, "First");
        this.setSize(new Dimension(1000, 500));
        this.setLocationRelativeTo(null);
    }

    private void jBtnPrintActionPerformed(ActionEvent evt) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (currentperiodeGlobal != null) {
                        Decreaser decreaser = new Decreaser(JXCaisse.this.dlSales, JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd), "Rapport de caisse: " + JXCaisse.this.title, null, new Integer(JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd)));
                        String rapport_title = currentperiodeGlobal.getRapport_title() != null ? currentperiodeGlobal.getRapport_title() : JXCaisse.this.RAPPORT_TITLE_Z_GLOBAL;
                        new PrinterHelper().printCloseCaisseGlobal(currentperiodeGlobal, JXCaisse.this.marqueNF, JXCaisse.this.dateStart, JXCaisse.this.dateEnd, rapport_title, decreaser, currentperiodeGlobal.getType_periode(), AppLocal.NUMBER_PRINT_Z);
                    } else {
                        ZGlobalInfoDTO periodeGlobal;
                        if (grandTotalPeriode == null || !grandTotalPeriode.isInsert_ficancial_infos()) {
                            JXCaisse.this.totalDiscount = JXCaisse.this.dlStats.getTotalDiscountOrderOfType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd, "pourcentage") + JXCaisse.this.dlStats.getTotalDiscountOrderOfType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd, "somme");
                            JXCaisse.this.totalDiscountOnLines = JXCaisse.this.dlStats.getTotalDiscountOnTicketLines(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                            JXCaisse.this.dataTypeOrders = JXCaisse.this.dlStats.loadSatisticOrderByType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                            JXCaisse.this.dataTypePlatformOrders = JXCaisse.this.dlStats.loadPlatformOrdersByType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                        }
                        Decreaser decreaser = new Decreaser(JXCaisse.this.dlSales, JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd), "Rapport de caisse: " + JXCaisse.this.title, null, new Integer(JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd)));
                        new PrinterHelper().printCloseCaisseCenter(JXCaisse.this.m_iSales, JXCaisse.this.turnover, null, JXCaisse.this.caCanceled, JXCaisse.this.totalTaxes, JXCaisse.this.payments, JXCaisse.this.allTaxes, JXCaisse.this.users, JXCaisse.this.caisse, JXCaisse.this.marqueNF, JXCaisse.this.dateStart, JXCaisse.this.dateEnd, JXCaisse.this.title, JXCaisse.this.totalDiscount, JXCaisse.this.totalDiscountOnLines, caisseZ, JXCaisse.this.ordersCanceled, null, JXCaisse.this.dataTypeOrders, decreaser, JXCaisse.this.xType, JXCaisse.this.notesCanceled, JXCaisse.this.dataTypePlatformOrders, JXCaisse.this.groupedTaxes, JXCaisse.this.total_ht_taxable, JXCaisse.this.total_ht_no_taxable);
                        if (grandTotalPeriode != null && (periodeGlobal = JXCaisse.this.mZGlobalService.getZglobal(grandTotalPeriode.getId(), equipements_address)) != null) {
                            new PrinterHelper().printCloseCaisseGlobal(periodeGlobal, JXCaisse.this.marqueNF, JXCaisse.this.dateStart, JXCaisse.this.dateEnd, JXCaisse.this.RAPPORT_TITLE_Z_GLOBAL, decreaser, grandTotalPeriode.getTypePeriode(), AppLocal.NUMBER_PRINT_Z);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void jComboYearActionPerformed(ActionEvent evt) {
        if (!this.firstTime) {
            MonthInfo monthInfo = (MonthInfo)this.jComboMonth.getSelectedItem();
            this.year = (Integer)this.jComboYear.getSelectedItem();
            if (monthInfo != null && this.year != -1) {
                this.month = monthInfo.getId();
                try {
                    this.load(null, "month", null);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    private void jComboMonthActionPerformed(ActionEvent evt) {
        if (!this.firstTime) {
            MonthInfo monthInfo = (MonthInfo)this.jComboMonth.getSelectedItem();
            this.year = (Integer)this.jComboYear.getSelectedItem();
            if (monthInfo != null && this.year > 0) {
                this.month = monthInfo.getId();
                try {
                    this.load(null, "month", null);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    private void changeYear() {
        if (!this.firstTime) {
            Integer myYear = (Integer)this.jComboYear.getSelectedItem();
            if (this.year > 0) {
                this.year = myYear;
                try {
                    this.load(null, "a", null);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    private void jBtnPrintSyntheseActionPerformed(ActionEvent evt) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                List<RankCategory> m_resultCategories = null;
                List<RankProductDiver> itemsDivers = null;
                try {
                    itemsDivers = JXCaisse.this.dlStats.getRankItemDivers(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                    m_resultCategories = JXCaisse.this.dlStats.getRankCategories(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                    for (RankCategory m_resultCategory : m_resultCategories) {
                        m_resultCategory.setRankProducts(JXCaisse.this.dlStats.getRankItems(JXCaisse.this.dateStart, JXCaisse.this.dateEnd, m_resultCategory.getId()));
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                try {
                    Double totalDiscount = JXCaisse.this.dlStats.getTotalDiscountOrderOfType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd, "pourcentage") + JXCaisse.this.dlStats.getTotalDiscountOrderOfType(JXCaisse.this.dateStart, JXCaisse.this.dateEnd, "somme");
                    Double totalDiscountOnLines = JXCaisse.this.dlStats.getTotalDiscountOnTicketLines(JXCaisse.this.dateStart, JXCaisse.this.dateEnd);
                    Decreaser decreaser = new Decreaser(JXCaisse.this.dlSales, JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd), "Rapport de Synthese: " + JXCaisse.this.title, null, new Integer(JXCaisse.this.dateFormatterInversed.format(JXCaisse.this.dateEnd)));
                    new PrinterHelper().printSynthesCaisse(JXCaisse.this.unit, JXCaisse.this.salesByUnit, m_resultCategories, itemsDivers, JXCaisse.this.turnover, JXCaisse.this.caCanceled, JXCaisse.this.totalTaxes, JXCaisse.this.payments, JXCaisse.this.allTaxes, JXCaisse.this.users, JXCaisse.this.caisse, JXCaisse.this.marqueNF, JXCaisse.this.dateStart, JXCaisse.this.dateEnd, totalDiscount, totalDiscountOnLines, decreaser);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void jBtnPrintOperationsActionPerformed(ActionEvent evt) {
        if (!this.jBtnPrintOperations.getText().contains("Confirmer")) {
            this.panelClose.removeAll();
            JPanel panelHeader = new JPanel();
            this.remove(this.jPanelFirst);
            panelHeader.setPreferredSize(new Dimension(800, 20));
            this.panelClose.add(panelHeader);
            this.labelTitle = new JLabel();
            this.labelTitle.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            this.labelTitle.setText(" les types des operations du Journal ");
            panelHeader.add(this.labelTitle);
            JPanel salesPanel = new JPanel();
            salesPanel.setPreferredSize(new Dimension(800, 30));
            salesPanel.setLayout(new FlowLayout(0));
            JPanel refundsPanel = new JPanel();
            refundsPanel.setPreferredSize(new Dimension(800, 30));
            refundsPanel.setLayout(new FlowLayout(0));
            JPanel canselsPanel = new JPanel();
            canselsPanel.setPreferredSize(new Dimension(800, 30));
            canselsPanel.setLayout(new FlowLayout(0));
            this.checkSales = new JCheckBox();
            this.checkSales.setText("Ventes");
            this.checkCanceled = new JCheckBox();
            this.checkCanceled.setText("Annulations");
            this.checkRefund = new JCheckBox();
            this.checkRefund.setText("Remboursements");
            this.checkRefund.setSelected(true);
            salesPanel.add(this.checkSales);
            canselsPanel.add(this.checkCanceled);
            refundsPanel.add(this.checkRefund);
            this.jBtnPrintOperations.setText("Confirmer l'impression des operations s\u00e9lectionn\u00e9s ");
            this.jPanelPrint.removeAll();
            this.jPanelPrint.add(this.jBtnPrintOperations);
            this.panelClose.add(salesPanel);
            this.panelClose.add(canselsPanel);
            this.panelClose.add(refundsPanel);
            ItemListener listenercheack = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    JXCaisse.this.changeButtonStatus();
                }
            };
            this.checkSales.addItemListener(listenercheack);
            this.checkCanceled.addItemListener(listenercheack);
            this.checkRefund.addItemListener(listenercheack);
            this.panelClose.repaint();
            this.panelClose.revalidate();
        } else if (this.checkCanceled.isSelected() || this.checkRefund.isSelected() || this.checkSales.isSelected()) {
            try {
                List<TicketInfo> allTicketZCaisse = this.dlSales.loadAllTicket(this.dateStart, this.dateEnd, this.checkSales.isSelected(), this.checkCanceled.isSelected(), this.checkRefund.isSelected(), false);
                PrinterHelper printer = new PrinterHelper();
                int nbCaceled = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "cancel");
                int nbSales = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "paid");
                int nbRefund = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "Refund");
                printer.printOperationsCaisse(allTicketZCaisse, this.dateStart, this.dateEnd, this.marqueNF, this.turnover, this.caCanceled, nbCaceled, nbSales, nbRefund, null);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "veuillez s\u00e9lectionner au moin un type d'op\u00e9ration ", 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    private void jBtnExportTurnoverExcelActionPerformed(ActionEvent evt) {
        ExportGeneratorHelper mEGH = new ExportGeneratorHelper(this.dateStart, this.dateEnd);
        mEGH.setDlStats(this.dlStats);
        mEGH.setDlSales(this.dlSales);
        mEGH.setTotal(this.turnover);
        mEGH.setNbOrders(this.m_iSales);
        mEGH.setTaxes(this.allTaxes);
        mEGH.setPayments(this.payments);
        mEGH.setzPeriod(this.period_value);
        mEGH.setMarqueNFC(this.marqueNF);
        mEGH.setGroupedTaxes(this.groupedTaxes);
        IZDetail zDetail = null;
        boolean showDetailTurnover = false;
        boolean showPeriode = false;
        if (grandTotalPeriode != null) {
            if (grandTotalPeriode.getTypePeriode().equals("m")) {
                try {
                    List<GrandTotalPeriode> grandTotauxJournalier = this.dlSales.getGrandTotauxJournalier(grandTotalPeriode.getId());
                    grandTotalPeriode.setGrandTotauxJournalier(grandTotauxJournalier);
                    mEGH.setGrandTotalPeriode(grandTotalPeriode);
                    zDetail = new ZMonthDetail(grandTotalPeriode);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else if (grandTotalPeriode.getTypePeriode().equals("j")) {
                zDetail = new ZDayDetail(this.dlSales, this.dlStats);
            }
            showDetailTurnover = true;
        }
        if (currentperiodeGlobal != null) {
            if (currentperiodeGlobal.getType_periode().equals("m")) {
                this.mZGlobalService = ZGlobalService.getInstance();
                System.out.println("+++++ equipements_address : " + equipements_address);
                List<ZGlobalInfoDTO> zGlobalDaily = this.mZGlobalService.getZglobal(currentperiodeGlobal.getId_periode(), "j", equipements_address);
                currentperiodeGlobal.setzGloablDaily(zGlobalDaily);
                zDetail = new ZGlobalDetail(currentperiodeGlobal);
                showDetailTurnover = true;
            }
            mEGH.setZ_hosts_name(currentperiodeGlobal.getZ_host_name());
        }
        if (grandTotalPeriode == null && currentperiodeGlobal == null) {
            zDetail = new ZDayDetail(this.dlSales, this.dlStats);
            showDetailTurnover = true;
        }
        mEGH.setzDetail(zDetail);
        ExportTurnoverExcel mExportTurnoverExcel = new ExportTurnoverExcel();
        mExportTurnoverExcel.setComponentParent(null);
        Object fileName = this.mDialogTitle;
        Boolean izForZCaisse = false;
        if (this.xType != null) {
            switch (this.xType) {
                case "j": 
                case "day": 
                case "caisse": {
                    izForZCaisse = true;
                    fileName = (String)fileName + " (" + DateUtils.formatDate(this.dateStart) + ")";
                    break;
                }
                case "m": 
                case "month": {
                    fileName = (String)fileName + " (" + DateUtils.formatMonth(this.dateStart) + " " + DateUtils.formatYear(this.dateStart) + ")";
                    break;
                }
                case "a": {
                    fileName = (String)fileName + " (" + DateUtils.formatYear(this.dateStart) + ")";
                }
            }
        } else if (currentperiodeGlobal != null) {
            fileName = currentperiodeGlobal.getType_periode().equals("m") ? (String)fileName + " (" + DateUtils.formatMonth(this.dateStart) + " " + DateUtils.formatYear(this.dateStart) + ")" : (String)fileName + " (" + DateUtils.formatDate(this.dateStart) + ")";
        } else {
            showPeriode = true;
            izForZCaisse = true;
            fileName = (String)fileName + " (" + DateUtils.formatDate(this.dateStart) + ")";
        }
        fileName = (String)fileName + ".xlsx";
        mEGH.setIsForClosedCaisse(izForZCaisse);
        mExportTurnoverExcel.setFileName((String)fileName);
        mExportTurnoverExcel.setShowDetailTurnover(showDetailTurnover);
        mExportTurnoverExcel.setShowPeriode(showPeriode);
        String $result = mExportTurnoverExcel.export(mEGH, true);
        if ($result != null && !$result.equals("canceled")) {
            try {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les donn\u00e9es on \u00e9t\u00e9 export\u00e9 avec succ\u00e8s !", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void jBtnPrintPaymentsActionPerformed(ActionEvent evt) {
        this.printJournalPayments();
    }

    private void jBtnZCaisseActionPerformed(ActionEvent evt) {
        this.exportZfile();
    }

    private void changeButtonStatus() {
        if (!(this.checkCanceled.isSelected() || this.checkRefund.isSelected() || this.checkSales.isSelected())) {
            this.jBtnPrintOperations.setEnabled(false);
        } else {
            this.jBtnPrintOperations.setEnabled(true);
        }
    }

    private void printJournalPayments() {
        try {
            List<TicketInfo> allTicketZCaisse = this.dlSales.loadAllTicket(this.dateStart, this.dateEnd, true, false, false, true);
            PrinterHelper printer = new PrinterHelper();
            int nbCaceled = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "cancel");
            int nbSales = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "paid");
            int nbRefund = this.dlSales.getNbOrderByStatus(this.dateStart, this.dateEnd, "Refund");
            printer.printPayments(allTicketZCaisse, this.dateStart, this.dateEnd, this.marqueNF, this.turnover, this.caCanceled, nbCaceled, nbSales, nbRefund, null);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    private void loadFinancialReportInfo() throws BasicException {
        this.payments = grandTotalPeriode.getPayments();
        this.m_iSales = grandTotalPeriode.getNumber_orders();
        this.caCanceled = grandTotalPeriode.getTurnover_canceled();
        this.allProduct = grandTotalPeriode.getNumber_products_sold();
        this.allTaxes = grandTotalPeriode.getTaxes();
        this.turnover = grandTotalPeriode.getCumul();
        this.totalDiscount = grandTotalPeriode.getTotal_discount();
        this.totalDiscountOnLines = grandTotalPeriode.getTotal_discount_lines();
        this.dataTypeOrders = grandTotalPeriode.getTypeOrders();
        this.groupedTaxes = grandTotalPeriode.getGtpTaxes();
        this.total_ht_taxable = grandTotalPeriode.getTotal_ht_taxable();
        this.total_ht_no_taxable = grandTotalPeriode.getTotal_ht_no_taxable();
        this.turnover_deliveroo = grandTotalPeriode.getTotal_orders_deliveroo();
        this.turnover_ubereat = grandTotalPeriode.getTurnover_ubereat();
        this.ordersCanceled = this.dlSales.loadTicketCanceled(this.dateStart, this.dateEnd);
        this.notesCanceled = this.dlSales.loadNotesCanceled(this.dateStart, this.dateEnd);
        this.dataTypePlatformOrders = grandTotalPeriode.getTypePlatformOrders();
    }

    private void exportZfile() {
        Object fileName = this.mDialogTitle;
        if (grandTotalPeriode == null || !grandTotalPeriode.isInsert_ficancial_infos()) {
            try {
                this.dataTypeOrders = this.dlStats.loadSatisticOrderByType(this.dateStart, this.dateEnd);
            }
            catch (BasicException ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        }
        if (this.xType != null) {
            switch (this.xType) {
                case "j": 
                case "day": 
                case "caisse": {
                    fileName = (String)fileName + " (" + DateUtils.formatDate(this.dateStart) + ")";
                    break;
                }
                case "m": 
                case "month": {
                    fileName = (String)fileName + " (" + DateUtils.formatMonth(this.dateStart) + " " + DateUtils.formatYear(this.dateStart) + ")";
                    break;
                }
                case "a": {
                    fileName = (String)fileName + " (" + DateUtils.formatYear(this.dateStart) + ")";
                }
            }
        } else {
            fileName = (String)fileName + " (" + DateUtils.formatDate(this.dateStart) + ")";
        }
        fileName = (String)fileName + ".txt";
        ExportZFileHelper mExportZFileHelper = new ExportZFileHelper(this.turnover, this.m_iSales, this.payments, this.allTaxes, this.dataTypeOrders, this.period_value, (String)fileName);
        mExportZFileHelper.export();
    }
}

