/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.SALLEINFO;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class JPanelTable
extends JPanel
implements ListSelectionListener,
JPanelView,
BeanFactoryApp {
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    protected DataLogicSales dlSales;
    private String type;
    private List<TableInfo> tables;
    private List<TableInfo> tablesDB;
    private List<TableInfo> allTables;
    private List<SALLEINFO> salles;
    private SALLEINFO salleCurrent;
    private int counter;
    private TicketInfo currentTicket;
    private boolean cancel;
    private boolean transfert;
    protected DataLogicAdmin dlUsers;
    protected DefaultTableModel modelDetail;
    protected List<PrinterInfo> printers;
    private int bornInfX;
    private int bornInfY;
    private int bornSupX;
    private int bornSupY;
    private JLabel labelPersonne;
    private JLabel labelNumero;
    private JButton add;
    private JButton bar;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelMain;
    private JPanel jPanelOutils;
    private JPanel jPanelRight;
    private JPanel jPanelSalle;
    private JPanel jPanelSallesOrder;
    private JPanel jPanelTables;
    private JPanel jPanelTitle;
    private JButton jPlante;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextSalle;
    private JButton jcomptoir;
    private JList m_jListSalles;
    private JButton removeSalle;
    private JButton save;
    private JButton table;

    public JPanelTable() {
        this.initComponents();
        this.jPanelTitle.setLayout(new FlowLayout(0));
        this.jPanel2.setLayout(new FlowLayout(2));
        this.type = null;
        this.tables = new ArrayList<TableInfo>();
        this.jPanelRight.removeAll();
        this.jPanelRight.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.setVisible(true);
        this.jPanelRight.revalidate();
        this.jPanelRight.repaint();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlUsers = (DataLogicAdmin)this.m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.salles = new ArrayList<SALLEINFO>();
        this.tables = new ArrayList<TableInfo>();
        this.tablesDB = new ArrayList<TableInfo>();
        this.allTables = new ArrayList<TableInfo>();
        this.printers = new ArrayList<PrinterInfo>();
        this.salleCurrent = null;
        this.currentTicket = null;
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        this.cancel = this.dlUsers.hasPermission(this.m_App.getAppUserView().getUser().getId(), "3");
        this.transfert = this.dlUsers.hasPermission(this.m_App.getAppUserView().getUser().getId(), "4");
        this.loadCatalog();
        this.m_jListSalles.setSelectedIndex(0);
        this.jPanelOutils.setVisible(true);
        this.jPanel2.setVisible(true);
        this.jLabel1.setVisible(true);
        this.add.setVisible(true);
        this.jLabelTitle.setText("Gestion Plan Restaurant");
        this.initBorns();
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        if (AppLocal.chooseTable.booleanValue()) {
            return "Plan restaurant";
        }
        return "Gestion Plan restaurant";
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        int i;
        if (!lse.getValueIsAdjusting() && (i = this.m_jListSalles.getSelectedIndex()) >= 0) {
            Rectangle oRect = this.m_jListSalles.getCellBounds(i, i);
            this.m_jListSalles.scrollRectToVisible(oRect);
        }
    }

    public void loadTables() {
        this.jPanelTables.removeAll();
        for (final TableInfo table1 : this.tables) {
            final JPanel panel = new JPanel();
            switch (table1.getType()) {
                case "rectangle": {
                    JPanel panelTable = new JPanel();
                    panel.setLayout(new FlowLayout());
                    panelTable.setLayout(new BorderLayout());
                    this.labelPersonne = new JLabel(String.valueOf(table1.getNumber_person()) + "P");
                    this.labelNumero = new JLabel(String.valueOf(table1.getNumber()));
                    this.labelNumero.setHorizontalAlignment(0);
                    panelTable.add((Component)this.labelNumero, "Center");
                    panelTable.setBackground(Color.WHITE);
                    panelTable.setPreferredSize(new Dimension(50, 30));
                    this.labelPersonne.setPreferredSize(new Dimension(50, 10));
                    panel.add(this.labelPersonne);
                    panel.add(panelTable);
                    break;
                }
                case "cercle": {
                    Surface panelBar = new Surface();
                    panel.setLayout(new FlowLayout(1));
                    panelBar.setLayout(new BorderLayout());
                    this.labelPersonne = new JLabel(String.valueOf(table1.getNumber_person()) + "P");
                    this.labelNumero = new JLabel(String.valueOf(table1.getNumber()));
                    this.labelNumero.setHorizontalAlignment(0);
                    panelBar.add((Component)this.labelNumero, "Center");
                    panelBar.setPreferredSize(new Dimension(30, 30));
                    this.labelPersonne.setPreferredSize(new Dimension(50, 10));
                    if (!table1.isAvailable()) {
                        panelBar.setBackground(Color.RED);
                    } else {
                        panelBar.setBackground(new Color(154, 205, 50));
                    }
                    panel.add(this.labelPersonne);
                    panel.add(panelBar);
                    break;
                }
                case "comptoir": {
                    panel.setBorder(BorderFactory.createLineBorder(new Color(222, 184, 135)));
                    panel.setBackground(new Color(222, 184, 135));
                    break;
                }
                case "plante": {
                    JLabel label = new JLabel();
                    label.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/plante.png")));
                    panel.setLayout(new BorderLayout());
                    panel.add((Component)label, "Center");
                }
            }
            if (table1.getType().equals("rectangle") || table1.getType().equals("cercle")) {
                panel.setBorder(BorderFactory.createLineBorder(new Color(154, 205, 50)));
                if (!table1.isAvailable()) {
                    panel.setBackground(Color.RED);
                } else {
                    panel.setBackground(new Color(154, 205, 50));
                }
            }
            this.jPanelTables.add(panel);
            panel.setBounds(table1.getX(), table1.getY(), 60, 60);
            if (table1.isAvailable()) {
                panel.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseDragged(MouseEvent me) {
                        JPanelTable.this.dragTable(table1, me, panel);
                    }
                });
            }
            panel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 1) {
                        if (table1.getType().equals("rectangle") || table1.getType().equals("cercle")) {
                            if (table1.isAvailable()) {
                                JPanelTable.this.loadPopUpMAJ(table1, JPanelTable.this.labelPersonne, JPanelTable.this.labelNumero);
                            }
                        } else {
                            JPanelTable.this.deleteAccessoir(table1);
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }
            });
        }
        this.jPanelTables.validate();
        this.jPanelTables.repaint();
    }

    public void loadCatalog() throws BasicException {
        this.type = null;
        this.jPanelTables.removeAll();
        this.salles = this.dlSales.getSalles();
        this.m_jListSalles.setCellRenderer(new SmallSalleRenderer());
        this.m_jListSalles.setModel(new SallesListModel(this.salles));
        if (this.m_jListSalles.getModel().getSize() == 0) {
            this.salleCurrent = null;
        }
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jPanelOutils = new JPanel();
        this.table = new JButton();
        this.bar = new JButton();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButton1 = new JButton();
        this.jcomptoir = new JButton();
        this.jPlante = new JButton();
        this.jPanelSalle = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextSalle = new JTextField();
        this.save = new JButton();
        this.jPanelTables = new JPanel();
        this.jPanelSallesOrder = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.add = new JButton();
        this.removeSalle = new JButton();
        this.jPanelRight = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.m_jListSalles = new JList();
        this.jPanelTitle = new JPanel();
        this.jLabelTitle = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelMain.setLayout(new BorderLayout());
        this.jPanelOutils.setBorder(BorderFactory.createLineBorder(new Color(0, 153, 255)));
        this.jPanelOutils.setPreferredSize(new Dimension(110, 0));
        this.jPanelOutils.setLayout((LayoutManager)new AbsoluteLayout());
        this.table.setBackground(new Color(218, 223, 225));
        this.table.setText("Table");
        this.table.setFocusPainted(false);
        this.table.setPreferredSize(new Dimension(75, 22));
        this.table.setRequestFocusEnabled(false);
        this.table.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.tableActionPerformed(evt);
            }
        });
        this.jPanelOutils.add((Component)this.table, new AbsoluteConstraints(10, 100, 90, 30));
        this.bar.setBackground(new Color(218, 223, 225));
        this.bar.setText("Bar");
        this.bar.setFocusPainted(false);
        this.bar.setPreferredSize(new Dimension(75, 22));
        this.bar.setRequestFocusEnabled(false);
        this.bar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.barActionPerformed(evt);
            }
        });
        this.jPanelOutils.add((Component)this.bar, new AbsoluteConstraints(10, 140, 90, 30));
        this.jLabel2.setText("Outils");
        this.jPanelOutils.add((Component)this.jLabel2, new AbsoluteConstraints(20, 20, -1, -1));
        this.jPanelOutils.add((Component)this.jSeparator1, new AbsoluteConstraints(10, 40, 80, 10));
        this.jButton1.setBackground(new Color(218, 223, 225));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/refresh.png")));
        this.jButton1.setFocusPainted(false);
        this.jButton1.setPreferredSize(new Dimension(75, 36));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanelOutils.add((Component)this.jButton1, new AbsoluteConstraints(10, 60, 90, 30));
        this.jcomptoir.setBackground(new Color(218, 223, 225));
        this.jcomptoir.setText("comptoir");
        this.jcomptoir.setFocusPainted(false);
        this.jcomptoir.setPreferredSize(new Dimension(75, 23));
        this.jcomptoir.setRequestFocusEnabled(false);
        this.jcomptoir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.jcomptoirActionPerformed(evt);
            }
        });
        this.jPanelOutils.add((Component)this.jcomptoir, new AbsoluteConstraints(10, 180, 90, 30));
        this.jPlante.setBackground(new Color(218, 223, 225));
        this.jPlante.setText("Plante");
        this.jPlante.setFocusPainted(false);
        this.jPlante.setPreferredSize(new Dimension(75, 23));
        this.jPlante.setRequestFocusEnabled(false);
        this.jPlante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.jPlanteActionPerformed(evt);
            }
        });
        this.jPanelOutils.add((Component)this.jPlante, new AbsoluteConstraints(10, 220, 90, 30));
        this.jPanelMain.add((Component)this.jPanelOutils, "Before");
        this.jPanelSalle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelTable.this.jPanelSalleMouseClicked(evt);
            }
        });
        this.jPanelSalle.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(10, 50));
        this.jTextSalle.setPreferredSize(new Dimension(200, 40));
        this.jTextSalle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.jTextSalleActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jTextSalle);
        this.save.setBackground(new Color(218, 223, 225));
        this.save.setText("Sauvegarder");
        this.save.setFocusable(false);
        this.save.setPreferredSize(new Dimension(110, 40));
        this.save.setRequestFocusEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.saveActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.save);
        this.jPanelSalle.add((Component)this.jPanel2, "First");
        this.jPanelTables.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelTables.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelTable.this.jPanelTablesMouseClicked(evt);
            }
        });
        this.jPanelTables.setLayout(null);
        this.jPanelSalle.add((Component)this.jPanelTables, "Center");
        this.jPanelMain.add((Component)this.jPanelSalle, "Center");
        this.jPanelSallesOrder.setPreferredSize(new Dimension(200, 10));
        this.jPanelSallesOrder.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 50));
        this.jPanel1.setPreferredSize(new Dimension(10, 50));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Les salles");
        this.jPanel1.add(this.jLabel1);
        this.add.setBackground(new Color(218, 223, 225));
        this.add.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/add.png")));
        this.add.setFocusPainted(false);
        this.add.setPreferredSize(new Dimension(40, 40));
        this.add.setRequestFocusEnabled(false);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.addActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.add);
        this.removeSalle.setBackground(new Color(218, 223, 225));
        this.removeSalle.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/iconDelete.png")));
        this.removeSalle.setFocusPainted(false);
        this.removeSalle.setPreferredSize(new Dimension(40, 40));
        this.removeSalle.setRequestFocusEnabled(false);
        this.removeSalle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelTable.this.removeSalleActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.removeSalle);
        this.jPanelSallesOrder.add((Component)this.jPanel1, "First");
        this.jPanelRight.setLayout(new BorderLayout());
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.m_jListSalles.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jListSalles.setSelectionMode(0);
        this.m_jListSalles.setFocusable(false);
        this.m_jListSalles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JPanelTable.this.m_jListSallesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.m_jListSalles);
        this.jPanelRight.add((Component)this.jScrollPane1, "Center");
        this.jPanelSallesOrder.add((Component)this.jPanelRight, "Center");
        this.jPanelMain.add((Component)this.jPanelSallesOrder, "After");
        this.add((Component)this.jPanelMain, "Center");
        this.jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        this.jPanelTitle.setPreferredSize(new Dimension(10, 50));
        this.jLabelTitle.setFont(new Font("Tahoma", 1, 14));
        this.jLabelTitle.setPreferredSize(new Dimension(200, 30));
        this.jPanelTitle.add(this.jLabelTitle);
        this.add((Component)this.jPanelTitle, "First");
    }

    private void tableActionPerformed(ActionEvent evt) {
        this.type = "rectangle";
    }

    private void barActionPerformed(ActionEvent evt) {
        this.type = "cercle";
    }

    private void jPanelSalleMouseClicked(MouseEvent evt) {
    }

    private void m_jListSallesValueChanged(ListSelectionEvent evt) {
        SALLEINFO salle;
        if (!evt.getValueIsAdjusting() && (salle = (SALLEINFO)this.m_jListSalles.getSelectedValue()) != null) {
            this.salleCurrent = salle;
            this.jTextSalle.setText(salle.getName());
            this.jTextSalle.setForeground(Color.BLACK);
            try {
                this.tablesDB = this.dlSales.getTablesBySalle(salle.getId());
                this.allTables = this.dlSales.getTables();
                this.counter = this.allTables.size() > 0 ? this.allTables.get(this.allTables.size() - 1).getNumber() : 0;
                ++this.counter;
                this.tables = this.tablesDB;
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
            this.loadTables();
            this.type = null;
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        this.salleCurrent = null;
        this.jTextSalle.setText("");
        this.tables.clear();
        this.loadTables();
    }

    private void jPanelTablesMouseClicked(MouseEvent evt) {
        if (this.type != null) {
            switch (this.type) {
                case "rectangle": {
                    this.tables.add(new TableInfo(-1, this.counter, "rectangle", 0, evt.getX(), evt.getY(), true, 1));
                    this.loadTables();
                    break;
                }
                case "cercle": {
                    this.tables.add(new TableInfo(-1, this.counter, "cercle", 0, evt.getX(), evt.getY(), true, 1));
                    this.loadTables();
                    break;
                }
                case "comptoir": {
                    this.tables.add(new TableInfo(-1, this.counter, "comptoir", 0, evt.getX(), evt.getY(), true, 1));
                    this.loadTables();
                    break;
                }
                case "plante": {
                    this.tables.add(new TableInfo(-1, this.counter, "plante", 0, evt.getX(), evt.getY(), true, 1));
                    this.loadTables();
                }
            }
            ++this.counter;
        }
    }

    private void saveActionPerformed(ActionEvent evt) {
        int index = this.m_jListSalles.getSelectedIndex();
        if (!this.jTextSalle.getText().isEmpty()) {
            if (this.salleCurrent == null) {
                SALLEINFO salle = new SALLEINFO();
                salle.setName(this.jTextSalle.getText());
                try {
                    this.dlSales.addSalle(salle, this.tables);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Votre salle a \u00e9t\u00e9 cr\u00e9e avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                    this.loadCatalog();
                }
                catch (BasicException | SQLException ex) {
                    LogToFile.log("severe", null, ex);
                }
            } else {
                this.salleCurrent.setName(this.jTextSalle.getText());
                try {
                    this.dlSales.updateSalle(this.salleCurrent, this.tables);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La salle a \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                    this.loadCatalog();
                    this.m_jListSalles.setSelectedIndex(index);
                }
                catch (BasicException | SQLException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        } else {
            new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, "Merci de saisir le nom de la Salle.", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    private void jTextSalleActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.type = null;
    }

    private void jcomptoirActionPerformed(ActionEvent evt) {
        this.type = "comptoir";
    }

    private void jPlanteActionPerformed(ActionEvent evt) {
        this.type = "plante";
    }

    private void removeSalleActionPerformed(ActionEvent evt) {
        if (this.salleCurrent != null && JOptionPane.showConfirmDialog(this, "Voulez-vous supprimer la salle ?", "Warning", 0) == 0) {
            if (this.tables != null && this.tables.size() > 0) {
                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "La salle contien un ou plusieurs object, veuillez les supprimer d'abord.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                try {
                    this.dlSales.removeSalle(this.salleCurrent);
                    this.salleCurrent = null;
                    this.jTextSalle.setText("");
                    if (this.tables != null) {
                        this.tables.clear();
                    }
                    this.loadCatalog();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La salle a \u00e9t\u00e9 supprim\u00e9 avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                }
                catch (BasicException ex) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est survenue.", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        }
    }

    public void loadPopUpMAJ(final TableInfo table1, final JLabel labelPersonne, final JLabel labelNumero) {
        final JDialog dialog = new JDialog((Frame)new JFrame(), true);
        dialog.setTitle("Table");
        try {
            dialog.setIconImage(ImageIO.read(this.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
        }
        dialog.setPreferredSize(new Dimension(400, 200));
        JPanel panelBody = new JPanel();
        panelBody.setLayout(new FlowLayout());
        JPanel panelNumero = new JPanel();
        panelNumero.setLayout(new FlowLayout());
        JPanel panelPerson = new JPanel();
        panelPerson.setLayout(new FlowLayout());
        JPanel panelPersist = new JPanel();
        panelPersist.setLayout(new GridLayout(1, 2));
        JLabel titleNumber = new JLabel("Num\u00e9ro table");
        JLabel titlePersone = new JLabel("nombre de couverts");
        final JTextField textNumber = new JTextField();
        final JTextField textPerso = new JTextField();
        JButton btnOK = new JButton("Valider");
        btnOK.setRequestFocusEnabled(false);
        btnOK.setFocusPainted(false);
        btnOK.setBackground(new Color(218, 223, 225));
        if (table1.getNumber() != -1) {
            textNumber.setText(String.valueOf(table1.getNumber()));
        }
        if (table1.getNumber_person() != -1) {
            textPerso.setText(String.valueOf(table1.getNumber_person()));
        }
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                table1.setNumber(Integer.parseInt(textNumber.getText()));
                table1.setNumber_person(Integer.parseInt(textPerso.getText()));
                labelPersonne.setText(textPerso.getText() + " P");
                labelNumero.setText(textNumber.getText());
                dialog.dispose();
            }
        });
        JButton btnDelete = new JButton("Supprimer");
        btnDelete.setRequestFocusEnabled(false);
        btnDelete.setFocusPainted(false);
        btnDelete.setBackground(new Color(218, 223, 225));
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (table1.getId() != -1) {
                    try {
                        JPanelTable.this.dlSales.deleteTable(table1.getId());
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                JPanelTable.this.tables.remove(table1);
                JPanelTable.this.loadTables();
                dialog.dispose();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Table supprim\u00e9.", 1500, NPosition.CENTER);
            }
        });
        titlePersone.setPreferredSize(new Dimension(150, 50));
        titleNumber.setPreferredSize(new Dimension(150, 50));
        textNumber.setPreferredSize(new Dimension(100, 50));
        textPerso.setPreferredSize(new Dimension(100, 50));
        panelNumero.add(titleNumber);
        panelNumero.add(textNumber);
        panelPerson.add(titlePersone);
        panelPerson.add(textPerso);
        panelPersist.add(btnOK);
        panelPersist.add(btnDelete);
        panelPersist.setPreferredSize(new Dimension(300, 50));
        panelPerson.setPreferredSize(new Dimension(300, 50));
        panelNumero.setPreferredSize(new Dimension(300, 50));
        panelBody.add(panelNumero);
        panelBody.add(panelPerson);
        panelBody.add(panelPersist);
        dialog.add((Component)panelBody, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void deleteAccessoir(TableInfo table1) {
        String secondMessage;
        String firstMessage;
        if (table1.getType().equals("plante")) {
            firstMessage = "Vous voulez vraiment supprimer plante ?";
            secondMessage = "Plante supprim\u00e9";
        } else {
            firstMessage = "Vous voulez vraiment supprimer comptoir ?";
            secondMessage = "Comptoir supprim\u00e9";
        }
        int dialogButton = 0;
        int dialogResult = JOptionPane.showConfirmDialog(this, firstMessage, "Warning", dialogButton);
        if (dialogResult == 0) {
            if (table1.getId() != -1) {
                try {
                    this.dlSales.deleteTable(table1.getId());
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
            this.tables.remove(table1);
            this.loadTables();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, secondMessage, 1500, NPosition.CENTER);
        }
    }

    public void dragTable(TableInfo table1, MouseEvent me, JPanel panel) {
        me.translatePoint(me.getComponent().getLocation().x, me.getComponent().getLocation().y);
        if (me.getX() > 0 && me.getY() > 0 && me.getX() < this.bornSupX && me.getY() < this.bornSupY) {
            panel.setLocation(me.getX(), me.getY());
            table1.setX(me.getX());
            table1.setY(me.getY());
        }
    }

    public void initBorns() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelTable.this.bornInfX = JPanelTable.this.jPanelOutils.getPreferredSize().width;
                JPanelTable.this.bornSupX = (int)(JPanelTable.this.jPanelSallesOrder.getLocationOnScreen().getX() - JPanelTable.this.jPanelTables.getLocationOnScreen().getX() - 60.0);
                JPanelTable.this.bornInfY = JPanelTable.this.jPanelTitle.getPreferredSize().height + JPanelTable.this.jPanel2.getPreferredSize().height + 50;
                JPanelTable.this.bornSupY = (int)(AppVarUtils.getScreenDimension().getHeight() - JPanelTable.this.jPanelTables.getLocationOnScreen().getY() - 90.0);
            }
        });
    }

    class Surface
    extends JPanel {
        Surface() {
        }

        private void doDrawing(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.drawOval(0, 0, 30, 30);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.doDrawing(g);
        }
    }

    private class SmallSalleRenderer
    extends DefaultListCellRenderer {
        private SmallSalleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            SALLEINFO salle = (SALLEINFO)value;
            this.setText(salle.getName());
            return this;
        }
    }

    private class SallesListModel
    extends AbstractListModel {
        private final List m_aSalles;

        public SallesListModel(List aCategories) {
            this.m_aSalles = aCategories;
        }

        @Override
        public int getSize() {
            return this.m_aSalles.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.m_aSalles.get(i);
        }
    }
}

