/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.StockHistoryController;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JPanelStockHistory
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private AppView m_App;
    private StockHistoryController controller;

    public JPanelStockHistory() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        try {
            this.m_App = app;
            String fxmlFile = "/fxml/stock_history.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            this.controller = (StockHistoryController)loader.getController();
            Scene scene = new Scene(rootNode, 400.0, 200.0);
            scene.getStylesheets().add((Object)"/styles/styles.css");
            this.controller.initialize(this.m_App, scene);
            JFXPanel fxPanel = new JFXPanel();
            Platform.runLater(() -> fxPanel.setScene(scene));
            this.add((Component)fxPanel, "Center");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JPanelStockHistory.this.controller.load();
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        });
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Commandes en attente";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

