/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.PlanTableController;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JPanelPlanTable
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private AppView m_App;
    private PlanTableController controller;

    public JPanelPlanTable() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        try {
            this.m_App = app;
            String fxmlFile = "/fxml/plan_table.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            this.controller = (PlanTableController)loader.getController();
            Scene scene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight() - 85.0);
            scene.getStylesheets().add((Object)"/styles/styles.css");
            this.controller.init(this.m_App, scene);
            JFXPanel fxPanel = new JFXPanel();
            Platform.runLater(() -> fxPanel.setScene(scene));
            this.add((Component)fxPanel, "Center");
        }
        catch (BasicException | IOException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JPanelPlanTable.this.controller.load();
                }
                catch (BasicException ex) {
                    LogToFile.log("sever", null, ex);
                }
            }
        });
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Commandes en attente";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

