/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.LivraisonController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JPanelLVClient
extends JPanel
implements JPanelView,
BeanFactoryApp {
    protected AppView m_App;
    private LivraisonController controller;

    public JPanelLVClient() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        try {
            this.m_App = app;
            String fxmlFile = "/fxml/livraison.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            this.controller = (LivraisonController)loader.getController();
            Scene scene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            scene.getStylesheets().add((Object)"/styles/styles.css");
            this.controller.init(this.m_App, scene);
            JFXPanel fxPanel = new JFXPanel();
            fxPanel.setScene(scene);
            this.add((Component)fxPanel, "Center");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        if (AppLocal.changeAddress.booleanValue()) {
            this.controller.loadOldAdress();
        } else {
            this.controller.initialize();
        }
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Commandes en attente";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

