/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.dao.DataLogicEmployees;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.format.Formats;
import com.openbravo.keen.CassandraManager;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.printer.TicketParser;
import com.openbravo.pos.sales.DateLabelFormatter;
import com.openbravo.pos.sales.JCancelOrder;
import com.openbravo.pos.sales.JDetail;
import com.openbravo.pos.sales.JEncaissement;
import com.openbravo.pos.sales.JEncaissementOrder;
import com.openbravo.pos.sales.JExportRapport;
import com.openbravo.pos.sales.JXCaisse;
import com.openbravo.pos.sales.jPopupCloseCaisse;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.MonthInfo;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketResto;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.orderPaymentInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.InactivityListener;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.PaymentUtils;
import com.openbravo.pos.util.ProDefaultTableModel;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.ArchivageService;
import com.openbravo.service.AvoirService;
import com.openbravo.service.TicketService;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.ZGlobalInfoDTO;
import fr.protactile.procaisse.services.AddressService;
import fr.protactile.procaisse.services.BorneService;
import fr.protactile.procaisse.services.ZGlobalService;
import fr.protactile.procaisse.tpeCmi.TPECmi;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.jdatepicker.DateModel;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class JPanelHistoriqueCaisse
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private DataLogicStats dlStats;
    private TicketParser m_TTP;
    protected DefaultTableModel modelOrder;
    protected DefaultTableModel modelDetail;
    protected DefaultTableModel modelCaisse;
    protected DefaultTableModel modelClotures;
    protected DefaultTableModel modelOrdersShared;
    private AvoirService avoirService;
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    protected DataLogicSales dlSales;
    private DataLogicOrder dlOrders;
    private DataLogicEmployees dlEmployees;
    protected DataLogicItems dlItems;
    private Action logout;
    private InactivityListener listener;
    private Integer delay = 0;
    private List<TicketInfo> tickets_no_closed;
    private List<TicketInfo> tickets_by_day;
    private List<TicketInfo> tickets_canceled;
    private List<TicketInfo> orders;
    private List<CaisseZ> caisses;
    private List<GrandTotalPeriode> cloturesData;
    private List<PaymentLine> payments;
    private List<orderPaymentInfo> paymentsMonth;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat fullDateFormatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private Double cash;
    private Double card;
    private Double cheque;
    private Double free;
    private Double debt;
    private Double cashMonth;
    private Double cardMonth;
    private Double chequeMonth;
    private Double freeMonth;
    private Double debtMonth;
    private int countOrder;
    private Double totalOrder;
    private List<Integer> listCancel;
    private Date date;
    private int numberOrderMonth;
    private Double totalOrderMonth;
    private List<MonthInfo> listMonths;
    private MonthInfo month;
    private int year;
    private int currentMonth;
    private PaymentsModel m_PaymentsDay = null;
    private PaymentsModel m_PaymentsMonth = null;
    private CaisseInfo caisse;
    private TicketInfo currentOrder;
    private int orderPending;
    private double htAmount;
    private double taxAmount;
    private double ttcAmount;
    private double caNet;
    private List<TaxeLine> taxes;
    private List<TaxeLine> allTaxes;
    private Integer m_iSales;
    private List<UserCaisseInfo> users;
    private double caCanceled;
    private EnteteInfo entetTicket;
    private MarqueNFC marqueNF;
    private CassandraManager m_keenProject = null;
    private Date dateStart;
    private Date dateEnd;
    private boolean firstTime = true;
    private int day;
    private List<PrinterInfo> printers;
    private List<TicketLineInfo> productToSend;
    private boolean displayNumOrder;
    private boolean displayNameServeur;
    private AddressService mAddressService = AddressService.getInstance();
    private OrderService orderService;
    private boolean kitchen_composite;
    private Date dateStart_orders;
    private Date dateEnd_orders;
    private Date date_order;
    private String type_orders;
    private String type_filter_cloture = "Journalier";
    private int month_cloture = 0;
    private int year_cloture = 0;
    private HashMap<String, Integer> map_months;
    private TicketService ticketService;
    private boolean isToday;
    private final String LIVREE = "livre";
    TicketSharedService mTicketSharedService;
    private String type_cloture;
    private final String GLOBAL = "global";
    private final String LOCAL = "local";
    protected DefaultTableModel modelCloturesGlobal;
    private List<ZGlobalInfoDTO> recapsSharedSaleses;
    private final String ORDERS_BY_DAY = "orders_by_day";
    private final String ORDERS_CANCELED = "orders_canceled";
    private final String ORDERS_SHARED = "orders_shared";
    private final String BORNE = "borne";
    private boolean set_nodes_date_picker;
    private boolean set_nodes_date_picker_shared;
    private boolean filter_by_month;
    private ZGlobalService mZGlobalService;
    private PostgreService mPostgreService = null;
    private List<String> equipements_address;
    private List<TicketInfo> ticketsShared_by_day;
    private List<TaxInfo> taxesInfo;
    private int number_taxes;
    private List<GroupedTax> globalTaxes;
    private TPECmi mTPECmi;
    private JButton btn_next_date;
    private JButton btn_previous_date;
    private JLabel clotueEmpty;
    private JLabel clotureGlobalEmpty;
    private JButton jBntHistory;
    private JButton jBntHistoryByDay;
    private JButton jBntHistoryCanceled;
    private JButton jBntRecapByDay;
    private JButton jBntRecapByMonth;
    private JButton jBntSharedOrders;
    private JButton jBntSharedOrdersByDay;
    private JButton jBtnCloture;
    private JButton jBtnHistoryZ;
    private JButton jButton2;
    private JLabel jCaisseEmpty;
    private JButton jCancel;
    private JButton jChangePayment;
    private JLabel jDate;
    private JButton jDetail;
    private JLabel jLabel1;
    private JLabel jLabeltotalOrder;
    private JLabel jLabeltotalOrderShared;
    private JComboBox<MonthInfo> jListMonthCloture;
    private JComboBox<String> jListTypeCloture;
    private JComboBox<Integer> jListYearsClotures;
    private JLabel jOrderEmpty;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelBtn;
    private JPanel jPanelBtnRight;
    private JPanel jPanelCalendar;
    private JPanel jPanelCalendarCloture;
    private JPanel jPanelCloture;
    private JPanel jPanelDetailSharedSales;
    private JPanel jPanelFooter;
    private JPanel jPanelFooterSharedOrders;
    private JPanel jPanelHistories;
    private JPanel jPanelHistory;
    private JPanel jPanelHistoryZ;
    private JPanel jPanelMenuGlobal;
    private JPanel jPanelRecapGlobal;
    private JPanel jPanelSharedOrders;
    private JPanel jPanelSharedSales;
    private JPanel jPanelTableCaisse;
    private JPanel jPanelTableCloture;
    private JPanel jPanelTableClotureGlobal;
    private JPanel jPanelTableHistory;
    private JPanel jPanelTableHistorySharedOrders;
    private JPanel jPanelTitle;
    private JButton jPrint;
    private JButton jPrintCaisse;
    private JButton jPrintDay;
    private JButton jPrintMonth;
    private JButton jResetA;
    private JButton jResetJ;
    private JButton jResetM;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPaneClotureGlobal;
    private JScrollPane jScrollPaneSharedOrder;
    private JLabel jSharedOrderEmpty;
    private JTable jTableOrders;
    private JTable jTableSharedOrders;
    private JTable jTablecaisses;
    private JTable jTablecloture;
    private JTable jTableclotureGlobal;
    private JButton jaddPayment;
    private JComboBox<MonthInfo> jlistMonth;
    private JComboBox<Integer> jlistYear;
    private JLabel numberOrder;
    private JLabel numberOrderShared;
    private JPanel panelDatePicker;
    private JPanel panelDatePickerSharedOrder;
    private JPanel panelFilterClotures;
    private JPanel panelFilterSharedSales;

    public JPanelHistoriqueCaisse() {
        this.initComponents();
        this.jResetJ.setForeground(Color.BLACK);
        this.jResetJ.setBackground(Color.WHITE);
        LineBorder line = new LineBorder(Color.BLACK);
        EmptyBorder margin = new EmptyBorder(5, 15, 5, 15);
        CompoundBorder compound = new CompoundBorder(line, margin);
        this.jResetJ.setBorder(compound);
        this.jPrintCaisse.setForeground(Color.BLACK);
        this.jPrintCaisse.setBackground(Color.WHITE);
        this.jPrintCaisse.setBorder(compound);
        this.jResetM.setForeground(Color.BLACK);
        this.jResetM.setBackground(Color.WHITE);
        this.jResetM.setBorder(compound);
        this.jResetA.setForeground(Color.BLACK);
        this.jResetA.setBackground(Color.WHITE);
        this.jResetA.setBorder(compound);
        this.jPrintMonth.setForeground(Color.BLACK);
        this.jPrintMonth.setBackground(Color.WHITE);
        this.jPrintMonth.setBorder(compound);
        this.jPrintDay.setForeground(Color.BLACK);
        this.jPrintDay.setBackground(Color.WHITE);
        this.jPrintDay.setBorder(compound);
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        int firstYear;
        Object[] columnsOrders;
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlStats = (DataLogicStats)this.m_App.getBean("com.openbravo.dao.DataLogicStats");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.dlOrders = (DataLogicOrder)this.m_App.getBean("com.openbravo.dao.DataLogicOrder");
        this.dlSales.setDlStats(this.dlStats);
        this.dlEmployees = (DataLogicEmployees)this.m_App.getBean("com.openbravo.dao.DataLogicEmployees");
        this.dlSales.setDlEmployees(this.dlEmployees);
        this.avoirService = new AvoirService(this.dlOrders);
        try {
            this.marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
            this.taxesInfo = this.dlSales.getAllTax(AppLocal.MODULE_TVA_GLOBAL);
            for (TaxInfo taxInfo : this.taxesInfo) {
                if (!taxInfo.isEnabled()) continue;
                ++this.number_taxes;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.dlSystem);
        this.modelOrder = new ProDefaultTableModel();
        this.modelCaisse = new ProDefaultTableModel();
        this.modelClotures = new ProDefaultTableModel();
        this.modelDetail = new ProDefaultTableModel();
        this.modelOrdersShared = new ProDefaultTableModel();
        this.jTableOrders.setRowHeight(60);
        this.jTableSharedOrders.setRowHeight(60);
        this.jTableOrders.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int row = JPanelHistoriqueCaisse.this.jTableOrders.getSelectedRow();
                    if (row != -1) {
                        JPanelHistoriqueCaisse.this.currentOrder = JPanelHistoriqueCaisse.this.orders.get(row);
                        if (!JPanelHistoriqueCaisse.this.currentOrder.isPaid() && JPanelHistoriqueCaisse.this.currentOrder.isPrint_after_update()) {
                            System.out.println(" no paid deja imprim\u00e9");
                            JPanelHistoriqueCaisse.this.jPrint.setEnabled(false);
                        } else {
                            JPanelHistoriqueCaisse.this.jPrint.setEnabled(true);
                        }
                        try {
                            JPanelHistoriqueCaisse.this.currentOrder.setAddressInfo(JPanelHistoriqueCaisse.this.mAddressService.findOne(JPanelHistoriqueCaisse.this.currentOrder.getAddress()));
                            JPanelHistoriqueCaisse.this.currentOrder.setCustomer(JPanelHistoriqueCaisse.this.dlSales.loadCustomerExt(JPanelHistoriqueCaisse.this.currentOrder.getCustomerId()));
                            List<TicketLineInfo> lines = JPanelHistoriqueCaisse.this.dlSales.loadLines(JPanelHistoriqueCaisse.this.currentOrder.getId());
                            List<TicketLineInfo> linesExterne = JPanelHistoriqueCaisse.this.dlSales.getTicketLineExterne(JPanelHistoriqueCaisse.this.currentOrder.getId());
                            lines.addAll(linesExterne);
                            JPanelHistoriqueCaisse.this.currentOrder.setLines(lines);
                            JPanelHistoriqueCaisse.this.entetTicket = JPanelHistoriqueCaisse.this.dlSales.getEnteteByTicket(JPanelHistoriqueCaisse.this.currentOrder.getId(), JPanelHistoriqueCaisse.this.currentOrder.isPaid());
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        if (JPanelHistoriqueCaisse.this.type_orders != null && JPanelHistoriqueCaisse.this.type_orders.equals("orders_by_day")) {
                            JPanelHistoriqueCaisse.this.jCancel.setVisible(false);
                            JPanelHistoriqueCaisse.this.jaddPayment.setVisible(false);
                            JPanelHistoriqueCaisse.this.jChangePayment.setVisible(false);
                            JPanelHistoriqueCaisse.this.jDetail.setVisible(true);
                            JPanelHistoriqueCaisse.this.jPrint.setVisible(true);
                        } else if (JPanelHistoriqueCaisse.this.type_orders != null && JPanelHistoriqueCaisse.this.type_orders.equals("orders_canceled")) {
                            JPanelHistoriqueCaisse.this.jCancel.setVisible(false);
                            JPanelHistoriqueCaisse.this.jaddPayment.setVisible(false);
                            JPanelHistoriqueCaisse.this.jChangePayment.setVisible(false);
                            JPanelHistoriqueCaisse.this.jDetail.setVisible(true);
                            JPanelHistoriqueCaisse.this.jPrint.setVisible(false);
                        } else {
                            if (JPanelHistoriqueCaisse.this.caisse.isOuverte().booleanValue()) {
                                if ("cancel".equals(JPanelHistoriqueCaisse.this.currentOrder.getStatus()) || "Refund".equals(JPanelHistoriqueCaisse.this.currentOrder.getStatus())) {
                                    JPanelHistoriqueCaisse.this.jCancel.setVisible(false);
                                    JPanelHistoriqueCaisse.this.jaddPayment.setVisible(false);
                                    JPanelHistoriqueCaisse.this.jChangePayment.setVisible(false);
                                }
                                if ("paid".equals(JPanelHistoriqueCaisse.this.currentOrder.getStatus()) || JPanelHistoriqueCaisse.this.currentOrder.getStatus().equalsIgnoreCase("livre")) {
                                    JPanelHistoriqueCaisse.this.jCancel.setVisible(true);
                                    JPanelHistoriqueCaisse.this.jaddPayment.setVisible(false);
                                    JPanelHistoriqueCaisse.this.jChangePayment.setVisible(true);
                                }
                                if ("pending".equalsIgnoreCase(JPanelHistoriqueCaisse.this.currentOrder.getStatus())) {
                                    JPanelHistoriqueCaisse.this.jCancel.setVisible(true);
                                    JPanelHistoriqueCaisse.this.jaddPayment.setVisible(true);
                                    JPanelHistoriqueCaisse.this.jChangePayment.setVisible(false);
                                }
                            }
                            JPanelHistoriqueCaisse.this.jDetail.setVisible(true);
                            JPanelHistoriqueCaisse.this.jPrint.setVisible(true);
                        }
                    } else {
                        JPanelHistoriqueCaisse.this.jaddPayment.setVisible(false);
                        JPanelHistoriqueCaisse.this.jChangePayment.setVisible(false);
                        JPanelHistoriqueCaisse.this.jCancel.setVisible(false);
                        JPanelHistoriqueCaisse.this.jDetail.setVisible(false);
                        JPanelHistoriqueCaisse.this.jPrint.setVisible(false);
                    }
                }
            }
        });
        this.currentOrder = null;
        if (AppLocal.licence.equals("venteDetail")) {
            columnsOrders = new String[]{"N\u00b0", "Date", "Etat", "Total", "Paiements", "Caissier"};
            this.modelOrder.setColumnIdentifiers(columnsOrders);
        } else {
            columnsOrders = new String[]{"N\u00b0", "Date", "Type", "Etat", "Total", "Paiements", "Serveur"};
            this.modelOrder.setColumnIdentifiers(columnsOrders);
        }
        columnsOrders = new String[]{"N\u00b0", "N\u00b0 table", "Date", "Type", "Paiements", "Total", "Serveur", "Source", "Etat"};
        this.modelOrdersShared.setColumnIdentifiers(columnsOrders);
        this.jTableOrders.setShowGrid(true);
        this.jTableOrders.setModel(this.modelOrder);
        this.jTableSharedOrders.setModel(this.modelOrdersShared);
        Object[] columnsCaisses = new String[]{"Date ouverture", "Heure Ouverture", "Date Fermeture", "Heure Fermeture", "Ouverte par", "Ferm\u00e9e par", "HT", "TVA", "TTC"};
        this.modelCaisse.setColumnIdentifiers(columnsCaisses);
        this.jTablecaisses.setModel(this.modelCaisse);
        this.jTablecaisses.setRowHeight(40);
        this.tickets_no_closed = new ArrayList<TicketInfo>();
        this.caisses = new ArrayList<CaisseZ>();
        this.payments = new ArrayList<PaymentLine>();
        this.paymentsMonth = new ArrayList<orderPaymentInfo>();
        this.users = new ArrayList<UserCaisseInfo>();
        this.printers = new ArrayList<PrinterInfo>();
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.countOrder = 0;
        this.totalOrder = 0.0;
        this.totalOrderMonth = 0.0;
        this.listCancel = new ArrayList<Integer>();
        this.numberOrderMonth = 0;
        this.listMonths = new ArrayList<MonthInfo>();
        this.listMonths.add(new MonthInfo(1, "Janvier"));
        this.listMonths.add(new MonthInfo(2, "F\u00e9vrier"));
        this.listMonths.add(new MonthInfo(3, "Mars"));
        this.listMonths.add(new MonthInfo(4, "Avril"));
        this.listMonths.add(new MonthInfo(5, "Mai"));
        this.listMonths.add(new MonthInfo(6, "Juin"));
        this.listMonths.add(new MonthInfo(7, "Juillet"));
        this.listMonths.add(new MonthInfo(8, "Aout"));
        this.listMonths.add(new MonthInfo(9, "Septembre"));
        this.listMonths.add(new MonthInfo(10, "Octobre"));
        this.listMonths.add(new MonthInfo(11, "Novembre"));
        this.listMonths.add(new MonthInfo(12, "D\u00e9cembre"));
        Date dateJour = new Date();
        this.month = null;
        for (MonthInfo mois : this.listMonths) {
            if (dateJour.getMonth() + 1 != mois.getId()) continue;
            this.month = mois;
        }
        this.jlistMonth.removeAllItems();
        for (MonthInfo mois : this.listMonths) {
            this.jlistMonth.addItem(mois);
        }
        this.jlistMonth.setSelectedItem(this.month);
        for (int i = firstYear = dateJour.getYear() + 1900; i > firstYear - 10; --i) {
            this.jlistYear.addItem(i);
        }
        this.jlistYear.setSelectedItem(firstYear);
        this.allTaxes = new ArrayList<TaxeLine>();
        Date today = new Date();
        this.jResetA.setEnabled(!this.dlItems.isClotured("a", today));
        this.jResetM.setEnabled(!this.dlItems.isClotured("m", today) && !this.dlItems.isClotured("a", today));
        this.jResetJ.setEnabled(!this.dlItems.isClotured("j", today) && !this.dlItems.isClotured("m", today) && !this.dlItems.isClotured("a", today));
        this.initClotures();
        this.jResetA.setVisible(false);
        this.jResetM.setVisible(false);
        this.jResetJ.setVisible(false);
        this.jaddPayment.setVisible(false);
        this.jChangePayment.setVisible(false);
        this.jCancel.setVisible(false);
        this.jDetail.setVisible(false);
        this.jPrint.setVisible(false);
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.orderService = OrderService.getInstance();
        }
        this.date = DateUtils.getToday();
        this.initTime();
        this.type_orders = "no_closed";
        this.ticketService = TicketService.getInstance();
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mTicketSharedService = TicketSharedService.getInstance();
        }
        this.jBntSharedOrders.setVisible(AppLocal.KITCHEN_COMPOSITE && AppLocal.PRINT_TICKET_Z_GLOBAL);
        this.mZGlobalService = ZGlobalService.getInstance();
        this.modelCloturesGlobal = new ProDefaultTableModel();
        ArrayList<Object> tva_global = new ArrayList<Object>();
        tva_global.add("P\u00e9riode clotur\u00e9");
        tva_global.add("Cumule de p\u00e9riode");
        for (TaxInfo taxInfo : this.taxesInfo) {
            if (!taxInfo.isEnabled()) continue;
            tva_global.add("TVA " + taxInfo.getName());
        }
        Object[] columnsCloturesGlobal = new String[tva_global.size()];
        columnsCloturesGlobal = tva_global.toArray(columnsCloturesGlobal);
        this.modelCloturesGlobal.setColumnIdentifiers(columnsCloturesGlobal);
        try {
            this.loadClotures();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.jTableclotureGlobal.setModel(this.modelCloturesGlobal);
        this.jTableclotureGlobal.setAutoResizeMode(4);
        this.jTableclotureGlobal.setRowHeight(40);
        this.set_nodes_date_picker = false;
        this.set_nodes_date_picker_shared = true;
    }

    private void encaisserOrder(List<TicketLineInfo> lines, List<PaymentInfo> m_aPaymentInfo, Map<Integer, TicketAvoir> ticketsAvoirs, HashMap<Integer, TicketResto> ticketsRestau, String holder_ticket) throws BasicException {
        boolean payment_cb = m_aPaymentInfo != null && m_aPaymentInfo.size() == 1 && m_aPaymentInfo.get(0) != null && m_aPaymentInfo.get(0).getName() != null && m_aPaymentInfo.get(0).getName().equalsIgnoreCase("CB");
        boolean openDrawer = AppLocal.OPEN_DRAWER && (!payment_cb || AppLocal.CB_DRAWER);
        this.ticketService.paidOldOrder(this.currentOrder, lines, m_aPaymentInfo, ticketsAvoirs, openDrawer, ticketsRestau, false, true, false, holder_ticket, "print paper", null);
    }

    public void loadOrder() throws BasicException {
        this.jCancel.setVisible(false);
        this.jDetail.setVisible(false);
        this.jPrint.setVisible(false);
        this.jChangePayment.setVisible(false);
        this.currentOrder = null;
        this.caNet = this.dlSales.getCA(this.caisse.getDateOpen());
        this.users = this.dlSales.getCAbyUser();
        this.payments = this.dlSales.loadPayment(this.caisse.getDateOpen(), new Date());
        this.caCanceled = this.dlSales.getCACanceled();
        this.m_iSales = this.dlSales.getNbOrder();
        this.allTaxes.clear();
        this.taxes = this.dlSales.getTaxeByDate();
        this.allTaxes.addAll(this.taxes);
        this.htAmount = 0.0;
        this.taxAmount = 0.0;
        for (TaxeLine allTaxe : this.allTaxes) {
            this.htAmount += allTaxe.getHt();
            this.taxAmount += allTaxe.getTax();
        }
        this.tickets_no_closed = this.dlSales.loadBydateOpen();
        this.globalTaxes = this.dlStats.getGlobalTaxes(this.caisse.getDateOpen(), new Date());
    }

    public void loadCaisseZ() throws BasicException {
        MonthInfo monthZ = (MonthInfo)this.jlistMonth.getSelectedItem();
        Integer yearZ = (Integer)this.jlistYear.getSelectedItem();
        if (monthZ != null && yearZ != null) {
            this.caisses = this.dlSales.getCaisseZ(yearZ, monthZ.getId());
            this.modelCaisse.setRowCount(0);
            if (this.caisses.size() > 0) {
                this.jPanelTableCaisse.removeAll();
                this.jPanelTableCaisse.add((Component)this.jScrollPane2, "Center");
                this.jScrollPane2.setVisible(true);
                this.jCaisseEmpty.setVisible(false);
                this.jPanelTableCaisse.revalidate();
                this.jPanelTableCaisse.repaint();
                for (CaisseZ caissez : this.caisses) {
                    Object[] rowData = new Object[]{this.dateFormatter.format(caissez.getDateOpen()), this.timeFormatter.format(caissez.getDateOpen()), this.dateFormatter.format(caissez.getDateClose()), this.timeFormatter.format(caissez.getDateClose()), caissez.getUser_open().getName(), caissez.getUser_close().getName(), Formats.CURRENCY.formatValue(caissez.getHtAmount()), Formats.CURRENCY.formatValue(caissez.getTaxAmount()), Formats.CURRENCY.formatValue(caissez.getTtcAmount())};
                    this.modelCaisse.addRow(rowData);
                }
                this.jTablecaisses.setModel(this.modelCaisse);
            } else {
                this.jPanelTableCaisse.removeAll();
                this.jPanelTableCaisse.add((Component)this.jCaisseEmpty, "Center");
                this.jScrollPane2.setVisible(false);
                this.jCaisseEmpty.setVisible(true);
                this.jPanelTableCaisse.revalidate();
                this.jPanelTableCaisse.repaint();
            }
        }
    }

    public void loadClotures() {
        int numberColumns = 7 + this.number_taxes;
        try {
            this.cloturesData = this.dlItems.loadGrandTotalPeriodByDate(this.month_cloture, this.year_cloture, this.type_filter_cloture);
            System.out.println("cloturesData *************************: " + this.cloturesData);
            this.modelClotures.setRowCount(0);
            if (this.cloturesData.size() > 0) {
                this.jPanelTableCloture.removeAll();
                this.jPanelTableCloture.add((Component)this.jScrollPane3, "Center");
                this.jScrollPane3.setVisible(true);
                this.clotueEmpty.setVisible(false);
                for (GrandTotalPeriode cloture : this.cloturesData) {
                    Object[] rowData = new Object[numberColumns];
                    int column = 0;
                    rowData[column++] = cloture.getId();
                    rowData[column++] = cloture.displayTypePeriode();
                    rowData[column++] = cloture.displayPeriodeName();
                    rowData[column++] = Formats.CURRENCY.formatValue(cloture.getCumul());
                    rowData[column++] = Formats.CURRENCY.formatValue(cloture.getCumulPerpetual());
                    for (TaxInfo taxInfo : this.taxesInfo) {
                        if (!taxInfo.isEnabled()) continue;
                        if (taxInfo.isTax_global()) {
                            rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTaxeByName(taxInfo.getName()));
                            continue;
                        }
                        switch (taxInfo.getName()) {
                            case "0%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva0());
                                break;
                            }
                            case "5.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva5());
                                break;
                            }
                            case "10%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva10());
                                break;
                            }
                            case "20%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva20());
                                break;
                            }
                            case "7.7%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_7_7());
                                break;
                            }
                            case "2.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_2_5());
                                break;
                            }
                            case "2.1%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_2_1());
                                break;
                            }
                            case "8.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_8_5());
                                break;
                            }
                            case "6%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_6());
                                break;
                            }
                            case "12%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_12());
                                break;
                            }
                            case "21%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_21());
                                break;
                            }
                            case "8.1%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_8_1());
                                break;
                            }
                            case "2.6%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(cloture.getTva_2_6());
                            }
                        }
                    }
                    rowData[column++] = this.dateFormatter.format(cloture.getTimestampGDH());
                    rowData[column++] = this.timeFormatter.format(cloture.getTimestampGDH());
                    this.modelClotures.addRow(rowData);
                }
                this.jTablecloture.setModel(this.modelClotures);
                this.jPanelTableCloture.revalidate();
                this.jPanelTableCloture.repaint();
            } else {
                this.jPanelTableCloture.removeAll();
                this.jPanelTableCloture.add((Component)this.clotueEmpty, "Center");
                this.jScrollPane3.setVisible(false);
                this.clotueEmpty.setVisible(true);
                this.jPanelTableCloture.revalidate();
                this.jPanelTableCloture.repaint();
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public String printCash() {
        return Formats.CURRENCY.formatValue(this.cash);
    }

    public String printCheque() {
        return Formats.CURRENCY.formatValue(this.cheque);
    }

    public String printCard() {
        return Formats.CURRENCY.formatValue(this.card);
    }

    public String printFree() {
        return Formats.CURRENCY.formatValue(this.free);
    }

    public String printDebit() {
        return Formats.CURRENCY.formatValue(this.debt);
    }

    public String printCashMonth() {
        return Formats.CURRENCY.formatValue(this.cashMonth);
    }

    public String printChequeMonth() {
        return Formats.CURRENCY.formatValue(this.chequeMonth);
    }

    public String printCardMonth() {
        return Formats.CURRENCY.formatValue(this.cardMonth);
    }

    public String printFreeMonth() {
        return Formats.CURRENCY.formatValue(this.freeMonth);
    }

    public String printDebitMonth() {
        return Formats.CURRENCY.formatValue(this.debtMonth);
    }

    public String printTotalOrder() {
        return Formats.CURRENCY.formatValue(this.totalOrder);
    }

    public String printTotalOrderMonth() {
        return Formats.CURRENCY.formatValue(this.totalOrderMonth);
    }

    public String printDate() {
        SimpleDateFormat sdf = com.openbravo.pos.util.DateUtils.formatterDAY_MONTH_YEAR_SLASHES;
        return sdf.format(DateUtils.getToday());
    }

    public String printDateMonth() {
        return this.month.getName() + " " + this.year;
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        Date today;
        this.caisse = this.dlSales.getCaisse(AppLocal.token);
        this.orderPending = this.dlSales.getNbOrderPending();
        this.loadOrder();
        this.loadCaisseZ();
        this.loadHistory();
        if (this.caisse != null) {
            this.jResetJ.setEnabled(this.caisse.isOuverte());
            this.jResetA.setEnabled(true);
            this.jResetM.setEnabled(true);
            this.jPrintCaisse.setEnabled(this.caisse.isOuverte());
        }
        this.jResetA.setEnabled(!this.dlItems.isClotured("a", today = new Date()));
        this.jResetM.setEnabled(!this.dlItems.isClotured("m", today) && !this.dlItems.isClotured("a", today));
        this.jResetJ.setEnabled(!this.dlItems.isClotured("j", today) && !this.dlItems.isClotured("m", today) && !this.dlItems.isClotured("a", today));
        if (this.equipements_address == null) {
            this.equipements_address = new ArrayList<String>();
        } else {
            this.equipements_address.clear();
        }
        this.equipements_address.add("");
        this.equipements_address.add(null);
        try {
            InetAddress ip_machine = InetAddress.getLocalHost();
            if (ip_machine != null) {
                this.equipements_address.add(ip_machine.getHostAddress());
            }
        }
        catch (UnknownHostException ex) {
            LogToFile.log("severe", null, ex);
        }
        BorneService mBorneService = BorneService.getInstance();
        List<BorneInfo> equipments = mBorneService.getBornes();
        for (BorneInfo equipment : equipments) {
            if (equipment == null || equipment.getAddress_ip() == null || equipment.getAddress_ip().isEmpty()) continue;
            this.equipements_address.add(equipment.getAddress_ip());
        }
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    public String getResourceAsXML(String sresourcename) {
        return this.dlSystem.getResourceAsXML(sresourcename);
    }

    @Override
    public String getTitle() {
        return "Historique";
    }

    public void loadHistory() {
        this.type_orders = "no_closed";
        this.buildPaneOrders(this.tickets_no_closed);
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelHistory, "Center");
        this.jPanelHistory.setVisible(true);
        this.jPanelHistoryZ.setVisible(false);
        this.jPanelSharedSales.setVisible(false);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBntHistory.setBackground(new Color(89, 171, 227));
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntHistoryCanceled.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setBackground(new Color(29, 207, 224));
        this.panelDatePicker.setVisible(false);
        this.jPanelFooter.setVisible(true);
    }

    public void loadHistoryZ() {
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelHistoryZ, "Center");
        this.jPanelHistory.setVisible(false);
        this.jPanelHistoryZ.setVisible(true);
        this.jPanelSharedSales.setVisible(false);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBtnHistoryZ.setBackground(new Color(89, 171, 227));
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setBackground(new Color(29, 207, 224));
        this.panelDatePicker.setVisible(false);
    }

    public void viewClotures() {
        this.type_cloture = "local";
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelCloture, "Center");
        this.jPanelHistory.setVisible(false);
        this.jPanelHistoryZ.setVisible(false);
        this.jPanelCloture.setVisible(true);
        this.jPanelSharedSales.setVisible(false);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBtnCloture.setBackground(new Color(89, 171, 227));
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setBackground(new Color(29, 207, 224));
        this.panelDatePicker.setVisible(false);
        this.panelFilterSharedSales.removeAll();
        this.panelFilterSharedSales.revalidate();
        this.panelFilterSharedSales.repaint();
        this.panelFilterClotures.removeAll();
        this.panelFilterClotures.add(this.jListMonthCloture);
        this.panelFilterClotures.add(this.jListYearsClotures);
        this.panelFilterClotures.revalidate();
        this.panelFilterClotures.repaint();
    }

    private void initComponents() {
        this.jPanelTitle = new JPanel();
        this.jPanelBtn = new JPanel();
        this.jBntHistory = new JButton();
        this.jBtnHistoryZ = new JButton();
        this.jBtnCloture = new JButton();
        this.jBntHistoryByDay = new JButton();
        this.jBntHistoryCanceled = new JButton();
        this.jBntSharedOrders = new JButton();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanelHistories = new JPanel();
        this.jPanelHistoryZ = new JPanel();
        this.jPanelCalendar = new JPanel();
        this.jlistYear = new JComboBox();
        this.jlistMonth = new JComboBox();
        this.jPanelTableCaisse = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTablecaisses = new JTable();
        this.jCaisseEmpty = new JLabel();
        this.jPanelHistory = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.numberOrder = new JLabel();
        this.jLabeltotalOrder = new JLabel();
        this.jPanelFooter = new JPanel();
        this.jPrintCaisse = new JButton();
        this.jPrintDay = new JButton();
        this.jPrintMonth = new JButton();
        this.jResetJ = new JButton();
        this.jResetM = new JButton();
        this.jResetA = new JButton();
        this.jPanel4 = new JPanel();
        this.panelDatePicker = new JPanel();
        this.btn_previous_date = new JButton();
        this.jDate = new JLabel();
        this.btn_next_date = new JButton();
        this.jPanelBtnRight = new JPanel();
        this.jaddPayment = new JButton();
        this.jChangePayment = new JButton();
        this.jCancel = new JButton();
        this.jDetail = new JButton();
        this.jPrint = new JButton();
        this.jPanelTableHistory = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableOrders = new JTable();
        this.jOrderEmpty = new JLabel();
        this.jPanel9 = new JPanel();
        this.jPanelCloture = new JPanel();
        this.jPanelCalendarCloture = new JPanel();
        this.jListTypeCloture = new JComboBox();
        this.panelFilterClotures = new JPanel();
        this.jListMonthCloture = new JComboBox();
        this.jListYearsClotures = new JComboBox();
        this.jButton2 = new JButton();
        this.jPanelTableCloture = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTablecloture = new JTable();
        this.clotueEmpty = new JLabel();
        this.jPanelSharedSales = new JPanel();
        this.jPanelMenuGlobal = new JPanel();
        this.jBntSharedOrdersByDay = new JButton();
        this.jBntRecapByDay = new JButton();
        this.jBntRecapByMonth = new JButton();
        this.jPanelDetailSharedSales = new JPanel();
        this.jPanelSharedOrders = new JPanel();
        this.panelDatePickerSharedOrder = new JPanel();
        this.jPanelTableHistorySharedOrders = new JPanel();
        this.jScrollPaneSharedOrder = new JScrollPane();
        this.jTableSharedOrders = new JTable();
        this.jSharedOrderEmpty = new JLabel();
        this.jPanelFooterSharedOrders = new JPanel();
        this.numberOrderShared = new JLabel();
        this.jLabeltotalOrderShared = new JLabel();
        this.jPanelRecapGlobal = new JPanel();
        this.panelFilterSharedSales = new JPanel();
        this.jPanelTableClotureGlobal = new JPanel();
        this.jScrollPaneClotureGlobal = new JScrollPane();
        this.jTableclotureGlobal = new JTable();
        this.clotureGlobalEmpty = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(153, 153, 153)));
        this.jPanelTitle.setPreferredSize(new Dimension(815, 50));
        this.jPanelTitle.setLayout(new BorderLayout());
        this.jPanelBtn.setPreferredSize(new Dimension(800, 0));
        this.jPanelBtn.setLayout(new GridLayout(1, 0, 5, 5));
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBntHistory.setText("<html><center>Historique <br>En cours</center></html>");
        this.jBntHistory.setBorderPainted(false);
        this.jBntHistory.setFocusPainted(false);
        this.jBntHistory.setRequestFocusEnabled(false);
        this.jBntHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntHistoryActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBntHistory);
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBtnHistoryZ.setText("<html><center>Historique <br>Z Caisse</center></html>");
        this.jBtnHistoryZ.setBorderPainted(false);
        this.jBtnHistoryZ.setFocusPainted(false);
        this.jBtnHistoryZ.setRequestFocusEnabled(false);
        this.jBtnHistoryZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBtnHistoryZActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBtnHistoryZ);
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBtnCloture.setText("<html><center>Historique <br>des clotures</center></html>");
        this.jBtnCloture.setBorderPainted(false);
        this.jBtnCloture.setFocusPainted(false);
        this.jBtnCloture.setRequestFocusEnabled(false);
        this.jBtnCloture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBtnClotureActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBtnCloture);
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setText("<html><center>Historique <br>Par jour</center></html>");
        this.jBntHistoryByDay.setBorderPainted(false);
        this.jBntHistoryByDay.setFocusPainted(false);
        this.jBntHistoryByDay.setRequestFocusEnabled(false);
        this.jBntHistoryByDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntHistoryByDayActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBntHistoryByDay);
        this.jBntHistoryCanceled.setBackground(new Color(129, 207, 224));
        this.jBntHistoryCanceled.setText("<html><center>Historique <br>Des annulations</center></html>");
        this.jBntHistoryCanceled.setBorderPainted(false);
        this.jBntHistoryCanceled.setFocusPainted(false);
        this.jBntHistoryCanceled.setRequestFocusEnabled(false);
        this.jBntHistoryCanceled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntHistoryCanceledActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBntHistoryCanceled);
        this.jBntSharedOrders.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setText("Global");
        this.jBntSharedOrders.setBorderPainted(false);
        this.jBntSharedOrders.setFocusPainted(false);
        this.jBntSharedOrders.setRequestFocusEnabled(false);
        this.jBntSharedOrders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntSharedOrdersActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBntSharedOrders);
        this.jPanelTitle.add((Component)this.jPanelBtn, "Before");
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Historique");
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanel8.add(this.jLabel1);
        this.jPanelTitle.add((Component)this.jPanel8, "Center");
        this.add((Component)this.jPanelTitle, "First");
        this.jPanelHistories.setLayout(new BorderLayout());
        this.jPanelHistoryZ.setLayout(new BorderLayout());
        this.jPanelCalendar.setPreferredSize(new Dimension(0, 40));
        this.jPanelCalendar.setLayout(new FlowLayout(2));
        this.jlistYear.setPreferredSize(new Dimension(150, 30));
        this.jlistYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jlistYearActionPerformed(evt);
            }
        });
        this.jPanelCalendar.add(this.jlistYear);
        this.jlistMonth.setPreferredSize(new Dimension(150, 30));
        this.jlistMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jlistMonthActionPerformed(evt);
            }
        });
        this.jPanelCalendar.add(this.jlistMonth);
        this.jPanelHistoryZ.add((Component)this.jPanelCalendar, "First");
        this.jPanelTableCaisse.setLayout(new BorderLayout());
        this.jTablecaisses.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTablecaisses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelHistoriqueCaisse.this.jTablecaissesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTablecaisses);
        this.jPanelTableCaisse.add((Component)this.jScrollPane2, "Center");
        this.jCaisseEmpty.setFont(new Font("Tahoma", 1, 18));
        this.jCaisseEmpty.setHorizontalAlignment(0);
        this.jCaisseEmpty.setText("Aucune Z caisse pour cette date");
        this.jPanelTableCaisse.add((Component)this.jCaisseEmpty, "Center");
        this.jPanelHistoryZ.add((Component)this.jPanelTableCaisse, "Center");
        this.jPanelHistories.add((Component)this.jPanelHistoryZ, "Center");
        this.jPanelHistory.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel7.setPreferredSize(new Dimension(10, 100));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel1.add((Component)this.jPanel7, "After");
        this.jPanel6.setPreferredSize(new Dimension(10, 100));
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel1.add((Component)this.jPanel6, "Before");
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(0, 40));
        this.jPanel3.setLayout(new BorderLayout());
        this.numberOrder.setPreferredSize(new Dimension(300, 14));
        this.jPanel3.add((Component)this.numberOrder, "Before");
        this.jLabeltotalOrder.setHorizontalAlignment(4);
        this.jLabeltotalOrder.setPreferredSize(new Dimension(150, 14));
        this.jPanel3.add((Component)this.jLabeltotalOrder, "After");
        this.jPanel2.add((Component)this.jPanel3, "First");
        this.jPrintCaisse.setText("Rapport Caisse");
        this.jPrintCaisse.setPreferredSize(new Dimension(150, 40));
        this.jPrintCaisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jPrintCaisseActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jPrintCaisse);
        this.jPrintDay.setText("Rapport Jour");
        this.jPrintDay.setPreferredSize(new Dimension(150, 40));
        this.jPrintDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jPrintDayActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jPrintDay);
        this.jPrintMonth.setText("Rapport Mois");
        this.jPrintMonth.setPreferredSize(new Dimension(150, 40));
        this.jPrintMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jPrintMonthActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jPrintMonth);
        this.jResetJ.setText("Clot\u00fbre journali\u00e8re");
        this.jResetJ.setPreferredSize(new Dimension(150, 40));
        this.jResetJ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jResetJActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jResetJ);
        this.jResetM.setText("Cl\u00f4ture Mensuel");
        this.jResetM.setPreferredSize(new Dimension(150, 40));
        this.jResetM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jResetMActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jResetM);
        this.jResetA.setText("Cl\u00f4ture Annuel");
        this.jResetA.setPreferredSize(new Dimension(150, 40));
        this.jResetA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jResetAActionPerformed(evt);
            }
        });
        this.jPanelFooter.add(this.jResetA);
        this.jPanel2.add((Component)this.jPanelFooter, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Last");
        this.jPanel4.setPreferredSize(new Dimension(1177, 40));
        this.jPanel4.setLayout(new BorderLayout());
        this.panelDatePicker.setPreferredSize(new Dimension(300, 35));
        this.panelDatePicker.setLayout(new FlowLayout(0));
        this.btn_previous_date.setText("<");
        this.btn_previous_date.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.btn_previous_dateActionPerformed(evt);
            }
        });
        this.panelDatePicker.add(this.btn_previous_date);
        this.jDate.setBackground(new Color(255, 255, 255));
        this.jDate.setHorizontalAlignment(0);
        this.jDate.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jDate.setPreferredSize(new Dimension(150, 30));
        this.panelDatePicker.add(this.jDate);
        this.btn_next_date.setText(">");
        this.btn_next_date.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.btn_next_dateActionPerformed(evt);
            }
        });
        this.panelDatePicker.add(this.btn_next_date);
        this.jPanel4.add((Component)this.panelDatePicker, "Before");
        this.jPanelBtnRight.setPreferredSize(new Dimension(100, 35));
        this.jPanelBtnRight.setLayout(new FlowLayout(2));
        this.jaddPayment.setBackground(new Color(78, 205, 196));
        this.jaddPayment.setText("Encaisser");
        this.jaddPayment.setFocusPainted(false);
        this.jaddPayment.setPreferredSize(new Dimension(150, 35));
        this.jaddPayment.setRequestFocusEnabled(false);
        this.jaddPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jaddPaymentActionPerformed(evt);
            }
        });
        this.jPanelBtnRight.add(this.jaddPayment);
        this.jChangePayment.setBackground(new Color(78, 205, 196));
        this.jChangePayment.setText("Modifier paiement");
        this.jChangePayment.setFocusPainted(false);
        this.jChangePayment.setPreferredSize(new Dimension(150, 35));
        this.jChangePayment.setRequestFocusEnabled(false);
        this.jChangePayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jChangePaymentActionPerformed(evt);
            }
        });
        this.jPanelBtnRight.add(this.jChangePayment);
        this.jCancel.setBackground(new Color(240, 52, 52));
        this.jCancel.setText("Annuler");
        this.jCancel.setFocusPainted(false);
        this.jCancel.setPreferredSize(new Dimension(100, 35));
        this.jCancel.setRequestFocusEnabled(false);
        this.jCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jCancelActionPerformed(evt);
            }
        });
        this.jPanelBtnRight.add(this.jCancel);
        this.jDetail.setBackground(new Color(3, 201, 169));
        this.jDetail.setText("Detail");
        this.jDetail.setFocusPainted(false);
        this.jDetail.setPreferredSize(new Dimension(100, 35));
        this.jDetail.setRequestFocusEnabled(false);
        this.jDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jDetailActionPerformed(evt);
            }
        });
        this.jPanelBtnRight.add(this.jDetail);
        this.jPrint.setBackground(new Color(162, 222, 208));
        this.jPrint.setText("Imprimer Ticket");
        this.jPrint.setFocusPainted(false);
        this.jPrint.setPreferredSize(new Dimension(150, 35));
        this.jPrint.setRequestFocusEnabled(false);
        this.jPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jPrintActionPerformed(evt);
            }
        });
        this.jPanelBtnRight.add(this.jPrint);
        this.jPanel4.add((Component)this.jPanelBtnRight, "Center");
        this.jPanel1.add((Component)this.jPanel4, "First");
        this.jPanelTableHistory.setLayout(new BorderLayout());
        this.jTableOrders.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTableOrders);
        this.jPanelTableHistory.add((Component)this.jScrollPane1, "Center");
        this.jOrderEmpty.setFont(new Font("Tahoma", 1, 18));
        this.jOrderEmpty.setHorizontalAlignment(0);
        this.jOrderEmpty.setText("Aucun enregistrement");
        this.jPanelTableHistory.add((Component)this.jOrderEmpty, "Center");
        this.jPanel1.add((Component)this.jPanelTableHistory, "Center");
        this.jPanelHistory.add((Component)this.jPanel1, "Center");
        this.jPanel9.setPreferredSize(new Dimension(10, 100));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanelHistory.add((Component)this.jPanel9, "After");
        this.jPanelHistories.add((Component)this.jPanelHistory, "Center");
        this.jPanelCloture.setLayout(new BorderLayout());
        this.jPanelCalendarCloture.setPreferredSize(new Dimension(0, 40));
        this.jPanelCalendarCloture.setLayout(new FlowLayout(0));
        this.jListTypeCloture.setModel(new DefaultComboBoxModel<String>(new String[]{"Journalier", "Mensuel", "Annuel"}));
        this.jListTypeCloture.setPreferredSize(new Dimension(100, 25));
        this.jListTypeCloture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jListTypeClotureActionPerformed(evt);
            }
        });
        this.jPanelCalendarCloture.add(this.jListTypeCloture);
        this.panelFilterClotures.setPreferredSize(new Dimension(210, 30));
        this.panelFilterClotures.setLayout(new FlowLayout(0));
        this.jListMonthCloture.setPreferredSize(new Dimension(100, 25));
        this.jListMonthCloture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jListMonthClotureActionPerformed(evt);
            }
        });
        this.panelFilterClotures.add(this.jListMonthCloture);
        this.jListYearsClotures.setPreferredSize(new Dimension(100, 25));
        this.jListYearsClotures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jListYearsCloturesActionPerformed(evt);
            }
        });
        this.panelFilterClotures.add(this.jListYearsClotures);
        this.jPanelCalendarCloture.add(this.panelFilterClotures);
        this.jButton2.setText("Exporter le rapport");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanelCalendarCloture.add(this.jButton2);
        this.jPanelCloture.add((Component)this.jPanelCalendarCloture, "First");
        this.jPanelTableCloture.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelHistoriqueCaisse.this.jPanelTableClotureMouseClicked(evt);
            }
        });
        this.jPanelTableCloture.setLayout(new BorderLayout());
        this.jTablecloture.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTablecloture.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelHistoriqueCaisse.this.jTableclotureMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTablecloture);
        this.jPanelTableCloture.add((Component)this.jScrollPane3, "Center");
        this.clotueEmpty.setFont(new Font("Tahoma", 1, 18));
        this.clotueEmpty.setHorizontalAlignment(0);
        this.clotueEmpty.setText("Aucune cloture dans cette p\u00e9riode");
        this.jPanelTableCloture.add((Component)this.clotueEmpty, "Center");
        this.jPanelCloture.add((Component)this.jPanelTableCloture, "Center");
        this.jPanelHistories.add((Component)this.jPanelCloture, "Center");
        this.jPanelSharedSales.setLayout(new BorderLayout());
        this.jPanelMenuGlobal.setPreferredSize(new Dimension(0, 40));
        this.jPanelMenuGlobal.setLayout(new FlowLayout(0));
        this.jBntSharedOrdersByDay.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrdersByDay.setText("Historique par jour");
        this.jBntSharedOrdersByDay.setBorderPainted(false);
        this.jBntSharedOrdersByDay.setFocusPainted(false);
        this.jBntSharedOrdersByDay.setPreferredSize(new Dimension(150, 30));
        this.jBntSharedOrdersByDay.setRequestFocusEnabled(false);
        this.jBntSharedOrdersByDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntSharedOrdersByDayActionPerformed(evt);
            }
        });
        this.jPanelMenuGlobal.add(this.jBntSharedOrdersByDay);
        this.jBntRecapByDay.setBackground(new Color(129, 207, 224));
        this.jBntRecapByDay.setText("Recap mensuel ");
        this.jBntRecapByDay.setBorderPainted(false);
        this.jBntRecapByDay.setFocusPainted(false);
        this.jBntRecapByDay.setPreferredSize(new Dimension(150, 30));
        this.jBntRecapByDay.setRequestFocusEnabled(false);
        this.jBntRecapByDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntRecapByDayActionPerformed(evt);
            }
        });
        this.jPanelMenuGlobal.add(this.jBntRecapByDay);
        this.jBntRecapByMonth.setBackground(new Color(129, 207, 224));
        this.jBntRecapByMonth.setText("Recap annuel");
        this.jBntRecapByMonth.setBorderPainted(false);
        this.jBntRecapByMonth.setFocusPainted(false);
        this.jBntRecapByMonth.setPreferredSize(new Dimension(150, 30));
        this.jBntRecapByMonth.setRequestFocusEnabled(false);
        this.jBntRecapByMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelHistoriqueCaisse.this.jBntRecapByMonthActionPerformed(evt);
            }
        });
        this.jPanelMenuGlobal.add(this.jBntRecapByMonth);
        this.jPanelSharedSales.add((Component)this.jPanelMenuGlobal, "First");
        this.jPanelDetailSharedSales.setLayout(new BorderLayout());
        this.jPanelSharedOrders.setLayout(new BorderLayout());
        this.panelDatePickerSharedOrder.setPreferredSize(new Dimension(300, 35));
        this.panelDatePickerSharedOrder.setLayout(new FlowLayout(0));
        this.jPanelSharedOrders.add((Component)this.panelDatePickerSharedOrder, "First");
        this.jPanelTableHistorySharedOrders.setLayout(new BorderLayout());
        this.jTableSharedOrders.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneSharedOrder.setViewportView(this.jTableSharedOrders);
        this.jPanelTableHistorySharedOrders.add((Component)this.jScrollPaneSharedOrder, "Center");
        this.jSharedOrderEmpty.setFont(new Font("Tahoma", 1, 18));
        this.jSharedOrderEmpty.setHorizontalAlignment(0);
        this.jSharedOrderEmpty.setText("Aucun enregistrement");
        this.jPanelTableHistorySharedOrders.add((Component)this.jSharedOrderEmpty, "Center");
        this.jPanelSharedOrders.add((Component)this.jPanelTableHistorySharedOrders, "Center");
        this.jPanelFooterSharedOrders.setPreferredSize(new Dimension(200, 35));
        this.numberOrderShared.setPreferredSize(new Dimension(300, 14));
        this.jLabeltotalOrderShared.setHorizontalAlignment(4);
        this.jLabeltotalOrderShared.setPreferredSize(new Dimension(150, 14));
        GroupLayout jPanelFooterSharedOrdersLayout = new GroupLayout(this.jPanelFooterSharedOrders);
        this.jPanelFooterSharedOrders.setLayout(jPanelFooterSharedOrdersLayout);
        jPanelFooterSharedOrdersLayout.setHorizontalGroup(jPanelFooterSharedOrdersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFooterSharedOrdersLayout.createSequentialGroup().addContainerGap().addComponent(this.numberOrderShared, -1, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabeltotalOrderShared, -2, 165, -2).addGap(29, 29, 29)));
        jPanelFooterSharedOrdersLayout.setVerticalGroup(jPanelFooterSharedOrdersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFooterSharedOrdersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFooterSharedOrdersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabeltotalOrderShared, -2, -1, -2).addComponent(this.numberOrderShared, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelSharedOrders.add((Component)this.jPanelFooterSharedOrders, "South");
        this.jPanelDetailSharedSales.add((Component)this.jPanelSharedOrders, "Center");
        this.jPanelRecapGlobal.setLayout(new BorderLayout());
        this.panelFilterSharedSales.setPreferredSize(new Dimension(210, 30));
        this.panelFilterSharedSales.setLayout(new FlowLayout(0));
        this.jPanelRecapGlobal.add((Component)this.panelFilterSharedSales, "First");
        this.jPanelTableClotureGlobal.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanelTableClotureGlobal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelHistoriqueCaisse.this.jPanelTableClotureGlobalMouseClicked(evt);
            }
        });
        this.jPanelTableClotureGlobal.setLayout(new BorderLayout());
        this.jTableclotureGlobal.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableclotureGlobal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelHistoriqueCaisse.this.jTableclotureGlobalMouseClicked(evt);
            }
        });
        this.jScrollPaneClotureGlobal.setViewportView(this.jTableclotureGlobal);
        this.jPanelTableClotureGlobal.add((Component)this.jScrollPaneClotureGlobal, "Center");
        this.clotureGlobalEmpty.setFont(new Font("Tahoma", 1, 18));
        this.clotureGlobalEmpty.setHorizontalAlignment(0);
        this.clotureGlobalEmpty.setText("Aucune cloture dans cette p\u00e9riode");
        this.jPanelTableClotureGlobal.add((Component)this.clotureGlobalEmpty, "Center");
        this.jPanelRecapGlobal.add((Component)this.jPanelTableClotureGlobal, "Center");
        this.jPanelDetailSharedSales.add((Component)this.jPanelRecapGlobal, "Center");
        this.jPanelSharedSales.add((Component)this.jPanelDetailSharedSales, "Center");
        this.jPanelHistories.add((Component)this.jPanelSharedSales, "Center");
        this.add((Component)this.jPanelHistories, "Center");
    }

    private void jPrintCaisseActionPerformed(ActionEvent evt) {
        try {
            JXCaisse.showMessage(this, this.m_App, null, "caisse");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jResetJActionPerformed(ActionEvent evt) {
        Date dateFinArchivage = new Date();
        this.dateStart = new Date(dateFinArchivage.getYear(), dateFinArchivage.getMonth(), dateFinArchivage.getDate());
        com.openbravo.pos.util.DateUtils.setDateHours(this.dateStart, this.dateEnd);
        try {
            this.caNet = this.dlSales.getTurnover(this.dateStart, this.dateEnd);
            this.payments = this.dlSales.loadPaymentXDay(dateFinArchivage.getYear() + 1900, dateFinArchivage.getMonth() + 1, dateFinArchivage.getDate());
            this.m_iSales = this.dlSales.getNbOrderXDay(dateFinArchivage.getYear() + 1900, dateFinArchivage.getMonth() + 1, dateFinArchivage.getDate());
            this.caCanceled = this.dlSales.getCACanceledXDay(dateFinArchivage.getYear() + 1900, dateFinArchivage.getMonth() + 1, dateFinArchivage.getDate());
            this.taxes = this.dlSales.getTaxeXDay(dateFinArchivage.getYear() + 1900, dateFinArchivage.getMonth() + 1, dateFinArchivage.getDate());
            this.globalTaxes = this.dlStats.getGlobalTaxes(this.dateStart, this.dateEnd);
            this.allTaxes.clear();
            this.allTaxes.addAll(this.taxes);
            for (TaxeLine taxe : this.allTaxes) {
                this.taxAmount += taxe.getTax();
            }
            this.users = this.dlSales.getCAbyUserXDay(dateFinArchivage.getYear() + 1900, dateFinArchivage.getMonth() + 1, dateFinArchivage.getDate());
            this.orderPending = this.dlSales.getNbOrderPending();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (this.orderPending > 0) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci d'encaisser toutes les commandes en attente avant la fermeture de la caisse.", 1500, NPosition.CENTER);
        } else {
            int dialogButton = 0;
            int dialogResult = JOptionPane.showConfirmDialog(this.getComponent(), "Apr\u00e8s la cloture Journali\u00e8re ,vous ne pouvez plus passer des commandes aujourd'hui.\n\u00cates-vous s\u00fbr de vuloir continuer ?", "Cl\u00f4ture et archivage du Jour", dialogButton);
            if (dialogResult == 0) {
                double fondClose = 0.0;
                try {
                    fondClose = jPopupCloseCaisse.showMessage(this);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.caisse.setOuverte(false);
                this.caisse.setDateClose(new Date());
                this.caisse.setUser_close(this.m_App.getAppUserView().getUser().getUserInfo());
                this.caisse.setFondClose(fondClose);
                CaisseZ caisseZ = new CaisseZ();
                caisseZ.setDateClose(this.caisse.getDateClose());
                caisseZ.setDateOpen(this.caisse.getDateOpen());
                caisseZ.setCaisse(this.caisse.getId());
                caisseZ.setUser_close_id(this.caisse.getUser_close().getId());
                caisseZ.setUser_open_id(this.caisse.getUser_open_id());
                caisseZ.setHtAmount(this.htAmount);
                caisseZ.setTaxAmount(this.taxAmount);
                caisseZ.setTtcAmount(this.caNet);
                try {
                    Journal.writeToJET(new Event(170, "Traitement de fond de caisse", this.m_App.getAppUserView().getUser().getId(), "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.dlSales.closeCaisse(this.caisse, caisseZ, "j", this.allTaxes, this.m_App.getAppUserView().getUser().getId(), new Date());
                    this.dlSales.resetNumber();
                    ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.dlItems, this.m_App.getAppUserView().getUser().getId());
                    archivageUtils.archivRecursive("j", dateFinArchivage);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    List<RankCategory> m_resultCategories = this.dlStats.getRankCategories(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    for (RankCategory m_resultCategory : m_resultCategories) {
                        m_resultCategory.setRankProducts(this.dlStats.getRankItems(this.dateStart, this.dateEnd, m_resultCategory.getId()));
                    }
                    List<HourInfo> salesByHour = this.dlStats.loadSatisticByHour(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    List<TicketInfo> allTicketZCaisse = this.dlSales.loadAllTicket(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Double totalDiscount = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "pourcentage") + JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "somme");
                                Double totalDiscountOnLines = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOnTicketLines(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypeOrders = JPanelHistoriqueCaisse.this.dlStats.loadSatisticOrderByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypePlatformOrders = JPanelHistoriqueCaisse.this.dlStats.loadPlatformOrdersByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                PrinterHelper printer = new PrinterHelper();
                                Decreaser decreaser = new Decreaser(JPanelHistoriqueCaisse.this.dlSales, "", "Rapport fermeture", null, 0);
                                printer.printCloseCaisseCenter(JPanelHistoriqueCaisse.this.m_iSales, JPanelHistoriqueCaisse.this.caNet, null, JPanelHistoriqueCaisse.this.caCanceled, JPanelHistoriqueCaisse.this.taxAmount, JPanelHistoriqueCaisse.this.payments, JPanelHistoriqueCaisse.this.allTaxes, JPanelHistoriqueCaisse.this.users, JPanelHistoriqueCaisse.this.caisse, JPanelHistoriqueCaisse.this.marqueNF, JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, " Z journali\u00e8re", totalDiscount, totalDiscountOnLines, null, null, null, dataTypeOrders, decreaser, "day", null, dataTypePlatformOrders, JPanelHistoriqueCaisse.this.globalTaxes, 0.0, 0.0);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.m_App.closeAppView();
            }
        }
    }

    private void jCancelActionPerformed(ActionEvent evt) {
        block22: {
            if (this.currentOrder != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
                int dialogButton = 0;
                int dialogResult = JOptionPane.showConfirmDialog(this.getComponent(), "Voulez-vous vraiment annuler cette commande ?", "Annulation", dialogButton);
                if (dialogResult == 0) {
                    try {
                        Object[] results = JCancelOrder.showMessage(this);
                        boolean cancel_order = (Boolean)results[0];
                        if (!cancel_order) break block22;
                        String reason_cancel = (String)results[1];
                        if (reason_cancel != null && !reason_cancel.isEmpty()) {
                            try {
                                final TicketInfo ticketTracked = (TicketInfo)this.currentOrder.clone();
                                TicketInfo ticketLoyalty = (TicketInfo)this.currentOrder.clone();
                                boolean iscanceled = false;
                                if ("paid".equals(this.currentOrder.getStatus()) || this.currentOrder.getStatus().equalsIgnoreCase("livre")) {
                                    boolean hasCBPayment = true;
                                    for (PaymentInfo payment : this.currentOrder.getPayments()) {
                                        if (payment.getName().equalsIgnoreCase("CB")) continue;
                                        hasCBPayment = false;
                                        break;
                                    }
                                    System.out.println("********hasCBPayment ******* " + hasCBPayment);
                                    if (hasCBPayment && AppLocal.CMI_TPE_PAYMENT) {
                                        Object[] results_cmi = null;
                                        this.mTPECmi = TPECmi.getInstance();
                                        results_cmi = this.mTPECmi.doCancelCurrentPayment(this.currentOrder);
                                        if (results_cmi != null && results_cmi.length == 7) {
                                            boolean success = (Boolean)results_cmi[0];
                                            String message = String.valueOf(results_cmi[1]);
                                            final String ticket_cmi = String.valueOf(results[2]);
                                            String session_id = String.valueOf(results_cmi[3]);
                                            String ecr_stan = String.valueOf(results_cmi[4]);
                                            String eft_stan = String.valueOf(results_cmi[5]);
                                            String last4_digits = String.valueOf(results_cmi[6]);
                                            this.currentOrder.setSession_id(session_id);
                                            this.currentOrder.setEft_stan(eft_stan);
                                            this.currentOrder.setTag_erc_stan(ecr_stan);
                                            this.currentOrder.setLast_digit(last4_digits);
                                            this.currentOrder.setEcrDateTime(AppLocal.CURRENT_ECR_DATE_TIME);
                                            System.out.println("++++++++++success :" + success);
                                            if (success) {
                                                iscanceled = true;
                                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                                                if (ticket_cmi != null && !ticket_cmi.isEmpty()) {
                                                    final PrinterHelper printer = new PrinterHelper();
                                                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            JPanelHistoriqueCaisse.this.ticketService.printCmiTicketPayment(printer, ticket_cmi, true);
                                                        }
                                                    });
                                                }
                                            } else {
                                                iscanceled = false;
                                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                                            }
                                        }
                                    } else {
                                        iscanceled = true;
                                    }
                                    if (iscanceled) {
                                        this.currentOrder.setReason_cancel(reason_cancel);
                                        this.currentOrder = this.ticketService.cancelTicket(this.currentOrder, "Espece");
                                        this.currentOrder.setAddressInfo(this.mAddressService.findOne(this.currentOrder.getAddress()));
                                        this.currentOrder.setCustomer(this.dlSales.loadCustomerExt(this.currentOrder.getCustomerId()));
                                        List<TicketLineInfo> lines = this.dlSales.loadLines(this.currentOrder.getId());
                                        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(this.currentOrder.getId());
                                        lines.addAll(linesExterne);
                                        this.currentOrder.setLines(lines);
                                        this.entetTicket = this.dlSales.getEnteteByTicket(this.currentOrder.getId(), this.currentOrder.isPaid());
                                        Decreaser decreaser = new Decreaser(this.dlSales, this.currentOrder.getId(), "TICKET", null, this.currentOrder.getNumero_order());
                                        PrinterHelper printer = new PrinterHelper();
                                        printer.printRappelTickets(this.currentOrder.getNumero_order(), this.currentOrder, this.entetTicket, 0L, decreaser);
                                        System.out.println("+++++++++ contain CB");
                                    }
                                } else {
                                    iscanceled = true;
                                    this.dlSales.cancelOrderPending(this.currentOrder, reason_cancel, this.m_App.getAppUserView().getUser().getId());
                                    if (AppLocal.CUSTOMER_LOYALTY) {
                                        this.ticketService.deleteTransactionLoyalty(ticketLoyalty);
                                    }
                                }
                                if (iscanceled) {
                                    if (AppLocal.KITCHEN_COMPOSITE) {
                                        this.orderService.cancelOrder(this.currentOrder.getId());
                                    }
                                    this.printTikcetCanceled(this.currentOrder);
                                    ticketTracked.setReason_cancel(reason_cancel);
                                    if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                                        new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                JPanelHistoriqueCaisse.this.mPostgreService = PostgreService.getInstance();
                                                JPanelHistoriqueCaisse.this.mPostgreService.canceledOrder(ticketTracked);
                                            }
                                        }).start();
                                    }
                                    this.loadOrder();
                                    this.loadHistory();
                                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Commande annul\u00e9e.", 1500, NPosition.CENTER);
                                }
                                break block22;
                            }
                            catch (BasicException ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue.", 1500, NPosition.CENTER);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                            break block22;
                        }
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de pr\u00e9ciser la raison d'annulation.", 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private void jlistYearActionPerformed(ActionEvent evt) {
        try {
            this.loadCaisseZ();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jBntHistoryActionPerformed(ActionEvent evt) {
        this.loadHistory();
    }

    private void jBtnHistoryZActionPerformed(ActionEvent evt) {
        this.loadHistoryZ();
    }

    private void jlistMonthActionPerformed(ActionEvent evt) {
        try {
            this.loadCaisseZ();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jResetMActionPerformed(ActionEvent evt) {
        Date dateFinArchivage = new Date();
        if (this.orderPending > 0) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci d'encaisser toutes les commandes en attente avant la fermeture de la caisse.", 1500, NPosition.CENTER);
        } else {
            int dialogButton = 0;
            int dialogResult = JOptionPane.showConfirmDialog(this.getComponent(), "Apr\u00e8s la cloture mensuel ,vous ne pouvez plus passer des commandes ce mois.\n\u00cates-vous s\u00fbr de vuloir continuer ?", "Cl\u00f4ture et archivage du Mois", dialogButton);
            if (dialogResult == 0) {
                double fondClose = 0.0;
                try {
                    fondClose = jPopupCloseCaisse.showMessage(this);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.caisse.setOuverte(false);
                this.caisse.setDateClose(new Date());
                this.caisse.setUser_close(this.m_App.getAppUserView().getUser().getUserInfo());
                this.caisse.setFondClose(fondClose);
                CaisseZ caisseZ = new CaisseZ();
                caisseZ.setDateClose(this.caisse.getDateClose());
                caisseZ.setDateOpen(this.caisse.getDateOpen());
                caisseZ.setCaisse(this.caisse.getId());
                caisseZ.setUser_close_id(this.caisse.getUser_close().getId());
                caisseZ.setUser_open_id(this.caisse.getUser_open_id());
                caisseZ.setHtAmount(this.htAmount);
                caisseZ.setTaxAmount(this.taxAmount);
                caisseZ.setTtcAmount(this.caNet);
                try {
                    Journal.writeToJET(new Event(170, "Traitement de fond de caisse", this.m_App.getAppUserView().getUser().getId(), "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.dlSales.closeCaisse(this.caisse, caisseZ, "m", this.allTaxes, this.m_App.getAppUserView().getUser().getId(), new Date());
                    this.dlSales.resetNumber();
                    ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.dlItems, this.m_App.getAppUserView().getUser().getId());
                    archivageUtils.archivRecursive("m", dateFinArchivage);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Double totalDiscount = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "pourcentage") + JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "somme");
                                Double totalDiscountOnLines = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOnTicketLines(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypeOrders = JPanelHistoriqueCaisse.this.dlStats.loadSatisticOrderByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypePlatformOrders = JPanelHistoriqueCaisse.this.dlStats.loadPlatformOrdersByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                PrinterHelper printer = new PrinterHelper();
                                Decreaser decreaser = new Decreaser(JPanelHistoriqueCaisse.this.dlSales, "", "Rapport Mensuel", null, 0);
                                printer.printCloseCaisseCenter(JPanelHistoriqueCaisse.this.m_iSales, JPanelHistoriqueCaisse.this.caNet, null, JPanelHistoriqueCaisse.this.caCanceled, JPanelHistoriqueCaisse.this.taxAmount, JPanelHistoriqueCaisse.this.payments, JPanelHistoriqueCaisse.this.allTaxes, JPanelHistoriqueCaisse.this.users, JPanelHistoriqueCaisse.this.caisse, JPanelHistoriqueCaisse.this.marqueNF, JPanelHistoriqueCaisse.this.caisse.getDateOpen(), JPanelHistoriqueCaisse.this.caisse.getDateClose(), " Z mensuel ", totalDiscount, totalDiscountOnLines, null, null, null, dataTypeOrders, decreaser, "month", null, dataTypePlatformOrders, JPanelHistoriqueCaisse.this.globalTaxes, 0.0, 0.0);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                    List<RankCategory> m_resultCategories = this.dlStats.getRankCategories(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    for (RankCategory m_resultCategory : m_resultCategories) {
                        m_resultCategory.setRankProducts(this.dlStats.getRankItems(this.dateStart, this.dateEnd, m_resultCategory.getId()));
                    }
                    List<HourInfo> salesByHour = this.dlStats.loadSatisticByHour(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    List<TicketInfo> list = this.dlSales.loadAllTicket(this.caisse.getDateOpen(), this.caisse.getDateClose());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.m_App.closeAppView();
            }
        }
    }

    private void jResetAActionPerformed(ActionEvent evt) {
        Date dateFinArchivage = new Date();
        if (this.orderPending > 0) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci d'encaisser toutes les commandes en attente avant la fermeture de la caisse.", 1500, NPosition.CENTER);
        } else {
            int dialogButton = 0;
            int dialogResult = JOptionPane.showConfirmDialog(this.getComponent(), "Apr\u00e8s la cloture annuel ,vous ne pouvez plus passer des commandes cette ann\u00e9e.\n\u00cates-vous s\u00fbr de vuloir continuer ?", "Cl\u00f4ture et archivage de l'exercice ", dialogButton);
            if (dialogResult == 0) {
                double fondClose = 0.0;
                try {
                    fondClose = jPopupCloseCaisse.showMessage(this);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.caisse.setOuverte(false);
                this.caisse.setDateClose(new Date());
                this.caisse.setUser_close(this.m_App.getAppUserView().getUser().getUserInfo());
                this.caisse.setFondClose(fondClose);
                CaisseZ caisseZ = new CaisseZ();
                caisseZ.setDateClose(this.caisse.getDateClose());
                caisseZ.setDateOpen(this.caisse.getDateOpen());
                caisseZ.setCaisse(this.caisse.getId());
                caisseZ.setUser_close_id(this.caisse.getUser_close().getId());
                caisseZ.setUser_open_id(this.caisse.getUser_open_id());
                caisseZ.setHtAmount(this.htAmount);
                caisseZ.setTaxAmount(this.taxAmount);
                caisseZ.setTtcAmount(this.caNet);
                try {
                    Journal.writeToJET(new Event(170, "Traitement de fond de caisse", this.m_App.getAppUserView().getUser().getId(), "fon de caisse", new Date().getTime(), "" + caisseZ.getTtcAmount()));
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.dlSales.closeCaisse(this.caisse, caisseZ, "a", this.allTaxes, this.m_App.getAppUserView().getUser().getId(), new Date());
                    this.dlSales.resetNumber();
                    ArchivageService archivageUtils = new ArchivageService(this.dlSales, this.dlItems, this.m_App.getAppUserView().getUser().getId());
                    archivageUtils.archivRecursive("a", dateFinArchivage);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Double totalDiscount = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "pourcentage") + JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOrderOfType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd, "somme");
                                Double totalDiscountOnLines = JPanelHistoriqueCaisse.this.dlStats.getTotalDiscountOnTicketLines(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypeOrders = JPanelHistoriqueCaisse.this.dlStats.loadSatisticOrderByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                List<RankTypeOrder> dataTypePlatformOrders = JPanelHistoriqueCaisse.this.dlStats.loadPlatformOrdersByType(JPanelHistoriqueCaisse.this.dateStart, JPanelHistoriqueCaisse.this.dateEnd);
                                PrinterHelper printer = new PrinterHelper();
                                Decreaser decreaser = new Decreaser(JPanelHistoriqueCaisse.this.dlSales, com.openbravo.pos.util.DateUtils.SDF_YYYYMMDD.format(JPanelHistoriqueCaisse.this.dateEnd), "Rapport annuel", null, new Integer(com.openbravo.pos.util.DateUtils.SDF_YYYYMMDD.format(JPanelHistoriqueCaisse.this.dateEnd)));
                                printer.printCloseCaisseCenter(JPanelHistoriqueCaisse.this.m_iSales, JPanelHistoriqueCaisse.this.caNet, null, JPanelHistoriqueCaisse.this.caCanceled, JPanelHistoriqueCaisse.this.taxAmount, JPanelHistoriqueCaisse.this.payments, JPanelHistoriqueCaisse.this.allTaxes, JPanelHistoriqueCaisse.this.users, JPanelHistoriqueCaisse.this.caisse, JPanelHistoriqueCaisse.this.marqueNF, JPanelHistoriqueCaisse.this.caisse.getDateOpen(), JPanelHistoriqueCaisse.this.caisse.getDateClose(), " Z d'exercice", totalDiscount, totalDiscountOnLines, null, null, null, dataTypeOrders, decreaser, "day", null, dataTypePlatformOrders, JPanelHistoriqueCaisse.this.globalTaxes, 0.0, 0.0);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                    List<RankCategory> m_resultCategories = this.dlStats.getRankCategories(this.caisse.getDateOpen(), this.caisse.getDateClose());
                    for (RankCategory m_resultCategory : m_resultCategories) {
                        m_resultCategory.setRankProducts(this.dlStats.getRankItems(this.dateStart, this.dateEnd, m_resultCategory.getId()));
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.m_App.closeAppView();
            }
        }
    }

    private void jDetailActionPerformed(ActionEvent evt) {
        try {
            JDetail.showMessage(this, this.m_App, this.currentOrder);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jTablecaissesMouseClicked(MouseEvent evt) {
        int line = this.jTablecaisses.getSelectedRow();
        CaisseZ caisseZ = this.caisses.get(line);
        try {
            JXCaisse.showMessage(this, this.m_App, caisseZ, null);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jPrintActionPerformed(ActionEvent evt) {
        if (this.currentOrder != null && this.currentOrder.getLinesCount() > 0) {
            if (this.currentOrder.getStatus().equalsIgnoreCase("cancel") && this.currentOrder.isPaid()) {
                try {
                    TicketInfo ticketRefund = this.dlSales.getTicketByOrigin(this.currentOrder.getId());
                    TicketAvoir avoir = this.dlOrders.findTicketAvoirByTicket(ticketRefund.getId());
                    ticketRefund.setAddressInfo(this.mAddressService.findOne(ticketRefund.getAddress()));
                    ticketRefund.setCustomer(this.dlSales.loadCustomerExt(ticketRefund.getCustomerId()));
                    List<TicketLineInfo> lines = this.dlSales.loadLines(ticketRefund.getId());
                    List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticketRefund.getId());
                    lines.addAll(linesExterne);
                    ticketRefund.setLines(lines);
                    EnteteInfo entetTicket = this.dlSales.getEnteteByTicket(ticketRefund.getId(), true);
                    this.ticketService.printPaidTicketCaisse(ticketRefund, entetTicket, null);
                }
                catch (BasicException ex) {
                    Logger.getLogger(JPanelHistoriqueCaisse.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                final PrinterHelper printer = new PrinterHelper();
                if (!this.currentOrder.isPaid()) {
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JPanelHistoriqueCaisse.this.dlSales.addEnteteNoteAfterPrint(JPanelHistoriqueCaisse.this.currentOrder);
                                Decreaser decreaser = new Decreaser(JPanelHistoriqueCaisse.this.dlSales, JPanelHistoriqueCaisse.this.currentOrder.getId(), "Commande", null, JPanelHistoriqueCaisse.this.currentOrder.getNumero_order());
                                JPanelHistoriqueCaisse.this.entetTicket = JPanelHistoriqueCaisse.this.dlSales.getEnteteByTicket(JPanelHistoriqueCaisse.this.currentOrder.getId(), JPanelHistoriqueCaisse.this.currentOrder.isPaid());
                                printer.printRappelTickets(JPanelHistoriqueCaisse.this.currentOrder.getNumero_order(), JPanelHistoriqueCaisse.this.currentOrder, JPanelHistoriqueCaisse.this.entetTicket, 0L, decreaser);
                                JPanelHistoriqueCaisse.this.currentOrder.setPrint_after_update(true);
                                JPanelHistoriqueCaisse.this.jPrint.setEnabled(false);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                } else {
                    try {
                        this.entetTicket = this.dlSales.getEnteteByTicket(this.currentOrder.getId(), this.currentOrder.isPaid());
                        this.ticketService.printPaidTicketCaisse(this.currentOrder);
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
    }

    private void jPrintMonthActionPerformed(ActionEvent evt) {
        try {
            JXCaisse.showMessage(this, this.m_App, null, "month");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jPrintDayActionPerformed(ActionEvent evt) {
        try {
            JXCaisse.showMessage(this, this.m_App, null, "day");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jTableclotureMouseClicked(MouseEvent evt) {
        int line = this.jTablecloture.getSelectedRow();
        GrandTotalPeriode periode = this.cloturesData.get(line);
        try {
            JXCaisse.showMessage(this, this.m_App, periode, null, this.equipements_address);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jBtnClotureActionPerformed(ActionEvent evt) {
        this.viewClotures();
    }

    private void jChangePaymentActionPerformed(ActionEvent evt) {
        try {
            Object[] result = JEncaissement.showMessage(this, this.dlSales, this.dlOrders, this.m_App, this.currentOrder);
            if (((Boolean)result[1]).booleanValue()) {
                List m_aPaymentInfo = (List)result[0];
                Map ticketsAvoirs = (Map)result[5];
                HashMap ticketsRestau = (HashMap)result[7];
                List<PaymentInfo> paymentsTosave = PaymentUtils.getPaymentToSave(m_aPaymentInfo, this.currentOrder);
                this.currentOrder.setPayments(paymentsTosave);
                this.ticketService.updatePayment(this.currentOrder, paymentsTosave, ticketsAvoirs, ticketsRestau);
                this.loadOrder();
                this.loadHistory();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jPanelTableClotureMouseClicked(MouseEvent evt) {
    }

    private void jaddPaymentActionPerformed(ActionEvent evt) {
        try {
            Object[] result = JEncaissementOrder.showMessage(this, this.dlSales, this.dlOrders, this.m_App, this.currentOrder);
            if (((Boolean)result[1]).booleanValue()) {
                List m_aPaymentInfo = (List)result[0];
                List lines = (List)result[3];
                Map ticketsAvoirs = (Map)result[5];
                HashMap ticketsRestau = (HashMap)result[7];
                String holder_ticket = (String)result[10];
                this.encaisserOrder(lines, m_aPaymentInfo, ticketsAvoirs, ticketsRestau, holder_ticket);
                this.loadOrder();
                this.loadHistory();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jBntHistoryByDayActionPerformed(ActionEvent evt) {
        this.loadHistoryByDay();
    }

    private void btn_next_dateActionPerformed(ActionEvent evt) {
        this.next();
    }

    private void btn_previous_dateActionPerformed(ActionEvent evt) {
        this.previous();
    }

    private void jBntHistoryCanceledActionPerformed(ActionEvent evt) {
        this.loadHistoryCanceled();
    }

    private void jListTypeClotureActionPerformed(ActionEvent evt) {
        String typeCloture = (String)this.jListTypeCloture.getSelectedItem();
        if (typeCloture != null) {
            this.panelFilterClotures.removeAll();
            switch (typeCloture) {
                case "Journalier": {
                    this.type_filter_cloture = "Journalier";
                    this.panelFilterClotures.add(this.jListMonthCloture);
                    this.panelFilterClotures.add(this.jListYearsClotures);
                    break;
                }
                case "Mensuel": {
                    this.type_filter_cloture = "Mensuel";
                    this.panelFilterClotures.add(this.jListYearsClotures);
                    break;
                }
                case "Annuel": {
                    this.type_filter_cloture = "Annuel";
                }
            }
            this.panelFilterClotures.revalidate();
            this.panelFilterClotures.repaint();
            if (this.type_filter_cloture.equalsIgnoreCase("Journalier") && this.month_cloture != 0 && this.year_cloture != 0 || this.type_filter_cloture.equalsIgnoreCase("Mensuel") && this.year_cloture != 0 || this.type_filter_cloture.equalsIgnoreCase("Annuel")) {
                this.loadClotures();
            }
        }
    }

    private void jListMonthClotureActionPerformed(ActionEvent evt) {
        MonthInfo current_month = (MonthInfo)this.jListMonthCloture.getSelectedItem();
        if (current_month != null) {
            this.month_cloture = current_month.getId();
            if (this.type_cloture == null || this.type_cloture.equalsIgnoreCase("local")) {
                this.loadClotures();
            } else {
                this.loadCloturesGlobal();
            }
        }
    }

    private void jListYearsCloturesActionPerformed(ActionEvent evt) {
        Integer current_year = (Integer)this.jListYearsClotures.getSelectedItem();
        if (current_year != null) {
            this.year_cloture = current_year;
            if (this.type_cloture == null || this.type_cloture.equalsIgnoreCase("local")) {
                this.loadClotures();
            } else {
                this.loadCloturesGlobal();
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            JExportRapport.showMessage(this, this.m_App, this.dlSales, this.dlStats);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jBntSharedOrdersActionPerformed(ActionEvent evt) {
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelSharedSales, "Center");
        this.jPanelHistory.setVisible(false);
        this.jPanelHistoryZ.setVisible(false);
        this.jPanelCloture.setVisible(false);
        this.jPanelSharedSales.setVisible(true);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setBackground(new Color(89, 171, 227));
        this.panelDatePicker.setVisible(false);
    }

    private void jBntSharedOrdersByDayActionPerformed(ActionEvent evt) {
        this.type_orders = "orders_shared";
        this.jPanelDetailSharedSales.removeAll();
        this.jPanelDetailSharedSales.add((Component)this.jPanelSharedOrders, "Center");
        this.jPanelSharedOrders.setVisible(true);
        this.jPanelRecapGlobal.setVisible(false);
        this.jPanelDetailSharedSales.revalidate();
        this.jPanelDetailSharedSales.repaint();
        this.jBntSharedOrdersByDay.setBackground(new Color(89, 171, 227));
        this.jBntRecapByDay.setBackground(new Color(129, 207, 224));
        this.jBntRecapByMonth.setBackground(new Color(129, 207, 224));
        this.initTime();
        if (this.set_nodes_date_picker_shared) {
            this.loadNodeDatePickerSharedOrders();
        }
        this.set_nodes_date_picker = true;
        this.set_nodes_date_picker_shared = false;
        this.jSharedOrderEmpty.setText("Chargement en cours ...");
        this.jPanelTableHistorySharedOrders.removeAll();
        this.jPanelTableHistorySharedOrders.add((Component)this.jSharedOrderEmpty, "Center");
        this.jSharedOrderEmpty.setVisible(true);
        this.jScrollPaneSharedOrder.setVisible(false);
        this.jPanelTableHistorySharedOrders.revalidate();
        this.jPanelTableHistorySharedOrders.repaint();
        new Thread(new Runnable(){

            @Override
            public void run() {
                JPanelHistoriqueCaisse.this.loadOrdersSharedByDay();
            }
        }).start();
    }

    private void jBntRecapByDayActionPerformed(ActionEvent evt) {
        this.filter_by_month = true;
        this.loadRecapGlobal();
        this.panelFilterClotures.removeAll();
        this.panelFilterClotures.revalidate();
        this.panelFilterClotures.repaint();
        this.panelFilterSharedSales.removeAll();
        this.panelFilterSharedSales.add(this.jListMonthCloture);
        this.panelFilterSharedSales.add(this.jListYearsClotures);
        this.panelFilterSharedSales.revalidate();
        this.panelFilterSharedSales.repaint();
        this.jBntRecapByDay.setBackground(new Color(89, 171, 227));
        this.jBntRecapByMonth.setBackground(new Color(129, 207, 224));
    }

    private void jBntRecapByMonthActionPerformed(ActionEvent evt) {
        this.filter_by_month = false;
        this.loadRecapGlobal();
        this.panelFilterClotures.removeAll();
        this.panelFilterClotures.revalidate();
        this.panelFilterClotures.repaint();
        this.panelFilterSharedSales.removeAll();
        this.panelFilterSharedSales.add(this.jListYearsClotures);
        this.panelFilterSharedSales.revalidate();
        this.panelFilterSharedSales.repaint();
        this.jBntRecapByMonth.setBackground(new Color(89, 171, 227));
        this.jBntRecapByDay.setBackground(new Color(129, 207, 224));
    }

    private void jTableclotureGlobalMouseClicked(MouseEvent evt) {
        int line = this.jTableclotureGlobal.getSelectedRow();
        ZGlobalInfoDTO periodeGlobal = this.recapsSharedSaleses.get(line);
        try {
            JXCaisse.showMessage(this, this.m_App, null, periodeGlobal, this.equipements_address);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jPanelTableClotureGlobalMouseClicked(MouseEvent evt) {
    }

    public void initCalendar() {
        Calendar calendar = Calendar.getInstance();
        this.dateEnd = new Date();
        calendar.setTime(this.dateEnd);
        calendar.add(2, -1);
        this.dateStart = calendar.getTime();
        UtilDateModel modelStart = new UtilDateModel(this.dateStart);
        Properties p = new Properties();
        p.put("text.today", "Aujourd'hui");
        p.put("text.month", "Mois");
        p.put("text.year", "Ann\u00e9e");
        JDatePanelImpl datePanel = new JDatePanelImpl((DateModel)modelStart, p);
        final JDatePickerImpl datePickerStart = new JDatePickerImpl(datePanel, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
        datePickerStart.getModel().setSelected(true);
        datePickerStart.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Date selectedDate;
                if (!JPanelHistoriqueCaisse.this.firstTime && (selectedDate = (Date)datePickerStart.getModel().getValue()) != null) {
                    JPanelHistoriqueCaisse.this.dateStart = selectedDate;
                    try {
                        JPanelHistoriqueCaisse.this.loadClotures();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
        datePickerStart.setPreferredSize(new Dimension(300, 30));
        JPanel paneDate = new JPanel();
        paneDate.setLayout(new FlowLayout(2));
        paneDate.add((Component)datePickerStart);
        UtilDateModel modelEnd = new UtilDateModel(this.dateEnd);
        JDatePanelImpl datePanelEnd = new JDatePanelImpl((DateModel)modelEnd, p);
        final JDatePickerImpl datePickerEnd = new JDatePickerImpl(datePanelEnd, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
        datePickerEnd.getModel().setSelected(true);
        datePickerEnd.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Date selectedDate;
                if (!JPanelHistoriqueCaisse.this.firstTime && (selectedDate = (Date)datePickerEnd.getModel().getValue()) != null) {
                    JPanelHistoriqueCaisse.this.dateEnd = selectedDate;
                    try {
                        JPanelHistoriqueCaisse.this.loadClotures();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
        datePickerEnd.setPreferredSize(new Dimension(300, 30));
        JPanel paneDateEnd = new JPanel();
        paneDateEnd.setLayout(new FlowLayout(2));
        paneDateEnd.add((Component)datePickerEnd);
        this.jListYearsClotures.removeAllItems();
        int first_year = 2017;
        Integer last_year = new Date().getYear() + 1900;
        for (int i = first_year; i <= last_year; ++i) {
            this.jListYearsClotures.addItem(i);
        }
        this.jListYearsClotures.setSelectedItem(last_year);
        this.jListMonthCloture.removeAllItems();
        for (MonthInfo mois : this.listMonths) {
            this.jListMonthCloture.addItem(mois);
        }
        this.jListMonthCloture.setSelectedItem(this.month);
        this.firstTime = false;
    }

    public void initClotures() {
        double width = AppVarUtils.getScreenDimension().getWidth() - 20.0;
        this.initCalendar();
        ArrayList<Object> tva_local = new ArrayList<Object>();
        tva_local.add("Identifiant");
        tva_local.add("Type de Cloture");
        tva_local.add("P\u00e9riode clotur\u00e9");
        tva_local.add("Cumule de p\u00e9riode");
        tva_local.add("Cumule Perpetuel");
        for (TaxInfo taxInfo : this.taxesInfo) {
            if (!taxInfo.isEnabled()) continue;
            tva_local.add("TVA " + taxInfo.getName());
        }
        tva_local.add("Date de Cloture");
        tva_local.add("Heure de cloture");
        Object[] columnsClotures = new String[tva_local.size()];
        columnsClotures = tva_local.toArray(columnsClotures);
        this.modelClotures.setColumnIdentifiers(columnsClotures);
        try {
            this.loadClotures();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.modelClotures.setColumnIdentifiers(columnsClotures);
        this.jTablecloture.setModel(this.modelClotures);
        this.jTablecloture.setAutoResizeMode(4);
        this.jTablecloture.setRowHeight(40);
        TableColumnModel colModel = this.jTablecloture.getColumnModel();
        double widthColumn = this.number_taxes > 4 ? width * 0.065 : width * 0.09;
        double withTaxes = this.number_taxes > 4 ? 0.55 : 0.37;
        int column = 0;
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        double width_tax = withTaxes / (double)this.number_taxes;
        for (int i = 0; i < this.number_taxes; ++i) {
            colModel.getColumn(column++).setPreferredWidth((int)(width * width_tax));
        }
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
        colModel.getColumn(column++).setPreferredWidth((int)widthColumn);
    }

    private void printTikcetCanceled(TicketInfo ticket) {
        final TicketInfo tikcetToSend = (TicketInfo)ticket.clone();
        this.ticketService.prepareTicketCuisine(tikcetToSend);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JPanelHistoriqueCaisse.this.ticketService.printKitchenTicketCanceld(tikcetToSend);
            }
        });
    }

    public void loadHistoryByDay() {
        this.initTime();
        this.type_orders = "orders_by_day";
        this.loadOrdersByDay();
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelHistory, "Center");
        this.jPanelHistory.setVisible(true);
        this.jPanelHistoryZ.setVisible(false);
        this.jPanelSharedSales.setVisible(false);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(89, 171, 227));
        this.jBntHistoryCanceled.setBackground(new Color(129, 207, 224));
        this.jBntSharedOrders.setBackground(new Color(29, 207, 224));
        this.panelDatePicker.setVisible(true);
        this.jPanelFooter.setVisible(false);
        if (this.set_nodes_date_picker) {
            this.loadNodeDatePicker();
        }
        this.set_nodes_date_picker = false;
        this.set_nodes_date_picker_shared = true;
    }

    private void buildPaneOrders(List<TicketInfo> tickets) {
        this.orders = tickets;
        this.currentOrder = null;
        this.listCancel.clear();
        this.modelOrder.setRowCount(0);
        this.modelDetail.setRowCount(0);
        this.countOrder = 0;
        this.totalOrder = 0.0;
        if (this.orders.size() > 0) {
            this.jPanelTableHistory.removeAll();
            this.jPanelTableHistory.add((Component)this.jScrollPane1, "Center");
            this.jOrderEmpty.setVisible(false);
            this.jScrollPane1.setVisible(true);
            this.jPanelTableHistory.revalidate();
            this.jPanelTableHistory.repaint();
            if ("venteDetail".equals(AppLocal.licence)) {
                Object[] rowData = new Object[6];
                for (int i = 0; i < this.orders.size(); ++i) {
                    String orderNum = this.orders.get(i).getNumberOrder();
                    rowData[0] = orderNum;
                    rowData[1] = this.fullDateFormatter.format(this.orders.get(i).getDate());
                    if (this.orders.get(i).getStatus() != null) {
                        switch (this.orders.get(i).getStatus()) {
                            case "livre": {
                                rowData[2] = "Livr\u00e9e";
                                break;
                            }
                            case "paid": {
                                rowData[2] = "Termin\u00e9e";
                                break;
                            }
                            case "cancel": {
                                if (this.orders.get(i).getReason_cancel() != null) {
                                    rowData[2] = "Annul\u00e9e (" + this.orders.get(i).getReason_cancel() + ")";
                                    break;
                                }
                                rowData[2] = "Annul\u00e9e";
                                break;
                            }
                            case "pending": {
                                rowData[2] = "En cours";
                                break;
                            }
                            case "Refund": {
                                rowData[2] = "Remboursement";
                            }
                        }
                    }
                    Object discount = "";
                    if (this.orders.get(i).getDiscount() > 0.0) {
                        discount = " / promo: ";
                        discount = (String)discount + (this.orders.get(i).getTypeDiscount().equalsIgnoreCase("pourcentage") ? this.orders.get(i).getDiscount() + "%" : this.orders.get(i).getDiscount() + "\u20ac");
                    }
                    rowData[3] = this.orders.get(i).printTotalOrder() + (String)discount;
                    Object payments = "<html>";
                    if (this.orders.get(i).isPaid()) {
                        for (PaymentInfo payment : this.orders.get(i).getPayments()) {
                            payments = (String)payments + payment.getName() + " : " + payment.printTotal() + "<br>";
                        }
                    }
                    rowData[4] = payments = (String)payments + "</html>";
                    rowData[5] = this.orders.get(i).getUser().getName();
                    this.modelOrder.addRow(rowData);
                    if ("paid".equals(this.orders.get(i).getStatus()) || this.orders.get(i).getStatus().equalsIgnoreCase("livre")) {
                        ++this.countOrder;
                        this.totalOrder = this.totalOrder + this.orders.get(i).getTotalOrder();
                    }
                    if (!"cancel".equals(this.orders.get(i).getStatus())) continue;
                    this.listCancel.add(i);
                }
            } else {
                Object[] rowData = new Object[7];
                for (int i = 0; i < this.orders.size(); ++i) {
                    String orderNum = this.orders.get(i).getNumberOrder();
                    rowData[0] = orderNum;
                    rowData[1] = this.fullDateFormatter.format(this.orders.get(i).getDate());
                    rowData[2] = this.orders.get(i).getType();
                    if (this.orders.get(i).getStatus() != null) {
                        switch (this.orders.get(i).getStatus()) {
                            case "livre": {
                                rowData[3] = "Livr\u00e9e";
                                break;
                            }
                            case "paid": {
                                rowData[3] = "Termin\u00e9e";
                                break;
                            }
                            case "cancel": {
                                if (this.orders.get(i).getReason_cancel() != null) {
                                    rowData[3] = "Annul\u00e9e (" + this.orders.get(i).getReason_cancel() + ")";
                                    break;
                                }
                                rowData[3] = "Annul\u00e9e";
                                break;
                            }
                            case "pending": {
                                rowData[3] = "En cours";
                                break;
                            }
                            case "Refund": {
                                rowData[3] = "Remboursement";
                            }
                        }
                    }
                    Object discount = "";
                    if (this.orders.get(i).getDiscount() > 0.0) {
                        discount = " / promo: ";
                        discount = (String)discount + (this.orders.get(i).getTypeDiscount().equalsIgnoreCase("pourcentage") ? this.orders.get(i).getDiscount() + "%" : this.orders.get(i).getDiscount() + "\u20ac");
                    }
                    rowData[4] = this.orders.get(i).printTotalOrder() + (String)discount;
                    Object payments = "<html>";
                    if (this.orders.get(i).isPaid()) {
                        for (PaymentInfo payment : this.orders.get(i).getPayments()) {
                            payments = (String)payments + payment.getName() + " : " + payment.printTotal() + "<br>";
                        }
                    }
                    rowData[5] = payments = (String)payments + "</html>";
                    rowData[6] = this.orders.get(i).getUser().getName();
                    this.modelOrder.addRow(rowData);
                    if ("paid".equals(this.orders.get(i).getStatus()) || this.orders.get(i).getStatus().equalsIgnoreCase("livre")) {
                        ++this.countOrder;
                        this.totalOrder = this.totalOrder + this.orders.get(i).getTotalOrder();
                    }
                    if (!"cancel".equals(this.orders.get(i).getStatus())) continue;
                    this.listCancel.add(i);
                }
            }
            this.jTableOrders.setDefaultRenderer(Object.class, new colorCancelCellRenderer(this.listCancel));
            this.jTableOrders.setModel(this.modelOrder);
        } else {
            this.jPanelTableHistory.removeAll();
            this.jPanelTableHistory.add((Component)this.jOrderEmpty, "Center");
            this.jScrollPane1.setVisible(false);
            this.jOrderEmpty.setVisible(true);
            this.jPanelTableHistory.revalidate();
            this.jPanelTableHistory.repaint();
        }
        this.numberOrder.setText("Nombre de commandes termin\u00e9es: " + this.countOrder);
        this.jLabeltotalOrder.setText("Total: " + this.printTotalOrder());
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart_orders = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd_orders = calEnd.getTime();
    }

    public void next() {
        this.isToday = false;
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date_order);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jDate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jDate.setText("Aujourd'hui");
            this.isToday = true;
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jDate.setText("Hier");
        }
        this.date_order = cal.getTime();
        this.setTime(this.date_order);
        this.loadOrdersByDay();
    }

    public void previous() {
        this.isToday = false;
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date_order);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jDate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jDate.setText("Aujourd'hui");
            this.isToday = true;
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jDate.setText("Hier");
        }
        this.date_order = cal.getTime();
        this.setTime(this.date_order);
        this.loadOrdersByDay();
    }

    private void loadOrdersByDay() {
        try {
            switch (this.type_orders) {
                case "orders_by_day": {
                    this.tickets_by_day = this.isToday ? this.dlSales.loadBydateOpen() : this.dlOrders.loadPaidOrder(this.dateStart_orders, this.dateEnd_orders);
                    this.buildPaneOrders(this.tickets_by_day);
                    break;
                }
                case "orders_canceled": {
                    this.tickets_canceled = this.dlSales.loadTicketcanceled(this.dateStart_orders, this.dateEnd_orders);
                    this.buildPaneOrders(this.tickets_canceled);
                    break;
                }
                case "orders_shared": {
                    this.loadOrdersSharedByDay();
                }
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadHistoryCanceled() {
        this.initTime();
        this.type_orders = "orders_canceled";
        this.loadOrdersByDay();
        this.jPanelHistories.removeAll();
        this.jPanelHistories.add((Component)this.jPanelHistory, "Center");
        this.jPanelHistory.setVisible(true);
        this.jPanelHistoryZ.setVisible(false);
        this.jPanelSharedSales.setVisible(false);
        this.jPanelHistories.revalidate();
        this.jPanelHistories.repaint();
        this.jBntHistory.setBackground(new Color(129, 207, 224));
        this.jBtnHistoryZ.setBackground(new Color(129, 207, 224));
        this.jBtnCloture.setBackground(new Color(129, 207, 224));
        this.jBntHistoryByDay.setBackground(new Color(129, 207, 224));
        this.jBntHistoryCanceled.setBackground(new Color(89, 171, 227));
        this.jBntSharedOrders.setBackground(new Color(29, 207, 224));
        this.panelDatePicker.setVisible(true);
        this.jPanelFooter.setVisible(false);
        if (this.set_nodes_date_picker) {
            this.loadNodeDatePicker();
        }
        this.set_nodes_date_picker = false;
        this.set_nodes_date_picker_shared = true;
    }

    private void initTime() {
        Calendar calToday = Calendar.getInstance();
        this.date_order = DateUtils.getToday();
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date_order = calToday.getTime();
        }
        this.btn_next_date.setVisible(false);
        this.setTime(this.date_order);
        this.jDate.setText("Aujourd'hui");
        this.isToday = true;
    }

    private void buildPaneOrdersGlobal(List<TicketInfo> tickets) {
        this.currentOrder = null;
        this.listCancel.clear();
        this.modelOrdersShared.setRowCount(0);
        this.countOrder = 0;
        this.totalOrder = 0.0;
        int i = 0;
        if (tickets.size() > 0) {
            this.jPanelTableHistorySharedOrders.removeAll();
            this.jPanelTableHistorySharedOrders.add((Component)this.jScrollPaneSharedOrder, "Center");
            this.jSharedOrderEmpty.setVisible(false);
            this.jScrollPaneSharedOrder.setVisible(true);
            this.jPanelTableHistorySharedOrders.revalidate();
            this.jPanelTableHistorySharedOrders.repaint();
            Object[] rowData = new Object[9];
            for (TicketInfo sharedOrder : tickets) {
                Object number_shared_order;
                rowData[0] = number_shared_order = sharedOrder.getNum_order_kitchen() != -1 && sharedOrder.getNum_order_kitchen() != 0 ? String.valueOf(sharedOrder.getNum_order_kitchen()) : (sharedOrder.getSource_order() != null && sharedOrder.getSource_order().equals("borne") ? "C-" + sharedOrder.getNum_order_borne() : "C-" + sharedOrder.getNumero_order());
                rowData[1] = sharedOrder.getNum_table() != 0 ? Integer.valueOf(sharedOrder.getNum_table()) : "";
                rowData[2] = this.fullDateFormatter.format(sharedOrder.getDate());
                rowData[3] = sharedOrder.getType();
                Object discount = "";
                if (sharedOrder.getDiscount() > 0.0) {
                    discount = " / promo: ";
                    discount = (String)discount + (sharedOrder.getTypeDiscount().equalsIgnoreCase("pourcentage") ? sharedOrder.getDiscount() + "%" : sharedOrder.getDiscount() + "\u20ac");
                }
                Object payments = "<html>";
                for (PaymentInfo payment : sharedOrder.getPayments()) {
                    payments = (String)payments + payment.getName() + " : " + payment.getTotal() + "<br>";
                }
                rowData[4] = payments = (String)payments + "</html>";
                rowData[5] = Formats.CURRENCY.formatValue(sharedOrder.getTotalOrder()) + (String)discount;
                rowData[6] = sharedOrder.getUser() != null ? sharedOrder.getUser().getName() : "";
                rowData[7] = sharedOrder.getSource_order();
                switch (sharedOrder.getStatus()) {
                    case "livre": {
                        rowData[8] = "Livr\u00e9e";
                        break;
                    }
                    case "paid": {
                        rowData[8] = "Termin\u00e9e";
                        break;
                    }
                    case "cancel": {
                        rowData[8] = sharedOrder.getReason_cancel() != null ? "Annul\u00e9e (" + sharedOrder.getReason_cancel() + ")" : "Annul\u00e9e";
                        this.listCancel.add(i);
                        break;
                    }
                    case "pending": {
                        rowData[8] = "En cours";
                        break;
                    }
                    case "Refund": {
                        rowData[8] = "Remboursement";
                    }
                }
                if (sharedOrder.isPaid()) {
                    ++this.countOrder;
                    this.totalOrder = this.totalOrder + sharedOrder.getTotalOrder();
                }
                this.modelOrdersShared.addRow(rowData);
                ++i;
            }
        } else {
            this.jSharedOrderEmpty.setText("Aucun enregistrement");
            this.jPanelTableHistorySharedOrders.removeAll();
            this.jPanelTableHistorySharedOrders.add((Component)this.jSharedOrderEmpty, "Center");
            this.jSharedOrderEmpty.setVisible(true);
            this.jScrollPaneSharedOrder.setVisible(false);
            this.jPanelTableHistorySharedOrders.revalidate();
            this.jPanelTableHistorySharedOrders.repaint();
        }
        this.jTableSharedOrders.setDefaultRenderer(Object.class, new colorCancelCellRenderer(this.listCancel));
        this.jTableSharedOrders.setModel(this.modelOrdersShared);
        this.numberOrderShared.setText("Nombre de commandes termin\u00e9es: " + this.countOrder);
        this.jLabeltotalOrderShared.setText("Total: " + this.printTotalOrder());
    }

    private void loadRecapGlobal() {
        this.type_cloture = "global";
        this.jPanelDetailSharedSales.removeAll();
        this.jPanelDetailSharedSales.add((Component)this.jPanelRecapGlobal, "Center");
        this.jPanelSharedOrders.setVisible(false);
        this.jPanelRecapGlobal.setVisible(true);
        this.jPanelDetailSharedSales.revalidate();
        this.jPanelDetailSharedSales.repaint();
        this.jBntSharedOrdersByDay.setBackground(new Color(129, 207, 224));
        this.loadCloturesGlobal();
    }

    public void loadCloturesGlobal() {
        int numberColumns = 2 + this.number_taxes;
        int column = 0;
        try {
            String type_periode = "";
            if (this.filter_by_month) {
                type_periode = "j";
                this.recapsSharedSaleses = this.mZGlobalService.getZglobal(this.month_cloture, this.year_cloture, this.equipements_address);
            } else {
                ZGlobalInfoDTO xGlobal;
                type_periode = "m";
                this.recapsSharedSaleses = this.mZGlobalService.getZglobal(this.year_cloture, this.equipements_address);
                int this_year = new Date().getYear() + 1900;
                if (this_year == this.year_cloture && (xGlobal = this.mZGlobalService.getXglobal(this.equipements_address)) != null) {
                    this.recapsSharedSaleses.add(xGlobal);
                }
            }
            this.modelCloturesGlobal.setRowCount(0);
            this.jPanelTableClotureGlobal.removeAll();
            if (this.recapsSharedSaleses.size() > 0) {
                this.jPanelTableClotureGlobal.add((Component)this.jScrollPaneClotureGlobal, "Center");
                this.jScrollPaneClotureGlobal.setVisible(true);
                this.clotureGlobalEmpty.setVisible(false);
                for (ZGlobalInfoDTO recapSharedSaleses : this.recapsSharedSaleses) {
                    Object[] rowData = new Object[numberColumns];
                    column = 0;
                    rowData[column++] = recapSharedSaleses.displayPeriodeName(type_periode);
                    rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTotal());
                    for (TaxInfo taxInfo : this.taxesInfo) {
                        if (!taxInfo.isEnabled()) continue;
                        if (taxInfo.isTax_global()) {
                            rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTaxeByName(taxInfo.getName()));
                            continue;
                        }
                        switch (taxInfo.getName()) {
                            case "0%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_0());
                                break;
                            }
                            case "5.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_5_5());
                                break;
                            }
                            case "10%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_10());
                                break;
                            }
                            case "20%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_20());
                                break;
                            }
                            case "7.7%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_7_7());
                                break;
                            }
                            case "2.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_2_5());
                                break;
                            }
                            case "2.1%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_2_1());
                                break;
                            }
                            case "8.5%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_8_5());
                                break;
                            }
                            case "6%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_6());
                                break;
                            }
                            case "12%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_12());
                                break;
                            }
                            case "21%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_21());
                                break;
                            }
                            case "8.1%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_8_1());
                                break;
                            }
                            case "2.6%": {
                                rowData[column++] = Formats.CURRENCY.formatValue(recapSharedSaleses.getTva_2_6());
                            }
                        }
                    }
                    this.modelCloturesGlobal.addRow(rowData);
                }
                this.jTableclotureGlobal.setModel(this.modelCloturesGlobal);
                this.jPanelTableClotureGlobal.revalidate();
                this.jPanelTableClotureGlobal.repaint();
            } else {
                this.jPanelTableClotureGlobal.add((Component)this.clotureGlobalEmpty, "Center");
                this.jScrollPaneClotureGlobal.setVisible(false);
                this.clotureGlobalEmpty.setVisible(true);
            }
            this.jPanelTableClotureGlobal.revalidate();
            this.jPanelTableClotureGlobal.repaint();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    private void loadOrdersSharedByDay() {
        this.ticketsShared_by_day = this.ticketService.getTicketsEquippements(this.dateStart_orders, this.dateEnd_orders);
        this.buildPaneOrdersGlobal(this.ticketsShared_by_day);
    }

    private void loadNodeDatePickerSharedOrders() {
        this.panelDatePickerSharedOrder.removeAll();
        this.panelDatePickerSharedOrder.add(this.btn_previous_date);
        this.panelDatePickerSharedOrder.add(this.jDate);
        this.panelDatePickerSharedOrder.add(this.btn_next_date);
        this.panelDatePickerSharedOrder.repaint();
        this.panelDatePickerSharedOrder.revalidate();
    }

    private void loadNodeDatePicker() {
        this.panelDatePicker.removeAll();
        this.panelDatePicker.add(this.btn_previous_date);
        this.panelDatePicker.add(this.jDate);
        this.panelDatePicker.add(this.btn_next_date);
        this.panelDatePicker.repaint();
        this.panelDatePicker.revalidate();
    }

    private static class colorCancelCellRenderer
    extends DefaultTableCellRenderer {
        private final List<Integer> ticketsCancel;

        public colorCancelCellRenderer(List<Integer> ticketsCancel) {
            this.ticketsCancel = ticketsCancel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int found = -1;
            for (Integer ticket : this.ticketsCancel) {
                if (row != ticket) continue;
                found = 1;
            }
            if (found == 1) {
                c.setForeground(Color.red);
            } else {
                c.setForeground(Color.BLACK);
            }
            return c;
        }
    }
}

