/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.sales.DateLabelFormatter;
import com.openbravo.pos.ticket.LogPanier;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.ProDefaultTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.jdatepicker.DateModel;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class JListLogPaniers
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private int day;
    private int year;
    private int month;
    protected DefaultTableModel modelLog;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    protected AppView m_App;
    protected DataLogicSales dlSales;
    private List<LogPanier> paniers;
    private boolean firstTime;
    private JLabel PanierEmpty;
    private JLabel jLabel1;
    private JPanel jPanel7;
    private JPanel jPanelMain;
    private JPanel jPanelTitle;
    private JPanel jPaneldate;
    private JScrollPane jScrollPane1;
    private JTable jTableLog;

    public JListLogPaniers() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.modelLog = new ProDefaultTableModel();
        this.jTableLog.setRowHeight(40);
        Object[] columnsOrders = new String[]{"Numero commande", "Date Suppression", "Heure Suppression", "Nom utilisateur", "Produit", "Quantit\u00e9", "Prix", "Promotion"};
        this.modelLog.setColumnIdentifiers(columnsOrders);
        this.jTableLog.setModel(this.modelLog);
        this.paniers = new ArrayList<LogPanier>();
        Date date = new Date();
        this.day = date.getDate();
        this.month = date.getMonth() + 1;
        this.year = date.getYear() + 1900;
        UtilDateModel model = new UtilDateModel();
        Properties p = new Properties();
        p.put("text.today", "Aujourd'hui");
        p.put("text.month", "Mois");
        p.put("text.year", "Ann\u00e9e");
        this.firstTime = true;
        JDatePanelImpl datePanel = new JDatePanelImpl((DateModel)model, p);
        final JDatePickerImpl datePicker = new JDatePickerImpl(datePanel, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
        datePicker.getModel().setSelected(true);
        datePicker.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Date selectedDate;
                if (!JListLogPaniers.this.firstTime && (selectedDate = (Date)datePicker.getModel().getValue()) != null) {
                    JListLogPaniers.this.day = selectedDate.getDate();
                    JListLogPaniers.this.month = selectedDate.getMonth() + 1;
                    JListLogPaniers.this.year = selectedDate.getYear() + 1900;
                    try {
                        JListLogPaniers.this.loadPaniers();
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        });
        datePicker.setPreferredSize(new Dimension(300, 30));
        this.jPaneldate.add((Component)datePicker);
        try {
            this.loadPaniers();
            this.firstTime = false;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void loadPaniers() throws BasicException {
        this.paniers = this.dlSales.loadLogPanier(this.year, this.month, this.day);
        this.modelLog.setRowCount(0);
        if (this.paniers.size() > 0) {
            this.jPanelMain.removeAll();
            this.jPanelMain.add((Component)this.jScrollPane1, "Center");
            this.PanierEmpty.setVisible(false);
            this.jScrollPane1.setVisible(true);
            this.jPanelMain.revalidate();
            this.jPanelMain.repaint();
            Object[] rowData = new Object[8];
            for (LogPanier panier : this.paniers) {
                rowData[0] = panier.getNumero_order();
                rowData[1] = this.dateFormatter.format(panier.getDateSuppression());
                rowData[2] = this.timeFormatter.format(panier.getDateSuppression());
                rowData[3] = panier.getNameUser();
                rowData[4] = panier.getNameProduct();
                rowData[5] = this.printMultiply(panier.getMultiply());
                rowData[6] = this.printPrice(panier.getPrice());
                rowData[7] = panier.getDiscount() > 0.0 ? "-" + this.printPrice(panier.getValueDiscount()) : "";
                this.modelLog.addRow(rowData);
            }
        } else {
            this.jPanelMain.removeAll();
            this.jPanelMain.add((Component)this.PanierEmpty, "Center");
            this.PanierEmpty.setVisible(true);
            this.jScrollPane1.setVisible(false);
            this.jPanelMain.revalidate();
            this.jPanelMain.repaint();
        }
    }

    public String printMultiply(double quantity) {
        if (quantity == (double)Math.round(quantity)) {
            return Formats.INT.formatValue(quantity);
        }
        return Formats.DOUBLE.formatValue(quantity);
    }

    public String printPrice(double price) {
        if (price > 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        try {
            this.loadPaniers();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Commandes en attente";
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.jPanelMain = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLog = new JTable();
        this.PanierEmpty = new JLabel();
        this.jPanelTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPaneldate = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanelMain.setLayout(new BorderLayout());
        this.jTableLog.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTableLog);
        this.jPanelMain.add((Component)this.jScrollPane1, "Center");
        this.PanierEmpty.setFont(new Font("Tahoma", 1, 18));
        this.PanierEmpty.setHorizontalAlignment(0);
        this.PanierEmpty.setText("Aucun Produit");
        this.jPanelMain.add((Component)this.PanierEmpty, "Center");
        this.jPanel7.add((Component)this.jPanelMain, "Center");
        this.add((Component)this.jPanel7, "Center");
        this.jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        this.jPanelTitle.setPreferredSize(new Dimension(974, 50));
        this.jPanelTitle.setLayout(new BorderLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Log Panier");
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanelTitle.add((Component)this.jLabel1, "Before");
        this.jPaneldate.setPreferredSize(new Dimension(574, 50));
        this.jPanelTitle.add((Component)this.jPaneldate, "Center");
        this.add((Component)this.jPanelTitle, "First");
    }

    public static class ScriptArg {
        private final String key;
        private final Object value;

        public ScriptArg(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

