/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.sales.JTicketLines;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.ProDefaultTableModel;
import com.openbravo.service.TicketService;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.procaisse.services.AddressService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class JListFacture
extends JPanel
implements JPanelView,
BeanFactoryApp {
    protected JTicketLines m_ticketlines;
    protected Object m_oTicketExt;
    private Date date;
    private Date dateStart;
    private Date dateEnd;
    AddressService mAddressService = AddressService.getInstance();
    protected DefaultTableModel modelFacture;
    protected DefaultTableModel modelDetail;
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    protected DataLogicSales dlSales;
    protected DataLogicAdmin dlUsers;
    private List<Facture> factures;
    protected List<PrinterInfo> printers;
    protected String typeDisplay;
    private Facture currentFacture;
    private TicketInfo currentTicket;
    private List<Integer> listCancel;
    private EnteteInfo entetTicket;
    private TicketService mTicketService;
    final SimpleDateFormat dateFormatterFullFacture = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH'h'mm'm'ss's'");
    private JButton jBtnPrint;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel7;
    private JPanel jPanelBtn;
    private JPanel jPanelTitle;
    private JPanel jPaneldate;
    private JScrollPane jScrollPane1;
    private JTable jTableFacture;
    private JTextField jdate;
    private JButton next;
    private JButton previous;

    public JListFacture() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlUsers = (DataLogicAdmin)this.m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.printers = new ArrayList<PrinterInfo>();
        this.modelFacture = new ProDefaultTableModel();
        this.modelDetail = new ProDefaultTableModel();
        this.jTableFacture.setRowHeight(40);
        Object[] columnsOrders = new String[]{"Physique / Moral", "Adress Complet", "Code postale", "Nom ", "Soci\u00e9t\u00e9 ", "Intra TVA", "Date de Facturation", "Montant TTC"};
        this.listCancel = new ArrayList<Integer>();
        this.modelFacture.setColumnIdentifiers(columnsOrders);
        this.jTableFacture.setModel(this.modelFacture);
        this.factures = new ArrayList<Facture>();
        this.mTicketService = TicketService.getInstance();
        this.jTableFacture.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row;
                if (!e.getValueIsAdjusting() && (row = JListFacture.this.jTableFacture.getSelectedRow()) != -1) {
                    JListFacture.this.currentFacture = JListFacture.this.factures.get(row);
                    if (JListFacture.this.currentFacture != null) {
                        try {
                            JListFacture.this.currentTicket = JListFacture.this.dlSales.getTicketById(JListFacture.this.currentFacture.getTicket());
                            if (JListFacture.this.currentTicket != null) {
                                List<TicketLineInfo> lines = JListFacture.this.dlSales.loadLines(JListFacture.this.currentTicket.getId());
                                List<TicketLineInfo> linesExterne = JListFacture.this.dlSales.getTicketLineExterne(JListFacture.this.currentTicket.getId());
                                lines.addAll(linesExterne);
                                JListFacture.this.currentTicket.setLines(lines);
                                JListFacture.this.entetTicket = JListFacture.this.dlSales.getEnteteByTicket(JListFacture.this.currentTicket.getId(), JListFacture.this.currentTicket.isPaid());
                            }
                        }
                        catch (BasicException ex) {
                            LogToFile.log("severe", null, ex);
                        }
                        System.out.println("+++++++++++++ currentFacture.getType_operation() : " + JListFacture.this.currentFacture.getType_operation());
                        JListFacture.this.jPanelBtn.removeAll();
                        if (!JListFacture.this.currentFacture.isCancel() || JListFacture.this.currentFacture.getType_operation() != null && JListFacture.this.currentFacture.getType_operation().equalsIgnoreCase(Facture.CANCEL)) {
                            JListFacture.this.jPanelBtn.add(JListFacture.this.jBtnPrint);
                            JListFacture.this.jBtnPrint.setVisible(true);
                        }
                        JListFacture.this.jPanelBtn.revalidate();
                        JListFacture.this.jPanelBtn.repaint();
                        JListFacture.this.jPanelBtn.setVisible(true);
                    } else {
                        JListFacture.this.jPanelBtn.setVisible(false);
                    }
                }
            }
        });
        this.currentFacture = null;
        this.currentTicket = null;
        this.entetTicket = null;
    }

    public void loadOrder() throws BasicException {
        this.jPanelBtn.setVisible(false);
        this.factures = this.dlSales.getFactures(this.dateStart, this.dateEnd);
        this.currentFacture = null;
        this.currentTicket = null;
        this.entetTicket = null;
        this.listCancel.clear();
        this.modelFacture.setRowCount(0);
        this.modelDetail.setRowCount(0);
        if (this.factures.size() > 0) {
            Object[] rowData = new Object[8];
            int i = 0;
            for (Facture facture : this.factures) {
                rowData[0] = facture.isPhysical_person() ? "Personne Physique " : "Personne moral";
                rowData[1] = facture.getAddress() + " " + facture.getCity() + " " + facture.getCountry();
                rowData[2] = facture.getZip_code();
                rowData[3] = facture.getName_contact();
                rowData[4] = facture.getCompany();
                rowData[5] = facture.getNum_tva();
                rowData[6] = this.dateFormatterFullFacture.format(facture.getDateFacture());
                rowData[7] = Formats.CURRENCY.formatValue(facture.getTotal());
                this.modelFacture.addRow(rowData);
                if (facture.isCancel()) {
                    this.listCancel.add(i);
                }
                ++i;
            }
            this.jTableFacture.setDefaultRenderer(Object.class, new colorCancelCellRenderer(this.listCancel));
            this.jTableFacture.setModel(this.modelFacture);
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.next.setVisible(false);
        this.jdate.setText("Aujourd'hui");
        this.setTime(this.date);
        this.loadOrder();
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    public String getPickupString(TicketInfo pTicket) {
        if (pTicket == null) {
            return "0";
        }
        Object tmpPickupId = Integer.toString(pTicket.getPickupId());
        String pickupSize = this.m_App.getProperties().getProperty("till.pickupsize");
        if (pickupSize != null && Integer.parseInt(pickupSize) >= ((String)tmpPickupId).length()) {
            while (((String)tmpPickupId).length() < Integer.parseInt(pickupSize)) {
                tmpPickupId = "0" + (String)tmpPickupId;
            }
        }
        return tmpPickupId;
    }

    public String getResourceAsXML(String sresourcename) {
        return this.dlSystem.getResourceAsXML(sresourcename);
    }

    public BufferedImage getResourceAsImage(String sresourcename) {
        return this.dlSystem.getResourceAsImage(sresourcename);
    }

    @Override
    public String getTitle() {
        return "Commandes en attente";
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFacture = new JTable();
        this.jPanelBtn = new JPanel();
        this.jBtnPrint = new JButton();
        this.jPanelTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPaneldate = new JPanel();
        this.previous = new JButton();
        this.jdate = new JTextField();
        this.next = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jTableFacture.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTableFacture);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel7.add((Component)this.jPanel1, "Center");
        this.jPanelBtn.setPreferredSize(new Dimension(974, 50));
        this.jPanelBtn.setLayout(new GridLayout(1, 0));
        this.jBtnPrint.setBackground(new Color(3, 201, 169));
        this.jBtnPrint.setText("Imprimer");
        this.jBtnPrint.setBorderPainted(false);
        this.jBtnPrint.setFocusPainted(false);
        this.jBtnPrint.setRequestFocusEnabled(false);
        this.jBtnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListFacture.this.jBtnPrintActionPerformed(evt);
            }
        });
        this.jPanelBtn.add(this.jBtnPrint);
        this.jPanel7.add((Component)this.jPanelBtn, "Last");
        this.add((Component)this.jPanel7, "Center");
        this.jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        this.jPanelTitle.setPreferredSize(new Dimension(974, 50));
        this.jPanelTitle.setLayout(new BorderLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Facture");
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanelTitle.add((Component)this.jLabel1, "Before");
        this.jPaneldate.setPreferredSize(new Dimension(574, 50));
        this.previous.setText("<<");
        this.previous.setPreferredSize(new Dimension(50, 40));
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListFacture.this.previousActionPerformed(evt);
            }
        });
        this.jPaneldate.add(this.previous);
        this.jdate.setEditable(false);
        this.jdate.setPreferredSize(new Dimension(200, 40));
        this.jdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListFacture.this.jdateActionPerformed(evt);
            }
        });
        this.jPaneldate.add(this.jdate);
        this.next.setText(">>");
        this.next.setPreferredSize(new Dimension(50, 40));
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JListFacture.this.nextActionPerformed(evt);
            }
        });
        this.jPaneldate.add(this.next);
        this.jPanelTitle.add((Component)this.jPaneldate, "Center");
        this.add((Component)this.jPanelTitle, "First");
    }

    private void previousActionPerformed(ActionEvent evt) {
        try {
            Calendar cal = Calendar.getInstance();
            Calendar today = Calendar.getInstance();
            cal.setTime(this.date);
            cal.add(5, -1);
            Calendar yesterday = Calendar.getInstance();
            yesterday.setTime(DateUtils.getToday());
            yesterday.add(5, -1);
            if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
                yesterday.add(6, -1);
                today.add(6, -1);
            }
            this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
            if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
                this.next.setVisible(false);
                this.jdate.setText("Aujourd'hui");
            } else {
                this.next.setVisible(true);
            }
            if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
                this.jdate.setText("Hier");
            }
            this.date = cal.getTime();
            this.setTime(this.date);
            this.loadOrder();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    private void jdateActionPerformed(ActionEvent evt) {
    }

    private void nextActionPerformed(ActionEvent evt) {
        try {
            Calendar cal = Calendar.getInstance();
            Calendar today = Calendar.getInstance();
            cal.setTime(this.date);
            cal.add(5, 1);
            Calendar yesterday = Calendar.getInstance();
            yesterday.setTime(DateUtils.getToday());
            yesterday.add(5, -1);
            this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
            if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
                yesterday.add(6, -1);
                today.add(6, -1);
            }
            if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
                this.next.setVisible(false);
                this.jdate.setText("Aujourd'hui");
            } else {
                this.next.setVisible(true);
            }
            if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
                this.jdate.setText("Hier");
            }
            this.date = cal.getTime();
            this.setTime(this.date);
            this.loadOrder();
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    private void showRaison() {
        String result;
        JTextArea textArea = new JTextArea(4, 4);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new JLabel("Merci de saisir la raison d'annulation :"), "North");
        pnl.add((Component)textArea, "Center");
        int okCxl = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), pnl, "Confirmer l'annulation", 2);
        if (okCxl == 0 && (result = textArea.getText()) != null && !result.isEmpty()) {
            try {
                this.dlSales.cancelFacture(this.currentFacture, this.m_App.getAppUserView().getUser().getId(), result, null);
                this.loadOrder();
            }
            catch (BasicException ex) {
                Logger.getLogger(JListFacture.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jBtnPrintActionPerformed(ActionEvent evt) {
        if (this.currentFacture.isCancel()) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            JListFacture.this.currentTicket = JListFacture.this.dlSales.getTicketById(JListFacture.this.currentFacture.getTicket());
                            TicketInfo ti = JListFacture.this.dlSales.getTicketByOrigin(JListFacture.this.currentTicket.getId());
                            JListFacture.this.entetTicket = JListFacture.this.dlSales.getEnteteByTicket(ti.getId(), ti.isPaid());
                            ti.setAddressInfo(JListFacture.this.mAddressService.findOne(ti.getAddress()));
                            ti.setCustomer(JListFacture.this.dlSales.loadCustomerExt(ti.getCustomerId()));
                            List<TicketLineInfo> lines = JListFacture.this.dlSales.loadLines(ti.getId());
                            List<TicketLineInfo> linesExterne = JListFacture.this.dlSales.getTicketLineExterne(ti.getId());
                            lines.addAll(linesExterne);
                            ti.setLines(lines);
                            PrinterHelper printer = new PrinterHelper();
                            try {
                                if (JListFacture.this.currentFacture.getNb_print() == 0) {
                                    Decreaser decreaser = new Decreaser(JListFacture.this.dlSales, ti.getId(), "FACTURE", null, ti.getNumero_order());
                                    printer.printFactureCanceled(JListFacture.this.currentFacture, ti, JListFacture.this.entetTicket, 0, decreaser);
                                    break block5;
                                }
                                Duplicata d = new Duplicata(ti.getTicketId(), ti.getId(), "Facture", JListFacture.this.m_App.getAppUserView().getUser().getId(), new Integer(JListFacture.this.entetTicket.getNumDoc()), null, (int)JListFacture.this.currentFacture.getId(), 0);
                                long impressionNumber = JListFacture.this.dlSales.getNumberPrintDuplicata(ti.getId(), "Facture");
                                JListFacture.this.currentFacture.setNb_print((int)impressionNumber);
                                Decreaser decreaser = new Decreaser(JListFacture.this.dlSales, ti.getId(), "DUPLICATA", d, ti.getNumero_order());
                                printer.printFactureCanceled(JListFacture.this.currentFacture, ti, JListFacture.this.entetTicket, (int)impressionNumber, decreaser);
                            }
                            catch (BasicException ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            });
        } else {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JListFacture.this.entetTicket = JListFacture.this.dlSales.getEnteteByTicket(JListFacture.this.currentFacture.getTicket(), true);
                        JListFacture.this.currentFacture = JListFacture.this.dlSales.getFactureById(JListFacture.this.currentFacture.getId());
                        JListFacture.this.currentTicket = JListFacture.this.dlSales.getTicketById(JListFacture.this.currentFacture.getTicket());
                        JListFacture.this.currentTicket.setPayments(JListFacture.this.dlSales.findPaymetsByIdTicket(JListFacture.this.currentTicket.getId()));
                        if (JListFacture.this.currentTicket != null) {
                            List<TicketLineInfo> lines = JListFacture.this.dlSales.loadLines(JListFacture.this.currentTicket.getId());
                            List<TicketLineInfo> linesExterne = JListFacture.this.dlSales.getTicketLineExterne(JListFacture.this.currentTicket.getId());
                            lines.addAll(linesExterne);
                            JListFacture.this.currentTicket.setLines(lines);
                        }
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    PrinterHelper printer = new PrinterHelper();
                    try {
                        if (!JListFacture.this.entetTicket.IsTicketRestituted()) {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Veuillez imprimer le ticket d'origine pour pouvoir imprimer la facture .", 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            JListFacture.this.mTicketService.printFacture(JListFacture.this.entetTicket, JListFacture.this.currentTicket, JListFacture.this.currentFacture);
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    private void jBtnPrintLessActionPerformed(ActionEvent evt) {
    }

    private static class colorCancelCellRenderer
    extends DefaultTableCellRenderer {
        private final List<Integer> ticketsCancel;

        public colorCancelCellRenderer(List<Integer> ticketsCancel) {
            this.ticketsCancel = ticketsCancel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int found = -1;
            for (Integer ticket : this.ticketsCancel) {
                if (row != ticket) continue;
                found = 1;
            }
            if (found == 1) {
                c.setForeground(Color.red);
            } else {
                c.setForeground(Color.BLACK);
            }
            return c;
        }
    }

    public static class ScriptArg {
        private final String key;
        private final Object value;

        public ScriptArg(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

