/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.MonthInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.HTMLBuilder;
import com.openbravo.pos.util.LogToFile;
import com.protactile.mailer.Email;
import com.protactile.mailer.Mailer;
import fr.protactile.procaisse.orders.export.ExportGeneratorHelper;
import fr.protactile.procaisse.orders.export.ExportTurnoverExcel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.ImageIO;
import javax.mail.Message;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JExportRapport
extends JDialog {
    private AppView app;
    protected DataLogicSales dlSales;
    private List<MonthInfo> listMonths;
    private Date dateStart;
    private Date dateEnd;
    protected DataLogicStats dlStats;
    private DataLogicAdmin dlUser;
    private int year = 0;
    private int month = 0;
    private JButton jButton1;
    private JLabel jLabel1;
    private JComboBox<MonthInfo> jListMonths;
    private JComboBox<Integer> jListYears;
    private JPanel jPanelFooter;
    private JPanel jPanelMain;

    private JExportRapport(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JExportRapport(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private void init(AppView app, DataLogicSales dlSales, DataLogicStats dlStats) throws BasicException {
        this.initComponents();
        this.dlUser = (DataLogicAdmin)app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.app = app;
        this.dlSales = dlSales;
        this.dlStats = dlStats;
        this.setTitle("Export Historique Mois");
        this.jListYears.removeAllItems();
        int first_year = 2017;
        Integer last_year = new Date().getYear() + 1900;
        for (int i = first_year; i <= last_year; ++i) {
            this.jListYears.addItem(i);
        }
        this.jListYears.setSelectedItem(last_year);
        this.initMonths();
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JExportRapport.getWindow(parent.getParent());
    }

    public static void showMessage(Component parent, AppView app, DataLogicSales dlSales, DataLogicStats dlStats) throws BasicException, IOException {
        Window window = JExportRapport.getWindow(parent);
        JExportRapport myMsg = window instanceof Frame ? new JExportRapport((Frame)window, true) : new JExportRapport((Dialog)window, true);
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(app, dlSales, dlStats);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabel1 = new JLabel();
        this.jListMonths = new JComboBox();
        this.jListYears = new JComboBox();
        this.jPanelFooter = new JPanel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Impression");
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Veuillez choisissez le mois et l'ann\u00e9e");
        this.jLabel1.setPreferredSize(new Dimension(400, 30));
        this.jPanelMain.add(this.jLabel1);
        this.jListMonths.setPreferredSize(new Dimension(100, 30));
        this.jListMonths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JExportRapport.this.jListMonthsActionPerformed(evt);
            }
        });
        this.jPanelMain.add(this.jListMonths);
        this.jListYears.setPreferredSize(new Dimension(100, 30));
        this.jListYears.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JExportRapport.this.jListYearsActionPerformed(evt);
            }
        });
        this.jPanelMain.add(this.jListYears);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelFooter.setPreferredSize(new Dimension(10, 50));
        this.jPanelFooter.setLayout(new BorderLayout());
        this.jButton1.setBackground(new Color(42, 187, 155));
        this.jButton1.setText("Envoyer par Email");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JExportRapport.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanelFooter.add((Component)this.jButton1, "Center");
        this.getContentPane().add((Component)this.jPanelFooter, "South");
        this.setSize(new Dimension(482, 247));
        this.setLocationRelativeTo(null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.month != 0 && this.year != 0) {
            try {
                this.dateStart = new Date(this.year - 1900, this.month - 1, 1);
                this.dateEnd = new Date(this.year - 1900, this.month, 1);
                ExportGeneratorHelper mEGH = new ExportGeneratorHelper(this.dateStart, this.dateEnd);
                mEGH.setDlStats(this.dlStats);
                mEGH.setDlSales(this.dlSales);
                ExportTurnoverExcel mExportTurnoverExcel = new ExportTurnoverExcel();
                mExportTurnoverExcel.setComponentParent(null);
                mExportTurnoverExcel.setTemporaryDirectoryOutput();
                String fileName = " (" + DateUtils.formatMonth(this.dateStart) + " " + DateUtils.formatYear(this.dateStart) + ").xlsx";
                mEGH.setIsForClosedCaisse(true);
                mEGH.loadData();
                mExportTurnoverExcel.setFileName(fileName);
                String $resultExportFile = mExportTurnoverExcel.export(mEGH, false);
                Email email = new Email();
                email.setFromAddress("Pro-tactile", "no-reply@pro-tactile.fr");
                List<User> receipts = this.dlUser.getUsersHavingPermission("5");
                for (User receipt : receipts) {
                    if (receipt == null || receipt.getEmail().isEmpty()) continue;
                    email.addRecipient(receipt.getName(), receipt.getEmail(), Message.RecipientType.TO);
                }
                if (email.getRecipients() != null && !email.getRecipients().isEmpty()) {
                    HTMLBuilder emailHtml = new HTMLBuilder("Rapport de cloture: ", null, null);
                    email.setTextHTML(emailHtml.toString());
                    email.setSubject("Rapport de cloture: ");
                    if ($resultExportFile != null && !$resultExportFile.equals("canceled") && new File($resultExportFile).exists() && !new File($resultExportFile).isDirectory()) {
                        FileDataSource sourceFile = new FileDataSource($resultExportFile);
                        email.addAttachment(fileName, (DataSource)sourceFile);
                    }
                    Mailer.sendMailParametred(email);
                    this.dispose();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les donn\u00e9es on \u00e9t\u00e9 export\u00e9 et envoy\u00e9 avec succ\u00e8s !", 1500, NPosition.BOTTOM_RIGHT);
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci d'introduire les emails des d\u00e9stinataires avant l'envoi", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
            catch (BasicException ex) {
                this.dispose();
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void jListMonthsActionPerformed(ActionEvent evt) {
        MonthInfo current_month = (MonthInfo)this.jListMonths.getSelectedItem();
        if (current_month != null) {
            this.month = current_month.getId();
        }
    }

    private void jListYearsActionPerformed(ActionEvent evt) {
        Integer current_year = (Integer)this.jListYears.getSelectedItem();
        if (current_year != null) {
            this.year = current_year;
        }
    }

    private void initMonths() {
        this.listMonths = new ArrayList<MonthInfo>();
        this.listMonths.add(new MonthInfo(1, "Janvier"));
        this.listMonths.add(new MonthInfo(2, "F\u00e9vrier"));
        this.listMonths.add(new MonthInfo(3, "Mars"));
        this.listMonths.add(new MonthInfo(4, "Avril"));
        this.listMonths.add(new MonthInfo(5, "Mai"));
        this.listMonths.add(new MonthInfo(6, "Juin"));
        this.listMonths.add(new MonthInfo(7, "Juillet"));
        this.listMonths.add(new MonthInfo(8, "Aout"));
        this.listMonths.add(new MonthInfo(9, "Septembre"));
        this.listMonths.add(new MonthInfo(10, "Octobre"));
        this.listMonths.add(new MonthInfo(11, "Novembre"));
        this.listMonths.add(new MonthInfo(12, "D\u00e9cembre"));
        Date dateJour = new Date();
        MonthInfo month = null;
        for (MonthInfo mois : this.listMonths) {
            if (dateJour.getMonth() + 1 != mois.getId()) continue;
            month = mois;
        }
        this.jListMonths.removeAllItems();
        for (MonthInfo mois : this.listMonths) {
            this.jListMonths.addItem(mois);
        }
        this.jListMonths.setSelectedItem(month);
    }
}

