/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.PopUpPaymentController;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JEncaissementOrder
extends JDialog {
    Component parent;
    PopUpPaymentController controller;

    private JEncaissementOrder(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private JEncaissementOrder(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private void initAndShowGUI(final DataLogicSales dlSales, final DataLogicOrder dlOrders, final AppView m_App, final TicketInfo ticket) {
        final JFXPanel fxPanel = new JFXPanel();
        fxPanel.setSize(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), 500));
        this.getContentPane().add((Component)fxPanel, "Center");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JEncaissementOrder.this.initFX(fxPanel, dlSales, dlOrders, m_App, ticket);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void initFX(JFXPanel fxPanel, DataLogicSales dlSales, DataLogicOrder dlOrders, AppView m_App, TicketInfo ticket) throws IOException, BasicException, URISyntaxException {
        String fxmlFile = "/fxml/popUp_payment.fxml";
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
        Parent rootNode = (Parent)loader.load();
        this.controller = (PopUpPaymentController)loader.getController();
        double widthPayment = AppVarUtils.getScreenDimension().getWidth() * 0.6;
        Scene scenePop = new Scene(rootNode, widthPayment, 500.0);
        scenePop.getStylesheets().add((Object)"/styles/styles.css");
        this.controller.init(m_App, false, ticket.getTotal(), this, dlSales, null, ticket, false, false, dlOrders, false, false, AppLocal.USE_TPE_IN_UPDATE_PAYMENT, false);
        fxPanel.setScene(scenePop);
    }

    private Object[] init(DataLogicSales dlSales, DataLogicOrder dlOrders, AppView m_App, TicketInfo ticket) throws BasicException {
        this.initComponents();
        this.setSize(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), 500));
        this.initAndShowGUI(dlSales, dlOrders, m_App, ticket);
        this.setVisible(true);
        return this.controller.getResult();
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JEncaissementOrder.getWindow(parent.getParent());
    }

    public static Object[] showMessage(Component parent, DataLogicSales dlSales, DataLogicOrder dlOrders, AppView m_App, TicketInfo ticket) throws BasicException, IOException {
        Window window = JEncaissementOrder.getWindow(parent);
        JEncaissementOrder myMsg = window instanceof Frame ? new JEncaissementOrder((Frame)window, true) : new JEncaissementOrder((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(700, 600));
        return myMsg.init(dlSales, dlOrders, m_App, ticket);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(700, 600));
        this.setType(Window.Type.POPUP);
        this.setSize(new Dimension(700, 600));
        this.setLocationRelativeTo(null);
    }
}

