/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.DefaultTableModel;

public class JDetail
extends JDialog {
    private AppView app;
    protected DataLogicSales dlSales;
    protected DefaultTableModel modelOrder;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
    private TicketInfo currentOrder;
    private JFlowPanel panelDetail;
    JScrollPane scroll;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator3;
    private JLabel labelTitle;
    private JLabel titleQtt;
    private JLabel titleProduct;
    private JLabel titlePrice;
    private JPanel titleLine;
    private JPanel panelTotal;
    private JLabel titleTotal;
    private JLabel labelTotal;
    private CaisseInfo caisse;
    private List<PaymentLine> payments;
    private List<TaxeLine> taxes;
    private List<TaxeLine> taxesDivers;
    private List<TaxeLine> allTaxes;
    private Integer m_iSales;
    private Integer nbproduct;
    private Integer nbProductDiver;
    private Integer allProduct;
    private PaymentsModel m_PaymentsCaisse;
    private double caBrut;
    private List<UserCaisseInfo> users;
    private double tvas;
    private double caNet;
    private double caCanceled;

    private JDetail(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JDetail(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private void init(AppView app, TicketInfo order) throws BasicException {
        this.initComponents();
        this.panelDetail = new JFlowPanel();
        this.scroll = new JScrollPane(this.panelDetail);
        this.scroll = new JScrollPane(this.panelDetail);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.getVerticalScrollBar().setPreferredSize(new Dimension(25, 35));
        this.panelDetail.setAlignmentY(0.5f);
        this.add((Component)this.scroll, "Center");
        this.app = app;
        this.dlSales = (DataLogicSales)app.getBean("com.openbravo.dao.DataLogicSales");
        this.currentOrder = order;
        this.payments = this.dlSales.loadPaymentByTicket(this.currentOrder.getId());
        this.load();
        this.setTitle("Detail commande");
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JDetail.getWindow(parent.getParent());
    }

    public static void showMessage(Component parent, AppView app, TicketInfo order) throws BasicException, IOException {
        Window window = JDetail.getWindow(parent);
        JDetail myMsg = window instanceof Frame ? new JDetail((Frame)window, true) : new JDetail((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(1000, 500));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(app, order);
    }

    public void load() throws BasicException {
        int with = 800;
        this.panelDetail.removeAll();
        JPanel panelHeader = new JPanel();
        panelHeader.setPreferredSize(new Dimension(800, 20));
        this.panelDetail.add(panelHeader);
        this.labelTitle = new JLabel();
        this.labelTitle.setHorizontalAlignment(2);
        this.labelTitle.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.labelTitle.setText("Commande N\u00b0 " + this.currentOrder.getNumberOrder() + " " + this.dateFormatter.format(this.currentOrder.getDate()));
        this.labelTitle.setPreferredSize(new Dimension(800, 20));
        this.panelDetail.add(this.labelTitle);
        this.titleLine = new JPanel();
        this.titleLine.setLayout(new FlowLayout(0));
        this.titleLine.setPreferredSize(new Dimension(800, 30));
        this.titleQtt = new JLabel();
        this.titleQtt.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.titleQtt.setText("Qtt");
        this.titleQtt.setPreferredSize(new Dimension(100, 30));
        this.titleProduct = new JLabel();
        this.titleProduct.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.titleProduct.setText("produit");
        this.titleProduct.setPreferredSize(new Dimension(300, 30));
        this.titlePrice = new JLabel();
        this.titlePrice.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.titlePrice.setText("Total");
        this.titlePrice.setPreferredSize(new Dimension(100, 30));
        this.titleLine.add(this.titleQtt);
        this.titleLine.add(this.titleProduct);
        this.titleLine.add(this.titlePrice);
        this.panelDetail.add(this.titleLine);
        this.separator1 = new JSeparator();
        this.separator1.setPreferredSize(new Dimension(600, 5));
        this.panelDetail.add(this.separator1);
        for (TicketLineInfo line : this.currentOrder.getLines()) {
            JPanel panelLine = new JPanel();
            panelLine.setLayout(new FlowLayout(0));
            panelLine.setPreferredSize(new Dimension(800, 30));
            JLabel labelqtt = new JLabel();
            labelqtt.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            labelqtt.setText(line.printMultiply());
            labelqtt.setPreferredSize(new Dimension(100, 30));
            JLabel labelProduct = new JLabel();
            labelProduct.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            labelProduct.setText(line.printName());
            labelProduct.setPreferredSize(new Dimension(300, 30));
            JLabel labelPrice = new JLabel();
            labelPrice.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            labelPrice.setText(line.printValue());
            labelPrice.setPreferredSize(new Dimension(100, 30));
            panelLine.add(labelqtt);
            panelLine.add(labelProduct);
            panelLine.add(labelPrice);
            if (line.getValueDiscount() > 0.0) {
                String labelDiscount = line.printLabelDiscount();
                JPanel panelDiscount = new JPanel();
                panelDiscount.setLayout(new FlowLayout(0));
                panelDiscount.setPreferredSize(new Dimension(800, 30));
                JLabel labelVide2 = new JLabel();
                labelVide2.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelVide2.setText("");
                labelVide2.setPreferredSize(new Dimension(100, 30));
                JLabel labelVide = new JLabel();
                labelVide.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelVide.setText(labelDiscount);
                labelVide.setPreferredSize(new Dimension(300, 30));
                JLabel labelPromo = new JLabel();
                labelPromo.setFont(AppLocal.FONT_ARIAL_BOLD_14);
                labelPromo.setText("-" + Formats.CURRENCY.formatValue(Math.abs(line.getDiscount())));
                labelPromo.setPreferredSize(new Dimension(100, 30));
                panelDiscount.add(labelVide2);
                panelDiscount.add(labelVide);
                panelDiscount.add(labelPromo);
                this.panelDetail.add(panelLine);
                this.panelDetail.add(panelDiscount);
                continue;
            }
            this.panelDetail.add(panelLine);
        }
        this.separator2 = new JSeparator();
        this.separator2.setPreferredSize(new Dimension(600, 5));
        this.panelDetail.add(this.separator2);
        if (this.currentOrder.getDiscount() > 0.0) {
            String value = this.currentOrder.getTypeDiscount().equalsIgnoreCase("pourcentage") ? TaxLineInfo.printThisDoubleAsAmount(-Math.abs(this.currentOrder.getDiscount() * this.currentOrder.getTotal() / (100.0 - this.currentOrder.getDiscount()))) : TaxLineInfo.printThisDoubleAsAmount(-Math.abs(this.currentOrder.getDiscount()));
            JLabel titleDiscount = new JLabel();
            JPanel panelDiscount = new JPanel();
            JLabel labelDiscount = new JLabel();
            panelDiscount.setLayout(new FlowLayout(0));
            panelDiscount.setPreferredSize(new Dimension(800, 30));
            titleDiscount.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            titleDiscount.setText("R\u00e9duction :");
            titleDiscount.setPreferredSize(new Dimension(300, 30));
            labelDiscount.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            labelDiscount.setText(value);
            labelDiscount.setPreferredSize(new Dimension(100, 30));
            panelDiscount.add(titleDiscount);
            panelDiscount.add(labelDiscount);
            this.panelDetail.add(panelDiscount);
        }
        this.titleTotal = new JLabel();
        this.panelTotal = new JPanel();
        this.labelTotal = new JLabel();
        this.panelTotal.setLayout(new FlowLayout(0));
        this.panelTotal.setPreferredSize(new Dimension(800, 30));
        this.titleTotal.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.titleTotal.setText("Total TTC :");
        this.titleTotal.setPreferredSize(new Dimension(300, 30));
        this.labelTotal.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.labelTotal.setText(this.currentOrder.printTotal());
        this.labelTotal.setPreferredSize(new Dimension(100, 30));
        this.panelTotal.add(this.titleTotal);
        this.panelTotal.add(this.labelTotal);
        this.panelDetail.add(this.panelTotal);
        JLabel paymentTile = new JLabel();
        paymentTile.setHorizontalAlignment(2);
        paymentTile.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        paymentTile.setText("Modes de paiement");
        paymentTile.setPreferredSize(new Dimension(800, 20));
        this.panelDetail.add(paymentTile);
        this.separator3 = new JSeparator();
        this.separator3.setPreferredSize(new Dimension(600, 5));
        this.panelDetail.add(this.separator3);
        for (PaymentLine payment : this.payments) {
            JPanel panelPayment = new JPanel();
            panelPayment.setLayout(new FlowLayout(0));
            panelPayment.setPreferredSize(new Dimension(800, 20));
            JLabel typePayment = new JLabel();
            typePayment.setFont(AppLocal.FONT_ARIAL_BOLD_14);
            typePayment.setText(payment.getM_PaymentType() + " : " + Formats.CURRENCY.formatValue(payment.getM_PaymentValue()));
            typePayment.setPreferredSize(new Dimension(300, 20));
            panelPayment.add(typePayment);
            panelPayment.add(typePayment);
            this.panelDetail.add(panelPayment);
        }
        this.panelDetail.revalidate();
        this.panelDetail.repaint();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Impression");
        this.setSize(new Dimension(826, 438));
        this.setLocationRelativeTo(null);
    }
}

