/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.PopUpCancelOrders;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JCancelOrders
extends JDialog {
    Component parent;
    PopUpCancelOrders controller;

    private JCancelOrders(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private JCancelOrders(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private void initAndShowGUI() {
        final JFXPanel fxPanel = new JFXPanel();
        fxPanel.setSize(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
        this.getContentPane().add((Component)fxPanel, "Center");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    JCancelOrders.this.initFX(fxPanel);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void initFX(JFXPanel fxPanel) throws IOException, BasicException, URISyntaxException {
        String fxmlFile = "/fxml/popUp_cancel_orders.fxml";
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
        Parent rootNode = (Parent)loader.load();
        this.controller = (PopUpCancelOrders)loader.getController();
        double width = AppVarUtils.getScreenDimension().getWidth() * 0.6;
        double height = AppVarUtils.getScreenDimension().getHeight() * 0.7;
        Scene scenePop = new Scene(rootNode, width, height);
        scenePop.getStylesheets().add((Object)"/styles/styles.css");
        this.controller.initializer(this);
        fxPanel.setScene(scenePop);
    }

    private boolean init() throws BasicException {
        this.initComponents();
        this.setTitle("les commandes en attente");
        this.setSize(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
        this.initAndShowGUI();
        this.setVisible(true);
        return this.controller.getResult();
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JCancelOrders.getWindow(parent.getParent());
    }

    public static boolean showOrders(Component parent) throws BasicException, IOException {
        Window window = JCancelOrders.getWindow(parent);
        JCancelOrders myMsg = window instanceof Frame ? new JCancelOrders((Frame)window, true) : new JCancelOrders((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        return myMsg.init();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.POPUP);
        this.setSize(new Dimension(700, 639));
        this.setLocationRelativeTo(null);
    }
}

