/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.robot.NativeAsciiRobotHandler;

public class JCancelOrder
extends JDialog {
    private static final Dimension DIMENSION_PANEL = new Dimension(500, 200);
    Object[] results;
    private Stage stageKeyBoard;
    private KeyBoardPopup popupKeyBoard;
    private boolean keyBoardLoaded;
    private JButton jButton2;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton keyBoardBtn;
    private JPanel panelReasonCancel;
    private JPanel panelTitle;
    private JPanel panelValid;
    private JTextArea textReason;

    private JCancelOrder(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JCancelOrder(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    private Object[] init() throws BasicException {
        this.initComponents();
        this.results = new Object[2];
        this.results[0] = false;
        this.results[1] = null;
        this.keyBoardBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/keyBoard.png")));
        this.setVisible(true);
        return this.results;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JCancelOrder.getWindow(parent.getParent());
    }

    public static Object[] showMessage(Component parent) throws BasicException, IOException {
        Window window = JCancelOrder.getWindow(parent);
        JCancelOrder myMsg = window instanceof Frame ? new JCancelOrder((Frame)window, true) : new JCancelOrder((Dialog)window, true);
        myMsg.setPreferredSize(DIMENSION_PANEL);
        myMsg.setTitle("Annulation de commande");
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        return myMsg.init();
    }

    public String getHtmlTitle(String title) {
        return "<HTML><BODY align='center'>Imprimer<BR>" + title + "</BODY></HTML>";
    }

    private void initComponents() {
        this.panelTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.panelReasonCancel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textReason = new JTextArea();
        this.panelValid = new JPanel();
        this.keyBoardBtn = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Impression");
        this.panelTitle.setPreferredSize(new Dimension(490, 40));
        this.panelTitle.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("Raison d'annulation");
        this.jLabel1.setPreferredSize(new Dimension(150, 20));
        this.panelTitle.add(this.jLabel1);
        this.getContentPane().add((Component)this.panelTitle, "First");
        this.jScrollPane1.setPreferredSize(new Dimension(490, 70));
        this.textReason.setColumns(20);
        this.textReason.setRows(5);
        this.textReason.setPreferredSize(new Dimension(490, 80));
        this.jScrollPane1.setViewportView(this.textReason);
        this.panelReasonCancel.add(this.jScrollPane1);
        this.getContentPane().add((Component)this.panelReasonCancel, "Center");
        this.panelValid.setPreferredSize(new Dimension(490, 45));
        this.panelValid.setLayout(new FlowLayout(2));
        this.keyBoardBtn.setPreferredSize(new Dimension(70, 40));
        this.keyBoardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCancelOrder.this.keyBoardBtnActionPerformed(evt);
            }
        });
        this.panelValid.add(this.keyBoardBtn);
        this.jButton2.setText("OK");
        this.jButton2.setPreferredSize(new Dimension(70, 40));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCancelOrder.this.jButton2ActionPerformed(evt);
            }
        });
        this.panelValid.add(this.jButton2);
        this.getContentPane().add((Component)this.panelValid, "Last");
        this.setSize(new Dimension(519, 204));
        this.setLocationRelativeTo(null);
    }

    private void keyBoardBtnActionPerformed(ActionEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JCancelOrder.this.loadKeyBoard();
            }
        });
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.results[0] = true;
        this.results[1] = this.textReason.getText().trim();
        this.dispose();
    }

    private void loadKeyBoard() {
        try {
            if (!this.keyBoardLoaded) {
                this.keyBoardLoaded = true;
                if (this.stageKeyBoard == null || this.popupKeyBoard == null) {
                    this.stageKeyBoard = new Stage();
                    this.stageKeyBoard.setResizable(false);
                    this.stageKeyBoard.initStyle(StageStyle.UNDECORATED);
                    KeyboardPane kb = new KeyboardPane();
                    kb.setLayer(DefaultLayer.NUMBLOCK);
                    kb.addRobotHandler((IRobot)new NativeAsciiRobotHandler());
                    kb.setOnKeyboardCloseButton(e -> {
                        this.stageKeyBoard.close();
                        this.keyBoardLoaded = false;
                    });
                    kb.setLocale(Locale.forLanguageTag("en"));
                    kb.load();
                    this.popupKeyBoard = new KeyBoardPopup(kb);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    double width = screenSize.getWidth();
                    double height = screenSize.getHeight();
                    this.popupKeyBoard.setX(width / 4.0);
                    this.popupKeyBoard.setY(height / 4.0 * 3.0);
                    this.popupKeyBoard.setHeight(height / 4.0);
                    Scene scene = new Scene((Parent)new Group(), 0.1, 0.1);
                    this.stageKeyBoard.setScene(scene);
                    this.popupKeyBoard.registerScene(scene);
                }
                this.stageKeyBoard.show();
                this.popupKeyBoard.setVisible(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

