/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.Controller;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.forms.PopupLoading;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.OrderOnLineService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JCaissePanel
extends JPanel
implements JPanelView,
BeanFactoryApp {
    protected AppView m_App;
    private Controller controller;
    private boolean view_loaded;
    private Scene scene;

    public JCaissePanel() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        try {
            this.m_App = app;
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/caisse_view.fxml"));
            Parent rootNode = (Parent)loader.load();
            this.controller = (Controller)loader.getController();
            this.scene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            this.scene.getStylesheets().add((Object)"/styles/styles.css");
            this.scene.getStylesheets().add((Object)"/styles/app.css");
            this.controller.initialize(this.m_App, this.scene);
            JFXPanel fxPanel = new JFXPanel();
            Platform.runLater(() -> fxPanel.setScene(this.scene));
            this.add((Component)fxPanel, "Center");
            this.view_loaded = true;
        }
        catch (BasicException | IOException | URISyntaxException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void beforeLoad(final Scene scene) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PopupLoading m_PopUpNotification = new PopupLoading(scene, new Stage());
                m_PopUpNotification.setmAppView(JCaissePanel.this.m_App);
                try {
                    m_PopUpNotification.init();
                }
                catch (IOException ex) {
                    Logger.getLogger(OrderOnLineService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!JCaissePanel.this.view_loaded) {
                    try {
                        JCaissePanel.this.controller.initialize(JCaissePanel.this.m_App, JCaissePanel.this.scene);
                        JFXPanel fxPanel = new JFXPanel();
                        fxPanel.setScene(JCaissePanel.this.scene);
                        JCaissePanel.this.add((Component)fxPanel, "Center");
                        JCaissePanel.this.view_loaded = true;
                    }
                    catch (BasicException | URISyntaxException ex) {
                        Logger.getLogger(JCaissePanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (AppLocal.ticket != null) {
                    JCaissePanel.this.controller.loadTicketMAJ();
                }
                if (AppLocal.ticketLV != null) {
                    JCaissePanel.this.controller.loadTicketMAJLV();
                }
                if (AppLocal.table != null && AppLocal.ticket != null) {
                    JCaissePanel.this.controller.loadTableMAJ();
                }
                if (AppLocal.table != null && AppLocal.ticket == null) {
                    JCaissePanel.this.controller.loadTable();
                }
                if (AppLocal.demandeLivraison.booleanValue()) {
                    JCaissePanel.this.controller.loadLV();
                }
                if (AppLocal.chooseCustomer.booleanValue()) {
                    JCaissePanel.this.controller.loadCustomer();
                }
                try {
                    JCaissePanel.this.controller.reloadPermission();
                    if (AppLocal.GLORY_ENABLED) {
                        JCaissePanel.this.controller.setInventory();
                    }
                    JCaissePanel.this.controller.load();
                    JCaissePanel.this.controller.reloadCategories(true);
                    System.out.println("+++++++++++++ date activate after : " + new Date());
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        });
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Historique";
    }

    public void loadTicketBorne(TicketInfo ticket) {
        this.controller.loadTicketBorne(ticket);
    }

    public void setShared_order_caisse(boolean shared_order_caisse) {
        this.controller.setShared_order_caisse(shared_order_caisse);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

