/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ArchivageService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JArchives
extends JDialog {
    private DataLogicSales dlSales;
    private AppView app;
    private DataLogicItems dlItems;
    Component parent;
    private LinkedHashMap<String, Integer> map_months;
    private JButton JbuttonValid;
    private JPanel JpanelParent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JComboBox<String> jMonthEnd;
    private JComboBox<String> jMonthStart;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JComboBox<String> jYear;
    private JLabel labelMessage;
    private JPanel panelMessage;

    private JArchives(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private JArchives(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
    }

    private void init(DataLogicSales dlSales) throws BasicException {
        this.initComponents();
        this.setResizable(false);
        this.dlSales = dlSales;
        this.setTitle("Archivage ");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.JpanelParent, "Center");
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
        this.map_months = new LinkedHashMap();
        this.map_months.put("Janvier", 1);
        this.map_months.put("F\u00e9vrier", 2);
        this.map_months.put("Mars", 3);
        this.map_months.put("Avril", 4);
        this.map_months.put("Mai", 5);
        this.map_months.put("Juin", 6);
        this.map_months.put("Juillet", 7);
        this.map_months.put("Ao\u00fbt", 8);
        this.map_months.put("Septembre", 9);
        this.map_months.put("Octobre", 10);
        this.map_months.put("Novembre", 11);
        this.map_months.put("D\u00e9cembre", 12);
        for (String month : this.map_months.keySet()) {
            this.jMonthStart.addItem(month);
            this.jMonthEnd.addItem(month);
        }
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JArchives.getWindow(parent.getParent());
    }

    public static void showMessage(Component parent, DataLogicSales dlSales) throws BasicException, IOException {
        Window window = JArchives.getWindow(parent);
        JArchives myMsg = window instanceof Frame ? new JArchives((Frame)window, true) : new JArchives((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(1000, 500));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(dlSales);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.panelMessage = new JPanel();
        this.labelMessage = new JLabel();
        this.JpanelParent = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jYear = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jMonthStart = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jMonthEnd = new JComboBox();
        this.jPanel3 = new JPanel();
        this.JbuttonValid = new JButton();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.POPUP);
        this.panelMessage.setLayout(new BorderLayout());
        this.labelMessage.setFont(new Font("Tahoma", 0, 14));
        this.labelMessage.setHorizontalAlignment(0);
        this.panelMessage.add((Component)this.labelMessage, "Center");
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.JpanelParent.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(300, 40));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel2.setText("Ann\u00e9e");
        this.jLabel2.setPreferredSize(new Dimension(100, 30));
        this.jPanel1.add(this.jLabel2);
        this.jYear.setModel(new DefaultComboBoxModel<String>(new String[]{"2017", "2018", "2019", "2020"}));
        this.jYear.setPreferredSize(new Dimension(150, 30));
        this.jPanel1.add(this.jYear);
        this.JpanelParent.add((Component)this.jPanel1, "First");
        this.jPanel2.setPreferredSize(new Dimension(500, 30));
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel3.setText("Les mois");
        this.jLabel3.setPreferredSize(new Dimension(80, 25));
        this.jPanel2.add(this.jLabel3);
        this.jLabel4.setText("D\u00e9but");
        this.jLabel4.setPreferredSize(new Dimension(50, 25));
        this.jPanel2.add(this.jLabel4);
        this.jMonthStart.setPreferredSize(new Dimension(100, 25));
        this.jPanel2.add(this.jMonthStart);
        this.jLabel5.setText("Fin");
        this.jLabel5.setPreferredSize(new Dimension(50, 25));
        this.jPanel2.add(this.jLabel5);
        this.jMonthEnd.setPreferredSize(new Dimension(100, 25));
        this.jPanel2.add(this.jMonthEnd);
        this.JpanelParent.add((Component)this.jPanel2, "Center");
        this.jPanel3.setPreferredSize(new Dimension(500, 30));
        this.jPanel3.setLayout(new BorderLayout());
        this.JbuttonValid.setBackground(new Color(0, 153, 153));
        this.JbuttonValid.setText("G\u00e9nerer les Archives");
        this.JbuttonValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JArchives.this.JbuttonValidActionPerformed(evt);
            }
        });
        this.jPanel3.add((Component)this.JbuttonValid, "Center");
        this.JpanelParent.add((Component)this.jPanel3, "Last");
        this.getContentPane().add((Component)this.JpanelParent, "Center");
        this.setSize(new Dimension(448, 173));
        this.setLocationRelativeTo(null);
    }

    private void JbuttonValidActionPerformed(ActionEvent evt) {
        this.generateArchives();
    }

    private void generateArchives() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
        this.labelMessage.setText("L'archiavge en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArchivageService archivageUtils = new ArchivageService(JArchives.this.dlSales, AppLocal.dlItems, "0");
                    String year = (String)JArchives.this.jYear.getSelectedItem();
                    String monthStart = (String)JArchives.this.jMonthStart.getSelectedItem();
                    String monthEnd = (String)JArchives.this.jMonthEnd.getSelectedItem();
                    if (year != null && monthStart != null && monthEnd != null) {
                        int index_end;
                        int index_start = JArchives.this.map_months.get(monthStart) != null ? JArchives.this.map_months.get(monthStart) : 0;
                        int n = index_end = JArchives.this.map_months.get(monthEnd) != null ? JArchives.this.map_months.get(monthEnd) : 0;
                        if (index_start != 0 && index_end != 0) {
                            ArrayList<String> months = new ArrayList<String>();
                            for (int i = index_start; i <= index_end; ++i) {
                                StringBuilder monthbuilder = new StringBuilder();
                                monthbuilder.append(year);
                                if (i < 10) {
                                    monthbuilder.append("0");
                                }
                                monthbuilder.append(String.valueOf(i));
                                months.add(monthbuilder.toString());
                            }
                            if (!months.isEmpty()) {
                                System.out.println("+++++++++++++ months : " + months);
                                archivageUtils.regenerateArchives(months);
                                JArchives.this.dispose();
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "L'archivage a \u00e9t\u00e9 faite avec succ\u00e8s.", 4000, NPosition.CENTER);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JArchives.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }
}

