/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.sales;

import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.apache.commons.io.FileUtils;

public class ExportZFileHelper {
    private String fileName;
    private String typePeriode;
    private List<String> lines = new ArrayList<String>();
    private String period_value;
    private List<PaymentLine> payments;
    private List<TaxeLine> taxes;
    private Integer numberOrders;
    private List<RankTypeOrder> dataTypeOrders;
    private double turnover;
    private final String SIGNATURE_FILE_NAME = "signature.txt";

    public ExportZFileHelper(double turnover, Integer numberOrders, List<PaymentLine> payments, List<TaxeLine> taxes, List<RankTypeOrder> dataTypeOrders, String period_value, String fileName) {
        this.period_value = period_value;
        this.fileName = fileName;
        this.dataTypeOrders = dataTypeOrders;
        this.payments = payments;
        this.taxes = taxes;
        this.turnover = turnover;
        this.numberOrders = numberOrders;
    }

    public void export() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("exporter z caisse");
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(new JFrame()) == 0) {
            try {
                File destinationFolder = fc.getSelectedFile();
                String directoryName = this.fileName.substring(0, this.fileName.length() - 5);
                String path_directory = destinationFolder.getAbsolutePath() + File.separator + directoryName;
                File directoryParent = new File(path_directory);
                if (!directoryParent.exists()) {
                    directoryParent.mkdir();
                }
                File fileZ = new File(directoryParent.getAbsolutePath() + File.separator + this.fileName);
                File fileSignature = new File(directoryParent.getAbsolutePath() + File.separator + "signature.txt");
                this.fillLines(fileZ, fileSignature);
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les donn\u00e9es on \u00e9t\u00e9 export\u00e9 avec succ\u00e8s !", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void fillLines(File fileZ, File fileSignature) throws IOException {
        this.lines.add(this.period_value);
        this.lines.add("Chiffre d'affaire : " + NumericUtils.round(this.turnover));
        this.lines.add(this.numberOrders + " commandes");
        double totalTaxes = 0.0;
        for (TaxeLine allTaxe : this.taxes) {
            totalTaxes += allTaxe.getTax();
        }
        this.lines.add("TVA \u00e0 reverser: " + NumericUtils.round(totalTaxes));
        for (TaxeLine taxe : this.taxes) {
            this.lines.add("TVA " + taxe.getName() + " : " + NumericUtils.round(taxe.getTax()));
        }
        for (PaymentLine paymentLine : this.payments) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                this.lines.add(paymentLine.getM_PaymentType() + " : " + NumericUtils.round(paymentLine.getM_PaymentValue()));
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                this.lines.add("Avoir Encaiss\u00e9 : " + NumericUtils.round(paymentLine.getM_PaymentValue()));
                continue;
            }
            this.lines.add("Avoir D\u00e9caiss\u00e9 : " + NumericUtils.round(paymentLine.getM_PaymentValue()));
        }
        for (PaymentLine paymentLine : this.payments) {
            switch (paymentLine.getM_PaymentType()) {
                case "CB": {
                    this.lines.add(paymentLine.getNombre() + " " + AppLocal.getIntString("Button.cb"));
                    break;
                }
                case "Carte Ticket Resto": {
                    this.lines.add(paymentLine.getNombre() + " Carte Ticket Resto");
                    break;
                }
                case "Ticket Resto": {
                    this.lines.add(paymentLine.getNombre() + " Tickets Resto");
                }
            }
        }
        for (RankTypeOrder type : this.dataTypeOrders) {
            this.lines.add(type.getName() + " : " + NumericUtils.round(type.getCa()));
        }
        FileUtils.writeLines((File)fileZ, (String)"ISO-8859-15", this.lines, (boolean)true);
        this.signZFile(fileZ, fileSignature);
    }

    public void signZFile(File fileToSign, File fileSignature) throws IOException {
        SignatureGenerator generator = SignatureGenerator.getGenerator();
        String signature = generator.sign(fileToSign);
        FileUtils.writeStringToFile((File)fileSignature, (String)signature);
    }
}

