/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer.screen;

import com.openbravo.controllers.IDualScreenController;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.printer.screen.DeviceDisplayDualScreen;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class DeviceDisplayWindow
extends JFrame
implements DeviceDisplayDualScreen {
    List<PhotoDispaly> list;
    Map<Integer, ImageIcon> maps_photos = new HashMap<Integer, ImageIcon>();
    Timer tm;
    int x = 0;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private IDualScreenController controller;
    public final String FX_DUAL_SCREEN = "/fxml/dual_screen.fxml";
    public final String FX_DUAL_SCREEN_DRIVE = "/fxml/dual_screen_drive.fxml";
    public final String FX_DUAL_SCREEN_DRIVE_NEW = "/fxml/dual_screen_drive_new.fxml";
    private JPanel m_jContainer;

    public DeviceDisplayWindow() throws IOException {
        this.setUndecorated(true);
        this.setResizable(false);
        this.initComponents();
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        int width = 0;
        int height = 0;
        int screen = 1;
        if (gd.length > 1) {
            width = gd[screen].getDefaultConfiguration().getBounds().width;
            height = gd[screen].getDefaultConfiguration().getBounds().height;
            this.setSize(width, height);
        }
        this.loadController();
        if (gd.length == 1) {
            this.setVisible(true);
        } else if (screen > 0 && screen < gd.length) {
            this.setLocation(gd[screen].getDefaultConfiguration().getBounds().x, gd[screen].getDefaultConfiguration().getBounds().y);
            this.setVisible(true);
        } else {
            throw new RuntimeException("No Screens Found");
        }
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    private void initComponents() {
        this.m_jContainer = new JPanel();
        this.setTitle(AppLocal.getIntString("Display.Window"));
        this.m_jContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_jContainer.setFont(new Font("Arial", 0, 14));
        this.m_jContainer.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_jContainer, "Center");
        this.setSize(new Dimension(1140, 427));
    }

    @Override
    public void sendOrder(TicketInfo order, List<TicketLineInfo> lines, String total, String typeOrder) {
        this.controller.loadPanier(order, lines, total, typeOrder);
    }

    @Override
    public void reloadView(String typeOrder) {
        this.controller.reloadView(typeOrder);
    }

    @Override
    public void loadAdditionalSale(String typeOrder) {
        this.controller.loadAdditionnals(typeOrder);
    }

    @Override
    public void loadRendu(double total, double paid, double rendu) {
        this.controller.loadRendu(total, paid, rendu);
    }

    @Override
    public void hideRendu() {
        this.controller.hideRendu();
    }

    @Override
    public void setTotal(String text_total) {
        this.controller.setTotal(text_total);
    }

    private void loadController() {
        boolean dual_screen_drive = AppLocal.TYPE_DISPLAY != null && AppLocal.TYPE_DISPLAY.equals("window_drive");
        String fxml_file = dual_screen_drive ? "/fxml/dual_screen_drive_new.fxml" : "/fxml/dual_screen.fxml";
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxml_file));
            Parent rootNode = (Parent)loader.load();
            this.controller = (IDualScreenController)loader.getController();
            Scene scene = new Scene(rootNode, this.getSize().getWidth(), this.getSize().getHeight());
            scene.getStylesheets().add((Object)"/styles/styles.css");
            scene.getStylesheets().add((Object)"/styles/app.css");
            this.controller.init(this.getSize().getWidth(), this.getSize().getHeight());
            JFXPanel fxPanel = new JFXPanel();
            Platform.runLater(() -> fxPanel.setScene(scene));
            this.m_jContainer.add((Component)fxPanel, "Center");
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    @Override
    public void loadMomentsProducts() {
        this.controller.loadMomentsProducts();
    }

    @Override
    public void loadInfoProduct(ProductInfoExt product, String total_order, String total_product, SupplementProduct goption, List<SupplementProduct> options, List<OptionItemOrder> listOptions) {
        this.controller.loadInfoProduct(product, total_order, total_product, goption, options, listOptions);
    }

    @Override
    public void selectOption(SupplementItemInfo option) {
        this.controller.selectOption(option);
    }

    @Override
    public void deselectOption(SupplementItemInfo option) {
        this.controller.deselectOption(option);
    }

    @Override
    public void setTotalProduct(String text_total) {
        this.controller.setTotalProduct(text_total);
    }

    @Override
    public Object propagateClick(String functionName, Object[] args) {
        return this.controller.propagateClick(functionName, args);
    }
}

