/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer.escpos;

import com.fazecast.jSerialComm.SerialPort;
import com.openbravo.pos.printer.escpos.DeviceDisplaySerial;
import com.openbravo.pos.printer.escpos.ESCPOS;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;

public class DeviceVFDESCPOS
extends DeviceDisplaySerial {
    protected Enumeration portList;
    protected SerialPort serialPort;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    private String default_message = "*** Bienvenue ***";
    private String sDisplayPort = null;

    public DeviceVFDESCPOS(String m_Port) {
        this.sDisplayPort = m_Port;
        this.init();
    }

    public DeviceVFDESCPOS(String m_Port, boolean b) {
        this.sDisplayPort = m_Port;
        this.init(9600, 7, 1, 0);
    }

    public void init() {
        boolean found = false;
        for (SerialPort p : SerialPort.getCommPorts()) {
            if (!this.sDisplayPort.equals(p.getSystemPortName())) continue;
            this.serialPort = p;
            this.serialPort.setComPortParameters(9600, 8, 1, 0);
            found = true;
            break;
        }
        if (found && this.serialPort.openPort(2000)) {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        this.initVisor();
    }

    public void init(int baud, int DATABITS, int STOPBITS, int PARITY) {
        boolean found = false;
        for (SerialPort p : SerialPort.getCommPorts()) {
            if (!this.sDisplayPort.equals(p.getSystemPortName())) continue;
            this.serialPort = p;
            this.serialPort.setComPortParameters(baud, DATABITS, STOPBITS, PARITY);
            found = true;
            break;
        }
        if (found && this.serialPort.openPort(2000)) {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        this.initVisor();
    }

    @Override
    public void initVisor() {
        try {
            if (this.outputStream != null) {
                this.outputStream.write(ESCPOS.Anim);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void repaintLines() {
    }

    private void writeLines(String sLine1, String sLine2) {
        this.clearVisor();
        if (sLine1 != null && sLine1.length() > 20) {
            String last = sLine1.substring(20);
            sLine1 = sLine1.substring(0, 20);
            if (sLine2 == null) {
                sLine2 = "";
            }
            sLine2 = last + " " + (String)sLine2;
        }
        if (sLine2 != null && ((String)sLine2).length() > 20) {
            sLine2 = ((String)sLine2).substring(0, 20);
        }
        try {
            System.out.println("+++++++++ sLine1 : " + sLine1);
            System.out.println("+++++++++ sLine2 : " + (String)sLine2);
            if (this.outputStream != null && sLine1 != null) {
                this.outputStream.write(sLine1.replace("\u20ac", "e").getBytes());
                this.outputStream.flush();
            }
            if (this.outputStream != null && sLine2 != null) {
                this.outputStream.write(ESCPOS.SELECT_DISPLAY);
                this.outputStream.write(ESCPOS.Down_Line);
                this.outputStream.write(ESCPOS.Left_Line);
                this.outputStream.write(((String)sLine2).replace("\u20ac", "e").getBytes());
                this.outputStream.flush();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void writeVisor(int animation, String sLine1, String sLine2, TicketInfo order, List<TicketLineInfo> lines) {
        this.writeLines(sLine1, sLine2);
    }

    @Override
    public void writeVisor(String sLine1, String sLine2, TicketInfo order, List<TicketLineInfo> lines) {
        this.writeLines(sLine1, sLine2);
    }

    @Override
    public void clearVisor() {
        try {
            if (this.outputStream != null) {
                this.outputStream.write(ESCPOS.SELECT_DISPLAY);
                this.outputStream.write(ESCPOS.VISOR_CLEAR);
                this.outputStream.write(ESCPOS.VISOR_HOME);
                this.outputStream.flush();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void close() {
        if (this.serialPort != null) {
            this.serialPort.closePort();
        }
    }
}

