/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.printer.escpos.ESCPOS;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.qrcode.QImage;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class Ticket2
implements Cloneable {
    private static String TICKET_HEADER;
    private static String TICKET_FOOTER;
    public List<Integer> bytes = new ArrayList<Integer>();
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_LEFT_RIGHT = 3;
    protected final int TICKET_WIDTH;
    protected final int AVAILABLE_WIDTH;
    private final String LINE_OF_DASHES;
    private final String LINE_OF_STARS;
    private final String LINE_OF_EQUALS;
    private final StringBuilder builder = new StringBuilder(1024);

    public static void init(String header, String footer) {
        TICKET_HEADER = header.trim();
        TICKET_FOOTER = footer.trim();
    }

    public Ticket2(int TICKET_WIDTH, int AVAILABLE_WIDTH, List<Integer> bytes) {
        this.bytes = bytes;
        this.TICKET_WIDTH = TICKET_WIDTH;
        this.AVAILABLE_WIDTH = AVAILABLE_WIDTH;
        this.LINE_OF_DASHES = new String(new char[TICKET_WIDTH]).replace("\u0000", "-") + "\n";
        this.LINE_OF_STARS = new String(new char[TICKET_WIDTH]).replace("\u0000", "#") + "\n";
        this.LINE_OF_EQUALS = new String(new char[TICKET_WIDTH]).replace("\u0000", "=") + "\n";
        this.cancelChinese();
    }

    public Ticket2(int ticketWidth, int availableWidth) {
        this.TICKET_WIDTH = ticketWidth;
        this.AVAILABLE_WIDTH = availableWidth;
        this.LINE_OF_DASHES = new String(new char[ticketWidth]).replace("\u0000", "-") + "\n";
        this.LINE_OF_STARS = new String(new char[ticketWidth]).replace("\u0000", "#") + "\n";
        this.LINE_OF_EQUALS = new String(new char[ticketWidth]).replace("\u0000", "=") + "\n";
        this.bytes.add(27);
        this.bytes.add(64);
        this.bytes.add(27);
        this.bytes.add(116);
        this.bytes.add(16);
        this.cancelChinese();
        try {
            for (byte byt : " ".getBytes("windows-1252")) {
                this.bytes.add(Integer.valueOf(byt));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void blankLine(int numLines) {
        this.builder.setLength(0);
        for (int i = 0; i < numLines; ++i) {
            this.builder.append('\n');
        }
        this.append(this.builder.toString());
    }

    public void addNewLine(String str1, Object ... args) {
        this.addNewLine(-1, str1, args);
    }

    public void addNewLine(int alignment, String str1, Object ... args) {
        this.addNewLine(alignment, false, str1, args);
    }

    public void addNewLine(int alignment, boolean arabic, String str1, Object ... args) {
        if (alignment == 3) {
            this.alignLeftRight(str1, (String)args[0], arabic);
        } else {
            if (alignment != -1) {
                this.bytes.add(27);
                this.bytes.add(97);
                this.bytes.add(alignment);
            }
            if (args == null || args.length == 0) {
                this.append(str1 + "\n");
            } else {
                this.append(String.format(str1, args) + "\n", arabic);
            }
            if (alignment != -1) {
                this.bytes.add(27);
                this.bytes.add(97);
                this.bytes.add(0);
            }
        }
    }

    public void align(int alignment, String message) {
        this.bytes.add(27);
        this.bytes.add(97);
        this.bytes.add(alignment);
        this.append(message);
    }

    public void centerWithDashes(String message) {
        int numDashes = (this.TICKET_WIDTH - message.length() - 2) / 2;
        String halfDashes = new String(new char[numDashes]).replace("\u0000", "-");
        this.append(String.format("%s %s %s\n", halfDashes, message, halfDashes));
    }

    public void centerWithSpaces(String message) {
        int numSpace1 = (this.TICKET_WIDTH - message.length()) / 4;
        if (numSpace1 > 0) {
            int numSpace2 = numSpace1 * 4 + message.length() != this.TICKET_WIDTH ? (this.TICKET_WIDTH - (numSpace1 * 2 + message.length())) / 2 : numSpace1;
            this.append(String.format("%" + numSpace1 + "s%s%" + numSpace2 + "s\n", "", message, ""));
        } else {
            this.append(message + "\n");
        }
    }

    private void alignLeftRight(String message1, String message2, boolean arabic) {
        int numSpace = this.TICKET_WIDTH - message1.length() - message2.length();
        System.out.println("+++++++++ TICKET_WIDTH : " + this.TICKET_WIDTH);
        if (numSpace > 0) {
            this.append(String.format("%s%" + numSpace + "s%s\n", message1, "", message2), arabic);
        } else {
            this.append(String.format("%s%s\n", message1, message2), arabic);
        }
    }

    public String formatMax(String message) {
        return message.length() > this.AVAILABLE_WIDTH ? message.substring(0, this.AVAILABLE_WIDTH) : message;
    }

    public void addHeader() {
        if (!TICKET_HEADER.isEmpty()) {
            this.setTextSize(1, 2);
            this.align(1, TICKET_HEADER);
            this.setTextSize(1, 1);
            this.blankLine(2);
        }
    }

    public void addFooter() {
        if (!TICKET_FOOTER.isEmpty()) {
            this.blankLine(1);
            this.align(1, TICKET_FOOTER);
            this.blankLine(2);
        }
    }

    public void addLineOfStars() {
        this.append(this.LINE_OF_STARS);
    }

    public void addLineOfEquals() {
        this.append(this.LINE_OF_EQUALS);
    }

    public void addLineOfDashes() {
        this.append(this.LINE_OF_DASHES);
    }

    public void cut() {
        this.bytes.add(29);
        this.bytes.add(86);
        this.bytes.add(0);
    }

    public void halfCut() {
        this.bytes.add(29);
        this.bytes.add(86);
        this.bytes.add(1);
    }

    public void openCashDrawer() {
        this.bytes.add(27);
        this.bytes.add(112);
        this.bytes.add(0);
        this.bytes.add(50);
        this.bytes.add(250);
    }

    public void setBoldText(boolean bold) {
        this.bytes.add(27);
        this.bytes.add(69);
        this.bytes.add(bold ? 1 : 0);
    }

    public void setTextSize(int width, int height) {
        this.bytes.add(29);
        this.bytes.add(33);
        this.bytes.add(width - 1 << 4 | height - 1);
    }

    public void setEmphasis(boolean mode, int emphase) {
        if (mode) {
            this.bytes.add(27);
            this.bytes.add(69);
            this.bytes.add(emphase);
        } else {
            this.bytes.add(27);
            this.bytes.add(69);
            this.bytes.add(0);
        }
    }

    public void setUnderline(boolean isUnderlined) {
        if (isUnderlined) {
            this.bytes.add(27);
            this.bytes.add(45);
            this.bytes.add(50);
        } else {
            this.bytes.add(27);
            this.bytes.add(45);
            this.bytes.add(0);
        }
    }

    public void setReversedText(boolean reversed) {
        this.bytes.add(29);
        this.bytes.add(66);
        this.bytes.add(reversed ? 1 : 0);
    }

    public void setAlign(int alignment) {
        this.bytes.add(27);
        this.bytes.add(97);
        this.bytes.add(alignment);
    }

    public void append(String str) {
        this.append(str, false);
    }

    public void append(String str, boolean arabic) {
        if (AppLocal.PRINT_ARABIC) {
            try {
                byte[] newBytes4;
                if (!StringUtils.isBlank((String)str)) {
                    this.bytes.add(27);
                    this.bytes.add(116);
                    this.bytes.add(AppLocal.PRINT_CODE_PAGE);
                }
                for (byte byt : newBytes4 = str.getBytes(AppLocal.PRINT_ENCODING)) {
                    this.bytes.add(Integer.valueOf(byt));
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Ticket2.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                byte[] newBytes4;
                if (!StringUtils.isBlank((String)str)) {
                    this.bytes.add(27);
                    this.bytes.add(116);
                    this.bytes.add(16);
                }
                for (byte byt : newBytes4 = str.getBytes("Windows-1252")) {
                    this.bytes.add(Integer.valueOf(byt));
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Ticket2.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void prepend(String str) {
        try {
            byte[] newBytes;
            for (byte byt : newBytes = str.getBytes("windows-1252")) {
                this.bytes.add(0, Integer.valueOf(byt));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void append(Ticket2 ticket) {
        this.bytes.addAll(ticket.bytes);
    }

    public void cancelChinese() {
        this.bytes.add(28);
        this.bytes.add(46);
    }

    public void appendCodeBar(String str) {
        this.bytes.add(27);
        this.bytes.add(97);
        this.bytes.add(1);
        this.bytes.add(29);
        this.bytes.add(107);
        this.bytes.add(5);
        this.append(str);
        this.bytes.add(0);
    }

    private byte[] buildPOSCommand(byte[] command, byte ... args) {
        byte[] posCommand = new byte[command.length + args.length];
        System.arraycopy(command, 0, posCommand, 0, command.length);
        System.arraycopy(args, 0, posCommand, command.length, args.length);
        return posCommand;
    }

    private BitSet getBitsImageData(BufferedImage image) {
        int threshold = 127;
        int index = 0;
        int dimenssions = image.getWidth() * image.getHeight();
        BitSet imageBitsData = new BitSet(dimenssions);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int blue;
                int green;
                int color = image.getRGB(x, y);
                int red = (color & 0xFF0000) >> 16;
                int luminance = (int)((double)red * 0.3 + (double)(green = (color & 0xFF00) >> 8) * 0.59 + (double)(blue = color & 0xFF) * 0.11);
                imageBitsData.set(index, luminance < threshold);
                ++index;
            }
        }
        return imageBitsData;
    }

    public void addImageBis(BufferedImage image) {
        QImage img = new QImage();
        int[][] pixels = img.getPixelsSlow(image);
        for (int y = 0; y < pixels.length; y += 24) {
            this.bytes.addAll(this.asIntegers(ESCPOS.LINE_SPACE_24));
            this.bytes.addAll(this.asIntegers(ESCPOS.SELECT_BIT_IMAGE_MODE));
            this.bytes.addAll(this.asIntegers(new byte[]{(byte)(0xFF & pixels[y].length), (byte)((0xFF00 & pixels[y].length) >> 8)}));
            for (int x = 0; x < pixels[y].length; ++x) {
                this.bytes.addAll(this.asIntegers(img.recollectSlice(y, x, pixels)));
            }
            this.bytes.addAll(this.asIntegers(ESCPOS.CTL_LF));
        }
        this.bytes.addAll(this.asIntegers(ESCPOS.CTL_LF));
        this.bytes.addAll(this.asIntegers(ESCPOS.LINE_SPACE_30));
    }

    public void addImage(BufferedImage image) {
        BitSet imageBits = this.getBitsImageData(image);
        byte widthLSB = (byte)(image.getWidth() & 0xFF);
        byte widthMSB = (byte)(image.getWidth() >> 8 & 0xFF);
        byte[] selectBitImageModeCommand = this.buildPOSCommand(ESCPOS.SELECT_BIT_IMAGE_MODE, 33, widthLSB, widthMSB);
        this.bytes.addAll(this.asIntegers(ESCPOS.CTL_LF_IMAGE));
        for (int offset = 0; offset < image.getHeight(); offset += 24) {
            this.bytes.addAll(this.asIntegers(selectBitImageModeCommand));
            int imageDataLineIndex = 0;
            byte[] imageDataLine = new byte[3 * image.getWidth()];
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int k = 0; k < 3; ++k) {
                    byte slice = 0;
                    for (int b = 0; b < 8; ++b) {
                        int y = (offset / 8 + k) * 8 + b;
                        int i = y * image.getWidth() + x;
                        boolean v = false;
                        if (i < imageBits.length()) {
                            v = imageBits.get(i);
                        }
                        slice = (byte)(slice | (byte)((v ? 1 : 0) << 7 - b));
                    }
                    imageDataLine[imageDataLineIndex + k] = slice;
                }
                imageDataLineIndex += 3;
            }
            this.bytes.addAll(this.asIntegers(imageDataLine));
            this.append("\n");
        }
        this.bytes.add(27);
        this.bytes.add(50);
    }

    public void addImageTicket(BufferedImage image) {
        BitSet imageBits = this.getBitsImageData(image);
        byte widthLSB = (byte)(image.getWidth() & 0xFF);
        byte widthMSB = (byte)(image.getWidth() >> 8 & 0xFF);
        byte[] selectBitImageModeCommand = this.buildPOSCommand(ESCPOS.SELECT_BIT_IMAGE_MODE, 33, widthLSB, widthMSB);
        this.bytes.addAll(this.asIntegers(ESCPOS.CTL_LF_IMAGE));
        for (int offset = 0; offset < image.getHeight(); offset += 24) {
            this.bytes.addAll(this.asIntegers(selectBitImageModeCommand));
            int imageDataLineIndex = 0;
            byte[] imageDataLine = new byte[3 * image.getWidth()];
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int k = 0; k < 3; ++k) {
                    byte slice = 0;
                    for (int b = 0; b < 8; ++b) {
                        int y = (offset / 8 + k) * 8 + b;
                        int i = y * image.getWidth() + x;
                        boolean v = false;
                        if (i < imageBits.length()) {
                            v = imageBits.get(i);
                        }
                        slice = (byte)(slice | (byte)((v ? 1 : 0) << 7 - b));
                    }
                    imageDataLine[imageDataLineIndex + k] = slice;
                }
                imageDataLineIndex += 3;
            }
            this.bytes.addAll(this.asIntegers(imageDataLine));
            this.append("\n");
        }
        this.bytes.add(27);
        this.bytes.add(50);
    }

    public void appendQRCode(String str) {
        this.bytes.add(10);
        this.bytes.add(27);
        this.bytes.add(29);
        this.bytes.add(121);
        this.bytes.add(83);
        this.bytes.add(48);
        this.bytes.add(2);
        this.bytes.add(str.length());
        this.append(str);
        this.bytes.add(10);
    }

    private List<Byte> asBytes(byte[] arrays) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte b : arrays) {
            list.add(b);
        }
        return list;
    }

    private List<Integer> asIntegers(byte[] arrays) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (byte b : arrays) {
            list.add(new Integer(b & 0xFF));
        }
        return list;
    }

    public Ticket2 clone() {
        try {
            return (Ticket2)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Ticket2.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setFontSizeText(int font) {
        this.bytes.add(27);
        this.bytes.add(77);
        this.bytes.add(font);
    }
}

