/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.AppConstants;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.controllers.GloryController;
import com.openbravo.format.Formats;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankProduct;
import com.openbravo.models.RankProductDiver;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.ActionPrint;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterCommand;
import com.openbravo.pos.printer.Ticket;
import com.openbravo.pos.printer.Ticket2;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.CarteOrder;
import com.openbravo.pos.ticket.Course;
import com.openbravo.pos.ticket.EquipmentTurnover;
import com.openbravo.pos.ticket.FinancialReportInfo;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.ItemLabel;
import com.openbravo.pos.ticket.ItemLine;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.ItemResult;
import com.openbravo.pos.ticket.LineKitchen;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.LogPanier;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TurnoverInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.ticket.ZoneItems;
import com.openbravo.pos.ticket.ZoneItemsLabel;
import com.openbravo.pos.ticket.ZoneLines;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.GenPDF;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.TicketUtils;
import com.openbravo.qrcode.QrCodeHelper;
import fr.protactile.glory.POSSimple.Collect;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.DuplicataJustificatifPayment;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.JustificatifPayment;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.PertEntity;
import fr.protactile.procaisse.dao.entities.PertInfo;
import fr.protactile.procaisse.dao.entities.ZGlobalInfoDTO;
import fr.protactile.procaisse.dao.entities.ZHostNameDTO;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PrinterHelper {
    private int nombreLignesInCammande = 0;
    private static final int ALIGN_LEFT = 0;
    private static final int ALIGN_CENTER = 1;
    private static final int ALIGN_RIGHT = 2;
    public static final int LOGO_WIDTH = 256;
    public static final int LOGO_HEIGHT = 256;
    public final SimpleDateFormat dateFormatterYearLess = new SimpleDateFormat("dd/MM");
    public final SimpleDateFormat HorraireFormatter = new SimpleDateFormat("HH'h'mm");
    public final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    public static final SimpleDateFormat dateFormatterFull = new SimpleDateFormat("dd/MM/yyyy - HH:mm:ss");
    SimpleDateFormat dateFormatterText = new SimpleDateFormat("EEEEEE dd MMMMMM yyy \u00c0 HH:mm", Locale.FRENCH);
    public final SimpleDateFormat dateFormatterFullFacture = new SimpleDateFormat("dd/MM/yyyy \u00c0 HH'h'mm'm'ss's'");
    public final SimpleDateFormat dateMonthFormatter = new SimpleDateFormat("MMMM yyyy");
    public final SimpleDateFormat dateFormatter = DateUtils.formatterDAY_MONTH_YEAR_SLASHES;
    public static Map ticketStatus = new HashMap();
    public String barIP;
    public int numKitchenTickets;
    public int numBarTickets;
    public String barTicketHeader;
    public String barTicketFooter;
    public String avoirTicketFooter;
    public static boolean printLogo;
    public static String barConnexion;
    public static String defaultKitchenConnexion;
    public static String barUsbDevice;
    public static String defaultKitchenUsbDevice;
    public static int CUSTOMER_TICKET_WIDTH;
    public static int KITCHEN_TICKET_WIDTH;
    public static int AVAILABLE_CUSTOMER_WIDTH;
    public static int MIN_TICKET_LINES;
    public static String LINE_OF_DASHES;
    public static String LINE_OF_STARS;
    public static boolean HAS_CASH_DRAWER;
    public static boolean PRINT_GIVE_BACK;
    public static boolean BOLDER_KITCHEN_TICKET;
    public static int TICKET_WIDTH;
    public static int AVAILABLE_WIDTH;
    public static boolean CASH_DRAWER_ON_OXHOO;
    public static boolean ADD_DESCRIPTION_ON_KICTHEN_TICKETS;
    public static boolean ADD_TOTAL_ON_KICTHEN_TICKETS;
    public static boolean SINGLE_ORDER_TYPE;
    public static int BAR_PRINTER_BAUDRATE;
    public static int KITCHEN_PRINTER_BAUDRATE;
    private double min_total = 25.0;
    public static boolean DELIVERY_SERVICES;
    PrinterInfo printerCaisse;
    PrinterInfo ecranSuivi;
    int z = 0;
    private String prefix_option;
    private int shift_option;
    private int shift_after_name_goption;
    private Ticket2 ticket;
    private List<String> alphaOrder;
    private final String SOURCE_CAISSE = "caisse";
    private final String SOURCE_UBEREAT = "Uber Eats";
    private final String SOURCE_BORNE_CB = "borne cb";
    private final String SOURCE_BORNE = "borne";
    private final String SOURCE_ONLINE = "online";
    private final String SOURCE_WEB = "web";
    private final String MODE_CAISSE = "Caisse";
    private final String INSIDE = "inside";
    private final String OUTSIDE = "outside";
    private List<String> platFormSourcesOrder;
    private List<String> platFormTypesOrder;
    public final String STR_FAC_REG_MEN_IND = "Pe\u0301nalite\u0301s de retard : trois fois le taux annuel d'inte\u0301re\u0302t le\u0301gal en vigueur calcule\u0301 depuis la date d'e\u0301che\u0301ance jusqu'a\u0300 complet paiement du prix";
    public final String STR_FAC_REG_TXX = "Indemnite\u0301 forfaitaire pour frais de recouvrement en cas de retard de paiement : 40 \u20ac";
    public final String STR_ANNULATION = "ANNULATION";
    private AppView m_App;
    private AppConfig config;

    public PrinterHelper() {
        this.init();
    }

    public void init() {
        this.printerCaisse = AppLocal.printerCaisse;
        this.ecranSuivi = AppLocal.printerEcranSuivi;
        MIN_TICKET_LINES = 1;
        SINGLE_ORDER_TYPE = false;
        CUSTOMER_TICKET_WIDTH = this.printerCaisse.getWith();
        KITCHEN_TICKET_WIDTH = 40;
        AVAILABLE_CUSTOMER_WIDTH = CUSTOMER_TICKET_WIDTH - 17;
        LINE_OF_DASHES = new String(new char[CUSTOMER_TICKET_WIDTH]).replace("\u0000", "-");
        LINE_OF_STARS = new String(new char[CUSTOMER_TICKET_WIDTH]).replace("\u0000", "#");
        this.barIP = "192.168.1.120";
        this.numKitchenTickets = 1;
        this.numBarTickets = 1;
        this.barTicketHeader = "Bienvenue\n\n";
        this.barTicketFooter = "Merci et \ufffd\ufffd bient\u00f4t";
        this.avoirTicketFooter = "Merci et \ufffd\ufffd bient\u00f4t";
        printLogo = false;
        Ticket2.init(this.barTicketHeader, this.barTicketFooter);
        BOLDER_KITCHEN_TICKET = false;
        HAS_CASH_DRAWER = true;
        PRINT_GIVE_BACK = false;
        barConnexion = "reseau";
        defaultKitchenConnexion = "reseau";
        barUsbDevice = "";
        defaultKitchenUsbDevice = "";
        if (barConnexion.equals("USB")) {
            this.barIP = barUsbDevice;
        }
        CASH_DRAWER_ON_OXHOO = true;
        ADD_DESCRIPTION_ON_KICTHEN_TICKETS = false;
        ADD_TOTAL_ON_KICTHEN_TICKETS = false;
        BAR_PRINTER_BAUDRATE = 1;
        KITCHEN_PRINTER_BAUDRATE = 1;
        DELIVERY_SERVICES = false;
        this.prefix_option = AppLocal.disting_option != false ? "    " : "";
        this.shift_option = 7;
        this.shift_after_name_goption = 4;
        this.initAlphaOrder();
        this.initPlatFromInfosOrder();
    }

    public void printKitchenTickets(TicketInfo order, String type, List<PrinterInfo> printers, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDineInLaterByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayLaterByPrinter, String status_borne, Decreaser decreaser, List<OptionItemOrder> optionsToprint, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDeletedByPrinter, boolean first_part_of_order, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesUpdatedByPrinter, LinkedHashMap<Integer, List<ZoneItems>> zoneSubItemsLaterByPrinter, boolean borne, boolean dishop_ticket) {
        System.out.println("******** printKitchenTickets()");
        int numPrinters = printers.size();
        String text_commande = first_part_of_order ? " " : AppLocal.getIntString("Text.update.order") + " ";
        int j = 1;
        String orderNum = this.getNumOrder(order);
        int index_product = 0;
        for (PrinterInfo printer : printers) {
            int numberZones;
            List<ZoneItems> zoneSubItems;
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            this.ticket = null;
            if (!AppLocal.KITCHEN_TICKET_BY_PRODUCT) {
                this.headerKitchenTicket(order, text_commande, orderNum, borne, dishop_ticket);
            }
            int index = 0;
            List<ZoneLines> zoneLines = zoneLinesByPrinter != null ? zoneLinesByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesDineInLater = zoneLinesDineInLaterByPrinter != null ? zoneLinesDineInLaterByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesTakeAway = zoneLinesTakeAwayByPrinter != null ? zoneLinesTakeAwayByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesTakeAwayLater = zoneLinesTakeAwayLaterByPrinter != null ? zoneLinesTakeAwayLaterByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesDeleted = zoneLinesDeletedByPrinter != null ? zoneLinesDeletedByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesUpdated = zoneLinesUpdatedByPrinter != null ? zoneLinesUpdatedByPrinter.get(printer.getId()) : null;
            List<ZoneItems> list = zoneSubItems = zoneSubItemsLaterByPrinter != null ? zoneSubItemsLaterByPrinter.get(printer.getId()) : null;
            if (zoneLines != null) {
                numberZones = zoneLines.size();
                for (ZoneLines zoneLine : zoneLines) {
                    if (!AppLocal.KITCHEN_TICKET_BY_PRODUCT) {
                        this.addNameZone(numberZones, zoneLine, this.ticket);
                    }
                    if (zoneLine.getLines() == null) continue;
                    for (TicketLineInfo product : zoneLine.getLines()) {
                        if (AppLocal.KITCHEN_TICKET_BY_PRODUCT && (product.getListProducts() == null || product.getListProducts().isEmpty())) {
                            this.headerKitchenTicket(order, orderNum, index_product);
                        }
                        if (AppLocal.KITCHEN_TICKET_BY_PRODUCT && product.getListProducts() != null && !product.getListProducts().isEmpty()) {
                            this.addDetailProductAndSubProduct(product, printer, "(" + AppLocal.getIntString("Button.add") + ") ", first_part_of_order, order, orderNum, decreaser, index_product, dishop_ticket, false, borne);
                        } else {
                            this.addDetailProduct(this.ticket, order, product, printer, "(" + AppLocal.getIntString("Button.add") + ") ", first_part_of_order, false);
                        }
                        if (AppLocal.KITCHEN_TICKET_BY_PRODUCT && (product.getListProducts() == null || product.getListProducts().isEmpty())) {
                            this.footerKitchenTicket(this.ticket, printer, orderNum, decreaser, dishop_ticket, 0, 0, order, borne);
                        }
                        ++index_product;
                        ++index;
                    }
                }
            }
            if (AppLocal.KITCHEN_TICKET_BY_PRODUCT) continue;
            if (optionsToprint != null) {
                this.ticket.blankLine(1);
                this.ticket.setTextSize(AppLocal.size_supplement, 2);
                for (OptionItemOrder option : optionsToprint) {
                    if (option.getPrinter() != printer.getId()) continue;
                    this.addNameOption(this.ticket, option);
                    this.ticket.setReversedText(false);
                    this.ticket.blankLine(2);
                }
                this.ticket.setTextSize(1, 2);
            }
            if (zoneLinesDineInLater != null && !zoneLinesDineInLater.isEmpty() || zoneSubItems != null && !zoneSubItems.isEmpty()) {
                this.ticket.addNewLine(1, " **** " + AppLocal.text_later + " **** ", new Object[0]);
                if (zoneLinesDineInLater != null && !zoneLinesDineInLater.isEmpty()) {
                    numberZones = zoneLinesDineInLater.size();
                    for (ZoneLines zoneLine : zoneLinesDineInLater) {
                        this.addNameZone(numberZones, zoneLine, this.ticket);
                        if (zoneLine.getLines() == null) continue;
                        for (TicketLineInfo ticketLineInfo : zoneLine.getLines()) {
                            this.printLineLater(this.ticket, order, ticketLineInfo, printer, index, first_part_of_order);
                        }
                    }
                }
                if (zoneSubItems != null && !zoneSubItems.isEmpty()) {
                    numberZones = zoneSubItems.size();
                    for (ZoneItems zoneItem : zoneSubItems) {
                        this.addNameZone(numberZones, zoneItem, this.ticket);
                        if (zoneItem.getSubItems() == null) continue;
                        for (ProductTicket subItem : zoneItem.getSubItems()) {
                            this.addDetailSubProduct(this.ticket, subItem);
                        }
                    }
                }
            }
            if (zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty() || zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty()) {
                this.addBlocLater(this.ticket);
                if (zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty()) {
                    numberZones = zoneLinesTakeAway.size();
                    for (ZoneLines zoneLine : zoneLinesTakeAway) {
                        this.addNameZone(numberZones, zoneLine, this.ticket);
                        if (zoneLine.getLines() == null) continue;
                        for (TicketLineInfo ticketLineInfo : zoneLine.getLines()) {
                            this.printLineLater(this.ticket, order, ticketLineInfo, printer, index, first_part_of_order);
                        }
                    }
                }
                if (zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty()) {
                    this.ticket.addNewLine(1, " **** " + AppLocal.text_later + " **** ", new Object[0]);
                    numberZones = zoneLinesTakeAwayLater.size();
                    for (ZoneLines zoneLine : zoneLinesTakeAwayLater) {
                        this.addNameZone(numberZones, zoneLine, this.ticket);
                        if (zoneLine.getLines() == null) continue;
                        for (TicketLineInfo ticketLineInfo : zoneLine.getLines()) {
                            this.printLineLater(this.ticket, order, ticketLineInfo, printer, index, first_part_of_order);
                        }
                    }
                }
            }
            if (zoneLinesDeleted != null && !zoneLinesDeleted.isEmpty()) {
                numberZones = zoneLinesDeleted.size();
                this.ticket.setTextSize(1, 2);
                this.ticket.addNewLine(1, AppLocal.getIntString("Text.cancel"), new Object[0]);
                this.ticket.setTextSize(1, 1);
                for (ZoneLines zoneLine : zoneLinesDeleted) {
                    if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                    this.addNameZone(numberZones, zoneLine, this.ticket);
                    this.ticket.setTextSize(1, 2);
                    for (TicketLineInfo product : zoneLine.getLines()) {
                        String str = PrinterHelper.formatMax("( " + AppLocal.getIntString("Button.cancel") + " ) " + product.printName());
                        this.ticket.addNewLine(1, str, new Object[0]);
                    }
                }
            }
            if (zoneLinesUpdated != null && !zoneLinesUpdated.isEmpty()) {
                numberZones = zoneLinesUpdated.size();
                this.ticket.setTextSize(1, 2);
                this.ticket.addNewLine(1, AppLocal.getIntString("Text.update"), new Object[0]);
                this.ticket.setTextSize(1, 1);
                for (ZoneLines zoneLine : zoneLinesUpdated) {
                    if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                    this.addNameZone(numberZones, zoneLine, this.ticket);
                    for (TicketLineInfo line : zoneLine.getLines()) {
                        this.ticket.setTextSize(1, 2);
                        this.addDetailProduct(this.ticket, order, line, printer, "(" + AppLocal.getIntString("Button.update") + ") ", first_part_of_order, false);
                    }
                }
            }
            this.ticket.setTextSize(1, 1);
            if (status_borne != null) {
                this.addTextBloc(this.ticket, status_borne.toUpperCase());
            }
            if (order.getComment() != null && !order.getComment().isEmpty()) {
                this.addNote(this.ticket, "Commentaire : " + order.getComment());
            }
            this.footerKitchenTicket(this.ticket, printer, orderNum, decreaser, dishop_ticket, numPrinters, j, order, borne);
            ++j;
        }
    }

    public void printKitchenTicketsAllProduct(PrinterInfo printerSummaryKitchen, TicketInfo order, List<ZoneLines> zoneLines, boolean displayQuantity, boolean fondNoir, boolean isSeparate, Decreaser decreaser, boolean cb_borne, boolean delivery_order, boolean error_send_to_caisse, String num_order_borne, List<ItemResult> itemProducts) {
        String source_order;
        String orderNum;
        AVAILABLE_WIDTH = TICKET_WIDTH = printerSummaryKitchen.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addTypeOrder(ticket, order);
        }
        ticket.blankLine(1);
        ticket.setTextSize(3, 3);
        String string = orderNum = num_order_borne != null && !num_order_borne.isEmpty() ? num_order_borne : order.getNumberOrder(true, false);
        if (AppLocal.PRINT_TEXT_DISHOP_IN_TICKETS && order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("Dishop")) {
            ticket.addNewLine(1, AppLocal.getIntString("Text.recap.order") + " DISHOP", new Object[0]);
            ticket.addNewLine(1, orderNum, new Object[0]);
        } else {
            this.addTitleRecap(ticket, order, orderNum);
        }
        ticket.setTextSize(2, 2);
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addStatusOrder(ticket, order, cb_borne);
        }
        ticket.blankLine(1);
        if (!AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(ticket, order);
            ticket.blankLine(1);
        }
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        this.checkAndShowInfoCustomer(order, ticket, 0);
        this.sortLinesOrder(order);
        if (!AppLocal.ADD_GROUPED_PRODUCT_TO_PRINTED_RECAP && zoneLines != null) {
            int numberZones = zoneLines.size();
            for (ZoneLines zoneLines2 : zoneLines) {
                this.addNameZone(numberZones, zoneLines2, ticket);
                if (zoneLines2.getLines() == null) continue;
                for (TicketLineInfo product : zoneLines2.getLines()) {
                    boolean print_able = true;
                    if (product.isNext()) continue;
                    if (print_able) {
                        ticket.setTextSize(1, 2);
                        if (AppLocal.PRODUCT_KITCHEN_BOLD) {
                            ticket.setBoldText(true);
                        }
                        this.addNameProduit(ticket, product, fondNoir);
                        this.loadIngredient(product, ticket);
                        for (ItemOrderInfo ingredient : product.getListIngredients()) {
                            if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
                            this.addNameIngredient(ticket, ingredient);
                        }
                        for (OptionItemOrder supplement : product.getListSupplements()) {
                            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                            this.appendSupplemntKitchen(supplement, ticket, true);
                        }
                        for (ProductTicket productMenu : product.getListProducts()) {
                            this.addNameItem(ticket, productMenu);
                            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                                if (ingredient.getIdProduct() != productMenu.getIdProduct() || ingredient.getIdCarte() != productMenu.getIdCarte() || ingredient.getIndex_carte() != productMenu.getIndex_carte()) continue;
                                this.addNameIngredient(ticket, ingredient);
                            }
                            for (OptionItemOrder supplement : product.getListSupplements()) {
                                if (supplement.getIdProduct() != productMenu.getIdProduct() || supplement.getIdCarte() != productMenu.getIdCarte() || supplement.getIndex_carte() != productMenu.getIndex_carte()) continue;
                                this.appendSupplemntKitchen(supplement, ticket, true);
                            }
                            if (productMenu.getComment() == null || productMenu.getComment().isEmpty()) continue;
                            this.addNote(ticket, this.textAfterCheckLanguage(productMenu.getComment()));
                        }
                        if (product.getDescription() != null && !product.getDescription().isEmpty() && !AppLocal.HIDE_DESCRIPTION_PRODUCT_IN_TICKET) {
                            ticket.addNewLine(0, this.textAfterCheckLanguage(product.getDescription()), new Object[0]);
                        }
                        if (product.getNote() != null && !product.getNote().isEmpty()) {
                            this.addNote(ticket, this.textAfterCheckLanguage(product.getNote()));
                        }
                    }
                    ticket.blankLine(1);
                }
            }
        }
        if (AppLocal.ADD_GROUPED_PRODUCT_TO_PRINTED_RECAP && itemProducts != null && !itemProducts.isEmpty() && !AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_PRINTED_RECAP) {
            String categorie = null;
            ticket.setTextSize(2, 2);
            for (ItemResult itemResult : itemProducts) {
                String item_categorie = itemResult.getOrder_category();
                if (categorie == null || !categorie.equals(item_categorie)) {
                    if (categorie != null) {
                        ticket.blankLine(1);
                    }
                    categorie = item_categorie;
                    ticket.setReversedText(true);
                    ticket.addNewLine(0, item_categorie.toUpperCase(), new Object[0]);
                    ticket.setReversedText(false);
                }
                ticket.addNewLine(0, this.printMultiply(itemResult.getQuantity()) + " " + itemResult.getName().toUpperCase(), new Object[0]);
            }
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_PRINTED_RECAP && itemProducts != null && !itemProducts.isEmpty()) {
            String zone;
            LinkedHashMap<String, List> groupedByZone = new LinkedHashMap<String, List>();
            for (ItemResult itemResult : itemProducts) {
                zone = itemResult.getZone();
                groupedByZone.computeIfAbsent(zone, k -> new ArrayList()).add(itemResult);
            }
            ticket.setTextSize(2, 2);
            for (Map.Entry entry : groupedByZone.entrySet()) {
                zone = (String)entry.getKey();
                ticket.blankLine(1);
                ticket.setReversedText(true);
                ticket.addNewLine(0, "ZONE: " + zone.toUpperCase(), new Object[0]);
                ticket.setReversedText(false);
                for (ItemResult item : (List)entry.getValue()) {
                    ticket.addNewLine(0, this.printMultiply(item.getQuantity()) + " " + item.getName().toUpperCase(), new Object[0]);
                }
            }
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.TOTAL_RECAP || delivery_order || AppLocal.PRINT_RECAP_DELIVERY && order.getType() != null && order.getType().equalsIgnoreCase("En Livraison")) {
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
            ticket.setBoldText(true);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(3, "Total :", Formats.CURRENCY_PRINTED.formatValue(order.getTotal()));
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
        }
        if (order.getComment() != null && !order.getComment().isEmpty()) {
            this.addNote(ticket, "Commentaire : " + order.getComment());
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            String status_order;
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            ticket.setReversedText(true);
            ticket.addNewLine(1, " " + order.getType() + " ", new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            String string2 = status_order = order.isPaid() || order.isPlatform_order() ? "Pay\u00e9e" : "Impay\u00e9e";
            if (cb_borne && order.isPaid()) {
                status_order = AppLocal.getIntString("Text.paid.at.terminal");
            }
            if (!order.isPaid()) {
                ticket.setReversedText(true);
            }
            ticket.addNewLine(1, status_order, new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(ticket, order);
            ticket.blankLine(1);
        }
        if (error_send_to_caisse) {
            this.addMessageFooter(ticket);
        }
        if ((source_order = this.getSourceOrder(order)) != null && !source_order.isEmpty() && !AppLocal.PRINT_ARABIC) {
            ticket.addNewLine(1, "Source : " + source_order, new Object[0]);
        }
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(printerSummaryKitchen.getIp(), printerSummaryKitchen.getNamePrinter(), printerSummaryKitchen.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket"), printerSummaryKitchen.getPort(), printerSummaryKitchen.getBand_rate(), printerSummaryKitchen, decreaser, false);
    }

    public void printKitchenTicketsMAJ1(TicketInfo order, String type, List<PrinterInfo> printers, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDineInLaterByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayLaterByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDeletedByPrinter, LinkedHashMap<Integer, List<ZoneItems>> zoneSubItemsLaterByPrinter, boolean fondNoir, boolean isSeparate, boolean displayNumOrder, boolean displayServeur, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        String orderNum = this.getNumOrder(order);
        for (PrinterInfo printer : printers) {
            List<ZoneItems> zoneSubItems;
            List<ZoneLines> zoneLines = zoneLinesByPrinter != null ? zoneLinesByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesDineInLater = zoneLinesDineInLaterByPrinter != null ? zoneLinesDineInLaterByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesTakeAway = zoneLinesTakeAwayByPrinter != null ? zoneLinesTakeAwayByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesTakeAwayLater = zoneLinesTakeAwayLaterByPrinter != null ? zoneLinesTakeAwayLaterByPrinter.get(printer.getId()) : null;
            List<ZoneLines> zoneLinesDeleted = zoneLinesDeletedByPrinter != null ? zoneLinesDeletedByPrinter.get(printer.getId()) : null;
            List<ZoneItems> list = zoneSubItems = zoneSubItemsLaterByPrinter != null ? zoneSubItemsLaterByPrinter.get(printer.getId()) : null;
            if (zoneLines != null && !zoneLines.isEmpty() || zoneLinesDineInLater != null && !zoneLinesDineInLater.isEmpty() || zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty() || zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty() || zoneLinesDeleted != null && !zoneLinesDeleted.isEmpty() || zoneSubItems != null && !zoneSubItems.isEmpty()) {
                boolean addTileCancel_Add = (zoneLines != null && !zoneLines.isEmpty() || zoneLinesDineInLater != null && !zoneLinesDineInLater.isEmpty() || zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty() || zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty() || zoneSubItems != null && !zoneSubItems.isEmpty()) && zoneLinesDeleted != null && !zoneLinesDeleted.isEmpty();
                TICKET_WIDTH = printer.getWith();
                AVAILABLE_WIDTH = printer.getWith();
                Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
                ticket.blankLine(1);
                ticket.setTextSize(2, 2);
                ticket.setBoldText(true);
                ticket.addNewLine(1, AppLocal.getIntString("Text.update") + " ", new Object[0]);
                ticket.setTextSize(1, 2);
                ticket.addNewLine(1, AppLocal.getIntString("Text.orders") + " " + orderNum, new Object[0]);
                if (displayServeur && order.getUser() != null) {
                    ticket.addNewLine(1, AppLocal.getIntString("Label.server") + " " + order.getUser().getName(), new Object[0]);
                }
                if (order.getNumTable() != 0) {
                    ticket.setTextSize(2, 2);
                    String str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
                    ticket.addNewLine(1, str, new Object[0]);
                }
                ticket.setBoldText(false);
                if (zoneLinesDeleted != null && !zoneLinesDeleted.isEmpty()) {
                    int numberZones = zoneLinesDeleted.size();
                    if (addTileCancel_Add) {
                        ticket.setTextSize(1, 1);
                        ticket.blankLine(1);
                        ticket.setTextSize(1, 2);
                        ticket.addNewLine(1, AppLocal.getIntString("Text.cancel"), new Object[0]);
                        ticket.setTextSize(1, 1);
                    }
                    for (ZoneLines zoneLine : zoneLinesDeleted) {
                        if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                        this.addNameZone(numberZones, zoneLine, ticket);
                        ticket.setTextSize(1, 2);
                        for (TicketLineInfo product : zoneLine.getLines()) {
                            String str = PrinterHelper.formatMax("( " + AppLocal.getIntString("Button.cancel") + " ) " + product.printName());
                            ticket.addNewLine(1, str, new Object[0]);
                        }
                    }
                }
                if (addTileCancel_Add) {
                    ticket.setTextSize(1, 1);
                    ticket.blankLine(1);
                    ticket.setTextSize(1, 2);
                    ticket.setTextSize(1, 2);
                    ticket.addNewLine(1, AppLocal.getIntString("Text.update"), new Object[0]);
                    ticket.setTextSize(1, 1);
                }
                if (zoneLines != null && !zoneLines.isEmpty()) {
                    int numberZones = zoneLines.size();
                    for (ZoneLines zoneLine : zoneLines) {
                        if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                        this.addNameZone(numberZones, zoneLine, ticket);
                        this.appendLineUpdated(ticket, order, zoneLine.getLines(), printer, fondNoir, isSeparate, false);
                    }
                }
                if (zoneLinesDineInLater != null && !zoneLinesDineInLater.isEmpty()) {
                    int numberZones = zoneLinesDineInLater.size();
                    ticket.addNewLine(1, " **** " + AppLocal.text_later + " **** ", new Object[0]);
                    for (ZoneLines zoneLine : zoneLinesDineInLater) {
                        if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                        this.addNameZone(numberZones, zoneLine, ticket);
                        this.appendLineUpdated(ticket, order, zoneLine.getLines(), printer, fondNoir, isSeparate, true);
                    }
                }
                if (zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty() || zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty()) {
                    this.addBlocLater(ticket);
                    if (zoneLinesTakeAway != null && !zoneLinesTakeAway.isEmpty()) {
                        int numberZones = zoneLinesTakeAway.size();
                        for (ZoneLines zoneLine : zoneLinesTakeAway) {
                            if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                            this.addNameZone(numberZones, zoneLine, ticket);
                            this.appendLineUpdated(ticket, order, zoneLine.getLines(), printer, fondNoir, isSeparate, true);
                        }
                    }
                    if (zoneLinesTakeAwayLater != null && !zoneLinesTakeAwayLater.isEmpty()) {
                        int numberZones = zoneLinesTakeAwayLater.size();
                        ticket.addNewLine(1, " **** " + AppLocal.text_later + " **** ", new Object[0]);
                        for (ZoneLines zoneLine : zoneLinesTakeAwayLater) {
                            if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                            this.addNameZone(numberZones, zoneLine, ticket);
                            this.appendLineUpdated(ticket, order, zoneLine.getLines(), printer, fondNoir, isSeparate, true);
                        }
                    }
                }
                if (zoneSubItems != null && !zoneSubItems.isEmpty()) {
                    ticket.addNewLine(1, " **** " + AppLocal.text_later + " **** ", new Object[0]);
                    int numberZones = zoneSubItems.size();
                    for (ZoneItems zoneItem : zoneSubItems) {
                        this.addNameZone(numberZones, zoneItem, ticket);
                        if (zoneItem.getSubItems() == null) continue;
                        for (ProductTicket subItem : zoneItem.getSubItems()) {
                            this.addDetailSubProduct(ticket, subItem);
                        }
                    }
                }
                ticket.blankLine(1);
                if (order.getComment() != null && !order.getComment().isEmpty()) {
                    this.addNote(ticket, "Commentaire : " + order.getComment());
                }
                ticket.blankLine(3);
                ticket.setTextSize(1, 2);
                ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
                ticket.blankLine(4);
                if (AppLocal.AUTO_CUTTER_TICKET) {
                    ticket.cut();
                } else {
                    ticket.halfCut();
                }
                ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
                mesBytesInteger.addAll(ticket.bytes);
                for (int h = 1; h < printer.getNumber(); ++h) {
                    ticket.bytes.addAll(mesBytesInteger);
                }
                PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + orderNum, AppLocal.getIntString("Message.error.print.ticket.kitchen"), printer.getPort(), printer.getBand_rate(), printer, decreaser);
            }
            ++j;
        }
    }

    public void printCaisseTickets(int orderId, TicketInfo order, EnteteInfo entete, boolean has_drawer_permission, Decreaser decreaser, String holder_ticket) {
        this.printCaisseTickets(orderId, order, entete, has_drawer_permission, null, decreaser, holder_ticket);
    }

    public void printCaisseTickets(int orderId, TicketInfo order, EnteteInfo entete, boolean has_drawer_permission, BufferedImage qrCodeImage, Decreaser decreaser, String holder_ticket) {
        if (order.getTotal() >= this.min_total || this.printerCaisse.getNumber() > 0) {
            AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
            this.nombreLignesInCammande = 0;
            Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
            ticket.blankLine(1);
            if (TicketUtils.getPicTicket() != null) {
                ticket.blankLine(1);
                ticket.setAlign(1);
                ticket.addImageTicket(TicketUtils.getPicTicket());
                ticket.blankLine(1);
            }
            ticket.setBoldText(true);
            this.appendHeader(ticket, entete);
            if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
                ticket.setTextSize(2, 2);
                ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
                ticket.setTextSize(1, 1);
                ticket.blankLine(1);
            }
            this.addNumOrder(ticket, order);
            ticket.blankLine(1);
            this.checkAndShowInfoCustomer(order, ticket, 1);
            String orderNum = order.getCaisse() != null && order.getSent_from() == null ? order.getCaisse() + " " + entete.getId() : String.valueOf(entete.getId());
            String postFix = " " + AppLocal.getIntString("Label.caisse") + " " + entete.getCode_caisse();
            if (entete.IsTicketRestituted()) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.duplicata") + " " + AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
            } else {
                ticket.addNewLine(1, AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
            }
            if (AppLocal.isVersionRetailSale().booleanValue()) {
                ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
            } else {
                ticket.setBoldText(true);
                ticket.addNewLine(1, dateFormatterFull.format(order.getDate()) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
                ticket.setBoldText(false);
            }
            if (order.getNumTable() != 0) {
                String str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
                ticket.addNewLine(1, str, new Object[0]);
            }
            String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
            ticket.addNewLine(1, AppLocal.getIntString("Text.seller") + " : " + order.getUser().getName() + sId, new Object[0]);
            if (order != null && order.getNumero_platform_order() != null && !order.getNumero_platform_order().isEmpty() && (order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) || order.getType() != null && this.platFormTypesOrder.contains(order.getType()))) {
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, "Commande N\u00b0 interne : " + order.getNumberOrderToPrint(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            if (order.getBipper() != 0 && !AppLocal.bloc_bipper.booleanValue()) {
                ticket.setTextSize(2, 2);
                ticket.addNewLine(1, AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            if (order.getEasel_number() != 0) {
                ticket.setTextSize(2, 2);
                ticket.addNewLine(1, "N\u00b0 chevalet " + order.getEasel_number(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
            int sizeTVA = order.isPaid() ? 3 : 0;
            int sizePrices = (TICKET_WIDTH / 2 - sizeTVA) / 2;
            String textTotal = StringUtils.center((String)"TOTAL", (int)sizePrices);
            String textPrice = StringUtils.center((String)AppLocal.getIntString("Text.price"), (int)sizePrices);
            ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), textPrice + textTotal + AppLocal.getIntString("Text.tva"));
            ticket.addLineOfDashes();
            this.sortLinesOrder(order);
            for (TicketLineInfo line : order.getLines()) {
                if (line.isNext()) continue;
                this.appendProduct(line, ticket, true, order);
            }
            ticket.blankLine(1);
            ticket.addNewLine(0, AppLocal.getIntString("Text.nb.articles") + " : " + order.getNbrArticles(), new Object[0]);
            ticket.addNewLine(3, AppLocal.getIntString("Text.tva") + "        Mt.TVA", "Base HT   Base TTC");
            double mtTva = 0.0;
            double baseHT = 0.0;
            double baseTTC = 0.0;
            for (TaxLineInfo taxe : order.getTaxes()) {
                Object name = taxe.getName();
                if (((String)name).length() == 3) {
                    name = (String)name + " ";
                }
                int nmbSpce = 11 - taxe.printSumTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(taxe.printSumHT());
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " \u00e0 " + (String)name + "   " + taxe.printAmount(), stringBuilder.toString() + taxe.printSumTTC());
                mtTva += NumericUtils.round(taxe.getAmount());
                baseHT += NumericUtils.round(taxe.getSumHT());
                baseTTC += NumericUtils.round(taxe.getSumTTC());
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(baseHT));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total      " + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(baseTTC));
            ticket.addLineOfDashes();
            ticket.setBoldText(true);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(3, "Total T.T.C. ", TaxLineInfo.printThisDoubleAsAmount(baseTTC));
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
            if (order.getDiscount() > 0.0) {
                if (order.getTypeDiscount().contains("ourcen")) {
                    ticket.addNewLine(3, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getRealTotal() / 100.0)));
                } else {
                    ticket.addNewLine(3, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
                }
            }
            double discount_global = order.getGlobalDiscount();
            System.out.println("discount_global ************************** " + discount_global);
            if (discount_global > 0.0) {
                ticket.addNewLine(3, "Total remise articles", Formats.CURRENCY.formatValue(-Math.abs(discount_global)));
            }
            Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

                @Override
                public int compare(PaymentInfo s1, PaymentInfo s2) {
                    return s1.getName().compareToIgnoreCase(s2.getName());
                }
            });
            double renduMonnaie = 0.0;
            boolean isFirst = true;
            for (PaymentInfo payment : order.getPayments()) {
                if (isFirst) {
                    ticket.addNewLine(1, AppLocal.getIntString("Text.mode.payment"), new Object[0]);
                    isFirst = false;
                }
                ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                renduMonnaie += payment.getPaid() - payment.getTotal();
                if (!payment.getName().equalsIgnoreCase("cashlogy")) continue;
                ticket.addNewLine(3, " * Montant Entr\u00e9 :", this.printTotal(AppLocal.TOTAL_PAID_CASHLOGY));
                ticket.addNewLine(3, " * Montant encaiss\u00e9 :", this.printTotal(AppLocal.TOTAL_PAID_CASHLOGY - AppLocal.TOTAL_RENDU_CASHLOGY));
                ticket.addNewLine(3, " * Montant rendu :", this.printTotal(AppLocal.TOTAL_RENDU_CASHLOGY));
            }
            renduMonnaie = NumericUtils.round(renduMonnaie);
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, AppLocal.getIntString("Text.currency.return") + ": " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getPaid() - payment.getTotal() > 0.0)) continue;
                    ticket.addNewLine(3, AppLocal.getIntString("Text.rendering") + " " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getPaid() - payment.getTotal()));
                }
            }
            ticket.blankLine(1);
            if (order.getComment() != null && !order.getComment().isEmpty()) {
                this.addNote(ticket, "Commentaire : " + order.getComment());
                ticket.blankLine(1);
            }
            ticket.setBoldText(true);
            this.setIdentificationLogiciel(ticket, entete.getSignature(), entete.getVersionSoft(), entete.getName_soft());
            ticket.addNewLine(1, AppLocal.getIntString("Text.type.operation") + " : " + entete.getTypeOperation(), new Object[0]);
            if (entete.IsTicketRestituted()) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.reprint") + entete.getNbPrint() + " - " + order.getNbrArticles() + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
            } else {
                ticket.addNewLine(1, AppLocal.getIntString("Text.print") + " 1 - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
            }
            if (entete.getTypeOperation().equalsIgnoreCase(AppLocal.getIntString("Text.order"))) {
                ticket.addNewLine(1, "C" + entete.getId(), new Object[0]);
            } else {
                ticket.addNewLine(1, "T" + entete.getId(), new Object[0]);
            }
            ticket.setBoldText(false);
            if (entete.getFootr() != null) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.align(1, entete.getFootr());
                ticket.setTextSize(1, 1);
                ticket.blankLine(1);
            }
            if (order.getBipper() != 0 && AppLocal.bloc_bipper.booleanValue()) {
                String str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
                this.addTextBloc(ticket, str);
            }
            ticket.setAlign(1);
            if (qrCodeImage != null) {
                ticket.blankLine(1);
                ticket.addImage(qrCodeImage);
            }
            System.out.println("++++++ holder_ticket test : " + order.getHolder());
            if (order.getHolder() != null && !order.getHolder().isEmpty()) {
                ticket.blankLine(1);
                ticket.addNewLine(0, order.getHolder(), new Object[0]);
            }
            this.printQrSites(ticket);
            ticket.blankLine(5);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
            mesBytesInteger.addAll(ticket.bytes);
            PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0" + orderNum, AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
            this.printConsole(ticket.bytes);
        }
    }

    public void printRappelTickets(int orderId, TicketInfo order, EnteteInfo entete, long impressionNumber, Decreaser decreaser) {
        this.printRappelTickets(orderId, order, entete, impressionNumber, decreaser, false, null, null, false);
    }

    public void printRappelTickets(int orderId, TicketInfo order, EnteteInfo entete, long impressionNumber, Decreaser decreaser, boolean pendingOrder, String holder_ticket, Duplicata duplicata, boolean order_uber) {
        String signature;
        double discount_global;
        Date dateOrigin;
        Date dateOrder;
        System.out.println("++++++++++++ printerCaisse : " + this.printerCaisse);
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        if (TicketUtils.getPicTicket() != null) {
            ticket.blankLine(1);
            ticket.setAlign(1);
            ticket.addImageTicket(TicketUtils.getPicTicket());
            ticket.blankLine(1);
        }
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        if (entete != null && entete.getHeader() != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getHeader());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.phone") + " : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (!order_uber) {
            this.addNumOrder(ticket, order);
            ticket.blankLine(1);
        }
        this.checkAndShowInfoCustomer(order, ticket, 0);
        String orderNum = "";
        if (!order_uber) {
            orderNum = String.valueOf(entete.getId());
            System.out.println("++++++++++++ order.getCaisse() : " + order.getCaisse());
            String postFix = " " + AppLocal.getIntString("Label.caisse") + " " + entete.getCode_caisse();
            if (impressionNumber > 0L && order.isPaid() && order.getTotal() >= 0.0) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.duplicata") + " " + AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
            } else if (order.isPaid() && order.getTotal() >= 0.0) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
            } else if (order.getTotal() > 0.0) {
                ticket.addNewLine(1, AppLocal.getIntString("Label.num.order") + orderNum + postFix, new Object[0]);
            } else if (order.getTotal() < 0.0) {
                if (impressionNumber > 0L) {
                    ticket.addNewLine(1, AppLocal.getIntString("Text.duplicata") + " " + AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
                } else {
                    ticket.addNewLine(1, AppLocal.getIntString("Text.num.ticket") + orderNum + postFix, new Object[0]);
                }
                ticket.addNewLine(1, AppLocal.getIntString("Text.cancel.ticket") + order.getOrigineCanceledTicket() + postFix, new Object[0]);
            }
        }
        Date date = duplicata != null ? duplicata.getDate_impression() : (entete != null ? entete.getTimestampGDH() : (dateOrder = order.isPaid() ? order.getDatePaid() : order.getDate()));
        Date date2 = duplicata != null ? (order.isPaid() ? order.getDatePaid() : order.getDate()) : (dateOrigin = null);
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, dateFormatterFull.format(dateOrder), new Object[0]);
        } else {
            ticket.setBoldText(true);
            ticket.addNewLine(1, dateFormatterFull.format(dateOrder) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
            ticket.setBoldText(false);
        }
        if (dateOrigin != null) {
            ticket.addNewLine(1, "Date commande " + dateFormatterFull.format(dateOrigin), new Object[0]);
        }
        if (order.getNumTable() != 0) {
            String str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
            ticket.addNewLine(1, str, new Object[0]);
        }
        String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
        ticket.addNewLine(1, AppLocal.getIntString("Text.seller") + " : " + order.getUser().getName() + sId, new Object[0]);
        if (order != null && order.getNumero_platform_order() != null && !order.getNumero_platform_order().isEmpty() && (order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) || order.getType() != null && this.platFormTypesOrder.contains(order.getType()))) {
            ticket.setTextSize(1, 1);
            ticket.addNewLine(1, "Commande N\u00b0 interne : " + order.getNumberOrderToPrint(), new Object[0]);
            ticket.setTextSize(1, 1);
        }
        if (order.getBipper() != 0 && !AppLocal.bloc_bipper.booleanValue()) {
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Label.bipper") + "\u00b0" + order.getBipper(), new Object[0]);
            ticket.setTextSize(1, 1);
        }
        if (order.getEasel_number() != 0) {
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, "N\u00b0 chevalet " + order.getEasel_number(), new Object[0]);
            ticket.setTextSize(1, 1);
        }
        if (order.getStore_uber_eat() != null && !order.getStore_uber_eat().isEmpty()) {
            ticket.addNewLine(1, AppLocal.getIntString("Text.restaurant") + " : " + order.getStore_uber_eat(), new Object[0]);
        }
        ticket.setBoldText(false);
        if (order.getStatus() != null && order.getStatus().equalsIgnoreCase("cancel")) {
            ticket.addNewLine(1, "----" + AppLocal.getIntString("Text.canceled").toUpperCase() + "----", new Object[0]);
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        int sizeTVA = order.isPaid() ? 3 : 0;
        int sizePrices = (TICKET_WIDTH / 2 - sizeTVA) / 2;
        String textTotal = StringUtils.leftPad((String)"TOTAL", (int)sizePrices);
        String textPrice = StringUtils.leftPad((String)AppLocal.getIntString("Text.price"), (int)sizePrices);
        if (order.isPaid()) {
            ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), textPrice + textTotal + AppLocal.getIntString("Text.tva"));
        } else {
            ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), textPrice + textTotal);
        }
        ticket.addLineOfDashes();
        this.sortLinesOrder(order);
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProduct(line, ticket, order.isPaid(), order);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, AppLocal.getIntString("Text.nb.articles") + " : " + order.getNbrArticles(), new Object[0]);
        if (order.isPaid()) {
            ticket.addNewLine(3, AppLocal.getIntString("Text.tva") + "        Mt.TVA", "Base HT   Base TTC");
            double mtTva = 0.0;
            double baseHT = 0.0;
            double baseTTC = 0.0;
            for (TaxLineInfo taxe : order.getTaxes()) {
                Object name = taxe.getName();
                if (((String)name).length() == 3) {
                    name = (String)name + " ";
                }
                int nmbSpce = 11 - taxe.printSumTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append((String)(order.getTotal() > 0.0 ? taxe.printSumHT() : "-" + taxe.printSumHT()));
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + "   " + (String)(order.getTotal() > 0.0 ? taxe.printAmount() : "-" + taxe.printAmount()), stringBuilder.toString() + (String)(order.getTotal() > 0.0 ? taxe.printSumTTC() : "-" + taxe.printSumTTC()));
                mtTva += NumericUtils.round(taxe.getAmount());
                baseHT += NumericUtils.round(taxe.getSumHT());
                baseTTC += NumericUtils.round(taxe.getSumTTC());
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append((String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseHT) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseHT)));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total" + (order.getTotal() > 0.0 ? "      " : "     -") + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + (String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseTTC) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseTTC)));
        }
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        if (!order_uber) {
            if (!order.isPaid()) {
                ticket.addNewLine(3, AppLocal.getIntString("Text.net.to.pay") + " :", order.printTotalOrder());
            } else if (order.getTotal() >= 0.0) {
                ticket.addNewLine(3, "Total T.T.C. ", order.printTotalOrder());
            } else {
                ticket.addNewLine(3, "Total T.T.C. ", order.printTotalOrder());
            }
        } else {
            double total = order.getTotal();
            ticket.addNewLine(3, AppLocal.getIntString("Text.total.order") + " :", Formats.CURRENCY_PRINTED.formatValue(total));
            ticket.addNewLine(3, AppLocal.getIntString("Text.tva.ubereat") + " :", Formats.CURRENCY_PRINTED.formatValue(order.getTax_ubereat()));
            ticket.addNewLine(3, AppLocal.getIntString("Text.service.ubereat") + " :", Formats.CURRENCY_PRINTED.formatValue(order.getTotal_fee_ubereat()));
            ticket.addNewLine(3, AppLocal.getIntString("Text.net.to.pay") + " :", Formats.CURRENCY_PRINTED.formatValue(total + order.getTax_ubereat() + order.getTotal_fee_ubereat()));
        }
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().equalsIgnoreCase("pourcentage")) {
                ticket.addNewLine(3, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getRealTotal() / 100.0)));
            } else {
                ticket.addNewLine(3, AppLocal.getIntString("Button.discount") + " ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
        }
        if ((discount_global = order.getGlobalDiscount()) > 0.0) {
            ticket.addNewLine(3, "Total remise articles", Formats.CURRENCY.formatValue(-Math.abs(discount_global)));
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        if (order.isPaid()) {
            boolean isFirst = true;
            boolean isNegative = false;
            if (order.getTotalOrder() < 0.0) {
                ticket.addNewLine(1, "----" + AppLocal.getIntString("Text.refund") + "----", new Object[0]);
                isNegative = true;
            } else if (order.getTotalOrder() >= 0.0) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.mode.payment"), new Object[0]);
            }
            for (PaymentInfo payment : order.getPayments()) {
                if (!isNegative) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
                renduMonnaie += payment.getTendered() - payment.getTotal();
            }
            if (isNegative) {
                for (PaymentInfo payment : order.getPayments()) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
            }
            renduMonnaie = NumericUtils.round(renduMonnaie);
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0 && order.getTotalOrder() > 0.0) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, AppLocal.getIntString("Text.currency.return") + ": " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    ticket.addNewLine(3, AppLocal.getIntString("Text.rendering") + " " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
        }
        ticket.blankLine(1);
        if (order.getReason_cancel() != null && !order.getReason_cancel().isEmpty() && (order.getStatus().equalsIgnoreCase("cancel") || order.getStatus().equalsIgnoreCase("Refund"))) {
            ticket.addNewLine(1, "----" + AppLocal.getIntString("Text.canceled").toUpperCase() + "----", new Object[0]);
            ticket.addNewLine(2, order.getReason_cancel(), new Object[0]);
            ticket.blankLine(1);
        }
        if (order.getComment() != null && !order.getComment().isEmpty()) {
            this.addNote(ticket, "Commentaire : " + order.getComment());
            ticket.blankLine(1);
        }
        ticket.setBoldText(true);
        if (!order.isPaid()) {
            ticket.addNewLine(1, AppLocal.getIntString("Text.provisional.document"), new Object[0]);
            ticket.addNewLine(1, AppLocal.getIntString("Text.no.valid.cashing"), new Object[0]);
        }
        String string = signature = duplicata != null ? duplicata.getSignature() : entete.getSignature();
        if (signature != null && !signature.isEmpty()) {
            this.setIdentificationLogiciel(ticket, signature, entete.getVersionSoft(), entete.getName_soft());
        }
        ticket.addNewLine(1, AppLocal.getIntString("Text.type.operation") + " : " + entete.getTypeOperation().toUpperCase(), new Object[0]);
        if (entete.IsTicketRestituted()) {
            ticket.addNewLine(1, AppLocal.getIntString("Text.reprint") + impressionNumber + " - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        } else if (order.isPaid()) {
            ticket.addNewLine(1, AppLocal.getIntString("Text.print") + "1  - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        }
        if (!order.isPaid()) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.note") + " N\u00b0" + entete.getId(), new Object[0]);
        } else {
            ticket.addNewLine(1, "T" + entete.getId(), new Object[0]);
        }
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        if (order.getBipper() != 0 && AppLocal.bloc_bipper.booleanValue()) {
            ticket.blankLine(1);
            String str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
            this.addTextBloc(ticket, str);
        }
        if (order.getHolder() != null && !order.getHolder().isEmpty()) {
            ticket.blankLine(1);
            ticket.addNewLine(0, order.getHolder(), new Object[0]);
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Ticket n\u00b0" + orderNum, AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    /*
     * Could not resolve type clashes
     */
    public void printEcranSuiviTickets(TicketInfo order, String type, List<TicketLineInfo> products, Decreaser decreaser) {
        String str;
        PrinterInfo printer = AppLocal.printerEcranSuivi;
        int j = 1;
        TICKET_WIDTH = printer.getWith();
        AVAILABLE_WIDTH = printer.getWith();
        Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
        ticket.setTextSize(1, 2);
        ticket.addNewLine(3, String.format("Ticket %d/%d", j, 1), type);
        ticket.setTextSize(2, 2);
        ticket.addNewLine("Commande " + order.getNumero_order(), new Object[0]);
        if (order.getTable() != null) {
            str = "Table N\u00b0 " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        if (order.getBipper() != 0) {
            str = "Bipper N\u00b0 " + order.getBipper();
            ticket.addNewLine(1, str, new Object[0]);
        }
        ticket.blankLine(4);
        int index = 0;
        for (TicketLineInfo product : products) {
            if (!product.isNext()) {
                String str2;
                String strBip;
                if (product.isMenu()) {
                    Object supplement2;
                    int numSpace;
                    ticket.setTextSize(1, 2);
                    if (index > 1 && products.get(index - 1).isNext()) {
                        if (products.get(index - 1).getNextRetourn().contains("Emporter")) {
                            if (order.getBipper() != 0) {
                                strBip = " Bipper N\u00b0 " + order.getBipper() + " ";
                                ticket.setReversedText(true);
                                ticket.append(strBip);
                                ticket.setReversedText(false);
                                type = " " + (String)type + " ";
                                if (strBip.length() + ((String)type).length() < TICKET_WIDTH) {
                                    numSpace = TICKET_WIDTH - (strBip.length() + ((String)type).length()) - 1;
                                    for (int h = 0; h < numSpace; ++h) {
                                        ticket.append(" ");
                                    }
                                }
                                ticket.setReversedText(true);
                                ticket.append((String)type);
                                ticket.setReversedText(false);
                            }
                            ticket.blankLine(1);
                            ticket.setTextSize(1, 2);
                            ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
                            ticket.blankLine(5);
                            if (AppLocal.AUTO_CUTTER_TICKET) {
                                ticket.cut();
                            } else {
                                ticket.halfCut();
                            }
                            ticket.setTextSize(2, 2);
                            ticket.addNewLine(1, "Commande " + order.getNumero_order(), new Object[0]);
                            ticket.blankLine(2);
                            ticket.setTextSize(1, 2);
                            ticket.addNewLine(1, products.get(index - 1).getNextRetourn(), new Object[0]);
                            ticket.blankLine(2);
                        } else {
                            ticket.addNewLine(products.get(index - 1).getNextRetourn(), new Object[0]);
                            ticket.blankLine(2);
                        }
                    }
                    ticket.setReversedText(true);
                    str2 = product.getMultiply() == 1.0 ? (product.getSizeProduct() != null ? PrinterHelper.formatMax(" " + product.printName() + " - " + product.getSizeProduct()) : PrinterHelper.formatMax(" " + product.printName())) : (product.getSizeProduct() != null ? PrinterHelper.formatMax(" " + product.printMultiply() + "* " + product.printName() + " - " + product.getSizeProduct()) : PrinterHelper.formatMax(" " + product.printMultiply() + "* " + product.printName()));
                    ticket.align(0, str2);
                    if (str2.length() < TICKET_WIDTH) {
                        numSpace = TICKET_WIDTH - str2.length();
                        for (int i = 0; i < numSpace; ++i) {
                            ticket.append(" ");
                        }
                    }
                    ticket.blankLine(1);
                    ticket.setReversedText(false);
                    this.loadIngredient(product, ticket);
                    for (ItemOrderInfo ingredient : product.getListIngredients()) {
                        if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
                        String str1 = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
                        ticket.addNewLine(1, str1, new Object[0]);
                    }
                    for (Object supplement2 : product.getListSupplements()) {
                        if (((OptionItemOrder)supplement2).getIdProduct() != -1 && ((OptionItemOrder)supplement2).getIdProduct() != 0) continue;
                        String str1 = ((OptionItemOrder)supplement2).getNumberOption() > 1 ? PrinterHelper.formatMax("  + " + ((OptionItemOrder)supplement2).getNumberOption() + " " + ((OptionItemOrder)supplement2).getNameSupplement()) : PrinterHelper.formatMax("  + " + ((OptionItemOrder)supplement2).getNameSupplement());
                        if (((OptionItemOrder)supplement2).getIsBold().booleanValue()) {
                            ticket.setBoldText(true);
                            ticket.addNewLine(str1.toUpperCase(), new Object[0]);
                            ticket.setBoldText(false);
                            ticket.blankLine(1);
                            continue;
                        }
                        ticket.addNewLine(str1, new Object[0]);
                    }
                    supplement2 = product.getListProducts().iterator();
                    while (supplement2.hasNext()) {
                        ProductTicket productMenu = (ProductTicket)supplement2.next();
                        String full_name_item = productMenu.getNumberProduct() > 1 ? productMenu.getNumberProduct() + " " + productMenu.getNameProduct() : productMenu.getNameProduct();
                        String str22 = PrinterHelper.formatMax("  " + full_name_item);
                        ticket.align(0, str22);
                        if (str22.length() < TICKET_WIDTH) {
                            int numSpace2 = TICKET_WIDTH - str22.length();
                            for (int i = 0; i < numSpace2; ++i) {
                                ticket.append(" ");
                            }
                        }
                        ticket.blankLine(1);
                        for (ItemOrderInfo ingredient : product.getListIngredients()) {
                            if (ingredient.getIdProduct() != productMenu.getIdProduct()) continue;
                            str22 = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
                            ticket.addNewLine(1, str22, new Object[0]);
                        }
                        for (OptionItemOrder ingredient : product.getListSupplements()) {
                            if (ingredient.getIdProduct() != productMenu.getIdProduct()) continue;
                            str22 = ingredient.getNumberOption() > 1 ? PrinterHelper.formatMax("     +" + ingredient.getNumberOption() + " " + ingredient.getNameSupplement()) : PrinterHelper.formatMax("     +" + ingredient.getNameSupplement());
                            if (ingredient.getIsBold().booleanValue()) {
                                ticket.setBoldText(true);
                                ticket.addNewLine(str22.toUpperCase(), new Object[0]);
                                ticket.setBoldText(false);
                                ticket.blankLine(1);
                                continue;
                            }
                            ticket.addNewLine(str22, new Object[0]);
                        }
                    }
                    if (index < products.size() - 1 && products.get(index + 1).isNext() && !products.get(index + 1).getNextRetourn().contains("Emporter")) {
                        ticket.addNewLine(products.get(index + 1).getNextRetourn(), new Object[0]);
                        ticket.blankLine(2);
                    }
                } else {
                    if (index > 1 && products.get(index - 1).isNext()) {
                        if (products.get(index - 1).getNextRetourn().contains("Emporter")) {
                            if (order.getBipper() != 0) {
                                strBip = " Bipper N\u00b0 " + order.getBipper() + " ";
                                ticket.setReversedText(true);
                                ticket.append(strBip);
                                ticket.setReversedText(false);
                                type = " " + (String)type + " ";
                                if (strBip.length() + ((String)type).length() < TICKET_WIDTH) {
                                    int numSpace = TICKET_WIDTH - (strBip.length() + ((String)type).length()) - 1;
                                    for (int h = 0; h < numSpace; ++h) {
                                        ticket.append(" ");
                                    }
                                }
                                ticket.setReversedText(true);
                                ticket.append((String)type);
                                ticket.setReversedText(false);
                            }
                            ticket.blankLine(1);
                            ticket.setTextSize(1, 2);
                            ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
                            ticket.blankLine(5);
                            if (AppLocal.AUTO_CUTTER_TICKET) {
                                ticket.cut();
                            } else {
                                ticket.halfCut();
                            }
                            ticket.setTextSize(2, 2);
                            ticket.addNewLine(1, "Commande " + order.getNumero_order(), new Object[0]);
                            ticket.blankLine(2);
                            ticket.setTextSize(1, 2);
                            ticket.addNewLine(1, products.get(index - 1).getNextRetourn(), new Object[0]);
                            ticket.blankLine(2);
                        } else {
                            ticket.addNewLine(products.get(index - 1).getNextRetourn(), new Object[0]);
                            ticket.blankLine(2);
                        }
                    }
                    ticket.setTextSize(1, 2);
                    ticket.setReversedText(true);
                    str2 = product.getMultiply() == 1.0 ? (product.getSizeProduct() != null ? PrinterHelper.formatMax(" " + product.printName() + " - " + product.getSizeProduct()) : PrinterHelper.formatMax(" " + product.printName())) : (product.getSizeProduct() != null ? PrinterHelper.formatMax(" " + product.printMultiply() + "* " + product.printName() + " - " + product.getSizeProduct()) : PrinterHelper.formatMax(" " + product.printMultiply() + "* " + product.printName()));
                    ticket.align(0, str2);
                    if (str2.length() < TICKET_WIDTH) {
                        int numSpace = TICKET_WIDTH - str2.length();
                        for (int i = 0; i < numSpace; ++i) {
                            ticket.append(" ");
                        }
                    }
                    ticket.blankLine(1);
                    ticket.setReversedText(false);
                    for (ItemOrderInfo ingredient : product.getListIngredients()) {
                        str2 = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
                        ticket.addNewLine(1, str2, new Object[0]);
                    }
                    for (OptionItemOrder supplement : product.getListSupplements()) {
                        str2 = supplement.getNumberOption() > 1 ? PrinterHelper.formatMax("  + " + supplement.getNumberOption() + " " + supplement.getNameSupplement()) : PrinterHelper.formatMax("  + " + supplement.getNameSupplement());
                        if (supplement.getIsBold().booleanValue()) {
                            ticket.setBoldText(true);
                            ticket.addNewLine(str2.toUpperCase(), new Object[0]);
                            ticket.setBoldText(false);
                            ticket.blankLine(1);
                            continue;
                        }
                        ticket.addNewLine(str2, new Object[0]);
                    }
                    if (product.getNote() != null) {
                        String[] tabNote = product.getNote().split(" ");
                        Object stringNote = "";
                        boolean checkBloc = false;
                        for (int i = 0; i < tabNote.length; ++i) {
                            String check = (String)stringNote + " " + tabNote[i];
                            if (check.length() <= TICKET_WIDTH) {
                                stringNote = (String)stringNote + " " + tabNote[i];
                                checkBloc = false;
                                continue;
                            }
                            str2 = PrinterHelper.formatMax((String)stringNote);
                            ticket.align(0, str2);
                            if (str2.length() < TICKET_WIDTH) {
                                int numSpace = TICKET_WIDTH - str2.length();
                                for (int h = 0; h < numSpace; ++h) {
                                    ticket.append(" ");
                                }
                            }
                            ticket.blankLine(1);
                            stringNote = tabNote[i];
                            checkBloc = true;
                        }
                        if (!checkBloc) {
                            str2 = PrinterHelper.formatMax((String)stringNote);
                            ticket.align(0, str2);
                            if (str2.length() < TICKET_WIDTH) {
                                int numSpace = TICKET_WIDTH - str2.length();
                                for (int h = 0; h < numSpace; ++h) {
                                    ticket.append(" ");
                                }
                            }
                            ticket.blankLine(1);
                        }
                    }
                    if (index < products.size() - 1 && products.get(index + 1).isNext() && !products.get(index + 1).getNextRetourn().contains("Emporter")) {
                        ticket.addNewLine(products.get(index + 1).getNextRetourn(), new Object[0]);
                        ticket.blankLine(2);
                    }
                }
            }
            ++index;
        }
        ticket.blankLine(2);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(2);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        for (int h = 0; h < printer.getNumber(); ++h) {
            PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande N\u00b0" + String.valueOf(order.getNumero_order()), "L'impression du ticket dans l'Ecran Suivi a \u00e9chou\u00e9.", printer.getPort(), printer.getBand_rate(), printer, decreaser);
        }
        ++j;
    }

    public void printOrderTickets(int orderId, TicketInfo order, String deviceName, Decreaser decreaser) {
        String str;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(KITCHEN_TICKET_WIDTH, KITCHEN_TICKET_WIDTH);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "COMMANDE " + orderId, dateFormatterFull.format(order.getDate()));
        if (order.getTable() != null) {
            str = "Table N\u00b0 " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        ticket.addNewLine(AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        if (order.getUser() != null) {
            ticket.addNewLine(0, "Serveur : " + order.getUser().getName(), new Object[0]);
        }
        if (order.getBipper() != 0) {
            str = "Bipper\u00b0 " + order.getBipper();
            ticket.addNewLine(1, str, new Object[0]);
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "QT\u00c8 D\u00c8SIGNATION", " PRIX  TOTAL");
        for (TicketLineInfo line : order.getLines()) {
            String str2;
            String itemName = ticket.formatMax(line.printMultiply() + (line.getMultiply() < 10.0 ? " " : "") + " " + line.printName());
            Object prices = Formats.DOUBLE.formatValue(line.getPrice());
            String itemBasePrice = Formats.DOUBLE.formatValue(line.getValue());
            switch (itemBasePrice.length()) {
                case 4: {
                    prices = (String)prices + "  " + itemBasePrice;
                    break;
                }
                case 5: {
                    prices = (String)prices + " " + itemBasePrice;
                    break;
                }
                default: {
                    prices = (String)prices + itemBasePrice;
                }
            }
            ticket.addNewLine(3, itemName, prices);
            if (line.isMenu()) {
                for (CarteOrder carte : line.getSupplementsMenu()) {
                    str2 = PrinterHelper.formatMax("  " + carte.getName());
                    ticket.addNewLine(0, str2, new Object[0]);
                    for (ProductOrder product : carte.getListProducts()) {
                        str2 = PrinterHelper.formatMax("   " + product.getName());
                        ticket.addNewLine(0, str2, new Object[0]);
                        for (String ingredient : product.getListIngredient()) {
                            str2 = PrinterHelper.formatMax("   *Sans " + ingredient);
                            ticket.addNewLine(0, str2, new Object[0]);
                        }
                        for (String option : product.getListOptions()) {
                            str2 = PrinterHelper.formatMax("   *Avec " + option);
                            ticket.addNewLine(0, str2, new Object[0]);
                        }
                    }
                }
                continue;
            }
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                str2 = PrinterHelper.formatMax("  *Sans " + ingredient.getNameSupplement());
                ticket.addNewLine(0, str2, new Object[0]);
            }
            for (OptionItemOrder supplement : line.getListSupplements()) {
                str2 = PrinterHelper.formatMax("  *Avec " + supplement.getNameSupplement());
                if (supplement.getIsBold().booleanValue()) {
                    ticket.setBoldText(true);
                    ticket.addNewLine(0, str2.toUpperCase(), new Object[0]);
                    ticket.setBoldText(false);
                    continue;
                }
                ticket.addNewLine(0, str2, new Object[0]);
            }
        }
        ticket.addLineOfDashes();
        ticket.addNewLine("Total HT: %s\n", order.printSubTotal());
        for (TaxLineInfo taxe : order.getTaxes()) {
            ticket.addNewLine("%s: %s\n", "TVA  " + taxe.getName(), taxe.printAmount());
        }
        ticket.blankLine(2);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(2, "NET A PAYER: " + order.printTotal(), new Object[0]);
        ticket.setTextSize(1, 1);
        if (AppLocal.ISRENDMONNAIE.booleanValue() && order.getRetourMonnaie() > 0.0) {
            ticket.blankLine(1);
            ticket.addNewLine(2, "Rendu monnaie: " + order.printRetourMonnaie(), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.align(1, "Merci et \u00c0 bient\u00f4t");
        ticket.blankLine(2);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande N\u00b0" + String.valueOf(orderId), AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printLivraisonTickets(int orderId, TicketInfo order, LivreurInfo livreur, String deviceName, EnteteInfo entete, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        Object space = "";
        for (int i = 0; i < (TICKET_WIDTH - 3) / 2; ++i) {
            space = (String)space + "-";
        }
        ticket.addNewLine(1, (String)space + "LIV" + (String)space, new Object[0]);
        ticket.setBoldText(true);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(0, " " + AppLocal.getIntString("Label.client") + ": " + order.getCustomer().getName().toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addNewLine(0, " " + AppLocal.getIntString("Label.address") + ":" + order.getAddressInfo().getAddress(), new Object[0]);
        if (order.getAddressInfo().getSociete() != null && !order.getAddressInfo().getSociete().isEmpty()) {
            ticket.addNewLine(0, " " + AppLocal.getIntString("Label.company") + ": " + order.getAddressInfo().getSociete(), new Object[0]);
        }
        if (order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty() && order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
            ticket.addNewLine(0, " " + AppLocal.getIntString("Text.batiment") + ":" + order.getAddressInfo().getBatiment() + ", " + AppLocal.getIntString("Text.interphone") + ":" + order.getAddressInfo().getInterphone(), new Object[0]);
        } else {
            if (order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.batiment") + ":" + order.getAddressInfo().getBatiment(), new Object[0]);
            }
            if (order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.interphone") + ":" + order.getAddressInfo().getInterphone(), new Object[0]);
            }
        }
        if (order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty() && order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
            ticket.addNewLine(0, " " + AppLocal.getIntString("Text.codeEntree") + ": " + order.getAddressInfo().getEntrycode() + ", " + AppLocal.getIntString("Text.escalier") + ":" + order.getAddressInfo().getEscalier(), new Object[0]);
        } else {
            if (order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.escalier") + ": " + order.getAddressInfo().getEscalier(), new Object[0]);
            }
            if (order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.codeEntree") + ": " + order.getAddressInfo().getEntrycode(), new Object[0]);
            }
        }
        if (order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty() && order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
            ticket.addNewLine(0, " " + AppLocal.getIntString("Text.etage") + ":" + order.getAddressInfo().getEtage() + ", " + AppLocal.getIntString("Text.appartement") + ":" + order.getAddressInfo().getAppartement(), new Object[0]);
        } else {
            if (order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.etage") + ":" + order.getAddressInfo().getEtage(), new Object[0]);
            }
            if (order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
                ticket.addNewLine(0, " " + AppLocal.getIntString("Text.appartement") + ":" + order.getAddressInfo().getAppartement(), new Object[0]);
            }
        }
        ticket.addNewLine(0, " " + AppLocal.getIntString("Text.city") + ": " + order.getAddressInfo().getCity(), new Object[0]);
        if (order.getAddressInfo().getZipcode() != null && !order.getAddressInfo().getZipcode().isEmpty()) {
            ticket.addNewLine(0, " " + AppLocal.getIntString("Text.zipCode") + ": " + order.getAddressInfo().getZipcode(), new Object[0]);
        }
        if (order.getAddressInfo().getRemarque() != null && !order.getAddressInfo().getRemarque().isEmpty()) {
            ticket.addNewLine(0, order.getAddressInfo().getRemarque(), new Object[0]);
        }
        ticket.addNewLine(0, " " + AppLocal.getIntString("Label.phone") + ": " + order.getCustomer().printPhone(), new Object[0]);
        ticket.setBoldText(true);
        ticket.setTextSize(1, 2);
        Date orderTime = order.getDelivered();
        ticket.addNewLine(1, AppLocal.getIntString("Text.planned.delivery"), new Object[0]);
        ticket.addNewLine(1, this.dateFormatterText.format(orderTime), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(0, " " + AppLocal.getIntString("Text.mode.payment") + ": " + order.getModePayment(), new Object[0]);
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(1, 2);
        String orderNum = order.getNumberOrder(true, false);
        ticket.addNewLine(1, AppLocal.getIntString("Label.num.order") + orderNum, new Object[0]);
        ticket.addNewLine(1, "Le " + this.dateFormatterText.format(order.getDate()), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), AppLocal.getIntString("Text.price") + "  TOTAL");
        ticket.addLineOfDashes();
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProduct(line, ticket, false, order);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, AppLocal.getIntString("Text.nb.articles") + " : " + order.getNbrArticles(), new Object[0]);
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, AppLocal.getIntString("Text.net.to.pay") + ": ", order.printTotal());
        ticket.blankLine(1);
        ticket.setTextSize(1, 1);
        ticket.addLineOfDashes();
        ticket.addNewLine(1, AppLocal.getIntString("Text.provisional.document"), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.no.valid.cashing"), new Object[0]);
        if (entete.getSignature() != null && !entete.getSignature().isEmpty()) {
            this.setIdentificationLogiciel(ticket, entete.getSignature(), entete.getVersionSoft(), entete.getName_soft());
        }
        ticket.addNewLine(1, AppLocal.getIntString("Text.type.operation") + " : COMMANDE", new Object[0]);
        ticket.addNewLine(1, this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        ticket.addNewLine(1, "C" + entete.getNumDoc(), new Object[0]);
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getFootr());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0" + orderNum, AppLocal.getIntString("Message.error.print.ticket.delivery"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printZDay(PaymentsModel payment, String deviceName, Boolean detail, Boolean all, UserInfo userOrder, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = KITCHEN_TICKET_WIDTH;
        AVAILABLE_WIDTH = 100;
        boolean printer = true;
        StringBuilder builder = new StringBuilder(4096);
        Ticket2 ticket = new Ticket2(KITCHEN_TICKET_WIDTH, KITCHEN_TICKET_WIDTH);
        ticket.align(1, "Rapport du jour");
        ticket.blankLine(1);
        ticket.align(1, "Le " + this.dateFormatter.format(new Date()));
        ticket.blankLine(1);
        if (detail.booleanValue()) {
            String itemName;
            ticket.align(1, "Produits");
            ticket.blankLine(1);
            ticket.addNewLine(3, "QT\u00c9 D\u00c9SIGNATION", "PRIX   TOTAL");
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            for (PaymentsModel.ProductSalesLine product : payment.getProductSalesLines()) {
                itemName = ticket.formatMax(product.printProductUnits() + (product.getProductUnits() < 10.0 ? " " : "") + " " + product.printProductName());
                String itemBasePrice = Formats.DOUBLE.formatValue(product.getProductPriceTotal());
                Object prices = Formats.DOUBLE.formatValue(product.getProductPrice());
                switch (itemBasePrice.length()) {
                    case 4: {
                        prices = (String)prices + "  " + itemBasePrice;
                        break;
                    }
                    case 5: {
                        prices = (String)prices + " " + itemBasePrice;
                        break;
                    }
                    default: {
                        prices = (String)prices + itemBasePrice;
                    }
                }
                ticket.addNewLine(3, itemName, prices);
            }
            ticket.addLineOfDashes();
            ticket.addNewLine(3, "Total ", payment.printProductTotalPrice());
            ticket.addLineOfDashes();
            ticket.align(1, "Categories des produits");
            ticket.blankLine(1);
            ticket.addNewLine(3, "QT\u00c9 D\u00c9SIGNATION", "TOTAL");
            ticket.addLineOfDashes();
            for (PaymentsModel.CategorySalesLine category : payment.getCategorySalesLines()) {
                itemName = ticket.formatMax(category.printCategoryUnits() + (category.getCategoryUnits() < 10.0 ? " " : "") + " " + category.printCategoryName());
                String prices = Formats.DOUBLE.formatValue(category.getCategorySum());
                ticket.addNewLine(3, itemName, prices);
            }
            ticket.addLineOfDashes();
            ticket.addNewLine(3, "Total ", payment.printCategorySalesTotal());
            ticket.addLineOfDashes();
            ticket.blankLine(1);
        }
        ticket.align(1, "TVA");
        ticket.blankLine(1);
        ticket.addNewLine(3, "Nom", "TOTAL");
        ticket.addLineOfDashes();
        for (TaxLineInfo saleLine : payment.getSaleLines()) {
            ticket.addNewLine(3, saleLine.getName(), Formats.DOUBLE.formatValue(saleLine.getAmount()));
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Total", payment.printTaxTotal());
        ticket.align(1, "Paiements");
        ticket.blankLine(1);
        ticket.addNewLine(3, "Type", "TOTAL");
        ticket.addLineOfDashes();
        for (PaymentsModel.PaymentsLine paymentLine : payment.getPaymentLines()) {
            ticket.addNewLine(3, com.openbravo.pos.util.StringUtils.encodeXML(paymentLine.printType()), paymentLine.printValue());
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Total", payment.printPaymentsTotal());
        ticket.addLineOfDashes();
        ticket.blankLine(2);
        if (all.booleanValue()) {
            ticket.align(1, com.openbravo.pos.util.StringUtils.encodeXML("CA par employ\u00e9"));
            ticket.blankLine(1);
            ticket.addNewLine(3, "Utilisateur", "TOTAL");
            ticket.addLineOfDashes();
            for (UserCaisseInfo user : payment.getM_users()) {
                ticket.addNewLine(3, user.getName(), user.printTotal());
            }
            ticket.addLineOfDashes();
            ticket.blankLine(2);
        }
        ticket.addNewLine(3, "Total", payment.printPaymentsTotal());
        ticket.addLineOfDashes();
        ticket.blankLine(2);
        ticket.align(1, com.openbravo.pos.util.StringUtils.encodeXML("R\u00e9sum\u00e9"));
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        if (!all.booleanValue()) {
            ticket.addNewLine(3, "Employ\u00e9", userOrder.getName());
        }
        ticket.addNewLine(3, "Commandes", payment.printSales());
        ticket.addNewLine(3, "Payments", payment.printPayments());
        ticket.addNewLine(3, "Total HT", payment.printSalesBase());
        ticket.addNewLine(3, "TVA", payment.printTaxTotal());
        ticket.addNewLine(3, "Total NET", payment.printSalesTotal());
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0", "L'impression du ticket Z Jours a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printZMonth(PaymentsModel payment, String date, String deviceName, Boolean detail, Boolean all, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = KITCHEN_TICKET_WIDTH;
        AVAILABLE_WIDTH = 100;
        boolean printer = true;
        StringBuilder builder = new StringBuilder(4096);
        Ticket2 ticket = new Ticket2(KITCHEN_TICKET_WIDTH, KITCHEN_TICKET_WIDTH);
        String printerIP = "192.168.1.120";
        ticket.align(1, "Rapport du MOIS");
        ticket.blankLine(1);
        ticket.align(1, "Mois du " + date);
        ticket.blankLine(1);
        if (detail.booleanValue()) {
            String itemName;
            ticket.align(1, "Produits");
            ticket.blankLine(1);
            ticket.addNewLine(3, "QT\u00c9 D\u00c9SIGNATION", "PRIX   TOTAL");
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            for (PaymentsModel.ProductSalesLine product : payment.getProductSalesLines()) {
                itemName = ticket.formatMax(product.printProductUnits() + (product.getProductUnits() < 10.0 ? " " : "") + " " + product.printProductName());
                String itemBasePrice = Formats.DOUBLE.formatValue(product.getProductPriceTotal());
                Object prices = Formats.DOUBLE.formatValue(product.getProductPrice());
                switch (itemBasePrice.length()) {
                    case 4: {
                        prices = (String)prices + "  " + itemBasePrice;
                        break;
                    }
                    case 5: {
                        prices = (String)prices + " " + itemBasePrice;
                        break;
                    }
                    default: {
                        prices = (String)prices + itemBasePrice;
                    }
                }
                ticket.addNewLine(3, itemName, prices);
            }
            ticket.addLineOfDashes();
            ticket.addNewLine(3, "Total ", payment.printProductTotalPrice());
            ticket.addLineOfDashes();
            ticket.align(1, "Categories des produits");
            ticket.blankLine(1);
            ticket.addNewLine(3, "QT\u00c9 D\u00c9SIGNATION", "TOTAL");
            ticket.addLineOfDashes();
            for (PaymentsModel.CategorySalesLine category : payment.getCategorySalesLines()) {
                itemName = ticket.formatMax(category.printCategoryUnits() + (category.getCategoryUnits() < 10.0 ? " " : "") + " " + category.printCategoryName());
                String prices = Formats.DOUBLE.formatValue(category.getCategorySum());
                ticket.addNewLine(3, itemName, prices);
            }
            ticket.addLineOfDashes();
            ticket.addNewLine(3, "Total ", payment.printCategorySalesTotal());
            ticket.addLineOfDashes();
            ticket.blankLine(1);
        }
        ticket.align(1, "TVA");
        ticket.blankLine(1);
        ticket.addNewLine(3, "Nom", "TOTAL");
        ticket.addLineOfDashes();
        for (TaxLineInfo saleLine : payment.getSaleLines()) {
            ticket.addNewLine(3, saleLine.getName(), Formats.DOUBLE.formatValue(saleLine.getAmount()));
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Total", payment.printTaxTotal());
        ticket.align(1, "Paiements");
        ticket.blankLine(1);
        ticket.addNewLine(3, "Type", "TOTAL");
        ticket.addLineOfDashes();
        for (PaymentsModel.PaymentsLine paymentLine : payment.getPaymentLines()) {
            ticket.addNewLine(3, paymentLine.printType(), paymentLine.printValue());
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Total", payment.printPaymentsTotal());
        ticket.addLineOfDashes();
        ticket.blankLine(2);
        if (all.booleanValue()) {
            ticket.align(1, com.openbravo.pos.util.StringUtils.encodeXML("CA par employ\u00e9"));
            ticket.blankLine(1);
            ticket.addNewLine(3, "Utilisateur", "TOTAL");
            ticket.addLineOfDashes();
            for (UserCaisseInfo user : payment.getM_users()) {
                ticket.addNewLine(3, user.getName(), user.printTotal());
            }
            ticket.addLineOfDashes();
            ticket.blankLine(2);
        }
        ticket.align(1, "R\u00e9sum\u00e9");
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Commandes", payment.printSales());
        ticket.addNewLine(3, "Payments", payment.printPayments());
        ticket.addNewLine(3, "Total HT", payment.printSalesBase());
        ticket.addNewLine(3, "TVA", payment.printTaxTotal());
        ticket.addNewLine(3, "Total NET", payment.printSalesTotal());
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0", "L'impression du ticket Z mois a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printSummary(PaymentsModel payment, CaisseInfo caisse, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        StringBuilder builder = new StringBuilder(4096);
        PrinterHelper.appendLine(builder, "%s", "Fermeture de la caisse");
        PrinterHelper.appendLine(builder, "%s", "Num\u00e9ro de ticket: " + payment.printSales());
        PrinterHelper.appendLine(builder, "\n%s\n", LINE_OF_DASHES);
        PrinterHelper.appendLine(builder, "%s", "Ouverte par " + caisse.getUser_open().getName());
        PrinterHelper.appendLine(builder, "%s\n", "le " + dateFormatterFull.format(caisse.getDateOpen()));
        PrinterHelper.appendLine(builder, "%s", "Ferm\u00e9e par " + caisse.getUser_close().getName());
        PrinterHelper.appendLine(builder, "%s\n", "le " + dateFormatterFull.format(caisse.getDateClose()));
        PrinterHelper.appendLine(builder, "%s\n", "CA total: " + payment.printPaymentsTotal());
        PrinterHelper.appendLine(builder, "%s", "TVA \u00e0 reverser: " + payment.printTaxTotal());
        for (TaxLineInfo saleLine : payment.getSaleLines()) {
            PrinterHelper.appendLine(builder, "TVA %s", saleLine.getName() + " : " + saleLine.printAmount());
        }
        PrinterHelper.appendLine(builder, "\n%s\n", "CA par mode de paiement");
        for (PaymentsModel.PaymentsLine paymentLine : payment.getPaymentLines()) {
            PrinterHelper.appendLine(builder, "%s", paymentLine.printType() + " : " + paymentLine.printValue());
        }
        PrinterHelper.appendLine(builder, "\n%s\n", "CA par emoloy\u00e9");
        for (UserCaisseInfo user : payment.getM_users()) {
            PrinterHelper.appendLine(builder, "%s", user.getName() + " : " + user.printTotal());
        }
        builder.append('\n');
        PrinterHelper.appendLine(builder, "\n%s\n", "Fond de caisse:" + Formats.DOUBLE.formatValue(caisse.getFondCaisse()));
        PrinterCommand body = new PrinterCommand.Builder(builder.toString()).align(1).cut().build();
        Ticket ticket = new Ticket.Builder().add(body).build();
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printCloseCaisse(int nbOrder, double caNet, double caCanceld, double tvas, List<PaymentLine> payments, List<TaxeLine> taxes, List<UserCaisseInfo> users, CaisseInfo caisse, MarqueNFC marqueNF, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.addNewLine(0, "Fermeture de la caisse", new Object[0]);
        ticket.addLineOfDashes();
        ticket.addNewLine(0, "Ouverte par " + caisse.getUser_open().getName(), new Object[0]);
        ticket.addNewLine(1, "le " + dateFormatterFull.format(caisse.getDateOpen()), new Object[0]);
        ticket.addNewLine(0, "Ferm\u00e9e par " + caisse.getUser_close().getName(), new Object[0]);
        ticket.addNewLine(1, "le " + dateFormatterFull.format(caisse.getDateClose()), new Object[0]);
        ticket.addNewLine(1, "CA par mode de paiement", new Object[0]);
        for (PaymentLine paymentLine : payments) {
            ticket.addNewLine(0, paymentLine.getM_PaymentType() + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.addNewLine(1, "CA total: " + Formats.CURRENCY_PRINTED.formatValue(caNet), new Object[0]);
        ticket.addNewLine(0, "Fond de caisse \u00e0 la  fermeture :" + Formats.DOUBLE.formatValue(caisse.getFondClose()), new Object[0]);
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printSynthesCaisse(String chiffePerUnit, List<TurnoverInfo> salesByUnit, List<RankCategory> categories, List<RankProductDiver> itemsDivers, double caNet, double caCanceld, double tvas, List<PaymentLine> payments, List<TaxeLine> taxes, List<UserCaisseInfo> users, CaisseInfo caisse, MarqueNFC marqueNF, Date dateStart, Date dateEnd, Double discountOrders, Double discountOnLines, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.summary.journal"), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addNewLine(1, AppLocal.getIntString("Text.period") + "  " + dateFormatterFull.format(dateStart), new Object[0]);
        ticket.addNewLine(1, " \u00e0 " + dateFormatterFull.format(dateEnd), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover.by.payment"), new Object[0]);
        ticket.setReversedText(false);
        for (PaymentLine paymentLine : payments) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                ticket.addNewLine(0, this.getOfficialPayement(paymentLine.getM_PaymentType()) + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                ticket.addNewLine(0, "Avoir Encaiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            ticket.addNewLine(0, "Avoir D\u00e9caiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover.by.category"), new Object[0]);
        ticket.setReversedText(false);
        for (RankCategory categorie : categories) {
            ticket.setBoldText(true);
            ticket.addNewLine(1, categorie.getName() + " : " + categorie.getTurnover(), new Object[0]);
            ticket.setBoldText(false);
            for (RankProduct rankProduct : categorie.getRankProducts()) {
                ticket.addNewLine(3, rankProduct.getQuantity() + " * " + rankProduct.getName(), rankProduct.getTurnover());
            }
        }
        if (itemsDivers.size() != 0) {
            double divers_turnover = 0.0;
            for (RankProductDiver rankProductDiver : itemsDivers) {
                divers_turnover += rankProductDiver.getTurnover();
            }
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Text.various.products") + " : " + this.printPrice(divers_turnover), new Object[0]);
            ticket.setBoldText(false);
            for (RankProductDiver rankProductDiver : itemsDivers) {
                ticket.addNewLine(3, this.printMultiply(rankProductDiver.getQuantity()) + " * " + rankProductDiver.getName(), this.printPrice(rankProductDiver.getTurnover()));
            }
        }
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover.by.users"), new Object[0]);
        ticket.setReversedText(false);
        for (UserCaisseInfo user : users) {
            ticket.addNewLine(0, user.getName() + " : " + user.printTotal(), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover.by") + " " + (chiffePerUnit.equals("h") ? AppLocal.getIntString("Text.hour") : (chiffePerUnit.equals("j") ? AppLocal.getIntString("Text.hour") : AppLocal.getIntString("Text.month"))) + "  ", new Object[0]);
        ticket.setReversedText(false);
        for (TurnoverInfo entry : salesByUnit) {
            Integer key = entry.getIndex();
            Double value = entry.getturnover();
            String numberUnit = chiffePerUnit.equals("h") ? key + "h" : (chiffePerUnit.equals("j") ? "Le " + key + " " + DateUtils.getNameOfMonth(dateStart.getMonth() + 1) : DateUtils.getNameOfMonth(key));
            ticket.addNewLine(0, numberUnit + " : " + Formats.CURRENCY_PRINTED.formatValue(value), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.tva"), new Object[0]);
        ticket.setReversedText(false);
        ticket.addNewLine(0, AppLocal.getIntString("Text.tva.paid.back") + ": " + Formats.CURRENCY_PRINTED.formatValue(tvas), new Object[0]);
        for (TaxeLine taxe : taxes) {
            String name_taxe = taxe.getName() != null && !taxe.getName().isEmpty() ? taxe.getName() : "";
            ticket.addNewLine(0, AppLocal.getIntString("Text.tva") + " " + name_taxe + " : " + Formats.CURRENCY_PRINTED.formatValue(taxe.getTax()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion"), new Object[0]);
        ticket.setReversedText(false);
        ticket.addNewLine(0, AppLocal.getIntString("Text.promotion.orders") + ": " + Formats.CURRENCY_PRINTED.formatValue(discountOrders), new Object[0]);
        ticket.addNewLine(0, AppLocal.getIntString("Text.promotion.items") + ": " + Formats.CURRENCY_PRINTED.formatValue(discountOnLines), new Object[0]);
        ticket.blankLine(1);
        ticket.setReversedText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.summary"), new Object[0]);
        ticket.setReversedText(false);
        ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.total") + " : " + Formats.CURRENCY_PRINTED.formatValue(caNet), new Object[0]);
        ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.canceled") + ": " + Formats.CURRENCY_PRINTED.formatValue(caCanceld), new Object[0]);
        if (caisse != null && caisse.getFondCaisse() > 0.0) {
            ticket.addNewLine(0, AppLocal.getIntString("Text.cash.fund.open") + ": " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondCaisse()), new Object[0]);
        }
        if (caisse != null && caisse.getFondClose() > 0.0 && caisse.getDateOpen().before(caisse.getDateClose())) {
            ticket.addNewLine(0, AppLocal.getIntString("Label.cash.fund.close") + ": " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondClose()), new Object[0]);
            ticket.blankLine(1);
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printOperationsCaisse(List<TicketInfo> tickets, Date dateStart, Date dateEnd, MarqueNFC marqueNF, Double cANet, Double cACanceled, int nbCancel, int nbcmd, int nbrefund, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.addNewLine(1, AppLocal.getIntString("Text.journal.operation"), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.period") + " " + dateFormatterFull.format(dateStart), new Object[0]);
        ticket.addNewLine(1, "\u00e0 " + dateFormatterFull.format(dateEnd), new Object[0]);
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.list.operation"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(3, AppLocal.getIntString("Text.horodatage") + " ", "Total T.T.C.      " + AppLocal.getIntString("Text.operation"));
        for (TicketInfo order : tickets) {
            ticket.addNewLine(3, dateFormatterFull.format(order.getDate()), order.printTotalOrder() + "  " + (String)(order.getTotalOrder() < 0.0 ? AppLocal.getIntString("Text.refund") : (order.getStatus().equals("paid") ? "        " + AppLocal.getIntString("Text.sale") : (order.getStatus().equalsIgnoreCase("cancel") ? "   " + AppLocal.getIntString("Text.cancel") : order.getStatus()))));
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.brut") + " : " + Formats.CURRENCY_PRINTED.formatValue(cANet), new Object[0]);
        if (cACanceled != 0.0) {
            ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.canceled") + " : " + Formats.CURRENCY_PRINTED.formatValue(cACanceled), new Object[0]);
            ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.repaid") + " : " + Formats.CURRENCY_PRINTED.formatValue(-cACanceled.doubleValue()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.summary"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(0, nbcmd + " " + AppLocal.getIntString("Text.sale.operation"), new Object[0]);
        ticket.addNewLine(0, nbCancel + " " + AppLocal.getIntString("Text.canceled.operation"), new Object[0]);
        ticket.addNewLine(0, nbrefund + " " + AppLocal.getIntString("Text.refund.operation"), new Object[0]);
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printPayments(List<TicketInfo> tickets, Date dateStart, Date dateEnd, MarqueNFC marqueNF, Double cANet, Double cACanceled, int nbCancel, int nbcmd, int nbrefund, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.addNewLine(1, AppLocal.getIntString("Text.journal.payment"), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.period") + " " + dateFormatterFull.format(dateStart), new Object[0]);
        ticket.addNewLine(1, "\u00c0 " + dateFormatterFull.format(dateEnd), new Object[0]);
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.list.payment"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(3, AppLocal.getIntString("Text.horodatage") + "        Total T.T.C.", AppLocal.getIntString("Label.payment"));
        for (TicketInfo order : tickets) {
            ticket.addNewLine(3, dateFormatterFull.format(order.getDate()) + "  " + order.printTotalOrder(), order.getPayments().size() > 0 ? order.getPayments().get(0).getName() + ":" + order.getPayments().get(0).printTotal() : "");
            for (int i = 1; i < order.getPayments().size(); ++i) {
                ticket.addNewLine(2, this.getOfficialPayement(order.getPayments().get(i).getName()) + ":" + order.getPayments().get(i).printTotal(), new Object[0]);
            }
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.brut") + " : " + Formats.CURRENCY_PRINTED.formatValue(cANet), new Object[0]);
        if (cACanceled != 0.0) {
            ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.canceled") + " : " + Formats.CURRENCY_PRINTED.formatValue(cACanceled), new Object[0]);
            ticket.addNewLine(0, AppLocal.getIntString("Text.turnover.repaid") + " : " + Formats.CURRENCY_PRINTED.formatValue(-cACanceled.doubleValue()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.summary"), new Object[0]);
        ticket.setBoldText(false);
        ticket.addNewLine(0, nbcmd + " " + AppLocal.getIntString("Text.sale.operation"), new Object[0]);
        ticket.addNewLine(0, nbCancel + " " + AppLocal.getIntString("Text.canceled.operation"), new Object[0]);
        ticket.addNewLine(0, nbrefund + " " + AppLocal.getIntString("Text.refund.operation"), new Object[0]);
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printPlat(TicketInfo order, List<PrinterInfo> printers, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        for (PrinterInfo printer : printers) {
            String str;
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
            ticket.setTextSize(1, 2);
            ticket.addNewLine(3, String.format("Ticket %d/%d", j, numPrinters), AppConstants.getTypeOrder(order.getType()));
            ticket.setTextSize(2, 2);
            String orderNum = this.getNumOrder(order);
            ticket.addNewLine(AppLocal.getIntString("Text.order") + " " + orderNum, new Object[0]);
            if (order.getNumTable() != 0) {
                str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
                ticket.addNewLine(1, str, new Object[0]);
            }
            if (order.getBipper() != 0) {
                str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
                ticket.addNewLine(1, str, new Object[0]);
            }
            ticket.blankLine(2);
            ticket.addNewLine(AppLocal.getIntString("Button.reclam.plat"), new Object[0]);
            ticket.blankLine(4);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
            ticket.blankLine(4);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            for (int h = 0; h < printer.getNumber(); ++h) {
                PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket.kitchen"), printer.getPort(), printer.getBand_rate(), printer, decreaser);
            }
            ++j;
        }
    }

    public void printDessert(TicketInfo order, List<PrinterInfo> printers, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        for (PrinterInfo printer : printers) {
            String str;
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
            ticket.setTextSize(1, 2);
            ticket.addNewLine(3, String.format("Ticket %d/%d", j, numPrinters), AppConstants.getTypeOrder(order.getType()));
            ticket.setTextSize(2, 2);
            String orderNum = this.getNumOrder(order);
            ticket.addNewLine(AppLocal.getIntString("Text.order") + " " + orderNum, new Object[0]);
            if (order.getNumTable() != 0) {
                str = AppLocal.getIntString("Label.num.table") + " " + order.getNumTable();
                ticket.addNewLine(1, str, new Object[0]);
            }
            if (order.getBipper() != 0) {
                str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
                ticket.addNewLine(1, str, new Object[0]);
            }
            ticket.blankLine(2);
            ticket.addNewLine(AppLocal.getIntString("Button.reclam.dessert"), new Object[0]);
            ticket.blankLine(4);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
            ticket.blankLine(4);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            for (int h = 0; h < printer.getNumber(); ++h) {
                PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket.kitchen"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
            }
            ++j;
        }
    }

    public void printOrder(TicketInfo order, List<PrinterInfo> printers, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        for (PrinterInfo printer : printers) {
            String str;
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
            ticket.setTextSize(1, 2);
            ticket.addNewLine(3, String.format("Ticket %d/%d", j, numPrinters), AppConstants.getTypeOrder(order.getType()));
            ticket.setTextSize(2, 2);
            String orderNum = order.getCaisse() != null ? order.getCaisse() + order.getNumero_order() : String.valueOf(order.getNumero_order());
            ticket.addNewLine(AppLocal.getIntString("Text.order") + " " + orderNum, new Object[0]);
            if (order.getTable() != null) {
                str = AppLocal.getIntString("Label.num.table") + " " + order.getTable().getNumber();
                ticket.addNewLine(1, str, new Object[0]);
            }
            if (order.getBipper() != 0) {
                str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
                ticket.addNewLine(1, str, new Object[0]);
            }
            ticket.blankLine(2);
            ticket.addNewLine(AppLocal.getIntString("Button.reclam.order"), new Object[0]);
            ticket.blankLine(4);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
            ticket.blankLine(4);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            for (int h = 0; h < printer.getNumber(); ++h) {
                PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket.kitchen"), printer.getPort(), printer.getBand_rate(), this.printerCaisse, decreaser);
            }
            ++j;
        }
    }

    public void printFacture(Facture facture, TicketInfo order, EnteteInfo entete, int impressionNumber, Decreaser decreaser, Duplicata mDuplicataFacture) {
        String signature;
        double discount_global;
        Date dateFacture;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeaderFacture(ticket, facture);
        if (entete != null && entete.getHeader() != null && !entete.getHeader().isEmpty()) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getHeader());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, "TEL : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        ticket.blankLine(1);
        if (impressionNumber != 0) {
            ticket.addNewLine(1, "DUPLICATA Facture N\u00b0" + facture.getId(), new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + entete.getId() + " Caisse " + entete.getCode_caisse(), new Object[0]);
        } else {
            ticket.addNewLine(1, "Facture N\u00b0" + facture.getId(), new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + entete.getId() + " Caisse " + entete.getCode_caisse(), new Object[0]);
        }
        if (facture.getType_operation() != null && facture.getType_operation().equals("ANNULATION")) {
            ticket.addNewLine(1, "Annulation de la facture N\u00b0" + facture.getCanceled_facture_id(), new Object[0]);
        }
        Date date = dateFacture = mDuplicataFacture != null ? mDuplicataFacture.getDate_impression() : facture.getDateFacture();
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(dateFacture), new Object[0]);
        } else {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(dateFacture) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        }
        ticket.addNewLine(1, "date Ticket " + this.dateFormatterFullFacture.format(order.getDatePaid()), new Object[0]);
        if (facture.getFacture_type() != null && !facture.getFacture_type().isEmpty()) {
            ticket.addNewLine(1, "Type Facture : " + facture.getFacture_type(), new Object[0]);
            ticket.blankLine(1);
        }
        if (facture.isPhysical_person()) {
            ticket.addNewLine(1, "Client : " + facture.getName_contact(), new Object[0]);
        } else {
            ticket.addNewLine(1, "Client : " + facture.getCompany(), new Object[0]);
        }
        ticket.setTextSize(1, 1);
        if (facture.getAddress() != null && !facture.getAddress().isEmpty()) {
            String[] tabString = facture.getAddress().split(" ");
            int longueur = tabString.length;
            int half = longueur / 2;
            Object line1 = "";
            for (int i = 0; i < half; ++i) {
                line1 = (String)line1 + tabString[i] + " ";
            }
            Iterator<TicketLineInfo> line2 = "";
            for (int i = half; i < longueur; ++i) {
                line2 = (String)((Object)line2) + tabString[i] + " ";
            }
            ticket.addNewLine(1, (String)line1, new Object[0]);
            if (((String)((Object)line2)).length() > 0) {
                ticket.addNewLine(1, (String)((Object)line2), new Object[0]);
            }
        }
        if (facture.getZip_code() != null && !facture.getZip_code().isEmpty() || facture.getCity() != null && !facture.getCity().isEmpty()) {
            ticket.addNewLine(1, facture.getZip_code() + " " + facture.getCity(), new Object[0]);
        }
        if (facture.getCountry() != null && !facture.getCountry().isEmpty()) {
            ticket.addNewLine(1, facture.getCountry(), new Object[0]);
        }
        if (facture.getSiret() != null && !facture.getSiret().isEmpty()) {
            ticket.addNewLine(1, "Siret : " + facture.getSiret(), new Object[0]);
        }
        if (facture.getNum_tva() != null && !facture.getNum_tva().isEmpty()) {
            ticket.addNewLine(1, "TVA INTRA : " + facture.getNum_tva(), new Object[0]);
        }
        boolean canceled = false;
        if (order.getStatus().equalsIgnoreCase("cancel") || facture.getType_operation() != null && facture.getType_operation().equalsIgnoreCase(Facture.CANCEL)) {
            canceled = true;
        }
        String prefix_sign = canceled ? "-" : "";
        ticket.addLineOfDashes();
        int width_price = (TICKET_WIDTH - 17) / 3;
        int width_designation = TICKET_WIDTH - width_price * 3;
        ticket.addNewLine(3, StringUtils.rightPad((String)"QT\u00c9 D\u00c9SIGNATION", (int)width_designation), StringUtils.center((String)"HT", (int)width_price) + StringUtils.center((String)"Total", (int)width_price) + StringUtils.center((String)"TVA", (int)width_price));
        ticket.addLineOfDashes();
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProductToFacture(line, ticket, canceled);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, "Nb. Article : " + order.getNbrArticles(), new Object[0]);
        ticket.addNewLine(3, "TVA      Mt.TVA", "Base HT   Base TTC");
        double mtTva = 0.0;
        double baseHT = 0.0;
        double baseTTC = 0.0;
        for (TaxLineInfo taxe : order.getTaxes()) {
            Object name = taxe.getName();
            if (((String)name).length() == 3) {
                name = (String)name + " ";
            }
            int nmbSpce = 11 - taxe.printSumTTC().length();
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append(taxe.printSumHT());
            for (int i = 0; i < nmbSpce; ++i) {
                stringBuilder.append(" ");
            }
            ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + " " + prefix_sign + taxe.printAmount(), prefix_sign + stringBuilder.toString() + " " + prefix_sign + taxe.printSumTTC());
            mtTva += NumericUtils.round(taxe.getAmount());
            baseHT += NumericUtils.round(taxe.getSumHT());
            baseTTC += NumericUtils.round(taxe.getSumTTC());
        }
        int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
        StringBuilder stringTotal = new StringBuilder("");
        stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(baseHT));
        for (int i = 0; i < nmbSpce; ++i) {
            stringTotal.append(" ");
        }
        ticket.addNewLine(3, "Total taxes " + prefix_sign + TaxLineInfo.printThisDoubleAsAmount(mtTva), prefix_sign + stringTotal + " " + prefix_sign + TaxLineInfo.printThisDoubleAsAmount(baseTTC));
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Montant net \u00e0 payer ", order.printTotalOrder());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().contains("pourcentage")) {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getTotal() / (100.0 - order.getDiscount()))));
            } else {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
        }
        if ((discount_global = order.getGlobalDiscount()) > 0.0) {
            ticket.addNewLine(3, "Total remise articles", Formats.CURRENCY.formatValue(-Math.abs(discount_global)));
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        boolean isFirst = true;
        boolean isNegative = false;
        if (order.getTotalOrder() < 0.0) {
            ticket.addNewLine(1, "----Remboursement----", new Object[0]);
            isNegative = true;
        } else {
            ticket.addNewLine(1, "Mode de paiement", new Object[0]);
        }
        isNegative = canceled;
        for (PaymentInfo payment : order.getPayments()) {
            if (!isNegative) {
                ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
            }
            renduMonnaie += payment.getTendered() - payment.getTotal();
        }
        if (isNegative) {
            ticket.addNewLine(3, AppConstants.PAYMENT_MODE.CASH.getName(), order.printTotalOrder());
        }
        renduMonnaie = NumericUtils.round(renduMonnaie);
        if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.addNewLine(1, "Rendu monnaie: " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
            for (PaymentInfo payment : order.getPayments()) {
                if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                ticket.addNewLine(3, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
            }
        }
        if (!facture.isPhysical_person()) {
            ticket.blankLine(1);
            ticket.addNewLine(1, "P\u00e9nalit\u00e9s de retard : trois fois le taux annuel d'int\u00e9r\u00eat l\u00e9gal en vigueur calcul\u00e9 depuis la date d'\u00e9ch\u00e9ance jusqu'\u00e0 complet paiement du prix", new Object[0]);
            ticket.blankLine(1);
            ticket.addNewLine(1, "Indemnit\u00e9 forfaitaire pour frais de recouvrement en cas de regard de paiement : 40 \u20ac", new Object[0]);
        }
        ticket.setBoldText(true);
        ticket.blankLine(1);
        String string = signature = mDuplicataFacture != null ? mDuplicataFacture.getSignature() : facture.getSignature();
        if (signature != null && !signature.isEmpty()) {
            this.setIdentificationLogiciel(ticket, signature, entete.getVersionSoft(), entete.getName_soft());
        }
        String typeOperation = facture.getType_operation() != null && facture.getType_operation().equalsIgnoreCase(Facture.CANCEL) ? facture.getType_operation() : entete.getTypeOperation();
        ticket.addNewLine(1, "Type d'op\u00e9ration: " + typeOperation.toUpperCase(), new Object[0]);
        if (impressionNumber != 0) {
            ticket.addNewLine(1, "R\u00e9impression N\u00b0" + impressionNumber + " - " + this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, "Impression N\u00b0 1 - " + this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        }
        ticket.addNewLine(1, "F" + facture.getId(), new Object[0]);
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Facture n\u00b0" + String.valueOf(facture.getId()), "L'impression de la facture a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public static void appendLine(StringBuilder builder, String format, Object ... args) {
        String a = String.format(format, args);
        builder.append(a);
        if (a.length() < TICKET_WIDTH) {
            int numSpace = TICKET_WIDTH - a.length();
            for (int i = 0; i < numSpace; ++i) {
                builder.append(' ');
            }
        }
        builder.append('\n');
    }

    public static void appendLine2(StringBuilder builder, String format, Object ... args) {
        String a = String.format(format, args);
        builder.append(a);
        if (a.length() < TICKET_WIDTH) {
            int numSpace = TICKET_WIDTH - a.length();
            for (int i = 0; i < numSpace; ++i) {
                builder.append(' ');
            }
        }
        builder.append('\n');
    }

    private static String formatAlignRight(String message) {
        int numSpace = TICKET_WIDTH - message.length();
        return String.format("%" + numSpace + "s%s", "", message);
    }

    private static String formatAlignLeftRight(String message1, String message2) {
        int numSpace = TICKET_WIDTH - message1.length() - message2.length();
        if (numSpace == 0) {
            return String.format("%s%s", message1, message2);
        }
        return String.format("%s%" + numSpace + "s%s", message1, "", message2);
    }

    public static String formatMax(String message) {
        return message.length() > AVAILABLE_WIDTH ? message.substring(0, AVAILABLE_WIDTH) : message;
    }

    public static String formatMax(String message, int MAX_WIDTH) {
        return message.length() > MAX_WIDTH ? message.substring(0, MAX_WIDTH) : message;
    }

    private static String formatCenterWithDashes(String message) {
        int numDashes = (TICKET_WIDTH - message.length() - 2) / 2;
        String halfDashes = new String(new char[numDashes]).replace("\u0000", "-");
        return String.format("%s %s %s", halfDashes, message, halfDashes);
    }

    private static String formatAlignCenter(String message) {
        int halfSpace = (TICKET_WIDTH - message.length()) / 2;
        if (halfSpace == 0) {
            return message;
        }
        return String.format("%" + halfSpace + "s%s%" + halfSpace + "s", "", message, "");
    }

    public void openCashDrawer(Decreaser decreaser) {
        PrinterCommand openDrawerCommand = new PrinterCommand.Builder().openDrawer(true).build();
        Ticket ticket = new Ticket.Builder().add(openDrawerCommand).build();
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "TIROIR CAISSE", "L'ouverture du tiroir caisse a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printAvoir1(Double avoir, Decreaser decreaser) {
        TICKET_WIDTH = this.printerCaisse.getWith();
        AVAILABLE_WIDTH = this.printerCaisse.getWith();
        StringBuilder builder = new StringBuilder();
        String avoirAmount = Formats.CURRENCY_PRINTED.formatValue(avoir);
        PrinterHelper.appendLine(builder, "\n%s%s\n", "AVOIR: ", avoirAmount);
        PrinterCommand header = new PrinterCommand.Builder(this.barTicketHeader + "\n\nLe " + dateFormatterFull.format(System.currentTimeMillis()) + "\n").align(1).image(printLogo ? -1 : 0).size(1, 2).build();
        PrinterCommand content = new PrinterCommand.Builder(builder.toString()).align(0).size(2, 2).build();
        PrinterCommand extra = new PrinterCommand.Builder("\n" + this.avoirTicketFooter + "\n\n").align(1).cut().build();
        Ticket ticket = new Ticket.Builder().add(header).add(content).add(extra).build();
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "AVOIR", "L'impression d'un avoir de " + avoirAmount.replace(",", ".") + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printAvoir(Double avoir, EnteteInfo entete, TicketAvoir ticketAvoir, BufferedImage qrCodeImage, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        ticket.addLineOfDashes();
        String avoirAmount = Formats.CURRENCY_PRINTED.formatValue(avoir);
        ticket.addImage(qrCodeImage);
        ticket.addNewLine(1, ticketAvoir.getBarCode(), new Object[0]);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, "AVOIR: " + avoirAmount, new Object[0]);
        ticket.blankLine(2);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(0, "Utilisation de l'avoir avant le " + this.dateFormatter.format(ticketAvoir.getExpirationDate()), new Object[0]);
        ticket.blankLine(2);
        ticket.blankLine(1);
        ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "AVOIR", "L'impression d'un avoir de " + avoirAmount.replace(",", ".") + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public static void printTicket(String printerIP, String printerName, String PrinterType, Ticket2 ticket2, String errTitle, String errMsg, String portName, String brand_rate, PrinterInfo printerData, Decreaser decreaser) {
        PrinterHelper.printTicket(printerIP, printerName, PrinterType, ticket2, errTitle, errMsg, portName, brand_rate, printerData, decreaser, true);
    }

    public static void printTicket(String printerIP, String printerName, String PrinterType, Ticket2 ticket2, String errTitle, String errMsg, String portName, String brand_rate, PrinterInfo printerData, Decreaser decreaser, boolean addEventNoAvailablePrinter) {
        System.out.println("++++++++++++ PrinterType : " + PrinterType);
        if (PrinterType != null) {
            switch (PrinterType) {
                case "USB": {
                    new ActionPrint(printerIP, printerName, true, false, false, ticket2, errTitle, errMsg, portName, brand_rate, printerData, decreaser, addEventNoAvailablePrinter).execute();
                    break;
                }
                case "R\u00e9seau": {
                    new ActionPrint(printerIP, printerName, false, false, true, ticket2, errTitle, errMsg, portName, brand_rate, printerData, decreaser, addEventNoAvailablePrinter).execute();
                    break;
                }
                case "Serial": {
                    new ActionPrint(printerIP, printerName, false, true, false, ticket2, errTitle, errMsg, portName, brand_rate, printerData, decreaser, addEventNoAvailablePrinter).execute();
                }
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, errMsg, 1500, NPosition.CENTER);
        }
    }

    public static void printTicket(Ticket2 ticket2, String errTitle, String errMsg, PrinterInfo printerData, Decreaser decreaser) {
        if (printerData.getType() != null) {
            switch (printerData.getType()) {
                case "USB": {
                    new ActionPrint(printerData.getIp(), printerData.getNamePrinter(), true, false, false, ticket2, errTitle, errMsg, printerData.getPort(), printerData.getBand_rate(), printerData, decreaser, true).execute();
                    break;
                }
                case "R\u00e9seau": {
                    new ActionPrint(printerData.getIp(), printerData.getNamePrinter(), false, false, true, ticket2, errTitle, errMsg, printerData.getPort(), printerData.getBand_rate(), printerData, decreaser, true).execute();
                    break;
                }
                case "Serial": {
                    new ActionPrint(printerData.getIp(), printerData.getNamePrinter(), false, true, false, ticket2, errTitle, errMsg, printerData.getPort(), printerData.getBand_rate(), printerData, decreaser, true).execute();
                }
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, errMsg, 1500, NPosition.CENTER);
        }
    }

    public static synchronized void printTicket(String printerIP, String printerName, String PrinterType, Ticket ticket, String errTitle, String errMsg, String port, String brand_rate, PrinterInfo printerData, Decreaser decreaser) {
        if (PrinterType != null) {
            switch (PrinterType) {
                case "USB": {
                    new ActionPrint(printerIP, printerName, true, false, false, ticket, errTitle, errMsg, port, brand_rate, printerData, decreaser).execute();
                    break;
                }
                case "R\u00e9seau": {
                    new ActionPrint(printerIP, printerName, false, false, true, ticket, errTitle, errMsg, port, brand_rate, printerData, decreaser).execute();
                    break;
                }
                case "Serial": {
                    new ActionPrint(printerIP, printerName, false, true, false, ticket, errTitle, errMsg, port, brand_rate, printerData, decreaser).execute();
                }
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, errMsg, 1500, NPosition.CENTER);
        }
    }

    public static Bitmap getResizedBitmap(int targetW, int targetH, String imagePath) {
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        bmOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)bmOptions);
        int scaleFactor = Math.min(bmOptions.outWidth / targetW, bmOptions.outHeight / targetH);
        bmOptions.inJustDecodeBounds = false;
        bmOptions.inSampleSize = scaleFactor;
        Bitmap reducedResolutionBitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)bmOptions);
        if (reducedResolutionBitmap != null) {
            return Bitmap.createScaledBitmap((Bitmap)reducedResolutionBitmap, (int)targetW, (int)targetH, (boolean)true);
        }
        return null;
    }

    private void appendProduct(TicketLineInfo line, Ticket2 ticket, boolean isPaid, TicketInfo order) {
        boolean printQuantityOption = AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop light") && order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("Dishop");
        int sizeDesignation = TICKET_WIDTH / 2;
        int sizeTVA = isPaid ? 3 : 0;
        int sizePrices = (TICKET_WIDTH / 2 - sizeTVA) / 2;
        String unit = line.printMultiply();
        StringBuilder name = new StringBuilder();
        if (line.getSizeProduct() != null && AppLocal.LABEL_SIZE_FIRST) {
            name.append(line.getSizeProduct()).append(" - ");
        }
        name.append(line.printName());
        if (line.getSizeProduct() != null && !AppLocal.LABEL_SIZE_FIRST) {
            name.append(" - ").append(line.getSizeProduct());
        }
        int sizeQuantity = 3;
        String itemName = this.getName_product(name.toString(), unit, ticket, sizeDesignation -= sizeQuantity);
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        String tax_line = line.getTaxInfo() != null && line.getTaxInfo().getId() != null ? StringUtils.leftPad((String)("" + Integer.valueOf(line.getTaxInfo().getId())), (int)sizeTVA) : "";
        int taxe_id = line.getTaxInfo() != null && line.getTaxInfo().getId() != null ? Integer.valueOf(line.getTaxInfo().getId()) : 0;
        String price_item = Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded()) + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() * line.getMultiply()), (int)sizePrices) + tax_line;
        if (!isPaid) {
            price_item = Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded()) + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() * line.getMultiply()), (int)sizePrices);
        }
        ticket.addNewLine(3, true, itemName.toUpperCase(), price_item);
        ticket.setBoldText(false);
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0 || supplement.getFull_price() == 0.0 && !supplement.isDisplay_free()) continue;
            int tax_id_option = supplement.getTax() != null ? Integer.valueOf(supplement.getTax().getId()) : taxe_id;
            this.appendSupplement(supplement, ticket, tax_id_option, line.getMultiply() >= 0.0, line, isPaid, printQuantityOption);
        }
        for (ProductTicket product : line.getListProducts()) {
            this.appendItem(product, ticket, Integer.valueOf(line.getTaxInfo().getId()), line.getMultiply() >= 0.0, line, isPaid);
            for (OptionItemOrder supplementItem : line.getListSupplements()) {
                if (supplementItem.getIdProduct() != product.getIdProduct() || supplementItem.getIdCarte() != product.getIdCarte() || supplementItem.getIndex_carte() != product.getIndex_carte() || supplementItem.getPrice() == 0.0 && !supplementItem.isDisplay_free()) continue;
                this.appendSupplement(supplementItem, ticket, taxe_id, line.getMultiply() >= 0.0, line, isPaid, printQuantityOption);
            }
        }
        if (line.getValueDiscount() > 0.0) {
            String labelDiscount = line.printLabelDiscount();
            ticket.addNewLine(0, " " + labelDiscount + "  -" + Formats.CURRENCY_PRINTED.formatValue(Math.abs(line.getDiscount())), new Object[0]);
            ++this.nombreLignesInCammande;
        }
    }

    private void appendProductPlusTard(TicketLineInfo line, Ticket2 ticket) {
        Object itemName;
        int sizeDesignation = TICKET_WIDTH - 8;
        if (line.printName().length() > sizeDesignation) {
            int nbrLignofProduct = line.printName().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = line.printName().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? (line.getSizeProduct() != null ? ticket.formatMax(StringUtils.rightPad((String)line.printMultiply(), (int)4) + ligne + " - " + line.getSizeProduct()) : ticket.formatMax(StringUtils.rightPad((String)line.printMultiply(), (int)4) + ligne)) : StringUtils.rightPad((String)"", (int)4) + ligne;
                ++this.nombreLignesInCammande;
                ticket.setBoldText(true);
                ticket.addNewLine(0, ((String)itemName).toUpperCase(), new Object[0]);
                ticket.setBoldText(false);
            }
            itemName = "    " + line.printName().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = line.getSizeProduct() != null ? ticket.formatMax(StringUtils.rightPad((String)line.printMultiply(), (int)4) + line.printName() + " - " + line.getSizeProduct()) : ticket.formatMax(StringUtils.rightPad((String)line.printMultiply(), (int)4) + line.printName());
        }
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        ticket.addNewLine(3, ((String)itemName).toUpperCase(), StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() * line.getMultiply()), (int)7));
        ticket.setBoldText(false);
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
            ticket.addNewLine(1, "SANS " + ingredient.getNameSupplement(), new Object[0]);
        }
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
            this.appendSupplementPlusTard(supplement, ticket, Integer.valueOf(line.getTaxInfo().getId()), line.getMultiply() >= 0.0, line);
        }
        for (ProductTicket product : line.getListProducts()) {
            this.appendItemPlusTard(product, ticket, Integer.valueOf(line.getTaxInfo().getId()), line.getMultiply() >= 0.0);
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                if (ingredient.getIdProduct() != product.getIdProduct() || ingredient.getIdCarte() != product.getIdCarte() || ingredient.getIndex_carte() != product.getIndex_carte()) continue;
                ticket.addNewLine(1, "SANS " + ingredient.getNameSupplement(), new Object[0]);
            }
            for (OptionItemOrder supplementItem : line.getListSupplements()) {
                if (supplementItem.getIdProduct() != product.getIdProduct() || supplementItem.getIdCarte() != product.getIdCarte() || supplementItem.getIndex_carte() != product.getIndex_carte()) continue;
                this.appendSupplementPlusTard(supplementItem, ticket, Integer.valueOf(line.getTaxInfo().getId()), line.getMultiply() >= 0.0, line);
            }
        }
        if (line.getValueDiscount() > 0.0) {
            ticket.addNewLine(0, " " + line.getLabelDiscount() + "  -" + Formats.CURRENCY_PRINTED.formatValue(Math.abs(line.getDiscount())), new Object[0]);
        }
    }

    private void appendProductToFacture(TicketLineInfo line, Ticket2 ticket, boolean canceled) {
        Object itemName;
        String nameProduct;
        String prefix_sign = canceled ? "-" : "";
        int sizeDesignation = TICKET_WIDTH - 17;
        int width_price = (TICKET_WIDTH - 17) / 3;
        StringBuilder name = new StringBuilder();
        if (line.getSizeProduct() != null && AppLocal.LABEL_SIZE_FIRST) {
            name.append(line.getSizeProduct()).append(" - ");
        }
        name.append(line.printName());
        if (line.getSizeProduct() != null && !AppLocal.LABEL_SIZE_FIRST) {
            name.append(" - ").append(line.getSizeProduct());
        }
        if ((nameProduct = name.toString()).length() > sizeDesignation) {
            int nbrLignofProduct = nameProduct.length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = nameProduct.substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(line.printMultiply() + (("" + line.getMultiply()).length() < 2 ? " " : "") + "  " + ligne) : "    " + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "    " + nameProduct.substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(line.printMultiply() + (("" + line.getMultiply()).length() < 2 ? " " : "") + "  " + nameProduct);
        }
        this.nombreLignesInCammande += 2;
        ticket.addNewLine(0, (String)itemName, new Object[0]);
        String price_ht = prefix_sign + Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() / (1.0 + line.getTaxInfo().getRate()));
        String total_ht = Formats.CURRENCY_PRINTED.formatValue(line.getPriceProductMinusPriceIncluded() / (1.0 + line.getTaxInfo().getRate()) * line.getMultiply());
        String tva = " TVA(" + line.getTaxInfo().getName() + ")";
        ticket.addNewLine(2, StringUtils.center((String)price_ht, (int)width_price) + StringUtils.center((String)total_ht, (int)width_price) + StringUtils.center((String)tva, (int)width_price), new Object[0]);
        for (OptionItemOrder supplement : line.getListSupplements()) {
            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0 || supplement.getFull_price() == 0.0) continue;
            TaxInfo taxe = supplement.getTax() != null ? supplement.getTax() : line.getTaxInfo();
            this.appendSupplementToFacture(supplement, ticket, taxe, line, canceled);
        }
        for (ProductTicket product : line.getListProducts()) {
            this.appendItemTofacture(product, ticket, line.getTaxInfo(), line, canceled);
            for (OptionItemOrder supplementItem : line.getListSupplements()) {
                if (supplementItem.getIdProduct() != product.getIdProduct() || supplementItem.getIdCarte() != product.getIdCarte() || supplementItem.getIndex_carte() != product.getIndex_carte() || supplementItem.getPrice() == 0.0) continue;
                this.appendSupplementToFacture(supplementItem, ticket, line.getTaxInfo(), line, canceled);
            }
        }
        if (line.getValueDiscount() > 0.0) {
            String labelDiscount = line.printLabelDiscount();
            ticket.addNewLine(0, " " + labelDiscount + "  -" + Formats.CURRENCY_PRINTED.formatValue(Math.abs(line.getDiscount())), new Object[0]);
            ++this.nombreLignesInCammande;
        }
    }

    private void appendSupplement(OptionItemOrder option, Ticket2 ticket, int taxeId, boolean isPositive, TicketLineInfo ticketLine, boolean isPaid, boolean printQuantity) {
        Object itemName;
        int sizeDesignation = TICKET_WIDTH - 23;
        int sizeTVA = isPaid ? 3 : 0;
        int sizePrices = (TICKET_WIDTH - sizeDesignation - sizeTVA) / 2;
        int numberOption = option.getNumberOption() - option.getNumber_free();
        if (option.getNumberOption() == option.getNumber_free()) {
            numberOption = option.getNumberOption();
        }
        String prefix = "";
        if (AppLocal.MODULE_MULTI_TVA) {
            prefix = option.addTaxeToOption() && option.getPrice_already_included() > 0.0 ? (option.getFull_price() == option.getPrice_already_included() ? "(OI) " : "(OPI)") : (option.getFull_price() > 0.0 ? "(OP) " : "(OG) ");
        }
        Object numberOptions = option.isDisplay_free() && option.getFull_price() == 0.0 && !printQuantity ? "" : "" + (int)((double)option.getNumberOption() * ticketLine.getMultiply());
        String nameOption = prefix + option.getNameSupplement();
        if (nameOption.length() > sizeDesignation) {
            int nbrLignofProduct = nameOption.length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = nameOption.substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)4) + ligne) : " " + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "  " + nameOption.substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)4) + nameOption);
        }
        ++this.nombreLignesInCammande;
        if (option.getFull_price() != 0.0) {
            String price_supplement = (isPositive ? Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption) : Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption)) + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() * ticketLine.getMultiply()), (int)sizePrices) + StringUtils.leftPad((String)("" + taxeId), (int)sizeTVA);
            if (!isPaid) {
                price_supplement = (isPositive ? Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption) : Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() / (double)numberOption)) + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() * ticketLine.getMultiply()), (int)sizePrices);
            }
            ticket.addNewLine(3, (String)itemName, price_supplement);
        } else {
            ticket.addNewLine(0, (String)itemName, new Object[0]);
        }
    }

    private void appendSupplementPlusTard(OptionItemOrder line, Ticket2 ticket, int taxeId, boolean isPositive, TicketLineInfo ticketLine) {
        Object itemName;
        int sizeDesignation = TICKET_WIDTH - 23;
        int numberOption = line.getNumberOption() - line.getNumber_free();
        String numberOptions = "" + (int)((double)numberOption * ticketLine.getMultiply());
        if (line.getNameSupplement().length() > sizeDesignation) {
            int nbrLignofProduct = line.getNameSupplement().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = line.getNameSupplement().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)4) + "     " + ligne) : "   " + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "    " + line.getNameSupplement().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)4) + "      " + line.getNameSupplement());
        }
        ++this.nombreLignesInCammande;
        ticket.addNewLine(3, (String)itemName, StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(line.getFull_price() * ticketLine.getMultiply()), (int)7));
    }

    private void appendSupplementLivraison(OptionItemOrder option, Ticket2 ticket, boolean isPositive, TicketLineInfo line) {
        Object itemName;
        int sizeDesignation = TICKET_WIDTH - 17;
        int numberOption = option.getNumberOption() - option.getNumber_free();
        if (option.getNumberOption() == option.getNumber_free()) {
            numberOption = option.getNumberOption();
        }
        String numberOptions = "" + (int)((double)numberOption * line.getMultiply());
        if (option.getNameSupplement().length() > sizeDesignation) {
            int nbrLignofProduct = option.getNameSupplement().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = option.getNameSupplement().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(numberOptions + (numberOptions.length() < 2 ? " " : "") + " ---" + ligne) : "   " + ligne;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "    " + option.getNameSupplement().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(numberOptions + (numberOptions.length() < 2 ? " " : "") + "  ---" + option.getNameSupplement());
        }
        if (option.getPrice() != 0.0) {
            ticket.addNewLine(3, (String)itemName, isPositive ? Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() * line.getMultiply()) : "-" + Formats.CURRENCY_PRINTED.formatValue(option.getFull_price() * line.getMultiply()));
        } else {
            ticket.addNewLine(0, (String)itemName, new Object[0]);
        }
    }

    private void appendItem(ProductTicket item, Ticket2 ticket, int taxeId, boolean isPositive, TicketLineInfo line, boolean isPaid) {
        int sizeDesignation = TICKET_WIDTH / 2 - 2;
        int sizeQuantity = 3;
        int sizeTVA = isPaid ? 3 : 0;
        int sizePrices = (TICKET_WIDTH / 2 - sizeTVA) / 2;
        String numberItems = String.valueOf((int)((double)item.getNumberProduct() * line.getMultiply()));
        String itemName = this.getName_Item(item.getNameProduct(), ticket, numberItems, sizeDesignation -= sizeQuantity);
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        if (item.getPriceProduct() != 0.0) {
            String price_item = item.printPrice() + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(item.getPriceProduct() * (double)item.getNumberProduct() * line.getMultiply()), (int)sizePrices) + StringUtils.leftPad((String)("" + taxeId), (int)sizeTVA);
            if (!isPaid) {
                price_item = item.printPrice() + StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(item.getPriceProduct() * (double)item.getNumberProduct() * line.getMultiply()), (int)sizePrices);
            }
            ticket.addNewLine(3, itemName.toUpperCase(), price_item);
        } else {
            ticket.addNewLine(0, itemName.toUpperCase(), new Object[0]);
        }
        ticket.setBoldText(false);
    }

    private void appendItemPlusTard(ProductTicket item, Ticket2 ticket, int taxeId, boolean isPositive) {
        int sizeDesignation = TICKET_WIDTH - 8 - 2;
        String numberOptions = String.valueOf(item.getNumberProduct());
        String itemName = this.getName_Item(item.getNameProduct(), ticket, numberOptions, sizeDesignation);
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        if (item.getPriceProduct() != 0.0) {
            ticket.addNewLine(3, itemName.toUpperCase(), StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(item.getPriceProduct() * (double)item.getNumberProduct()), (int)7));
        } else {
            ticket.addNewLine(0, itemName.toUpperCase(), new Object[0]);
        }
        ticket.setBoldText(false);
    }

    public int getNombreLignesInCammande() {
        return this.nombreLignesInCammande;
    }

    public void setNombreLignesInCammande(int nombreLignesInCammande) {
        this.nombreLignesInCammande = nombreLignesInCammande;
    }

    private void appendSupplementToFacture(OptionItemOrder line, Ticket2 ticket, TaxInfo taxe, TicketLineInfo ticketline, boolean canceled) {
        Object itemName;
        String prefix_sign = canceled ? "-" : "";
        int width_price = (TICKET_WIDTH - 17) / 3;
        int sizeDesignation = TICKET_WIDTH - 17;
        int numberOption = line.getNumberOption() - line.getNumber_free();
        int quantity = (int)((double)line.getNumberOption() * ticketline.getMultiply());
        if (line.getNameSupplement().length() > sizeDesignation) {
            int nbrLignofProduct = line.getNameSupplement().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = line.getNameSupplement().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(quantity + (("" + quantity).length() < 2 ? " " : "") + " ---" + ligne) : "   " + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "    " + line.getNameSupplement().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(quantity + (("" + quantity).length() < 2 ? " " : "") + "  ---" + line.getNameSupplement());
        }
        this.nombreLignesInCammande += 2;
        ticket.addNewLine(0, (String)itemName, new Object[0]);
        String price_ht = prefix_sign + Formats.CURRENCY_PRINTED.formatValue(line.getFull_price() / (double)numberOption / (1.0 + taxe.getRate()));
        String total_ht = prefix_sign + Formats.CURRENCY_PRINTED.formatValue(line.getFull_price() / (1.0 + taxe.getRate()) * ticketline.getMultiply());
        String tva = " TVA(" + taxe.getName() + ")";
        ticket.addNewLine(2, StringUtils.center((String)price_ht, (int)width_price) + StringUtils.center((String)total_ht, (int)width_price) + StringUtils.center((String)tva, (int)width_price), new Object[0]);
    }

    private void addBloc(Ticket2 ticket, TicketInfo order) {
        String str;
        ticket.setTextSize(1, 2);
        if (order.getBipper() != 0 || order.getEasel_number() != 0) {
            str = order.getBipper() != 0 ? " " + AppLocal.getIntString("Label.bipper") + " " + order.getBipper() + " " : "Chevalet " + order.getEasel_number();
            ticket.addNewLine(1, str, new Object[0]);
        }
        if (order.getTable() != null) {
            str = AppLocal.getIntString("Label.num.table") + " " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        if (order.getCouverts() != 0) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.covered") + " " + order.getCouverts(), new Object[0]);
        }
        ticket.setTextSize(1, 1);
    }

    private void addTextBloc(Ticket2 ticket, String text) {
        int h;
        int h2;
        ticket.blankLine(1);
        ticket.setTextSize(1, 1);
        int sizeMargin = (int)((double)TICKET_WIDTH * 0.2);
        int sizeBloc = TICKET_WIDTH - sizeMargin * 2;
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        for (h2 = 0; h2 < sizeBloc; ++h2) {
            ticket.append("-");
        }
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 2);
        String type = " " + text + " ";
        int space = sizeBloc - type.length() - 2;
        int halfSpace = space / 2;
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.append(type.toUpperCase());
        if (2 * halfSpace + type.length() + 2 < sizeBloc) {
            ++halfSpace;
        }
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 1);
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeBloc; ++h) {
            ticket.append("-");
        }
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
    }

    private void addBlocLater(Ticket2 ticket) {
        int h;
        int h2;
        ticket.blankLine(1);
        ticket.setTextSize(1, 1);
        int sizeMargin = (int)((double)TICKET_WIDTH * 0.2);
        int sizeBloc = TICKET_WIDTH - sizeMargin * 2;
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        for (h2 = 0; h2 < sizeBloc; ++h2) {
            ticket.append("-");
        }
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        for (h2 = 0; h2 < sizeMargin; ++h2) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 2);
        String type = " Emporter ";
        int space = sizeBloc - type.length() - 2;
        int halfSpace = space / 2;
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.append(type.toUpperCase());
        if (2 * halfSpace + type.length() + 2 < sizeBloc) {
            ++halfSpace;
        }
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 1);
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeBloc; ++h) {
            ticket.append("-");
        }
        for (h = 0; h < sizeMargin; ++h) {
            ticket.append(" ");
        }
    }

    private void addBloc(Ticket2 ticket, String type, int bipper, double widthBlock) {
        int h;
        int h2;
        ticket.blankLine(1);
        ticket.setTextSize(1, 1);
        int sizeMargin = (int)((double)TICKET_WIDTH * 0.2);
        int sizeBloc = (int)((double)TICKET_WIDTH * widthBlock);
        for (h2 = 0; h2 < sizeMargin + 1; ++h2) {
            ticket.append(" ");
        }
        for (h2 = 0; h2 < sizeBloc; ++h2) {
            ticket.append("-");
        }
        for (h2 = 0; h2 < sizeMargin + 1; ++h2) {
            ticket.append(" ");
        }
        if (bipper != 0) {
            for (h2 = 0; h2 < sizeMargin + 1; ++h2) {
                ticket.append(" ");
            }
            ticket.setTextSize(1, 3);
            ticket.append("|");
            ticket.setTextSize(1, 2);
            String str = " Bipper N\u00b0 " + bipper + " ";
            int space = sizeBloc - str.length();
            for (h = 0; h < space / 2; ++h) {
                ticket.append(" ");
            }
            ticket.append(str);
            for (h = 0; h < space / 2; ++h) {
                ticket.append(" ");
            }
            ticket.setTextSize(1, 3);
            ticket.append("|");
            ticket.setTextSize(1, 2);
            for (h = 0; h < sizeMargin + 1; ++h) {
                ticket.append(" ");
            }
        }
        for (int h3 = 0; h3 < sizeMargin; ++h3) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 2);
        type = " " + (String)type + " ";
        int space = sizeBloc - ((String)type).length();
        int halfSpace = space / 2;
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.append((String)type);
        if (2 * halfSpace + ((String)type).length() == sizeBloc) {
            --halfSpace;
        }
        for (h = 0; h < halfSpace; ++h) {
            ticket.append(" ");
        }
        ticket.setTextSize(1, 3);
        ticket.append("|");
        ticket.setTextSize(1, 1);
        for (h = 0; h < sizeMargin + 1; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeMargin + 1; ++h) {
            ticket.append(" ");
        }
        for (h = 0; h < sizeBloc; ++h) {
            ticket.append("-");
        }
        for (h = 0; h < sizeMargin + 1; ++h) {
            ticket.append(" ");
        }
    }

    private void addNameProduit(Ticket2 ticket, TicketLineInfo product, boolean update, String text_add, boolean background_black) {
        Object str = "";
        Object multiplicity = "";
        String add = text_add;
        StringBuilder textByLangaugeBuilder = new StringBuilder();
        if (AppLocal.PRINT_ARABIC) {
            String arabic_name_product = product.getNameByLanguage("ar");
            String english_name_product = product.getNameByLanguage("en");
            System.out.println("english_name_product : " + english_name_product);
            if (english_name_product != null && !english_name_product.isEmpty()) {
                textByLangaugeBuilder.append(english_name_product);
                if (arabic_name_product != null && !arabic_name_product.isEmpty()) {
                    textByLangaugeBuilder.append("(");
                }
            }
            if (arabic_name_product != null && !arabic_name_product.isEmpty()) {
                textByLangaugeBuilder.append(this.textAfterCheckLanguage(arabic_name_product));
            }
            if (english_name_product != null && !english_name_product.isEmpty() && arabic_name_product != null && !arabic_name_product.isEmpty()) {
                textByLangaugeBuilder.append(")");
            }
        }
        str = (String)str + (textByLangaugeBuilder.toString().isEmpty() ? PrinterHelper.formatMax(product.printName(true)) : textByLangaugeBuilder.toString());
        multiplicity = product.getDifference_quantity() != 0.0 ? product.printDifference_quantity() + "X - " : (product.getMultiply() == 1.0 ? "1X - " : product.printMultiply() + "X - ");
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < product.getOffset_print_kitchen(); ++i) {
            prefix.append(" ");
        }
        str = update ? add + (String)multiplicity + (String)str : (String)multiplicity + (String)str;
        if (AppLocal.UPPERCASE_KITCHEN_TICKET) {
            str = ((String)str).toUpperCase();
        }
        if (AppLocal.PRINT_ARABIC) {
            // empty if block
        }
        String[] tab_chaines = ((String)str).split(" ");
        ArrayList<String> chaines = new ArrayList<String>();
        Object chaine_tmp = "";
        int width_chaine = 2;
        for (String chaine : tab_chaines) {
            if ((((String)chaine_tmp).length() + chaine.length() + 1) * width_chaine + prefix.toString().length() <= TICKET_WIDTH) {
                chaine_tmp = (String)chaine_tmp + chaine + " ";
                continue;
            }
            String string_to_add = chaine_tmp;
            string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
            chaines.add(string_to_add);
            chaine_tmp = chaine + " ";
        }
        String string_to_add = chaine_tmp;
        string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
        chaines.add(string_to_add);
        for (String chaine : chaines) {
            ticket.setTextSize(1, 1);
            ticket.setReversedText(false);
            ticket.append(prefix.toString());
            ticket.setTextSize(2, 2);
            if (background_black) {
                ticket.setReversedText(true);
            }
            int size_chaine = chaine.length() * width_chaine;
            int numSpace = (TICKET_WIDTH - size_chaine - prefix.toString().length()) / width_chaine;
            ticket.append(chaine);
            for (int i = 0; i < numSpace; ++i) {
                ticket.append(" ");
            }
        }
        ticket.setTextSize(1, 2);
        ticket.setReversedText(false);
        if (product.getSizeProduct() != null && !product.getSizeProduct().isEmpty()) {
            ticket.blankLine(2);
            ticket.addNewLine(1, "TAILLE : " + product.getSizeProduct(), new Object[0]);
            ticket.blankLine(1);
        } else {
            ticket.blankLine(1);
        }
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
    }

    private void addNameProduit(Ticket2 ticket, TicketLineInfo product, boolean backgound_black) {
        this.addNameProduit(ticket, product, false, null, backgound_black);
    }

    public void printCloseCaisseCenter(FinancialReportInfo financialReportInfo, List<Course> courses, CaisseInfo caisse, MarqueNFC marqueNF, Date dateStart, Date dateEnd, String title, CaisseZ zcaisse, Decreaser decreaser, String type_rapport, int number_impression, double fondcaissecalcule) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, AppLocal.getIntString("Text.financial.report").toUpperCase(), new Object[0]);
        ticket.addNewLine(1, title.toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        if (type_rapport != null && type_rapport.equals("month")) {
            ticket.addNewLine(1, DateUtils.getNameOfMonth(dateStart.getMonth() + 1) + " " + (dateStart.getYear() + 1900), new Object[0]);
        } else {
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateStart) : this.dateFormatter.format(dateStart)) + "    " + this.HorraireFormatter.format(dateStart), new Object[0]);
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateEnd) : this.dateFormatter.format(dateEnd)) + "    " + this.HorraireFormatter.format(dateEnd), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTurnover()), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, financialReportInfo.getNumberOrders() + " " + AppLocal.getIntString("Text.orders"), new Object[0]);
        if (title.equalsIgnoreCase(" Z caisse ")) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            if (zcaisse != null) {
                ticket.addNewLine(1, "Fond de caisse \u00e0 l'ouverture : " + Formats.CURRENCY_PRINTED.formatValue(zcaisse.getFund_open()), new Object[0]);
                if (zcaisse.getFund_close() > 0.0) {
                    ticket.addNewLine(1, "Fond de caisse \u00e0 la fermeture :" + Formats.CURRENCY_PRINTED.formatValue(zcaisse.getFund_close()), new Object[0]);
                }
            } else if (caisse != null) {
                double ecart;
                ticket.addNewLine(1, "Fond de caisse \u00e0 l'ouverture : " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondCaisse()), new Object[0]);
                if (financialReportInfo.getTotalCash() > 0.0) {
                    ticket.addNewLine(1, " Paiement encaiss\u00e9 espece " + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalCash()), new Object[0]);
                }
                if (financialReportInfo.getTotalIn() > 0.0) {
                    ticket.addNewLine(1, " Entr\u00e9es d'argent " + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalIn()), new Object[0]);
                }
                if (financialReportInfo.getTotalOut() > 0.0) {
                    ticket.addNewLine(1, " Sorties d'argent -" + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalOut()), new Object[0]);
                }
                if (financialReportInfo.getValueCourses() > 0.0) {
                    ticket.addNewLine(1, " Courses -" + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getValueCourses()), new Object[0]);
                }
                ticket.addNewLine(1, "Fond de caisse saisi \u00e0 la fermeture :" + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondClose()), new Object[0]);
                if (fondcaissecalcule > 0.0) {
                    ticket.addNewLine(1, " Fond de caisse calcul\u00e9 apr\u00e8s fermeture:" + Formats.CURRENCY_PRINTED.formatValue(fondcaissecalcule), new Object[0]);
                }
                ticket.blankLine(1);
                if (financialReportInfo.getCashFund() > 0.0) {
                    ticket.addNewLine(1, " Fond de caisse th\u00e9orique :" + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getCashFund()), new Object[0]);
                }
                if (Math.abs(ecart = NumericUtils.round(caisse.getFondClose() - financialReportInfo.getCashFund())) > 0.0) {
                    ticket.addNewLine(1, "\u00c9cart :" + Formats.CURRENCY_PRINTED.formatValue(ecart), new Object[0]);
                }
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        if (AppLocal.MODULE_TVA_GLOBAL) {
            double total_before_taxes = financialReportInfo.getTurnover();
            for (GroupedTax globalTaxe : financialReportInfo.getGroupedTaxes()) {
                total_before_taxes -= globalTaxe.getTotal_tax();
            }
            ticket.addNewLine(3, "Total avant taxes : ", Formats.CURRENCY.formatValue(total_before_taxes));
            if (financialReportInfo.getTotal_ht_taxable() != 0.0 || financialReportInfo.getTotal_ht_no_taxable() != 0.0) {
                ticket.addNewLine(3, "Total HT Taxable : ", Formats.CURRENCY.formatValue(financialReportInfo.getTotal_ht_taxable()));
                ticket.addNewLine(3, "Total HT no Taxable : ", Formats.CURRENCY.formatValue(financialReportInfo.getTotal_ht_no_taxable()));
            }
            for (GroupedTax globalTaxe : financialReportInfo.getGroupedTaxes()) {
                ticket.addNewLine(3, globalTaxe.getName(), Formats.CURRENCY.formatValue(globalTaxe.getTotal_tax()));
            }
        } else {
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "TVA", new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.addNewLine(3, "TVA        Total TVA", "Total HT   Total TTC");
            double total_Tva = 0.0;
            double total_HT = 0.0;
            double total_TTC = 0.0;
            for (TaxeLine taxe : financialReportInfo.getTaxes()) {
                if (taxe.getTotal() == 0.0) continue;
                String name_taxe = taxe.getName() != null && !taxe.getName().isEmpty() ? taxe.getName() : "";
                int nmbSpce_name = 11 - name_taxe.length();
                StringBuilder stringBuilderName = new StringBuilder("");
                stringBuilderName.append(name_taxe);
                for (int i = 0; i < nmbSpce_name; ++i) {
                    stringBuilderName.append(" ");
                }
                int nmbSpce = 11 - taxe.printTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(taxe.printHT());
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, stringBuilderName.toString() + taxe.printTaxe(), stringBuilder.toString() + taxe.printTTC());
                total_Tva += taxe.getTax();
                total_HT += taxe.getHt();
                total_TTC += taxe.getTotal();
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(total_TTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(total_HT));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total      " + TaxLineInfo.printThisDoubleAsAmount(total_Tva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(total_TTC));
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition encaissement", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (PaymentLine paymentLine : financialReportInfo.getPayments()) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                ticket.addNewLine(1, this.getOfficialPayement(paymentLine.getM_PaymentType()) + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                ticket.addNewLine(1, "Avoir Encaiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            ticket.addNewLine(1, "Avoir D\u00e9caiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
        }
        for (PaymentLine paymentLine : financialReportInfo.getPayments()) {
            switch (paymentLine.getM_PaymentType()) {
                case "CB": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " " + AppLocal.getIntString("Button.cb"), new Object[0]);
                    break;
                }
                case "Carte Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Carte Ticket Resto", new Object[0]);
                    break;
                }
                case "Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Tickets Resto", new Object[0]);
                }
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition type", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (RankTypeOrder type : financialReportInfo.getDataTypeOrders()) {
            ticket.addNewLine(1, AppConstants.getTypeOrder(type.getName()) + " : " + Formats.CURRENCY_PRINTED.formatValue(type.getCa()), new Object[0]);
        }
        if (financialReportInfo.getDataTypePlatformOrders() != null && !financialReportInfo.getDataTypePlatformOrders().isEmpty()) {
            ticket.blankLine(1);
            for (RankTypeOrder type : financialReportInfo.getDataTypePlatformOrders()) {
                ticket.addNewLine(1, type.getName() + " : " + Formats.CURRENCY.formatValue(type.getCa()), new Object[0]);
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.orders") + ": " + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalDiscount()), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.items") + ": " + Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalDiscountOnLines()), new Object[0]);
        ticket.blankLine(1);
        if (financialReportInfo.getDiscountOrders() != null && financialReportInfo.getDiscountOrders().size() > 0) {
            ticket.blankLine(2);
            ticket.addNewLine(3, "Num date heure", "caissier R\u00e9duction");
            for (TicketInfo order : financialReportInfo.getDiscountOrders()) {
                this.appendOrderDiscount(order, ticket);
            }
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Label.cashier"), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        for (UserCaisseInfo user : financialReportInfo.getUsers()) {
            ticket.addNewLine(1, user.getName() + " : " + user.printTotal(), new Object[0]);
        }
        ticket.blankLine(1);
        double val_course = 0.0;
        if (courses != null && courses.size() > 0) {
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Button.courses"), new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            this.addColumnCourse(AppLocal.getIntString("Text.article"), 0.3, ticket);
            this.addColumnCourse(AppLocal.getIntString("Text.price"), 0.2, ticket);
            this.addColumnCourse(AppLocal.getIntString("Label.heure"), 0.2, ticket);
            this.addColumnCourse(AppLocal.getIntString("Label.cashier"), 0.3, ticket);
            ticket.blankLine(1);
            for (Course course : courses) {
                val_course += course.getPrice();
                this.appendCourse(course, ticket);
            }
        }
        if (AppLocal.PRINT_LOG_PANIER_ON_Z && financialReportInfo.getLogsPanier() != null && financialReportInfo.getLogsPanier().size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Text.canceled.products"), new Object[0]);
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), AppLocal.getIntString("Text.price") + "  H.Supp");
            for (LogPanier log : financialReportInfo.getLogsPanier()) {
                this.appendLog(log, ticket);
            }
        }
        if (financialReportInfo.getOrdersCanceled() != null && financialReportInfo.getOrdersCanceled().size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Text.canceled.orders"), new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTurnoverCanceled()), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, AppLocal.getIntString("Text.num") + " " + AppLocal.getIntString("Label.date").toLowerCase(), "Total");
                for (TicketInfo order : financialReportInfo.getOrdersCanceled()) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (AppLocal.PRINT_CANCELED_ORDERS_ON_Z && financialReportInfo.getNotesCanceled() != null && financialReportInfo.getNotesCanceled().size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "Notes annul\u00e9es", new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalNotesCanceled()), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, "Num date heure", "caissier Total");
                for (TicketInfo order : financialReportInfo.getNotesCanceled()) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (financialReportInfo.getPertesInfos() != null && financialReportInfo.getPertesInfos().size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "Perte de marchandises", new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(financialReportInfo.getTotalLoss()), new Object[0]);
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addNewLine(3, "Produit", "Prix");
            for (PertEntity pertEntity : financialReportInfo.getPertesInfos()) {
                for (PertInfo pertInfo : pertEntity.getPertInfoCollection()) {
                    ticket.addNewLine(3, pertInfo.getName_product(), Formats.CURRENCY_PRINTED.formatValue(pertInfo.getTotal()));
                }
            }
        }
        if (title.equalsIgnoreCase(" X caisse ")) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Label.cash.fund"), new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addNewLine(1, " " + AppLocal.getIntString("Text.opening") + " : " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondCaisse()), new Object[0]);
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
        mesBytesInteger.addAll(ticket.bytes);
        for (int h = 1; h < number_impression; ++h) {
            ticket.bytes.addAll(mesBytesInteger);
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void testPrinter(PrinterInfo printer, Decreaser decreaser) {
        TICKET_WIDTH = printer.getWith();
        Ticket2 ticket2 = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket2.addLineOfEquals();
        ticket2.addNewLine(1, "test impression " + printer.getNamePrinter(), new Object[0]);
        ticket2.blankLine(1);
        ticket2.addLineOfEquals();
        ticket2.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket2.cut();
        } else {
            ticket2.halfCut();
        }
        PrinterHelper.printTicket(ticket2, "Erreur d'impression", "erreur d'impression sur cette imprimante", printer, decreaser);
    }

    private Ticket2 generatorTicketBorneCustomerQrBarCode(TicketInfo order, EnteteInfo entete, BufferedImage qrCodeImage, boolean borne, String barCode) {
        String orderNum;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        ticket.setAlign(1);
        if (qrCodeImage != null) {
            ticket.addImage(qrCodeImage);
        } else if (barCode != null) {
            ticket.appendCodeBar(barCode);
            ticket.addNewLine(1, barCode, new Object[0]);
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        ticket.setTextSize(2, 4);
        ticket.addNewLine(1, AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        String string = orderNum = order.getCaisse() != null ? order.getCaisse() + order.getNumero_order() : String.valueOf(order.getNumero_order());
        if (borne) {
            orderNum = order.getNumberOrderBorne();
            String prefix = order.getCaisse() != null && !order.getCaisse().isEmpty() && order.getCaisse().length() <= 2 ? order.getCaisse() + "-" : "C-";
            ticket.addNewLine(1, prefix + orderNum, new Object[0]);
            if (order.getCustomer() == null && order.getName_customer() != null && !order.getName_customer().isEmpty() && AppLocal.ADD_NAME_CUSTOMER_AFTER_ORDER_BORNE) {
                ticket.addNewLine(1, "Client : " + order.getName_customer(), new Object[0]);
            }
        } else {
            ticket.addNewLine(1, AppLocal.getIntString("Text.order") + "  " + orderNum, new Object[0]);
        }
        if (AppLocal.PRINT_TOTAL_ON_KIOSK_QR_TICKET) {
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Text.net.to.pay") + " : " + Formats.CURRENCY_PRINTED.formatValue(order.getTotal()), new Object[0]);
        }
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        ticket.addNewLine(1, AppLocal.getIntString("Label.message.atcounter"), new Object[0]);
        ticket.setBoldText(true);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        return ticket;
    }

    private Ticket2 generatorTicketBorneCustomer(TicketInfo order, EnteteInfo entete, long impressionNumber) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        if (impressionNumber > 0L && order.isPaid() && order.getTotal() > 0.0) {
            ticket.addNewLine(1, "DUPLICATA Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
        } else if (order.isPaid() && order.getTotal() > 0.0) {
            ticket.addNewLine(1, "Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
        } else if (order.getTotal() > 0.0) {
            ticket.addNewLine(1, "Commande N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
        } else if (order.getTotal() < 0.0) {
            if (impressionNumber > 0L) {
                ticket.addNewLine(1, "DUPLICATA Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
            } else {
                ticket.addNewLine(1, "Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
            }
            ticket.addNewLine(1, "Avoir du Ticket N\u00b0" + order.getOrigineCanceledTicket() + " Caisse 1 ", new Object[0]);
        }
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
        } else {
            ticket.addNewLine(1, dateFormatterFull.format(new Date()) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        }
        if (order.getTable() != null) {
            String str = "Table N\u00b0 " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
        ticket.addNewLine(1, "Vendeur : " + order.getUser().getName() + sId, new Object[0]);
        if (order.getBipper() != 0) {
            String str = "Bipper\u00b0 " + order.getBipper();
            ticket.addNewLine(1, str, new Object[0]);
        }
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.isPaid()) {
            ticket.addNewLine(3, "QTE DESIGNATION", "PRIX  TOTAL TVA");
        } else {
            ticket.addNewLine(3, "QTE DESIGNATION", "PRIX  TOTAL");
        }
        ticket.addLineOfDashes();
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProduct(line, ticket, order.isPaid(), order);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, "Nb. Article : " + order.getNbrArticles(), new Object[0]);
        if (order.isPaid()) {
            ticket.addNewLine(3, "TVA        Mt.TVA", "Base HT   Base TTC");
            double mtTva = 0.0;
            double baseHT = 0.0;
            double baseTTC = 0.0;
            for (TaxLineInfo taxe : order.getTaxes()) {
                Object name = taxe.getName();
                if (((String)name).length() == 3) {
                    name = (String)name + " ";
                }
                int nmbSpce = 11 - taxe.printSumTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append((String)(order.getTotal() > 0.0 ? taxe.printSumHT() : "-" + taxe.printSumHT()));
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + "   " + (String)(order.getTotal() > 0.0 ? taxe.printAmount() : "-" + taxe.printAmount()), stringBuilder.toString() + (String)(order.getTotal() > 0.0 ? taxe.printSumTTC() : "-" + taxe.printSumTTC()));
                mtTva += taxe.getAmount();
                baseHT += taxe.getSumHT();
                baseTTC += taxe.getSumTTC();
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append((String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseHT) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseHT)));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total" + (order.getTotal() > 0.0 ? "      " : "     -") + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + (String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseTTC) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseTTC)));
            ticket.addLineOfDashes();
        }
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Total T.T.C. ", order.printTotal());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        if (order.isPaid()) {
            boolean isFirst = true;
            boolean isNegative = false;
            if (order.getPayments() != null && order.getPayments().size() == 1 && order.getPayments().get(0).getTendered() < 0.0) {
                ticket.addNewLine(1, "----Remboursement----", new Object[0]);
                isNegative = true;
            } else {
                ticket.addNewLine(1, "Mode de paiement", new Object[0]);
            }
            for (PaymentInfo payment : order.getPayments()) {
                if (!isNegative) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTendered());
                }
                renduMonnaie += payment.getTendered() - payment.getTotal();
                if (!payment.getName().equalsIgnoreCase("cashlogy")) continue;
                ticket.addNewLine(3, " * Montant Entr\u00e9 :", this.printTotal(AppLocal.TOTAL_PAID_CASHLOGY));
                ticket.addNewLine(3, " * Montant encaiss\u00e9 :", this.printTotal(AppLocal.TOTAL_PAID_CASHLOGY - AppLocal.TOTAL_RENDU_CASHLOGY));
                ticket.addNewLine(3, " * Montant rendu :", this.printTotal(AppLocal.TOTAL_RENDU_CASHLOGY));
            }
            if (isNegative) {
                ticket.addNewLine(3, "Espece", order.printTotal());
            }
            renduMonnaie = NumericUtils.round(renduMonnaie);
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0 && order.getTotal() > 0.0) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, "Rendu monnaie: " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    ticket.addNewLine(3, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "Version logiciel : 10.0.1.27", new Object[0]);
        ticket.addNewLine(1, "Type d'op\u00e9ration : " + (entete.getTypeOperation().equals("Annulation") ? "Avoir" : entete.getTypeOperation()), new Object[0]);
        if (entete.IsTicketRestituted()) {
            ticket.addNewLine(1, "R\u00e9impression N\u00b0" + impressionNumber + " - " + this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        }
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        return ticket;
    }

    public void printTicketQRBarCode(TicketInfo order, EnteteInfo entete, long impressionNumber, BufferedImage qrCodeImage, Decreaser decreaser, boolean borne, String barCode) {
        Ticket2 ticket = null;
        ticket = qrCodeImage != null || barCode != null ? this.generatorTicketBorneCustomerQrBarCode(order, entete, qrCodeImage, borne, barCode) : this.generatorTicketBorneCustomer(order, entete, impressionNumber);
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Ticket n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printTicketBorneCustomer(TicketInfo order, EnteteInfo entete, long impressionNumber, BufferedImage qrCodeImage, Decreaser decreaser, String barCode) {
        this.printTicketQRBarCode(order, entete, impressionNumber, qrCodeImage, decreaser, true, barCode);
    }

    public void printFactureSansDetails(Facture facture, TicketInfo order, EnteteInfo entete, int impressionNumber, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeaderFacture(ticket, facture);
        ticket.blankLine(1);
        if (impressionNumber > 0) {
            ticket.addNewLine(1, "DUPLICATA Facture N\u00b0" + facture.getId() + " Caisse 1 ", new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
        } else {
            ticket.addNewLine(1, "Facture N\u00b0" + facture.getId() + " Caisse 1 ", new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + order.getNumero_order() + " Caisse 1 ", new Object[0]);
        }
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(new Date()), new Object[0]);
        } else {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(new Date()) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        }
        if (facture.isPhysical_person()) {
            ticket.addNewLine(1, "Client : " + facture.getName_contact(), new Object[0]);
        } else {
            ticket.addNewLine(1, "Client : " + facture.getCompany(), new Object[0]);
        }
        ticket.setTextSize(1, 1);
        if (facture.getAddress() != null && !facture.getAddress().isEmpty()) {
            String[] tabString = facture.getAddress().split(" ");
            int longueur = tabString.length;
            int half = longueur / 2;
            Object line1 = "";
            for (int i = 0; i < half; ++i) {
                line1 = (String)line1 + tabString[i] + " ";
            }
            Object line2 = "";
            for (int i = half; i < longueur; ++i) {
                line2 = (String)line2 + tabString[i] + " ";
            }
            ticket.addNewLine(1, (String)line1, new Object[0]);
            if (((String)line2).length() > 0) {
                ticket.addNewLine(1, (String)line2, new Object[0]);
            }
        }
        if (facture.getZip_code() != null && !facture.getZip_code().isEmpty() || facture.getCity() != null && !facture.getCity().isEmpty()) {
            ticket.addNewLine(1, facture.getZip_code() + " " + facture.getCity(), new Object[0]);
        }
        if (facture.getCountry() != null && !facture.getCountry().isEmpty()) {
            ticket.addNewLine(1, facture.getCountry(), new Object[0]);
        }
        if (facture.getSiret() != null && !facture.getSiret().isEmpty()) {
            ticket.addNewLine(1, "Siret : " + facture.getSiret(), new Object[0]);
        }
        if (order.getStatus().equalsIgnoreCase("cancel")) {
            ticket.addNewLine(1, "----ANNUL\ufffd\ufffdE----", new Object[0]);
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "D\u00c9SIGNATION  HT", "TVA");
        ticket.addLineOfDashes();
        for (TaxLineInfo taxe : order.getTaxes()) {
            this.appendProductToFactureSensDetails("Offre Formule" + (String)(order.getCouverts() != 0 ? " x " + order.getCouverts() : ""), taxe.getSumHT(), taxe.getName(), ticket);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, "Nb. Article : " + order.getNbrArticles(), new Object[0]);
        ticket.addNewLine(3, "TVA      Mt.TVA", "Base HT   Base TTC");
        double mtTva = 0.0;
        double baseHT = 0.0;
        double baseTTC = 0.0;
        for (TaxLineInfo taxe : order.getTaxes()) {
            Object name = taxe.getName();
            if (((String)name).length() == 3) {
                name = (String)name + " ";
            }
            int nmbSpce = 11 - taxe.printSumTTC().length();
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append(taxe.printSumHT());
            for (int i = 0; i < nmbSpce; ++i) {
                stringBuilder.append(" ");
            }
            ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + " " + taxe.printAmount(), stringBuilder.toString() + taxe.printSumTTC());
            mtTva += NumericUtils.round(taxe.getAmount());
            baseHT += NumericUtils.round(taxe.getSumHT());
            baseTTC += NumericUtils.round(taxe.getSumTTC());
        }
        int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
        StringBuilder stringTotal = new StringBuilder("");
        stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(baseHT));
        for (int i = 0; i < nmbSpce; ++i) {
            stringTotal.append(" ");
        }
        ticket.addNewLine(3, "Total TVA " + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(baseTTC));
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Total T.T.C. ", order.printTotalOrder());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().contains("pourcentage")) {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getTotal() / (100.0 - order.getDiscount()))));
            } else {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        boolean isFirst = true;
        boolean isNegative = false;
        if (order.getTotalOrder() < 0.0) {
            ticket.addNewLine(1, "----Remboursement----", new Object[0]);
            isNegative = true;
        } else {
            ticket.addNewLine(1, "Mode de paiement", new Object[0]);
        }
        for (PaymentInfo payment : order.getPayments()) {
            if (!isNegative) {
                ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
            }
            renduMonnaie += payment.getTendered() - payment.getTotal();
        }
        if (isNegative) {
            ticket.addNewLine(3, "Espece", order.printTotalOrder());
        }
        renduMonnaie = NumericUtils.round(renduMonnaie);
        if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0) {
            ticket.blankLine(1);
            ticket.addNewLine(1, "Rendu monnaie: " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
            for (PaymentInfo payment : order.getPayments()) {
                if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                ticket.addNewLine(3, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
            }
        }
        ticket.blankLine(1);
        this.setIdentificationLogiciel(ticket, facture.getSignature(), entete.getVersionSoft(), entete.getName_soft());
        ticket.addNewLine(1, "Type d'op\u00e9ration : " + entete.getTypeOperation().toUpperCase(), new Object[0]);
        if (impressionNumber != 0) {
            ticket.addNewLine(1, "R\u00e9impression N\u00b0" + impressionNumber + " - " + this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        }
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Facture n\u00b0" + String.valueOf(facture.getId()), "L'impression de la facture a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private void appendProductToFactureSensDetails(String printName, Double totalHT, String taxeName, Ticket2 ticket) {
        this.nombreLignesInCammande += 2;
        ticket.addNewLine(0, printName, new Object[0]);
        ticket.addNewLine(2, "H.T.   " + Formats.CURRENCY_PRINTED.formatValue(totalHT) + "     TAUX TVA(" + taxeName + ")", new Object[0]);
    }

    private String loadWeightOption(OptionItemOrder supplement) {
        Object textWeight = "";
        if (supplement.getWeight() != null) {
            switch (supplement.getWeight()) {
                case "light": {
                    textWeight = (String)textWeight + " == Leger ==";
                    break;
                }
                case "heavy": {
                    textWeight = (String)textWeight + " == Beaucoup  ==";
                }
            }
        }
        return textWeight;
    }

    public void printPlusTardTickets(int orderId, TicketInfo order, EnteteInfo entete, boolean has_drawer_permission, List<TicketLineInfo> products, List<ProductTicket> subProducts, boolean fondNoir, Decreaser decreaser) {
        String str;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        ticket.addNewLine(0, "Produit diff\u00e9r\u00e9", new Object[0]);
        ticket.addNewLine(0, "Date: " + dateFormatterFull.format(order.getDate()) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        Object str_number_order = "";
        Object prefix = "";
        prefix = order.getNum_order_kitchen() != -1 && order.getNum_order_kitchen() != 0 || !AppLocal.KITCHEN_COMPOSITE ? "Commande N\u00b0" : (String)prefix + "PB connexion N\u00b0";
        str_number_order = (String)prefix + order.getNumberOrderToPrint();
        ticket.addNewLine(0, (String)str_number_order, new Object[0]);
        if (order.getTable() != null) {
            str = "Table N\u00b0 " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        if (order.getBipper() != 0) {
            str = "Bipper\u00b0 " + order.getBipper();
            ticket.align(0, str);
            if (str.length() < TICKET_WIDTH) {
                int numSpace = TICKET_WIDTH - str.length();
                for (int i = 0; i < numSpace; ++i) {
                    ticket.append(" ");
                }
            }
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        this.appendPlafond("  Bon de Commande  ", ticket);
        ticket.blankLine(1);
        String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
        ticket.addNewLine(1, "Vendeur : " + order.getUser().getName() + sId, new Object[0]);
        ticket.blankLine(1);
        if (order.getCustomer() != null) {
            ticket.addNewLine(0, "Client : " + order.getCustomer().getName(), new Object[0]);
        } else if (order.getName_customer() != null && !order.getName_customer().isEmpty()) {
            ticket.addNewLine(1, "Client : " + order.getName_customer(), new Object[0]);
        }
        Collections.sort(products, new Comparator<TicketLineInfo>(){

            @Override
            public int compare(TicketLineInfo s1, TicketLineInfo s2) {
                return s1.getPlace_served().compareToIgnoreCase(s2.getPlace_served());
            }
        });
        TicketLineInfo product0 = null;
        for (TicketLineInfo product : products) {
            ticket.setBoldText(true);
            if (product0 == null) {
                ticket.addNewLine(0, StringUtils.rightPad((String)product.getPlace_served(), (int)TICKET_WIDTH, (String)"_"), new Object[0]);
            } else if (!product.getPlace_served().equals(product0.getPlace_served())) {
                ticket.addNewLine(0, StringUtils.rightPad((String)product.getPlace_served(), (int)TICKET_WIDTH, (String)"_"), new Object[0]);
            }
            ticket.setBoldText(false);
            product0 = product;
            boolean print_able = true;
            if (product.isNext() || !print_able) continue;
            ticket.setTextSize(1, 1);
            this.appendProductPlusTard(product, ticket);
        }
        if (!(subProducts == null || subProducts.isEmpty() || product0 != null && product0.getPlace_served().equalsIgnoreCase("Sur Place"))) {
            ticket.setBoldText(true);
            ticket.addNewLine(0, StringUtils.rightPad((String)"Sur Place", (int)TICKET_WIDTH, (String)"_"), new Object[0]);
            ticket.setBoldText(false);
        }
        for (ProductTicket subProduct : subProducts) {
            ticket.setTextSize(1, 1);
            this.appendSubProductPlusTard(subProduct, ticket);
        }
        ticket.blankLine(1);
        ticket.setTextSize(1, 1);
        if (entete.getFootr() != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getFootr());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        if (has_drawer_permission) {
            PrinterCommand openDrawerCommand = new PrinterCommand.Builder().openDrawer(true).build();
            Ticket ticket1 = new Ticket.Builder().add(openDrawerCommand).build();
            PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket1, "TIROIR CAISSE", "L'ouverture du tiroir caisse a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0" + String.valueOf(orderId), AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private void printLineLater(Ticket2 ticket, TicketInfo order, TicketLineInfo product, PrinterInfo printer, int index, boolean first_part_of_order) {
        boolean printProduct = false;
        ticket.setTextSize(1, 2);
        if (product.getPrinterID() != printer.getId()) {
            for (ProductTicket item : product.getListProducts()) {
                if (item.getPrinterID() != printer.getId()) continue;
                printProduct = true;
                product.setPrinterID(item.getPrinterID());
                break;
            }
        } else {
            printProduct = true;
        }
        if (printProduct) {
            this.addDetailProduct(ticket, order, product, printer, "(" + AppLocal.getIntString("Button.add") + ") ", first_part_of_order, false);
        }
        ++index;
    }

    private void appendLineUpdated(Ticket2 ticket, TicketInfo order, List<TicketLineInfo> productToprint, PrinterInfo printer, boolean fondNoir, boolean isSeparate, boolean later) {
        ticket.blankLine(1);
        int index = 0;
        for (TicketLineInfo product : productToprint) {
            if (!product.isNext()) {
                String full_name_item;
                String str;
                String prefix = "update".equals(product.getTypeUpdate()) ? "(" + AppLocal.getIntString("Button.update") + ")" : "(" + AppLocal.getIntString("Button.add") + ") ";
                ticket.setTextSize(1, 2);
                if (!later && index > 1 && productToprint.get(index - 1).isNext() && productToprint.get(index - 1).getPrinterID() != printer.getId()) {
                    ticket.addNewLine(productToprint.get(index - 1).getNextRetourn(), new Object[0]);
                    ticket.blankLine(2);
                }
                ticket.setTextSize(AppLocal.size_product, 2);
                if (AppLocal.PRODUCT_KITCHEN_BOLD) {
                    ticket.setBoldText(true);
                }
                this.addNameProduit(ticket, product, true, prefix, fondNoir);
                ticket.setTextSize(AppLocal.size_supplement, 2);
                if (product.getPrinterID() == printer.getId()) {
                    this.loadIngredient(product, ticket);
                    for (ItemOrderInfo itemOrderInfo : product.getListIngredients()) {
                        if (itemOrderInfo.getIdProduct() != -1 && itemOrderInfo.getIdProduct() != 0) continue;
                        str = PrinterHelper.formatMax("#### " + AppLocal.getIntString("Label.without") + " " + itemOrderInfo.getNameSupplement() + " ####");
                        ticket.addNewLine(1, str, new Object[0]);
                    }
                    int id_groupe_option = 0;
                    for (OptionItemOrder supplement : product.getListSupplements()) {
                        if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                        if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                            if (id_groupe_option != supplement.getId_groupe_option()) {
                                String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                                ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                            }
                            id_groupe_option = supplement.getId_groupe_option();
                        }
                        this.appendSupplemntKitchen(supplement, ticket);
                    }
                }
                if ("update".equals(product.getTypeUpdate())) {
                    for (ProductTicket productTicket : product.getListDelete()) {
                        full_name_item = productTicket.getNumberProduct() > 1 ? productTicket.getNumberProduct() + " " + productTicket.getNameProduct() : productTicket.getNameProduct();
                        ticket.setTextSize(1, 2);
                        if (productTicket.getPrinterID() != printer.getId()) continue;
                        str = PrinterHelper.formatMax("( " + AppLocal.getIntString("Button.cancel") + " ) " + full_name_item);
                        ticket.addNewLine(1, str, new Object[0]);
                    }
                    for (ProductTicket productTicket : product.getListUpdate()) {
                        full_name_item = productTicket.getNumberProduct() > 1 ? productTicket.getNumberProduct() + " " + productTicket.getNameProduct() : productTicket.getNameProduct();
                        this.addDetailItem("  *" + full_name_item + "(" + AppLocal.getIntString("Button.update") + ") ", ticket, productTicket, printer, isSeparate, product);
                    }
                    for (ProductTicket productTicket : product.getListNew()) {
                        full_name_item = productTicket.getNumberProduct() > 1 ? productTicket.getNumberProduct() + " " + productTicket.getNameProduct() : productTicket.getNameProduct();
                        this.addDetailItem(" " + full_name_item, ticket, productTicket, printer, isSeparate, product);
                    }
                } else {
                    for (ProductTicket productTicket : product.getListProducts()) {
                        full_name_item = productTicket.getNumberProduct() > 1 ? productTicket.getNumberProduct() + " " + productTicket.getNameProduct() : productTicket.getNameProduct();
                        this.addDetailItem(" " + full_name_item, ticket, productTicket, printer, isSeparate, product);
                    }
                }
                ticket.blankLine(1);
                ticket.setTextSize(1, 2);
                if (product.getDescription() != null && !product.getDescription().isEmpty() && !AppLocal.HIDE_DESCRIPTION_PRODUCT_IN_TICKET) {
                    ticket.addNewLine(0, product.getDescription(), new Object[0]);
                }
                if (product.getNote() != null && !product.getNote().isEmpty()) {
                    this.addNote(ticket, product.getNote());
                }
                ticket.setTextSize(1, 2);
                if (!later && index < productToprint.size() - 1 && productToprint.get(index + 1).isNext()) {
                    ticket.addNewLine(productToprint.get(index + 1).getNextRetourn(), new Object[0]);
                    ticket.blankLine(2);
                    productToprint.get(index + 1).setPrinterID(printer.getId());
                }
            }
            ++index;
        }
    }

    private void appendLog(LogPanier line, Ticket2 ticket) {
        int sizeDesignation = TICKET_WIDTH / 2;
        String unit = line.printMultiply();
        String name_product = line.getNameProduct();
        String itemName = this.getName_product(name_product, unit, ticket, sizeDesignation);
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        ticket.addNewLine(3, itemName.toUpperCase(), Formats.CURRENCY_PRINTED.formatValue(line.getPrice()) + " " + StringUtils.leftPad((String)this.timeFormatter.format(line.getDateSuppression()), (int)4));
        ticket.setBoldText(false);
    }

    private void appendOrder(TicketInfo order, Ticket2 ticket, boolean cancelOrder) {
        ticket.addNewLine(3, order.getNumberOrderTorint() + " " + DateUtils.FORMATTER_DATE_HOUR.format(order.getDate()), order.getNameUser() + " " + order.printTotalOrder());
        if (cancelOrder && order.getReason_cancel() != null && !order.getReason_cancel().isEmpty()) {
            ticket.addNewLine(0, "Raison annulation : " + order.getReason_cancel(), new Object[0]);
        }
    }

    private void appendPlafond(String phrase, Ticket2 ticket) {
        ticket.setBoldText(true);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, StringUtils.rightPad((String)"", (int)(phrase.length() + 1), (String)"_"), new Object[0]);
        ticket.setTextSize(1, 2);
        ticket.setUnderline(true);
        ticket.addNewLine(1, "|" + phrase + "|", new Object[0]);
        ticket.setUnderline(false);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
    }

    public void printConsole(List<Integer> bytes) {
        byte[] mesBytes = new byte[bytes.size()];
        int j = 0;
        for (Integer b : bytes) {
            mesBytes[j++] = b.byteValue();
        }
        System.out.println("*********ticket : " + new String(mesBytes));
    }

    public String getOfficialPayement(String payment) {
        System.out.println("payment.toUpperCase() : " + payment.toUpperCase());
        switch (payment.toUpperCase()) {
            case "CB": {
                return AppLocal.getIntString("Text.bluecard").toUpperCase();
            }
            case "TICKET RESTO": {
                return AppConstants.PAYMENT_MODE.TICKET_RESTO.getName().toUpperCase();
            }
            case "ESPECE": {
                return AppLocal.getIntString("Button.cash").toUpperCase();
            }
            case "AVOIR": {
                return AppLocal.getIntString("Label.free").toUpperCase();
            }
            case "CHEQUE": {
                return AppLocal.getIntString("Label.cheque").toUpperCase();
            }
            case "DEBIT": {
                return AppLocal.getIntString("Label.debit").toUpperCase();
            }
            case "CARTE CREDIT": {
                return AppLocal.getIntString("Text.creditcard").toUpperCase();
            }
        }
        return payment;
    }

    public void printLabelKitchen(LineKitchen line, PrinterInfo printer, Decreaser decreaser) throws IOException, FileNotFoundException {
        String status = line.isPaid() ? "PAYEE" : "EN ATTENTE";
        int numProducts = line.getOrder_size();
        int j = line.getNumero_line();
        GenPDF genPDF = new GenPDF();
        if (printer != null) {
            AVAILABLE_WIDTH = TICKET_WIDTH = printer.getWith();
            int z = 0;
            while ((double)z < line.getUnits()) {
                String numLabel = j + "/" + numProducts;
                Object ingredientNames = "";
                String ingredientInclus = "";
                if (AppLocal.printIngredientAtLabel.booleanValue() && line.getIngredientsInclus() != null && !line.getIngredientsInclus().isEmpty()) {
                    ingredientInclus = line.getIngredientsInclus();
                }
                if (AppLocal.printIngredientExclus.booleanValue() && line.getListIngredient().size() > 0) {
                    for (String string : line.getListIngredient()) {
                        ingredientNames = (String)ingredientNames + " _SANS " + string.toUpperCase();
                    }
                }
                Object supplementNames = "";
                if (line.getListSupplement().size() > 0) {
                    for (String supplement : line.getListSupplement()) {
                        supplementNames = (String)supplementNames + " + " + supplement;
                    }
                }
                String string = dateFormatterFull.format(new Date());
                Object productItems = "";
                for (ItemLine item : line.getItems()) {
                    productItems = (String)productItems + " + " + item.getProduct();
                }
                Object commentaire = "";
                if (line.getNote() != null && !line.getNote().isEmpty()) {
                    commentaire = "\n(NB: " + line.getNote() + ")";
                }
                String options = ingredientInclus + (String)ingredientNames + (String)supplementNames + (String)productItems + (String)commentaire;
                for (int i = 0; i < printer.getNumber(); ++i) {
                    Object bipper = "";
                    if (line.getBipper() != 0) {
                        bipper = "BIP " + line.getBipper();
                    }
                    try {
                        boolean doCut = false;
                        if ((double)z == line.getUnits() - 1.0) {
                            doCut = true;
                        }
                        String dateAndBipperOrPlusTard = string;
                        if (line.getAfterSeparator().contains("Emporter plus tard")) {
                            dateAndBipperOrPlusTard = "Emporter plus tard";
                        }
                        String orderNum = line.getCaisse() != null ? line.getCaisse() + line.getNum_order() : String.valueOf(line.getNum_order());
                        String productSizeAndName = line.getProduct() + (String)(line.getSize_product() != null ? " - " + line.getSize_product() : "");
                        genPDF.generateLabelPdf(printer, printer.getIp(), printer.getNamePrinter(), line.getPlace_served(), "N\u00b0" + orderNum, productSizeAndName, numLabel, options, dateAndBipperOrPlusTard, status, doCut, (String)bipper, decreaser, 1);
                        continue;
                    }
                    catch (Exception ex) {
                        try {
                            Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "L'impression de l'etiquette", new Date().getTime(), ""));
                        }
                        catch (IOException ext) {
                            LogToFile.log("severe", null, ext);
                        }
                        LogToFile.log("severe", null, ex);
                    }
                }
                ++j;
                ++z;
            }
        }
    }

    public synchronized void printLabel(TicketInfo order, LinkedHashMap<Integer, List<ZoneItemsLabel>> zoneItemsLabelByPrinter, String status, List<PrinterInfo> printers, Decreaser decreaser) throws IOException, FileNotFoundException {
        System.out.println("*********printLabel() ");
        int numItemsToPrint = 0;
        for (PrinterInfo printer : printers) {
            List<ZoneItemsLabel> zoneItemsLabel = zoneItemsLabelByPrinter != null ? zoneItemsLabelByPrinter.get(printer.getId()) : null;
            if (zoneItemsLabel == null) continue;
            for (ZoneItemsLabel zoneItemLabel : zoneItemsLabel) {
                if (zoneItemLabel == null || zoneItemLabel.getItemsLabel() == null) continue;
                for (ItemLabel itemLabel : zoneItemLabel.getItemsLabel()) {
                    numItemsToPrint = (int)((double)numItemsToPrint + itemLabel.getQuantity());
                }
            }
        }
        GenPDF genPDF = new GenPDF();
        int indexLabel = 1;
        String date = dateFormatterFull.format(new Date());
        for (PrinterInfo printer : printers) {
            boolean printerNormal = printer.getModel() != null && printer.getModel().equals("Normal");
            List<ZoneItemsLabel> zoneItemsLabel = zoneItemsLabelByPrinter != null ? zoneItemsLabelByPrinter.get(printer.getId()) : null;
            if (zoneItemsLabel == null) continue;
            int index = 0;
            int numberItemsByPrinter = 0;
            for (ZoneItemsLabel zoneItemLabel : zoneItemsLabel) {
                if (zoneItemLabel == null || zoneItemLabel.getItemsLabel() == null) continue;
                numberItemsByPrinter += zoneItemLabel.getItemsLabel().size();
            }
            for (ZoneItemsLabel zoneItemLabel : zoneItemsLabel) {
                for (ItemLabel itemLabel : zoneItemLabel.getItemsLabel()) {
                    ++index;
                    if (printerNormal) {
                        this.printLabelNormal(order, itemLabel, printer, indexLabel, numItemsToPrint, decreaser);
                    } else {
                        boolean lastElement = index == numberItemsByPrinter;
                        this.printLabel(itemLabel, printer, indexLabel, numItemsToPrint, date, lastElement, genPDF, decreaser);
                    }
                    indexLabel = (int)((double)indexLabel + itemLabel.getQuantity());
                }
            }
        }
    }

    private String getName_product(String name_product, String unit, Ticket2 ticket, int sizeDesignation) {
        Object itemName;
        int sizeQuantity = 3;
        if (name_product.length() > sizeDesignation) {
            List<String> chaines = this.getLines_separate(name_product, sizeDesignation, 0);
            for (int j = 0; j < chaines.size() - 1; ++j) {
                String ligne = chaines.get(j);
                itemName = j == 0 ? ticket.formatMax(StringUtils.rightPad((String)unit, (int)sizeQuantity) + ligne) : StringUtils.rightPad((String)"", (int)sizeQuantity) + ligne;
                ++this.nombreLignesInCammande;
                ticket.setBoldText(true);
                ticket.addNewLine(0, ((String)itemName).toUpperCase(), new Object[0]);
                ticket.setBoldText(false);
            }
            String ligne = chaines.get(chaines.size() - 1);
            itemName = StringUtils.rightPad((String)"", (int)sizeQuantity) + ligne;
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)unit, (int)sizeQuantity) + name_product);
        }
        return itemName;
    }

    private void appendHeader_Marque(Ticket2 ticket, MarqueNFC marqueNF) {
        if (marqueNF != null) {
            if (marqueNF.getCompany() != null) {
                ticket.setTextSize(1, 2);
                ticket.addNewLine(1, marqueNF.getCompany(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            if (marqueNF.getAdresse1() != null) {
                ticket.addNewLine(1, marqueNF.getAdresse1(), new Object[0]);
            }
            if (marqueNF.getZipCode() != null && marqueNF.getCity() != null) {
                ticket.addNewLine(1, marqueNF.getZipCode() + " " + marqueNF.getCity(), new Object[0]);
            }
            if (!AppLocal.IS_MOROCCAN_CUSTOMER.booleanValue()) {
                if (marqueNF.getSiret() != null) {
                    ticket.addNewLine(1, "Siret : " + marqueNF.getSiret(), new Object[0]);
                }
                if (marqueNF.getIntraTVA() != null) {
                    ticket.addNewLine(1, "TVA intra : " + marqueNF.getIntraTVA(), new Object[0]);
                }
            }
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty()) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.phone") + " : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        if (AppLocal.header != null) {
            ticket.addNewLine(1, AppLocal.header, new Object[0]);
        }
    }

    private void appendHeader(Ticket2 ticket, EnteteInfo entete) {
        if (entete != null) {
            if (entete.getCompany() != null && !entete.getCompany().isEmpty()) {
                ticket.setTextSize(1, 2);
                ticket.addNewLine(1, entete.getCompany(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            if (entete.getAddress() != null && !entete.getAddress().isEmpty()) {
                ticket.addNewLine(1, entete.getAddress(), new Object[0]);
            }
            if (entete.getZipCode() != null && !entete.getZipCode().isEmpty() && entete.getCity() != null && !entete.getCity().isEmpty()) {
                ticket.addNewLine(1, entete.getZipCode() + " " + entete.getCity(), new Object[0]);
            }
            if (entete.getCountry() != null && !entete.getCountry().isEmpty()) {
                ticket.addNewLine(1, AppLocal.getIntString("Label.country") + " : " + entete.getCountry(), new Object[0]);
            }
            if (!AppLocal.IS_MOROCCAN_CUSTOMER.booleanValue()) {
                if (entete.getCodeNAF() != null && !entete.getCodeNAF().isEmpty()) {
                    ticket.addNewLine(1, "Code NAF : " + entete.getCodeNAF(), new Object[0]);
                }
                if (entete.getSiret() != null && !entete.getSiret().isEmpty()) {
                    ticket.addNewLine(1, "Siret : " + entete.getSiret(), new Object[0]);
                }
                if (entete.getTvaIntra() != null && !entete.getTvaIntra().isEmpty()) {
                    ticket.addNewLine(1, "TVA intra : " + entete.getTvaIntra(), new Object[0]);
                }
            }
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.phone") + ": " + AppLocal.phoneRestaurant, new Object[0]);
        }
        if (entete.getHeader() != null && !entete.getHeader().isEmpty()) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getHeader());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        ticket.blankLine(1);
    }

    private List<String> getLines_separate(String name_product, int sizeDesignation, int prefix) {
        return this.getLines_separate(name_product, sizeDesignation, prefix, 1);
    }

    private List<String> getLines_separate(String name_product, int sizeDesignation, int prefix, int width_by_char) {
        String[] tab_chaines = name_product.split(" ");
        ArrayList<String> chaines = new ArrayList<String>();
        Object chaine_tmp = "";
        for (String chaine : tab_chaines) {
            if (chaine.length() * width_by_char + ((String)chaine_tmp).length() * width_by_char + 1 + prefix <= sizeDesignation) {
                chaine_tmp = (String)chaine_tmp + chaine + " ";
                continue;
            }
            String string_to_add = chaine_tmp;
            string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
            chaines.add(string_to_add);
            chaine_tmp = chaine + " ";
        }
        String string_to_add = chaine_tmp;
        string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
        chaines.add(string_to_add);
        return chaines;
    }

    private String getName_Supplement(String name_option, Ticket2 ticket, int sizeDesignation, int prefix, String numberOptions) {
        Object itemName;
        if (name_option.length() > sizeDesignation) {
            List<String> chaines = this.getLines_separate(name_option, sizeDesignation, prefix);
            for (int i = 0; i < chaines.size() - 1; ++i) {
                String ligne = chaines.get(i);
                itemName = i == 0 ? ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)(4 + prefix)) + ligne) : StringUtils.rightPad((String)"", (int)(4 + prefix)) + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            String ligne = chaines.get(chaines.size() - 1);
            itemName = StringUtils.rightPad((String)"", (int)(4 + prefix)) + ligne;
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)numberOptions, (int)(4 + prefix)) + name_option);
        }
        return itemName;
    }

    private String getName_Item(String name_item, Ticket2 ticket, String numberItems, int sizeDesignation) {
        Object itemName;
        int sizeQuantity = 3;
        int sizeQuantityItem = 5;
        if (name_item.length() > sizeDesignation) {
            List<String> chaines = this.getLines_separate(name_item, sizeDesignation, 2);
            for (int i = 0; i < chaines.size() - 1; ++i) {
                String ligne = chaines.get(i);
                itemName = i == 0 ? ticket.formatMax(StringUtils.rightPad((String)numberItems, (int)sizeQuantity) + "--" + ligne) : ticket.formatMax(StringUtils.rightPad((String)"", (int)sizeQuantityItem) + ligne);
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            String ligne = chaines.get(chaines.size() - 1);
            itemName = StringUtils.rightPad((String)"", (int)sizeQuantityItem) + ligne;
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)numberItems, (int)4) + "--" + name_item);
        }
        return itemName;
    }

    public void printTBPayed(String num_order) {
        Ticket2 ticket = new Ticket2(this.printerCaisse.getWith(), this.printerCaisse.getWith());
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, "Commande N\u00b0 " + num_order, new Object[0]);
        ticket.blankLine(2);
        ticket.addNewLine(1, "Commande pay\u00e9e", new Object[0]);
        ticket.blankLine(4);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(2, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(ticket, "Commande n\u00b0" + num_order, "L'impression du ticket cuisine a \u00e9chou\u00e9.", this.printerCaisse, null);
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY_PRINTED.formatValue(price);
        }
        return "";
    }

    public String printMultiply(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    private void addColumnCourse(String str, double width, Ticket2 ticket) {
        ticket.align(0, str);
        if ((double)str.length() < (double)TICKET_WIDTH * width) {
            int numSpace = (int)((double)TICKET_WIDTH * width) - str.length();
            for (int h = 0; h < numSpace; ++h) {
                ticket.append(" ");
            }
        }
    }

    private void appendCourse(Course course, Ticket2 ticket) {
        String itemName;
        int sizeDesignation = (int)((double)TICKET_WIDTH * 0.3);
        if (course.getProduct().length() > sizeDesignation) {
            String ligne;
            List<String> chaines = this.getLines_separate(course.getProduct(), sizeDesignation, 0);
            for (int j = 0; j < chaines.size() - 1; ++j) {
                String ligne2 = chaines.get(j);
                this.addColumnCourse(ligne2, 0.3, ticket);
                this.addColumnCourse(ligne2, 0.7, ticket);
                ticket.blankLine(1);
            }
            itemName = ligne = chaines.get(chaines.size() - 1);
        } else {
            itemName = course.getProduct();
        }
        this.addColumnCourse(itemName, 0.3, ticket);
        this.addColumnCourse(this.printPrice(course.getPrice()), 0.2, ticket);
        this.addColumnCourse(this.timeFormatter.format(course.getCreated()), 0.2, ticket);
        if (course.getUser() != null) {
            this.addColumnCourse(course.getUser().getName(), 0.3, ticket);
        } else {
            this.addColumnCourse("", 0.2, ticket);
        }
        ticket.blankLine(1);
    }

    private boolean existLines(PrinterInfo printer, List<TicketLineInfo> products) {
        boolean printProduct = false;
        block0: for (TicketLineInfo product : products) {
            if (product.getPrinterID() != printer.getId()) {
                if (product.getListProducts() != null) {
                    for (ProductTicket item : product.getListProducts()) {
                        if (item.getPrinterID() != printer.getId()) continue;
                        printProduct = true;
                        product.setPrinterID(item.getPrinterID());
                        break;
                    }
                }
                if (product.getListNew() != null) {
                    for (ProductTicket item : product.getListNew()) {
                        if (item.getPrinterID() != printer.getId()) continue;
                        printProduct = true;
                        product.setPrinterID(item.getPrinterID());
                        break;
                    }
                }
                if (product.getListUpdate() != null) {
                    for (ProductTicket item : product.getListUpdate()) {
                        if (item.getPrinterID() != printer.getId()) continue;
                        printProduct = true;
                        product.setPrinterID(item.getPrinterID());
                        break;
                    }
                }
                if (product.getListDelete() == null) continue;
                for (ProductTicket item : product.getListDelete()) {
                    if (item.getPrinterID() != printer.getId()) continue;
                    printProduct = true;
                    product.setPrinterID(item.getPrinterID());
                    continue block0;
                }
                continue;
            }
            printProduct = true;
        }
        return printProduct;
    }

    public void printKitchenTicketCanceld(TicketInfo order, List<PrinterInfo> printers, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter, boolean displayNumOrder, boolean displayServeur, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        String orderNum = this.getNumOrder(order);
        for (PrinterInfo printer : printers) {
            List<ZoneLines> zoneLines = zoneLinesByPrinter != null ? zoneLinesByPrinter.get(printer.getId()) : null;
            if (zoneLines == null || zoneLines.isEmpty()) continue;
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, String.format("Ticket %d/%d", j, numPrinters), new Object[0]);
            ticket.addNewLine(1, AppLocal.getIntString("Text.cancel.order") + " " + orderNum, new Object[0]);
            if (displayServeur && order.getUser() != null) {
                ticket.addNewLine(1, AppLocal.getIntString("Label.server") + " " + order.getUser().getName(), new Object[0]);
            }
            if (order.getSource_order() != null) {
                ticket.addNewLine(1, AppLocal.getIntString("Label.source") + " " + order.getSource_order(), new Object[0]);
            }
            ticket.blankLine(1);
            this.addBloc(ticket, order);
            for (ZoneLines zoneLine : zoneLines) {
                int numberZones = zoneLines.size();
                if (zoneLine.getLines() == null || zoneLine.getLines().isEmpty()) continue;
                this.addNameZone(numberZones, zoneLine, ticket);
                ticket.setTextSize(1, 2);
                for (TicketLineInfo product : zoneLine.getLines()) {
                    String str = PrinterHelper.formatMax("( " + AppLocal.getIntString("Button.cancel") + " ) " + product.printName());
                    ticket.addNewLine(1, str, new Object[0]);
                }
            }
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
            ticket.blankLine(5);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
            mesBytesInteger.addAll(ticket.bytes);
            for (int h = 1; h < printer.getNumber(); ++h) {
                ticket.bytes.addAll(mesBytesInteger);
            }
            this.printConsole(ticket.bytes);
            PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket.kitchen"), printer.getPort(), printer.getBand_rate(), printer, decreaser, false);
            ++j;
        }
    }

    public void printOptions(TicketInfo order, List<PrinterInfo> printers, List<OptionItemOrder> options, boolean fondNoir, Decreaser decreaser) {
        int numPrinters = printers.size();
        int j = 1;
        for (PrinterInfo printer : printers) {
            TICKET_WIDTH = printer.getWith();
            AVAILABLE_WIDTH = printer.getWith();
            Ticket2 ticket = new Ticket2(printer.getWith(), printer.getWith());
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, String.format("Ticket %d/%d", j, numPrinters), new Object[0]);
            if (order.getNum_order_borne() != null) {
                ticket.addNewLine(1, "Commande " + order.getNum_order_borne(), new Object[0]);
            } else {
                ticket.addNewLine(1, "Commande " + order.getNumero_order(), new Object[0]);
            }
            ticket.blankLine(1);
            for (OptionItemOrder option : options) {
                if (option.getPrinter() != printer.getId()) continue;
                this.addNameOption(ticket, option);
                ticket.setReversedText(false);
                ticket.blankLine(2);
            }
            ticket.blankLine(2);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
            ticket.blankLine(5);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
            mesBytesInteger.addAll(ticket.bytes);
            for (int h = 1; h < printer.getNumber(); ++h) {
                ticket.bytes.addAll(mesBytesInteger);
            }
            PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), "L'impression du ticket cuisine a \u00e9chou\u00e9.", printer.getPort(), printer.getBand_rate(), printer, decreaser);
            ++j;
        }
    }

    private void addNameOption(Ticket2 ticket, OptionItemOrder supplement) {
        Object str_option;
        Object prefix = " ";
        String space = this.getPrefixSpace(supplement.getShift_option(), false);
        prefix = space + (String)prefix;
        int width_by_char = 1;
        String name_option = (int)(supplement.getQuantity_product() * (double)supplement.getNumberOption()) + " X " + supplement.printName(true);
        Object str = PrinterHelper.formatMax(name_option);
        str = (String)str + this.loadWeightOption(supplement);
        ticket.align(0, (String)prefix);
        if (supplement.getIsBold().booleanValue()) {
            ticket.setBoldText(true);
            width_by_char = 2;
            ticket.setTextSize(2, 2);
        } else {
            ticket.setTextSize(1, 2);
        }
        Object object = str_option = AppLocal.UPPERCASE_KITCHEN_TICKET ? ((String)str).toUpperCase() : str;
        if (supplement.isPrint_black_background()) {
            ticket.setReversedText(true);
            str_option = AppLocal.UPPERCASE_KITCHEN_TICKET ? " " + ((String)str).toUpperCase() + " " : " " + (String)str + " ";
        }
        ticket.align(0, (String)str_option);
        ticket.setReversedText(false);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        if (((String)str_option).length() + ((String)prefix).length() < TICKET_WIDTH) {
            int numSpace = TICKET_WIDTH - ((String)str_option).length() * width_by_char - ((String)prefix).length();
            for (int h = 0; h < numSpace; ++h) {
                ticket.append(" ");
            }
        }
        ticket.setReversedText(false);
    }

    private void appendSupplemntKitchen(OptionItemOrder supplement, Ticket2 ticket) {
        this.appendSupplemntKitchen(supplement, ticket, false);
    }

    private void appendSupplemntKitchen(OptionItemOrder supplement, Ticket2 ticket, boolean recap) {
        Object name_option;
        String name;
        Object prefix = " ";
        String space = this.getPrefixSpace(supplement.getShift_option(), true);
        System.out.println("space : " + space);
        prefix = space + (String)prefix;
        System.out.println("prefix.length() 0 : " + ((String)prefix).length());
        int width_by_char = 1;
        int number_iteration = 1;
        StringBuilder textByLangaugeBuilder = new StringBuilder();
        if (AppLocal.PRINT_ARABIC) {
            String arabic_name = supplement.getNameByLanguage("ar");
            String english_name = supplement.getNameByLanguage("en");
            if (english_name != null && !english_name.isEmpty()) {
                textByLangaugeBuilder.append(english_name);
                if (arabic_name != null && !arabic_name.isEmpty()) {
                    textByLangaugeBuilder.append("(");
                }
            }
            if (arabic_name != null && !arabic_name.isEmpty()) {
                textByLangaugeBuilder.append(this.textAfterCheckLanguage(arabic_name));
            }
            if (english_name != null && !english_name.isEmpty()) {
                textByLangaugeBuilder.append(english_name);
                if (arabic_name != null && !arabic_name.isEmpty()) {
                    textByLangaugeBuilder.append(")");
                }
            }
        }
        String string = name = textByLangaugeBuilder.toString().isEmpty() ? supplement.printName(true) : textByLangaugeBuilder.toString();
        if (!AppLocal.DEACTIVE_QUANTITY && !AppLocal.SEPARATE_OPTION && supplement.getNumberOption() > 1) {
            name_option = supplement.getNumberOption() + " " + name;
        } else {
            number_iteration = supplement.getNumberOption();
            name_option = name;
        }
        for (int i = 0; i < number_iteration; ++i) {
            Object str_option;
            Object str = PrinterHelper.formatMax((String)name_option);
            str = (String)str + this.loadWeightOption(supplement);
            ticket.align(0, (String)prefix);
            if (supplement.getIsBold().booleanValue()) {
                ticket.setBoldText(true);
                width_by_char = 2;
                ticket.setTextSize(2, 2);
            } else {
                ticket.setTextSize(1, 2);
            }
            Object object = str_option = AppLocal.UPPERCASE_KITCHEN_TICKET ? ((String)str).toUpperCase() : str;
            if (supplement.getIsBold().booleanValue() && recap || supplement.isPrint_black_background()) {
                ticket.setReversedText(true);
                str_option = AppLocal.UPPERCASE_KITCHEN_TICKET ? " " + ((String)str).toUpperCase() + " " : " " + (String)str + " ";
            }
            str_option = ((String)str_option).trim();
            String[] nameOptionArray = ((String)str_option).split(" ");
            StringBuilder nameOptionBuilder = new StringBuilder();
            ArrayList<String> textsValid = new ArrayList<String>();
            int lastLineWidth = ((String)prefix).length();
            for (int j = 0; j < nameOptionArray.length; ++j) {
                System.out.println("nameOptionArray[j] : " + nameOptionArray[j]);
                if (!this.isTextValid(nameOptionArray[j])) continue;
                System.out.println("valid");
                textsValid.add(nameOptionArray[j]);
            }
            int index = 0;
            for (String textValid : textsValid) {
                Object text = "";
                text = index == textsValid.size() - 1 ? textValid : textValid + " ";
                nameOptionBuilder.append((String)text);
                int lenghtText = ((String)text).length() * width_by_char;
                lastLineWidth = lastLineWidth + lenghtText <= TICKET_WIDTH ? (lastLineWidth += lenghtText) : lenghtText;
                ++index;
            }
            str_option = nameOptionBuilder.toString();
            ticket.align(0, (String)str_option);
            ticket.setReversedText(false);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            if (lastLineWidth < TICKET_WIDTH) {
                ticket.setReversedText(false);
                ticket.blankLine(1);
            }
            ticket.setReversedText(false);
        }
    }

    public void printTikcetSansDetail(TicketInfo order, EnteteInfo entete, Decreaser decreaser, int couverts, DuplicataJustificatifPayment duplicataJustificatifPayment, JustificatifPayment mJustificatifPayment) {
        String signature;
        double discount_global;
        Date dateJustificatifPayment;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        if (TicketUtils.getPicTicket() != null) {
            ticket.blankLine(1);
            ticket.setAlign(1);
            ticket.addImageTicket(TicketUtils.getPicTicket());
            ticket.blankLine(1);
        }
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        if (entete != null && entete.getHeader() != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getHeader());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.phone") + " : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        if (duplicataJustificatifPayment != null) {
            ticket.addNewLine(1, "DUPLICATA JUSTIFICATIF DE PAIEMENT", new Object[0]);
        }
        ticket.addNewLine(1, "Ticket N\u00b0" + entete.getId() + " Caisse " + entete.getCode_caisse(), new Object[0]);
        Date date = dateJustificatifPayment = duplicataJustificatifPayment != null ? duplicataJustificatifPayment.getDate_impression() : mJustificatifPayment.getTimestampGDH();
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, dateFormatterFull.format(dateJustificatifPayment), new Object[0]);
        } else {
            ticket.addNewLine(1, dateFormatterFull.format(dateJustificatifPayment) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        }
        if (order.getTable() != null) {
            String str = AppLocal.getIntString("Label.num.table") + " " + order.getTable().getNumber();
            ticket.addNewLine(1, str, new Object[0]);
        }
        String sId = order.getUser().getCounter() > 0 ? "(" + order.getUser().getCounter() + ")" : "";
        ticket.addNewLine(1, AppLocal.getIntString("Text.seller") + " : " + order.getUser().getName() + sId, new Object[0]);
        this.checkAndShowInfoCustomer(order, ticket, 1);
        if (order.getBipper() != 0 && !AppLocal.bloc_bipper.booleanValue()) {
            String str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
            ticket.align(0, str);
            if (str.length() < TICKET_WIDTH) {
                int numSpace = TICKET_WIDTH - str.length();
                for (int i = 0; i < numSpace; ++i) {
                    ticket.append(" ");
                }
            }
            ticket.blankLine(1);
        }
        ticket.setBoldText(false);
        if (order.getStatus().equalsIgnoreCase("cancel")) {
            ticket.addNewLine(1, "----" + AppLocal.getIntString("Text.canceled").toUpperCase() + "----", new Object[0]);
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.addNewLine(3, AppLocal.getIntString("Text.designation"), StringUtils.center((String)"TOTAL", (int)8) + StringUtils.center((String)AppLocal.getIntString("Text.tva"), (int)4));
        ticket.addLineOfDashes();
        for (TaxLineInfo taxe : order.getTaxes()) {
            this.appendProductToTicketSensDetails(AppLocal.getIntString("Text.offre.formule") + (String)(couverts != 0 ? " x " + couverts : ""), taxe.getSumTTC(), "" + Integer.valueOf(taxe.getId()), ticket);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, AppLocal.getIntString("Text.nb.articles") + " : " + order.getNbrArticles(), new Object[0]);
        ticket.addNewLine(3, "TVA        Mt.TVA", "Base HT   Base TTC");
        double mtTva = 0.0;
        double baseHT = 0.0;
        double baseTTC = 0.0;
        for (TaxLineInfo taxe : order.getTaxes()) {
            Object name = taxe.getName();
            if (((String)name).length() == 3) {
                name = (String)name + " ";
            }
            int nmbSpce = 11 - taxe.printSumTTC().length();
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append((String)(order.getTotal() > 0.0 ? taxe.printSumHT() : "-" + taxe.printSumHT()));
            for (int i = 0; i < nmbSpce; ++i) {
                stringBuilder.append(" ");
            }
            ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + "   " + (String)(order.getTotal() > 0.0 ? taxe.printAmount() : "-" + taxe.printAmount()), stringBuilder.toString() + (String)(order.getTotal() > 0.0 ? taxe.printSumTTC() : "-" + taxe.printSumTTC()));
            mtTva += taxe.getAmount();
            baseHT += taxe.getSumHT();
            baseTTC += taxe.getSumTTC();
        }
        int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
        StringBuilder stringTotal = new StringBuilder("");
        stringTotal.append((String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseHT) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseHT)));
        for (int i = 0; i < nmbSpce; ++i) {
            stringTotal.append(" ");
        }
        ticket.addNewLine(3, "Total" + (order.getTotal() > 0.0 ? "      " : "     -") + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + (String)(order.getTotal() > 0.0 ? TaxLineInfo.printThisDoubleAsAmount(baseTTC) : "-" + TaxLineInfo.printThisDoubleAsAmount(baseTTC)));
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Total T.T.C. ", order.printTotalOrder());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.isPaid() && (discount_global = order.getGlobalDiscount()) > 0.0) {
            ticket.addNewLine(3, "Total remise articles", Formats.CURRENCY.formatValue(-Math.abs(discount_global)));
        }
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().equalsIgnoreCase("pourcentage")) {
                ticket.addNewLine(3, AppLocal.getIntString("Text.discount"), TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getRealTotal() / 100.0)));
            } else {
                ticket.addNewLine(3, AppLocal.getIntString("Text.discount"), TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        if (order.isPaid()) {
            boolean isFirst = true;
            boolean isNegative = false;
            if (order.getTotalOrder() < 0.0) {
                ticket.addNewLine(1, "----" + AppLocal.getIntString("Text.refund") + "----", new Object[0]);
                isNegative = true;
            } else if (order.getTotalOrder() >= 0.0) {
                ticket.addNewLine(1, AppLocal.getIntString("Text.mode.payment"), new Object[0]);
            }
            for (PaymentInfo payment : order.getPayments()) {
                if (!isNegative) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
                renduMonnaie += payment.getTendered() - payment.getTotal();
            }
            if (isNegative) {
                ticket.addNewLine(3, AppConstants.PAYMENT_MODE.CASH.getName(), order.printTotalOrder());
            }
            renduMonnaie = NumericUtils.round(renduMonnaie);
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0 && order.getTotalOrder() > 0.0) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, AppLocal.getIntString("Text.currency.return") + ": " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    ticket.addNewLine(3, AppLocal.getIntString("Text.rendering") + " " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
        }
        ticket.blankLine(1);
        ticket.addNewLine(1, "JUSTIFICATIF PAIEMENT", new Object[0]);
        ticket.addNewLine(1, "NON VALABLE POUR ENCAISSEMENT", new Object[0]);
        ticket.blankLine(1);
        ticket.setBoldText(true);
        String string = signature = duplicataJustificatifPayment != null ? duplicataJustificatifPayment.getSignature() : mJustificatifPayment.getSignature();
        if (signature != null && !signature.isEmpty()) {
            this.setIdentificationLogiciel(ticket, signature, entete.getVersionSoft(), entete.getName_soft());
        }
        ticket.addNewLine(1, AppLocal.getIntString("Text.type.operation") + " : " + entete.getTypeOperation().toUpperCase(), new Object[0]);
        if (duplicataJustificatifPayment != null) {
            ticket.addNewLine(1, "R\u00e9impression N\u00b0" + duplicataJustificatifPayment.getImpression_number() + " - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, "Impression N\u00b01  - " + this.nombreLignesInCammande + " " + AppLocal.getIntString("Text.line") + "(s)", new Object[0]);
        }
        if (mJustificatifPayment != null) {
            ticket.addNewLine(1, "J" + mJustificatifPayment.getId(), new Object[0]);
        } else {
            ticket.addNewLine(1, "J" + (duplicataJustificatifPayment.getmJustificatifPayment() != null ? duplicataJustificatifPayment.getmJustificatifPayment().getId() : duplicataJustificatifPayment.getNum_justificatif_payment()), new Object[0]);
        }
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        ticket.blankLine(1);
        if (order.getBipper() != 0 && AppLocal.bloc_bipper.booleanValue()) {
            String str = AppLocal.getIntString("Label.bipper") + "\u00b0 " + order.getBipper();
            this.addTextBloc(ticket, str);
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Ticket n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.payment.receipt"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private void appendProductToTicketSensDetails(String name, double totalTTC, String taxeName, Ticket2 ticket) {
        ++this.nombreLignesInCammande;
        ticket.addNewLine(3, name, StringUtils.center((String)Formats.CURRENCY_PRINTED.formatValue(totalTTC), (int)8) + StringUtils.center((String)taxeName, (int)4));
    }

    private void checkAndShowInfoCustomer(TicketInfo order, Ticket2 ticket, int align) {
        boolean validPrintInfoCustomer = this.isValidPrintInfosCustomer(order);
        boolean printAllCustomerInfo = validPrintInfoCustomer && order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("outside") && order.getSent_from() != null && !order.getSent_from().equalsIgnoreCase("caisse") || order.getType() != null && !order.getType().equalsIgnoreCase("Sur Place");
        ticket.setReversedText(true);
        ticket.setTextSize(2, 2);
        if (order.getCustomer() == null && order.getName_customer() != null && !order.getName_customer().isEmpty()) {
            ticket.addNewLine(1, AppLocal.getIntString("Label.client") + " : " + order.getName_customer(), new Object[0]);
        }
        if (order.getCustomer() != null && order.getCustomer().getName() != null && !order.getCustomer().getName().isEmpty()) {
            ticket.addNewLine(align, this.textAfterCheckLanguage(AppLocal.getIntString("Label.client") + " : " + order.getCustomer().getName()), new Object[0]);
        }
        if (printAllCustomerInfo) {
            if (order.getCustomer() != null && order.getCustomer().getPhone() != null && !order.getCustomer().getPhone().isEmpty()) {
                ticket.addNewLine(align, this.textAfterCheckLanguage(AppLocal.getIntString("Label.phone") + " : " + order.getCustomer().printPhone()), new Object[0]);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty() && order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
                ticket.addNewLine(align, AppLocal.getIntString("Text.batiment") + " :" + order.getAddressInfo().getBatiment() + ", " + AppLocal.getIntString("Text.interphone") + " : " + order.getAddressInfo().getInterphone(), new Object[0]);
            } else {
                if (order.getAddressInfo() != null && order.getAddressInfo().getBatiment() != null && !order.getAddressInfo().getBatiment().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.batiment") + " :" + order.getAddressInfo().getBatiment(), new Object[0]);
                }
                if (order.getAddressInfo() != null && order.getAddressInfo().getInterphone() != null && !order.getAddressInfo().getInterphone().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.interphone") + " : " + order.getAddressInfo().getInterphone(), new Object[0]);
                }
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty() && order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
                ticket.addNewLine(align, AppLocal.getIntString("Text.codeEntree") + " : " + order.getAddressInfo().getEntrycode() + ", " + AppLocal.getIntString("Text.escalier") + " :" + order.getAddressInfo().getEscalier(), new Object[0]);
            } else {
                if (order.getAddressInfo() != null && order.getAddressInfo().getEscalier() != null && !order.getAddressInfo().getEscalier().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.escalier") + " : " + order.getAddressInfo().getEscalier(), new Object[0]);
                }
                if (order.getAddressInfo() != null && order.getAddressInfo().getEntrycode() != null && !order.getAddressInfo().getEntrycode().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.codeEntree") + " : " + order.getAddressInfo().getEntrycode(), new Object[0]);
                }
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty() && order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
                ticket.addNewLine(align, AppLocal.getIntString("Text.etage") + " :" + order.getAddressInfo().getEtage() + ", " + AppLocal.getIntString("Text.appartement") + " :" + order.getAddressInfo().getAppartement(), new Object[0]);
            } else {
                if (order.getAddressInfo() != null && order.getAddressInfo().getEtage() != null && !order.getAddressInfo().getEtage().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.etage") + " :" + order.getAddressInfo().getEtage(), new Object[0]);
                }
                if (order.getAddressInfo() != null && order.getAddressInfo().getAppartement() != null && !order.getAddressInfo().getAppartement().isEmpty()) {
                    ticket.addNewLine(align, AppLocal.getIntString("Text.appartement") + " :" + order.getAddressInfo().getAppartement(), new Object[0]);
                }
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getAddress() != null && !order.getAddressInfo().getAddress().isEmpty()) {
                ticket.addNewLine(align, order.getAddressInfo().getAddress(), new Object[0]);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getCity() != null && !order.getAddressInfo().getCity().isEmpty() && order.getAddressInfo().getZipcode() != null && !order.getAddressInfo().getZipcode().isEmpty()) {
                ticket.addNewLine(align, order.getAddressInfo().getZipcode() + " " + order.getAddressInfo().getCity(), new Object[0]);
            }
            if (order.getAddressInfo() != null && order.getAddressInfo().getRemarque() != null && !order.getAddressInfo().getRemarque().isEmpty()) {
                ticket.addNewLine(align, order.getAddressInfo().getRemarque(), new Object[0]);
            }
            if (order.getLivreur() != null && order.getLivreur().getName() != null && !order.getLivreur().getName().isEmpty()) {
                ticket.addNewLine(0, AppLocal.getIntString("Text.name.delivery") + " : " + order.getLivreur().getName(), new Object[0]);
            }
        }
        ticket.setTextSize(1, 1);
        ticket.setReversedText(false);
        ticket.blankLine(1);
    }

    private void appendItemTofacture(ProductTicket product, Ticket2 ticket, TaxInfo taxe, TicketLineInfo ticketline, boolean canceled) {
        Object itemName;
        String prefix_sign = canceled ? "-" : "";
        int width_price = (TICKET_WIDTH - 17) / 3;
        int sizeDesignation = TICKET_WIDTH - 17;
        int numberItem = product.getNumberProduct();
        int quantity = (int)((double)numberItem * ticketline.getMultiply());
        if (product.getNameProduct().length() > sizeDesignation) {
            int nbrLignofProduct = product.getNameProduct().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = product.getNameProduct().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(quantity + (("" + quantity).length() < 2 ? " " : "") + " --" + ligne) : "   " + ligne;
                ++this.nombreLignesInCammande;
                ticket.addNewLine(0, (String)itemName, new Object[0]);
            }
            itemName = "    " + product.getNameProduct().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(quantity + (("" + quantity).length() < 2 ? " " : "") + "  --" + product.getNameProduct());
        }
        ++this.nombreLignesInCammande;
        ticket.addNewLine(0, (String)itemName, new Object[0]);
        if (product.getPriceProduct() != 0.0) {
            ++this.nombreLignesInCammande;
            String price_ht = prefix_sign + Formats.CURRENCY_PRINTED.formatValue(product.getPriceProduct() / (1.0 + taxe.getRate()));
            String total_ht = prefix_sign + Formats.CURRENCY_PRINTED.formatValue(product.getPriceProduct() / (1.0 + taxe.getRate()) * ticketline.getMultiply());
            String tva = " TVA(" + taxe.getName() + ")";
            ticket.addNewLine(2, StringUtils.center((String)price_ht, (int)width_price) + StringUtils.center((String)total_ht, (int)width_price) + StringUtils.center((String)tva, (int)width_price), new Object[0]);
        }
    }

    public void printFactureCanceled(Facture facture, TicketInfo order, EnteteInfo entete, int impressionNumber, Decreaser decreaser) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader(ticket, entete);
        if (entete != null && entete.getHeader() != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, entete.getHeader());
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, "TEL : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        ticket.blankLine(1);
        if (impressionNumber != 0) {
            ticket.addNewLine(1, "DUPLICATA Facture N\u00b0" + facture.getId(), new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + entete.getId() + " Caisse " + entete.getCode_caisse(), new Object[0]);
        } else {
            ticket.addNewLine(1, "Facture N\u00b0" + facture.getId(), new Object[0]);
            ticket.addNewLine(1, "du Ticket N\u00b0" + entete.getId() + " Caisse " + entete.getCode_caisse(), new Object[0]);
        }
        if (AppLocal.isVersionRetailSale().booleanValue()) {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(new Date()), new Object[0]);
        } else {
            ticket.addNewLine(1, this.dateFormatterFullFacture.format(new Date()) + " - " + AppConstants.getTypeOrder(order.getType()).toUpperCase(), new Object[0]);
        }
        if (facture.isPhysical_person()) {
            ticket.addNewLine(1, "Client : " + facture.getName_contact(), new Object[0]);
        } else {
            ticket.addNewLine(1, "Client : " + facture.getCompany(), new Object[0]);
        }
        ticket.setTextSize(1, 1);
        if (facture.getAddress() != null && !facture.getAddress().isEmpty()) {
            String[] tabString = facture.getAddress().split(" ");
            int longueur = tabString.length;
            int half = longueur / 2;
            Object line1 = "";
            for (int i = 0; i < half; ++i) {
                line1 = (String)line1 + tabString[i] + " ";
            }
            Iterator<TicketLineInfo> line2 = "";
            for (int i = half; i < longueur; ++i) {
                line2 = (String)((Object)line2) + tabString[i] + " ";
            }
            ticket.addNewLine(1, (String)line1, new Object[0]);
            if (((String)((Object)line2)).length() > 0) {
                ticket.addNewLine(1, (String)((Object)line2), new Object[0]);
            }
        }
        if (facture.getZip_code() != null && !facture.getZip_code().isEmpty() || facture.getCity() != null && !facture.getCity().isEmpty()) {
            ticket.addNewLine(1, facture.getZip_code() + " " + facture.getCity(), new Object[0]);
        }
        if (facture.getCountry() != null && !facture.getCountry().isEmpty()) {
            ticket.addNewLine(1, facture.getCountry(), new Object[0]);
        }
        if (facture.getSiret() != null && !facture.getSiret().isEmpty()) {
            ticket.addNewLine(1, "Siret : " + facture.getSiret(), new Object[0]);
        }
        boolean canceled = false;
        if (order.getStatus().equalsIgnoreCase("cancel") || facture.getType_operation() != null && facture.getType_operation().equalsIgnoreCase(Facture.CANCEL)) {
            ticket.addNewLine(1, "----ANNUL\u00c9E----", new Object[0]);
            ticket.blankLine(1);
            canceled = true;
        }
        String prefix_sign = canceled ? "-" : "";
        ticket.addLineOfDashes();
        int width_price = (TICKET_WIDTH - 17) / 3;
        int width_designation = TICKET_WIDTH - width_price * 3;
        ticket.addNewLine(3, StringUtils.rightPad((String)"QT\u00c9 D\u00c9SIGNATION", (int)width_designation), StringUtils.center((String)"HT", (int)width_price) + StringUtils.center((String)"Total", (int)width_price) + StringUtils.center((String)"TVA", (int)width_price));
        ticket.addLineOfDashes();
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProductToFacture(line, ticket, canceled);
        }
        ticket.blankLine(1);
        ticket.addNewLine(0, "Nb. Article : " + prefix_sign + order.getNbrArticles(), new Object[0]);
        ticket.addNewLine(3, "TVA      Mt.TVA", "Base HT   Base TTC");
        double mtTva = 0.0;
        double baseHT = 0.0;
        double baseTTC = 0.0;
        for (TaxLineInfo taxe : order.getTaxes()) {
            Object name = taxe.getName();
            if (((String)name).length() == 3) {
                name = (String)name + " ";
            }
            int nmbSpce = 11 - ("-" + taxe.printSumTTC()).length();
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append("-" + taxe.printSumHT());
            for (int i = 0; i < nmbSpce; ++i) {
                stringBuilder.append(" ");
            }
            ticket.addNewLine(3, Integer.valueOf(taxe.getId()) + " a " + (String)name + " -" + taxe.printAmount(), stringBuilder.toString() + "-" + taxe.printSumTTC());
            mtTva += taxe.getAmount();
            baseHT += taxe.getSumHT();
            baseTTC += taxe.getSumTTC();
        }
        mtTva = -mtTva;
        baseHT = -baseHT;
        baseTTC = -baseTTC;
        int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(baseTTC).length();
        StringBuilder stringTotal = new StringBuilder("");
        stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(baseHT));
        for (int i = 0; i < nmbSpce; ++i) {
            stringTotal.append(" ");
        }
        ticket.addNewLine(3, "Total taxes " + TaxLineInfo.printThisDoubleAsAmount(mtTva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(baseTTC));
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Total T.T.C. ", order.printTotalOrder());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().contains("pourcentage")) {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getTotal() / (100.0 - order.getDiscount()))));
            } else {
                ticket.addNewLine(3, "R\u00e9duction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        double renduMonnaie = 0.0;
        boolean isFirst = true;
        boolean isNegative = false;
        if (order.getTotalOrder() < 0.0) {
            ticket.addNewLine(1, "----Remboursement----", new Object[0]);
            isNegative = true;
        } else {
            ticket.addNewLine(1, "Mode de paiement", new Object[0]);
        }
        for (PaymentInfo payment : order.getPayments()) {
            if (!isNegative) {
                ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
            }
            renduMonnaie += payment.getTendered() - payment.getTotal();
        }
        if (isNegative) {
            ticket.addNewLine(3, AppConstants.PAYMENT_MODE.CASH.getName(), order.printTotalOrder());
        }
        renduMonnaie = NumericUtils.round(renduMonnaie);
        if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.addNewLine(1, "Rendu monnaie: " + Formats.CURRENCY_PRINTED.formatValue(renduMonnaie), new Object[0]);
            for (PaymentInfo payment : order.getPayments()) {
                if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                ticket.addNewLine(3, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY_PRINTED.formatValue(payment.getTendered() - payment.getTotal()));
            }
        }
        ticket.setBoldText(true);
        ticket.blankLine(1);
        if (facture.getSignature() != null && !facture.getSignature().isEmpty()) {
            this.setIdentificationLogiciel(ticket, facture.getSignature(), entete.getVersionSoft(), entete.getName_soft());
        }
        ticket.addNewLine(1, "Type d'op\u00e9ration: " + entete.getTypeOperation().toUpperCase(), new Object[0]);
        ticket.addNewLine(1, "Type document: " + facture.getType_operation().toUpperCase(), new Object[0]);
        if (impressionNumber != 0) {
            ticket.addNewLine(1, "R\u00e9impression N\u00b0" + impressionNumber + " - " + this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        } else {
            ticket.addNewLine(1, this.nombreLignesInCammande + " ligne(s)", new Object[0]);
        }
        ticket.addNewLine(1, "F" + facture.getId(), new Object[0]);
        ticket.setBoldText(false);
        if (entete.getFootr() != null) {
            ticket.align(1, entete.getFootr());
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Facture n\u00b0" + String.valueOf(facture.getId()), "L'impression de la facture a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printInventory(BrueBoxServiceStub.InventoryResponseType inv, boolean isPrintCassette) {
        String titre = "Rapport d'\u00e9tat du Monnayeur";
        this.printInventory(inv, titre, isPrintCassette);
    }

    public void printInventory(BrueBoxServiceStub.InventoryResponseType inv, String titre, boolean isPrintCassette) {
        int j;
        BrueBoxServiceStub.DenominationType[] denominations;
        int i;
        Ticket2 ticket = this.appendGloryEntete(titre);
        ticket.blankLine(1);
        ticket.addNewLine(0, "Contenu du Recycler", new Object[0]);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Devise        Nombre", "Montant");
        ticket.addLineOfDashes();
        int k = 0;
        int coinId = 0;
        int noteId = 0;
        int colNoteSum = 0;
        double sommeCst = 0.0;
        double fondCaisseNote = 0.0;
        double fondCaisseCoin = 0.0;
        double sommeCoinCst = 0.0;
        int colCoinSum = 0;
        block2: for (i = 0; i < inv.getCash().length; ++i) {
            if (inv.getCash()[i].getType().intValue() != 4 || (denominations = inv.getCash()[i].getDenomination()).length <= 1) continue;
            for (j = 0; j < denominations.length; ++j) {
                int nbPieces;
                double fValue;
                if (denominations[j].getDevid().intValue() == 1) {
                    if (noteId >= 4) continue block2;
                    fValue = denominations[j].getFv().doubleValue();
                    nbPieces = denominations[j].getPiece().intValue();
                    ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                    fondCaisseNote += (double)nbPieces * fValue;
                    ++noteId;
                    continue;
                }
                if (denominations[j].getDevid().intValue() != 2) continue;
                if (coinId >= 8) continue block2;
                fValue = denominations[j].getFv().doubleValue();
                nbPieces = denominations[j].getPiece().intValue();
                ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                fondCaisseCoin += (double)nbPieces * fValue;
                ++coinId;
            }
        }
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(3, "Total dans le Recycler", Formats.CURRENCY_PRINTED.formatValue(fondCaisseCoin + fondCaisseNote));
        ticket.setBoldText(false);
        BrueBoxServiceStub.CashUnitsType[] cashUnits = inv.getCashUnits();
        if (cashUnits != null) {
            if (isPrintCassette) {
                ticket.blankLine(1);
                ticket.addNewLine(0, "Contenu des cassetes", new Object[0]);
                ticket.addLineOfDashes();
                ticket.addNewLine(3, "Devise        Nombre", "Montant");
                ticket.addLineOfDashes();
            }
            for (i = 0; i < cashUnits.length; ++i) {
                BrueBoxServiceStub.CashUnitType[] cashUnit = cashUnits[i].getCashUnit();
                if (cashUnits[i].getDevid().intValue() == 1) {
                    Map<CallSite, BigInteger> myMap = new HashMap();
                    for (j = 0; j < cashUnit.length; ++j) {
                        int unitno = cashUnit[j].getUnitno().intValue();
                        if (unitno != 4056 && unitno != 4057 && unitno != 4058 && unitno != 4059 && unitno != 4060) continue;
                        denominations = cashUnit[j].getDenomination();
                        for (k = 0; k < denominations.length; ++k) {
                            BigInteger nbPieces = denominations[k].getPiece();
                            double fValue = denominations[k].getFv().doubleValue();
                            String key = IUserInterface.decimalFormat.format(fValue /= 100.0).replace(",", ".") + "\u20ac";
                            if (myMap.get(key) != null) {
                                nbPieces = nbPieces.add((BigInteger)myMap.get(key));
                            }
                            myMap.put((CallSite)((Object)key), nbPieces);
                            colNoteSum += denominations[k].getPiece().intValue();
                            sommeCst += (double)denominations[k].getPiece().intValue() * denominations[k].getFv().doubleValue() / 100.0;
                        }
                    }
                    if (!isPrintCassette) continue;
                    myMap = myMap.entrySet().stream().sorted(Map.Entry.comparingByKey((key1, key2) -> {
                        try {
                            return IUserInterface.decimalFormat.parse(key1.replace("\u20ac", "")).intValue() - IUserInterface.decimalFormat.parse(key2.replace("\u20ac", "")).intValue();
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(PrinterHelper.class.getName()).log(Level.SEVERE, null, ex);
                            return -1;
                        }
                    })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                    for (Map.Entry entry : myMap.entrySet()) {
                        try {
                            String key = (String)entry.getKey();
                            int nbPieces = ((BigInteger)entry.getValue()).intValue();
                            double fValue = IUserInterface.decimalFormat.parse(key.replace("\u20ac", "")).doubleValue();
                            ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue(fValue * (double)nbPieces));
                        }
                        catch (ParseException ex) {
                            Logger.getLogger(PrinterHelper.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    continue;
                }
                if (cashUnits[i].getDevid().intValue() != 2) continue;
                for (j = 0; j < cashUnit.length; ++j) {
                    int unitno = cashUnit[j].getUnitno().intValue();
                    if (unitno != 4084 || (denominations = cashUnit[j].getDenomination()) == null) continue;
                    for (k = 0; k < denominations.length; ++k) {
                        double fValue = denominations[k].getFv().doubleValue();
                        fValue /= 100.0;
                        if (isPrintCassette) {
                            ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + denominations[k].getPiece().intValue()), (int)14), Formats.CURRENCY_PRINTED.formatValue(fValue * (double)denominations[k].getPiece().intValue()));
                        }
                        colCoinSum += denominations[k].getPiece().intValue();
                        sommeCoinCst += (double)denominations[k].getPiece().intValue() * denominations[k].getFv().doubleValue() / 100.0;
                    }
                }
            }
            ticket.addNewLine(3, "Fond Cassette pi\u00e8ces", Formats.CURRENCY_PRINTED.formatValue(sommeCoinCst));
            ticket.addNewLine(3, "Fond Cassette billets", Formats.CURRENCY_PRINTED.formatValue(sommeCst));
            ticket.setBoldText(true);
            ticket.addNewLine(3, "Total dans les Cassettes", Formats.CURRENCY_PRINTED.formatValue(sommeCoinCst + sommeCst));
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
        }
        ticket.setBoldText(true);
        ticket.addNewLine(3, "Total dans le Monnayeur", Formats.CURRENCY_PRINTED.formatValue(fondCaisseCoin + fondCaisseNote + (sommeCst + sommeCoinCst)));
        ticket.setBoldText(false);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Rapport Glory", "L'impression du rapport d'etat du Monnayeur a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    public double printGloryReport(String title, BrueBoxServiceStub.DenominationType[] denominations, String titelTotal) {
        Ticket2 ticket = this.appendGloryEntete(title);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Devise        Nombre", "Montant");
        double total = this.appendDenomination(ticket, denominations, titelTotal);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Rapport Glory", "L'impression du " + title + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
        return total;
    }

    public void printGloryReport(String title, List<Collect> denominations, String titelTotal) {
        Ticket2 ticket = this.appendGloryEntete(title);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Devise        Nombre", "Montant");
        this.appendDenomination(ticket, denominations, titelTotal);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Rapport Glory", "L'impression du " + title + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    public void printGloryReport(String title, List<Collect> denominationsSortie, BrueBoxServiceStub.DenominationType[] denominations) {
        Ticket2 ticket = this.appendGloryEntete(title);
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(3, "Argent en entr\u00e9e", new Object[0]);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Devise        Nombre", "Montant");
        this.appendDenomination(ticket, denominations, "Total en entr\u00e9e");
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(3, "Argent en sortie", new Object[0]);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "Devise        Nombre", "Montant");
        this.appendDenomination(ticket, denominationsSortie, "Total en sortie");
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Rapport Glory", "L'impression du " + title + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    private Ticket2 appendGloryEntete(String title) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        ticket.addNewLine(1, title, new Object[0]);
        ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.addNewLine(1, "Op\u00e9rateur : " + AppLocal.user.getName(), new Object[0]);
        return ticket;
    }

    private double appendDenomination(Ticket2 ticket, BrueBoxServiceStub.DenominationType[] denominations, String titleTotal) {
        ticket.addLineOfDashes();
        double total = 0.0;
        if (denominations != null && denominations.length > 0) {
            int coinId = 0;
            int noteId = 0;
            double fondCaisseNote = 0.0;
            double fondCaisseCoin = 0.0;
            for (int j = 0; j < denominations.length; ++j) {
                int nbPieces;
                double fValue;
                if (denominations[j].getDevid().intValue() == 1) {
                    if (noteId >= 4) break;
                    fValue = denominations[j].getFv().doubleValue();
                    nbPieces = denominations[j].getPiece().intValue();
                    ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                    fondCaisseNote += (double)nbPieces * fValue;
                    ++noteId;
                    continue;
                }
                if (denominations[j].getDevid().intValue() != 2) continue;
                if (coinId >= 8) break;
                fValue = denominations[j].getFv().doubleValue();
                nbPieces = denominations[j].getPiece().intValue();
                ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                fondCaisseCoin += (double)nbPieces * fValue;
                ++coinId;
            }
            ticket.addLineOfDashes();
            ticket.setBoldText(true);
            total = fondCaisseCoin + fondCaisseNote;
            ticket.addNewLine(3, titleTotal, Formats.CURRENCY_PRINTED.formatValue(total));
            ticket.setBoldText(false);
        }
        return total;
    }

    private void appendDenomination(Ticket2 ticket, List<Collect> denominations, String titleTotal) {
        ticket.addLineOfDashes();
        if (denominations != null && denominations.size() > 0) {
            int coinId = 0;
            int noteId = 0;
            double fondCaisseNote = 0.0;
            double fondCaisseCoin = 0.0;
            for (int j = 0; j < denominations.size(); ++j) {
                int nbPieces;
                double fValue;
                if (denominations.get(j).getDevice() == 1) {
                    if (noteId >= 4) break;
                    fValue = denominations.get(j).getFvDouble();
                    nbPieces = denominations.get(j).getPiece();
                    ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                    fondCaisseNote += (double)nbPieces * fValue;
                    ++noteId;
                    continue;
                }
                if (denominations.get(j).getDevice() == 2) {
                    if (coinId >= 8) break;
                    fValue = denominations.get(j).getFvDouble();
                    nbPieces = denominations.get(j).getPiece();
                    ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                    fondCaisseCoin += (double)nbPieces * fValue;
                    ++coinId;
                    continue;
                }
                fValue = denominations.get(j).getFvDouble();
                nbPieces = denominations.get(j).getPiece();
                ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue) + StringUtils.leftPad((String)("" + nbPieces), (int)14), Formats.CURRENCY_PRINTED.formatValue((fValue /= 100.0) * (double)nbPieces));
                fondCaisseCoin += (double)nbPieces * fValue;
            }
            ticket.addLineOfDashes();
            ticket.setBoldText(true);
            ticket.addNewLine(3, titleTotal, Formats.CURRENCY_PRINTED.formatValue(fondCaisseCoin + fondCaisseNote));
            ticket.setBoldText(false);
        }
    }

    private void addDetailProduct(Ticket2 ticket, TicketInfo order, TicketLineInfo product, PrinterInfo printer, String prefix, boolean first_part_of_order, boolean printLabel) {
        if (product.isNext()) {
            ticket.addNewLine(1, product.getNextRetourn(), new Object[0]);
        } else {
            String str;
            boolean orderDishopLight = AppLocal.DISHOP_INTEGRATION != null && AppLocal.DISHOP_INTEGRATION.equalsIgnoreCase("dishop light") && order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("Dishop");
            ticket.setTextSize(1, 2);
            if (AppLocal.PRODUCT_KITCHEN_BOLD) {
                ticket.setBoldText(true);
                ticket.setTextSize(2, 2);
            }
            if (first_part_of_order) {
                this.addNameProduit(ticket, product, AppLocal.PRINT_FOND);
            } else {
                this.addNameProduit(ticket, product, true, prefix, AppLocal.PRINT_FOND);
            }
            if (printLabel && product.getPrinterLabel() == printer.getId() || product.getPrinterID() == printer.getId()) {
                this.loadIngredient(product, ticket);
                for (ItemOrderInfo itemOrderInfo : product.getListIngredients()) {
                    if (itemOrderInfo.getIdProduct() != -1 && itemOrderInfo.getIdProduct() != 0) continue;
                    str = PrinterHelper.formatMax("#### " + AppLocal.getIntString("Label.without") + " " + itemOrderInfo.printName(true) + " ####");
                    ticket.addNewLine(1, str, new Object[0]);
                }
                int id_groupe_option = 0;
                for (OptionItemOrder supplement : product.getListSupplements()) {
                    if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0 || supplement.isNo_printable() || supplement.isHidden_in_kitchen()) continue;
                    if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                        if (id_groupe_option != supplement.getId_groupe_option()) {
                            String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                            ticket.setTextSize(1, 1);
                            ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                        }
                        id_groupe_option = supplement.getId_groupe_option();
                    }
                    this.appendSupplemntKitchen(supplement, ticket);
                }
                ticket.setTextSize(1, 1);
                ticket.blankLine(1);
            }
            ticket.setTextSize(1, 2);
            for (ProductTicket productTicket : product.getListProducts()) {
                if (!orderDishopLight && (!printLabel || productTicket.getPrinterLabel() != printer.getId()) && productTicket.getPrinterID() != printer.getId()) continue;
                String prefix_item = "  ";
                String full_name_item = productTicket.getNumberProduct() > 1 ? productTicket.getNumberProduct() + " " + productTicket.getNameProduct() : productTicket.getNameProduct();
                Object name_item = full_name_item;
                ticket.align(0, prefix_item);
                ticket.setTextSize(2, 2);
                if (AppLocal.PRINT_FOND) {
                    ticket.setReversedText(true);
                    name_item = " " + full_name_item + " ";
                }
                ticket.align(0, (String)name_item);
                ticket.setReversedText(false);
                ticket.setTextSize(1, 2);
                String str_item = prefix_item + (String)name_item;
                if (str_item.length() < TICKET_WIDTH) {
                    int numSpace = TICKET_WIDTH - str_item.length() * 2;
                    for (int i = 0; i < numSpace; ++i) {
                        ticket.append(" ");
                    }
                }
                ticket.blankLine(1);
                for (ItemOrderInfo ingredient : product.getListIngredients()) {
                    if (ingredient.getIdProduct() != productTicket.getIdProduct() || ingredient.getIdCarte() != productTicket.getIdCarte() || ingredient.getIndex_carte() != productTicket.getIndex_carte()) continue;
                    str = PrinterHelper.formatMax("#### " + AppLocal.getIntString("Label.without") + " " + ingredient.printName(true) + " ####");
                    ticket.addNewLine(1, str, new Object[0]);
                }
                int id_groupe_option = 0;
                for (OptionItemOrder supplement : product.getListSupplements()) {
                    if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != productTicket.getIdProduct() || supplement.getIdCarte() != productTicket.getIdCarte() || supplement.getIndex_carte() != productTicket.getIndex_carte()) continue;
                    if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                        if (id_groupe_option != supplement.getId_groupe_option()) {
                            String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                            ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                        }
                        id_groupe_option = supplement.getId_groupe_option();
                    }
                    this.appendSupplemntKitchen(supplement, ticket);
                }
                if (productTicket.getComment() == null || productTicket.getComment().isEmpty()) continue;
                this.addNote(ticket, productTicket.getComment());
            }
            if (orderDishopLight || printLabel && product.getPrinterLabel() == printer.getId() || product.getPrinterID() == printer.getId()) {
                if (product.getDescription() != null && !product.getDescription().isEmpty() && !AppLocal.HIDE_DESCRIPTION_PRODUCT_IN_TICKET) {
                    ticket.addNewLine(0, product.getDescription(), new Object[0]);
                }
                if (product.getNote() != null && !product.getNote().isEmpty()) {
                    this.addNote(ticket, product.getNote());
                }
            }
        }
        ticket.blankLine(1);
    }

    public void printCollectVerificationReport(BrueBoxServiceStub.CollectResponse result, Map<String, BrueBoxServiceStub.CashUnitType> cashUnitsMapOld, double totalStolen) {
        String title = "Collect de v\u00e9rification";
        Ticket2 ticket = this.appendGloryEntete(title);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        for (BrueBoxServiceStub.CashType cash : result.getCollectResponse().getCash()) {
            String lblStr;
            String amtStr;
            BrueBoxServiceStub.DenominationType logicalDenomination;
            BrueBoxServiceStub.CashUnitType cashOld;
            double fValue;
            if (cash.getType().intValue() != 2) continue;
            ticket.addNewLine(1, "*D\u00e9tail de collection", new Object[0]);
            int total = 0;
            BrueBoxServiceStub.DenominationType[] denominations = cash.getDenomination();
            if (denominations != null) {
                ticket.addNewLine(3, "Devise        Nombre", "Montant");
                for (int j = 0; j < denominations.length; ++j) {
                    BrueBoxServiceStub.DenominationType dnm = denominations[j];
                    double fValue2 = dnm.getFv().doubleValue();
                    double fValue100 = fValue2 / 100.0;
                    total += (int)((double)dnm.getPiece().intValue() * fValue100);
                    ticket.addNewLine(3, Formats.CURRENCY_PRINTED.formatValue(fValue100) + StringUtils.leftPad((String)("" + dnm.getPiece()), (int)14), Formats.CURRENCY_PRINTED.formatValue((double)dnm.getPiece().intValue() * fValue100));
                }
            } else {
                ticket.addNewLine(1, "0.00\u20ac", new Object[0]);
            }
            ticket.addNewLine(3, "Total collect\u00e9 :", Formats.CURRENCY_PRINTED.formatValue(total));
            ticket.blankLine(1);
            if (!(totalStolen > 0.0)) continue;
            ticket.addNewLine(1, "*D\u00e9tail du montant perdu", new Object[0]);
            ticket.addNewLine(3, "Devise        Nombre", "Montant");
            totalStolen = 0.0;
            if (cash.getDenomination() != null) {
                for (BrueBoxServiceStub.DenominationType denominationType : cash.getDenomination()) {
                    fValue = denominationType.getFv().doubleValue();
                    String key = IUserInterface.decimalFormat.format(fValue /= 100.0).replace(",", ".") + "\u20ac";
                    cashOld = cashUnitsMapOld.get(key);
                    if (cashOld == null || cashOld.getDenomination() == null || cashOld.getDenomination().length <= 0) continue;
                    logicalDenomination = cashOld.getDenomination()[0];
                    int picesStolen = denominationType.getPiece().intValue() - logicalDenomination.getPiece().intValue();
                    denominationType.setPiece(new BigInteger("" + -picesStolen));
                    amtStr = Formats.CURRENCY_PRINTED.formatValue(denominationType.getPiece().doubleValue() * fValue);
                    lblStr = Formats.CURRENCY_PRINTED.formatValue(fValue);
                    totalStolen += (double)denominationType.getPiece().intValue() * fValue;
                    ticket.addNewLine(3, lblStr + StringUtils.leftPad((String)("" + denominationType.getPiece()), (int)14), amtStr);
                }
            } else {
                for (Map.Entry entry : GloryController.compromisedDenomination.entrySet()) {
                    String key = (String)entry.getKey();
                    BrueBoxServiceStub.DenominationType denominationType = (BrueBoxServiceStub.DenominationType)entry.getValue();
                    fValue = denominationType.getFv().doubleValue();
                    fValue /= 100.0;
                    cashOld = cashUnitsMapOld.get(key);
                    if (cashOld == null || cashOld.getDenomination() == null || cashOld.getDenomination().length <= 0) continue;
                    logicalDenomination = cashOld.getDenomination()[0];
                    int picesStolen = denominationType.getPiece().intValue() - logicalDenomination.getPiece().intValue();
                    denominationType.setPiece(new BigInteger("" + -picesStolen));
                    amtStr = Formats.CURRENCY_PRINTED.formatValue((double)denominationType.getPiece().intValue() * fValue);
                    lblStr = Formats.CURRENCY_PRINTED.formatValue(fValue);
                    totalStolen += denominationType.getPiece().doubleValue() * fValue;
                    ticket.addNewLine(3, lblStr + StringUtils.leftPad((String)("" + denominationType.getPiece()), (int)14), amtStr);
                }
            }
            ticket.addNewLine(3, "Total perdu :", Formats.CURRENCY_PRINTED.formatValue(totalStolen));
        }
        ticket.blankLine(4);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Rapport Glory", "L'impression du " + title + " a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    private void loadIngredient(TicketLineInfo product, Ticket2 ticket) {
        if (product.isPrint_ingredients() && product.getListIngredientsIN() != null && product.getListIngredientsIN().size() > 0) {
            boolean exist = false;
            for (SupplementItemInfo ingredient : product.getListIngredientsIN()) {
                for (ItemOrderInfo SansIngredient : product.getListIngredients()) {
                    if (!ingredient.getName().equals(SansIngredient.getNameSupplement())) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    ticket.addNewLine(1, ingredient.getName(), new Object[0]);
                }
                exist = false;
            }
        }
    }

    public void printNumOrder(TicketInfo order, Decreaser decreaser) {
        if (this.printerCaisse.getNumber() > 0) {
            AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
            Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
            ticket.blankLine(1);
            String orderNum = order.getNumberOrderToPrint();
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, "Commande N\u00b0", new Object[0]);
            ticket.setTextSize(4, 5);
            ticket.addNewLine(1, orderNum, new Object[0]);
            ticket.blankLine(5);
            if (AppLocal.AUTO_CUTTER_TICKET) {
                ticket.cut();
            } else {
                ticket.halfCut();
            }
            ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
            mesBytesInteger.addAll(ticket.bytes);
            PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0" + orderNum, AppLocal.getIntString("Message.error.print.ticket"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
        }
    }

    private void addNote(Ticket2 ticket, String note) {
        System.out.println("++++++++++ note : " + note);
        ticket.setTextSize(1, 2);
        String[] tabNote = note.split(" ");
        Object stringNote = "";
        boolean checkBloc = false;
        String str = "";
        for (int i = 0; i < tabNote.length; ++i) {
            String check = (String)stringNote + " " + tabNote[i];
            if (check.length() <= TICKET_WIDTH) {
                stringNote = (String)stringNote + " " + tabNote[i];
                checkBloc = false;
                continue;
            }
            str = PrinterHelper.formatMax((String)stringNote);
            ticket.align(0, str);
            if (str.length() < TICKET_WIDTH) {
                int numSpace = TICKET_WIDTH - str.length();
                for (int h = 0; h < numSpace; ++h) {
                    ticket.append(" ");
                }
            }
            ticket.blankLine(1);
            stringNote = tabNote[i];
            checkBloc = true;
        }
        if (!checkBloc) {
            str = PrinterHelper.formatMax((String)stringNote);
            ticket.align(0, str);
            if (str.length() < TICKET_WIDTH) {
                int numSpace = TICKET_WIDTH - str.length();
                for (int h = 0; h < numSpace; ++h) {
                    ticket.append(" ");
                }
            }
            ticket.blankLine(1);
        }
        ticket.setTextSize(1, 1);
    }

    private void addDetailItem(String name_product, Ticket2 ticket, ProductTicket productMenu, PrinterInfo printer, boolean isSeparate, TicketLineInfo product) {
        if (productMenu.getPrinterID() == printer.getId()) {
            ticket.setTextSize(1, 2);
            ticket.setTextSize(AppLocal.size_supplement, 2);
            String str = PrinterHelper.formatMax(name_product);
            ticket.addNewLine(0, str, new Object[0]);
            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                if (ingredient.getIdProduct() != productMenu.getIdProduct() || ingredient.getIdCarte() != productMenu.getIdCarte() || ingredient.getIndex_carte() != productMenu.getIndex_carte()) continue;
                str = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
                ticket.addNewLine(1, str, new Object[0]);
            }
            int id_groupe_option = 0;
            for (OptionItemOrder supplement : product.getListSupplements()) {
                if (supplement.getIdProduct() != productMenu.getIdProduct() || supplement.getIdCarte() != productMenu.getIdCarte() || supplement.getIndex_carte() != productMenu.getIndex_carte()) continue;
                if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                    if (id_groupe_option != supplement.getId_groupe_option()) {
                        String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                        ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                    }
                    id_groupe_option = supplement.getId_groupe_option();
                }
                this.appendSupplemntKitchen(supplement, ticket);
            }
        }
    }

    public void printCloseBorne(LinkedHashMap<String, Object> map_infos, Date date, String title, MarqueNFC marqueNF, Decreaser decreaser) {
        int nbOrder = map_infos.get("nbOrders") != null ? (Integer)map_infos.get("nbOrders") : 0;
        double turnover = map_infos.get("turnover") != null ? (Double)map_infos.get("turnover") : 0.0;
        double totalDiscount = map_infos.get("totalDiscount") != null ? (Double)map_infos.get("totalDiscount") : 0.0;
        double totalDiscountLines = map_infos.get("totalDiscountLines") != null ? (Double)map_infos.get("totalDiscountLines") : 0.0;
        List payments = map_infos.get("payments") != null ? (List)map_infos.get("payments") : null;
        List dataTypeOrders = map_infos.get("typeOrders") != null ? (List)map_infos.get("typeOrders") : null;
        List taxes = map_infos.get("taxes") != null ? (List)map_infos.get("taxes") : null;
        List equipments = map_infos.get("equipments") != null ? (List)map_infos.get("equipments") : null;
        List not_available = map_infos.get("not_available") != null ? (List)map_infos.get("not_available") : null;
        int nbCB = 0;
        if (payments != null) {
            for (PaymentLine paymentLine : payments) {
                if (!paymentLine.getM_PaymentType().equalsIgnoreCase("CB")) continue;
                nbCB = paymentLine.getNombre();
            }
        }
        double total_taxe = 0.0;
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, "Rapport Financier".toUpperCase(), new Object[0]);
        ticket.addNewLine(1, title.toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, this.dateFormatter.format(date), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "Chiffres d'affaires", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(turnover), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, nbOrder + " commandes", new Object[0]);
        ticket.blankLine(1);
        if (taxes != null) {
            for (TaxeLine taxe_1 : taxes) {
                total_taxe += taxe_1.getTax();
            }
            ticket.addNewLine(1, "TVA \u00e0 reverser: " + Formats.CURRENCY_PRINTED.formatValue(total_taxe), new Object[0]);
            for (TaxeLine taxe : taxes) {
                String name_taxe = taxe.getName() != null && !taxe.getName().isEmpty() ? taxe.getName() : "";
                ticket.addNewLine(1, "TVA " + name_taxe + " : " + Formats.CURRENCY_PRINTED.formatValue(taxe.getTax()), new Object[0]);
            }
            ticket.blankLine(2);
        }
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, "CB : " + Formats.CURRENCY_PRINTED.formatValue(turnover), new Object[0]);
        if (nbCB > 0) {
            ticket.addNewLine(1, nbCB + " CB", new Object[0]);
        }
        ticket.blankLine(2);
        if (dataTypeOrders != null) {
            for (RankTypeOrder type : dataTypeOrders) {
                ticket.addNewLine(1, type.getName() + " : " + Formats.CURRENCY_PRINTED.formatValue(type.getCa()), new Object[0]);
            }
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9ductions et promotions", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, "R\u00e9ductions sur les commandes: " + Formats.CURRENCY_PRINTED.formatValue(totalDiscount), new Object[0]);
        ticket.addNewLine(1, "R\u00e9ductions sur les articles: " + Formats.CURRENCY_PRINTED.formatValue(totalDiscountLines), new Object[0]);
        if (equipments != null || not_available != null && !not_available.isEmpty()) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "CA par \u00e9quipement", new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            if (equipments != null) {
                for (EquipmentTurnover equipment : equipments) {
                    ticket.addNewLine(1, equipment.getName() + " : " + Formats.CURRENCY_PRINTED.formatValue(equipment.getTurnover()), new Object[0]);
                }
            }
            if (not_available != null && !not_available.isEmpty()) {
                for (String equipmentNoAvailable : not_available) {
                    ticket.addNewLine(1, equipmentNoAvailable + " : \u00e9quipement indisponible", new Object[0]);
                }
            }
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printCloseCaisseCenter(int nbOrder, double caNet, List<Course> courses, double caCanceld, double tvas, List<PaymentLine> payments, List<TaxeLine> taxes, List<UserCaisseInfo> users, CaisseInfo caisse, MarqueNFC marqueNF, Date dateStart, Date dateEnd, String title, double discountOrders, double discountLines, CaisseZ zcaisse, List<TicketInfo> orders, List<LogPanier> logs, List<RankTypeOrder> dataTypeOrders, Decreaser decreaser, String type_rapport, List<TicketInfo> notesCanceled, List<RankTypeOrder> dataTypePlatformOrders, List<GroupedTax> globalTaxes, double total_ht_taxable, double total_ht_no_taxable) {
        this.printCloseCaisseCenter(nbOrder, caNet, courses, caCanceld, tvas, payments, taxes, users, caisse, marqueNF, dateStart, dateEnd, title, discountOrders, discountLines, zcaisse, orders, logs, dataTypeOrders, decreaser, type_rapport, 1, 0.0, 0.0, null, notesCanceled, dataTypePlatformOrders, globalTaxes, total_ht_taxable, total_ht_no_taxable);
    }

    private String getNumOrder(TicketInfo order) {
        return order.getNumberOrder(true, true);
    }

    public void printRappelTickets(int orderId, TicketInfo order, EnteteInfo entete, long impressionNumber, Decreaser decreaser, String holder_ticket) {
        this.printRappelTickets(orderId, order, entete, impressionNumber, decreaser, false, holder_ticket, null, false);
    }

    public void printCloseCaisseGlobal(ZGlobalInfoDTO periodeGlobal, MarqueNFC marqueNF, Date dateStart, Date dateEnd, String title, Decreaser decreaser, String type_rapport, int number_impression) {
        int nbOrder = periodeGlobal.getNumber_orders();
        double caNet = periodeGlobal.getTotal();
        double caCanceld = periodeGlobal.getTurnover_canceled();
        List<PaymentLine> payments = periodeGlobal.getPayments();
        List<RankTypeOrder> dataTypeOrders = periodeGlobal.getTypeOrders();
        List<RankTypeOrder> dataTypePlatformOrders = periodeGlobal.getTypePlatformOrders();
        double totalDiscount = periodeGlobal.getTotal_discount();
        double totalDiscountOnLines = periodeGlobal.getTotal_discount_lines();
        List<GroupedTax> groupedTaxes = periodeGlobal.getGroupedTaxes();
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, AppLocal.getIntString("Text.financial.report").toUpperCase(), new Object[0]);
        ticket.addNewLine(1, title.toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        if (type_rapport != null && type_rapport.equals("m")) {
            ticket.addNewLine(1, DateUtils.getNameOfMonth(dateStart.getMonth() + 1) + " " + (dateStart.getYear() + 1900), new Object[0]);
        } else if (type_rapport != null && type_rapport.equals("a")) {
            ticket.addNewLine(1, String.valueOf(dateStart.getYear() + 1900), new Object[0]);
        } else {
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateStart) : this.dateFormatter.format(dateStart)) + "    " + this.HorraireFormatter.format(dateStart), new Object[0]);
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateEnd) : this.dateFormatter.format(dateEnd)) + "    " + this.HorraireFormatter.format(dateEnd), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(caNet), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, nbOrder + " " + AppLocal.getIntString("Text.orders"), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        if (AppLocal.MODULE_TVA_GLOBAL) {
            double total_before_taxes = caNet;
            for (GroupedTax groupedTaxe : groupedTaxes) {
                total_before_taxes -= groupedTaxe.getTotal_tax();
            }
            ticket.addNewLine(3, "Total avant taxes : ", Formats.CURRENCY.formatValue(total_before_taxes));
            if (periodeGlobal.getTotal_ht_taxable() != 0.0 || periodeGlobal.getTotal_ht_no_taxable() != 0.0) {
                ticket.addNewLine(3, "Total HT Taxable : ", Formats.CURRENCY.formatValue(periodeGlobal.getTotal_ht_taxable()));
                ticket.addNewLine(3, "Total HT no Taxable : ", Formats.CURRENCY.formatValue(periodeGlobal.getTotal_ht_no_taxable()));
            }
            for (GroupedTax groupedTaxe : groupedTaxes) {
                ticket.addNewLine(3, groupedTaxe.getName(), Formats.CURRENCY.formatValue(groupedTaxe.getTotal_tax()));
            }
        } else {
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "TVA", new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.addNewLine(3, "TVA        Total TVA", "Total HT   Total TTC");
            double total_Tva = 0.0;
            double total_HT = 0.0;
            double total_TTC = 0.0;
            for (TaxeLine taxe : periodeGlobal.getTaxes()) {
                int nmbSpce_name = 11 - taxe.getName().length();
                StringBuilder stringBuilderName = new StringBuilder("");
                stringBuilderName.append(taxe.getName());
                for (int i = 0; i < nmbSpce_name; ++i) {
                    stringBuilderName.append(" ");
                }
                int nmbSpce = 11 - taxe.printTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(taxe.printHT());
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, stringBuilderName.toString() + taxe.printTaxe(), stringBuilder.toString() + taxe.printTTC());
                total_Tva += taxe.getTax();
                total_HT += taxe.getHt();
                total_TTC += taxe.getTotal();
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(total_TTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(total_HT));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total      " + TaxLineInfo.printThisDoubleAsAmount(total_Tva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(total_TTC));
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition encaissement", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (PaymentLine paymentLine : payments) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                ticket.addNewLine(1, this.getOfficialPayement(paymentLine.getM_PaymentType()) + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                ticket.addNewLine(1, "Avoir Encaiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            ticket.addNewLine(1, "Avoir D\u00e9caiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
        }
        for (PaymentLine paymentLine : payments) {
            switch (paymentLine.getM_PaymentType()) {
                case "CB": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " " + AppLocal.getIntString("Button.cb"), new Object[0]);
                    break;
                }
                case "Carte Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Carte Ticket Resto", new Object[0]);
                    break;
                }
                case "Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Tickets Resto", new Object[0]);
                }
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition type", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (RankTypeOrder type : dataTypeOrders) {
            ticket.addNewLine(1, AppConstants.getTypeOrder(type.getName()) + " : " + Formats.CURRENCY_PRINTED.formatValue(type.getCa()), new Object[0]);
        }
        if (dataTypePlatformOrders != null && !dataTypePlatformOrders.isEmpty()) {
            ticket.blankLine(1);
            for (RankTypeOrder type : dataTypePlatformOrders) {
                ticket.addNewLine(1, type.getName() + " : " + Formats.CURRENCY.formatValue(type.getCa()), new Object[0]);
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover.canceled") + ": " + Formats.CURRENCY_PRINTED.formatValue(caCanceld), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.orders") + ": " + Formats.CURRENCY_PRINTED.formatValue(totalDiscount), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.items") + ": " + Formats.CURRENCY_PRINTED.formatValue(totalDiscountOnLines), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "Equipements", new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        for (ZHostNameDTO mZHostNameDTO : periodeGlobal.getZ_host_name()) {
            ticket.addNewLine(1, mZHostNameDTO.getHost_name() + " : " + Formats.CURRENCY_PRINTED.formatValue(mZHostNameDTO.getTotal()), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
        mesBytesInteger.addAll(ticket.bytes);
        for (int h = 1; h < number_impression; ++h) {
            ticket.bytes.addAll(mesBytesInteger);
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public PrinterInfo getPrinterCaisse() {
        return this.printerCaisse;
    }

    private void printQrSites(Ticket2 ticket) {
        this.printQrCodeSite(ticket, AppLocal.TICKET_SITE1, AppLocal.DESCRIPTION_TICKET_SITE1);
        this.printQrCodeSite(ticket, AppLocal.TICKET_SITE2, AppLocal.DESCRIPTION_TICKET_SITE2);
        this.printQrCodeSite(ticket, AppLocal.TICKET_SITE3, AppLocal.DESCRIPTION_TICKET_SITE3);
    }

    private void printQrCodeSite(Ticket2 ticket, String site, String description) {
        if (site != null && !site.isEmpty()) {
            if (description != null && !description.isEmpty()) {
                ticket.addNewLine(1, description, new Object[0]);
            }
            BufferedImage site1QrCodeImage = QrCodeHelper.siteTicketToImageQrCode(site);
            ticket.setAlign(1);
            ticket.addImage(site1QrCodeImage);
        }
    }

    private String getTextItem(ProductTicket item, TicketLineInfo product) {
        StringBuilder itemInfos = new StringBuilder("");
        if (AppLocal.printIngredientExclus.booleanValue() && product.getListIngredients().size() > 0) {
            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                if (itemInfos.length() == 0) {
                    itemInfos.append("(");
                }
                itemInfos.append(" _SANS " + ingredient.getNameSupplement());
            }
        }
        if (product.getListSupplements().size() > 0) {
            for (OptionItemOrder supplement : product.getListSupplements()) {
                if (supplement.isHidden_in_kitchen() || supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                if (itemInfos.length() == 0) {
                    itemInfos.append("(");
                } else {
                    itemInfos.append(" + ");
                }
                if (supplement.getNumberOption() > 1) {
                    itemInfos.append(supplement.getNumberOption() + "x" + supplement.getNameSupplement() + this.loadWeightOption(supplement));
                    continue;
                }
                itemInfos.append(supplement.getNameSupplement() + this.loadWeightOption(supplement));
            }
        }
        if (itemInfos.length() > 0) {
            itemInfos.append(")");
            return itemInfos.toString();
        }
        return null;
    }

    private void headerKitchenTicket(TicketInfo order, String text_commande, String orderNum, boolean borne, boolean dishop_ticket) {
        this.ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.ticket.blankLine(1);
            this.ticket.setTextSize(2, 2);
            this.ticket.setReversedText(true);
            this.ticket.addNewLine(1, " " + AppConstants.getTypeOrder(order.getType()) + " ", new Object[0]);
            this.ticket.setReversedText(false);
            this.ticket.setTextSize(1, 1);
        }
        this.ticket.blankLine(1);
        this.ticket.setTextSize(2, 2);
        if (text_commande != null && !text_commande.isEmpty()) {
            this.ticket.addNewLine(1, text_commande, new Object[0]);
        }
        if (order.getNum_order_kitchen() != -1 || AppLocal.DISPLAY_NUM_ORDER) {
            this.ticket.setTextSize(5, 5);
            this.ticket.setBoldText(true);
            if (AppLocal.PRINT_TEXT_DISHOP_IN_TICKETS && order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("Dishop")) {
                this.ticket.addNewLine(1, "DISHOP", new Object[0]);
            }
            this.ticket.addNewLine(1, "#" + orderNum, new Object[0]);
            this.ticket.setTextSize(1, 1);
            this.ticket.setBoldText(false);
        }
        this.ticket.setTextSize(2, 2);
        if (AppLocal.DISPLAY_NAME_SERVER && order.getUser() != null) {
            this.ticket.addNewLine(1, AppLocal.getIntString("Label.server") + " " + order.getUser().getName(), new Object[0]);
        }
        if (order.getName_customer() != null && !order.getName_customer().isEmpty()) {
            this.ticket.addNewLine(1, AppLocal.getIntString("Label.client") + " : " + order.getName_customer(), new Object[0]);
        }
        if (dishop_ticket) {
            this.ticket.addNewLine(1, dateFormatterFull.format(order.getDate()), new Object[0]);
        }
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            this.ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
        }
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.setStatusPaid(this.ticket, order, borne);
        }
        if (!AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(this.ticket, order);
        }
        this.ticket.blankLine(1);
    }

    private void footerKitchenTicket(Ticket2 ticket, PrinterInfo printer, String orderNum, Decreaser decreaser, boolean dishop_ticket, int numPrinters, int j, TicketInfo order, boolean borne) {
        String source_order;
        ticket.blankLine(1);
        if (AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            ticket.setReversedText(true);
            ticket.addNewLine(1, " " + AppConstants.getTypeOrder(order.getType()) + " ", new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            this.setStatusPaid(ticket, order, borne);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(ticket, order);
        }
        if ((source_order = this.getSourceOrder(order)) != null && !source_order.isEmpty()) {
            ticket.addNewLine(1, "Source : " + source_order, new Object[0]);
        }
        ticket.addNewLine(1, String.format("Ticket %d/%d", j, numPrinters), new Object[0]);
        if (!dishop_ticket) {
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
        mesBytesInteger.addAll(ticket.bytes);
        for (int h = 1; h < printer.getNumber(); ++h) {
            ticket.bytes.addAll(mesBytesInteger);
        }
        System.out.println("***** footerKitchenTicket");
        this.printConsole(ticket.bytes);
        PrinterHelper.printTicket(printer.getIp(), printer.getNamePrinter(), printer.getType(), ticket, "Commande n\u00b0" + orderNum, "L'impression du ticket cuisine a \u00e9chou\u00e9.", printer.getPort(), printer.getBand_rate(), printer, decreaser, false);
    }

    private void headerKitchenTicketLabel(TicketInfo order, String orderNum, int index_product) {
        this.ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        this.ticket.setTextSize(5, 5);
        this.ticket.setBoldText(true);
        this.ticket.addNewLine(1, "#" + orderNum, new Object[0]);
        this.ticket.setTextSize(1, 1);
        this.ticket.setBoldText(false);
        this.ticket.blankLine(1);
        this.ticket.setTextSize(1, 1);
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            this.ticket.setTextSize(2, 2);
            this.ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
            this.ticket.setTextSize(1, 1);
            this.ticket.blankLine(1);
        }
        this.ticket.addNewLine(1, this.timeFormatter.format(order.getDate()), new Object[0]);
        this.ticket.blankLine(1);
    }

    private void headerKitchenTicket(TicketInfo order, String orderNum, int index_product) {
        this.ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("borne")) {
            orderNum = "B" + (String)orderNum;
        }
        if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse") && (order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("inside") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("caisse"))) {
            orderNum = "C" + (String)orderNum;
        }
        if (index_product < this.alphaOrder.size()) {
            orderNum = (String)orderNum + "-" + this.alphaOrder.get(index_product);
        }
        this.ticket.blankLine(1);
        if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
            this.ticket.setReversedText(true);
            this.ticket.setTextSize(4, 4);
        }
        this.ticket.addNewLine(1, (String)orderNum, new Object[0]);
        if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
            this.ticket.setReversedText(false);
        }
        this.ticket.setTextSize(1, 1);
        this.ticket.blankLine(1);
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            this.ticket.setTextSize(2, 2);
            this.ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
            this.ticket.setTextSize(1, 1);
            this.ticket.blankLine(1);
        }
        this.ticket.setTextSize(1, 1);
        this.ticket.addNewLine(1, this.timeFormatter.format(order.getDate()), new Object[0]);
        this.ticket.blankLine(1);
        System.out.println("++++++++++ ticket 2 : " + this.ticket);
    }

    private void addDetailProductAndSubProduct(TicketLineInfo product, PrinterInfo printer, String prefix, boolean first_part_of_order, TicketInfo order, String orderNum, Decreaser decreaser, int index_product, boolean dishop_ticket, boolean printLabel, boolean borne) {
        int h = 1;
        for (ProductTicket productMenu : product.getListProducts()) {
            if ((!printLabel || productMenu.getPrinterLabel() != printer.getId()) && productMenu.getPrinterID() != printer.getId()) continue;
            this.headerKitchenTicket(order, orderNum, index_product);
            this.ticket.setTextSize(1, 2);
            if (AppLocal.PRODUCT_KITCHEN_BOLD) {
                this.ticket.setBoldText(true);
            }
            if (first_part_of_order) {
                this.addNameProduit(this.ticket, product, AppLocal.PRINT_FOND);
            } else {
                this.addNameProduit(this.ticket, product, true, prefix, AppLocal.PRINT_FOND);
            }
            String full_name_item = productMenu.getNumberProduct() > 1 ? productMenu.getNumberProduct() + " " + productMenu.getNameProduct() : productMenu.getNameProduct();
            String str = PrinterHelper.formatMax("  " + full_name_item);
            this.ticket.align(0, str);
            if (str.length() < TICKET_WIDTH) {
                int numSpace = TICKET_WIDTH - str.length();
                for (int i = 0; i < numSpace; ++i) {
                    this.ticket.append(" ");
                }
            }
            this.ticket.blankLine(1);
            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                if (ingredient.getIdProduct() != productMenu.getIdProduct() || ingredient.getIdCarte() != productMenu.getIdCarte() || ingredient.getIndex_carte() != productMenu.getIndex_carte()) continue;
                str = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
                this.ticket.addNewLine(1, str, new Object[0]);
            }
            int id_groupe_option = 0;
            for (OptionItemOrder supplement : product.getListSupplements()) {
                if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != productMenu.getIdProduct() || supplement.getIdCarte() != productMenu.getIdCarte() || supplement.getIndex_carte() != productMenu.getIndex_carte()) continue;
                if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                    if (id_groupe_option != supplement.getId_groupe_option()) {
                        String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                        this.ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                    }
                    id_groupe_option = supplement.getId_groupe_option();
                }
                this.appendSupplemntKitchen(supplement, this.ticket);
            }
            this.footerKitchenTicket(this.ticket, printer, orderNum, decreaser, dishop_ticket, product.getListProducts().size(), h, order, borne);
            ++h;
        }
    }

    private void initAlphaOrder() {
        this.alphaOrder = new ArrayList<String>();
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.alphaOrder.add(String.valueOf(c));
        }
    }

    private void addNumOrder(Ticket2 ticket, TicketInfo order) {
        int width = 2;
        int height = 2;
        Object str_number_order = "";
        if (order != null && order.getNumero_platform_order() != null && !order.getNumero_platform_order().isEmpty() && (order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) || order.getType() != null && this.platFormTypesOrder.contains(order.getType()))) {
            str_number_order = order.getSent_from() != null && this.platFormSourcesOrder.contains(order.getSent_from()) ? order.getSent_from() : order.getType();
            str_number_order = (String)str_number_order + " N\u00b0" + order.getNumero_platform_order();
        } else {
            Object prefix = "";
            if (order.getNum_order_kitchen() != -1 && order.getNum_order_kitchen() != 0 || !AppLocal.KITCHEN_COMPOSITE) {
                if (!AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
                    prefix = "Commande N\u00b0";
                } else {
                    width = 4;
                    height = 4;
                }
            } else {
                if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
                    prefix = (String)prefix + " ";
                }
                prefix = (String)prefix + "PB connexion N\u00b0";
            }
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Borne") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("borne")) {
                prefix = (String)prefix + " B ";
            }
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse") && (order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("inside") || order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("caisse"))) {
                prefix = (String)prefix + " C ";
            }
            str_number_order = (String)prefix + order.getNumberOrderToPrint();
            if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
                str_number_order = (String)str_number_order + " ";
            }
        }
        if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
            ticket.setReversedText(true);
        }
        ticket.setTextSize(width, height);
        ticket.addNewLine(1, (String)str_number_order, new Object[0]);
        if (AppLocal.BLACK_BACKGROUND_NUM_ORDER) {
            ticket.setReversedText(false);
        }
        ticket.setTextSize(1, 1);
    }

    private void appendHeaderFacture(Ticket2 ticket, Facture facture) {
        if (facture != null) {
            if (facture.getCompany_sender() != null && !facture.getCompany_sender().isEmpty()) {
                ticket.setTextSize(1, 2);
                ticket.addNewLine(1, facture.getCompany_sender(), new Object[0]);
                ticket.setTextSize(1, 1);
            }
            if (facture.getAddress_sender() != null && !facture.getAddress_sender().isEmpty()) {
                ticket.addNewLine(1, facture.getAddress_sender(), new Object[0]);
            }
            if (facture.getZip_code_sender() != null && !facture.getZip_code_sender().isEmpty() && facture.getCity_sender() != null && !facture.getCity_sender().isEmpty()) {
                ticket.addNewLine(1, facture.getZip_code_sender() + " " + facture.getCity_sender(), new Object[0]);
            }
            if (facture.getCountry_sender() != null && !facture.getCountry_sender().isEmpty()) {
                ticket.addNewLine(1, "Pays : " + facture.getCountry_sender(), new Object[0]);
            }
            if (facture.getCode_NAF_sender() != null && !facture.getCode_NAF_sender().isEmpty()) {
                ticket.addNewLine(1, "Code NAF : " + facture.getCode_NAF_sender(), new Object[0]);
            }
            if (facture.getSiret_sender() != null && !facture.getSiret_sender().isEmpty()) {
                ticket.addNewLine(1, "Siret : " + facture.getSiret_sender(), new Object[0]);
            }
            if (facture.getNum_tva_sender() != null && !facture.getNum_tva_sender().isEmpty()) {
                ticket.addNewLine(1, "TVA intra : " + facture.getNum_tva_sender(), new Object[0]);
            }
            if (facture.getForme_juridique_sender() != null && !facture.getForme_juridique_sender().isEmpty()) {
                ticket.addNewLine(1, "Forme juridique : " + facture.getForme_juridique_sender(), new Object[0]);
            }
            if (facture.getCapital_social_sender() != null && !facture.getCapital_social_sender().isEmpty()) {
                ticket.addNewLine(1, "Capital social : " + facture.getCapital_social_sender(), new Object[0]);
            }
            if (facture.getRCS_sender() != null && !facture.getRCS_sender().isEmpty()) {
                ticket.addNewLine(1, "RCS : " + facture.getRCS_sender(), new Object[0]);
            }
            if (facture.getGreffe_sender() != null && !facture.getGreffe_sender().isEmpty()) {
                ticket.addNewLine(1, "Ville de greffe : " + facture.getGreffe_sender(), new Object[0]);
            }
            if (facture.getMetier_sender() != null && !facture.getMetier_sender().isEmpty()) {
                ticket.addNewLine(1, "Metier : " + facture.getMetier_sender(), new Object[0]);
            }
            if (facture.getReglement_tva_sender() != null && !facture.getReglement_tva_sender().isEmpty()) {
                ticket.addNewLine(1, "R\u00e9glement TVA : " + facture.getReglement_tva_sender(), new Object[0]);
            }
        }
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, "TEL: " + AppLocal.phoneRestaurant, new Object[0]);
        }
        if (AppLocal.header != null) {
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.align(1, AppLocal.header);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
    }

    private void sortLinesOrder(TicketInfo order) {
        if (order.getLinesCount() > 1) {
            ArrayList<TicketLineInfo> lines = new ArrayList<TicketLineInfo>();
            ArrayList<TicketLineInfo> lines_fees = new ArrayList<TicketLineInfo>();
            for (TicketLineInfo line : order.getLines()) {
                if (line.getProductName() == null || !line.getProductName().equalsIgnoreCase("Frais de livraison") && !line.getProductName().equalsIgnoreCase("Frais de gestion")) {
                    lines.add(line);
                    continue;
                }
                lines_fees.add(line);
            }
            order.setLines(lines);
            order.getLines().addAll(lines_fees);
        }
    }

    public void printCloseCaisseGlobal(LinkedHashMap<String, Object> map_infos, MarqueNFC marqueNF, Date dateStart, Date dateEnd, Decreaser decreaser, int number_impression) {
        int nbOrder = map_infos.get("nbOrders") != null ? (Integer)map_infos.get("nbOrders") : 0;
        double caNet = map_infos.get("turnover") != null ? (Double)map_infos.get("turnover") : 0.0;
        double turnoverCanceled = map_infos.get("turnover_canceled") != null ? (Double)map_infos.get("turnover_canceled") : 0.0;
        List payments = map_infos.get("payments") != null ? (List)map_infos.get("payments") : null;
        List users = map_infos.get("users") != null ? (List)map_infos.get("users") : null;
        List dataTypeOrders = map_infos.get("typeOrders") != null ? (List)map_infos.get("typeOrders") : null;
        List equipments = map_infos.get("equipments") != null ? (List)map_infos.get("equipments") : null;
        List taxes = map_infos.get("taxes") != null ? (List)map_infos.get("taxes") : null;
        List canceledOrders = map_infos.get("canceled_order") != null ? (List)map_infos.get("canceled_order") : null;
        List canceledNotes = map_infos.get("canceled_notes") != null ? (List)map_infos.get("canceled_notes") : null;
        List discountOrders = map_infos.get("discount_order") != null ? (List)map_infos.get("discount_order") : null;
        double totalDiscount = map_infos.get("totalDiscount") != null ? (Double)map_infos.get("totalDiscount") : 0.0;
        double totalDiscountOnLines = map_infos.get("totalDiscountLines") != null ? (Double)map_infos.get("totalDiscountLines") : 0.0;
        List not_available = map_infos.get("not_available") != null ? (List)map_infos.get("not_available") : null;
        List groupedTaxes = map_infos.get("grouped_taxes") != null ? (List)map_infos.get("grouped_taxes") : null;
        double tps = map_infos.get("tps") != null ? (Double)map_infos.get("tps") : 0.0;
        double tvq = map_infos.get("tvq") != null ? (Double)map_infos.get("tvq") : 0.0;
        double total_ht_taxable = map_infos.get("total_ht_taxable") != null ? (Double)map_infos.get("total_ht_taxable") : 0.0;
        double total_ht_no_taxable = map_infos.get("total_ht_no_taxable") != null ? (Double)map_infos.get("total_ht_no_taxable") : 0.0;
        double total_taxe = 0.0;
        String title_1 = "Rapport Financier";
        Object title_2 = " X Global ";
        if (not_available != null && !not_available.isEmpty()) {
            title_2 = (String)title_2 + "(incomplet)";
        }
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, title_1.toUpperCase(), new Object[0]);
        ticket.addNewLine(1, ((String)title_2).toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateStart) : this.dateFormatter.format(dateStart)) + "    " + this.HorraireFormatter.format(dateStart), new Object[0]);
        ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateEnd) : this.dateFormatter.format(dateEnd)) + "    " + this.HorraireFormatter.format(dateEnd), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "Chiffres d'affaires", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(caNet), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, nbOrder + " commandes", new Object[0]);
        ticket.blankLine(1);
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            double total_before_taxes = caNet;
            System.out.println("total_before_taxes :print  " + total_before_taxes);
            if (groupedTaxes != null) {
                for (GroupedTax globalTaxe : groupedTaxes) {
                    System.out.println("globalTaxe.getTotal_tax() : print " + globalTaxe.getTotal_tax());
                    total_before_taxes -= globalTaxe.getTotal_tax();
                }
            }
            ticket.addNewLine(3, "Total avant taxes : ", Formats.CURRENCY_PRINTED.formatValue(total_before_taxes));
            if (total_ht_taxable != 0.0 || total_ht_no_taxable != 0.0) {
                ticket.addNewLine(3, "Total HT Taxable : ", Formats.CURRENCY_PRINTED.formatValue(total_ht_taxable));
                ticket.addNewLine(3, "Total HT no Taxable : ", Formats.CURRENCY_PRINTED.formatValue(total_ht_no_taxable));
            }
            for (GroupedTax globalTaxe : groupedTaxes) {
                ticket.addNewLine(3, globalTaxe.getName(), Formats.CURRENCY_PRINTED.formatValue(globalTaxe.getTotal_tax()));
            }
        } else if (taxes != null) {
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "TVA", new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            for (TaxeLine taxe_1 : taxes) {
                total_taxe += taxe_1.getTax();
            }
            ticket.addNewLine(1, "TVA \u00e0 reverser: " + Formats.CURRENCY.formatValue(total_taxe), new Object[0]);
            for (TaxeLine taxe : taxes) {
                String name_taxe = taxe.getName() != null && !taxe.getName().isEmpty() ? taxe.getName() : "";
                ticket.addNewLine(1, "TVA " + name_taxe + " : " + Formats.CURRENCY.formatValue(taxe.getTax()), new Object[0]);
            }
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition encaissement", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        if (payments != null) {
            for (PaymentLine paymentLine : payments) {
                if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                    ticket.addNewLine(1, paymentLine.getM_PaymentType() + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                    continue;
                }
                if (paymentLine.getM_PaymentValue() > 0.0) {
                    ticket.addNewLine(1, "Avoir Encaiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                    continue;
                }
                ticket.addNewLine(1, "Avoir D\u00e9caiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
            }
        }
        for (PaymentLine paymentLine : payments) {
            switch (paymentLine.getM_PaymentType()) {
                case "CB": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " " + AppLocal.getIntString("Button.cb"), new Object[0]);
                    break;
                }
                case "Carte Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Carte Ticket Resto", new Object[0]);
                    break;
                }
                case "Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Tickets Resto", new Object[0]);
                }
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition type", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        if (dataTypeOrders != null) {
            for (RankTypeOrder type : dataTypeOrders) {
                ticket.addNewLine(1, type.getName() + " : " + Formats.CURRENCY_PRINTED.formatValue(type.getCa()), new Object[0]);
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9ductions et promotions", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, "R\u00e9ductions sur les commandes: " + Formats.CURRENCY_PRINTED.formatValue(totalDiscount), new Object[0]);
        ticket.addNewLine(1, "R\u00e9ductions sur les articles: " + Formats.CURRENCY_PRINTED.formatValue(totalDiscountOnLines), new Object[0]);
        if (discountOrders != null && discountOrders.size() > 0) {
            ticket.blankLine(2);
            ticket.addNewLine(3, "Num date heure", "caissier R\u00e9duction");
            for (TicketInfo order : discountOrders) {
                this.appendOrderDiscount(order, ticket);
            }
        }
        ticket.blankLine(1);
        if (users != null) {
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "CA par Caissier", new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            for (UserCaisseInfo user : users) {
                ticket.addNewLine(1, user.getName() + " : " + user.printTotal(), new Object[0]);
            }
            ticket.blankLine(1);
        }
        if (canceledOrders != null && canceledOrders.size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "Commandes annul\u00e9es", new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(turnoverCanceled), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, "Num date heure", "caissier Total");
                for (TicketInfo order : canceledOrders) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (AppLocal.PRINT_CANCELED_ORDERS_ON_Z && canceledNotes != null && canceledNotes.size() > 0) {
            double totalNoteCanceled = 0.0;
            for (TicketInfo order : canceledNotes) {
                totalNoteCanceled += order.getTotalOrder();
            }
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "Notes annul\u00e9es", new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(totalNoteCanceled), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, "Num date heure", "caissier Total");
                for (TicketInfo order : canceledNotes) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (equipments != null || not_available != null && !not_available.isEmpty()) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "CA par \u00e9quipement", new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            for (EquipmentTurnover equipment : equipments) {
                ticket.addNewLine(1, equipment.getName() + " : " + Formats.CURRENCY_PRINTED.formatValue(equipment.getTurnover()), new Object[0]);
            }
            if (not_available != null && !not_available.isEmpty()) {
                for (String equipmentNoAvailable : not_available) {
                    ticket.addNewLine(1, equipmentNoAvailable + " : \u00e9quipement indisponible", new Object[0]);
                }
            }
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
        mesBytesInteger.addAll(ticket.bytes);
        for (int h = 1; h < number_impression; ++h) {
            ticket.bytes.addAll(mesBytesInteger);
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", "L'impression du ticket de fermeture de caisse a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    public void printDeliverooTicket(TicketInfo order, MarqueNFC marqueNF) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        if (TicketUtils.getPicTicket() != null) {
            ticket.blankLine(1);
            ticket.setAlign(1);
            ticket.addImageTicket(TicketUtils.getPicTicket());
            ticket.blankLine(1);
        }
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        if (AppLocal.phoneRestaurant != null && !AppLocal.phoneRestaurant.isEmpty() && !AppLocal.phoneRestaurant.equals("")) {
            ticket.addNewLine(1, "TEL : " + AppLocal.phoneRestaurant, new Object[0]);
        }
        ticket.addNewLine(1, "Commande N\u00b0" + order.getNumero_platform_order(), new Object[0]);
        ticket.setBoldText(true);
        ticket.addNewLine(1, dateFormatterFull.format(order.getDate()) + " - " + order.getType().toUpperCase(), new Object[0]);
        ticket.setBoldText(false);
        this.checkAndShowInfoCustomer(order, ticket, 0);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "QT\u00c9 D\u00c9SIGNATION", "PRIX  TOTAL");
        ticket.addLineOfDashes();
        this.sortLinesOrder(order);
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProduct(line, ticket, order.isPaid(), order);
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Net \u00e0 payer :", order.printTotal());
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().equalsIgnoreCase("pourcentage")) {
                ticket.addNewLine(3, "R\u00e9duction ", Formats.CURRENCY_PRINTED.formatValue(-Math.abs(order.getDiscount() * order.getTotalOrder() / 100.0)));
            } else {
                ticket.addNewLine(3, "R\u00e9duction ", Formats.CURRENCY_PRINTED.formatValue(-Math.abs(order.getDiscount())));
            }
        }
        Collections.sort(order.getPayments(), new Comparator<PaymentInfo>(){

            @Override
            public int compare(PaymentInfo s1, PaymentInfo s2) {
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Ticket n\u00b0" + order.getNumero_platform_order(), "L'impression du ticket caisse a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    public void printKitchenTickets(TicketInfo order, String type, List<PrinterInfo> printers, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDineInLaterByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayByPrinter, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesTakeAwayLaterByPrinter, String status_borne, Decreaser decreaser, List<OptionItemOrder> optionsToprint, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesDeletedByPrinter, boolean first_part_of_order, LinkedHashMap<Integer, List<ZoneLines>> zoneLinesUpdatedByPrinter, LinkedHashMap<Integer, List<ZoneItems>> zoneSubItemsLaterByPrinter, boolean borne) {
        this.printKitchenTickets(order, type, printers, zoneLinesByPrinter, zoneLinesDineInLaterByPrinter, zoneLinesTakeAwayByPrinter, zoneLinesTakeAwayLaterByPrinter, status_borne, decreaser, optionsToprint, zoneLinesDeletedByPrinter, first_part_of_order, zoneLinesUpdatedByPrinter, zoneSubItemsLaterByPrinter, borne, false);
    }

    private String getPrefixSpace(int number_space, boolean addChar) {
        StringBuilder space = new StringBuilder();
        int max_space = AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET ? this.shift_after_name_goption : number_space * this.shift_option;
        for (int i = 0; i < max_space; ++i) {
            space.append(" ");
        }
        if (addChar) {
            space.append("|");
        }
        return space.toString();
    }

    private String getSourceOrder(TicketInfo ticket) {
        if (ticket.getOrdered_from() != null && ticket.getOrdered_from().equals("inside") && (ticket.getSent_from() == null || ticket.getSent_from().isEmpty())) {
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse")) {
                if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
                    return "Drive";
                }
                return "caisse";
            }
            return "borne cb";
        }
        if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
            return "Drive";
        }
        if (ticket.getSent_from() != null) {
            switch (ticket.getSent_from()) {
                case "borne": {
                    return "borne";
                }
                case "web": {
                    return "online";
                }
                case "Uber Eats": {
                    return "Uber Eats";
                }
                case "Just Eat": {
                    return "Just Eat";
                }
                case "Delivero": {
                    return "Delivero";
                }
            }
            return ticket.getSent_from();
        }
        return "";
    }

    public void printTicketContinuityMode(TicketInfo order, String value_reprint, String value_duplicata, String value_type_trans, Decreaser decreaser, MarqueNFC marqueNF) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        this.nombreLignesInCammande = 0;
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        if (marqueNF != null) {
            ticket.setTextSize(2, 2);
            if (marqueNF.getCompany() != null && !marqueNF.getCompany().isEmpty()) {
                ticket.addNewLine(1, marqueNF.getCompany(), new Object[0]);
            }
            if (marqueNF.getZipCode() != null && !marqueNF.getZipCode().isEmpty() && marqueNF.getAdresse1() != null && !marqueNF.getAdresse1().isEmpty()) {
                ticket.addNewLine(1, marqueNF.getZipCode() + " " + marqueNF.getAdresse1(), new Object[0]);
            }
            if (marqueNF.getCity() != null && !marqueNF.getCity().isEmpty()) {
                ticket.addNewLine(1, marqueNF.getCity(), new Object[0]);
            }
            ticket.setTextSize(1, 1);
        }
        ticket.blankLine(1);
        if (value_reprint.equals("O")) {
            ticket.addNewLine(1, "***R\u00e9impression***", new Object[0]);
        }
        if (value_duplicata.equals("O")) {
            ticket.addNewLine(1, "***DUPLICATA***", new Object[0]);
        }
        if (value_type_trans.equals("ADDI")) {
            ticket.addNewLine(1, "***Vente mise en attente***", new Object[0]);
        }
        if (order.isPaid() && order.getTotalOrder() < 0.0) {
            ticket.addNewLine(1, "***Remboursement***", new Object[0]);
        }
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, "Commande N" + order.getNumberOrderToPrint(), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        if (order.getNumTable() != 0) {
            ticket.addNewLine(0, "Table N " + order.getNumTable(), new Object[0]);
        }
        if (order.getCustomer() == null && order.getName_customer() != null && !order.getName_customer().isEmpty()) {
            ticket.addNewLine(0, "Client : " + order.getName_customer(), new Object[0]);
        }
        if (order.getCustomer() != null && order.getCustomer().getName() != null && !order.getCustomer().getName().isEmpty()) {
            ticket.addNewLine(0, "Client : " + order.getCustomer().getName(), new Object[0]);
        }
        if (order.getCustomer() != null && order.getCustomer().getPhone() != null && !order.getCustomer().getPhone().isEmpty()) {
            ticket.addNewLine(0, "T\u00e9l : " + order.getCustomer().printPhone(), new Object[0]);
        }
        ticket.addNewLine(0, dateFormatterFull.format(order.getDate()), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        this.sortLinesOrder(order);
        ticket.addNewLine(3, "QTE DESIGNATION", "PRIX  TOTAL");
        for (TicketLineInfo line : order.getLines()) {
            if (line.isNext()) continue;
            this.appendProduct(line, ticket, false, order);
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.addNewLine(3, "SOUS-TOTAL", Formats.CURRENCY.formatValue(order.getTotalHTBeforeDiscount()));
        for (TaxLineInfo taxe : order.getTaxes()) {
            ticket.addNewLine(3, taxe.getName(), Formats.CURRENCY.formatValue(taxe.getAmount()));
        }
        ticket.addNewLine(3, "TOTAL", Formats.CURRENCY.formatValue(order.getTotal()));
        if (order.getDiscount() > 0.0) {
            if (order.getTypeDiscount().contains("ourcen")) {
                ticket.addNewLine(3, "Reduction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount() * order.getRealTotal() / 100.0)));
            } else {
                ticket.addNewLine(3, "Reduction ", TaxLineInfo.printThisDoubleAsAmount(-Math.abs(order.getDiscount())));
            }
            ticket.addNewLine(3, "Sous total. ", Formats.CURRENCY.formatValue(order.getTotalHT()));
        }
        ticket.addLineOfDashes();
        double renduMonnaie = 0.0;
        if (order.isPaid()) {
            boolean isNegative = false;
            if (order.getTotalOrder() < 0.0) {
                isNegative = true;
            }
            for (PaymentInfo payment : order.getPayments()) {
                if (!isNegative) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
                renduMonnaie += payment.getTendered() - payment.getTotal();
            }
            if (isNegative) {
                for (PaymentInfo payment : order.getPayments()) {
                    ticket.addNewLine(3, this.getOfficialPayement(payment.getName()), payment.printTotal());
                }
            }
            renduMonnaie = NumericUtils.round(renduMonnaie);
            if (AppLocal.ISRENDMONNAIE.booleanValue() && renduMonnaie > 0.0 && order.getTotalOrder() > 0.0) {
                ticket.addNewLine(1, "Rendu monnaie: " + Formats.CURRENCY.formatValue(renduMonnaie), new Object[0]);
                for (PaymentInfo payment : order.getPayments()) {
                    if (!(renduMonnaie > 0.0) || !(payment.getTendered() - payment.getTotal() > 0.0)) continue;
                    ticket.addNewLine(3, "Rendu " + this.getOfficialPayement(payment.getName()), Formats.CURRENCY.formatValue(payment.getTendered() - payment.getTotal()));
                }
            }
            ticket.addLineOfDashes();
        }
        ticket.setBoldText(true);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(3, "Total : ", TaxLineInfo.printThisDoubleAsAmount(order.getTotal()));
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        if (AppLocal.MODULE_MEV && AppLocal.MEV_TPS != null && !AppLocal.MEV_TPS.isEmpty() && AppLocal.MEV_TVQ != null && !AppLocal.MEV_TVQ.isEmpty()) {
            ticket.addLineOfDashes();
            ticket.addNewLine(0, "TPS : " + AppLocal.MEV_TPS, new Object[0]);
            ticket.addNewLine(0, "TVQ : " + AppLocal.MEV_TVQ, new Object[0]);
        }
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        if (order.getHolder() != null && !order.getHolder().isEmpty()) {
            ticket.blankLine(1);
            ticket.addNewLine(0, order.getHolder(), new Object[0]);
        }
        if (AppLocal.footer != null) {
            ticket.addNewLine(1, AppLocal.footer, new Object[0]);
        }
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Commande n\u00b0" + order.getNumberOrder(), "L'impression du ticket caisse a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private String getTextNumberOrder(TicketInfo order) {
        if (AppLocal.PRINT_TEXT_DISHOP_IN_TICKETS) {
            if (order.getSent_from() != null && order.getSent_from().equals("Dishop")) {
                return AppLocal.getIntString("Text.order") + " DISHOP N\u00b0" + order.getNumberOrder(true, false);
            }
            return AppLocal.getIntString("Label.num.order") + order.getNumberOrder(true, false);
        }
        return AppLocal.getIntString("Label.num.order") + order.getNumberOrderToPrint();
    }

    private String getNumberInCaseOfPlatformOrder(TicketInfo order) {
        if (AppLocal.PRINT_TEXT_DISHOP_IN_TICKETS) {
            return order.getNumberOrderToPrint();
        }
        return order.getNumberOrder(true, false);
    }

    private void adddetailSubProductLabel(TicketLineInfo product, ProductTicket productMenu) {
        this.ticket.setTextSize(1, 2);
        if (AppLocal.PRODUCT_KITCHEN_BOLD) {
            this.ticket.setBoldText(true);
        }
        String str = "";
        this.addNameProduitLabel(this.ticket, productMenu.getNameProduct(), AppLocal.PRINT_FOND, null, "");
        this.ticket.blankLine(1);
        for (ItemOrderInfo ingredient : product.getListIngredients()) {
            if (ingredient.getIdProduct() != productMenu.getIdProduct() || ingredient.getIdCarte() != productMenu.getIdCarte() || ingredient.getIndex_carte() != productMenu.getIndex_carte()) continue;
            str = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
            this.ticket.addNewLine(1, str, new Object[0]);
        }
        int id_groupe_option = 0;
        for (OptionItemOrder supplement : product.getListSupplements()) {
            if (supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != productMenu.getIdProduct() || supplement.getIdCarte() != productMenu.getIdCarte() || supplement.getIndex_carte() != productMenu.getIndex_carte()) continue;
            if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                if (id_groupe_option != supplement.getId_groupe_option()) {
                    String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                    this.ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                }
                id_groupe_option = supplement.getId_groupe_option();
            }
            this.appendSupplemntKitchen(supplement, this.ticket);
        }
    }

    private void adddetailProductLabel(TicketLineInfo product) {
        this.ticket.setTextSize(1, 2);
        if (AppLocal.PRODUCT_KITCHEN_BOLD) {
            this.ticket.setBoldText(true);
        }
        String zone_name = "";
        try {
            ZoneInfo zone = AppLocal.dlItems.getZoneInfoById(AppLocal.dlSales.getProductInfoById(product.getProductID()).getZoneId());
            zone_name = zone != null ? zone.getName() : "";
        }
        catch (Exception ext) {
            LogToFile.log("severe", null, ext);
        }
        this.addNameProduitLabel(this.ticket, product.printName(true), AppLocal.PRINT_FOND, product.getSizeProduct(), zone_name);
        String str = "";
        this.ticket.blankLine(1);
        for (ItemOrderInfo ingredient : product.getListIngredients()) {
            if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
            str = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
            this.ticket.addNewLine(1, str, new Object[0]);
        }
        int id_groupe_option = 0;
        for (OptionItemOrder supplement : product.getListSupplements()) {
            if (supplement.getId_sub_product() != 0 || supplement.isNo_printable() || supplement.isHidden_in_kitchen() || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
            if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                if (id_groupe_option != supplement.getId_groupe_option()) {
                    String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                    this.ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                }
                id_groupe_option = supplement.getId_groupe_option();
            }
            this.appendSupplemntKitchen(supplement, this.ticket);
        }
        if (product.getNote() != null && !product.getNote().isEmpty()) {
            this.addNote(this.ticket, product.getNote());
        }
    }

    private void addNameProduitLabel(Ticket2 ticket, String nameProduct, boolean background_black, String sizeProduct, String name_zone) {
        Object str = "";
        nameProduct = name_zone != null && !name_zone.equals("") ? nameProduct + "(" + name_zone + ")" : nameProduct;
        str = (String)str + PrinterHelper.formatMax(nameProduct);
        if (AppLocal.UPPERCASE_KITCHEN_TICKET) {
            str = ((String)str).toUpperCase();
        }
        String[] tab_chaines = ((String)str).split(" ");
        ArrayList<String> chaines = new ArrayList<String>();
        Object chaine_tmp = "";
        int width_chaine = 2;
        for (String chaine : tab_chaines) {
            if ((((String)chaine_tmp).length() + chaine.length() + 1) * width_chaine <= TICKET_WIDTH) {
                chaine_tmp = (String)chaine_tmp + chaine + " ";
                continue;
            }
            String string_to_add = chaine_tmp;
            string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
            chaines.add(string_to_add);
            chaine_tmp = chaine + " ";
        }
        String string_to_add = chaine_tmp;
        string_to_add = string_to_add.substring(0, string_to_add.length() - 1);
        chaines.add(string_to_add);
        for (String chaine : chaines) {
            ticket.setTextSize(1, 1);
            ticket.setReversedText(false);
            ticket.setTextSize(2, 2);
            if (background_black) {
                ticket.setReversedText(true);
            }
            int size_chaine = chaine.length() * width_chaine;
            int numSpace = (TICKET_WIDTH - size_chaine) / width_chaine;
            ticket.append(chaine);
            for (int i = 0; i < numSpace; ++i) {
                ticket.append(" ");
            }
        }
        ticket.setTextSize(1, 2);
        ticket.setReversedText(false);
        if (sizeProduct != null && !sizeProduct.isEmpty()) {
            ticket.blankLine(2);
            ticket.addNewLine(1, "TAILLE : " + sizeProduct, new Object[0]);
            ticket.blankLine(1);
        } else {
            ticket.blankLine(2);
        }
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
    }

    private void appendOrder(TicketInfo order, Ticket2 ticket) {
        this.appendOrder(order, ticket, false);
    }

    private boolean isValidPrintInfosCustomer(TicketInfo order) {
        return AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Borne") && (order.getSent_from() == null || !order.getSent_from().equalsIgnoreCase("borne")) && (AppLocal.ADD_CUSTOMER_INFO_TO_TICKET || order.getOrdered_from() != null && order.getOrdered_from().equalsIgnoreCase("outside") && order.getSent_from() != null && !order.getSent_from().equalsIgnoreCase("caisse") || order.getType() != null && !order.getType().equalsIgnoreCase("Sur Place") && (!order.getType().equalsIgnoreCase("A Emporter") || order.isTake_away_phone()));
    }

    private void initPlatFromInfosOrder() {
        this.platFormTypesOrder = new ArrayList<String>();
        this.platFormTypesOrder.add("Delivero");
        this.platFormTypesOrder.add("Uber Eats");
        this.platFormTypesOrder.add("Just Eat");
        this.platFormTypesOrder.add("Smood");
        this.platFormTypesOrder.add("Deliveroo");
        this.platFormSourcesOrder = new ArrayList<String>();
        this.platFormSourcesOrder.add("Delivero");
        this.platFormSourcesOrder.add("Uber Eats");
        this.platFormSourcesOrder.add("Just Eat");
        this.platFormSourcesOrder.add("Smood");
        this.platFormSourcesOrder.add("Deliveroo");
        this.platFormSourcesOrder.add("Dishop");
    }

    public void printCloseCaisseCenter(int nbOrder, double caNet, List<Course> courses, double caCanceld, double tvas, List<PaymentLine> payments, List<TaxeLine> taxes, List<UserCaisseInfo> users, CaisseInfo caisse, MarqueNFC marqueNF, Date dateStart, Date dateEnd, String title, double discountOrders, double discountLines, CaisseZ zcaisse, List<TicketInfo> orders, List<LogPanier> logs, List<RankTypeOrder> dataTypeOrders, Decreaser decreaser, String type_rapport, int number_impression, double fondcaisseReel, double fondcaissecalcule, List<TicketInfo> detailDiscountOrders, List<TicketInfo> notesCanceled, List<RankTypeOrder> dataTypePlatformOrders, List<GroupedTax> globalTaxes, double total_ht_taxable, double total_ht_no_taxable) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.setBoldText(false);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(1, AppLocal.getIntString("Text.financial.report").toUpperCase(), new Object[0]);
        ticket.addNewLine(1, title.toUpperCase(), new Object[0]);
        ticket.setTextSize(1, 1);
        if (type_rapport != null && (type_rapport.equals("m") || type_rapport.equals("month"))) {
            ticket.addNewLine(1, DateUtils.getNameOfMonth(dateStart.getMonth() + 1) + " " + (dateStart.getYear() + 1900), new Object[0]);
        } else if (type_rapport != null && type_rapport.equals("a")) {
            ticket.addNewLine(1, String.valueOf(dateStart.getYear() + 1900), new Object[0]);
        } else {
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateStart) : this.dateFormatter.format(dateStart)) + "    " + this.HorraireFormatter.format(dateStart), new Object[0]);
            ticket.addNewLine(1, (dateStart.getYear() == dateEnd.getYear() ? this.dateFormatter.format(dateEnd) : this.dateFormatter.format(dateEnd)) + "    " + this.HorraireFormatter.format(dateEnd), new Object[0]);
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.turnover"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(caNet), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, nbOrder + " " + AppLocal.getIntString("Text.orders"), new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        if (AppLocal.MODULE_TVA_GLOBAL) {
            double total_before_taxes = caNet;
            for (GroupedTax globalTaxe : globalTaxes) {
                total_before_taxes -= globalTaxe.getTotal_tax();
            }
            ticket.addNewLine(3, "Total avant taxes : ", Formats.CURRENCY.formatValue(total_before_taxes));
            if (total_ht_taxable != 0.0 || total_ht_no_taxable != 0.0) {
                ticket.addNewLine(3, "Total HT Taxable : ", Formats.CURRENCY.formatValue(total_ht_taxable));
                ticket.addNewLine(3, "Total HT no Taxable : ", Formats.CURRENCY.formatValue(total_ht_no_taxable));
            }
            for (GroupedTax globalTaxe : globalTaxes) {
                ticket.addNewLine(3, globalTaxe.getName(), Formats.CURRENCY.formatValue(globalTaxe.getTotal_tax()));
            }
        } else {
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "TVA", new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.addNewLine(3, "TVA        Total TVA", "Total HT   Total TTC");
            double total_Tva = 0.0;
            double total_HT = 0.0;
            double total_TTC = 0.0;
            for (TaxeLine taxe : taxes) {
                if (taxe.getTotal() == 0.0) continue;
                String name_taxe = taxe.getName() != null && !taxe.getName().isEmpty() ? taxe.getName() : "";
                int nmbSpce_name = 11 - name_taxe.length();
                StringBuilder stringBuilderName = new StringBuilder("");
                stringBuilderName.append(name_taxe);
                for (int i = 0; i < nmbSpce_name; ++i) {
                    stringBuilderName.append(" ");
                }
                int nmbSpce = 11 - taxe.printTTC().length();
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(taxe.printHT());
                for (int i = 0; i < nmbSpce; ++i) {
                    stringBuilder.append(" ");
                }
                ticket.addNewLine(3, stringBuilderName.toString() + taxe.printTaxe(), stringBuilder.toString() + taxe.printTTC());
                total_Tva += taxe.getTax();
                total_HT += taxe.getHt();
                total_TTC += taxe.getTotal();
            }
            int nmbSpce = 11 - TaxLineInfo.printThisDoubleAsAmount(total_TTC).length();
            StringBuilder stringTotal = new StringBuilder("");
            stringTotal.append(TaxLineInfo.printThisDoubleAsAmount(total_HT));
            for (int i = 0; i < nmbSpce; ++i) {
                stringTotal.append(" ");
            }
            ticket.addNewLine(3, "Total      " + TaxLineInfo.printThisDoubleAsAmount(total_Tva), stringTotal + TaxLineInfo.printThisDoubleAsAmount(total_TTC));
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition encaissement", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (PaymentLine paymentLine : payments) {
            if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                ticket.addNewLine(1, this.getOfficialPayement(paymentLine.getM_PaymentType()) + " : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            if (paymentLine.getM_PaymentValue() > 0.0) {
                ticket.addNewLine(1, "Avoir Encaiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
                continue;
            }
            ticket.addNewLine(1, "Avoir D\u00e9caiss\u00e9 : " + Formats.CURRENCY_PRINTED.formatValue(paymentLine.getM_PaymentValue()), new Object[0]);
        }
        for (PaymentLine paymentLine : payments) {
            switch (paymentLine.getM_PaymentType()) {
                case "CB": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " " + AppLocal.getIntString("Button.cb"), new Object[0]);
                    break;
                }
                case "Carte Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Carte Ticket Resto", new Object[0]);
                    break;
                }
                case "Ticket Resto": {
                    ticket.addNewLine(1, paymentLine.getNombre() + " Tickets Resto", new Object[0]);
                }
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "R\u00e9partition type", new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        for (RankTypeOrder type : dataTypeOrders) {
            ticket.addNewLine(1, AppConstants.getTypeOrder(type.getName()) + " : " + Formats.CURRENCY_PRINTED.formatValue(type.getCa()), new Object[0]);
        }
        if (dataTypePlatformOrders != null && !dataTypePlatformOrders.isEmpty()) {
            ticket.blankLine(1);
            for (RankTypeOrder type : dataTypePlatformOrders) {
                ticket.addNewLine(1, type.getName() + " : " + Formats.CURRENCY.formatValue(type.getCa()), new Object[0]);
            }
        }
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion"), new Object[0]);
        ticket.setBoldText(false);
        ticket.setTextSize(1, 1);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.orders") + ": " + Formats.CURRENCY_PRINTED.formatValue(discountOrders), new Object[0]);
        ticket.addNewLine(1, AppLocal.getIntString("Text.promotion.items") + ": " + Formats.CURRENCY_PRINTED.formatValue(discountLines), new Object[0]);
        ticket.blankLine(1);
        if (detailDiscountOrders != null && detailDiscountOrders.size() > 0) {
            ticket.blankLine(2);
            ticket.addNewLine(3, "Num date heure", "caissier R\u00e9duction");
            for (TicketInfo order : detailDiscountOrders) {
                this.appendOrderDiscount(order, ticket);
            }
            ticket.blankLine(1);
        }
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setTextSize(1, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Label.cashier"), new Object[0]);
        ticket.setTextSize(1, 1);
        ticket.setBoldText(false);
        for (UserCaisseInfo user : users) {
            ticket.addNewLine(1, user.getName() + " : " + user.printTotal(), new Object[0]);
        }
        ticket.blankLine(1);
        double val_course = 0.0;
        if (courses != null && courses.size() > 0) {
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Button.courses"), new Object[0]);
            ticket.setBoldText(false);
            ticket.setTextSize(1, 1);
            this.addColumnCourse(AppLocal.getIntString("Text.article"), 0.3, ticket);
            this.addColumnCourse(AppLocal.getIntString("Text.price"), 0.2, ticket);
            this.addColumnCourse(AppLocal.getIntString("Label.heure"), 0.2, ticket);
            this.addColumnCourse(AppLocal.getIntString("Label.cashier"), 0.3, ticket);
            ticket.blankLine(1);
            for (Course course : courses) {
                val_course += course.getPrice();
                this.appendCourse(course, ticket);
            }
        }
        if (AppLocal.PRINT_LOG_PANIER_ON_Z && logs != null && logs.size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Text.canceled.products"), new Object[0]);
            ticket.blankLine(1);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addNewLine(3, "QTE " + AppLocal.getIntString("Text.designation"), AppLocal.getIntString("Text.price") + "  H.Supp");
            for (LogPanier log : logs) {
                this.appendLog(log, ticket);
            }
        }
        if (orders != null && orders.size() > 0) {
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Text.canceled.orders"), new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(caCanceld), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, "Num date heure", "caissier Total");
                for (TicketInfo order : orders) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (AppLocal.PRINT_CANCELED_ORDERS_ON_Z && notesCanceled != null && notesCanceled.size() > 0) {
            double totalNoteCanceled = 0.0;
            for (TicketInfo order : notesCanceled) {
                totalNoteCanceled += order.getTotalOrder();
            }
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, "Notes annul\u00e9es", new Object[0]);
            ticket.addNewLine(1, Formats.CURRENCY_PRINTED.formatValue(totalNoteCanceled), new Object[0]);
            if (AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z) {
                ticket.blankLine(1);
                ticket.setTextSize(1, 1);
                ticket.setBoldText(false);
                ticket.addNewLine(3, "Num date heure", "caissier Total");
                for (TicketInfo order : notesCanceled) {
                    this.appendOrder(order, ticket, true);
                }
            }
        }
        if (title.equalsIgnoreCase(" Z caisse ") || title.equalsIgnoreCase(" X caisse ")) {
            double ecart;
            ticket.blankLine(1);
            ticket.addLineOfDashes();
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.setBoldText(true);
            ticket.addNewLine(1, AppLocal.getIntString("Label.cash.fund"), new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            if (title.equalsIgnoreCase(" Z caisse ")) {
                if (zcaisse != null) {
                    ticket.addNewLine(1, " " + AppLocal.getIntString("Text.opening") + " : " + Formats.CURRENCY_PRINTED.formatValue(zcaisse.getFund_open()), new Object[0]);
                    if (zcaisse.getFund_close() > 0.0) {
                        ticket.addNewLine(1, " " + AppLocal.getIntString("Text.closing") + " :" + Formats.CURRENCY_PRINTED.formatValue(zcaisse.getFund_close()), new Object[0]);
                    }
                } else if (caisse != null) {
                    ticket.addNewLine(1, " " + AppLocal.getIntString("Text.opening") + " : " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondCaisse()), new Object[0]);
                    ticket.addNewLine(1, " " + AppLocal.getIntString("Text.closing") + " :" + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondClose()), new Object[0]);
                }
            }
            if (title.equalsIgnoreCase(" X caisse ")) {
                ticket.addNewLine(1, " " + AppLocal.getIntString("Text.opening") + " : " + Formats.CURRENCY_PRINTED.formatValue(caisse.getFondCaisse()), new Object[0]);
            }
            if (fondcaisseReel > 0.0) {
                ticket.addNewLine(1, " Fond de caisse r\u00e9el avant fermeture :" + Formats.CURRENCY_PRINTED.formatValue(fondcaisseReel), new Object[0]);
            }
            if (fondcaissecalcule > 0.0) {
                ticket.addNewLine(1, " Fond de caisse calcul\u00e9 apr\u00e8s fermeture:" + Formats.CURRENCY_PRINTED.formatValue(fondcaissecalcule), new Object[0]);
            }
            if ((ecart = fondcaissecalcule - fondcaisseReel) > 0.0) {
                ticket.addNewLine(1, "\u00c9cart :" + Formats.CURRENCY_PRINTED.formatValue(ecart), new Object[0]);
            }
        }
        ticket.blankLine(6);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        ArrayList<Integer> mesBytesInteger = new ArrayList<Integer>();
        mesBytesInteger.addAll(ticket.bytes);
        for (int h = 1; h < number_impression; ++h) {
            ticket.bytes.addAll(mesBytesInteger);
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Fermeture de caisse", AppLocal.getIntString("Messeage.error.print.close"), this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private String textAfterCheckLanguage(String text) {
        if (AppLocal.PRINT_ARABIC && AppLocal.PRINT_RTL && com.openbravo.pos.util.StringUtils.containsArabic(text)) {
            return com.openbravo.pos.util.StringUtils.textRTL(text);
        }
        return text;
    }

    private void addNameIngredient(Ticket2 ticket, ItemOrderInfo ingredient) {
        StringBuilder textByLangaugeBuilder = new StringBuilder();
        if (AppLocal.PRINT_ARABIC) {
            String arabic_name = ingredient.getNameByLanguage("ar");
            String english_name = ingredient.getNameByLanguage("en");
            if (english_name != null && !english_name.isEmpty()) {
                textByLangaugeBuilder.append(english_name);
                if (arabic_name != null && !arabic_name.isEmpty()) {
                    textByLangaugeBuilder.append("(");
                }
            }
            if (arabic_name != null && !arabic_name.isEmpty()) {
                textByLangaugeBuilder.append(this.textAfterCheckLanguage(arabic_name));
            }
            if (english_name != null && !english_name.isEmpty()) {
                textByLangaugeBuilder.append(english_name);
                if (arabic_name != null && !arabic_name.isEmpty()) {
                    textByLangaugeBuilder.append(")");
                }
            }
        }
        String nameIngredient = textByLangaugeBuilder.toString().isEmpty() ? ingredient.printName(true) : textByLangaugeBuilder.toString();
        String str = PrinterHelper.formatMax("#### " + this.textAfterCheckLanguage(AppLocal.getIntString("Label.without")) + " " + nameIngredient + " ####");
        ticket.addNewLine(1, str, new Object[0]);
    }

    private void addNameItem(Ticket2 ticket, ProductTicket productMenu) {
        StringBuilder textByLangaugeBuilder = new StringBuilder();
        if (AppLocal.PRINT_ARABIC) {
            String arabic_name = productMenu.getNameByLanguage("ar");
            String english_name = productMenu.getNameByLanguage("en");
            if (english_name != null && !english_name.isEmpty()) {
                textByLangaugeBuilder.append(english_name);
                if (arabic_name != null && !arabic_name.isEmpty()) {
                    textByLangaugeBuilder.append("(");
                }
            }
            if (arabic_name != null && !arabic_name.isEmpty()) {
                textByLangaugeBuilder.append(this.textAfterCheckLanguage(arabic_name));
            }
            if (english_name != null && !english_name.isEmpty() && arabic_name != null && !arabic_name.isEmpty()) {
                textByLangaugeBuilder.append(")");
            }
        }
        String nameItem = textByLangaugeBuilder.toString().isEmpty() ? this.textAfterCheckLanguage(productMenu.getNameProduct()) : textByLangaugeBuilder.toString();
        String full_name_item = productMenu.getNumberProduct() > 1 ? productMenu.getNumberProduct() + " " + nameItem : nameItem;
        String str = PrinterHelper.formatMax("  " + full_name_item);
        ticket.setTextSize(2, 2);
        ticket.addNewLine(0, str, new Object[0]);
        ticket.setTextSize(1, 2);
    }

    private void addTypeOrder(Ticket2 ticket, TicketInfo order) {
        if (AppLocal.PRINT_ARABIC) {
            ticket.setTextSize(2, 2);
            ticket.setReversedText(true);
            ticket.addNewLine(1, " " + AppConstants.getTypeOrderEN(order.getType()) + " ", new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, " " + this.textAfterCheckLanguage(AppConstants.getTypeOrderAR(order.getType())) + " ", new Object[0]);
            ticket.setTextSize(1, 1);
        } else {
            ticket.setTextSize(2, 2);
            ticket.setReversedText(true);
            ticket.addNewLine(1, " " + this.textAfterCheckLanguage(AppConstants.getTypeOrder(order.getType())) + " ", new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
        }
    }

    private void addStatusOrder(Ticket2 ticket, TicketInfo order, boolean borne) {
        if (AppLocal.PRINT_ARABIC) {
            String status_order_ar;
            String status_order_en = order.isPaid() || order.isPlatform_order() ? "PAID" : "UNPAID";
            String string = status_order_ar = order.isPaid() || order.isPlatform_order() ? "\u0645\u062f\u0641\u0648\u0639\u0629 \u0627\u0644\u0623\u062c\u0631" : "\u063a\u064a\u0631 \u0645\u062f\u0641\u0648\u0639\u0629 \u0627\u0644\u0623\u062c\u0631";
            if (!order.isPaid()) {
                ticket.setReversedText(true);
            }
            ticket.addNewLine(1, status_order_en, new Object[0]);
            ticket.setReversedText(false);
            ticket.addNewLine(1, this.textAfterCheckLanguage(status_order_ar), new Object[0]);
        } else {
            String status_order;
            String string = status_order = order.isPaid() || order.isPlatform_order() ? AppLocal.getIntString("Text.paid") : AppLocal.getIntString("Text.not.paid");
            if (borne && order.isPaid()) {
                status_order = AppLocal.getIntString("Text.paid.at.terminal");
            }
            if (!order.isPaid()) {
                ticket.setReversedText(true);
            }
            ticket.addNewLine(1, this.textAfterCheckLanguage(status_order), new Object[0]);
            ticket.setReversedText(false);
        }
    }

    private void addTitleRecap(Ticket2 ticket, TicketInfo order, String orderNum) {
        if (AppLocal.PRINT_ARABIC) {
            ticket.addNewLine(1, "ORDER SUMMARY " + orderNum, new Object[0]);
            ticket.addNewLine(1, this.textAfterCheckLanguage("\u0645\u0644\u062e\u0635 \u0627\u0644\u0637\u0644\u0628"), new Object[0]);
        } else {
            String titleRecap = this.textAfterCheckLanguage(AppLocal.getIntString("Text.recap.order")) + " " + orderNum;
            if (titleRecap.length() * 3 + 1 > TICKET_WIDTH) {
                ticket.addNewLine(1, this.textAfterCheckLanguage(AppLocal.getIntString("Text.recap.order")), new Object[0]);
                ticket.addNewLine(1, orderNum, new Object[0]);
            } else {
                ticket.addNewLine(1, this.textAfterCheckLanguage(AppLocal.getIntString("Text.recap.order")) + " " + orderNum, new Object[0]);
            }
        }
    }

    private void addMessageFooter(Ticket2 ticket) {
        ticket.setTextSize(2, 2);
        if (AppLocal.PRINT_ARABIC) {
            ticket.addNewLine(1, "please proceed to checkout", new Object[0]);
            ticket.addNewLine(1, this.textAfterCheckLanguage("\u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062a\u0627\u0628\u0639\u0629 \u0625\u0644\u0649 \u0645\u0631\u062d\u0644\u0629 \u0627\u0644\u062f\u0641\u0639"), new Object[0]);
        } else {
            ticket.addNewLine(1, "MERCI DE PASSER \u00c0 LA CAISSE", new Object[0]);
        }
        ticket.setTextSize(1, 1);
    }

    private void setIdentificationLogiciel(Ticket2 ticket, String signature, String versionSoftware, String nameSoftware) {
        ticket.addNewLine(1, "(NF525) B 0413 " + signature.charAt(2) + signature.charAt(6) + signature.charAt(12) + signature.charAt(18) + " " + nameSoftware + "  " + versionSoftware, new Object[0]);
    }

    private void setStatusPaid(Ticket2 ticket, TicketInfo order, boolean borne) {
        String status_order;
        boolean paid = false;
        paid = order.isPaid() ? true : (order.getSent_from() != null && order.getSent_from().equalsIgnoreCase("Dishop") ? order.getModePayment() != null && order.getModePayment().equals("stripe") : order.isPlatform_order());
        String string = status_order = paid ? AppLocal.getIntString("Text.paid") : AppLocal.getIntString("Text.not.paid");
        if (borne && order.isPaid()) {
            status_order = AppLocal.getIntString("Text.paid.at.terminal");
        }
        if (!paid) {
            ticket.setReversedText(true);
        }
        ticket.addNewLine(1, status_order, new Object[0]);
        ticket.setReversedText(false);
    }

    private void appendOrderDiscount(TicketInfo order, Ticket2 ticket) {
        ticket.addNewLine(3, order.getNumberOrderTorint() + " " + DateUtils.FORMATTER_DATE_HOUR.format(order.getDate()), order.getNameUser() + " " + Formats.CURRENCY.formatValue(order.getDiscountOrderAndLines()));
    }

    public void printTPETicket(String ticketContent, BufferedImage qrCodeImage) {
        int TICKET_WIDTH = 384;
        Ticket2 ticket = new Ticket2(384, 384);
        String[] lines = ticketContent.split("\n");
        boolean isFirstCGCombined = false;
        for (String line : lines) {
            line = line.trim();
            line = line.replace("))))", "");
            if (!isFirstCGCombined && line.startsWith("cG")) {
                String combinedText = "CENTRE MONETIQUE INTERBANCAIRE";
                ticket.setBoldText(true);
                ticket.addNewLine(1, combinedText, new Object[0]);
                ticket.setBoldText(false);
                isFirstCGCombined = true;
                continue;
            }
            if (line.startsWith("cG") && !line.contains("ANNULATION") && !line.contains("DEBIT")) continue;
            if (line.startsWith("gN") || line.startsWith("gG")) {
                ticket.setTextSize(1, 1);
                ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
                continue;
            }
            if (line.startsWith("dG")) {
                ticket.setTextSize(2, 2);
                ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
                ticket.blankLine(1);
                continue;
            }
            if (line.startsWith("sN")) {
                ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
                ticket.addLineOfDashes();
                continue;
            }
            if (line.startsWith("cN")) {
                ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
                continue;
            }
            if (line.startsWith("MONTANT:")) {
                ticket.addNewLine(0, line, new Object[0]);
                ticket.blankLine(1);
            }
            if (line.contains("TICKET A") || line.contains("TICKET A")) {
                ticket.setTextSize(1, 1);
                ticket.setBoldText(true);
                ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
                ticket.blankLine(1);
                continue;
            }
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, line.substring(2).trim(), new Object[0]);
            ticket.blankLine(1);
        }
        if (!ticketContent.startsWith("002A")) {
            ticket.blankLine(1);
        }
        if (qrCodeImage != null) {
            ticket.blankLine(1);
            ticket.addImage(qrCodeImage);
        }
        ticket.blankLine(3);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Ticket TPE", "L'impression du ticket a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, null);
    }

    private void addNameZone(int numberZones, ZoneLines zoneLine, Ticket2 ticket) {
        if (!(zoneLine.getName() == null || numberZones <= 1 && zoneLine.getName().equalsIgnoreCase("default"))) {
            String nameZone = zoneLine.getName().equalsIgnoreCase("default") ? AppLocal.getIntString("Text.default") : zoneLine.getName();
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, "Zone " + nameZone, new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.addLineOfDashes();
        }
    }

    private void printLabel(ItemLabel itemLabel, PrinterInfo printer, int indexLabel, int numberItems, String date, boolean lastElement, GenPDF genPDF, Decreaser decreaser) {
        int index = indexLabel;
        System.out.println("numberItems : " + numberItems);
        for (int z = 1; z <= (int)itemLabel.getQuantity(); ++z) {
            String numLabel = index++ + "/" + numberItems;
            Object commentaire = "";
            if (AppLocal.printNote.booleanValue() && itemLabel.getComment() != null && !itemLabel.getComment().isEmpty()) {
                commentaire = "\n(NB: " + itemLabel.getComment() + ")";
            }
            StringBuilder optionsBuilder = new StringBuilder();
            if (itemLabel.getIngredientsNames() != null) {
                optionsBuilder.append(itemLabel.getIngredientsNames());
            }
            if (itemLabel.getSupplementsName() != null) {
                optionsBuilder.append(itemLabel.getSupplementsName());
            }
            if (itemLabel.getSubItemsNames() != null) {
                optionsBuilder.append(itemLabel.getSubItemsNames());
            }
            if (commentaire != null) {
                optionsBuilder.append((String)commentaire);
            }
            String options = optionsBuilder.toString();
            for (int i = 0; i < printer.getNumber(); ++i) {
                Object bipper = "";
                if (itemLabel.getBipper() != 0) {
                    bipper = "BIP " + itemLabel.getBipper();
                }
                try {
                    boolean doCut = lastElement && z == (int)itemLabel.getQuantity();
                    String dateAndBipperOrPlusTard = date;
                    if (itemLabel.getTimeServed() != null && itemLabel.getTimeServed().equalsIgnoreCase("later")) {
                        dateAndBipperOrPlusTard = "Emporter plus tard";
                    }
                    StringBuilder name = new StringBuilder();
                    if (itemLabel.getSizeProduct() != null && !itemLabel.getSizeProduct().isEmpty() && AppLocal.LABEL_SIZE_FIRST) {
                        name.append(itemLabel.getSizeProduct()).append(" - ");
                    }
                    name.append(itemLabel.getNameProduct());
                    if (itemLabel.getSizeProduct() != null && !itemLabel.getSizeProduct().isEmpty() && !AppLocal.LABEL_SIZE_FIRST) {
                        name.append(" - ").append(itemLabel.getSizeProduct());
                    }
                    String productSizeAndName = name.toString();
                    System.out.println("itemLabel.getPlaceServed() : " + itemLabel.getTypeOrder());
                    Object typeOrder_nameZone = itemLabel.getTypeOrder();
                    if (itemLabel.getZoneName() != null) {
                        typeOrder_nameZone = (String)typeOrder_nameZone + "\n" + itemLabel.getZoneName();
                    }
                    genPDF.generateLabelPdf(printer, printer.getIp(), printer.getNamePrinter(), (String)typeOrder_nameZone, "N\u00b0" + itemLabel.getNumberOrder(), productSizeAndName, numLabel, options, dateAndBipperOrPlusTard, itemLabel.getStatus(), doCut, (String)bipper, decreaser, index);
                    continue;
                }
                catch (IOException ex) {
                    try {
                        Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "L'impression de l'etiquette", new Date().getTime(), ""));
                    }
                    catch (IOException ext) {
                        LogToFile.log("severe", null, ext);
                    }
                    LogToFile.log("severe", null, ex);
                    continue;
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    private void printLabelNormal(TicketInfo order, ItemLabel itemLabel, PrinterInfo printer, int indexLabel, int numberItems, Decreaser decreaser) {
        this.headerKitchenTicketLabel(order, itemLabel.getNumberOrder(), indexLabel - 1);
        this.ticket.setTextSize(1, 2);
        if (AppLocal.PRODUCT_KITCHEN_BOLD) {
            this.ticket.setBoldText(true);
        }
        String zone_name = itemLabel.getZoneName();
        this.addNameProduitLabel(this.ticket, itemLabel.printName(true), AppLocal.PRINT_FOND, itemLabel.getSizeProduct(), zone_name);
        String str = "";
        this.ticket.blankLine(1);
        for (ItemOrderInfo ingredient : itemLabel.getIngredients()) {
            str = PrinterHelper.formatMax("#### SANS " + ingredient.getNameSupplement() + " ####");
            this.ticket.addNewLine(1, str, new Object[0]);
        }
        int id_groupe_option = 0;
        for (OptionItemOrder supplement : itemLabel.getSupplements()) {
            if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                if (id_groupe_option != supplement.getId_groupe_option()) {
                    String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                    this.ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                }
                id_groupe_option = supplement.getId_groupe_option();
            }
            this.appendSupplemntKitchen(supplement, this.ticket);
        }
        if (itemLabel.getSubItems() != null) {
            for (ProductTicket subItem : itemLabel.getSubItems()) {
                String prefix_item = "  ";
                String full_name_item = subItem.getNumberProduct() > 1 ? subItem.getNumberProduct() + " " + subItem.getNameProduct() : subItem.getNameProduct();
                Object name_item = full_name_item;
                this.ticket.align(0, prefix_item);
                this.ticket.setTextSize(2, 2);
                if (AppLocal.PRINT_FOND) {
                    this.ticket.setReversedText(true);
                    name_item = " " + full_name_item + " ";
                }
                this.ticket.align(0, (String)name_item);
                this.ticket.setReversedText(false);
                this.ticket.setTextSize(1, 2);
                String str_item = prefix_item + (String)name_item;
                if (str_item.length() < TICKET_WIDTH) {
                    int numSpace = TICKET_WIDTH - str_item.length() * 2;
                    for (int i = 0; i < numSpace; ++i) {
                        this.ticket.append(" ");
                    }
                }
                this.ticket.blankLine(1);
                for (ItemOrderInfo ingredient : subItem.getIngredients()) {
                    str = PrinterHelper.formatMax("#### " + AppLocal.getIntString("Label.without") + " " + ingredient.printName(true) + " ####");
                    this.ticket.addNewLine(1, str, new Object[0]);
                }
                int id_groupe_option_item = 0;
                for (OptionItemOrder supplement : subItem.getSupplements()) {
                    if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                        if (id_groupe_option_item != supplement.getId_groupe_option()) {
                            String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                            this.ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                        }
                        id_groupe_option_item = supplement.getId_groupe_option();
                    }
                    this.appendSupplemntKitchen(supplement, this.ticket);
                }
                if (subItem.getComment() == null || subItem.getComment().isEmpty()) continue;
                this.addNote(this.ticket, subItem.getComment());
            }
        }
        this.footerKitchenTicket(this.ticket, printer, itemLabel.getNumberOrder(), decreaser, false, numberItems, indexLabel, order, false);
    }

    private void addNameZone(int numberZones, ZoneItems zoneItem, Ticket2 ticket) {
        if (!(zoneItem.getName() == null || numberZones <= 1 && zoneItem.getName().equalsIgnoreCase("default"))) {
            String nameZone = zoneItem.getName().equalsIgnoreCase("default") ? AppLocal.getIntString("Text.default") : zoneItem.getName();
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, "Zone " + nameZone, new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.addLineOfDashes();
        }
    }

    private void addDetailSubProduct(Ticket2 ticket, ProductTicket subProduct) {
        String full_name_item;
        ticket.setTextSize(1, 2);
        Object multiplicity = "";
        multiplicity = subProduct.getNumberProduct() == 1 ? "1X - " : (String)multiplicity + "X - ";
        String name_item = full_name_item = (String)multiplicity + subProduct.getNameProduct();
        ticket.setTextSize(2, 2);
        if (AppLocal.PRINT_FOND) {
            ticket.setReversedText(true);
        }
        ticket.addNewLine(0, name_item, new Object[0]);
        ticket.setReversedText(false);
        ticket.setTextSize(1, 2);
        int id_groupe_option = 0;
        if (subProduct.getSupplements() != null) {
            for (OptionItemOrder supplement : subProduct.getSupplements()) {
                if (supplement.isNo_printable() || supplement.isHidden_in_kitchen()) continue;
                if (AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET) {
                    if (id_groupe_option != supplement.getId_groupe_option()) {
                        String prefix_space = this.getPrefixSpace(supplement.getShift_option(), true);
                        ticket.addNewLine(0, prefix_space + supplement.getName_groupe_option(), new Object[0]);
                    }
                    id_groupe_option = supplement.getId_groupe_option();
                }
                this.appendSupplemntKitchen(supplement, ticket);
            }
        }
    }

    private void appendSubProductPlusTard(ProductTicket subProduct, Ticket2 ticket) {
        Object itemName;
        int sizeDesignation = TICKET_WIDTH - 8;
        if (subProduct.getNameProduct().length() > sizeDesignation) {
            int nbrLignofProduct = subProduct.getNameProduct().length() / sizeDesignation;
            for (int i = 0; i < nbrLignofProduct; ++i) {
                String ligne = subProduct.getNameProduct().substring(sizeDesignation * i, sizeDesignation * (i + 1));
                itemName = i == 0 ? ticket.formatMax(StringUtils.rightPad((String)this.printMultiply(subProduct.getNumberProduct()), (int)4) + ligne) : StringUtils.rightPad((String)"", (int)4) + ligne;
                ++this.nombreLignesInCammande;
                ticket.setBoldText(true);
                ticket.addNewLine(0, ((String)itemName).toUpperCase(), new Object[0]);
                ticket.setBoldText(false);
            }
            itemName = "    " + subProduct.getNameProduct().substring(sizeDesignation * nbrLignofProduct);
        } else {
            itemName = ticket.formatMax(StringUtils.rightPad((String)this.printMultiply(subProduct.getNumberProduct()), (int)4) + subProduct.getNameProduct());
        }
        ++this.nombreLignesInCammande;
        ticket.setBoldText(true);
        ticket.addNewLine(3, ((String)itemName).toUpperCase(), StringUtils.leftPad((String)Formats.CURRENCY_PRINTED.formatValue(subProduct.getPriceProduct() * (double)subProduct.getNumberProduct()), (int)7));
        ticket.setBoldText(false);
    }

    public String printTotal(double m_dTotal) {
        return Formats.CURRENCY.formatValue(m_dTotal);
    }

    public void printCashlogySummary(MarqueNFC marqueNF, String status, double totalAvantBackOffice, double totalApresBackOffice, double montantInsere, double montantSorti, double montantNonRendu, double montantTotalConsolide) {
        AVAILABLE_WIDTH = TICKET_WIDTH = this.printerCaisse.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.setBoldText(true);
        this.appendHeader_Marque(ticket, marqueNF);
        ticket.blankLine(1);
        UserInfo user = this.getCurrentUser();
        ticket.addNewLine(1, "Op\u00e9rateur : " + user.getName(), new Object[0]);
        String name_machine = this.config.getStringProperty("machine.hostname");
        ticket.addNewLine(1, dateFormatterFull.format(new Date()) + " - " + name_machine.toUpperCase(), new Object[0]);
        ticket.blankLine(1);
        ticket.setBoldText(false);
        ticket.addNewLine(0, "* Statut: " + status, new Object[0]);
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Total avant Acc\u00e9der BackOffice: ", this.printTotal(totalAvantBackOffice / 100.0));
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Total apr\u00e8s Acc\u00e9der BackOffice: ", this.printTotal(totalApresBackOffice / 100.0));
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Montant ins\u00e9r\u00e9: ", this.printTotal(montantInsere / 100.0));
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Montant sorti: ", this.printTotal(montantSorti / 100.0));
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Montant non rendu: ", this.printTotal(montantNonRendu / 100.0));
        ticket.blankLine(1);
        ticket.addNewLine(3, "* Montant total consolid\u00e9: ", this.printTotal(montantTotalConsolide / 100.0));
        ticket.blankLine(2);
        ticket.addLineOfDashes();
        ticket.blankLine(1);
        ticket.setBoldText(true);
        ticket.addNewLine(1, "Merci de votre visite!", new Object[0]);
        ticket.blankLine(1);
        ticket.addLineOfDashes();
        ticket.blankLine(2);
        String operation = "";
        operation = montantInsere > 0.0 && montantSorti > 0.0 ? "Entr\u00e9e/Sortie Argent" : (montantInsere > 0.0 && montantSorti == 0.0 ? "Entr\u00e9e Argent" : (montantSorti > 0.0 && montantInsere == 0.0 ? "Sortie Argent" : "Acc\u00e8s au BackOffice"));
        ticket.addNewLine(1, "N\u00b0 de s\u00e9rie: " + com.openbravo.pos.util.StringUtils.formatLicence4jID("" + AppLocal.getLicenceId()), new Object[0]);
        ticket.addNewLine(1, "Version logiciel : 10.0.1.27", new Object[0]);
        ticket.addNewLine(1, "Type d'op\u00e9ration : " + operation, new Object[0]);
        ticket.addNewLine(1, "(NF525)", new Object[0]);
        ticket.blankLine(6);
        Decreaser decreaser = new Decreaser(AppLocal.dlSales, "", "Rapport d'\u00e9tat de CashLogy", null, 0);
        ticket.cut();
        PrinterHelper.printTicket(this.printerCaisse.getIp(), this.printerCaisse.getNamePrinter(), this.printerCaisse.getType(), ticket, "Acc\u00e9der au back-office CashLogy", "L'impression du ticket caisse de back-office CashLogy a \u00e9chou\u00e9.", this.printerCaisse.getPort(), this.printerCaisse.getBand_rate(), this.printerCaisse, decreaser);
    }

    private String formatCurrency(double amount) {
        return String.format("%.2f", amount);
    }

    private UserInfo getCurrentUser() {
        this.m_App = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
        this.config = AppConfig.getInstance(true, this.m_App.getProperties().getConfigFile());
        UserInfo user = null;
        user = this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null ? this.m_App.getAppUserView().getUser().getUserInfo() : new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
        return user;
    }

    public boolean isTextValid(String text) {
        return text.matches("^[\\p{L}\\p{N} @:!#$%&'()*+,-.=\\?|_~]*$");
    }

    public void printRecapTicketMaj(PrinterInfo printerSummaryKitchen, TicketInfo order, List<ZoneLines> zoneLines, boolean fondNoir, Decreaser decreaser, boolean delivery_order, List<TicketLineInfo> deletedLines) {
        String source_order;
        AVAILABLE_WIDTH = TICKET_WIDTH = printerSummaryKitchen.getWith();
        Ticket2 ticket = new Ticket2(TICKET_WIDTH, TICKET_WIDTH);
        ticket.blankLine(1);
        ticket.setTextSize(2, 2);
        ticket.setBoldText(true);
        ticket.addNewLine(1, AppLocal.getIntString("Text.update") + " ", new Object[0]);
        ticket.setTextSize(1, 2);
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addTypeOrder(ticket, order);
        }
        ticket.blankLine(1);
        ticket.setTextSize(3, 3);
        String orderNum = order.getNumberOrder(true, false);
        this.addTitleRecap(ticket, order, orderNum);
        ticket.setTextSize(2, 2);
        if (!AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addStatusOrder(ticket, order, false);
        }
        ticket.blankLine(1);
        if (!AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(ticket, order);
            ticket.blankLine(1);
        }
        ticket.setTextSize(1, 1);
        ticket.blankLine(1);
        if (order.getDelivered() != null && order.getDelivered().after(order.getDate())) {
            ticket.setTextSize(2, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Label.prevue") + " : " + this.timeFormatter.format(order.getDelivered()), new Object[0]);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        this.checkAndShowInfoCustomer(order, ticket, 0);
        this.sortLinesOrder(order);
        if (zoneLines != null) {
            int numberZones = zoneLines.size();
            for (ZoneLines zoneLine : zoneLines) {
                this.addNameZone(numberZones, zoneLine, ticket);
                if (zoneLine.getLines() == null) continue;
                for (TicketLineInfo product : zoneLine.getLines()) {
                    boolean print_able = true;
                    if (product.isNext()) continue;
                    if (print_able) {
                        ticket.setTextSize(1, 2);
                        if (AppLocal.PRODUCT_KITCHEN_BOLD) {
                            ticket.setBoldText(true);
                        }
                        String prefix = "update".equals(product.getTypeUpdate()) ? "(" + AppLocal.getIntString("Button.update") + ")" : "(" + AppLocal.getIntString("Button.add") + ") ";
                        this.addNameProduit(ticket, product, true, prefix, fondNoir);
                        this.loadIngredient(product, ticket);
                        for (ItemOrderInfo ingredient : product.getListIngredients()) {
                            if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
                            this.addNameIngredient(ticket, ingredient);
                        }
                        for (OptionItemOrder supplement : product.getListSupplements()) {
                            if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                            this.appendSupplemntKitchen(supplement, ticket, true);
                        }
                        for (ProductTicket productMenu : product.getListProducts()) {
                            this.addNameItem(ticket, productMenu);
                            for (ItemOrderInfo ingredient : product.getListIngredients()) {
                                if (ingredient.getIdProduct() != productMenu.getIdProduct() || ingredient.getIdCarte() != productMenu.getIdCarte() || ingredient.getIndex_carte() != productMenu.getIndex_carte()) continue;
                                this.addNameIngredient(ticket, ingredient);
                            }
                            for (OptionItemOrder supplement : product.getListSupplements()) {
                                if (supplement.getIdProduct() != productMenu.getIdProduct() || supplement.getIdCarte() != productMenu.getIdCarte() || supplement.getIndex_carte() != productMenu.getIndex_carte()) continue;
                                this.appendSupplemntKitchen(supplement, ticket, true);
                            }
                            if (productMenu.getComment() == null || productMenu.getComment().isEmpty()) continue;
                            this.addNote(ticket, this.textAfterCheckLanguage(productMenu.getComment()));
                        }
                        if (product.getDescription() != null && !product.getDescription().isEmpty() && !AppLocal.HIDE_DESCRIPTION_PRODUCT_IN_TICKET) {
                            ticket.addNewLine(0, this.textAfterCheckLanguage(product.getDescription()), new Object[0]);
                        }
                        if (product.getNote() != null && !product.getNote().isEmpty()) {
                            this.addNote(ticket, this.textAfterCheckLanguage(product.getNote()));
                        }
                    }
                    ticket.blankLine(1);
                }
            }
        }
        if (deletedLines != null && !deletedLines.isEmpty()) {
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.setTextSize(1, 2);
            ticket.addNewLine(1, AppLocal.getIntString("Text.cancel"), new Object[0]);
            ticket.setTextSize(1, 1);
            for (TicketLineInfo product : deletedLines) {
                String str = PrinterHelper.formatMax("( " + AppLocal.getIntString("Button.cancel") + " ) " + product.printName());
                ticket.addNewLine(1, str, new Object[0]);
            }
        }
        if (AppLocal.TOTAL_RECAP || delivery_order || AppLocal.PRINT_RECAP_DELIVERY && order.getType() != null && order.getType().equalsIgnoreCase("En Livraison")) {
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
            ticket.setBoldText(true);
            ticket.setTextSize(2, 2);
            ticket.addNewLine(3, "Total :", Formats.CURRENCY_PRINTED.formatValue(order.getTotal()));
            ticket.setTextSize(1, 1);
            ticket.setBoldText(false);
            ticket.addLineOfDashes();
        }
        if (order.getComment() != null && !order.getComment().isEmpty()) {
            this.addNote(ticket, "Commentaire : " + order.getComment());
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            String status_order;
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            ticket.setReversedText(true);
            ticket.addNewLine(1, " " + order.getType() + " ", new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
            ticket.setTextSize(2, 2);
            String string = status_order = order.isPaid() || order.isPlatform_order() ? "Pay\u00e9e" : "Impay\u00e9e";
            if (order.isPaid()) {
                status_order = AppLocal.getIntString("Text.paid.at.terminal");
            }
            if (!order.isPaid()) {
                ticket.setReversedText(true);
            }
            ticket.addNewLine(1, status_order, new Object[0]);
            ticket.setReversedText(false);
            ticket.setTextSize(1, 1);
            ticket.blankLine(1);
        }
        if (AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER) {
            this.addBloc(ticket, order);
            ticket.blankLine(1);
        }
        if ((source_order = this.getSourceOrder(order)) != null && !source_order.isEmpty() && !AppLocal.PRINT_ARABIC) {
            ticket.addNewLine(1, "Source : " + source_order, new Object[0]);
        }
        ticket.setTextSize(1, 2);
        ticket.addNewLine(1, dateFormatterFull.format(new Date()), new Object[0]);
        ticket.blankLine(5);
        if (AppLocal.AUTO_CUTTER_TICKET) {
            ticket.cut();
        } else {
            ticket.halfCut();
        }
        PrinterHelper.printTicket(printerSummaryKitchen.getIp(), printerSummaryKitchen.getNamePrinter(), printerSummaryKitchen.getType(), ticket, "Commande n\u00b0" + String.valueOf(order.getNumero_order()), AppLocal.getIntString("Message.error.print.ticket"), printerSummaryKitchen.getPort(), printerSummaryKitchen.getBand_rate(), printerSummaryKitchen, decreaser, false);
    }
}

