/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer;

public class PrinterCommand {
    public static final int NO_IMAGE = 0;
    public final int alignment;
    public final int idImage;
    public final int textWidth;
    public final int textHeight;
    public final int underline;
    public final int bold;
    public final boolean cut;
    public final boolean openDrawer;
    public final String content;

    private PrinterCommand(Builder builder) {
        this.alignment = builder.alignment;
        this.idImage = builder.idImage;
        this.textWidth = builder.textWidth;
        this.textHeight = builder.textHeight;
        this.underline = builder.underline;
        this.bold = builder.bold;
        this.cut = builder.cut;
        this.openDrawer = builder.openDrawer;
        this.content = builder.content;
    }

    public static class Builder {
        private int alignment = 0;
        public int idImage = 0;
        private int textWidth = 1;
        private int textHeight = 1;
        private int underline = 0;
        private int bold = 0;
        private boolean cut = false;
        private boolean openDrawer = false;
        private final String content;

        public Builder() {
            this("");
        }

        public Builder(String content) {
            this.content = content;
        }

        public Builder align(int alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder image(int idImage) {
            this.idImage = idImage;
            return this;
        }

        public Builder size(int width, int height) {
            this.textWidth = width;
            this.textHeight = height;
            return this;
        }

        public Builder style(boolean underline, boolean bold) {
            this.underline = underline ? 1 : 0;
            this.bold = bold ? 1 : 0;
            return this;
        }

        public Builder cut() {
            this.cut = true;
            return this;
        }

        public Builder openDrawer(boolean open) {
            this.openDrawer = open;
            return this;
        }

        public PrinterCommand build() {
            return new PrinterCommand(this);
        }
    }
}

