/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer;

import android.content.Context;
import android.graphics.Bitmap;
import com.fazecast.jSerialComm.SerialPort;
import com.openbravo.basic.BasicException;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.ActionPrint;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.ReportUtils;
import gnu.io.CommPortIdentifier;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;

public abstract class Printer {
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    public static Bitmap logoBitmap;
    private static final int VENDOR_ID = 0;
    private static final int PRODUCT_ID = 1;

    public static void print(ActionPrint printAction) {
        block11: {
            if (printAction.isUsbPrinter()) {
                try {
                    if (printAction.getTicket() != null) {
                        Printer.printTicketDrawCash(printAction);
                        break block11;
                    }
                    Printer.printUsbTicket(printAction);
                }
                catch (PrintException ex) {
                    if (printAction.isAddEventNoAvailablePrinter()) {
                        try {
                            Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printAction.getPrinterData().getName() + " - " + printAction.getErrMsg()));
                        }
                        catch (IOException ext) {
                            LogToFile.log("severe", null, ext);
                        }
                    }
                    LogToFile.log("severe", null, ex);
                }
                catch (IOException ex) {
                    LogToFile.log("severe", null, ex);
                }
            } else if (printAction.isSerialPrinter()) {
                Printer.printSerialTicketWithoutRxtx(printAction);
            } else {
                Printer.printESCTicket(printAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void printESCTicket(ActionPrint printAction) {
        Decreaser cheacker = printAction.getDecreaser();
        if (printAction.getPrinterIP() != null) {
            Socket socket = null;
            OutputStream os = null;
            try {
                socket = new Socket();
                socket.setSoTimeout(10000);
                socket.setKeepAlive(false);
                socket.connect(new InetSocketAddress(printAction.getPrinterIP(), 9100), 5000);
                os = new BufferedOutputStream(socket.getOutputStream());
                os.flush();
                if (printAction.getTicket() != null) {
                    for (int byt : printAction.getTicket().forESCPrinter) {
                        os.write(byt);
                    }
                } else {
                    for (int byt : printAction.getTicket2().bytes) {
                        os.write(byt);
                    }
                }
                System.out.println("+++++++++++ cheacker : " + cheacker);
                if (cheacker == null) return;
                cheacker.execute();
                return;
            }
            catch (IOException e) {
                if (printAction.isAddEventNoAvailablePrinter()) {
                    try {
                        Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printAction.getPrinterData().getName() + " - " + printAction.getErrMsg()));
                    }
                    catch (IOException ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null && cheacker != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", null, e);
                return;
            }
            catch (BasicException ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", null, ex);
                return;
            }
            finally {
                if (os != null) {
                    System.out.println("++++++++++++++++ test print 1");
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        if (printAction.isAddEventNoAvailablePrinter()) {
                            try {
                                Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printAction.getPrinterData().getName() + " - " + printAction.getErrMsg()));
                            }
                            catch (IOException ex) {
                                LogToFile.log("severe", null, ex);
                            }
                        }
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                        if (printAction.getTicket2() != null) {
                            cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                        }
                        LogToFile.log("severe", null, e);
                    }
                }
            }
        }
        if (printAction.isAddEventNoAvailablePrinter()) {
            try {
                Journal.writeToJET(new Event(150, "Imprimante indisponible ", "", "identifiant d'imprimante - message", new Date().getTime(), printAction.getPrinterData().getName() + " - " + printAction.getErrMsg()));
            }
            catch (IOException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
        System.out.println("++++++++++++++ error 5");
        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg() + "\n adresse ip non d\u00e9fini ", 1500, NPosition.BOTTOM_LEFT);
        if (printAction.getTicket2() == null) return;
        cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
    }

    public static void init(Context context) {
    }

    public static String getStringFromInputStream(InputStream is) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String finalResult = "";
        try {
            finalResult = result.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return finalResult;
    }

    private static boolean printUsbTicket(ActionPrint printAction) throws PrintException, IOException {
        byte[] bytes;
        DocPrintJob job;
        Decreaser cheacker = printAction.getDecreaser();
        if (printAction.getPrinterName() != null) {
            List<Integer> dataBytes;
            PrintService printservice = ReportUtils.getPrintService(printAction.getPrinterName());
            job = printservice.createPrintJob();
            if (printAction.getTicket() != null) {
                dataBytes = printAction.getTicket().forESCPrinter;
                bytes = new byte[dataBytes.size()];
                for (int k = 0; k < bytes.length; ++k) {
                    bytes[k] = dataBytes.get(k).byteValue();
                }
            } else {
                dataBytes = printAction.getTicket2().bytes;
                int size_array = dataBytes.size();
                bytes = new byte[size_array];
                for (int k = 0; k < dataBytes.size(); ++k) {
                    bytes[k] = dataBytes.get(k).byteValue();
                }
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.BOTTOM_LEFT);
            if (printAction.getTicket2() != null) {
                cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
            }
            return false;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(is, flavor, null);
        job.print(doc, null);
        ((InputStream)is).close();
        try {
            if (cheacker != null) {
                cheacker.execute();
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void printSerialTicketWithoutRxtx(ActionPrint printAction) {
        Decreaser cheacker = printAction.getDecreaser();
        OutputStream outputStream = null;
        boolean printed = false;
        SerialPort comPort = SerialPort.getCommPort((String)printAction.getPortName());
        int baudRate = 19200;
        if (printAction.getBaudRate() != null && !printAction.getBaudRate().isEmpty()) {
            baudRate = Integer.parseInt(printAction.getBaudRate());
        }
        comPort.setComPortParameters(baudRate, 8, 1, 0);
        comPort.openPort();
        outputStream = comPort.getOutputStream();
        System.out.println("++++++++++++ outputStream : " + outputStream);
        if (outputStream != null) {
            try {
                if (printAction.getTicket() != null) {
                    for (int byt : printAction.getTicket().forESCPrinter) {
                        outputStream.write(byt);
                    }
                } else {
                    for (int byt : printAction.getTicket2().bytes) {
                        outputStream.write(byt);
                    }
                }
                printed = true;
            }
            catch (IOException ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            finally {
                block26: {
                    if (outputStream != null && comPort != null) {
                        try {
                            outputStream.close();
                            comPort.closePort();
                        }
                        catch (IOException e) {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                            if (printAction.getTicket2() == null) break block26;
                            cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                        }
                    }
                }
            }
        }
        if (!printed && cheacker != null && printAction.getTicket2() != null) {
            cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void printSerialTicket(ActionPrint printAction) {
        Decreaser cheacker = printAction.getDecreaser();
        gnu.io.SerialPort serialPort = null;
        OutputStream outputStream = null;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        boolean printed = false;
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(printAction.getPortName())) continue;
            try {
                int baudRate = 9600;
                if (printAction.getBaudRate() != null && !printAction.getBaudRate().isEmpty()) {
                    baudRate = Integer.parseInt(printAction.getBaudRate());
                }
                serialPort = (gnu.io.SerialPort)portId.open("SimpleWriteApp", 2000);
                serialPort.setSerialPortParams(baudRate, 8, 1, 0);
                outputStream = serialPort.getOutputStream();
                if (printAction.getTicket() != null) {
                    for (int byt : printAction.getTicket().forESCPrinter) {
                        outputStream.write(byt);
                    }
                } else {
                    for (int byt : printAction.getTicket2().bytes) {
                        outputStream.write(byt);
                    }
                }
                printed = true;
            }
            catch (IOException ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", null, ex);
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                if (printAction.getTicket2() != null) {
                    cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                }
                LogToFile.log("severe", null, ex);
            }
            finally {
                block25: {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.CENTER);
                            if (printAction.getTicket2() == null) break block25;
                            cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
                        }
                    }
                }
                if (serialPort == null) continue;
                serialPort.close();
            }
        }
        if (!printed && cheacker != null && printAction.getTicket2() != null) {
            cheacker.addToQueue(printAction.getTicket2().bytes, printAction.getPrinterData());
        }
    }

    private static void printTicketDrawCash(ActionPrint printAction) throws PrintException, IOException {
        if (printAction.getPrinterName() != null) {
            int k;
            byte[] bytes;
            List<Integer> dataBytes;
            PrintService printservice = ReportUtils.getPrintService(printAction.getPrinterName());
            DocPrintJob job = printservice.createPrintJob();
            if (printAction.getTicket() != null) {
                dataBytes = printAction.getTicket().forESCPrinter;
                bytes = new byte[dataBytes.size()];
                for (k = 0; k < bytes.length; ++k) {
                    bytes[k] = dataBytes.get(k).byteValue();
                }
            } else {
                dataBytes = printAction.getTicket2().bytes;
                bytes = new byte[dataBytes.size()];
                for (k = 0; k < bytes.length; ++k) {
                    bytes[k] = dataBytes.get(k).byteValue();
                }
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            SimpleDoc doc = new SimpleDoc(is, flavor, null);
            job.print(doc, null);
            ((InputStream)is).close();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, printAction.getErrMsg(), 1500, NPosition.BOTTOM_LEFT);
        }
    }

    public static boolean isPrinterValid(PrinterInfo printer) {
        boolean valid = false;
        if (printer != null && printer.getType() != null) {
            System.out.println("++++++++++ printer.getType() : " + printer.getType());
            switch (printer.getType()) {
                case "USB": {
                    valid = Printer.isPrinterUsbValid(printer);
                    break;
                }
                case "R\u00e9seau": {
                    valid = Printer.isPrinterReseauValid(printer);
                    break;
                }
                case "Serial": {
                    valid = Printer.isPrinterSerialValid(printer);
                }
            }
        }
        return valid;
    }

    public static boolean isPrinterReseauValid(PrinterInfo printer) {
        if (printer.getIp() != null) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.setKeepAlive(false);
                socket.connect(new InetSocketAddress(printer.getIp(), 9100), 5000);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean isPrinterSerialValid(PrinterInfo printer) {
        if (printer.getIp() != null) {
            try {
                OutputStream outputStream = null;
                SerialPort comPort = SerialPort.getCommPort((String)printer.getPort());
                int baudRate = 19200;
                if (printer.getBand_rate() != null && !printer.getBand_rate().isEmpty()) {
                    baudRate = Integer.parseInt(printer.getBand_rate());
                }
                comPort.setComPortParameters(baudRate, 8, 1, 0);
                comPort.openPort();
                outputStream = comPort.getOutputStream();
                if (outputStream != null) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean isPrinterUsbValid(PrinterInfo printer) {
        return printer.getNamePrinter() != null;
    }
}

