/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.printer;

import com.openbravo.pos.util.LogToFile;
import javax.print.DocPrintJob;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

class PrintJobWatcher {
    boolean done = false;

    PrintJobWatcher(DocPrintJob job) {
        job.addPrintJobListener(new PrintJobListener(){

            @Override
            public void printJobCanceled(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobCompleted(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobFailed(PrintJobEvent pje) {
                this.allDone();
            }

            @Override
            public void printJobNoMoreEvents(PrintJobEvent pje) {
                this.allDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void allDone() {
                PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                synchronized (printJobWatcher) {
                    PrintJobWatcher.this.done = true;
                    PrintJobWatcher.this.notify();
                }
            }

            @Override
            public void printDataTransferCompleted(PrintJobEvent pje) {
            }

            @Override
            public void printJobRequiresAttention(PrintJobEvent pje) {
            }
        });
    }

    public synchronized void waitForDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

