/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.payment;

import com.openbravo.pos.util.LogToFile;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;

public class TpeCommunication
implements SerialPortEventListener {
    private BufferedReader input;
    private OutputStream output;
    private String portName;
    private String sDisplayPort = null;
    protected Enumeration portList;
    protected CommPortIdentifier portId;
    protected SerialPort serialPort;
    private final Integer ENQ = 5;
    private final Integer ACK = 6;
    private final Integer NAK = 21;
    private final Integer STX = 2;
    private final Integer ETX = 3;
    private final Integer EOT = 4;

    public TpeCommunication(String portName) {
        this.portName = portName;
        this.init(9600, 7, 1, 0);
    }

    public void serialEvent(SerialPortEvent oEvent) {
        if (oEvent.getEventType() == 1) {
            try {
                String inputLine = this.input.readLine();
                if (inputLine.equals("ping")) {
                    this.output.write("pong".getBytes());
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void init(int baud, int DATABITS, int STOPBITS, int PARITY) {
        boolean portFound = false;
        if (this.sDisplayPort != null && !this.sDisplayPort.isEmpty()) {
            try {
                this.portList = CommPortIdentifier.getPortIdentifiers();
                while (this.portList.hasMoreElements()) {
                    this.portId = (CommPortIdentifier)this.portList.nextElement();
                    if (this.portId.getPortType() != 1 || !this.portId.getName().equals(this.sDisplayPort)) continue;
                    portFound = true;
                    try {
                        this.serialPort = (SerialPort)this.portId.open("appelTPE", 2000);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        continue;
                    }
                    try {
                        this.output = this.serialPort.getOutputStream();
                        this.input = new BufferedReader(new InputStreamReader(this.serialPort.getInputStream()));
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    try {
                        this.serialPort.setSerialPortParams(baud, DATABITS, STOPBITS, PARITY);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    try {
                        this.serialPort.notifyOnOutputEmpty(true);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    this.serialPort.addEventListener((SerialPortEventListener)this);
                    this.serialPort.notifyOnDataAvailable(true);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!portFound) {
            // empty if block
        }
    }

    public synchronized void close() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
    }

    public byte[] getBytes(List<Integer> dataBytes) {
        byte[] bytes = new byte[dataBytes.size()];
        for (int k = 0; k < bytes.length; ++k) {
            bytes[k] = dataBytes.get(k).byteValue();
        }
        return bytes;
    }
}

