/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.payment;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.format.Formats;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.metadata.DataRead;
import java.io.Serializable;

public class PaymentInfo
implements Serializable,
Cloneable {
    private String id;
    private String namePayment;
    private double m_dTotal;
    private double m_dPaid;
    private double m_dTendered;
    private String m_dCardName = null;
    private String m_transactionID;
    private String transfer_num;
    private int idCustomer;
    private String origin;
    private int idEmployee;
    private int idLoyaltyCard;
    private String idPaymentExterne;
    private int index;

    public PaymentInfo(String namePayment, double m_dTotal, double m_dPaid) {
        this.id = "No ID";
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
    }

    public PaymentInfo(String namePayment, double m_dTotal, double m_dPaid, int idCustomer, int idLoyaltyCard) {
        this.id = "No ID";
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
        this.idCustomer = idCustomer;
        this.idLoyaltyCard = idLoyaltyCard;
    }

    public PaymentInfo(String namePayment, double m_dTotal, double m_dPaid, int idEmployee) {
        this.id = "No ID";
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
        this.idEmployee = idEmployee;
    }

    public PaymentInfo(String namePayment, double m_dTotal, double m_dPaid, String origin) {
        this.id = "No ID";
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
        this.origin = origin;
    }

    public PaymentInfo(String namePayment, double m_dTotal, double m_dPaid, String transfer_num, int idCustomer) {
        this.id = "No ID";
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
        this.transfer_num = transfer_num;
        this.idCustomer = idCustomer;
    }

    public PaymentInfo(String id, String namePayment, double m_dTotal, double m_dPaid) {
        this.id = id;
        this.namePayment = namePayment;
        this.m_dTotal = m_dTotal;
        this.m_dPaid = m_dPaid;
    }

    public PaymentInfo() {
        this.id = "No ID";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getChange() {
        return this.m_dPaid - this.m_dTotal;
    }

    public String getName() {
        return this.namePayment;
    }

    public void setNamePayment(String namePayment) {
        this.namePayment = namePayment;
    }

    public double getPaid() {
        return this.m_dPaid;
    }

    public void setPaid(double m_dPaid) {
        this.m_dPaid = m_dPaid;
    }

    public double getTotal() {
        return this.m_dTotal;
    }

    public void setTotal(double m_dTotal) {
        this.m_dTotal = m_dTotal;
    }

    public double getTendered() {
        return this.m_dTendered;
    }

    public void setM_dTendered(double m_dTendered) {
        this.m_dTendered = m_dTendered;
    }

    public String getCardName() {
        return this.m_dCardName;
    }

    public void setM_dCardName(String m_dCardName) {
        this.m_dCardName = m_dCardName;
    }

    public String getTransfer_num() {
        return this.transfer_num;
    }

    public void setTransfer_num(String transfer_num) {
        this.transfer_num = transfer_num;
    }

    public int getIdCustomer() {
        return this.idCustomer;
    }

    public void setIdCustomer(int idCustomer) {
        this.idCustomer = idCustomer;
    }

    public String printPaid() {
        return Formats.CURRENCY.formatValue(this.m_dPaid);
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(this.m_dTotal);
    }

    public String printTendered() {
        return Formats.CURRENCY.formatValue(this.m_dTendered);
    }

    public String printChange() {
        return Formats.CURRENCY.formatValue(new Double(this.m_dPaid - this.m_dTotal));
    }

    public String toString() {
        return "PaymentInfo{id=" + this.id + ", namePayment=" + this.namePayment + ", m_dTotal=" + this.m_dTotal + ", m_dPaid=" + this.m_dPaid + ", m_dTendered=" + this.m_dTendered + ", m_dCardName=" + this.m_dCardName + ", m_transactionID=" + this.m_transactionID + ", transfer_num=" + this.transfer_num + ", idCustomer=" + this.idCustomer + ", origin=" + this.origin + ", index=" + this.index + "}";
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                PaymentInfo paymentInfo = new PaymentInfo();
                paymentInfo.id = dr.getString(1);
                paymentInfo.namePayment = dr.getString(2);
                paymentInfo.m_dTotal = dr.getDouble(3);
                paymentInfo.m_transactionID = dr.getString(4);
                if (dr.getDouble(5) != null) {
                    paymentInfo.m_dTendered = dr.getDouble(5);
                }
                paymentInfo.m_dCardName = dr.getString(6);
                paymentInfo.origin = dr.getString(7);
                paymentInfo.idPaymentExterne = dr.getString(8);
                return paymentInfo;
            }
        };
    }

    public String getTransactionID() {
        return "no ID";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getIdEmployee() {
        return this.idEmployee;
    }

    public void setIdEmployee(int idEmployee) {
        this.idEmployee = idEmployee;
    }

    public int getIdLoyaltyCard() {
        return this.idLoyaltyCard;
    }

    public void setIdLoyaltyCard(int idLoyaltyCard) {
        this.idLoyaltyCard = idLoyaltyCard;
    }

    public Object clone() {
        PaymentInfo o = null;
        try {
            o = (PaymentInfo)super.clone();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return o;
    }

    public String getIdPaymentExterne() {
        return this.idPaymentExterne;
    }

    public void setIdPaymentExterne(String idPaymentExterne) {
        this.idPaymentExterne = idPaymentExterne;
    }
}

