/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.parser;

import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.admin.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserParser {
    public static List<User> parseUser(JSONObject obj) {
        JSONObject dataUsers = obj.getJSONObject("users");
        ArrayList<User> users = new ArrayList<User>();
        Iterator iteratorUser = dataUsers.keys();
        while (iteratorUser.hasNext()) {
            String keyUser = (String)iteratorUser.next();
            JSONObject objUser = dataUsers.getJSONObject(keyUser);
            String idUser = objUser.getString("id_user");
            String name = objUser.getString("name");
            String role = objUser.getString("role");
            boolean disabled = objUser.getBoolean("disabled");
            boolean removed = objUser.getBoolean("removed");
            String fingerprint = null;
            Object objFingerPrint = objUser.get("fingerprint");
            if (objFingerPrint != null && !objFingerPrint.toString().equals("null")) {
                fingerprint = objFingerPrint.toString();
            }
            String email = null;
            Object objEmail = objUser.get("email");
            if (objEmail != null && !objEmail.toString().equals("null")) {
                email = objEmail.toString();
            }
            String password = null;
            Object objPassword = objUser.get("password");
            if (objPassword != null && !objPassword.toString().equals("null")) {
                password = objPassword.toString();
            }
            Date removedAt = null;
            Object objDate = objUser.get("removedAt");
            if (objDate != null && !objDate.toString().equals("null")) {
                removedAt = new Date((Long)objDate);
            }
            User user = new User();
            user.setId(idUser);
            user.setName(name);
            user.setPassword(password);
            user.setEmail(email);
            user.setRole(role);
            user.setFingerprint(fingerprint);
            user.setDisabled(disabled);
            user.setRemoved(removed);
            user.setRemovedAt(removedAt);
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            JSONArray array_permissions = objUser.getJSONArray("permissions");
            for (int i = 0; i < array_permissions.length(); ++i) {
                JSONObject objPermission = array_permissions.getJSONObject(i);
                String idPemission = objPermission.getString("id_permission");
                String name_permission = objPermission.getString("name");
                permissions.add(new Permission(idPemission, name_permission));
            }
            user.setPermissions(permissions);
            users.add(user);
        }
        return users;
    }
}

