/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.parser;

import com.openbravo.beans.CarteMenu;
import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.config.SiteConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryDayAvailable;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductDayOn;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.ScreenProduct;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.ScreenSupplementItem;
import com.openbravo.pos.ticket.ShiftCategory;
import com.openbravo.pos.ticket.ShiftProduct;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementPriceInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.CityDeliveryInfo;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.MultiLanguageCarte;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import fr.protactile.procaisse.dao.entities.MultiLanguageGSS;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.MultiLanguagePromotion;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplement;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplementItem;
import fr.protactile.procaisse.dao.entities.NutrientData;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.dao.entities.TimeTableInfo;
import fr.protactile.procaisse.dao.entities.WorkShiftInfo;
import fr.protactile.procaisse.dao.entities.ZoneDeliveryInfo;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class ResponseObject {
    public static JSONObject getRootUserJson(List<User> users) {
        JSONObject jsonRoot = new JSONObject();
        JSONObject jsonAllUsers = new JSONObject();
        for (User user : users) {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put((Object)"id_user", (Object)user.getId());
            jsonUser.put((Object)"name", (Object)user.getName());
            jsonUser.put((Object)"password", (Object)user.getPassword());
            jsonUser.put((Object)"role", (Object)user.getRole());
            jsonUser.put((Object)"disabled", (Object)user.isDisabled());
            jsonUser.put((Object)"fingerprint", (Object)user.getFingerprint());
            jsonUser.put((Object)"email", (Object)user.getEmail());
            jsonUser.put((Object)"removed", (Object)user.isRemoved());
            jsonUser.put((Object)"removedAt", user.getRemovedAt() != null ? Long.valueOf(user.getRemovedAt().getTime()) : null);
            JSONArray jsonPermissions = new JSONArray();
            for (Permission permission : user.getPermissions()) {
                JSONObject jsonPermission = new JSONObject();
                jsonPermission.put((Object)"id_permission", (Object)permission.getId());
                jsonPermission.put((Object)"name", (Object)permission.getName());
                jsonPermissions.put((Map)jsonPermission);
            }
            jsonUser.put((Object)"permissions", (Object)jsonPermissions);
            jsonAllUsers.put((Object)user.getId(), (Object)jsonUser);
        }
        jsonRoot.put((Object)"users", (Object)jsonAllUsers);
        return jsonRoot;
    }

    public static JSONObject getRootPhotoJson(List<PhotoDispaly> photosPub, List<PhotoDispaly> photosHome, List<PhotoDispaly> photosDualScreen) {
        JSONObject jsonRoot = new JSONObject();
        JSONObject jsonAllPhotosPub = new JSONObject();
        for (PhotoDispaly photoDispaly : photosPub) {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put((Object)"id_photo", (Object)photoDispaly.getId());
            jsonUser.put((Object)"path", (Object)photoDispaly.getPath());
            jsonAllPhotosPub.put((Object)photoDispaly.getId(), (Object)jsonUser);
        }
        JSONObject jsonAllPhotosHome = new JSONObject();
        for (PhotoDispaly photoHome : photosHome) {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put((Object)"id_photo", (Object)photoHome.getId());
            jsonUser.put((Object)"path", (Object)photoHome.getPath());
            jsonAllPhotosHome.put((Object)photoHome.getId(), (Object)jsonUser);
        }
        JSONObject jSONObject = new JSONObject();
        for (PhotoDispaly photoDualScreen : photosDualScreen) {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put((Object)"id_photo", (Object)photoDualScreen.getId());
            jsonUser.put((Object)"path", (Object)photoDualScreen.getPath());
            jSONObject.put((Object)photoDualScreen.getId(), (Object)jsonUser);
        }
        jsonRoot.put((Object)"photosPub", (Object)jsonAllPhotosPub);
        jsonRoot.put((Object)"photosHome", (Object)jsonAllPhotosHome);
        jsonRoot.put((Object)"photosDualScreen", (Object)jSONObject);
        return jsonRoot;
    }

    public static JSONObject getJsonCarteANDParams(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages, List<NutrientData> ntriDatas) {
        return ResponseObject.getJsonCarteANDParams(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, false, ntriDatas);
    }

    public static JSONObject getJsonCarteANDParams(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages, boolean oldJsonVersion, List<NutrientData> ntriDatas) {
        JSONObject jsonRoot = ResponseObject.getJsonCarte(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, oldJsonVersion, ntriDatas);
        jsonRoot.put((Object)"hide_name_categories", (Object)AppLocal.HIDE_NAME_CATEGORIES_WEB);
        jsonRoot.put((Object)"hide_name_sub_categories", (Object)AppLocal.HIDE_NAME_SUB_CATEGORIES_WEB);
        jsonRoot.put((Object)"hide_name_products", (Object)AppLocal.HIDE_NAME_PRODUCTS_WEB);
        jsonRoot.put((Object)"hide_name_options", (Object)AppLocal.HIDE_NAME_OPTIONS_WEB);
        jsonRoot.put((Object)"has_delivery", (Object)(AppLocal.licence != null && AppLocal.licence.equalsIgnoreCase("livraison") ? 1 : 0));
        jsonRoot.put((Object)"product_size_1", (Object)AppLocal.PRODUCT_SIZE_JUNIOR);
        jsonRoot.put((Object)"product_size_2", (Object)AppLocal.PRODUCT_SIZE_SENIOR);
        jsonRoot.put((Object)"product_size_3", (Object)AppLocal.PRODUCT_SIZE_MEGA);
        jsonRoot.put((Object)"product_size_4", (Object)AppLocal.PRODUCT_SIZE1);
        jsonRoot.put((Object)"product_size_5", (Object)AppLocal.PRODUCT_SIZE2);
        jsonRoot.put((Object)"product_size_6", (Object)AppLocal.PRODUCT_SIZE3);
        jsonRoot.put((Object)"product_size_7", (Object)AppLocal.PRODUCT_SIZE4);
        jsonRoot.put((Object)"product_size_8", (Object)AppLocal.PRODUCT_SIZE5);
        jsonRoot.put((Object)"product_size_9", (Object)AppLocal.PRODUCT_SIZE6);
        jsonRoot.put((Object)"product_size_10", (Object)AppLocal.PRODUCT_SIZE7);
        return jsonRoot;
    }

    public static JSONObject getJsonCarte(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages, boolean oldJsonVersion, List<NutrientData> ntriDatas) {
        JSONObject jsonRoot = new JSONObject();
        JSONArray jsonAllZones = new JSONArray();
        for (ZoneInfo zoneInfo : zones) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)zoneInfo.getId());
            jSONObject.put((Object)"name_zone", (Object)zoneInfo.getName());
            jSONObject.put((Object)"position_zone", (Object)zoneInfo.getPosition());
            jSONObject.put((Object)"color", (Object)ColorUtils.getHexadecimal(zoneInfo.getColor()));
            jsonAllZones.put((Map)jSONObject);
        }
        JSONArray jsonAllScreens = new JSONArray();
        for (LocalScreen localScreen : screens) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idScreen", (Object)localScreen.getId());
            jSONObject.put((Object)"name_screen", (Object)localScreen.getName());
            jSONObject.put((Object)"number_screen", (Object)localScreen.getNumber());
            jsonAllScreens.put((Map)jSONObject);
        }
        JSONArray jSONArray = new JSONArray();
        for (TagInfo tagInfo : tags) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idTag", (Object)tagInfo.getId());
            jSONObject.put((Object)"name_tag", (Object)tagInfo.getName());
            jSONObject.put((Object)"number_tag", (Object)tagInfo.getNumber());
            jSONObject.put((Object)"deleted", (Object)tagInfo.isDeleted());
            jSONObject.put((Object)"logo_tag", (Object)tagInfo.getLogo_tag());
            jSONObject.put((Object)"background_catalog", (Object)tagInfo.getBackground_catalog());
            jSONObject.put((Object)"enabled", (Object)tagInfo.isEnabled());
            jSONObject.put((Object)"closed", (Object)tagInfo.isClosed());
            jSONArray.put((Map)jSONObject);
        }
        JSONArray jSONArray2 = new JSONArray();
        for (PrinterInfo printerInfo : printers) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idPrinter", (Object)printerInfo.getId());
            jSONObject.put((Object)"name", (Object)printerInfo.getName());
            jSONObject.put((Object)"type", (Object)printerInfo.getType());
            jSONObject.put((Object)"ip_address", (Object)printerInfo.getIp());
            jSONObject.put((Object)"width_ticket", (Object)printerInfo.getWith());
            jSONObject.put((Object)"number_ticket", (Object)printerInfo.getNumber());
            jSONObject.put((Object)"type_printer", (Object)printerInfo.getTypePrinter());
            jSONObject.put((Object)"model", (Object)printerInfo.getModel());
            jSONArray2.put((Map)jSONObject);
        }
        JSONArray jSONArray3 = new JSONArray();
        for (CategoryInfo categoryInfo : categories) {
            if (categoryInfo.getParent_id() != 0 && categoryInfo.getParent_id() != -1) continue;
            JSONObject jSONObject = ResponseObject.getJsonCategory(categoryInfo, oldJsonVersion);
            jSONArray3.put((Map)jSONObject);
            for (CategoryInfo categoryInfo2 : categoryInfo.getSub_categories()) {
                JSONObject jSONObject2 = ResponseObject.getJsonCategory(categoryInfo2, oldJsonVersion);
                jSONArray3.put((Map)jSONObject2);
            }
        }
        JSONArray jSONArray4 = new JSONArray();
        for (ProductInfoExt productInfoExt : items) {
            Object sizeProduct3;
            Object mProductDayOn2;
            Object promotion2;
            Object carteProduct2;
            Object sizeProduct22;
            ProductSizeInfo productSizeInfo = ResponseObject.getProductSize(productInfoExt.getListSizes(), "junior");
            ProductSizeInfo productSizeInfo2 = ResponseObject.getProductSize(productInfoExt.getListSizes(), "senior");
            ProductSizeInfo productSizeInfo3 = ResponseObject.getProductSize(productInfoExt.getListSizes(), "mega");
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idItem", (Object)productInfoExt.getID());
            jSONObject.put((Object)"bar_code", (Object)productInfoExt.getCode());
            jSONObject.put((Object)"idCat", !oldJsonVersion && productInfoExt.getId_global_category() != null && !productInfoExt.getId_global_category().isEmpty() ? productInfoExt.getId_global_category() : Integer.valueOf(productInfoExt.getCategoryid()));
            jSONObject.put((Object)"position", (Object)productInfoExt.getOrder_item());
            jSONObject.put((Object)"name", (Object)productInfoExt.getName());
            jSONObject.put((Object)"price", (Object)productInfoExt.getPrice(null, AppLocal.TARIFF));
            jSONObject.put((Object)"purchase_price", (Object)productInfoExt.getPriceBuy());
            jSONObject.put((Object)"tax", (Object)productInfoExt.getRate_tax());
            jSONObject.put((Object)"cook", (Object)productInfoExt.isPrepared());
            jSONObject.put((Object)"available_takeaway", (Object)productInfoExt.getEmp());
            jSONObject.put((Object)"available_on_the_spot", (Object)productInfoExt.getSp());
            jSONObject.put((Object)"available_delivery", (Object)productInfoExt.getLv());
            jSONObject.put((Object)"available_bar", (Object)productInfoExt.getBar());
            jSONObject.put((Object)"available_terasse", (Object)productInfoExt.getTerasse());
            jSONObject.put((Object)"available_happy_hour", (Object)productInfoExt.getHappy_hour());
            jSONObject.put((Object)"is_menu", (Object)productInfoExt.isMenu());
            jSONObject.put((Object)"price_type", (Object)productInfoExt.getPrice_type());
            jSONObject.put((Object)"price_sp", (Object)productInfoExt.getPrice("Sur Place", AppLocal.TARIFF));
            jSONObject.put((Object)"price_emp", (Object)productInfoExt.getPrice("A Emporter", AppLocal.TARIFF));
            jSONObject.put((Object)"price_lv", (Object)productInfoExt.getPrice("En Livraison", AppLocal.TARIFF));
            jSONObject.put((Object)"price_bar", (Object)productInfoExt.getPrice("BAR", AppLocal.TARIFF));
            jSONObject.put((Object)"price_terasse", (Object)productInfoExt.getPrice("Terasse", AppLocal.TARIFF));
            jSONObject.put((Object)"price_happy", (Object)productInfoExt.getPrice("Happy Hour", AppLocal.TARIFF));
            jSONObject.put((Object)"price_junior", (Object)productSizeInfo.getPrice());
            jSONObject.put((Object)"price_senior", (Object)productSizeInfo2.getPrice());
            jSONObject.put((Object)"price_mega", (Object)productSizeInfo3.getPrice());
            jSONObject.put((Object)"price_sp_junior", (Object)productSizeInfo.getPrice_sp());
            jSONObject.put((Object)"price_sp_senior", (Object)productSizeInfo2.getPrice_sp());
            jSONObject.put((Object)"price_sp_mega", (Object)productSizeInfo3.getPrice_sp());
            jSONObject.put((Object)"price_emp_junior", (Object)productSizeInfo.getPrice_emp());
            jSONObject.put((Object)"price_emp_senior", (Object)productSizeInfo2.getPrice_emp());
            jSONObject.put((Object)"price_emp_mega", (Object)productSizeInfo3.getPrice_emp());
            jSONObject.put((Object)"price_lv_junior", (Object)productSizeInfo.getPrice_lv());
            jSONObject.put((Object)"price_lv_senior", (Object)productSizeInfo2.getPrice_lv());
            jSONObject.put((Object)"price_lv_mega", (Object)productSizeInfo3.getPrice_lv());
            jSONObject.put((Object)"price_bar_junior", (Object)productSizeInfo.getPrice_bar());
            jSONObject.put((Object)"price_bar_senior", (Object)productSizeInfo2.getPrice_bar());
            jSONObject.put((Object)"price_bar_mega", (Object)productSizeInfo3.getPrice_bar());
            jSONObject.put((Object)"price_terasse_junior", (Object)productSizeInfo.getPrice_terasse());
            jSONObject.put((Object)"price_terasse_senior", (Object)productSizeInfo2.getPrice_terasse());
            jSONObject.put((Object)"price_terasse_mega", (Object)productSizeInfo3.getPrice_terasse());
            jSONObject.put((Object)"price_happy_junior", (Object)productSizeInfo.getPrice_happy_hour());
            jSONObject.put((Object)"price_happy_senior", (Object)productSizeInfo2.getPrice_happy_hour());
            jSONObject.put((Object)"price_happy_mega", (Object)productSizeInfo3.getPrice_happy_hour());
            jSONObject.put((Object)"removed", (Object)productInfoExt.isRemoved());
            jSONObject.put((Object)"hidden", (Object)productInfoExt.isHidden());
            jSONObject.put((Object)"printer", (Object)productInfoExt.getPrinterID());
            jSONObject.put((Object)"many_size", (Object)productInfoExt.isMany_size());
            jSONObject.put((Object)"different_price", (Object)productInfoExt.isDifferent_price());
            jSONObject.put((Object)"color", (Object)productInfoExt.getColor());
            jSONObject.put((Object)"tax_emp", (Object)productInfoExt.getRate_tax_emp());
            jSONObject.put((Object)"tax_lv", (Object)productInfoExt.getRate_tax_lv());
            jSONObject.put((Object)"label", (Object)productInfoExt.isHasLabel());
            jSONObject.put((Object)"printerLabel", (Object)productInfoExt.getPrinterLabel());
            jSONObject.put((Object)"option_free", (Object)productInfoExt.getOption_free());
            jSONObject.put((Object)"special_option", (Object)productInfoExt.isSpecial_option());
            jSONObject.put((Object)"number_line", (Object)productInfoExt.getNumber_line());
            jSONObject.put((Object)"number_column", (Object)productInfoExt.getNumber_column());
            jSONObject.put((Object)"max_line", (Object)productInfoExt.getMax_line());
            jSONObject.put((Object)"additional_sale", (Object)productInfoExt.isAdditional_sale());
            jSONObject.put((Object)"moment_product", (Object)productInfoExt.isMoment_product());
            jSONObject.put((Object)"quantity", (Object)productInfoExt.getQuantity());
            jSONObject.put((Object)"unit", (Object)productInfoExt.getUnit());
            jSONObject.put((Object)"weight", (Object)productInfoExt.getWeight());
            jSONObject.put((Object)"extra_unit", (Object)productInfoExt.getExtra_unit());
            jSONObject.put((Object)"apply_discount", (Object)productInfoExt.isApply_discount());
            jSONObject.put((Object)"display_kitchen", (Object)productInfoExt.getDisplayKitchen());
            jSONObject.put((Object)"path", (Object)productInfoExt.getImageProduct());
            jSONObject.put((Object)"hidden_borne", (Object)productInfoExt.isHidden_borne());
            jSONObject.put((Object)"sold_out", (Object)productInfoExt.isSold_out());
            jSONObject.put((Object)"free_price", (Object)productInfoExt.isFree_price());
            jSONObject.put((Object)"alias_product", (Object)productInfoExt.getAlias_kitchen());
            jSONObject.put((Object)"send_color", (Object)productInfoExt.isSend_color());
            jSONObject.put((Object)"display_time", (Object)productInfoExt.isHas_display_time());
            jSONObject.put((Object)"first_period", (Object)productInfoExt.getFirst_period());
            jSONObject.put((Object)"end_period", (Object)productInfoExt.getEnd_period());
            jSONObject.put((Object)"description", (Object)productInfoExt.getDescription());
            jSONObject.put((Object)"removed_by_admin", (Object)productInfoExt.isRemoved_by_admin());
            jSONObject.put((Object)"additional_sale_atSpot", (Object)productInfoExt.isAdditional_sale_at_spot());
            jSONObject.put((Object)"additional_sale_take_away", (Object)productInfoExt.isAdditional_sale_take_away());
            jSONObject.put((Object)"later", (Object)productInfoExt.isLater());
            jSONObject.put((Object)"print_ingredients", (Object)productInfoExt.isPrint_ingredients());
            jSONObject.put((Object)"price_platform", (Object)productInfoExt.getPrice("Platform", AppLocal.TARIFF));
            jSONObject.put((Object)"price_platform_junior", (Object)productSizeInfo.getPrice_platform());
            jSONObject.put((Object)"price_platform_senior", (Object)productSizeInfo2.getPrice_platform());
            jSONObject.put((Object)"price_platform_mega", (Object)productSizeInfo3.getPrice_platform());
            jSONObject.put((Object)"available_caisse", (Object)productInfoExt.isAvailable_caisse());
            jSONObject.put((Object)"labeled", (Object)productInfoExt.isLabeled());
            jSONObject.put((Object)"size_junior_enabled", (Object)(productSizeInfo.isSize_enabled() && AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED ? 1 : 0));
            jSONObject.put((Object)"size_senior_enabled", (Object)(productSizeInfo2.isSize_enabled() && AppLocal.PRODUCT_SIZE_SENIOR_ENABLED ? 1 : 0));
            jSONObject.put((Object)"size_mega_enabled", (Object)(productSizeInfo3.isSize_enabled() && AppLocal.PRODUCT_SIZE_MEGA_ENABLED ? 1 : 0));
            jSONObject.put((Object)"best_sale", (Object)productInfoExt.isBest_sale());
            jSONObject.put((Object)"promo_basket", (Object)productInfoExt.isPromo_basket());
            jSONObject.put((Object)"display_image_in_kitchen", (Object)productInfoExt.isDisplay_image_in_kitchen());
            jSONObject.put((Object)"daily_stock", (Object)productInfoExt.getDaily_stock());
            jSONObject.put((Object)"has_bar_code", (Object)productInfoExt.isHas_bar_code());
            jSONObject.put((Object)"top_product", (Object)productInfoExt.isTop_product());
            jSONObject.put((Object)"hide_name_in_borne", (Object)productInfoExt.isHide_name_in_borne());
            jSONObject.put((Object)"hide_price_in_borne", (Object)productInfoExt.isHide_price_in_borne());
            jSONObject.put((Object)"unavailable_online", (Object)productInfoExt.isUnavailable_online());
            jSONObject.put((Object)"hidden_online", (Object)productInfoExt.isHidden_online());
            jSONObject.put((Object)"has_timetable", (Object)productInfoExt.isHas_timetable());
            jSONObject.put((Object)"hidden_ubereat", (Object)productInfoExt.isHidden_platform());
            jSONObject.put((Object)"description_ubereat", (Object)productInfoExt.getDescription_uberEat());
            jSONObject.put((Object)"product_ubereat", (Object)productInfoExt.isProduct_ubereat());
            jSONObject.put((Object)"mixed_product", (Object)productInfoExt.isMixed_product());
            jSONObject.put((Object)"price_drive", (Object)productInfoExt.getPrice("Drive", AppLocal.TARIFF));
            jSONObject.put((Object)"price_drive_junior", (Object)productSizeInfo.getPrice_drive());
            jSONObject.put((Object)"price_drive_senior", (Object)productSizeInfo2.getPrice_drive());
            jSONObject.put((Object)"price_drive_mega", (Object)productSizeInfo3.getPrice_drive());
            jSONObject.put((Object)"product_loyalty", (Object)productInfoExt.isProduct_loyalty());
            jSONObject.put((Object)"price_point", (Object)productInfoExt.getPrice_point());
            jSONObject.put((Object)"sold_out_temporary", (Object)productInfoExt.isSold_out_temporary());
            jSONObject.put((Object)"enable_in_opening_mode", (Object)productInfoExt.isEnable_in_opening());
            jSONObject.put((Object)"price_opening", (Object)productInfoExt.getPrice_opening());
            jSONObject.put((Object)"hidden_caisse", (Object)productInfoExt.isHidden_caisse());
            jSONObject.put((Object)"valid_caisse", (Object)productInfoExt.isValid_caisse());
            jSONObject.put((Object)"tva_global_no_applicable", (Object)productInfoExt.isTva_global_no_applicable());
            jSONObject.put((Object)"marque", (Object)productInfoExt.getMarque());
            ImageProduct imageProduct = productInfoExt.getImageProductMoment();
            String string = imageProduct != null ? imageProduct.getPath() : null;
            String string2 = imageProduct != null ? imageProduct.getGraphic_type() : null;
            jSONObject.put((Object)"path_product_moment", (Object)string);
            jSONObject.put((Object)"type_image_product_moment", (Object)string2);
            jSONObject.put((Object)"path_platform", (Object)productInfoExt.getImageProductPlatForm());
            jSONObject.put((Object)"idGlobal", (Object)productInfoExt.getId_global());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put((Object)"dateDebut", (Object)(productInfoExt.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(productInfoExt.getDateStartDisplay())));
            jSONObject3.put((Object)"dateFin", (Object)(productInfoExt.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(productInfoExt.getDateEndDisplay())));
            jSONObject.put((Object)"campagneDates", (Object)jSONObject3);
            jSONObject.put((Object)"imageURL", (Object)productInfoExt.getImageUrlProduct());
            jSONObject.put((Object)"id_zone", (Object)productInfoExt.getZoneId());
            JSONArray jSONArray5 = new JSONArray();
            for (ItemIngredientInfo itemIngredientInfo : productInfoExt.getItemIngredients()) {
                JSONObject jsonIngredientProduct = new JSONObject();
                if (oldJsonVersion) {
                    jsonIngredientProduct.put((Object)"id_ingredient", (Object)itemIngredientInfo.getId_supplement_item());
                } else {
                    jsonIngredientProduct.put((Object)"id_ingredient", itemIngredientInfo.getId_global() != null && !itemIngredientInfo.getId_global().isEmpty() ? itemIngredientInfo.getId_global() : Integer.valueOf(itemIngredientInfo.getId_supplement_item()));
                }
                jsonIngredientProduct.put((Object)"quantity", (Object)itemIngredientInfo.getQuantity());
                SupplementItemInfo supplementItemInfo = ResponseObject.getDetailIngredientById(productInfoExt.getIngredients(), itemIngredientInfo.getId_supplement_item());
                if (supplementItemInfo != null) {
                    jsonIngredientProduct.put((Object)"name", (Object)supplementItemInfo.getName());
                    jsonIngredientProduct.put((Object)"path", (Object)supplementItemInfo.getPath());
                    jsonIngredientProduct.put((Object)"hidden_borne", (Object)supplementItemInfo.isHidden_borne());
                    jsonIngredientProduct.put((Object)"hidden_online", (Object)supplementItemInfo.isHidden_online());
                }
                jSONArray5.put((Map)jsonIngredientProduct);
            }
            JSONArray jsonSizesProduct = new JSONArray();
            for (Object sizeProduct22 : productInfoExt.getListSizes()) {
                if (((ProductSizeInfo)sizeProduct22).getName() == null || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("junior") || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("senior") || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("mega") || ((ProductSizeInfo)sizeProduct22).getTariff() != AppLocal.TARIFF) continue;
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put((Object)"id_size", (Object)((ProductSizeInfo)sizeProduct22).getID());
                jSONObject4.put((Object)"name_size", (Object)((ProductSizeInfo)sizeProduct22).getName());
                jSONObject4.put((Object)"label_size", (Object)((ProductSizeInfo)sizeProduct22).getLabel_size());
                jSONObject4.put((Object)"price", (Object)((ProductSizeInfo)sizeProduct22).getPrice());
                jSONObject4.put((Object)"price_sp", (Object)((ProductSizeInfo)sizeProduct22).getPrice_sp());
                jSONObject4.put((Object)"price_emp", (Object)((ProductSizeInfo)sizeProduct22).getPrice_emp());
                jSONObject4.put((Object)"price_lv", (Object)((ProductSizeInfo)sizeProduct22).getPrice_lv());
                jSONObject4.put((Object)"price_bar", (Object)((ProductSizeInfo)sizeProduct22).getPrice_bar());
                jSONObject4.put((Object)"price_terasse", (Object)((ProductSizeInfo)sizeProduct22).getPrice_terasse());
                jSONObject4.put((Object)"price_happy_hour", (Object)((ProductSizeInfo)sizeProduct22).getPrice_happy_hour());
                jSONObject4.put((Object)"price_uber", (Object)((ProductSizeInfo)sizeProduct22).getPrice_uber());
                jSONObject4.put((Object)"price_delivero", (Object)((ProductSizeInfo)sizeProduct22).getPrice_delivero());
                jSONObject4.put((Object)"price_platform", (Object)((ProductSizeInfo)sizeProduct22).getPrice_platform());
                jSONObject4.put((Object)"price_drive", (Object)((ProductSizeInfo)sizeProduct22).getPrice_drive());
                jSONObject4.put((Object)"idGlobal", (Object)((ProductSizeInfo)sizeProduct22).getId_global());
                switch (((ProductSizeInfo)sizeProduct22).getName()) {
                    case "size1": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE1_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size2": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE2_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size3": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE3_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size4": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE4_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size5": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE5_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size6": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE6_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size7": {
                        jSONObject4.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE7_ENABLED ? 1 : 0));
                    }
                }
                jsonSizesProduct.put((Map)jSONObject4);
            }
            JSONArray jSONArray6 = new JSONArray();
            sizeProduct22 = productInfoExt.getSupplements().iterator();
            while (sizeProduct22.hasNext()) {
                SupplementProduct supplementProduct = (SupplementProduct)sizeProduct22.next();
                JSONObject jsonSupplementItem = new JSONObject();
                if (oldJsonVersion) {
                    jsonSupplementItem.put((Object)"idSupplement", (Object)supplementProduct.getiD());
                } else {
                    jsonSupplementItem.put((Object)"idSupplement", supplementProduct.getId_global() != null && !supplementProduct.getId_global().isEmpty() ? supplementProduct.getId_global() : Integer.valueOf(supplementProduct.getiD()));
                }
                jsonSupplementItem.put((Object)"free_able", (Object)supplementProduct.isFree_able());
                jsonSupplementItem.put((Object)"separate", (Object)supplementProduct.isSeparate());
                jsonSupplementItem.put((Object)"option_free", (Object)supplementProduct.getOption_free());
                jsonSupplementItem.put((Object)"has_limit_options", (Object)supplementProduct.getHas_options());
                jsonSupplementItem.put((Object)"min_option", (Object)supplementProduct.getMin_options());
                jsonSupplementItem.put((Object)"max_option", (Object)supplementProduct.getMax_options());
                jsonSupplementItem.put((Object)"option_free_size2", (Object)supplementProduct.getOption_free_size2());
                jsonSupplementItem.put((Object)"min_option_size2", (Object)supplementProduct.getMin_options_size2());
                jsonSupplementItem.put((Object)"max_option_size2", (Object)supplementProduct.getMax_options_size2());
                jsonSupplementItem.put((Object)"option_free_size3", (Object)supplementProduct.getOption_free_size3());
                jsonSupplementItem.put((Object)"min_option_size3", (Object)supplementProduct.getMin_options_size3());
                jsonSupplementItem.put((Object)"max_option_size3", (Object)supplementProduct.getMax_options_size3());
                jsonSupplementItem.put((Object)"option_free_size4", (Object)supplementProduct.getOption_free_size4());
                jsonSupplementItem.put((Object)"min_option_size4", (Object)supplementProduct.getMin_options_size4());
                jsonSupplementItem.put((Object)"max_option_size4", (Object)supplementProduct.getMax_options_size4());
                jsonSupplementItem.put((Object)"option_free_size5", (Object)supplementProduct.getOption_free_size5());
                jsonSupplementItem.put((Object)"min_option_size5", (Object)supplementProduct.getMin_options_size5());
                jsonSupplementItem.put((Object)"max_option_size5", (Object)supplementProduct.getMax_options_size5());
                jsonSupplementItem.put((Object)"option_free_size6", (Object)supplementProduct.getOption_free_size6());
                jsonSupplementItem.put((Object)"min_option_size6", (Object)supplementProduct.getMin_options_size6());
                jsonSupplementItem.put((Object)"max_option_size6", (Object)supplementProduct.getMax_options_size6());
                jsonSupplementItem.put((Object)"many_size", (Object)supplementProduct.isMany_size());
                jsonSupplementItem.put((Object)"option_free_size7", (Object)supplementProduct.getOption_free_size7());
                jsonSupplementItem.put((Object)"min_option_size7", (Object)supplementProduct.getMin_options_size7());
                jsonSupplementItem.put((Object)"max_option_size7", (Object)supplementProduct.getMax_options_size7());
                jsonSupplementItem.put((Object)"option_free_size8", (Object)supplementProduct.getOption_free_size8());
                jsonSupplementItem.put((Object)"min_option_size8", (Object)supplementProduct.getMin_options_size8());
                jsonSupplementItem.put((Object)"max_option_size8", (Object)supplementProduct.getMax_options_size8());
                jsonSupplementItem.put((Object)"option_free_size9", (Object)supplementProduct.getOption_free_size9());
                jsonSupplementItem.put((Object)"min_option_size9", (Object)supplementProduct.getMin_options_size9());
                jsonSupplementItem.put((Object)"max_option_size9", (Object)supplementProduct.getMax_options_size9());
                jsonSupplementItem.put((Object)"option_free_size10", (Object)supplementProduct.getOption_free_size10());
                jsonSupplementItem.put((Object)"min_option_size10", (Object)supplementProduct.getMin_options_size10());
                jsonSupplementItem.put((Object)"max_option_size10", (Object)supplementProduct.getMax_options_size10());
                jSONArray6.put((Map)jsonSupplementItem);
            }
            JSONArray jsonAllCarteProduct = new JSONArray();
            for (Object carteProduct2 : productInfoExt.getCartes()) {
                JSONObject jsonCarteProduct = new JSONObject();
                jsonCarteProduct.put((Object)"id_carte", !oldJsonVersion && ((CarteOrderInfo)carteProduct2).getId_global() != null && !((CarteOrderInfo)carteProduct2).getId_global().isEmpty() ? ((CarteOrderInfo)carteProduct2).getId_global() : Integer.valueOf(((CarteOrderInfo)carteProduct2).getId()));
                jsonCarteProduct.put((Object)"name", (Object)((CarteOrderInfo)carteProduct2).getName());
                jsonCarteProduct.put((Object)"number_carte", (Object)((CarteOrderInfo)carteProduct2).getNumber_carte());
                jsonCarteProduct.put((Object)"order_carte", (Object)((CarteOrderInfo)carteProduct2).getOrderCarte());
                jsonAllCarteProduct.put((Map)jsonCarteProduct);
            }
            JSONArray jSONArray7 = new JSONArray();
            carteProduct2 = productInfoExt.getScreens().iterator();
            while (carteProduct2.hasNext()) {
                ScreenProduct screenProduct = (ScreenProduct)carteProduct2.next();
                JSONObject jSONObject5 = new JSONObject();
                jSONObject5.put((Object)"id", (Object)screenProduct.getId());
                jSONObject5.put((Object)"id_product", (Object)screenProduct.getId_product());
                jSONObject5.put((Object)"id_screen", (Object)screenProduct.getId_screen());
                jSONObject5.put((Object)"name_screen", (Object)screenProduct.getName_screen());
                jSONObject5.put((Object)"number_screen", (Object)screenProduct.getNumber_screen());
                jSONArray7.put((Map)jSONObject5);
            }
            JSONArray jsonAllAdditional = new JSONArray();
            for (ProductInfoExt productInfoExt2 : productInfoExt.getAdditional_sales()) {
                jsonAllAdditional.put(!oldJsonVersion && productInfoExt2.getId_global() != null && !productInfoExt2.getId_global().isEmpty() ? productInfoExt2.getId_global() : Integer.valueOf(productInfoExt2.getID()));
            }
            JSONArray jsonPromotions = new JSONArray();
            for (Object promotion2 : productInfoExt.getPromotions()) {
                JSONObject jSONObject6 = new JSONObject();
                jSONObject6.put((Object)"id", (Object)((PromotionInfo)promotion2).getId());
                jSONObject6.put((Object)"name_promotion", (Object)((PromotionInfo)promotion2).getName_promotion());
                jSONObject6.put((Object)"type_order", (Object)((PromotionInfo)promotion2).getType_order());
                jSONObject6.put((Object)"size_product", (Object)((PromotionInfo)promotion2).getSize_product());
                jSONObject6.put((Object)"quantity", (Object)((PromotionInfo)promotion2).getQuantity());
                jSONObject6.put((Object)"discount", (Object)((PromotionInfo)promotion2).getDiscount());
                jSONObject6.put((Object)"idGlobal", (Object)((PromotionInfo)promotion2).getId_global());
                jsonPromotions.put((Map)jSONObject6);
            }
            JSONArray jSONArray8 = new JSONArray();
            promotion2 = productInfoExt.getSub_products().iterator();
            while (promotion2.hasNext()) {
                ProductInfoExt productInfoExt3 = (ProductInfoExt)promotion2.next();
                JSONObject jsonSubProduct = new JSONObject();
                jsonSubProduct.put((Object)"id_sub_product", !oldJsonVersion && productInfoExt3.getId_global() != null && !productInfoExt3.getId_global().isEmpty() ? productInfoExt3.getId_global() : Integer.valueOf(productInfoExt3.getID()));
                jsonSubProduct.put((Object)"number_exemplary", (Object)productInfoExt3.getNumber_exemplary());
                jSONArray8.put((Map)jsonSubProduct);
            }
            JSONArray jsonDaysOn = new JSONArray();
            for (Object mProductDayOn2 : productInfoExt.getDaysOn()) {
                JSONObject jSONObject7 = new JSONObject();
                jSONObject7.put((Object)"id", (Object)((ProductDayOn)mProductDayOn2).getId());
                jSONObject7.put((Object)"day_of_week", (Object)((ProductDayOn)mProductDayOn2).getDay_of_week());
                jSONObject7.put((Object)"id_product", (Object)((ProductDayOn)mProductDayOn2).getId_product());
                jsonDaysOn.put((Map)jSONObject7);
            }
            JSONArray jSONArray9 = new JSONArray();
            mProductDayOn2 = productInfoExt.getShiftsCProduct().iterator();
            while (mProductDayOn2.hasNext()) {
                ShiftProduct shiftProduct = (ShiftProduct)mProductDayOn2.next();
                JSONObject jsonCategoryShift = new JSONObject();
                jsonCategoryShift.put((Object)"id", (Object)shiftProduct.getId());
                jsonCategoryShift.put((Object)"date_start", (Object)shiftProduct.getDateStart());
                jsonCategoryShift.put((Object)"date_end", (Object)shiftProduct.getDateEnd());
                jsonCategoryShift.put((Object)"id_category", (Object)shiftProduct.getIProduct());
                jSONArray9.put((Map)jsonCategoryShift);
            }
            JSONArray jsonAllSizeProduct = new JSONArray();
            for (Object sizeProduct3 : productInfoExt.getListSizes()) {
                JSONObject jSONObject8 = new JSONObject();
                jSONObject8.put((Object)"id_size", (Object)((ProductSizeInfo)sizeProduct3).getID());
                jSONObject8.put((Object)"name_size", (Object)((ProductSizeInfo)sizeProduct3).getName());
                jSONObject8.put((Object)"label_size", (Object)((ProductSizeInfo)sizeProduct3).getLabel_size());
                jSONObject8.put((Object)"price", (Object)((ProductSizeInfo)sizeProduct3).getPrice());
                jSONObject8.put((Object)"price_sp", (Object)((ProductSizeInfo)sizeProduct3).getPrice_sp());
                jSONObject8.put((Object)"price_emp", (Object)((ProductSizeInfo)sizeProduct3).getPrice_emp());
                jSONObject8.put((Object)"price_lv", (Object)((ProductSizeInfo)sizeProduct3).getPrice_lv());
                jSONObject8.put((Object)"price_bar", (Object)((ProductSizeInfo)sizeProduct3).getPrice_bar());
                jSONObject8.put((Object)"price_terasse", (Object)((ProductSizeInfo)sizeProduct3).getPrice_terasse());
                jSONObject8.put((Object)"price_happy_hour", (Object)((ProductSizeInfo)sizeProduct3).getPrice_happy_hour());
                jSONObject8.put((Object)"price_uber", (Object)((ProductSizeInfo)sizeProduct3).getPrice_uber());
                jSONObject8.put((Object)"price_delivero", (Object)((ProductSizeInfo)sizeProduct3).getPrice_delivero());
                jSONObject8.put((Object)"price_platform", (Object)((ProductSizeInfo)sizeProduct3).getPrice_platform());
                jSONObject8.put((Object)"price_drive", (Object)((ProductSizeInfo)sizeProduct3).getPrice_drive());
                jSONObject8.put((Object)"size_enabled", (Object)((ProductSizeInfo)sizeProduct3).isSize_enabled());
                jSONObject8.put((Object)"tariff", (Object)((ProductSizeInfo)sizeProduct3).getTariff());
                jSONObject8.put((Object)"idGlobal", (Object)((ProductSizeInfo)sizeProduct3).getId_global());
                jsonAllSizeProduct.put((Map)jSONObject8);
            }
            JSONArray jSONArray10 = new JSONArray();
            sizeProduct3 = productInfoExt.getPrices().iterator();
            while (sizeProduct3.hasNext()) {
                ProductPriceInfo productPriceInfo = (ProductPriceInfo)sizeProduct3.next();
                JSONObject jsonProductPrice = new JSONObject();
                jsonProductPrice.put((Object)"id", (Object)productPriceInfo.getId());
                jsonProductPrice.put((Object)"price", (Object)productPriceInfo.getPrice());
                jsonProductPrice.put((Object)"type_order", (Object)productPriceInfo.getType_order());
                jsonProductPrice.put((Object)"tariff", (Object)productPriceInfo.getTariff());
                jsonProductPrice.put((Object)"id_product", !oldJsonVersion && productInfoExt.getId_global() != null && !productInfoExt.getId_global().isEmpty() ? productInfoExt.getId_global() : Integer.valueOf(productInfoExt.getID()));
                jSONArray10.put((Map)jsonProductPrice);
            }
            JSONArray jsonTranslation2 = new JSONArray();
            for (MultiLanguageProduct multiLanguageText : productInfoExt.getMultiLanguageTexts()) {
                JSONObject jsonMultiLangueText2 = new JSONObject();
                jsonMultiLangueText2.put((Object)"langue", (Object)multiLanguageText.getLanguage());
                jsonMultiLangueText2.put((Object)"name", (Object)multiLanguageText.getName());
                jsonMultiLangueText2.put((Object)"description", (Object)multiLanguageText.getDescription());
                jsonMultiLangueText2.put((Object)"description_ubereat", (Object)multiLanguageText.getDescription_platform());
                jsonTranslation2.put((Map)jsonMultiLangueText2);
            }
            JSONObject jSONObject9 = new JSONObject();
            NutritionalInfoProduct nutriInfo = productInfoExt.getNutriValues();
            if (nutriInfo != null) {
                JSONObject energyKcal = new JSONObject();
                energyKcal.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getEnergyKcalValue()));
                energyKcal.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getEnergyKcalDailyPercentage()));
                jSONObject9.put((Object)"energy_kcal", (Object)energyKcal);
                JSONObject fiberG = new JSONObject();
                fiberG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getFiberGValue()));
                fiberG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getFiberGDailyPercentage()));
                jSONObject9.put((Object)"fiber_g", (Object)fiberG);
                JSONObject fatG = new JSONObject();
                fatG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getFatGValue()));
                fatG.put((Object)"saturated_fat_g", (Object)(nutriInfo.getFatSaturatedG() != null ? nutriInfo.getFatSaturatedG() : 0.0));
                fatG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getFatGDailyPercentage()));
                jSONObject9.put((Object)"fat_g", (Object)fatG);
                JSONObject carbsG = new JSONObject();
                carbsG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getCarbsGValue()));
                carbsG.put((Object)"sugar_g", (Object)ResponseObject.safeString(nutriInfo.getSugarG()));
                carbsG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getCarbsGDailyPercentage()));
                jSONObject9.put((Object)"carbs_g", (Object)carbsG);
                JSONObject proteinG = new JSONObject();
                proteinG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getProteinGValue()));
                proteinG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getProteinGDailyPercentage()));
                jSONObject9.put((Object)"protein_g", (Object)proteinG);
                JSONObject saltG = new JSONObject();
                saltG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getSaltGValue()));
                saltG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getSaltGDailyPercentage()));
                jSONObject9.put((Object)"salt_g", (Object)saltG);
            }
            jSONObject.put((Object)"translation", (Object)jsonTranslation2);
            jSONObject.put((Object)"ingredients", (Object)jSONArray5);
            jSONObject.put((Object)"options", (Object)jSONArray6);
            jSONObject.put((Object)"carte", (Object)jsonAllCarteProduct);
            jSONObject.put((Object)"sizes", (Object)jsonSizesProduct);
            jSONObject.put((Object)"screens", (Object)jSONArray7);
            jSONObject.put((Object)"additionals", (Object)jsonAllAdditional);
            jSONObject.put((Object)"promotions", (Object)jsonPromotions);
            jSONObject.put((Object)"sub_products", (Object)jSONArray8);
            jSONObject.put((Object)"daysOn", (Object)jsonDaysOn);
            jSONObject.put((Object)"shiftsOn", (Object)jSONArray9);
            jSONObject.put((Object)"allSizes", (Object)jsonAllSizeProduct);
            jSONObject.put((Object)"prices", (Object)jSONArray10);
            JSONArray jsonAllergenes = new JSONArray();
            List<Allergene> mlist = productInfoExt.getAllergenes();
            if (mlist != null && !mlist.isEmpty()) {
                for (Allergene allergene : mlist) {
                    jsonAllergenes.put((Object)allergene.getName());
                }
            }
            jSONObject.put((Object)"allergens", (Object)jsonAllergenes);
            jSONObject.put((Object)"nutritional_info", (Object)jSONObject9);
            jSONArray4.put((Map)jSONObject);
        }
        JSONArray jSONArray11 = new JSONArray();
        for (SupplementInfo supplementInfo : options) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)supplementInfo.getiD());
            jSONObject.put((Object)"name", (Object)supplementInfo.getName());
            jSONObject.put((Object)"has_options", (Object)supplementInfo.getHas_options());
            jSONObject.put((Object)"min_items", (Object)supplementInfo.getMin_options());
            jSONObject.put((Object)"max_items", (Object)supplementInfo.getMax_options());
            jSONObject.put((Object)"is_ingredient", (Object)supplementInfo.getIs_ingredient());
            jSONObject.put((Object)"position", (Object)supplementInfo.getOrderSupplement());
            jSONObject.put((Object)"removed", (Object)supplementInfo.isRemoved());
            jSONObject.put((Object)"color", (Object)supplementInfo.getColor());
            jSONObject.put((Object)"number_click", (Object)supplementInfo.getNumber_click());
            jSONObject.put((Object)"multiple_category", (Object)supplementInfo.isMultiple_category());
            jSONObject.put((Object)"path", (Object)supplementInfo.getPath());
            jSONObject.put((Object)"prepared", (Object)supplementInfo.isPrepared());
            jSONObject.put((Object)"printer", (Object)supplementInfo.getPrinter());
            jSONObject.put((Object)"shift_option", (Object)supplementInfo.getShift_option());
            jSONObject.put((Object)"display_screen_sorti", (Object)supplementInfo.isDisplay_screen_sorti());
            jSONObject.put((Object)"alphabetical_order", (Object)supplementInfo.isOrder_name());
            jSONObject.put((Object)"hidden_borne", (Object)supplementInfo.isHidden_borne());
            jSONObject.put((Object)"order_name", (Object)supplementInfo.isOrder_name());
            jSONObject.put((Object)"removed_by_admin", (Object)supplementInfo.isRemoved_by_admin());
            jSONObject.put((Object)"no_printable", (Object)supplementInfo.isNo_printable());
            jSONObject.put((Object)"is_bold", (Object)supplementInfo.getIsBold());
            jSONObject.put((Object)"hidden_online", (Object)supplementInfo.isHidden_online());
            jSONObject.put((Object)"hidden_ubereat", (Object)supplementInfo.isHidden_ubereat());
            jSONObject.put((Object)"supplement_ubereat", (Object)supplementInfo.isSupplement_ubereat());
            jSONObject.put((Object)"display_free", (Object)supplementInfo.isDisplay_free());
            jSONObject.put((Object)"print_black_background", (Object)supplementInfo.isPrint_black_background());
            jSONObject.put((Object)"idGlobal", (Object)supplementInfo.getId_global());
            JSONArray jSONArray12 = new JSONArray();
            for (SupplementItemInfo supplementItemInfo : supplementInfo.getItems()) {
                Object priceOption2;
                JSONObject jSONObject10 = new JSONObject();
                jSONObject10.put((Object)"id", (Object)supplementItemInfo.getiD());
                jSONObject10.put((Object)"name", (Object)supplementItemInfo.getName());
                jSONObject10.put((Object)"price", (Object)supplementItemInfo.getPrice());
                jSONObject10.put((Object)"price_junior", (Object)supplementItemInfo.getPrice_junior());
                jSONObject10.put((Object)"price_senior", (Object)supplementItemInfo.getPrice_senior());
                jSONObject10.put((Object)"price_mega", (Object)supplementItemInfo.getPrice_mega());
                jSONObject10.put((Object)"price_size1", (Object)supplementItemInfo.getPrice_size1());
                jSONObject10.put((Object)"price_size2", (Object)supplementItemInfo.getPrice_size2());
                jSONObject10.put((Object)"price_size3", (Object)supplementItemInfo.getPrice_size3());
                jSONObject10.put((Object)"removed", (Object)supplementItemInfo.isRemoved());
                jSONObject10.put((Object)"order_item", (Object)supplementItemInfo.getOrderItem());
                jSONObject10.put((Object)"many_size", (Object)supplementItemInfo.isMany_size());
                jSONObject10.put((Object)"path", (Object)supplementItemInfo.getPath());
                jSONObject10.put((Object)"hidden_borne", (Object)supplementItemInfo.isHidden_borne());
                jSONObject10.put((Object)"removed_by_admin", (Object)supplementItemInfo.isRemoved_by_admin());
                jSONObject10.put((Object)"many_type", (Object)supplementItemInfo.isMany_type());
                jSONObject10.put((Object)"hidden", (Object)supplementItemInfo.isHidden());
                jSONObject10.put((Object)"hidden_online", (Object)supplementItemInfo.isHidden_online());
                jSONObject10.put((Object)"price_size4", (Object)supplementItemInfo.getPrice_size4());
                jSONObject10.put((Object)"price_size5", (Object)supplementItemInfo.getPrice_size5());
                jSONObject10.put((Object)"price_size6", (Object)supplementItemInfo.getPrice_size6());
                jSONObject10.put((Object)"price_size7", (Object)supplementItemInfo.getPrice_size7());
                jSONObject10.put((Object)"hidden_ubereat", (Object)supplementItemInfo.isHidden_ubereat());
                jSONObject10.put((Object)"supplement_item_ubereat", (Object)supplementItemInfo.isSupplement_item_ubereat());
                jSONObject10.put((Object)"id_product", !oldJsonVersion && supplementItemInfo.getId_product_global() != null && !supplementItemInfo.getId_product_global().isEmpty() ? supplementItemInfo.getId_product_global() : Integer.valueOf(supplementItemInfo.getId_product()));
                jSONObject10.put((Object)"sold_out", (Object)supplementItemInfo.isSold_out());
                jSONObject10.put((Object)"hidden_in_kitchen", (Object)supplementItemInfo.isHidden_in_kitchen());
                jSONObject10.put((Object)"cookable", (Object)supplementItemInfo.isCookable());
                jSONObject10.put((Object)"rate_taxe", (Object)supplementItemInfo.getRateTaxe());
                jSONObject10.put((Object)"price_already_included", (Object)supplementItemInfo.getPrice_already_included());
                jSONObject10.put((Object)"idGlobal", (Object)supplementItemInfo.getId_global());
                jSONObject10.put((Object)"imageURL", (Object)supplementItemInfo.getImageUrl());
                JSONArray jSONArray13 = new JSONArray();
                for (ScreenSupplementItem screenSupplementItem : supplementItemInfo.getScreen()) {
                    JSONObject jsonScreenSupplement = new JSONObject();
                    jsonScreenSupplement.put((Object)"id", (Object)screenSupplementItem.getId());
                    jsonScreenSupplement.put((Object)"id_supplement", (Object)screenSupplementItem.getId_supplement());
                    jsonScreenSupplement.put((Object)"id_screen", (Object)screenSupplementItem.getId_screen());
                    jsonScreenSupplement.put((Object)"name_screen", (Object)screenSupplementItem.getName_screen());
                    jSONArray13.put((Map)jsonScreenSupplement);
                }
                JSONArray jSONArray14 = new JSONArray();
                for (Object priceOption2 : supplementItemInfo.getSupplementPrices()) {
                    JSONObject jSONObject11 = new JSONObject();
                    jSONObject11.put((Object)"id_price", (Object)((SupplementPriceInfo)priceOption2).getId());
                    jSONObject11.put((Object)"type_order", (Object)((SupplementPriceInfo)priceOption2).getType_order());
                    jSONObject11.put((Object)"price", (Object)((SupplementPriceInfo)priceOption2).getPrice());
                    jSONObject11.put((Object)"price_junior", (Object)((SupplementPriceInfo)priceOption2).getPrice_junior());
                    jSONObject11.put((Object)"price_senior", (Object)((SupplementPriceInfo)priceOption2).getPrice_senior());
                    jSONObject11.put((Object)"price_mega", (Object)((SupplementPriceInfo)priceOption2).getPrice_mega());
                    jSONObject11.put((Object)"price_size1", (Object)((SupplementPriceInfo)priceOption2).getPrice_size1());
                    jSONObject11.put((Object)"price_size2", (Object)((SupplementPriceInfo)priceOption2).getPrice_size2());
                    jSONObject11.put((Object)"price_size3", (Object)((SupplementPriceInfo)priceOption2).getPrice_size3());
                    jSONObject11.put((Object)"price_size4", (Object)((SupplementPriceInfo)priceOption2).getPrice_size4());
                    jSONObject11.put((Object)"price_size5", (Object)((SupplementPriceInfo)priceOption2).getPrice_size5());
                    jSONObject11.put((Object)"price_size6", (Object)((SupplementPriceInfo)priceOption2).getPrice_size6());
                    jSONObject11.put((Object)"price_size7", (Object)((SupplementPriceInfo)priceOption2).getPrice_size7());
                    jSONObject11.put((Object)"idGlobal", (Object)((SupplementPriceInfo)priceOption2).getId_global());
                    jSONArray14.put((Map)jSONObject11);
                }
                JSONArray jSONArray15 = new JSONArray();
                priceOption2 = supplementItemInfo.getGroupsSubSupplement().iterator();
                while (priceOption2.hasNext()) {
                    GroupSubSupplementInfo groupSubSupplementInfo = (GroupSubSupplementInfo)priceOption2.next();
                    jSONArray15.put(!oldJsonVersion && groupSubSupplementInfo.getId_global() != null && !groupSubSupplementInfo.getId_global().isEmpty() ? groupSubSupplementInfo.getId_global() : Integer.valueOf(groupSubSupplementInfo.getId()));
                }
                jSONObject10.put((Object)"screens", (Object)jSONArray13);
                jSONObject10.put((Object)"prices", (Object)jSONArray14);
                jSONObject10.put((Object)"color", (Object)supplementItemInfo.getColor());
                jSONObject10.put((Object)"alias_supplement", (Object)supplementItemInfo.getAlias_kitchen());
                jSONObject10.put((Object)"send_color", (Object)supplementItemInfo.isSend_color());
                jSONObject10.put((Object)"flame_enabled", (Object)supplementItemInfo.isFlame_enabled());
                jSONObject10.put((Object)"number_flame", (Object)supplementItemInfo.getNumber_flame());
                jSONObject10.put((Object)"groups_sub_supplement", (Object)jSONArray15);
                JSONObject jsonCompagneDatesOption = new JSONObject();
                jsonCompagneDatesOption.put((Object)"dateDebut", (Object)(supplementItemInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementItemInfo.getDateStartDisplay())));
                jsonCompagneDatesOption.put((Object)"dateFin", (Object)(supplementItemInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementItemInfo.getDateEndDisplay())));
                jSONObject10.put((Object)"campagneDates", (Object)jsonCompagneDatesOption);
                JSONArray jSONArray16 = new JSONArray();
                for (MultiLanguageSupplementItem multiLanguageSupplementItem : supplementItemInfo.getMultiLanguageTexts()) {
                    JSONObject jsonMultiLangueText3 = new JSONObject();
                    jsonMultiLangueText3.put((Object)"langue", (Object)multiLanguageSupplementItem.getLanguage());
                    jsonMultiLangueText3.put((Object)"name", (Object)multiLanguageSupplementItem.getName());
                    jSONArray16.put((Map)jsonMultiLangueText3);
                }
                jSONObject10.put((Object)"translation", (Object)jSONArray16);
                JSONArray jsonAllergenes = new JSONArray();
                List<AllergeneSupplement> list = supplementItemInfo.getAllergenes();
                if (list != null && !list.isEmpty()) {
                    for (AllergeneSupplement allergene : list) {
                        jsonAllergenes.put((Object)allergene.getName());
                    }
                }
                jSONObject10.put((Object)"allergens", (Object)jsonAllergenes);
                jSONArray12.put((Map)jSONObject10);
            }
            JSONArray jSONArray17 = new JSONArray();
            for (ScreenSupplementInfo screenSupplementInfo : supplementInfo.getScreens()) {
                JSONObject jSONObject12 = new JSONObject();
                jSONObject12.put((Object)"id", (Object)screenSupplementInfo.getId());
                jSONObject12.put((Object)"id_supplement", (Object)screenSupplementInfo.getId_supplement());
                jSONObject12.put((Object)"id_screen", (Object)screenSupplementInfo.getId_screen());
                jSONObject12.put((Object)"name_screen", (Object)screenSupplementInfo.getName_screen());
                jSONArray17.put((Map)jSONObject12);
            }
            JSONObject jSONObject13 = new JSONObject();
            jSONObject13.put((Object)"dateDebut", (Object)(supplementInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementInfo.getDateStartDisplay())));
            jSONObject13.put((Object)"dateFin", (Object)(supplementInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementInfo.getDateEndDisplay())));
            jSONObject.put((Object)"campagneDates", (Object)jSONObject13);
            jSONObject.put((Object)"items", (Object)jSONArray12);
            jSONObject.put((Object)"screens", (Object)jSONArray17);
            JSONArray jSONArray18 = new JSONArray();
            for (MultiLanguageSupplement multiLanguageSupplement : supplementInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject14 = new JSONObject();
                jSONObject14.put((Object)"langue", (Object)multiLanguageSupplement.getLanguage());
                jSONObject14.put((Object)"name", (Object)multiLanguageSupplement.getName());
                jSONArray18.put((Map)jSONObject14);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray18);
            jSONArray11.put((Map)jSONObject);
        }
        JSONArray jSONArray19 = new JSONArray();
        for (CarteInfo carteInfo : cartes) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)carteInfo.getId());
            jSONObject.put((Object)"name", (Object)carteInfo.getName());
            jSONObject.put((Object)"size_carte", (Object)carteInfo.getSizeCarte());
            jSONObject.put((Object)"removed", (Object)carteInfo.isRemoved());
            jSONObject.put((Object)"removed_by_admin", (Object)carteInfo.isRemoved_by_admin());
            jSONObject.put((Object)"idGlobal", (Object)carteInfo.getId_global());
            JSONArray jSONArray20 = new JSONArray();
            for (CarteItemInfo carteItemInfo : carteInfo.getCarteItems()) {
                JSONObject jSONObject15 = new JSONObject();
                jSONObject15.put((Object)"id_carte", !oldJsonVersion && carteInfo.getId_global() != null && !carteInfo.getId_global().isEmpty() ? carteInfo.getId_global() : Integer.valueOf(carteItemInfo.getId_carte()));
                jSONObject15.put((Object)"id_item", !oldJsonVersion && carteItemInfo.getId_global_item() != null && !carteItemInfo.getId_global_item().isEmpty() ? carteItemInfo.getId_global_item() : Integer.valueOf(carteItemInfo.getId_item()));
                jSONObject15.put((Object)"price", (Object)carteItemInfo.getPrice());
                jSONObject15.put((Object)"order_item", (Object)carteItemInfo.getOrder_item());
                jSONArray20.put((Map)jSONObject15);
            }
            jSONObject.put((Object)"items", (Object)jSONArray20);
            JSONArray jSONArray21 = new JSONArray();
            for (MultiLanguageCarte multiLanguageCarte : carteInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject16 = new JSONObject();
                jSONObject16.put((Object)"langue", (Object)multiLanguageCarte.getLanguage());
                jSONObject16.put((Object)"name", (Object)multiLanguageCarte.getName());
                jSONArray21.put((Map)jSONObject16);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray21);
            jSONArray19.put((Map)jSONObject);
        }
        JSONArray jSONArray22 = new JSONArray();
        for (GroupSubSupplementInfo groupSubSupplementInfo : groupsSubSupplements) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)groupSubSupplementInfo.getId());
            jSONObject.put((Object)"name_group", (Object)groupSubSupplementInfo.getName_group());
            jSONObject.put((Object)"title_group", (Object)groupSubSupplementInfo.getTitle_group());
            jSONObject.put((Object)"removed", (Object)groupSubSupplementInfo.isRemoved());
            jSONObject.put((Object)"option_free", (Object)groupSubSupplementInfo.getOption_free());
            jSONObject.put((Object)"has_limit_options", (Object)groupSubSupplementInfo.isHas_limit_options());
            jSONObject.put((Object)"min_option", (Object)groupSubSupplementInfo.getMin_options());
            jSONObject.put((Object)"max_option", (Object)groupSubSupplementInfo.getMax_options());
            jSONObject.put((Object)"idGlobal", (Object)groupSubSupplementInfo.getId_global());
            jSONObject.put((Object)"number_click", (Object)groupSubSupplementInfo.getNumber_click());
            JSONArray jSONArray23 = new JSONArray();
            for (SupplementItemInfo supplementItemInfo : groupSubSupplementInfo.getSupplements()) {
                jSONArray23.put(!oldJsonVersion && supplementItemInfo.getId_global() != null && !supplementItemInfo.getId_global().isEmpty() ? supplementItemInfo.getId_global() : Integer.valueOf(supplementItemInfo.getiD()));
            }
            jSONObject.put((Object)"sub_supplements", (Object)jSONArray23);
            JSONArray jSONArray24 = new JSONArray();
            for (MultiLanguageGSS multiLanguageGSS : groupSubSupplementInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject17 = new JSONObject();
                jSONObject17.put((Object)"langue", (Object)multiLanguageGSS.getLanguage());
                jSONObject17.put((Object)"name", (Object)multiLanguageGSS.getName());
                jSONObject17.put((Object)"title_group", (Object)multiLanguageGSS.getTitle_group());
                jSONArray24.put((Map)jSONObject17);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray24);
            jSONArray22.put((Map)jSONObject);
        }
        JSONArray jSONArray25 = new JSONArray();
        for (PromotionInfo promotionInfo : promotions) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)promotionInfo.getId());
            jSONObject.put((Object)"name_promotion", (Object)promotionInfo.getName_promotion());
            jSONObject.put((Object)"type_order", (Object)promotionInfo.getType_order());
            jSONObject.put((Object)"size_product", (Object)promotionInfo.getSize_product());
            jSONObject.put((Object)"quantity", (Object)promotionInfo.getQuantity());
            jSONObject.put((Object)"discount", (Object)promotionInfo.getDiscount());
            jSONObject.put((Object)"removed", (Object)promotionInfo.isRemoved());
            jSONObject.put((Object)"removed_by_admin", (Object)promotionInfo.isRemoved_by_admin());
            jSONObject.put((Object)"label_size_product", (Object)promotionInfo.getLabel_size_product());
            jSONObject.put((Object)"label_discount", (Object)promotionInfo.getLabel_discount());
            jSONObject.put((Object)"idGlobal", (Object)promotionInfo.getId_global());
            jSONObject.put((Object)"description", (Object)promotionInfo.getDescription());
            jSONObject.put((Object)"text_promo", (Object)promotionInfo.getText_promo());
            JSONArray jSONArray26 = new JSONArray();
            for (MultiLanguagePromotion multiLanguagePromotion : promotionInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject18 = new JSONObject();
                jSONObject18.put((Object)"langue", (Object)multiLanguagePromotion.getLanguage());
                jSONObject18.put((Object)"name", (Object)multiLanguagePromotion.getName());
                jSONObject18.put((Object)"description", (Object)multiLanguagePromotion.getDescription());
                jSONObject18.put((Object)"text_promo", (Object)multiLanguagePromotion.getText_promo());
                jSONArray26.put((Map)jSONObject18);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray26);
            jSONArray25.put((Map)jSONObject);
        }
        JSONArray jSONArray27 = new JSONArray();
        if (languages != null) {
            for (LanguageInfo languageInfo : languages) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"code", (Object)languageInfo.getCode_language());
                jSONObject.put((Object)"label", (Object)languageInfo.getLabel_language());
                jSONObject.put((Object)"isActive", (Object)languageInfo.isEnabled());
                jSONObject.put((Object)"isDefault", (Object)languageInfo.isDefault_language());
                jSONArray27.put((Map)jSONObject);
            }
        }
        JSONObject jSONObject = new JSONObject();
        for (NutrientData nutrientData : ntriDatas) {
            JSONObject jSONObject19 = new JSONObject();
            jSONObject19.put((Object)"image", (Object)nutrientData.getImage());
            jSONObject19.put((Object)"color", (Object)nutrientData.getColor());
            jSONObject.put((Object)nutrientData.getNutrient(), (Object)jSONObject19);
        }
        jsonRoot.put((Object)"categories", (Object)jSONArray3);
        jsonRoot.put((Object)"items", (Object)jSONArray4);
        jsonRoot.put((Object)"options", (Object)jSONArray11);
        jsonRoot.put((Object)"cartes", (Object)jSONArray19);
        jsonRoot.put((Object)"printers", (Object)jSONArray2);
        jsonRoot.put((Object)"groups_sub_options", (Object)jSONArray22);
        jsonRoot.put((Object)"promotions", (Object)jSONArray25);
        jsonRoot.put((Object)"screens", (Object)jsonAllScreens);
        jsonRoot.put((Object)"tags", (Object)jSONArray);
        jsonRoot.put((Object)"listeLanguages", (Object)jSONArray27);
        jsonRoot.put((Object)"zones", (Object)jsonAllZones);
        jsonRoot.put((Object)"nutritional_info", (Object)jSONObject);
        return jsonRoot;
    }

    public static JSONObject getRootJsonParamsSite(List<ZoneDeliveryInfo> zones, List<TimeTableInfo> timestable, SiteConfig mSiteConfig) {
        JSONObject jsonRoot = new JSONObject();
        JSONArray jsonAllCities = new JSONArray();
        for (ZoneDeliveryInfo zone : zones) {
            JSONObject jsonZone = new JSONObject();
            jsonZone.put((Object)"zone", (Object)zone.getName_zone());
            jsonZone.put((Object)"amount", (Object)zone.getMin_total());
            jsonZone.put((Object)"delivery_costs", (Object)zone.getDelivery_costs());
            JSONArray jsonArrayCities = new JSONArray();
            for (CityDeliveryInfo city : zone.getCityCollection()) {
                JSONObject jsonCity = new JSONObject();
                jsonCity.put((Object)"city", (Object)city.getCity());
                jsonCity.put((Object)"zip_code", (Object)city.getZipCode());
                jsonArrayCities.put((Map)jsonCity);
            }
            jsonZone.put((Object)"cities", (Object)jsonArrayCities);
            jsonAllCities.put((Map)jsonZone);
        }
        JSONArray jsonAllTimesTable = new JSONArray();
        for (TimeTableInfo timeTable : timestable) {
            JSONObject jsonTimeTable = new JSONObject();
            jsonTimeTable.put((Object)"day", (Object)timeTable.getDay());
            jsonTimeTable.put((Object)"name_day", (Object)timeTable.getName_day());
            jsonTimeTable.put((Object)"dayOff", (Object)timeTable.getDay_off());
            JSONArray jsonArrayWorkShifts = new JSONArray();
            if (!timeTable.getDay_off().booleanValue() && timeTable.getWorkShiftCollection() != null) {
                for (WorkShiftInfo workShiftInfo : timeTable.getWorkShiftCollection()) {
                    if ((workShiftInfo.getStart_shift() == null || workShiftInfo.getStart_shift().isEmpty()) && (workShiftInfo.getEnd_shift() == null || workShiftInfo.getEnd_shift().isEmpty())) continue;
                    JSONObject jsonWorkShift = new JSONObject();
                    jsonWorkShift.put((Object)"start_shift", (Object)workShiftInfo.getStart_shift());
                    jsonWorkShift.put((Object)"end_shift", (Object)workShiftInfo.getEnd_shift());
                    jsonArrayWorkShifts.put((Map)jsonWorkShift);
                }
            }
            jsonTimeTable.put((Object)"workShifts", (Object)jsonArrayWorkShifts);
            jsonAllTimesTable.put((Map)jsonTimeTable);
        }
        jsonRoot.put((Object)"days", (Object)jsonAllTimesTable);
        jsonRoot.put((Object)"zones", (Object)jsonAllCities);
        jsonRoot.put((Object)"hide_name_categories", (Object)AppLocal.HIDE_NAME_CATEGORIES_WEB);
        jsonRoot.put((Object)"hide_name_sub_categories", (Object)AppLocal.HIDE_NAME_SUB_CATEGORIES_WEB);
        jsonRoot.put((Object)"hide_name_products", (Object)AppLocal.HIDE_NAME_PRODUCTS_WEB);
        jsonRoot.put((Object)"hide_name_options", (Object)AppLocal.HIDE_NAME_OPTIONS_WEB);
        jsonRoot.put((Object)"at_spot", (Object)mSiteConfig.isAt_spot());
        jsonRoot.put((Object)"take_away", (Object)mSiteConfig.isTake_away());
        jsonRoot.put((Object)"delivery", (Object)mSiteConfig.isDelivery());
        jsonRoot.put((Object)"platform", (Object)mSiteConfig.isPlatform());
        jsonRoot.put((Object)"platform_url", (Object)mSiteConfig.getPlatfom_url());
        jsonRoot.put((Object)"stripe", (Object)mSiteConfig.isStripe());
        jsonRoot.put((Object)"has_delivery", (Object)(AppLocal.licence != null && AppLocal.licence.equalsIgnoreCase("livraison") ? 1 : 0));
        jsonRoot.put((Object)"hide_image_options", (Object)mSiteConfig.isHide_image_option());
        return jsonRoot;
    }

    public static JSONObject getJsonCarteAndParamsBorne(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages, List<NutrientData> ntriDatas) {
        JSONObject jsonRoot = ResponseObject.getJsonCarte(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, false, ntriDatas);
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        jsonRoot.put((Object)"promo_basket", (Object)AppLocal.PROMO_BASKET);
        jsonRoot.put((Object)"min_price_order_promo_basket", (Object)AppLocal.MIN_PRICE_ORDER_PROMO_BASKET);
        jsonRoot.put((Object)"price_promo_basket", (Object)AppLocal.PRICE_PROMO_BASKET);
        jsonRoot.put((Object)"product_size_1", (Object)AppLocal.PRODUCT_SIZE_JUNIOR);
        jsonRoot.put((Object)"product_size_2", (Object)AppLocal.PRODUCT_SIZE_SENIOR);
        jsonRoot.put((Object)"product_size_3", (Object)AppLocal.PRODUCT_SIZE_MEGA);
        jsonRoot.put((Object)"product_size_4", (Object)AppLocal.PRODUCT_SIZE1);
        jsonRoot.put((Object)"product_size_5", (Object)AppLocal.PRODUCT_SIZE2);
        jsonRoot.put((Object)"product_size_6", (Object)AppLocal.PRODUCT_SIZE3);
        jsonRoot.put((Object)"product_size_7", (Object)AppLocal.PRODUCT_SIZE4);
        jsonRoot.put((Object)"product_size_8", (Object)AppLocal.PRODUCT_SIZE5);
        jsonRoot.put((Object)"product_size_9", (Object)AppLocal.PRODUCT_SIZE6);
        jsonRoot.put((Object)"product_size_10", (Object)AppLocal.PRODUCT_SIZE7);
        jsonRoot.put((Object)"product_size_1_enabled", (Object)appConfig.getProperty("product.senior.enabled"));
        jsonRoot.put((Object)"product_size_2_enabled", (Object)appConfig.getProperty("product.senior.enabled"));
        jsonRoot.put((Object)"product_size_3_enabled", (Object)appConfig.getProperty("product.mega.enabled"));
        jsonRoot.put((Object)"product_size_4_enabled", (Object)appConfig.getProperty("product.size1.enabled"));
        jsonRoot.put((Object)"product_size_5_enabled", (Object)appConfig.getProperty("product.size2.enabled"));
        jsonRoot.put((Object)"product_size_6_enabled", (Object)appConfig.getProperty("product.size3.enabled"));
        jsonRoot.put((Object)"product_size_7_enabled", (Object)appConfig.getProperty("product.size4.enabled"));
        jsonRoot.put((Object)"product_size_8_enabled", (Object)appConfig.getProperty("product.size5.enabled"));
        jsonRoot.put((Object)"product_size_9_enabled", (Object)appConfig.getProperty("product.size6.enabled"));
        jsonRoot.put((Object)"product_size_10_enabled", (Object)appConfig.getProperty("product.size7.enabled"));
        jsonRoot.put((Object)"product_size_1_descreption", (Object)AppLocal.PRODUCT_SIZE1_DESCRIPTION);
        jsonRoot.put((Object)"product_size_2_descreption", (Object)AppLocal.PRODUCT_SIZE2_DESCRIPTION);
        jsonRoot.put((Object)"product_size_3_descreption", (Object)AppLocal.PRODUCT_SIZE3_DESCRIPTION);
        jsonRoot.put((Object)"product_size_4_descreption", (Object)AppLocal.PRODUCT_SIZE4_DESCRIPTION);
        jsonRoot.put((Object)"product_size_5_descreption", (Object)AppLocal.PRODUCT_SIZE5_DESCRIPTION);
        jsonRoot.put((Object)"product_size_6_descreption", (Object)AppLocal.PRODUCT_SIZE6_DESCRIPTION);
        jsonRoot.put((Object)"product_size_7_descreption", (Object)AppLocal.PRODUCT_SIZE7_DESCRIPTION);
        jsonRoot.put((Object)"product_size_8_descreption", (Object)AppLocal.PRODUCT_SIZE8_DESCRIPTION);
        jsonRoot.put((Object)"product_size_9_descreption", (Object)AppLocal.PRODUCT_SIZE9_DESCRIPTION);
        jsonRoot.put((Object)"product_size_10_descreption", (Object)AppLocal.PRODUCT_SIZE10_DESCRIPTION);
        HashMap<Integer, String> mapTariff = new HashMap<Integer, String>();
        mapTariff.put(1, "Tarif 1");
        mapTariff.put(2, "Tarif 2");
        mapTariff.put(3, "Tarif 3");
        jsonRoot.put((Object)"tariff", mapTariff.get(AppLocal.TARIFF) != null ? mapTariff.get(AppLocal.TARIFF) : null);
        System.out.println("++++++jsonRoot Parametres" + jsonRoot);
        return jsonRoot;
    }

    private static ProductSizeInfo getProductSize(List<ProductSizeInfo> listSizes, String size_name) {
        if (listSizes != null) {
            for (ProductSizeInfo size : listSizes) {
                if (!size.getName().equalsIgnoreCase(size_name) || size.getTariff() != AppLocal.TARIFF) continue;
                return size;
            }
        }
        return new ProductSizeInfo(size_name, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, null, 0.0, false, 1);
    }

    public static JSONArray getJsonLivreurs(List<LivreurInfo> livreurs) {
        JSONArray jsonLivreArray = new JSONArray();
        for (LivreurInfo livreur : livreurs) {
            JSONObject jsonlivreur = new JSONObject();
            jsonlivreur.put((Object)"id", (Object)livreur.getId());
            jsonlivreur.put((Object)"name", (Object)livreur.getName());
            jsonlivreur.put((Object)"code_livreur", (Object)livreur.getApppassword());
            jsonLivreArray.put((Map)jsonlivreur);
        }
        return jsonLivreArray;
    }

    private static JSONObject getJsonCategory(CategoryInfo categoryInfo, boolean oldJsonVersion) {
        JSONObject jsonCategory = new JSONObject();
        jsonCategory.put((Object)"idCat", (Object)categoryInfo.getID());
        jsonCategory.put((Object)"name", (Object)categoryInfo.getName());
        jsonCategory.put((Object)"position", (Object)categoryInfo.getOrdercategory());
        jsonCategory.put((Object)"removed", (Object)categoryInfo.isRemoved());
        jsonCategory.put((Object)"hidden", (Object)categoryInfo.isHidden());
        jsonCategory.put((Object)"color", (Object)categoryInfo.getColor());
        jsonCategory.put((Object)"apply_discount", (Object)categoryInfo.isApply_discount());
        jsonCategory.put((Object)"path", (Object)categoryInfo.getPath());
        jsonCategory.put((Object)"hidden_borne", (Object)categoryInfo.isHidden_borne());
        jsonCategory.put((Object)"hidden_caisse", (Object)categoryInfo.isHidden_caisse());
        if (oldJsonVersion) {
            jsonCategory.put((Object)"parent_id", (Object)categoryInfo.getParent_id());
        } else {
            jsonCategory.put((Object)"parent_id", categoryInfo.getParent_id_global() != null ? categoryInfo.getParent_id_global() : Integer.valueOf(categoryInfo.getParent_id()));
        }
        jsonCategory.put((Object)"moment_category", (Object)categoryInfo.isMoment_category());
        jsonCategory.put((Object)"removed_by_admin", (Object)categoryInfo.isRemoved_by_admin());
        jsonCategory.put((Object)"sold_out", (Object)categoryInfo.isSold_out());
        jsonCategory.put((Object)"products_first", (Object)categoryInfo.isProducts_first());
        jsonCategory.put((Object)"next_available", (Object)categoryInfo.isNext_available());
        jsonCategory.put((Object)"display_time", (Object)categoryInfo.isHas_display_time());
        jsonCategory.put((Object)"first_period", (Object)categoryInfo.getFirst_period());
        jsonCategory.put((Object)"end_period", (Object)categoryInfo.getEnd_period());
        jsonCategory.put((Object)"available_caisse", (Object)categoryInfo.isAvailable_caisse());
        jsonCategory.put((Object)"has_sub_categories", (Object)(!categoryInfo.getSub_categories().isEmpty() ? 1 : 0));
        jsonCategory.put((Object)"hide_name_in_borne", (Object)categoryInfo.isHide_name_in_borne());
        jsonCategory.put((Object)"hidden_online", (Object)categoryInfo.isHidden_online());
        jsonCategory.put((Object)"hidden_ubereat", (Object)categoryInfo.isHidden_ubereat());
        jsonCategory.put((Object)"category_ubereat", (Object)categoryInfo.isCategory_ubereat());
        jsonCategory.put((Object)"offset_print_kitchen", (Object)categoryInfo.getOffset_print_kitchen());
        jsonCategory.put((Object)"path_category_moment", (Object)categoryInfo.getPath_category_moment());
        jsonCategory.put((Object)"type_image_category_moment", (Object)categoryInfo.getType_image_category_moment());
        jsonCategory.put((Object)"has_timetable", (Object)categoryInfo.isHas_timetable());
        JSONArray jsonTagsCatgory = new JSONArray();
        jsonCategory.put((Object)"idGlobal", (Object)categoryInfo.getId_global());
        for (TagInfo tagInfo : categoryInfo.getTags()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id_category", (Object)categoryInfo.getID());
            jSONObject.put((Object)"id_tag", (Object)tagInfo.getId());
            jSONObject.put((Object)"name_tag", (Object)tagInfo.getName());
            jSONObject.put((Object)"number_tag", (Object)tagInfo.getNumber());
            jSONObject.put((Object)"logo_tag", (Object)tagInfo.getLogo_tag());
            jSONObject.put((Object)"background_catalog", (Object)tagInfo.getBackground_catalog());
            jSONObject.put((Object)"enabled", (Object)tagInfo.isEnabled());
            jSONObject.put((Object)"closed", (Object)tagInfo.isClosed());
            jsonTagsCatgory.put((Map)jSONObject);
        }
        JSONArray jsonDaysOnCat = new JSONArray();
        for (CategoryDayAvailable categoryDayAvailable : categoryInfo.getDaysOn()) {
            JSONObject jsonCategoryDayOn = new JSONObject();
            jsonCategoryDayOn.put((Object)"id", (Object)categoryDayAvailable.getId());
            jsonCategoryDayOn.put((Object)"day_of_week", (Object)categoryDayAvailable.getDayOfWeek());
            jsonCategoryDayOn.put((Object)"id_category", (Object)categoryDayAvailable.getCategoryId());
            jsonDaysOnCat.put((Map)jsonCategoryDayOn);
        }
        JSONArray jSONArray = new JSONArray();
        for (ShiftCategory mShiftCategory : categoryInfo.getShiftsCategory()) {
            JSONObject jsonCategoryShift = new JSONObject();
            jsonCategoryShift.put((Object)"id", (Object)mShiftCategory.getId());
            jsonCategoryShift.put((Object)"date_start", (Object)mShiftCategory.getDateStart());
            jsonCategoryShift.put((Object)"date_end", (Object)mShiftCategory.getDateEnd());
            jsonCategoryShift.put((Object)"id_category", (Object)mShiftCategory.getICategory());
            jSONArray.put((Map)jsonCategoryShift);
        }
        jsonCategory.put((Object)"tags", (Object)jsonTagsCatgory);
        jsonCategory.put((Object)"daysOn", (Object)jsonDaysOnCat);
        jsonCategory.put((Object)"shiftsOn", (Object)jSONArray);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"dateDebut", (Object)(categoryInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(categoryInfo.getDateStartDisplay())));
        jSONObject.put((Object)"dateFin", (Object)(categoryInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(categoryInfo.getDateEndDisplay())));
        jsonCategory.put((Object)"campagneDates", (Object)jSONObject);
        jsonCategory.put((Object)"imageURL", (Object)categoryInfo.getImageUrl());
        JSONArray jsonTranslation = new JSONArray();
        for (MultiLanguageCategory multiLanguageText : categoryInfo.getMultiLanguageTexts()) {
            JSONObject jsonMultiLangueText = new JSONObject();
            jsonMultiLangueText.put((Object)"langue", (Object)multiLanguageText.getLanguage());
            jsonMultiLangueText.put((Object)"name", (Object)multiLanguageText.getName());
            jsonTranslation.put((Map)jsonMultiLangueText);
        }
        jsonCategory.put((Object)"translation", (Object)jsonTranslation);
        return jsonCategory;
    }

    public static JSONObject getJsonCarteAndParamsBorneOld(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages) {
        JSONObject jsonRoot = ResponseObject.getJsonCarteOld(printers, categories, items, options, cartes, cartesMenu, groupsSubSupplements, promotions, screens, tags, zones, languages, true);
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        jsonRoot.put((Object)"promo_basket", (Object)AppLocal.PROMO_BASKET);
        jsonRoot.put((Object)"min_price_order_promo_basket", (Object)AppLocal.MIN_PRICE_ORDER_PROMO_BASKET);
        jsonRoot.put((Object)"price_promo_basket", (Object)AppLocal.PRICE_PROMO_BASKET);
        jsonRoot.put((Object)"product_size_1", (Object)AppLocal.PRODUCT_SIZE_JUNIOR);
        jsonRoot.put((Object)"product_size_2", (Object)AppLocal.PRODUCT_SIZE_SENIOR);
        jsonRoot.put((Object)"product_size_3", (Object)AppLocal.PRODUCT_SIZE_MEGA);
        jsonRoot.put((Object)"product_size_4", (Object)AppLocal.PRODUCT_SIZE1);
        jsonRoot.put((Object)"product_size_5", (Object)AppLocal.PRODUCT_SIZE2);
        jsonRoot.put((Object)"product_size_6", (Object)AppLocal.PRODUCT_SIZE3);
        jsonRoot.put((Object)"product_size_7", (Object)AppLocal.PRODUCT_SIZE4);
        jsonRoot.put((Object)"product_size_8", (Object)AppLocal.PRODUCT_SIZE5);
        jsonRoot.put((Object)"product_size_9", (Object)AppLocal.PRODUCT_SIZE6);
        jsonRoot.put((Object)"product_size_10", (Object)AppLocal.PRODUCT_SIZE7);
        jsonRoot.put((Object)"product_size_1_enabled", (Object)appConfig.getProperty("product.senior.enabled"));
        jsonRoot.put((Object)"product_size_2_enabled", (Object)appConfig.getProperty("product.senior.enabled"));
        jsonRoot.put((Object)"product_size_3_enabled", (Object)appConfig.getProperty("product.mega.enabled"));
        jsonRoot.put((Object)"product_size_4_enabled", (Object)appConfig.getProperty("product.size1.enabled"));
        jsonRoot.put((Object)"product_size_5_enabled", (Object)appConfig.getProperty("product.size2.enabled"));
        jsonRoot.put((Object)"product_size_6_enabled", (Object)appConfig.getProperty("product.size3.enabled"));
        jsonRoot.put((Object)"product_size_7_enabled", (Object)appConfig.getProperty("product.size4.enabled"));
        jsonRoot.put((Object)"product_size_8_enabled", (Object)appConfig.getProperty("product.size5.enabled"));
        jsonRoot.put((Object)"product_size_9_enabled", (Object)appConfig.getProperty("product.size6.enabled"));
        jsonRoot.put((Object)"product_size_10_enabled", (Object)appConfig.getProperty("product.size7.enabled"));
        jsonRoot.put((Object)"product_size_1_descreption", (Object)AppLocal.PRODUCT_SIZE1_DESCRIPTION);
        jsonRoot.put((Object)"product_size_2_descreption", (Object)AppLocal.PRODUCT_SIZE2_DESCRIPTION);
        jsonRoot.put((Object)"product_size_3_descreption", (Object)AppLocal.PRODUCT_SIZE3_DESCRIPTION);
        jsonRoot.put((Object)"product_size_4_descreption", (Object)AppLocal.PRODUCT_SIZE4_DESCRIPTION);
        jsonRoot.put((Object)"product_size_5_descreption", (Object)AppLocal.PRODUCT_SIZE5_DESCRIPTION);
        jsonRoot.put((Object)"product_size_6_descreption", (Object)AppLocal.PRODUCT_SIZE6_DESCRIPTION);
        jsonRoot.put((Object)"product_size_7_descreption", (Object)AppLocal.PRODUCT_SIZE7_DESCRIPTION);
        jsonRoot.put((Object)"product_size_8_descreption", (Object)AppLocal.PRODUCT_SIZE8_DESCRIPTION);
        jsonRoot.put((Object)"product_size_9_descreption", (Object)AppLocal.PRODUCT_SIZE9_DESCRIPTION);
        jsonRoot.put((Object)"product_size_10_descreption", (Object)AppLocal.PRODUCT_SIZE10_DESCRIPTION);
        System.out.println("++++++jsonRoot Parametres" + jsonRoot);
        return jsonRoot;
    }

    public static JSONObject getJsonCarteOld(List<PrinterInfo> printers, List<CategoryInfo> categories, List<ProductInfoExt> items, List<SupplementInfo> options, List<CarteInfo> cartes, List<CarteMenu> cartesMenu, List<GroupSubSupplementInfo> groupsSubSupplements, List<PromotionInfo> promotions, List<LocalScreen> screens, List<TagInfo> tags, List<ZoneInfo> zones, List<LanguageInfo> languages, boolean oldJsonVersion) {
        JSONObject jsonRoot = new JSONObject();
        JSONArray jsonAllZones = new JSONArray();
        for (ZoneInfo zoneInfo : zones) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)zoneInfo.getId());
            jSONObject.put((Object)"name_zone", (Object)zoneInfo.getName());
            jSONObject.put((Object)"position_zone", (Object)zoneInfo.getPosition());
            jSONObject.put((Object)"color", (Object)ColorUtils.getHexadecimal(zoneInfo.getColor()));
            jsonAllZones.put((Map)jSONObject);
        }
        JSONArray jsonAllScreens = new JSONArray();
        for (LocalScreen localScreen : screens) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idScreen", (Object)localScreen.getId());
            jSONObject.put((Object)"name_screen", (Object)localScreen.getName());
            jSONObject.put((Object)"number_screen", (Object)localScreen.getNumber());
            jsonAllScreens.put((Map)jSONObject);
        }
        JSONArray jSONArray = new JSONArray();
        for (TagInfo tagInfo : tags) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idTag", (Object)tagInfo.getId());
            jSONObject.put((Object)"name_tag", (Object)tagInfo.getName());
            jSONObject.put((Object)"number_tag", (Object)tagInfo.getNumber());
            jSONObject.put((Object)"deleted", (Object)true);
            jSONObject.put((Object)"logo_tag", (Object)tagInfo.getLogo_tag());
            jSONObject.put((Object)"background_catalog", (Object)tagInfo.getBackground_catalog());
            jSONObject.put((Object)"enabled", (Object)tagInfo.isEnabled());
            jSONObject.put((Object)"closed", (Object)tagInfo.isClosed());
            jSONArray.put((Map)jSONObject);
        }
        JSONArray jSONArray2 = new JSONArray();
        for (PrinterInfo printerInfo : printers) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"idPrinter", (Object)printerInfo.getId());
            jSONObject.put((Object)"name", (Object)printerInfo.getName());
            jSONObject.put((Object)"type", (Object)printerInfo.getType());
            jSONObject.put((Object)"ip_address", (Object)printerInfo.getIp());
            jSONObject.put((Object)"width_ticket", (Object)printerInfo.getWith());
            jSONObject.put((Object)"number_ticket", (Object)printerInfo.getNumber());
            jSONObject.put((Object)"type_printer", (Object)printerInfo.getTypePrinter());
            jSONArray2.put((Map)jSONObject);
        }
        JSONArray jSONArray3 = new JSONArray();
        for (CategoryInfo categoryInfo : categories) {
            if (categoryInfo.getParent_id() != 0 && categoryInfo.getParent_id() != -1) continue;
            JSONObject jSONObject = ResponseObject.getJsonCategoryOld(categoryInfo, oldJsonVersion);
            jSONArray3.put((Map)jSONObject);
            for (CategoryInfo categoryInfo2 : categoryInfo.getSub_categories()) {
                JSONObject jSONObject2 = ResponseObject.getJsonCategoryOld(categoryInfo2, oldJsonVersion);
                jSONArray3.put((Map)jSONObject2);
            }
        }
        JSONArray jSONArray4 = new JSONArray();
        for (ProductInfoExt productInfoExt : items) {
            Object sizeProduct3;
            Object mProductDayOn2;
            Object promotion2;
            Object carteProduct2;
            Object sizeProduct22;
            ProductSizeInfo productSizeInfo = ResponseObject.getProductSize(productInfoExt.getListSizes(), "junior");
            ProductSizeInfo productSizeInfo2 = ResponseObject.getProductSize(productInfoExt.getListSizes(), "senior");
            ProductSizeInfo productSizeInfo3 = ResponseObject.getProductSize(productInfoExt.getListSizes(), "mega");
            JSONObject jsonItem = new JSONObject();
            jsonItem.put((Object)"idItem", (Object)productInfoExt.getID());
            jsonItem.put((Object)"bar_code", (Object)productInfoExt.getCode());
            jsonItem.put((Object)"idCat", !oldJsonVersion && productInfoExt.getId_global_category() != null && !productInfoExt.getId_global_category().isEmpty() ? productInfoExt.getId_global_category() : Integer.valueOf(productInfoExt.getCategoryid()));
            jsonItem.put((Object)"position", (Object)productInfoExt.getOrder_item());
            jsonItem.put((Object)"name", (Object)productInfoExt.getName());
            jsonItem.put((Object)"price", (Object)productInfoExt.getPrice(null, AppLocal.TARIFF));
            jsonItem.put((Object)"purchase_price", (Object)productInfoExt.getPriceBuy());
            jsonItem.put((Object)"tax", (Object)productInfoExt.getRate_tax());
            jsonItem.put((Object)"cook", (Object)productInfoExt.isPrepared());
            jsonItem.put((Object)"available_takeaway", (Object)productInfoExt.getEmp());
            jsonItem.put((Object)"available_on_the_spot", (Object)productInfoExt.getSp());
            jsonItem.put((Object)"available_delivery", (Object)productInfoExt.getLv());
            jsonItem.put((Object)"available_bar", (Object)productInfoExt.getBar());
            jsonItem.put((Object)"available_terasse", (Object)productInfoExt.getTerasse());
            jsonItem.put((Object)"available_happy_hour", (Object)productInfoExt.getHappy_hour());
            jsonItem.put((Object)"is_menu", (Object)productInfoExt.isMenu());
            jsonItem.put((Object)"price_type", (Object)productInfoExt.getPrice_type());
            jsonItem.put((Object)"price_sp", (Object)productInfoExt.getPrice("Sur Place", AppLocal.TARIFF));
            jsonItem.put((Object)"price_emp", (Object)productInfoExt.getPrice("A Emporter", AppLocal.TARIFF));
            jsonItem.put((Object)"price_lv", (Object)productInfoExt.getPrice("En Livraison", AppLocal.TARIFF));
            jsonItem.put((Object)"price_bar", (Object)productInfoExt.getPrice("BAR", AppLocal.TARIFF));
            jsonItem.put((Object)"price_terasse", (Object)productInfoExt.getPrice("Terasse", AppLocal.TARIFF));
            jsonItem.put((Object)"price_happy", (Object)productInfoExt.getPrice("Happy Hour", AppLocal.TARIFF));
            jsonItem.put((Object)"price_junior", (Object)productSizeInfo.getPrice());
            jsonItem.put((Object)"price_senior", (Object)productSizeInfo2.getPrice());
            jsonItem.put((Object)"price_mega", (Object)productSizeInfo3.getPrice());
            jsonItem.put((Object)"price_sp_junior", (Object)productSizeInfo.getPrice_sp());
            jsonItem.put((Object)"price_sp_senior", (Object)productSizeInfo2.getPrice_sp());
            jsonItem.put((Object)"price_sp_mega", (Object)productSizeInfo3.getPrice_sp());
            jsonItem.put((Object)"price_emp_junior", (Object)productSizeInfo.getPrice_emp());
            jsonItem.put((Object)"price_emp_senior", (Object)productSizeInfo2.getPrice_emp());
            jsonItem.put((Object)"price_emp_mega", (Object)productSizeInfo3.getPrice_emp());
            jsonItem.put((Object)"price_lv_junior", (Object)productSizeInfo.getPrice_lv());
            jsonItem.put((Object)"price_lv_senior", (Object)productSizeInfo2.getPrice_lv());
            jsonItem.put((Object)"price_lv_mega", (Object)productSizeInfo3.getPrice_lv());
            jsonItem.put((Object)"price_bar_junior", (Object)productSizeInfo.getPrice_bar());
            jsonItem.put((Object)"price_bar_senior", (Object)productSizeInfo2.getPrice_bar());
            jsonItem.put((Object)"price_bar_mega", (Object)productSizeInfo3.getPrice_bar());
            jsonItem.put((Object)"price_terasse_junior", (Object)productSizeInfo.getPrice_terasse());
            jsonItem.put((Object)"price_terasse_senior", (Object)productSizeInfo2.getPrice_terasse());
            jsonItem.put((Object)"price_terasse_mega", (Object)productSizeInfo3.getPrice_terasse());
            jsonItem.put((Object)"price_happy_junior", (Object)productSizeInfo.getPrice_happy_hour());
            jsonItem.put((Object)"price_happy_senior", (Object)productSizeInfo2.getPrice_happy_hour());
            jsonItem.put((Object)"price_happy_mega", (Object)productSizeInfo3.getPrice_happy_hour());
            jsonItem.put((Object)"removed", (Object)true);
            jsonItem.put((Object)"hidden", (Object)productInfoExt.isHidden());
            jsonItem.put((Object)"printer", (Object)productInfoExt.getPrinterID());
            jsonItem.put((Object)"many_size", (Object)productInfoExt.isMany_size());
            jsonItem.put((Object)"different_price", (Object)productInfoExt.isDifferent_price());
            jsonItem.put((Object)"color", (Object)productInfoExt.getColor());
            jsonItem.put((Object)"tax_emp", (Object)productInfoExt.getRate_tax_emp());
            jsonItem.put((Object)"tax_lv", (Object)productInfoExt.getRate_tax_lv());
            jsonItem.put((Object)"label", (Object)productInfoExt.isHasLabel());
            jsonItem.put((Object)"printerLabel", (Object)productInfoExt.getPrinterLabel());
            jsonItem.put((Object)"option_free", (Object)productInfoExt.getOption_free());
            jsonItem.put((Object)"special_option", (Object)productInfoExt.isSpecial_option());
            jsonItem.put((Object)"number_line", (Object)productInfoExt.getNumber_line());
            jsonItem.put((Object)"number_column", (Object)productInfoExt.getNumber_column());
            jsonItem.put((Object)"max_line", (Object)productInfoExt.getMax_line());
            jsonItem.put((Object)"additional_sale", (Object)productInfoExt.isAdditional_sale());
            jsonItem.put((Object)"moment_product", (Object)productInfoExt.isMoment_product());
            jsonItem.put((Object)"quantity", (Object)productInfoExt.getQuantity());
            jsonItem.put((Object)"unit", (Object)productInfoExt.getUnit());
            jsonItem.put((Object)"weight", (Object)productInfoExt.getWeight());
            jsonItem.put((Object)"extra_unit", (Object)productInfoExt.getExtra_unit());
            jsonItem.put((Object)"apply_discount", (Object)productInfoExt.isApply_discount());
            jsonItem.put((Object)"display_kitchen", (Object)productInfoExt.getDisplayKitchen());
            jsonItem.put((Object)"path", (Object)productInfoExt.getImageProduct());
            jsonItem.put((Object)"hidden_borne", (Object)productInfoExt.isHidden_borne());
            jsonItem.put((Object)"sold_out", (Object)productInfoExt.isSold_out());
            jsonItem.put((Object)"free_price", (Object)productInfoExt.isFree_price());
            jsonItem.put((Object)"alias_product", (Object)productInfoExt.getAlias_kitchen());
            jsonItem.put((Object)"send_color", (Object)productInfoExt.isSend_color());
            jsonItem.put((Object)"display_time", (Object)productInfoExt.isHas_display_time());
            jsonItem.put((Object)"first_period", (Object)productInfoExt.getFirst_period());
            jsonItem.put((Object)"end_period", (Object)productInfoExt.getEnd_period());
            jsonItem.put((Object)"description", (Object)productInfoExt.getDescription());
            jsonItem.put((Object)"removed_by_admin", (Object)true);
            jsonItem.put((Object)"additional_sale_atSpot", (Object)productInfoExt.isAdditional_sale_at_spot());
            jsonItem.put((Object)"additional_sale_take_away", (Object)productInfoExt.isAdditional_sale_take_away());
            jsonItem.put((Object)"later", (Object)productInfoExt.isLater());
            jsonItem.put((Object)"print_ingredients", (Object)productInfoExt.isPrint_ingredients());
            jsonItem.put((Object)"price_platform", (Object)productInfoExt.getPrice("Platform", AppLocal.TARIFF));
            jsonItem.put((Object)"price_platform_junior", (Object)productSizeInfo.getPrice_platform());
            jsonItem.put((Object)"price_platform_senior", (Object)productSizeInfo2.getPrice_platform());
            jsonItem.put((Object)"price_platform_mega", (Object)productSizeInfo3.getPrice_platform());
            jsonItem.put((Object)"available_caisse", (Object)productInfoExt.isAvailable_caisse());
            jsonItem.put((Object)"labeled", (Object)productInfoExt.isLabeled());
            jsonItem.put((Object)"size_junior_enabled", (Object)(productSizeInfo.isSize_enabled() && AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED ? 1 : 0));
            jsonItem.put((Object)"size_senior_enabled", (Object)(productSizeInfo2.isSize_enabled() && AppLocal.PRODUCT_SIZE_SENIOR_ENABLED ? 1 : 0));
            jsonItem.put((Object)"size_mega_enabled", (Object)(productSizeInfo3.isSize_enabled() && AppLocal.PRODUCT_SIZE_MEGA_ENABLED ? 1 : 0));
            jsonItem.put((Object)"best_sale", (Object)productInfoExt.isBest_sale());
            jsonItem.put((Object)"promo_basket", (Object)productInfoExt.isPromo_basket());
            jsonItem.put((Object)"display_image_in_kitchen", (Object)productInfoExt.isDisplay_image_in_kitchen());
            jsonItem.put((Object)"daily_stock", (Object)productInfoExt.getDaily_stock());
            jsonItem.put((Object)"has_bar_code", (Object)productInfoExt.isHas_bar_code());
            jsonItem.put((Object)"top_product", (Object)productInfoExt.isTop_product());
            jsonItem.put((Object)"hide_name_in_borne", (Object)productInfoExt.isHide_name_in_borne());
            jsonItem.put((Object)"hide_price_in_borne", (Object)productInfoExt.isHide_price_in_borne());
            jsonItem.put((Object)"unavailable_online", (Object)productInfoExt.isUnavailable_online());
            jsonItem.put((Object)"hidden_online", (Object)productInfoExt.isHidden_online());
            jsonItem.put((Object)"has_timetable", (Object)productInfoExt.isHas_timetable());
            jsonItem.put((Object)"hidden_ubereat", (Object)productInfoExt.isHidden_platform());
            jsonItem.put((Object)"description_ubereat", (Object)productInfoExt.getDescription_uberEat());
            jsonItem.put((Object)"product_ubereat", (Object)productInfoExt.isProduct_ubereat());
            jsonItem.put((Object)"mixed_product", (Object)productInfoExt.isMixed_product());
            jsonItem.put((Object)"price_drive", (Object)productInfoExt.getPrice("Drive", AppLocal.TARIFF));
            jsonItem.put((Object)"price_drive_junior", (Object)productSizeInfo.getPrice_drive());
            jsonItem.put((Object)"price_drive_senior", (Object)productSizeInfo2.getPrice_drive());
            jsonItem.put((Object)"price_drive_mega", (Object)productSizeInfo3.getPrice_drive());
            jsonItem.put((Object)"product_loyalty", (Object)productInfoExt.isProduct_loyalty());
            jsonItem.put((Object)"price_point", (Object)productInfoExt.getPrice_point());
            jsonItem.put((Object)"sold_out_temporary", (Object)productInfoExt.isSold_out_temporary());
            jsonItem.put((Object)"enable_in_opening_mode", (Object)productInfoExt.isEnable_in_opening());
            jsonItem.put((Object)"price_opening", (Object)productInfoExt.getPrice_opening());
            jsonItem.put((Object)"hidden_caisse", (Object)productInfoExt.isHidden_caisse());
            jsonItem.put((Object)"valid_caisse", (Object)productInfoExt.isValid_caisse());
            jsonItem.put((Object)"tva_global_no_applicable", (Object)productInfoExt.isTva_global_no_applicable());
            jsonItem.put((Object)"marque", (Object)productInfoExt.getMarque());
            ImageProduct imageProduct = productInfoExt.getImageProductMoment();
            String string = imageProduct != null ? imageProduct.getPath() : null;
            String graphic_type_product_moment = imageProduct != null ? imageProduct.getGraphic_type() : null;
            jsonItem.put((Object)"path_product_moment", (Object)string);
            jsonItem.put((Object)"type_image_product_moment", (Object)graphic_type_product_moment);
            jsonItem.put((Object)"path_platform", (Object)productInfoExt.getImageProductPlatForm());
            jsonItem.put((Object)"idGlobal", (Object)productInfoExt.getId_global());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"dateDebut", (Object)(productInfoExt.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(productInfoExt.getDateStartDisplay())));
            jSONObject.put((Object)"dateFin", (Object)(productInfoExt.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(productInfoExt.getDateEndDisplay())));
            jsonItem.put((Object)"campagneDates", (Object)jSONObject);
            jsonItem.put((Object)"imageURL", (Object)productInfoExt.getImageUrlProduct());
            jsonItem.put((Object)"id_zone", (Object)productInfoExt.getZoneId());
            JSONArray jSONArray5 = new JSONArray();
            for (SupplementItemInfo supplementItemInfo : productInfoExt.getIngredients()) {
                JSONObject jsonIngredientProduct = new JSONObject();
                if (oldJsonVersion) {
                    jsonIngredientProduct.put((Object)"id_ingredient", (Object)supplementItemInfo.getiD());
                } else {
                    jsonIngredientProduct.put((Object)"id_ingredient", supplementItemInfo.getId_global() != null && !supplementItemInfo.getId_global().isEmpty() ? supplementItemInfo.getId_global() : Integer.valueOf(supplementItemInfo.getiD()));
                }
                jsonIngredientProduct.put((Object)"name", (Object)supplementItemInfo.getName());
                jsonIngredientProduct.put((Object)"path", (Object)supplementItemInfo.getPath());
                jsonIngredientProduct.put((Object)"hidden_borne", (Object)supplementItemInfo.isHidden_borne());
                jsonIngredientProduct.put((Object)"hidden_online", (Object)supplementItemInfo.isHidden_online());
                jSONArray5.put((Map)jsonIngredientProduct);
            }
            JSONArray jsonSizesProduct = new JSONArray();
            for (Object sizeProduct22 : productInfoExt.getListSizes()) {
                if (((ProductSizeInfo)sizeProduct22).getName() == null || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("junior") || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("senior") || ((ProductSizeInfo)sizeProduct22).getName().equalsIgnoreCase("mega") || ((ProductSizeInfo)sizeProduct22).getTariff() != AppLocal.TARIFF) continue;
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put((Object)"id_size", (Object)((ProductSizeInfo)sizeProduct22).getID());
                jSONObject3.put((Object)"name_size", (Object)((ProductSizeInfo)sizeProduct22).getName());
                jSONObject3.put((Object)"label_size", (Object)((ProductSizeInfo)sizeProduct22).getLabel_size());
                jSONObject3.put((Object)"price", (Object)((ProductSizeInfo)sizeProduct22).getPrice());
                jSONObject3.put((Object)"price_sp", (Object)((ProductSizeInfo)sizeProduct22).getPrice_sp());
                jSONObject3.put((Object)"price_emp", (Object)((ProductSizeInfo)sizeProduct22).getPrice_emp());
                jSONObject3.put((Object)"price_lv", (Object)((ProductSizeInfo)sizeProduct22).getPrice_lv());
                jSONObject3.put((Object)"price_bar", (Object)((ProductSizeInfo)sizeProduct22).getPrice_bar());
                jSONObject3.put((Object)"price_terasse", (Object)((ProductSizeInfo)sizeProduct22).getPrice_terasse());
                jSONObject3.put((Object)"price_happy_hour", (Object)((ProductSizeInfo)sizeProduct22).getPrice_happy_hour());
                jSONObject3.put((Object)"price_uber", (Object)((ProductSizeInfo)sizeProduct22).getPrice_uber());
                jSONObject3.put((Object)"price_delivero", (Object)((ProductSizeInfo)sizeProduct22).getPrice_delivero());
                jSONObject3.put((Object)"price_platform", (Object)((ProductSizeInfo)sizeProduct22).getPrice_platform());
                jSONObject3.put((Object)"price_drive", (Object)((ProductSizeInfo)sizeProduct22).getPrice_drive());
                jSONObject3.put((Object)"idGlobal", (Object)((ProductSizeInfo)sizeProduct22).getId_global());
                switch (((ProductSizeInfo)sizeProduct22).getName()) {
                    case "size1": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE1_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size2": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE2_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size3": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE3_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size4": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE4_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size5": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE5_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size6": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE6_ENABLED ? 1 : 0));
                        break;
                    }
                    case "size7": {
                        jSONObject3.put((Object)"size_enabled", (Object)(((ProductSizeInfo)sizeProduct22).isSize_enabled() && AppLocal.PRODUCT_SIZE7_ENABLED ? 1 : 0));
                    }
                }
                jsonSizesProduct.put((Map)jSONObject3);
            }
            JSONArray jSONArray6 = new JSONArray();
            sizeProduct22 = productInfoExt.getSupplements().iterator();
            while (sizeProduct22.hasNext()) {
                SupplementProduct supplementProduct = (SupplementProduct)sizeProduct22.next();
                JSONObject jsonSupplementItem = new JSONObject();
                if (oldJsonVersion) {
                    jsonSupplementItem.put((Object)"idSupplement", (Object)supplementProduct.getiD());
                } else {
                    jsonSupplementItem.put((Object)"idSupplement", supplementProduct.getId_global() != null && !supplementProduct.getId_global().isEmpty() ? supplementProduct.getId_global() : Integer.valueOf(supplementProduct.getiD()));
                }
                jsonSupplementItem.put((Object)"free_able", (Object)supplementProduct.isFree_able());
                jsonSupplementItem.put((Object)"separate", (Object)supplementProduct.isSeparate());
                jsonSupplementItem.put((Object)"option_free", (Object)supplementProduct.getOption_free());
                jsonSupplementItem.put((Object)"has_limit_options", (Object)supplementProduct.getHas_options());
                jsonSupplementItem.put((Object)"min_option", (Object)supplementProduct.getMin_options());
                jsonSupplementItem.put((Object)"max_option", (Object)supplementProduct.getMax_options());
                jsonSupplementItem.put((Object)"option_free_size2", (Object)supplementProduct.getOption_free_size2());
                jsonSupplementItem.put((Object)"min_option_size2", (Object)supplementProduct.getMin_options_size2());
                jsonSupplementItem.put((Object)"max_option_size2", (Object)supplementProduct.getMax_options_size2());
                jsonSupplementItem.put((Object)"option_free_size3", (Object)supplementProduct.getOption_free_size3());
                jsonSupplementItem.put((Object)"min_option_size3", (Object)supplementProduct.getMin_options_size3());
                jsonSupplementItem.put((Object)"max_option_size3", (Object)supplementProduct.getMax_options_size3());
                jsonSupplementItem.put((Object)"option_free_size4", (Object)supplementProduct.getOption_free_size4());
                jsonSupplementItem.put((Object)"min_option_size4", (Object)supplementProduct.getMin_options_size4());
                jsonSupplementItem.put((Object)"max_option_size4", (Object)supplementProduct.getMax_options_size4());
                jsonSupplementItem.put((Object)"option_free_size5", (Object)supplementProduct.getOption_free_size5());
                jsonSupplementItem.put((Object)"min_option_size5", (Object)supplementProduct.getMin_options_size5());
                jsonSupplementItem.put((Object)"max_option_size5", (Object)supplementProduct.getMax_options_size5());
                jsonSupplementItem.put((Object)"option_free_size6", (Object)supplementProduct.getOption_free_size6());
                jsonSupplementItem.put((Object)"min_option_size6", (Object)supplementProduct.getMin_options_size6());
                jsonSupplementItem.put((Object)"max_option_size6", (Object)supplementProduct.getMax_options_size6());
                jsonSupplementItem.put((Object)"many_size", (Object)supplementProduct.isMany_size());
                jsonSupplementItem.put((Object)"option_free_size7", (Object)supplementProduct.getOption_free_size7());
                jsonSupplementItem.put((Object)"min_option_size7", (Object)supplementProduct.getMin_options_size7());
                jsonSupplementItem.put((Object)"max_option_size7", (Object)supplementProduct.getMax_options_size7());
                jsonSupplementItem.put((Object)"option_free_size8", (Object)supplementProduct.getOption_free_size8());
                jsonSupplementItem.put((Object)"min_option_size8", (Object)supplementProduct.getMin_options_size8());
                jsonSupplementItem.put((Object)"max_option_size8", (Object)supplementProduct.getMax_options_size8());
                jsonSupplementItem.put((Object)"option_free_size9", (Object)supplementProduct.getOption_free_size9());
                jsonSupplementItem.put((Object)"min_option_size9", (Object)supplementProduct.getMin_options_size9());
                jsonSupplementItem.put((Object)"max_option_size9", (Object)supplementProduct.getMax_options_size9());
                jsonSupplementItem.put((Object)"option_free_size10", (Object)supplementProduct.getOption_free_size10());
                jsonSupplementItem.put((Object)"min_option_size10", (Object)supplementProduct.getMin_options_size10());
                jsonSupplementItem.put((Object)"max_option_size10", (Object)supplementProduct.getMax_options_size10());
                jSONArray6.put((Map)jsonSupplementItem);
            }
            JSONArray jsonAllCarteProduct = new JSONArray();
            for (Object carteProduct2 : productInfoExt.getCartes()) {
                JSONObject jsonCarteProduct = new JSONObject();
                jsonCarteProduct.put((Object)"id_carte", !oldJsonVersion && ((CarteOrderInfo)carteProduct2).getId_global() != null && !((CarteOrderInfo)carteProduct2).getId_global().isEmpty() ? ((CarteOrderInfo)carteProduct2).getId_global() : Integer.valueOf(((CarteOrderInfo)carteProduct2).getId()));
                jsonCarteProduct.put((Object)"name", (Object)((CarteOrderInfo)carteProduct2).getName());
                jsonCarteProduct.put((Object)"number_carte", (Object)((CarteOrderInfo)carteProduct2).getNumber_carte());
                jsonCarteProduct.put((Object)"order_carte", (Object)((CarteOrderInfo)carteProduct2).getOrderCarte());
                jsonAllCarteProduct.put((Map)jsonCarteProduct);
            }
            JSONArray jSONArray7 = new JSONArray();
            carteProduct2 = productInfoExt.getScreens().iterator();
            while (carteProduct2.hasNext()) {
                ScreenProduct screenProduct = (ScreenProduct)carteProduct2.next();
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put((Object)"id", (Object)screenProduct.getId());
                jSONObject4.put((Object)"id_product", (Object)screenProduct.getId_product());
                jSONObject4.put((Object)"id_screen", (Object)screenProduct.getId_screen());
                jSONObject4.put((Object)"name_screen", (Object)screenProduct.getName_screen());
                jSONObject4.put((Object)"number_screen", (Object)screenProduct.getNumber_screen());
                jSONArray7.put((Map)jSONObject4);
            }
            JSONArray jsonAllAdditional = new JSONArray();
            for (ProductInfoExt productInfoExt2 : productInfoExt.getAdditional_sales()) {
                jsonAllAdditional.put(!oldJsonVersion && productInfoExt2.getId_global() != null && !productInfoExt2.getId_global().isEmpty() ? productInfoExt2.getId_global() : Integer.valueOf(productInfoExt2.getID()));
            }
            JSONArray jsonPromotions = new JSONArray();
            for (Object promotion2 : productInfoExt.getPromotions()) {
                JSONObject jSONObject5 = new JSONObject();
                jSONObject5.put((Object)"id", (Object)((PromotionInfo)promotion2).getId());
                jSONObject5.put((Object)"name_promotion", (Object)((PromotionInfo)promotion2).getName_promotion());
                jSONObject5.put((Object)"type_order", (Object)((PromotionInfo)promotion2).getType_order());
                jSONObject5.put((Object)"size_product", (Object)((PromotionInfo)promotion2).getSize_product());
                jSONObject5.put((Object)"quantity", (Object)((PromotionInfo)promotion2).getQuantity());
                jSONObject5.put((Object)"discount", (Object)((PromotionInfo)promotion2).getDiscount());
                jSONObject5.put((Object)"idGlobal", (Object)((PromotionInfo)promotion2).getId_global());
                jsonPromotions.put((Map)jSONObject5);
            }
            JSONArray jSONArray8 = new JSONArray();
            promotion2 = productInfoExt.getSub_products().iterator();
            while (promotion2.hasNext()) {
                ProductInfoExt productInfoExt3 = (ProductInfoExt)promotion2.next();
                JSONObject jsonSubProduct = new JSONObject();
                jsonSubProduct.put((Object)"id_sub_product", !oldJsonVersion && productInfoExt3.getId_global() != null && !productInfoExt3.getId_global().isEmpty() ? productInfoExt3.getId_global() : Integer.valueOf(productInfoExt3.getID()));
                jsonSubProduct.put((Object)"number_exemplary", (Object)productInfoExt3.getNumber_exemplary());
                jSONArray8.put((Map)jsonSubProduct);
            }
            JSONArray jsonDaysOn = new JSONArray();
            for (Object mProductDayOn2 : productInfoExt.getDaysOn()) {
                JSONObject jSONObject6 = new JSONObject();
                jSONObject6.put((Object)"id", (Object)((ProductDayOn)mProductDayOn2).getId());
                jSONObject6.put((Object)"day_of_week", (Object)((ProductDayOn)mProductDayOn2).getDay_of_week());
                jSONObject6.put((Object)"id_product", (Object)((ProductDayOn)mProductDayOn2).getId_product());
                jsonDaysOn.put((Map)jSONObject6);
            }
            JSONArray jSONArray9 = new JSONArray();
            mProductDayOn2 = productInfoExt.getShiftsCProduct().iterator();
            while (mProductDayOn2.hasNext()) {
                ShiftProduct shiftProduct = (ShiftProduct)mProductDayOn2.next();
                JSONObject jsonCategoryShift = new JSONObject();
                jsonCategoryShift.put((Object)"id", (Object)shiftProduct.getId());
                jsonCategoryShift.put((Object)"date_start", (Object)shiftProduct.getDateStart());
                jsonCategoryShift.put((Object)"date_end", (Object)shiftProduct.getDateEnd());
                jsonCategoryShift.put((Object)"id_category", (Object)shiftProduct.getIProduct());
                jSONArray9.put((Map)jsonCategoryShift);
            }
            JSONArray jsonAllSizeProduct = new JSONArray();
            for (Object sizeProduct3 : productInfoExt.getListSizes()) {
                JSONObject jSONObject7 = new JSONObject();
                jSONObject7.put((Object)"id_size", (Object)((ProductSizeInfo)sizeProduct3).getID());
                jSONObject7.put((Object)"name_size", (Object)((ProductSizeInfo)sizeProduct3).getName());
                jSONObject7.put((Object)"label_size", (Object)((ProductSizeInfo)sizeProduct3).getLabel_size());
                jSONObject7.put((Object)"price", (Object)((ProductSizeInfo)sizeProduct3).getPrice());
                jSONObject7.put((Object)"price_sp", (Object)((ProductSizeInfo)sizeProduct3).getPrice_sp());
                jSONObject7.put((Object)"price_emp", (Object)((ProductSizeInfo)sizeProduct3).getPrice_emp());
                jSONObject7.put((Object)"price_lv", (Object)((ProductSizeInfo)sizeProduct3).getPrice_lv());
                jSONObject7.put((Object)"price_bar", (Object)((ProductSizeInfo)sizeProduct3).getPrice_bar());
                jSONObject7.put((Object)"price_terasse", (Object)((ProductSizeInfo)sizeProduct3).getPrice_terasse());
                jSONObject7.put((Object)"price_happy_hour", (Object)((ProductSizeInfo)sizeProduct3).getPrice_happy_hour());
                jSONObject7.put((Object)"price_uber", (Object)((ProductSizeInfo)sizeProduct3).getPrice_uber());
                jSONObject7.put((Object)"price_delivero", (Object)((ProductSizeInfo)sizeProduct3).getPrice_delivero());
                jSONObject7.put((Object)"price_platform", (Object)((ProductSizeInfo)sizeProduct3).getPrice_platform());
                jSONObject7.put((Object)"price_drive", (Object)((ProductSizeInfo)sizeProduct3).getPrice_drive());
                jSONObject7.put((Object)"size_enabled", (Object)((ProductSizeInfo)sizeProduct3).isSize_enabled());
                jSONObject7.put((Object)"tariff", (Object)((ProductSizeInfo)sizeProduct3).getTariff());
                jSONObject7.put((Object)"idGlobal", (Object)((ProductSizeInfo)sizeProduct3).getId_global());
                jsonAllSizeProduct.put((Map)jSONObject7);
            }
            JSONArray jSONArray10 = new JSONArray();
            sizeProduct3 = productInfoExt.getPrices().iterator();
            while (sizeProduct3.hasNext()) {
                ProductPriceInfo productPriceInfo = (ProductPriceInfo)sizeProduct3.next();
                JSONObject jsonProductPrice = new JSONObject();
                jsonProductPrice.put((Object)"id", (Object)productPriceInfo.getId());
                jsonProductPrice.put((Object)"price", (Object)productPriceInfo.getPrice());
                jsonProductPrice.put((Object)"type_order", (Object)productPriceInfo.getType_order());
                jsonProductPrice.put((Object)"tariff", (Object)productPriceInfo.getTariff());
                jsonProductPrice.put((Object)"id_product", oldJsonVersion ? Integer.valueOf(productInfoExt.getID()) : productInfoExt.getId_global());
                jSONArray10.put((Map)jsonProductPrice);
            }
            JSONArray jsonTranslation2 = new JSONArray();
            for (MultiLanguageProduct multiLanguageText : productInfoExt.getMultiLanguageTexts()) {
                JSONObject jsonMultiLangueText2 = new JSONObject();
                jsonMultiLangueText2.put((Object)"langue", (Object)multiLanguageText.getLanguage());
                jsonMultiLangueText2.put((Object)"name", (Object)multiLanguageText.getName());
                jsonMultiLangueText2.put((Object)"description", (Object)multiLanguageText.getDescription());
                jsonMultiLangueText2.put((Object)"description_ubereat", (Object)multiLanguageText.getDescription_platform());
                jsonTranslation2.put((Map)jsonMultiLangueText2);
            }
            jsonItem.put((Object)"translation", (Object)jsonTranslation2);
            jsonItem.put((Object)"ingredients", (Object)jSONArray5);
            jsonItem.put((Object)"options", (Object)jSONArray6);
            jsonItem.put((Object)"carte", (Object)jsonAllCarteProduct);
            jsonItem.put((Object)"sizes", (Object)jsonSizesProduct);
            jsonItem.put((Object)"screens", (Object)jSONArray7);
            jsonItem.put((Object)"additionals", (Object)jsonAllAdditional);
            jsonItem.put((Object)"promotions", (Object)jsonPromotions);
            jsonItem.put((Object)"sub_products", (Object)jSONArray8);
            jsonItem.put((Object)"daysOn", (Object)jsonDaysOn);
            jsonItem.put((Object)"shiftsOn", (Object)jSONArray9);
            jsonItem.put((Object)"allSizes", (Object)jsonAllSizeProduct);
            jsonItem.put((Object)"prices", (Object)jSONArray10);
            JSONObject jSONObject8 = new JSONObject();
            NutritionalInfoProduct nutriInfo = productInfoExt.getNutriValues();
            if (nutriInfo != null) {
                JSONObject energyKcal = new JSONObject();
                energyKcal.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getEnergyKcalValue()));
                energyKcal.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getEnergyKcalDailyPercentage()));
                jSONObject8.put((Object)"energy_kcal", (Object)energyKcal);
                JSONObject fiberG = new JSONObject();
                fiberG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getFiberGValue()));
                fiberG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getFiberGDailyPercentage()));
                jSONObject8.put((Object)"fiber_g", (Object)fiberG);
                JSONObject fatG = new JSONObject();
                fatG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getFatGValue()));
                fatG.put((Object)"saturated_fat_g", (Object)(nutriInfo.getFatSaturatedG() != null ? nutriInfo.getFatSaturatedG() : 0.0));
                fatG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getFatGDailyPercentage()));
                jSONObject8.put((Object)"fat_g", (Object)fatG);
                JSONObject carbsG = new JSONObject();
                carbsG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getCarbsGValue()));
                carbsG.put((Object)"sugar_g", (Object)ResponseObject.safeString(nutriInfo.getSugarG()));
                carbsG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getCarbsGDailyPercentage()));
                jSONObject8.put((Object)"carbs_g", (Object)carbsG);
                JSONObject proteinG = new JSONObject();
                proteinG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getProteinGValue()));
                proteinG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getProteinGDailyPercentage()));
                jSONObject8.put((Object)"protein_g", (Object)proteinG);
                JSONObject saltG = new JSONObject();
                saltG.put((Object)"value", (Object)ResponseObject.safeString(nutriInfo.getSaltGValue()));
                saltG.put((Object)"daily_percentage", (Object)ResponseObject.safeString(nutriInfo.getSaltGDailyPercentage()));
                jSONObject8.put((Object)"salt_g", (Object)saltG);
            }
            jsonItem.put((Object)"nutritional_info", (Object)jSONObject8);
            JSONArray jsonAllergenes = new JSONArray();
            List<Allergene> mlist = productInfoExt.getAllergenes();
            if (mlist != null && !mlist.isEmpty()) {
                for (Allergene allergene : mlist) {
                    jsonAllergenes.put((Object)allergene.getName());
                }
            }
            jsonItem.put((Object)"allergens", (Object)jsonAllergenes);
            jSONArray4.put((Map)jsonItem);
        }
        JSONArray jSONArray11 = new JSONArray();
        for (SupplementInfo supplementInfo : options) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)supplementInfo.getiD());
            jSONObject.put((Object)"name", (Object)supplementInfo.getName());
            jSONObject.put((Object)"has_options", (Object)supplementInfo.getHas_options());
            jSONObject.put((Object)"min_items", (Object)supplementInfo.getMin_options());
            jSONObject.put((Object)"max_items", (Object)supplementInfo.getMax_options());
            jSONObject.put((Object)"is_ingredient", (Object)supplementInfo.getIs_ingredient());
            jSONObject.put((Object)"position", (Object)supplementInfo.getOrderSupplement());
            jSONObject.put((Object)"removed", (Object)supplementInfo.isRemoved());
            jSONObject.put((Object)"color", (Object)supplementInfo.getColor());
            jSONObject.put((Object)"number_click", (Object)supplementInfo.getNumber_click());
            jSONObject.put((Object)"multiple_category", (Object)supplementInfo.isMultiple_category());
            jSONObject.put((Object)"path", (Object)supplementInfo.getPath());
            jSONObject.put((Object)"prepared", (Object)supplementInfo.isPrepared());
            jSONObject.put((Object)"printer", (Object)supplementInfo.getPrinter());
            jSONObject.put((Object)"shift_option", (Object)supplementInfo.getShift_option());
            jSONObject.put((Object)"display_screen_sorti", (Object)supplementInfo.isDisplay_screen_sorti());
            jSONObject.put((Object)"alphabetical_order", (Object)supplementInfo.isOrder_name());
            jSONObject.put((Object)"hidden_borne", (Object)supplementInfo.isHidden_borne());
            jSONObject.put((Object)"order_name", (Object)supplementInfo.isOrder_name());
            jSONObject.put((Object)"removed_by_admin", (Object)supplementInfo.isRemoved_by_admin());
            jSONObject.put((Object)"no_printable", (Object)supplementInfo.isNo_printable());
            jSONObject.put((Object)"is_bold", (Object)supplementInfo.getIsBold());
            jSONObject.put((Object)"hidden_online", (Object)supplementInfo.isHidden_online());
            jSONObject.put((Object)"hidden_ubereat", (Object)supplementInfo.isHidden_ubereat());
            jSONObject.put((Object)"supplement_ubereat", (Object)supplementInfo.isSupplement_ubereat());
            jSONObject.put((Object)"display_free", (Object)supplementInfo.isDisplay_free());
            jSONObject.put((Object)"print_black_background", (Object)supplementInfo.isPrint_black_background());
            jSONObject.put((Object)"idGlobal", (Object)supplementInfo.getId_global());
            JSONArray jSONArray12 = new JSONArray();
            for (SupplementItemInfo supplementItemInfo : supplementInfo.getItems()) {
                Object priceOption2;
                JSONObject jSONObject9 = new JSONObject();
                jSONObject9.put((Object)"id", (Object)supplementItemInfo.getiD());
                jSONObject9.put((Object)"name", (Object)supplementItemInfo.getName());
                jSONObject9.put((Object)"price", (Object)supplementItemInfo.getPrice());
                jSONObject9.put((Object)"price_junior", (Object)supplementItemInfo.getPrice_junior());
                jSONObject9.put((Object)"price_senior", (Object)supplementItemInfo.getPrice_senior());
                jSONObject9.put((Object)"price_mega", (Object)supplementItemInfo.getPrice_mega());
                jSONObject9.put((Object)"price_size1", (Object)supplementItemInfo.getPrice_size1());
                jSONObject9.put((Object)"price_size2", (Object)supplementItemInfo.getPrice_size2());
                jSONObject9.put((Object)"price_size3", (Object)supplementItemInfo.getPrice_size3());
                jSONObject9.put((Object)"removed", (Object)supplementItemInfo.isRemoved());
                jSONObject9.put((Object)"order_item", (Object)supplementItemInfo.getOrderItem());
                jSONObject9.put((Object)"many_size", (Object)supplementItemInfo.isMany_size());
                jSONObject9.put((Object)"path", (Object)supplementItemInfo.getPath());
                jSONObject9.put((Object)"hidden_borne", (Object)supplementItemInfo.isHidden_borne());
                jSONObject9.put((Object)"removed_by_admin", (Object)supplementItemInfo.isRemoved_by_admin());
                jSONObject9.put((Object)"many_type", (Object)supplementItemInfo.isMany_type());
                jSONObject9.put((Object)"hidden", (Object)supplementItemInfo.isHidden());
                jSONObject9.put((Object)"hidden_online", (Object)supplementItemInfo.isHidden_online());
                jSONObject9.put((Object)"price_size4", (Object)supplementItemInfo.getPrice_size4());
                jSONObject9.put((Object)"price_size5", (Object)supplementItemInfo.getPrice_size5());
                jSONObject9.put((Object)"price_size6", (Object)supplementItemInfo.getPrice_size6());
                jSONObject9.put((Object)"price_size7", (Object)supplementItemInfo.getPrice_size7());
                jSONObject9.put((Object)"hidden_ubereat", (Object)supplementItemInfo.isHidden_ubereat());
                jSONObject9.put((Object)"supplement_item_ubereat", (Object)supplementItemInfo.isSupplement_item_ubereat());
                jSONObject9.put((Object)"id_product", (Object)supplementItemInfo.getId_product());
                jSONObject9.put((Object)"sold_out", (Object)supplementItemInfo.isSold_out());
                jSONObject9.put((Object)"hidden_in_kitchen", (Object)supplementItemInfo.isHidden_in_kitchen());
                jSONObject9.put((Object)"rate_taxe", (Object)supplementItemInfo.getRateTaxe());
                jSONObject9.put((Object)"price_already_included", (Object)supplementItemInfo.getPrice_already_included());
                jSONObject9.put((Object)"idGlobal", (Object)supplementItemInfo.getId_global());
                jSONObject9.put((Object)"imageURL", (Object)supplementItemInfo.getImageUrl());
                JSONArray jsonScreensSupplement = new JSONArray();
                for (ScreenSupplementItem screenSupplementItem : supplementItemInfo.getScreen()) {
                    JSONObject jsonScreenSupplement = new JSONObject();
                    jsonScreenSupplement.put((Object)"id", (Object)screenSupplementItem.getId());
                    jsonScreenSupplement.put((Object)"id_supplement", (Object)screenSupplementItem.getId_supplement());
                    jsonScreenSupplement.put((Object)"id_screen", (Object)screenSupplementItem.getId_screen());
                    jsonScreenSupplement.put((Object)"name_screen", (Object)screenSupplementItem.getName_screen());
                    jsonScreensSupplement.put((Map)jsonScreenSupplement);
                }
                JSONArray jSONArray13 = new JSONArray();
                for (Object priceOption2 : supplementItemInfo.getSupplementPrices()) {
                    JSONObject jSONObject10 = new JSONObject();
                    jSONObject10.put((Object)"id_price", (Object)((SupplementPriceInfo)priceOption2).getId());
                    jSONObject10.put((Object)"type_order", (Object)((SupplementPriceInfo)priceOption2).getType_order());
                    jSONObject10.put((Object)"price", (Object)((SupplementPriceInfo)priceOption2).getPrice());
                    jSONObject10.put((Object)"price_junior", (Object)((SupplementPriceInfo)priceOption2).getPrice_junior());
                    jSONObject10.put((Object)"price_senior", (Object)((SupplementPriceInfo)priceOption2).getPrice_senior());
                    jSONObject10.put((Object)"price_mega", (Object)((SupplementPriceInfo)priceOption2).getPrice_mega());
                    jSONObject10.put((Object)"price_size1", (Object)((SupplementPriceInfo)priceOption2).getPrice_size1());
                    jSONObject10.put((Object)"price_size2", (Object)((SupplementPriceInfo)priceOption2).getPrice_size2());
                    jSONObject10.put((Object)"price_size3", (Object)((SupplementPriceInfo)priceOption2).getPrice_size3());
                    jSONObject10.put((Object)"price_size4", (Object)((SupplementPriceInfo)priceOption2).getPrice_size4());
                    jSONObject10.put((Object)"price_size5", (Object)((SupplementPriceInfo)priceOption2).getPrice_size5());
                    jSONObject10.put((Object)"price_size6", (Object)((SupplementPriceInfo)priceOption2).getPrice_size6());
                    jSONObject10.put((Object)"price_size7", (Object)((SupplementPriceInfo)priceOption2).getPrice_size7());
                    jSONObject10.put((Object)"idGlobal", (Object)((SupplementPriceInfo)priceOption2).getId_global());
                    jSONArray13.put((Map)jSONObject10);
                }
                JSONArray jSONArray14 = new JSONArray();
                priceOption2 = supplementItemInfo.getGroupsSubSupplement().iterator();
                while (priceOption2.hasNext()) {
                    GroupSubSupplementInfo groupSubSupplementInfo = (GroupSubSupplementInfo)priceOption2.next();
                    jSONArray14.put(!oldJsonVersion && groupSubSupplementInfo.getId_global() != null && !groupSubSupplementInfo.getId_global().isEmpty() ? groupSubSupplementInfo.getId_global() : Integer.valueOf(groupSubSupplementInfo.getId()));
                }
                jSONObject9.put((Object)"screens", (Object)jsonScreensSupplement);
                jSONObject9.put((Object)"prices", (Object)jSONArray13);
                jSONObject9.put((Object)"color", (Object)supplementItemInfo.getColor());
                jSONObject9.put((Object)"alias_supplement", (Object)supplementItemInfo.getAlias_kitchen());
                jSONObject9.put((Object)"send_color", (Object)supplementItemInfo.isSend_color());
                jSONObject9.put((Object)"flame_enabled", (Object)supplementItemInfo.isFlame_enabled());
                jSONObject9.put((Object)"number_flame", (Object)supplementItemInfo.getNumber_flame());
                jSONObject9.put((Object)"groups_sub_supplement", (Object)jSONArray14);
                JSONObject jsonCompagneDatesOption = new JSONObject();
                jsonCompagneDatesOption.put((Object)"dateDebut", (Object)(supplementItemInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementItemInfo.getDateStartDisplay())));
                jsonCompagneDatesOption.put((Object)"dateFin", (Object)(supplementItemInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementItemInfo.getDateEndDisplay())));
                jSONObject9.put((Object)"campagneDates", (Object)jsonCompagneDatesOption);
                JSONArray jSONArray15 = new JSONArray();
                for (MultiLanguageSupplementItem multiLanguageSupplementItem : supplementItemInfo.getMultiLanguageTexts()) {
                    JSONObject jsonMultiLangueText3 = new JSONObject();
                    jsonMultiLangueText3.put((Object)"langue", (Object)multiLanguageSupplementItem.getLanguage());
                    jsonMultiLangueText3.put((Object)"name", (Object)multiLanguageSupplementItem.getName());
                    jSONArray15.put((Map)jsonMultiLangueText3);
                }
                jSONObject9.put((Object)"translation", (Object)jSONArray15);
                JSONArray jsonAllergenes = new JSONArray();
                List<AllergeneSupplement> list = supplementItemInfo.getAllergenes();
                if (list != null && !list.isEmpty()) {
                    for (AllergeneSupplement allergene : list) {
                        jsonAllergenes.put((Object)allergene.getName());
                    }
                }
                jSONObject9.put((Object)"allergens", (Object)jsonAllergenes);
                jSONArray12.put((Map)jSONObject9);
            }
            JSONArray jsonScreensOption = new JSONArray();
            for (ScreenSupplementInfo screenSupplementInfo : supplementInfo.getScreens()) {
                JSONObject jsonScreenOption = new JSONObject();
                jsonScreenOption.put((Object)"id", (Object)screenSupplementInfo.getId());
                jsonScreenOption.put((Object)"id_supplement", (Object)screenSupplementInfo.getId_supplement());
                jsonScreenOption.put((Object)"id_screen", (Object)screenSupplementInfo.getId_screen());
                jsonScreenOption.put((Object)"name_screen", (Object)screenSupplementInfo.getName_screen());
                jsonScreensOption.put((Map)jsonScreenOption);
            }
            JSONObject jSONObject11 = new JSONObject();
            jSONObject11.put((Object)"dateDebut", (Object)(supplementInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementInfo.getDateStartDisplay())));
            jSONObject11.put((Object)"dateFin", (Object)(supplementInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(supplementInfo.getDateEndDisplay())));
            jSONObject.put((Object)"campagneDates", (Object)jSONObject11);
            jSONObject.put((Object)"items", (Object)jSONArray12);
            jSONObject.put((Object)"screens", (Object)jsonScreensOption);
            JSONArray jSONArray16 = new JSONArray();
            for (MultiLanguageSupplement multiLanguageSupplement : supplementInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject12 = new JSONObject();
                jSONObject12.put((Object)"langue", (Object)multiLanguageSupplement.getLanguage());
                jSONObject12.put((Object)"name", (Object)multiLanguageSupplement.getName());
                jSONArray16.put((Map)jSONObject12);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray16);
            jSONArray11.put((Map)jSONObject);
        }
        JSONArray jSONArray17 = new JSONArray();
        for (CarteInfo carteInfo : cartes) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)carteInfo.getId());
            jSONObject.put((Object)"name", (Object)carteInfo.getName());
            jSONObject.put((Object)"size_carte", (Object)carteInfo.getSizeCarte());
            jSONObject.put((Object)"removed", (Object)true);
            jSONObject.put((Object)"removed_by_admin", (Object)true);
            jSONObject.put((Object)"idGlobal", (Object)carteInfo.getId_global());
            JSONArray jsonCarteItems = new JSONArray();
            for (CarteItemInfo carteItemInfo : carteInfo.getCarteItems()) {
                JSONObject jsonCarteItem = new JSONObject();
                jsonCarteItem.put((Object)"id_carte", !oldJsonVersion && carteInfo.getId_global() != null && !carteInfo.getId_global().isEmpty() ? carteInfo.getId_global() : Integer.valueOf(carteItemInfo.getId_carte()));
                jsonCarteItem.put((Object)"id_item", !oldJsonVersion && carteItemInfo.getId_global_item() != null && !carteItemInfo.getId_global_item().isEmpty() ? carteItemInfo.getId_global_item() : Integer.valueOf(carteItemInfo.getId_item()));
                jsonCarteItem.put((Object)"price", (Object)carteItemInfo.getPrice());
                jsonCarteItems.put((Map)jsonCarteItem);
            }
            jSONObject.put((Object)"items", (Object)jsonCarteItems);
            JSONArray jSONArray18 = new JSONArray();
            for (MultiLanguageCarte multiLanguageText : carteInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject13 = new JSONObject();
                jSONObject13.put((Object)"langue", (Object)multiLanguageText.getLanguage());
                jSONObject13.put((Object)"name", (Object)multiLanguageText.getName());
                jSONArray18.put((Map)jSONObject13);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray18);
            jSONArray17.put((Map)jSONObject);
        }
        JSONArray jSONArray19 = new JSONArray();
        for (GroupSubSupplementInfo groupSubSupplementInfo : groupsSubSupplements) {
            JSONObject jsonGroupSubOption = new JSONObject();
            jsonGroupSubOption.put((Object)"id", (Object)groupSubSupplementInfo.getId());
            jsonGroupSubOption.put((Object)"name_group", (Object)groupSubSupplementInfo.getName_group());
            jsonGroupSubOption.put((Object)"title_group", (Object)groupSubSupplementInfo.getTitle_group());
            jsonGroupSubOption.put((Object)"removed", (Object)groupSubSupplementInfo.isRemoved());
            jsonGroupSubOption.put((Object)"option_free", (Object)groupSubSupplementInfo.getOption_free());
            jsonGroupSubOption.put((Object)"has_limit_options", (Object)groupSubSupplementInfo.isHas_limit_options());
            jsonGroupSubOption.put((Object)"min_option", (Object)groupSubSupplementInfo.getMin_options());
            jsonGroupSubOption.put((Object)"max_option", (Object)groupSubSupplementInfo.getMax_options());
            jsonGroupSubOption.put((Object)"idGlobal", (Object)groupSubSupplementInfo.getId_global());
            jsonGroupSubOption.put((Object)"number_click", (Object)groupSubSupplementInfo.getNumber_click());
            JSONArray jSONArray20 = new JSONArray();
            for (SupplementItemInfo subSupplement : groupSubSupplementInfo.getSupplements()) {
                jSONArray20.put(!oldJsonVersion && subSupplement.getId_global() != null && !subSupplement.getId_global().isEmpty() ? subSupplement.getId_global() : Integer.valueOf(subSupplement.getiD()));
            }
            jsonGroupSubOption.put((Object)"sub_supplements", (Object)jSONArray20);
            JSONArray jSONArray21 = new JSONArray();
            for (MultiLanguageGSS multiLanguageGSS : groupSubSupplementInfo.getMultiLanguageTexts()) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"langue", (Object)multiLanguageGSS.getLanguage());
                jSONObject.put((Object)"name", (Object)multiLanguageGSS.getName());
                jSONObject.put((Object)"title_group", (Object)multiLanguageGSS.getTitle_group());
                jSONArray21.put((Map)jSONObject);
            }
            jsonGroupSubOption.put((Object)"translation", (Object)jSONArray21);
            jSONArray19.put((Map)jsonGroupSubOption);
        }
        JSONArray jSONArray22 = new JSONArray();
        for (PromotionInfo promotion : promotions) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id", (Object)promotion.getId());
            jSONObject.put((Object)"name_promotion", (Object)promotion.getName_promotion());
            jSONObject.put((Object)"type_order", (Object)promotion.getType_order());
            jSONObject.put((Object)"size_product", (Object)promotion.getSize_product());
            jSONObject.put((Object)"quantity", (Object)promotion.getQuantity());
            jSONObject.put((Object)"discount", (Object)promotion.getDiscount());
            jSONObject.put((Object)"removed", (Object)true);
            jSONObject.put((Object)"removed_by_admin", (Object)true);
            jSONObject.put((Object)"label_size_product", (Object)promotion.getLabel_size_product());
            jSONObject.put((Object)"label_discount", (Object)promotion.getLabel_discount());
            jSONObject.put((Object)"idGlobal", (Object)promotion.getId_global());
            jSONObject.put((Object)"description", (Object)promotion.getDescription());
            jSONObject.put((Object)"text_promo", (Object)promotion.getText_promo());
            JSONArray jSONArray23 = new JSONArray();
            for (MultiLanguagePromotion multiLanguagePromotion : promotion.getMultiLanguageTexts()) {
                JSONObject jSONObject14 = new JSONObject();
                jSONObject14.put((Object)"langue", (Object)multiLanguagePromotion.getLanguage());
                jSONObject14.put((Object)"name", (Object)multiLanguagePromotion.getName());
                jSONObject14.put((Object)"description", (Object)multiLanguagePromotion.getDescription());
                jSONObject14.put((Object)"text_promo", (Object)multiLanguagePromotion.getText_promo());
                jSONArray23.put((Map)jSONObject14);
            }
            jSONObject.put((Object)"translation", (Object)jSONArray23);
            jSONArray22.put((Map)jSONObject);
        }
        JSONArray jSONArray24 = new JSONArray();
        if (languages != null) {
            for (LanguageInfo languageInfo : languages) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)"code", (Object)languageInfo.getCode_language());
                jSONObject.put((Object)"label", (Object)languageInfo.getLabel_language());
                jSONObject.put((Object)"isActive", (Object)languageInfo.isEnabled());
                jSONObject.put((Object)"isDefault", (Object)languageInfo.isDefault_language());
                jSONArray24.put((Map)jSONObject);
            }
        }
        jsonRoot.put((Object)"categories", (Object)jSONArray3);
        jsonRoot.put((Object)"items", (Object)jSONArray4);
        jsonRoot.put((Object)"options", (Object)jSONArray11);
        jsonRoot.put((Object)"cartes", (Object)jSONArray17);
        jsonRoot.put((Object)"printers", (Object)jSONArray2);
        jsonRoot.put((Object)"groups_sub_options", (Object)jSONArray19);
        jsonRoot.put((Object)"promotions", (Object)jSONArray22);
        jsonRoot.put((Object)"screens", (Object)jsonAllScreens);
        jsonRoot.put((Object)"tags", (Object)jSONArray);
        jsonRoot.put((Object)"listeLanguages", (Object)jSONArray24);
        jsonRoot.put((Object)"zones", (Object)jsonAllZones);
        return jsonRoot;
    }

    private static JSONObject getJsonCategoryOld(CategoryInfo categoryInfo, boolean oldJsonVersion) {
        JSONObject jsonCategory = new JSONObject();
        jsonCategory.put((Object)"idCat", (Object)categoryInfo.getID());
        jsonCategory.put((Object)"name", (Object)categoryInfo.getName());
        jsonCategory.put((Object)"position", (Object)categoryInfo.getOrdercategory());
        jsonCategory.put((Object)"removed", (Object)true);
        jsonCategory.put((Object)"hidden", (Object)categoryInfo.isHidden());
        jsonCategory.put((Object)"color", (Object)categoryInfo.getColor());
        jsonCategory.put((Object)"apply_discount", (Object)categoryInfo.isApply_discount());
        jsonCategory.put((Object)"path", (Object)categoryInfo.getPath());
        jsonCategory.put((Object)"hidden_borne", (Object)categoryInfo.isHidden_borne());
        if (oldJsonVersion) {
            jsonCategory.put((Object)"parent_id", (Object)categoryInfo.getParent_id());
        } else {
            jsonCategory.put((Object)"parent_id", categoryInfo.getParent_id_global() != null ? categoryInfo.getParent_id_global() : Integer.valueOf(categoryInfo.getParent_id()));
        }
        jsonCategory.put((Object)"moment_category", (Object)categoryInfo.isMoment_category());
        jsonCategory.put((Object)"removed_by_admin", (Object)true);
        jsonCategory.put((Object)"sold_out", (Object)categoryInfo.isSold_out());
        jsonCategory.put((Object)"products_first", (Object)categoryInfo.isProducts_first());
        jsonCategory.put((Object)"next_available", (Object)categoryInfo.isNext_available());
        jsonCategory.put((Object)"display_time", (Object)categoryInfo.isHas_display_time());
        jsonCategory.put((Object)"first_period", (Object)categoryInfo.getFirst_period());
        jsonCategory.put((Object)"end_period", (Object)categoryInfo.getEnd_period());
        jsonCategory.put((Object)"available_caisse", (Object)categoryInfo.isAvailable_caisse());
        jsonCategory.put((Object)"has_sub_categories", (Object)(!categoryInfo.getSub_categories().isEmpty() ? 1 : 0));
        jsonCategory.put((Object)"hide_name_in_borne", (Object)categoryInfo.isHide_name_in_borne());
        jsonCategory.put((Object)"hidden_online", (Object)categoryInfo.isHidden_online());
        jsonCategory.put((Object)"hidden_ubereat", (Object)categoryInfo.isHidden_ubereat());
        jsonCategory.put((Object)"category_ubereat", (Object)categoryInfo.isCategory_ubereat());
        jsonCategory.put((Object)"offset_print_kitchen", (Object)categoryInfo.getOffset_print_kitchen());
        jsonCategory.put((Object)"path_category_moment", (Object)categoryInfo.getPath_category_moment());
        jsonCategory.put((Object)"type_image_category_moment", (Object)categoryInfo.getType_image_category_moment());
        jsonCategory.put((Object)"has_timetable", (Object)categoryInfo.isHas_timetable());
        JSONArray jsonTagsCatgory = new JSONArray();
        jsonCategory.put((Object)"idGlobal", (Object)categoryInfo.getId_global());
        for (TagInfo tagInfo : categoryInfo.getTags()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"id_category", (Object)categoryInfo.getID());
            jSONObject.put((Object)"id_tag", (Object)tagInfo.getId());
            jSONObject.put((Object)"name_tag", (Object)tagInfo.getName());
            jSONObject.put((Object)"number_tag", (Object)tagInfo.getNumber());
            jSONObject.put((Object)"logo_tag", (Object)tagInfo.getLogo_tag());
            jSONObject.put((Object)"background_catalog", (Object)tagInfo.getBackground_catalog());
            jSONObject.put((Object)"enabled", (Object)tagInfo.isEnabled());
            jSONObject.put((Object)"closed", (Object)tagInfo.isClosed());
            jsonTagsCatgory.put((Map)jSONObject);
        }
        JSONArray jsonDaysOnCat = new JSONArray();
        for (CategoryDayAvailable categoryDayAvailable : categoryInfo.getDaysOn()) {
            JSONObject jsonCategoryDayOn = new JSONObject();
            jsonCategoryDayOn.put((Object)"id", (Object)categoryDayAvailable.getId());
            jsonCategoryDayOn.put((Object)"day_of_week", (Object)categoryDayAvailable.getDayOfWeek());
            jsonCategoryDayOn.put((Object)"id_category", (Object)categoryDayAvailable.getCategoryId());
            jsonDaysOnCat.put((Map)jsonCategoryDayOn);
        }
        JSONArray jSONArray = new JSONArray();
        for (ShiftCategory mShiftCategory : categoryInfo.getShiftsCategory()) {
            JSONObject jsonCategoryShift = new JSONObject();
            jsonCategoryShift.put((Object)"id", (Object)mShiftCategory.getId());
            jsonCategoryShift.put((Object)"date_start", (Object)mShiftCategory.getDateStart());
            jsonCategoryShift.put((Object)"date_end", (Object)mShiftCategory.getDateEnd());
            jsonCategoryShift.put((Object)"id_category", (Object)mShiftCategory.getICategory());
            jSONArray.put((Map)jsonCategoryShift);
        }
        jsonCategory.put((Object)"tags", (Object)jsonTagsCatgory);
        jsonCategory.put((Object)"daysOn", (Object)jsonDaysOnCat);
        jsonCategory.put((Object)"shiftsOn", (Object)jSONArray);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"dateDebut", (Object)(categoryInfo.getDateStartDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(categoryInfo.getDateStartDisplay())));
        jSONObject.put((Object)"dateFin", (Object)(categoryInfo.getDateEndDisplay() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(categoryInfo.getDateEndDisplay())));
        jsonCategory.put((Object)"campagneDates", (Object)jSONObject);
        jsonCategory.put((Object)"imageURL", (Object)categoryInfo.getImageUrl());
        JSONArray jsonTranslation = new JSONArray();
        for (MultiLanguageCategory multiLanguageText : categoryInfo.getMultiLanguageTexts()) {
            JSONObject jsonMultiLangueText = new JSONObject();
            jsonMultiLangueText.put((Object)"langue", (Object)multiLanguageText.getLanguage());
            jsonMultiLangueText.put((Object)"name", (Object)multiLanguageText.getName());
            jsonTranslation.put((Map)jsonMultiLangueText);
        }
        jsonCategory.put((Object)"translation", (Object)jsonTranslation);
        return jsonCategory;
    }

    private static SupplementItemInfo getDetailIngredientById(List<SupplementItemInfo> ingredients, int id_supplement_item) {
        SupplementItemInfo supplementItemInfo = null;
        if (ingredients != null) {
            for (SupplementItemInfo ingredient : ingredients) {
                if (ingredient.getiD() != id_supplement_item) continue;
                supplementItemInfo = ingredient;
                break;
            }
        }
        return supplementItemInfo;
    }

    private static String safeString(Double value) {
        return value != null ? String.valueOf(value) : "0";
    }
}

