/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.parser;

import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.ItemLine;
import com.openbravo.pos.ticket.LineKitchen;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketKitchen;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.UserInfo;
import fr.protactile.kitchen.dao.entities.Itemsticket;
import fr.protactile.kitchen.dao.entities.Optionsticket;
import fr.protactile.kitchen.dao.entities.Ticketlines;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OrdersParser {
    public static List<TicketKitchen> parseOrders(JSONObject obj) {
        JSONObject dataOrders = obj.getJSONObject("orders");
        ArrayList<TicketKitchen> orders = new ArrayList<TicketKitchen>();
        Iterator iterator = dataOrders.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JSONObject objOrder = dataOrders.getJSONObject(key);
            int idTicket = objOrder.getInt("id");
            String typeOrder = null;
            Object objType = objOrder.get("type_order");
            if (objType != null && !objType.toString().equals("null")) {
                typeOrder = objType.toString();
            }
            int num_order = objOrder.getInt("num_order");
            int num_table = objOrder.getInt("num_table");
            long time_order = objOrder.getLong("date");
            long date_order = objOrder.getLong("date_created");
            int bipper = objOrder.getInt("bipper");
            int couverts = objOrder.getInt("couverts");
            boolean finished_order = objOrder.getBoolean("finished");
            String status_order = null;
            Object objStatus = objOrder.get("status");
            if (objStatus != null && !objStatus.toString().equals("null")) {
                status_order = objStatus.toString();
            }
            String caisse = null;
            Object objCaisse = objOrder.get("caisse");
            if (objCaisse != null && !objCaisse.toString().equals("null")) {
                caisse = objCaisse.toString();
            }
            TicketKitchen ticket = new TicketKitchen(idTicket, 0.0, typeOrder, new Date(), caisse, num_order, num_table, bipper, couverts, finished_order);
            ticket.setStatus(status_order);
            ticket.setTime_order(time_order);
            ticket.setDate_created(new Date(date_order));
            JSONArray arrayLines = objOrder.getJSONArray("lines");
            for (int i = 0; i < arrayLines.length(); ++i) {
                Object objIngredientInclus;
                Object objIngredient;
                Object objSupplement;
                Object objSize;
                Object objNote;
                Object objStatusLine;
                Object objTime_served;
                Object objAfterSeparator;
                Object objPlace_served;
                JSONObject objLine = arrayLines.getJSONObject(i);
                int idLine = objLine.getInt("id");
                int numLine = objLine.getInt("numLine");
                String lineProduct = objLine.getString("product");
                double unit = objLine.getDouble("unit");
                String note = null;
                String size_product = null;
                boolean finished_line = objLine.getBoolean("finished");
                boolean label = objLine.getBoolean("label");
                String supplements = null;
                String ingredients = null;
                String status_line = null;
                String place_served = null;
                String time_served = null;
                String ingredientsInclus = null;
                String afterSeparator = null;
                if (objLine.has("place_served") && (objPlace_served = objLine.get("place_served")) != null && !objPlace_served.toString().equals("null")) {
                    place_served = objPlace_served.toString();
                }
                if (objLine.has("afterSeparator") && (objAfterSeparator = objLine.get("afterSeparator")) != null && !objAfterSeparator.toString().equals("null")) {
                    afterSeparator = objAfterSeparator.toString();
                }
                if (objLine.has("time_served") && (objTime_served = objLine.get("time_served")) != null && !objTime_served.toString().equals("null")) {
                    time_served = objTime_served.toString();
                }
                if ((objStatusLine = objLine.get("status_line")) != null && !objStatusLine.toString().equals("null")) {
                    status_line = objStatusLine.toString();
                }
                if ((objNote = objLine.get("note")) != null && !objNote.toString().equals("null")) {
                    note = objNote.toString();
                }
                if ((objSize = objLine.get("size_product")) != null && !objSize.toString().equals("null")) {
                    size_product = objSize.toString();
                }
                if ((objSupplement = objLine.get("supplements")) != null && !objSupplement.toString().equals("null")) {
                    supplements = objSupplement.toString();
                }
                if ((objIngredient = objLine.get("ingredients")) != null && !objIngredient.toString().equals("null")) {
                    ingredients = objIngredient.toString();
                }
                if (objLine.has("ingredientsInclus") && (objIngredientInclus = objLine.get("ingredientsInclus")) != null && !objIngredientInclus.toString().equals("null")) {
                    ingredientsInclus = objIngredientInclus.toString();
                }
                LineKitchen line = new LineKitchen(idLine, ticket.getId(), lineProduct, unit, note, size_product, finished_line, supplements, ingredients, ingredientsInclus);
                line.setStatus(status_line);
                line.setPlace_served(place_served);
                line.setTime_served(time_served);
                line.setNumero_line(numLine);
                line.setLabel(label);
                line.setAfterSeparator(afterSeparator);
                line.setPrint_warning(objLine.getBoolean("print_warning"));
                JSONArray arrayItems = objLine.getJSONArray("items");
                for (int j = 0; j < arrayItems.length(); ++j) {
                    Object objIngredientItem;
                    Object objSupplementItem;
                    if (arrayItems.isNull(i)) continue;
                    JSONObject objItem = arrayItems.getJSONObject(i);
                    int idItem = objItem.getInt("id");
                    String itemProduct = objItem.getString("product");
                    double unit_item = objItem.getDouble("unit");
                    String size_product_item = null;
                    String supplements_item = null;
                    String ingredients_item = null;
                    Object objSizeItem = objItem.get("size_product");
                    if (objSizeItem != null && !objSizeItem.toString().equals("null")) {
                        size_product_item = objSizeItem.toString();
                    }
                    if ((objSupplementItem = objItem.get("supplements")) != null && !objSupplementItem.toString().equals("null")) {
                        supplements_item = objSupplementItem.toString();
                    }
                    if ((objIngredientItem = objItem.get("ingredients")) != null && !objIngredientItem.toString().equals("null")) {
                        ingredients_item = objIngredientItem.toString();
                    }
                    ItemLine item = new ItemLine(idItem, line.getId(), itemProduct, unit_item, size_product_item, supplements_item, ingredients_item);
                    line.getItems().add(item);
                }
                ticket.getLines().add(line);
            }
            orders.add(ticket);
        }
        return orders;
    }

    public static Tickets parseTicket(JSONObject objOrder) {
        Tickets order = null;
        try {
            long date_order = objOrder.getLong("date_created");
            String typeOrder = null;
            Object objType = objOrder.get("type_order");
            if (objType != null && !objType.toString().equals("null")) {
                typeOrder = objType.toString();
            }
            String source_order = null;
            Object objSource = objOrder.get("source_order");
            if (objSource != null && !objSource.toString().equals("null")) {
                source_order = objSource.toString();
            }
            String num_local = null;
            Object objNumLocal = objOrder.get("numero_local");
            if (objNumLocal != null && !objNumLocal.toString().equals("null")) {
                num_local = objNumLocal.toString();
            }
            String host_name = null;
            Object objHostName = objOrder.get("host_name");
            if (objHostName != null && !objHostName.toString().equals("null")) {
                host_name = objHostName.toString();
            }
            String bar_code = null;
            Object objBarCode = objOrder.get("bar_code");
            if (objBarCode != null && !objBarCode.toString().equals("null")) {
                bar_code = objBarCode.toString();
            }
            String user_id = null;
            Object objUserId = objOrder.get("user_id");
            if (objUserId != null && !objUserId.toString().equals("null")) {
                user_id = objUserId.toString();
            }
            double total = objOrder.getDouble("total");
            int id_order = objOrder.getInt("id");
            String type_discount = null;
            Object objTypeDiscount = objOrder.get("discount_type");
            if (objTypeDiscount != null && !objTypeDiscount.toString().equals("null")) {
                type_discount = objTypeDiscount.toString();
            }
            int num_table = objOrder.getInt("num_table");
            int couvert = objOrder.getInt("couvert");
            double discount = objOrder.getDouble("discount");
            String name_user = objOrder.isNull("user_name") ? null : objOrder.getString("user_name");
            order = new Tickets(id_order, objOrder.getInt("num_order"), total, typeOrder, host_name, source_order, num_local, new Date(), bar_code, user_id, 0, discount, type_discount, 0, 0, null, name_user, num_table, couvert);
            ArrayList<Ticketlines> lines = new ArrayList<Ticketlines>();
            JSONArray arrayLines = objOrder.getJSONArray("lines");
            for (int i = 0; i < arrayLines.length(); ++i) {
                JSONObject objLine = arrayLines.getJSONObject(i);
                int id_line = objLine.getInt("id");
                if (!objLine.isNull("next")) {
                    Ticketlines ticketLine = new Ticketlines(id_line);
                    ticketLine.setNext_line(true);
                    ticketLine.setDefaultInfo();
                    ArrayList<Optionsticket> options = new ArrayList<Optionsticket>();
                    ticketLine.setOptionsticketCollection(options);
                    ArrayList<Itemsticket> items = new ArrayList<Itemsticket>();
                    ticketLine.setItemsticketCollection(items);
                    lines.add(ticketLine);
                    continue;
                }
                if (objLine.isNull("ref_product")) continue;
                double quantity = objLine.getInt("quantity");
                String ref_product = null;
                Object ojbrefPorduct = objLine.get("ref_product");
                if (ojbrefPorduct != null && !ojbrefPorduct.toString().equals("null")) {
                    ref_product = ojbrefPorduct.toString();
                }
                Ticketlines ticketLine = new Ticketlines(id_line, ref_product, quantity);
                JSONArray arrayOptions = objLine.getJSONArray("options");
                ArrayList<Optionsticket> options = new ArrayList<Optionsticket>();
                for (int j = 0; j < arrayOptions.length(); ++j) {
                    JSONObject objOption = arrayOptions.getJSONObject(j);
                    int number_option = objOption.getInt("number_option");
                    int number_free = objOption.getInt("number_free");
                    boolean isIngredient = objOption.getBoolean("isIngredient");
                    int id_option = objOption.getInt("id");
                    String ref_option = null;
                    Object ojbRefOption = objOption.get("ref_option");
                    if (ojbRefOption != null && !ojbRefOption.toString().equals("null")) {
                        ref_option = ojbRefOption.toString();
                    }
                    options.add(new Optionsticket(id_option, isIngredient, ref_option, number_option, number_free));
                }
                ticketLine.setOptionsticketCollection(options);
                JSONArray arrayItems = objLine.getJSONArray("items");
                ArrayList<Itemsticket> items = new ArrayList<Itemsticket>();
                for (int j = 0; j < arrayItems.length(); ++j) {
                    JSONObject objItem = arrayItems.getJSONObject(j);
                    int number_option = objItem.getInt("number_product");
                    int id_item = objItem.getInt("id");
                    String ref_item = null;
                    Object ojbRefItem = objItem.get("ref_item");
                    if (ojbRefItem != null && !ojbRefItem.toString().equals("null")) {
                        ref_item = ojbRefItem.toString();
                    }
                    String ref_carte = null;
                    Object ojbRefCarte = objItem.get("ref_carte");
                    if (ojbRefCarte != null && !ojbRefCarte.toString().equals("null")) {
                        ref_carte = ojbRefCarte.toString();
                    }
                    items.add(new Itemsticket(id_item, ref_carte, ref_item, number_option));
                }
                ticketLine.setItemsticketCollection(items);
                lines.add(ticketLine);
            }
            order.setTicketlinesCollection(lines);
        }
        catch (Exception jSONException) {
            jSONException.printStackTrace();
        }
        return order;
    }

    public static Tickets parseTicket(String request) {
        JSONTokener tokener = new JSONTokener(request);
        JSONObject objOrder = new JSONObject(tokener);
        return OrdersParser.parseTicket(objOrder);
    }

    public static List<Tickets> parseTickets(String request) {
        ArrayList<Tickets> tickets = new ArrayList<Tickets>();
        JSONTokener tokener = new JSONTokener(request);
        JSONObject objOrders = new JSONObject(tokener);
        JSONObject dataOrders = objOrders.getJSONObject("orders");
        Iterator iterator = dataOrders.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JSONObject objOrder = dataOrders.getJSONObject(key);
            Tickets ticket = OrdersParser.parseTicket(objOrder);
            if (ticket == null) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    public static TicketInfo jsonToTicket(JSONObject jsonTicket) {
        TicketInfo ticket = new TicketInfo();
        ticket.setPaid(jsonTicket.isNull("paid") ? false : jsonTicket.getBoolean("paid"));
        ticket.setTotal(jsonTicket.isNull("orderTotal") ? 0.0 : jsonTicket.getDouble("orderTotal"));
        ticket.setNum_order_kitchen(jsonTicket.isNull("num_order_kitchen") ? 0 : jsonTicket.getInt("num_order_kitchen"));
        ticket.setNumero_order(jsonTicket.isNull("numero_order") ? 0 : jsonTicket.getInt("numero_order"));
        ticket.setNum_table(jsonTicket.isNull("table_order") ? 0 : jsonTicket.getInt("table_order"));
        if (!jsonTicket.isNull("customer")) {
            CustomerInfo customer = new CustomerInfo();
            JSONObject jsonCustomer = jsonTicket.getJSONObject("customer");
            customer.setName(jsonCustomer.isNull("name_customer") ? null : jsonCustomer.getString("name_customer"));
            customer.setPhone(jsonCustomer.isNull("phone_customer") ? null : jsonCustomer.getString("phone_customer"));
            ticket.setCustomer(customer);
        }
        if (!jsonTicket.isNull("user")) {
            JSONObject jsonUser = jsonTicket.getJSONObject("user");
            String name_user = jsonUser.isNull("name_user") ? null : jsonUser.getString("name_user");
            String id_user = jsonUser.isNull("id_user") ? null : jsonUser.getString("id_user");
            UserInfo user = new UserInfo(id_user, name_user);
            ticket.setUser(user);
        }
        ticket.setDate(jsonTicket.isNull("date_created") ? new Date() : new Date(jsonTicket.getLong("date_created")));
        ticket.setDatePaid(jsonTicket.isNull("date_paid") ? new Date() : new Date(jsonTicket.getLong("date_paid")));
        if (!jsonTicket.isNull("items")) {
            JSONArray items = jsonTicket.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                int j;
                JSONObject itemObject = items.getJSONObject(i);
                TicketLineInfo line = new TicketLineInfo();
                line.setPrice(itemObject.isNull("price") ? 0.0 : itemObject.getDouble("price"));
                line.setMultiply(itemObject.isNull("quantity") ? 0.0 : itemObject.getDouble("quantity"));
                line.setNameProduct(itemObject.isNull("name_product") ? null : itemObject.getString("name_product"));
                line.setSizeProduct(itemObject.isNull("size_line_order") ? null : itemObject.getString("size_line_order"));
                line.setDiscount(itemObject.isNull("discount") ? 0.0 : itemObject.getDouble("discount"));
                line.setType_discount(itemObject.isNull("type_discount") ? null : itemObject.getString("type_discount"));
                line.setLabelDiscount(itemObject.isNull("label_discount") ? null : itemObject.getString("label_discount"));
                line.setPromo_product(itemObject.isNull("promo_product") ? false : itemObject.getBoolean("promo_product"));
                line.setTva_global_no_applicable(itemObject.isNull("tva_global_no_applicable") ? false : itemObject.getBoolean("tva_global_no_applicable"));
                if (!itemObject.isNull("modifiers")) {
                    JSONArray modifiers = itemObject.getJSONArray("modifiers");
                    for (j = 0; j < modifiers.length(); ++j) {
                        JSONObject modifierObject = modifiers.getJSONObject(j);
                        OptionItemOrder option = new OptionItemOrder();
                        option.setIdProduct(modifierObject.isNull("id_product") ? -1 : modifierObject.getInt("id_product"));
                        option.setIdCarte(modifierObject.isNull("id_carte") ? -1 : modifierObject.getInt("id_carte"));
                        option.setIndex_carte(modifierObject.isNull("index_carte") ? -1 : modifierObject.getInt("index_carte"));
                        option.setDisplay_free(modifierObject.isNull("display_free") ? false : modifierObject.getBoolean("display_free"));
                        option.setNumberOption(modifierObject.isNull("quantity") ? 0 : modifierObject.getInt("quantity"));
                        option.setNumber_free(modifierObject.isNull("number_free") ? 0 : modifierObject.getInt("number_free"));
                        double price_total = modifierObject.isNull("price") ? 0.0 : modifierObject.getDouble("price");
                        option.setPrice_already_included(modifierObject.isNull("price_already_included") ? 0.0 : modifierObject.getDouble("price_already_included"));
                        double quantity = option.getNumberOption() - option.getNumber_free();
                        double unit_price = quantity != 0.0 ? price_total / quantity : 0.0;
                        option.setPrice(unit_price, quantity);
                        option.setNameSupplement(modifierObject.isNull("name_supplement") ? null : modifierObject.getString("name_supplement"));
                        if (line.getListSupplements() == null) {
                            line.setListSupplements(new ArrayList<OptionItemOrder>());
                        }
                        line.getListSupplements().add(option);
                    }
                }
                if (!itemObject.isNull("sub_items")) {
                    JSONArray subItems = itemObject.getJSONArray("sub_items");
                    for (j = 0; j < subItems.length(); ++j) {
                        JSONObject subItemObject = subItems.getJSONObject(j);
                        ProductTicket productTicket = new ProductTicket();
                        productTicket.setIdProduct(subItemObject.isNull("id_product") ? -1 : subItemObject.getInt("id_product"));
                        productTicket.setIdCarte(subItemObject.isNull("id_carte") ? -1 : subItemObject.getInt("id_carte"));
                        productTicket.setIndex_carte(subItemObject.isNull("index_carte") ? -1 : subItemObject.getInt("index_carte"));
                        productTicket.setPriceProduct(subItemObject.isNull("price") ? 0.0 : subItemObject.getDouble("price"));
                        productTicket.setNumberProduct(subItemObject.isNull("quantity") ? 0 : subItemObject.getInt("quantity"));
                        productTicket.setNameProduct(subItemObject.isNull("name_sub_items") ? null : subItemObject.getString("name_sub_items"));
                        if (line.getListProducts() == null) {
                            line.setListProducts(new ArrayList<ProductTicket>());
                        }
                        line.getListProducts().add(productTicket);
                    }
                }
                ticket.getLines().add(line);
            }
        }
        ticket.setDiscount(jsonTicket.isNull("discount") ? 0.0 : jsonTicket.getDouble("discount"));
        ticket.setTypeDiscount(jsonTicket.isNull("type_discount") ? "pourcentage" : jsonTicket.getString("type_discount"));
        if (!jsonTicket.isNull("payments")) {
            JSONArray payments = jsonTicket.getJSONArray("payments");
            for (int i = 0; i < payments.length(); ++i) {
                JSONObject paymentObject = payments.getJSONObject(i);
                PaymentInfo payment = new PaymentInfo();
                payment.setTotal(paymentObject.isNull("total_payment") ? 0.0 : paymentObject.getDouble("total_payment"));
                payment.setM_dTendered(paymentObject.isNull("tendered") ? 0.0 : paymentObject.getDouble("tendered"));
                payment.setNamePayment(paymentObject.isNull("name_payment") ? null : paymentObject.getString("name_payment"));
                ticket.getPayments().add(payment);
            }
        }
        return ticket;
    }

    public static JSONObject ticketToJson(TicketInfo ticket) {
        JSONObject jsonTicket = new JSONObject();
        jsonTicket.put("paid", ticket.isPaid());
        jsonTicket.put("orderTotal", ticket.getTotalOrder());
        jsonTicket.put("num_order_kitchen", ticket.getNum_order_kitchen());
        jsonTicket.put("numero_order", (Object)ticket.getNumberOrder());
        jsonTicket.put("table_order", ticket.getNumTable());
        if (ticket.getCustomer() != null || ticket.getName_customer() != null && !ticket.getName_customer().isEmpty()) {
            JSONObject jsonCustomer = new JSONObject();
            Object nameCustomer = null;
            nameCustomer = ticket.getCustomer() == null && ticket.getName_customer() != null && !ticket.getName_customer().isEmpty() ? ticket.getName_customer() : ticket.getCustomer().getName();
            jsonCustomer.put("name_customer", nameCustomer);
            jsonCustomer.put("phone_customer", ticket.getCustomer() != null ? ticket.getCustomer().getPhone() : null);
            jsonTicket.put("customer", (Object)jsonCustomer);
        }
        if (ticket.getUser() != null) {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put("name_user", (Object)ticket.getUser().getName());
            jsonUser.put("id_user", (Object)ticket.getUser().getId());
            jsonTicket.put("user", (Object)jsonUser);
        }
        jsonTicket.put("date_created", ticket.getDate().getTime());
        jsonTicket.put("date_paid", ticket.getDatePaid().getTime());
        JSONArray jsonItems = new JSONArray();
        for (TicketLineInfo line : ticket.getLines()) {
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("price", line.getPrice());
            jsonItem.put("quantity", line.getMultiply());
            jsonItem.put("name_product", (Object)line.getNameProduct());
            jsonItem.put("size_line_order", (Object)line.getSizeProduct());
            jsonItem.put("type_discount", (Object)line.getType_discount());
            jsonItem.put("discount", line.getValueDiscount());
            jsonItem.put("label_discount", (Object)line.getLabelDiscount());
            jsonItem.put("promo_product", line.isPromo_product());
            jsonItem.put("tva_global_no_applicable", line.isTva_global_no_applicable());
            JSONArray jsonModifiers = new JSONArray();
            for (OptionItemOrder option : line.getListSupplements()) {
                JSONObject jsonModifier = new JSONObject();
                jsonModifier.put("id_product", option.getIdProduct());
                jsonModifier.put("id_carte", option.getIdCarte());
                jsonModifier.put("index_carte", option.getIndex_carte());
                jsonModifier.put("price", (Object)option.getPrice());
                jsonModifier.put("price_already_included", option.getPrice_already_included());
                jsonModifier.put("display_free", option.isDisplay_free());
                jsonModifier.put("quantity", option.getNumberOption());
                jsonModifier.put("number_free", option.getNumber_flame());
                jsonModifier.put("name_supplement", (Object)option.getNameSupplement());
                jsonModifiers.put((Object)jsonModifier);
            }
            JSONArray jsonSubItems = new JSONArray();
            for (ProductTicket subItem : line.getListProducts()) {
                JSONObject jsonSubItem = new JSONObject();
                jsonSubItem.put("id_product", subItem.getIdProduct());
                jsonSubItem.put("id_carte", subItem.getIdCarte());
                jsonSubItem.put("index_carte", subItem.getIndex_carte());
                jsonSubItem.put("price", subItem.getPriceProduct());
                jsonSubItem.put("quantity", subItem.getNumberProduct());
                jsonSubItem.put("name_sub_items", (Object)subItem.getNameProduct());
                jsonSubItems.put((Object)jsonSubItem);
            }
            jsonItem.put("sub_items", (Object)jsonSubItems);
            jsonItem.put("modifiers", (Object)jsonModifiers);
            jsonItems.put((Object)jsonItem);
        }
        jsonTicket.put("items", (Object)jsonItems);
        jsonTicket.put("discount", ticket.getDiscount());
        jsonTicket.put("type_discount", (Object)ticket.getTypeDiscount());
        JSONArray jsonPayments = new JSONArray();
        for (PaymentInfo payment : ticket.getPayments()) {
            JSONObject jsonPayment = new JSONObject();
            jsonPayment.put("total_payment", payment.getTotal());
            jsonPayment.put("tendered", payment.getTendered());
            jsonPayment.put("name_payment", (Object)payment.getName());
            jsonPayments.put((Object)jsonPayment);
        }
        jsonTicket.put("payments", (Object)jsonPayments);
        return jsonTicket;
    }
}

