/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.parser;

import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryDayAvailable;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductDayOn;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.ScreenProduct;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.ScreenSupplementItem;
import com.openbravo.pos.ticket.ShiftCategory;
import com.openbravo.pos.ticket.ShiftProduct;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementPriceInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.firebase.FirebaseService;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.MultiLanguageCarte;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import fr.protactile.procaisse.dao.entities.MultiLanguageGSS;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.MultiLanguagePromotion;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplement;
import fr.protactile.procaisse.dao.entities.MultiLanguageSupplementItem;
import fr.protactile.procaisse.dao.entities.NutrientData;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class CarteParser {
    private static final String prefix_categories = "C_";
    private static final String prefix_products = "P_";
    private static final String prefix_ingredients = "I_";
    private static final String prefix_supplements = "S_";

    public static Object[] parseItems(JSONObject obj) {
        int i;
        Object[] result = new Object[10];
        JSONArray dataCategories = obj.getJSONArray("categories");
        JSONArray dataProducts = obj.getJSONArray("items");
        JSONArray dataOptions = obj.getJSONArray("options");
        JSONArray dataCartes = obj.getJSONArray("cartes");
        JSONArray dataPrinters = obj.getJSONArray("printers");
        ArrayList<CarteInfo> cartes = new ArrayList<CarteInfo>();
        HashMap<Integer, PrinterInfo> printers = new HashMap<Integer, PrinterInfo>();
        HashMap<String, CategoryInfo> categories = new HashMap<String, CategoryInfo>();
        HashMap categoriesNoMenu = new HashMap();
        HashMap categoriesMenu = new HashMap();
        ArrayList<SupplementInfo> options = new ArrayList<SupplementInfo>();
        ArrayList<NutrientData> nutrientDatas = new ArrayList<NutrientData>();
        for (i = 0; i < dataCategories.length(); ++i) {
            Object parent_id;
            JSONObject objCategory = dataCategories.getJSONObject(i);
            int idCat = objCategory.getInt("idCat");
            String nameCategory = objCategory.getString("name");
            int positionCategory = objCategory.getInt("position");
            boolean removedCategory = objCategory.getBoolean("removed");
            boolean hiddenCategory = objCategory.getBoolean("hidden");
            boolean apply_discount_category = objCategory.getBoolean("apply_discount");
            String colorCategory = null;
            String pathCategory = null;
            if (!objCategory.isNull("color")) {
                colorCategory = objCategory.getString("color");
            }
            if (!objCategory.isNull("path")) {
                pathCategory = objCategory.getString("path");
            }
            CategoryInfo category = new CategoryInfo(idCat, nameCategory, positionCategory, colorCategory, removedCategory, hiddenCategory, apply_discount_category, pathCategory);
            category.setHidden_borne(objCategory.isNull("hidden_borne") ? false : objCategory.getBoolean("hidden_borne"));
            category.setHidden_caisse(objCategory.isNull("hidden_caisse") ? false : objCategory.getBoolean("hidden_caisse"));
            category.setSold_out(objCategory.getBoolean("sold_out"));
            category.setProducts_first(objCategory.getBoolean("products_first"));
            category.setNext_available(objCategory.getBoolean("next_available"));
            category.setMoment_category(objCategory.getBoolean("moment_category"));
            category.setRemoved_by_admin(objCategory.getBoolean("removed_by_admin"));
            category.setHas_display_time(objCategory.getBoolean("display_time"));
            category.setFirst_period(objCategory.getInt("first_period"));
            category.setEnd_period(objCategory.getInt("end_period"));
            category.setAvailable_caisse(objCategory.isNull("available_caisse") ? false : objCategory.getBoolean("available_caisse"));
            category.setHide_name_in_borne(objCategory.isNull("hide_name_in_borne") ? false : objCategory.getBoolean("hide_name_in_borne"));
            category.setHidden_online(objCategory.isNull("hidden_online") ? false : objCategory.getBoolean("hidden_online"));
            category.setHidden_ubereat(objCategory.isNull("hidden_ubereat") ? false : objCategory.getBoolean("hidden_ubereat"));
            category.setCategory_ubereat(objCategory.isNull("category_ubereat") ? false : objCategory.getBoolean("category_ubereat"));
            category.setOffset_print_kitchen(objCategory.isNull("offset_print_kitchen") ? 0 : objCategory.getInt("offset_print_kitchen"));
            category.setPath_category_moment(objCategory.isNull("path_category_moment") ? "" : objCategory.getString("path_category_moment"));
            category.setType_image_category_moment(objCategory.isNull("type_image_category_moment") ? "" : objCategory.getString("type_image_category_moment"));
            if (!objCategory.isNull("tags")) {
                JSONArray categoryTags = objCategory.getJSONArray("tags");
                for (int j = 0; j < categoryTags.length(); ++j) {
                    JSONObject objcategoryTag = categoryTags.getJSONObject(j);
                    TagInfo mTagInfo = new TagInfo();
                    if (!objcategoryTag.isNull("idTag")) {
                        mTagInfo.setId(objcategoryTag.getInt("idTag"));
                    }
                    if (!objcategoryTag.isNull("id_tag")) {
                        mTagInfo.setId(objcategoryTag.getInt("id_tag"));
                    }
                    mTagInfo.setName(objcategoryTag.getString("name_tag"));
                    mTagInfo.setNumber(objcategoryTag.getInt("number_tag"));
                    mTagInfo.setLogo_tag(!objcategoryTag.isNull("logo_tag") ? objcategoryTag.getString("logo_tag") : null);
                    mTagInfo.setBackground_catalog(!objcategoryTag.isNull("background_catalog") ? objcategoryTag.getString("background_catalog") : null);
                    mTagInfo.setEnabled(!objcategoryTag.isNull("enabled") ? objcategoryTag.getBoolean("enabled") : true);
                    mTagInfo.setClosed(!objcategoryTag.isNull("closed") ? objcategoryTag.getBoolean("closed") : false);
                    category.getTags().add(mTagInfo);
                }
            }
            if (!objCategory.isNull("idGlobal")) {
                category.setId_global(objCategory.getString("idGlobal"));
            }
            if ((parent_id = objCategory.get("parent_id")) instanceof Integer) {
                category.setParent_id(objCategory.getInt("parent_id"));
            } else {
                category.setParent_id_global(objCategory.getString("parent_id"));
            }
            String key = category.getId_global() != null && !category.getId_global().isEmpty() ? category.getId_global() : String.valueOf(idCat);
            category.setHas_timetable(objCategory.getBoolean("has_timetable"));
            if (!objCategory.isNull("daysOn")) {
                JSONArray daysOn = objCategory.getJSONArray("daysOn");
                for (int j = 0; j < daysOn.length(); ++j) {
                    JSONObject objDaysOn = daysOn.getJSONObject(j);
                    int day_of_week = objDaysOn.getInt("day_of_week");
                    CategoryDayAvailable mCategoryDayAvailable = new CategoryDayAvailable();
                    mCategoryDayAvailable.setDayOfWeek(day_of_week);
                    category.getDaysOn().add(mCategoryDayAvailable);
                }
            }
            if (!objCategory.isNull("shiftsOn")) {
                JSONArray shiftsOn = objCategory.getJSONArray("shiftsOn");
                for (int j = 0; j < shiftsOn.length(); ++j) {
                    JSONObject objShiftOn = shiftsOn.getJSONObject(j);
                    String date_start = objShiftOn.getString("date_start");
                    String date_end = objShiftOn.getString("date_end");
                    ShiftCategory mShiftCategory = new ShiftCategory();
                    mShiftCategory.setDateStart(date_start);
                    mShiftCategory.setDateEnd(date_end);
                    category.getShiftsCategory().add(mShiftCategory);
                }
            }
            if (!objCategory.isNull("campagneDates")) {
                JSONObject campagneDates = objCategory.getJSONObject("campagneDates");
                String dateDebut = campagneDates.getString("dateDebut");
                String dateFin = campagneDates.getString("dateFin");
                Date startDisplay = null;
                Date endDisplay = null;
                try {
                    startDisplay = dateDebut.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateDebut);
                    endDisplay = dateFin.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateFin);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
                category.setDateStartDisplay(startDisplay);
                category.setDateEndDisplay(endDisplay);
            }
            category.setImageUrl(!objCategory.isNull("imageURL") ? objCategory.getString("imageURL") : null);
            if (!objCategory.isNull("translation")) {
                JSONArray multiLanguageTexts = objCategory.getJSONArray("translation");
                for (int j = 0; j < multiLanguageTexts.length(); ++j) {
                    JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(j);
                    MultiLanguageCategory multiLanguageCategory = new MultiLanguageCategory();
                    multiLanguageCategory.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                    multiLanguageCategory.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                    category.getMultiLanguageTexts().add(multiLanguageCategory);
                }
            }
            categories.put(key, category);
        }
        for (i = 0; i < dataProducts.length(); ++i) {
            String key;
            Object category_id;
            int j;
            JSONObject objProduct = dataProducts.getJSONObject(i);
            String idproduct = String.valueOf(objProduct.getInt("idItem"));
            ProductInfoExt product = new ProductInfoExt();
            if (!objProduct.isNull("bar_code")) {
                product.setCode(objProduct.getString("bar_code"));
            }
            product.setName(objProduct.getString("name"));
            product.setPriceSell(objProduct.getDouble("price"));
            product.setPriceBuy(objProduct.getDouble("purchase_price"));
            product.setRate_tax(objProduct.getDouble("tax"));
            product.setRate_tax_emp(objProduct.getDouble("tax_emp"));
            product.setRate_tax_lv(objProduct.getDouble("tax_lv"));
            if (!objProduct.isNull("color")) {
                product.setColor(objProduct.getString("color"));
            }
            product.setMenu(objProduct.getBoolean("is_menu"));
            product.setPrepared(objProduct.getBoolean("cook"));
            product.setPrinterID(objProduct.getInt("printer"));
            product.setPrinterLabel(objProduct.getInt("printerLabel"));
            product.setHasLabel(objProduct.getBoolean("label"));
            product.setLv(objProduct.getBoolean("available_delivery"));
            product.setEmp(objProduct.getBoolean("available_takeaway"));
            product.setSp(objProduct.getBoolean("available_on_the_spot"));
            product.setBar(objProduct.getBoolean("available_bar"));
            product.setTerasse(objProduct.getBoolean("available_terasse"));
            product.setHappy_hour(objProduct.getBoolean("available_happy_hour"));
            product.setMany_size(objProduct.getBoolean("many_size"));
            product.setDifferent_price(objProduct.getBoolean("different_price"));
            product.setOption_free(objProduct.getInt("option_free"));
            product.setSpecial_option(objProduct.getBoolean("special_option"));
            product.setAdditional_sale(objProduct.getBoolean("additional_sale"));
            product.setMoment_product(objProduct.getBoolean("moment_product"));
            product.setRemoved(objProduct.getBoolean("removed"));
            product.setHidden(objProduct.getBoolean("hidden"));
            product.setNumber_line(objProduct.getInt("number_line"));
            product.setNumber_column(objProduct.getInt("number_column"));
            product.setMax_line(objProduct.getInt("max_line"));
            product.setQuantity(objProduct.getDouble("quantity"));
            product.setPrice_sp(objProduct.getDouble("price_sp"));
            product.setPrice_emp(objProduct.getDouble("price_emp"));
            product.setPrice_lv(objProduct.getDouble("price_lv"));
            product.setPrice_bar(objProduct.getDouble("price_bar"));
            product.setPrice_terasse(objProduct.getDouble("price_terasse"));
            product.setPrice_happy_hour(objProduct.getDouble("price_happy"));
            product.setPrice_junior(objProduct.getDouble("price_junior"));
            product.setPrice_senior(objProduct.getDouble("price_senior"));
            product.setPrice_mega(objProduct.getDouble("price_mega"));
            product.setPrice_sp_junior(objProduct.getDouble("price_sp_junior"));
            product.setPrice_sp_senior(objProduct.getDouble("price_sp_senior"));
            product.setPrice_sp_mega(objProduct.getDouble("price_sp_mega"));
            product.setPrice_emp_junior(objProduct.getDouble("price_emp_junior"));
            product.setPrice_emp_senior(objProduct.getDouble("price_emp_senior"));
            product.setPrice_emp_mega(objProduct.getDouble("price_emp_mega"));
            product.setPrice_lv_junior(objProduct.getDouble("price_lv_junior"));
            product.setPrice_lv_senior(objProduct.getDouble("price_lv_senior"));
            product.setPrice_lv_mega(objProduct.getDouble("price_lv_mega"));
            product.setPrice_bar_junior(objProduct.getDouble("price_bar_junior"));
            product.setPrice_bar_senior(objProduct.getDouble("price_bar_senior"));
            product.setPrice_bar_mega(objProduct.getDouble("price_bar_mega"));
            product.setPrice_terasse_junior(objProduct.getDouble("price_terasse_junior"));
            product.setPrice_terasse_senior(objProduct.getDouble("price_terasse_senior"));
            product.setPrice_terasse_mega(objProduct.getDouble("price_terasse_mega"));
            product.setPrice_happy_junior(objProduct.getDouble("price_happy_junior"));
            product.setPrice_happy_senior(objProduct.getDouble("price_happy_senior"));
            product.setPrice_happy_mega(objProduct.getDouble("price_happy_mega"));
            product.setDisplayKitchen(objProduct.getInt("display_kitchen"));
            product.setApply_discount(objProduct.getBoolean("apply_discount"));
            if (!objProduct.isNull("unit")) {
                product.setUnit(objProduct.getString("unit"));
            } else {
                product.setUnit("piece");
            }
            product.setWeight(objProduct.getDouble("weight"));
            if (!objProduct.isNull("extra_unit")) {
                product.setExtra_unit(objProduct.getString("extra_unit"));
            }
            product.setRef_web(idproduct);
            String pathImageProduct = !objProduct.isNull("path") ? objProduct.getString("path") : null;
            String urlImageProduct = !objProduct.isNull("imageURL") ? objProduct.getString("imageURL") : null;
            product.setImage(ProductInfoExt.IMAGE_POS, pathImageProduct, urlImageProduct, null);
            product.setOrder_item(objProduct.getInt("position"));
            product.setHidden_borne(objProduct.isNull("hidden_borne") ? false : objProduct.getBoolean("hidden_borne"));
            product.setSold_out(objProduct.getBoolean("sold_out"));
            product.setFree_price(objProduct.getBoolean("free_price"));
            if (!objProduct.isNull("alias_product")) {
                product.setAlias_kitchen(objProduct.getString("alias_product"));
            }
            product.setSend_color(objProduct.getBoolean("send_color"));
            product.setHas_display_time(objProduct.getBoolean("display_time"));
            product.setFirst_period(objProduct.getInt("first_period"));
            product.setEnd_period(objProduct.getInt("end_period"));
            if (!objProduct.isNull("description")) {
                product.setDescription(objProduct.getString("description"));
            }
            product.setRemoved_by_admin(objProduct.getBoolean("removed_by_admin"));
            product.setAdditional_sale_at_spot(objProduct.getBoolean("additional_sale_atSpot"));
            product.setAdditional_sale_take_away(objProduct.getBoolean("additional_sale_take_away"));
            product.setPrice_platform(objProduct.getDouble("price_platform"));
            product.setPrice_platform_junior(objProduct.getDouble("price_platform_junior"));
            product.setPrice_platform_senior(objProduct.getDouble("price_platform_senior"));
            product.setPrice_platform_mega(objProduct.getDouble("price_platform_mega"));
            product.setLater(objProduct.getBoolean("later"));
            product.setPrint_ingredients(objProduct.getBoolean("print_ingredients"));
            product.setAvailable_caisse(objProduct.isNull("available_caisse") ? false : objProduct.getBoolean("available_caisse"));
            product.setLabeled(objProduct.isNull("labeled") ? false : objProduct.getBoolean("labeled"));
            product.setSize_junior_enabled(objProduct.isNull("size_junior_enabled") ? true : objProduct.getBoolean("size_junior_enabled"));
            product.setSize_senior_enabled(objProduct.isNull("size_senior_enabled") ? true : objProduct.getBoolean("size_senior_enabled"));
            product.setSize_mega_enabled(objProduct.isNull("size_mega_enabled") ? true : objProduct.getBoolean("size_mega_enabled"));
            product.setBest_sale(objProduct.isNull("best_sale") ? false : objProduct.getBoolean("best_sale"));
            product.setPromo_basket(objProduct.isNull("promo_basket") ? false : objProduct.getBoolean("promo_basket"));
            product.setDisplay_image_in_kitchen(objProduct.isNull("display_image_in_kitchen") ? false : objProduct.getBoolean("display_image_in_kitchen"));
            product.setDaily_stock(objProduct.isNull("daily_stock") ? 0 : objProduct.getInt("daily_stock"));
            product.setHas_bar_code(objProduct.isNull("has_bar_code") ? false : objProduct.getBoolean("has_bar_code"));
            product.setTop_product(objProduct.isNull("top_product") ? false : objProduct.getBoolean("top_product"));
            product.setHide_name_in_borne(objProduct.isNull("hide_name_in_borne") ? false : objProduct.getBoolean("hide_name_in_borne"));
            product.setHide_price_in_borne(objProduct.isNull("hide_price_in_borne") ? false : objProduct.getBoolean("hide_price_in_borne"));
            product.setUnavailable_online(objProduct.isNull("unavailable_online") ? false : objProduct.getBoolean("unavailable_online"));
            product.setHidden_online(objProduct.isNull("hidden_online") ? false : objProduct.getBoolean("hidden_online"));
            product.setHas_timetable(objProduct.isNull("has_timetable") ? false : objProduct.getBoolean("has_timetable"));
            product.setHidden_platform(objProduct.isNull("hidden_ubereat") ? false : objProduct.getBoolean("hidden_ubereat"));
            product.setProduct_ubereat(objProduct.isNull("product_ubereat") ? false : objProduct.getBoolean("product_ubereat"));
            product.setDescription_uberEat(objProduct.isNull("description_ubereat") ? null : objProduct.getString("description_ubereat"));
            product.setMixed_product(objProduct.isNull("mixed_product") ? false : objProduct.getBoolean("mixed_product"));
            product.setPrice_drive(objProduct.isNull("price_drive") ? 0.0 : objProduct.getDouble("price_drive"));
            product.setPrice_drive_junior(objProduct.isNull("price_drive_junior") ? 0.0 : objProduct.getDouble("price_drive_junior"));
            product.setPrice_drive_senior(objProduct.isNull("price_drive_senior") ? 0.0 : objProduct.getDouble("price_drive_senior"));
            product.setPrice_drive_mega(objProduct.isNull("price_drive_mega") ? 0.0 : objProduct.getDouble("price_drive_mega"));
            product.setProduct_loyalty(objProduct.isNull("product_loyalty") ? false : objProduct.getBoolean("product_loyalty"));
            product.setPrice_point(objProduct.isNull("price_point") ? 0.0 : objProduct.getDouble("price_point"));
            product.setSold_out_temporary(objProduct.isNull("sold_out_temporary") ? false : objProduct.getBoolean("sold_out_temporary"));
            product.setEnable_in_opening(objProduct.isNull("enable_in_opening_mode") ? false : objProduct.getBoolean("enable_in_opening_mode"));
            product.setPrice_opening(objProduct.isNull("price_opening") ? 0.0 : objProduct.getDouble("price_opening"));
            product.setHidden_caisse(objProduct.isNull("hidden_caisse") ? false : objProduct.getBoolean("hidden_caisse"));
            product.SetValid_caisse(objProduct.isNull("valid_caisse") ? false : objProduct.getBoolean("valid_caisse"));
            product.setTva_global_no_applicable(objProduct.isNull("tva_global_no_applicable") ? false : objProduct.getBoolean("tva_global_no_applicable"));
            product.setMarque(objProduct.isNull("marque") ? 0 : objProduct.getInt("marque"));
            String pathImageProductMoment = !objProduct.isNull("path_product_moment") ? objProduct.getString("path_product_moment") : "";
            String urlImageProductMoment = !objProduct.isNull("imageURLMoment") ? objProduct.getString("imageURLMoment") : "";
            String graphicTypesProductMoment = !objProduct.isNull("type_image_product_moment") ? objProduct.getString("type_image_product_moment") : "";
            product.setImage(ProductInfoExt.IMAGE_PRODUCT_MOMENT, pathImageProductMoment, urlImageProductMoment, graphicTypesProductMoment);
            String pathImageProductPlatform = !objProduct.isNull("path_platform") ? objProduct.getString("path_platform") : "";
            String urlImageProductPlatform = !objProduct.isNull("imageURL_platform") ? objProduct.getString("imageURL_platform") : "";
            product.setImage(ProductInfoExt.IMAGE_PLATFORM, pathImageProductPlatform, urlImageProductPlatform, null);
            product.setZoneId((Integer)objProduct.opt("id_zone"));
            JSONArray productOptions = objProduct.getJSONArray("options");
            JSONArray productIngredients = objProduct.getJSONArray("ingredients");
            JSONArray productCartes = objProduct.getJSONArray("carte");
            JSONArray productSizes = objProduct.isNull("allSizes") ? objProduct.getJSONArray("sizes") : objProduct.getJSONArray("allSizes");
            JSONArray productScreens = objProduct.getJSONArray("screens");
            for (j = 0; j < productIngredients.length(); ++j) {
                JSONObject objproductIngredient = productIngredients.getJSONObject(j);
                if (objproductIngredient.isNull("id_ingredient")) continue;
                ItemIngredientInfo ingredient = new ItemIngredientInfo();
                Object id_ingredient = objproductIngredient.get("id_ingredient");
                if (id_ingredient instanceof Integer) {
                    ingredient.setId_supplement_item(objproductIngredient.getInt("id_ingredient"));
                } else {
                    ingredient.setId_global(objproductIngredient.getString("id_ingredient"));
                }
                int quantity = objproductIngredient.isNull("quantity") ? 1 : objproductIngredient.getInt("quantity");
                ingredient.setQuantity(quantity);
                product.getItemIngredients().add(ingredient);
            }
            for (j = 0; j < productOptions.length(); ++j) {
                JSONObject objproductOption = productOptions.getJSONObject(j);
                boolean free_able = objproductOption.getBoolean("free_able");
                boolean separate = objproductOption.getBoolean("separate");
                int option_free = objproductOption.getInt("option_free");
                boolean has_limit_options = objproductOption.getBoolean("has_limit_options");
                int min_option = objproductOption.getInt("min_option");
                int max_option = objproductOption.getInt("max_option");
                SupplementProduct supplementProduct = new SupplementProduct(free_able, separate, option_free, has_limit_options, min_option, max_option);
                supplementProduct.setOption_free_size2(objproductOption.isNull("option_free_size2") ? 0 : objproductOption.getInt("option_free_size2"));
                supplementProduct.setMin_options_size2(objproductOption.isNull("min_option_size2") ? 0 : objproductOption.getInt("min_option_size2"));
                supplementProduct.setMax_options_size2(objproductOption.isNull("max_option_size2") ? 0 : objproductOption.getInt("max_option_size2"));
                supplementProduct.setOption_free_size3(objproductOption.isNull("option_free_size3") ? 0 : objproductOption.getInt("option_free_size3"));
                supplementProduct.setMin_options_size3(objproductOption.isNull("min_option_size3") ? 0 : objproductOption.getInt("min_option_size3"));
                supplementProduct.setMax_options_size3(objproductOption.isNull("max_option_size3") ? 0 : objproductOption.getInt("max_option_size3"));
                supplementProduct.setOption_free_size4(objproductOption.isNull("option_free_size4") ? 0 : objproductOption.getInt("option_free_size4"));
                supplementProduct.setMin_options_size4(objproductOption.isNull("min_option_size4") ? 0 : objproductOption.getInt("min_option_size4"));
                supplementProduct.setMax_options_size4(objproductOption.isNull("max_option_size4") ? 0 : objproductOption.getInt("max_option_size4"));
                supplementProduct.setOption_free_size5(objproductOption.isNull("option_free_size5") ? 0 : objproductOption.getInt("option_free_size5"));
                supplementProduct.setMin_options_size5(objproductOption.isNull("min_option_size5") ? 0 : objproductOption.getInt("min_option_size5"));
                supplementProduct.setMax_options_size5(objproductOption.isNull("max_option_size5") ? 0 : objproductOption.getInt("max_option_size5"));
                supplementProduct.setOption_free_size6(objproductOption.isNull("option_free_size6") ? 0 : objproductOption.getInt("option_free_size6"));
                supplementProduct.setMin_options_size6(objproductOption.isNull("min_option_size6") ? 0 : objproductOption.getInt("min_option_size6"));
                supplementProduct.setMax_options_size6(objproductOption.isNull("max_option_size6") ? 0 : objproductOption.getInt("max_option_size6"));
                supplementProduct.setOption_free_size7(objproductOption.isNull("option_free_size7") ? 0 : objproductOption.getInt("option_free_size7"));
                supplementProduct.setMin_options_size7(objproductOption.isNull("min_option_size7") ? 0 : objproductOption.getInt("min_option_size7"));
                supplementProduct.setMax_options_size7(objproductOption.isNull("max_option_size7") ? 0 : objproductOption.getInt("max_option_size7"));
                supplementProduct.setOption_free_size8(objproductOption.isNull("option_free_size8") ? 0 : objproductOption.getInt("option_free_size8"));
                supplementProduct.setMin_options_size8(objproductOption.isNull("min_option_size8") ? 0 : objproductOption.getInt("min_option_size8"));
                supplementProduct.setMax_options_size8(objproductOption.isNull("max_option_size8") ? 0 : objproductOption.getInt("max_option_size8"));
                supplementProduct.setOption_free_size9(objproductOption.isNull("option_free_size9") ? 0 : objproductOption.getInt("option_free_size9"));
                supplementProduct.setMin_options_size9(objproductOption.isNull("min_option_size9") ? 0 : objproductOption.getInt("min_option_size9"));
                supplementProduct.setMax_options_size9(objproductOption.isNull("max_option_size9") ? 0 : objproductOption.getInt("max_option_size9"));
                supplementProduct.setOption_free_size10(objproductOption.isNull("option_free_size10") ? 0 : objproductOption.getInt("option_free_size10"));
                supplementProduct.setMin_options_size10(objproductOption.isNull("min_option_size10") ? 0 : objproductOption.getInt("min_option_size10"));
                supplementProduct.setMax_options_size10(objproductOption.isNull("max_option_size10") ? 0 : objproductOption.getInt("max_option_size10"));
                supplementProduct.setMany_size(objproductOption.isNull("many_size") ? false : objproductOption.getBoolean("many_size"));
                Object idSupplement = objproductOption.get("idSupplement");
                if (idSupplement instanceof Integer) {
                    supplementProduct.setiD(objproductOption.getInt("idSupplement"));
                } else {
                    supplementProduct.setId_global(objproductOption.getString("idSupplement"));
                }
                product.getSupplements().add(supplementProduct);
            }
            for (j = 0; j < productCartes.length(); ++j) {
                JSONObject objproductCarte = productCartes.getJSONObject(j);
                String name_carte = objproductCarte.getString("name");
                int number_carte = objproductCarte.getInt("number_carte");
                int order_carte = objproductCarte.getInt("order_carte");
                CarteOrderInfo caretInfo = new CarteOrderInfo(name_carte, order_carte, number_carte);
                Object id_carte = objproductCarte.get("id_carte");
                if (id_carte instanceof Integer) {
                    caretInfo.setId(objproductCarte.getInt("id_carte"));
                } else {
                    caretInfo.setId_global(objproductCarte.getString("id_carte"));
                }
                product.getCartes().add(caretInfo);
            }
            for (j = 0; j < productSizes.length(); ++j) {
                JSONObject objproductSize = productSizes.getJSONObject(j);
                ProductSizeInfo productSize = new ProductSizeInfo();
                productSize.setID(objproductSize.getInt("id_size"));
                productSize.setName(objproductSize.getString("name_size"));
                productSize.setLabel_size(objproductSize.getString("label_size"));
                productSize.setPrice(objproductSize.getDouble("price"));
                productSize.setPrice_sp(objproductSize.getDouble("price_sp"));
                productSize.setPrice_emp(objproductSize.getDouble("price_emp"));
                productSize.setPrice_lv(objproductSize.getDouble("price_lv"));
                productSize.setPrice_bar(objproductSize.getDouble("price_bar"));
                productSize.setPrice_terasse(objproductSize.getDouble("price_terasse"));
                productSize.setPrice_happy_hour(objproductSize.getDouble("price_happy_hour"));
                productSize.setPrice_uber(objproductSize.getDouble("price_uber"));
                productSize.setPrice_delivero(objproductSize.getDouble("price_delivero"));
                productSize.setPrice_platform(objproductSize.getDouble("price_platform"));
                productSize.setPrice_drive(objproductSize.isNull("price_drive") ? 0.0 : objproductSize.getDouble("price_drive"));
                productSize.setSize_enabled(objproductSize.isNull("size_enabled") ? true : objproductSize.getBoolean("size_enabled"));
                productSize.setTariff(objproductSize.isNull("tariff") ? 0 : objproductSize.getInt("tariff"));
                productSize.setId_global(objproductSize.isNull("idGlobal") ? "" : objproductSize.getString("idGlobal"));
                product.getListSizes().add(productSize);
            }
            for (j = 0; j < productScreens.length(); ++j) {
                Object id_product;
                JSONObject objproductScreen = productScreens.getJSONObject(j);
                ScreenProduct screenProduct = new ScreenProduct();
                if (!objproductScreen.isNull("id")) {
                    screenProduct.setId(objproductScreen.getInt("id"));
                }
                if ((id_product = objproductScreen.get("id_product")) instanceof Integer) {
                    screenProduct.setId_product(objproductScreen.getInt("id_product"));
                } else {
                    screenProduct.setId_global_product(objproductScreen.getString("id_product"));
                }
                if (!objproductScreen.isNull("id_screen")) {
                    screenProduct.setId_screen(objproductScreen.getInt("id_screen"));
                }
                if (!objproductScreen.isNull("idScreen")) {
                    screenProduct.setId_screen(objproductScreen.getInt("idScreen"));
                }
                screenProduct.setName_screen(objproductScreen.getString("name_screen"));
                screenProduct.setNumber_screen(objproductScreen.isNull("number_screen") ? 0 : objproductScreen.getInt("number_screen"));
                product.getScreens().add(screenProduct);
            }
            if (!objProduct.isNull("additionals")) {
                JSONArray productAdditionals = objProduct.getJSONArray("additionals");
                for (int j2 = 0; j2 < productAdditionals.length(); ++j2) {
                    ProductInfoExt additionalProduct = new ProductInfoExt();
                    Object idAdditional = productAdditionals.get(j2);
                    if (idAdditional instanceof Integer) {
                        additionalProduct.setID(productAdditionals.getInt(j2));
                    } else {
                        additionalProduct.setId_global(productAdditionals.getString(j2));
                    }
                    additionalProduct.setRef_web(additionalProduct.getID() != 0 ? String.valueOf(additionalProduct.getID()) : null);
                    product.getAdditional_sales().add(additionalProduct);
                }
            }
            if (!objProduct.isNull("promotions")) {
                JSONArray promotionsProduct = objProduct.getJSONArray("promotions");
                for (int j3 = 0; j3 < promotionsProduct.length(); ++j3) {
                    JSONObject objproductPromotion = promotionsProduct.getJSONObject(j3);
                    PromotionInfo promotionInfo = new PromotionInfo();
                    if (objproductPromotion.isNull("idGlobal")) {
                        promotionInfo.setId(objproductPromotion.getInt("id"));
                    } else {
                        promotionInfo.setId_global(objproductPromotion.getString("idGlobal"));
                    }
                    promotionInfo.setRef_synchro(promotionInfo.getId() != 0 ? String.valueOf(promotionInfo.getId()) : null);
                    product.getPromotions().add(promotionInfo);
                }
            }
            if (!objProduct.isNull("sub_products")) {
                JSONArray subProducts = objProduct.getJSONArray("sub_products");
                for (int j4 = 0; j4 < subProducts.length(); ++j4) {
                    JSONObject objSubProduct = subProducts.getJSONObject(j4);
                    int number_exemplary = objSubProduct.getInt("number_exemplary");
                    ProductInfoExt subProduct = new ProductInfoExt();
                    subProduct.setNumber_exemplary(number_exemplary);
                    Object idSubProduct = objSubProduct.get("id_sub_product");
                    if (idSubProduct instanceof Integer) {
                        subProduct.setID(objSubProduct.getInt("id_sub_product"));
                    } else {
                        subProduct.setId_global(objSubProduct.getString("id_sub_product"));
                    }
                    subProduct.setRef_web(subProduct.getID() != 0 ? String.valueOf(subProduct.getID()) : null);
                    product.getSub_products().add(subProduct);
                }
            }
            if (!objProduct.isNull("daysOn")) {
                JSONArray daysOn = objProduct.getJSONArray("daysOn");
                for (int j5 = 0; j5 < daysOn.length(); ++j5) {
                    JSONObject objDaysOn = daysOn.getJSONObject(j5);
                    int day_of_week = objDaysOn.getInt("day_of_week");
                    ProductDayOn mProductDayOn = new ProductDayOn();
                    mProductDayOn.setDay_of_week(day_of_week);
                    product.getDaysOn().add(mProductDayOn);
                }
            }
            if (!objProduct.isNull("shiftsOn")) {
                JSONArray shiftsOn = objProduct.getJSONArray("shiftsOn");
                for (int j6 = 0; j6 < shiftsOn.length(); ++j6) {
                    JSONObject objShiftOn = shiftsOn.getJSONObject(j6);
                    String date_start = objShiftOn.getString("date_start");
                    String date_end = objShiftOn.getString("date_end");
                    ShiftProduct mShiftProduct = new ShiftProduct();
                    mShiftProduct.setDateStart(date_start);
                    mShiftProduct.setDateEnd(date_end);
                    product.getShiftsCProduct().add(mShiftProduct);
                }
            }
            if (!objProduct.isNull("prices")) {
                JSONArray pricesProduct = objProduct.getJSONArray("prices");
                for (int j7 = 0; j7 < pricesProduct.length(); ++j7) {
                    JSONObject objPriceProduct = pricesProduct.getJSONObject(j7);
                    int tariff = objPriceProduct.isNull("tariff") ? 0 : objPriceProduct.getInt("tariff");
                    ProductPriceInfo productPrice = new ProductPriceInfo();
                    productPrice.setId(objPriceProduct.getInt("id"));
                    productPrice.setPrice(objPriceProduct.getDouble("price"));
                    productPrice.setType_order(objPriceProduct.isNull("type_order") ? null : objPriceProduct.getString("type_order"));
                    productPrice.setTariff(objPriceProduct.getInt("tariff"));
                    Object id_product = objPriceProduct.get("id_product");
                    if (id_product instanceof Integer) {
                        productPrice.setIdProduct(objPriceProduct.getInt("id_product"));
                    } else {
                        productPrice.setId_global_product(objPriceProduct.getString("id_product"));
                    }
                    product.getPrices().add(productPrice);
                }
            }
            if (!objProduct.isNull("idGlobal")) {
                product.setId_global(objProduct.getString("idGlobal"));
            }
            if ((category_id = objProduct.get("idCat")) instanceof Integer) {
                product.setCategoryid(objProduct.getInt("idCat"));
            } else {
                product.setId_global_category(objProduct.getString("idCat"));
            }
            if (!objProduct.isNull("campagneDates")) {
                JSONObject campagneDates = objProduct.getJSONObject("campagneDates");
                String dateDebut = campagneDates.getString("dateDebut");
                String dateFin = campagneDates.getString("dateFin");
                Date startDisplay = null;
                Date endDisplay = null;
                try {
                    startDisplay = dateDebut.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateDebut);
                    endDisplay = dateFin.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateFin);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
                product.setDateStartDisplay(startDisplay);
                product.setDateEndDisplay(endDisplay);
            }
            if (!objProduct.isNull("translation")) {
                JSONArray multiLanguageTexts = objProduct.getJSONArray("translation");
                for (int j8 = 0; j8 < multiLanguageTexts.length(); ++j8) {
                    JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(j8);
                    MultiLanguageProduct multiLanguageProduct = new MultiLanguageProduct();
                    multiLanguageProduct.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                    multiLanguageProduct.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                    multiLanguageProduct.setDescription(objMultiLanguageText.isNull("description") ? "" : objMultiLanguageText.getString("description"));
                    multiLanguageProduct.setDescription_platform(objMultiLanguageText.isNull("description_ubereat") ? "" : objMultiLanguageText.getString("description_ubereat"));
                    product.getMultiLanguageTexts().add(multiLanguageProduct);
                }
            }
            String string = key = product.getId_global_category() != null && !product.getId_global_category().isEmpty() ? product.getId_global_category() : String.valueOf(product.getCategoryid());
            if (categories.get(key) != null) {
                ((CategoryInfo)categories.get(key)).getProducts().add(product);
            }
            if (!objProduct.isNull("nutritional_info")) {
                JSONObject nutritional_infos = objProduct.getJSONObject("nutritional_info");
                NutritionalInfoProduct nutriInfo = new NutritionalInfoProduct();
                if (nutritional_infos.has("energy_kcal")) {
                    JSONObject energy = nutritional_infos.getJSONObject("energy_kcal");
                    nutriInfo.setEnergyKcalValue(CarteParser.parseDouble(energy.optString("value")));
                    nutriInfo.setEnergyKcalDailyPercentage(CarteParser.parseDouble(energy.optString("daily_percentage")));
                }
                if (nutritional_infos.has("fiber_g")) {
                    JSONObject fiber = nutritional_infos.getJSONObject("fiber_g");
                    nutriInfo.setFiberGValue(CarteParser.parseDouble(fiber.optString("value")));
                    nutriInfo.setFiberGDailyPercentage(CarteParser.parseDouble(fiber.optString("daily_percentage")));
                }
                if (nutritional_infos.has("fat_g")) {
                    JSONObject fat = nutritional_infos.getJSONObject("fat_g");
                    nutriInfo.setFatGValue(CarteParser.parseDouble(fat.optString("value")));
                    nutriInfo.setFatSaturatedG(fat.has("saturated_fat_g") && !String.valueOf(fat.get("saturated_fat_g")).isEmpty() ? Double.valueOf(fat.optDouble("saturated_fat_g")) : null);
                    nutriInfo.setFatGDailyPercentage(CarteParser.parseDouble(fat.optString("daily_percentage")));
                }
                if (nutritional_infos.has("carbs_g")) {
                    JSONObject carbs = nutritional_infos.getJSONObject("carbs_g");
                    nutriInfo.setCarbsGValue(CarteParser.parseDouble(carbs.optString("value")));
                    nutriInfo.setSugarG(CarteParser.parseDouble(carbs.optString("sugar_g")));
                    nutriInfo.setCarbsGDailyPercentage(CarteParser.parseDouble(carbs.optString("daily_percentage")));
                }
                if (nutritional_infos.has("protein_g")) {
                    JSONObject protein = nutritional_infos.getJSONObject("protein_g");
                    nutriInfo.setProteinGValue(CarteParser.parseDouble(protein.optString("value")));
                    nutriInfo.setProteinGDailyPercentage(CarteParser.parseDouble(protein.optString("daily_percentage")));
                }
                if (nutritional_infos.has("salt_g")) {
                    JSONObject salt = nutritional_infos.getJSONObject("salt_g");
                    nutriInfo.setSaltGValue(CarteParser.parseDouble(salt.optString("value")));
                    nutriInfo.setSaltGDailyPercentage(CarteParser.parseDouble(salt.optString("daily_percentage")));
                }
                product.setNutriValues(nutriInfo);
            }
            if (objProduct.isNull("allergens")) continue;
            JSONArray allergenArray = objProduct.getJSONArray("allergens");
            ArrayList<Allergene> allergeneList = new ArrayList<Allergene>();
            for (int idx = 0; idx < allergenArray.length(); ++idx) {
                String allergenName = allergenArray.getString(idx);
                System.out.println("********allergenName :" + allergenName);
                if (allergenName == null || allergenName.trim().isEmpty()) continue;
                Allergene allergene = new Allergene();
                allergene.setName(allergenName.trim());
                allergeneList.add(allergene);
            }
            product.setAllergenes(allergeneList);
        }
        for (i = 0; i < dataOptions.length(); ++i) {
            JSONObject objGOption = dataOptions.getJSONObject(i);
            int idGOption = objGOption.getInt("id");
            String nameGOption = objGOption.getString("name");
            boolean is_ingredient = objGOption.getBoolean("is_ingredient");
            boolean has_options = objGOption.getBoolean("has_options");
            int min_items = objGOption.getInt("min_items");
            int max_items = objGOption.getInt("max_items");
            int order_supplement = objGOption.isNull("position") ? 0 : objGOption.getInt("position");
            boolean removedSupp = objGOption.getBoolean("removed");
            int number_click = objGOption.getInt("number_click");
            boolean multiple_category = objGOption.getBoolean("multiple_category");
            String colorOption = null;
            if (!objGOption.isNull("color")) {
                colorOption = objGOption.getString("color");
            }
            JSONArray dataOptionItems = objGOption.getJSONArray("items");
            ArrayList<SupplementItemInfo> optionItems = new ArrayList<SupplementItemInfo>();
            for (int j = 0; j < dataOptionItems.length(); ++j) {
                Object id_product;
                int h;
                JSONObject objOptionItem = dataOptionItems.getJSONObject(j);
                String nameOptionItem = objOptionItem.getString("name");
                double priceOptionItem = objOptionItem.getDouble("price");
                double price_junior = objOptionItem.getDouble("price_junior");
                double price_senior = objOptionItem.getDouble("price_senior");
                double price_mega = objOptionItem.getDouble("price_mega");
                double price_size1 = objOptionItem.getDouble("price_size1");
                double price_size2 = objOptionItem.getDouble("price_size2");
                double price_size3 = objOptionItem.getDouble("price_size3");
                boolean removedSuppItem = objOptionItem.getBoolean("removed");
                int positionItem = objOptionItem.getInt("order_item");
                boolean many_size = objOptionItem.getBoolean("many_size");
                int idOptionItem = objOptionItem.getInt("id");
                SupplementItemInfo optionItem = new SupplementItemInfo(idOptionItem, nameOptionItem, priceOptionItem, price_junior, price_senior, price_mega, price_size1, price_size2, price_size3, positionItem, many_size, removedSuppItem);
                if (!objOptionItem.isNull("path")) {
                    optionItem.setPath(objOptionItem.getString("path"));
                }
                if (!objOptionItem.isNull("color")) {
                    optionItem.setColor(objOptionItem.getString("color"));
                }
                optionItem.setHidden_borne(objOptionItem.isNull("hidden_borne") ? false : objOptionItem.getBoolean("hidden_borne"));
                optionItem.setRemoved_by_admin(objOptionItem.getBoolean("removed_by_admin"));
                optionItem.setMany_type(objOptionItem.getBoolean("many_type"));
                optionItem.setPrice_size4(objOptionItem.isNull("price_size4") ? 0.0 : objOptionItem.getDouble("price_size4"));
                optionItem.setPrice_size5(objOptionItem.isNull("price_size5") ? 0.0 : objOptionItem.getDouble("price_size5"));
                optionItem.setPrice_size6(objOptionItem.isNull("price_size6") ? 0.0 : objOptionItem.getDouble("price_size6"));
                optionItem.setPrice_size7(objOptionItem.isNull("price_size7") ? 0.0 : objOptionItem.getDouble("price_size7"));
                JSONArray supplementScreens = objOptionItem.getJSONArray("screens");
                JSONArray supplementPrices = objOptionItem.getJSONArray("prices");
                for (h = 0; h < supplementScreens.length(); ++h) {
                    JSONObject objoptionScreen = supplementScreens.getJSONObject(h);
                    ScreenSupplementItem screenSuppelent = new ScreenSupplementItem();
                    screenSuppelent.setId(objoptionScreen.getInt("id"));
                    screenSuppelent.setId_supplement(objoptionScreen.getInt("id_supplement"));
                    screenSuppelent.setId_screen(objoptionScreen.getInt("id_screen"));
                    screenSuppelent.setName_screen(objoptionScreen.getString("name_screen"));
                    optionItem.getScreen().add(screenSuppelent);
                }
                for (h = 0; h < supplementPrices.length(); ++h) {
                    JSONObject objSupplementSize = supplementPrices.getJSONObject(h);
                    SupplementPriceInfo supplementprice = new SupplementPriceInfo();
                    supplementprice.setId(objSupplementSize.getInt("id_price"));
                    supplementprice.setType_order(objSupplementSize.getString("type_order"));
                    supplementprice.setPrice(objSupplementSize.getDouble("price"));
                    supplementprice.setPrice_junior(objSupplementSize.getDouble("price_junior"));
                    supplementprice.setPrice_senior(objSupplementSize.getDouble("price_senior"));
                    supplementprice.setPrice_mega(objSupplementSize.getDouble("price_mega"));
                    supplementprice.setPrice_size1(objSupplementSize.getDouble("price_size1"));
                    supplementprice.setPrice_size2(objSupplementSize.getDouble("price_size2"));
                    supplementprice.setPrice_size3(objSupplementSize.getDouble("price_size3"));
                    supplementprice.setPrice_size4(objSupplementSize.isNull("price_size4") ? 0.0 : objSupplementSize.getDouble("price_size4"));
                    supplementprice.setPrice_size5(objSupplementSize.isNull("price_size5") ? 0.0 : objSupplementSize.getDouble("price_size5"));
                    supplementprice.setPrice_size6(objSupplementSize.isNull("price_size6") ? 0.0 : objSupplementSize.getDouble("price_size6"));
                    supplementprice.setPrice_size7(objSupplementSize.isNull("price_size7") ? 0.0 : objSupplementSize.getDouble("price_size7"));
                    supplementprice.setId_global(objSupplementSize.isNull("idGlobal") ? "" : objSupplementSize.getString("idGlobal"));
                    optionItem.getSupplementPrices().add(supplementprice);
                }
                if (!objOptionItem.isNull("groups_sub_supplement")) {
                    JSONArray groupsSubOption = objOptionItem.getJSONArray("groups_sub_supplement");
                    for (int h2 = 0; h2 < groupsSubOption.length(); ++h2) {
                        GroupSubSupplementInfo groupSubSupplementInfo = new GroupSubSupplementInfo();
                        Object idGroupSubOption = groupsSubOption.get(h2);
                        if (idGroupSubOption instanceof Integer) {
                            groupSubSupplementInfo.setId(groupsSubOption.getInt(h2));
                        } else if (idGroupSubOption instanceof String) {
                            groupSubSupplementInfo.setId_global(groupsSubOption.getString(h2));
                        }
                        groupSubSupplementInfo.setRef_synchro(groupSubSupplementInfo.getId() != 0 ? String.valueOf(groupSubSupplementInfo.getId()) : null);
                        optionItem.getGroupsSubSupplement().add(groupSubSupplementInfo);
                    }
                }
                if (!objOptionItem.isNull("alias_supplement")) {
                    optionItem.setAlias_kitchen(objOptionItem.getString("alias_supplement"));
                }
                optionItem.setSend_color(objOptionItem.getBoolean("send_color"));
                optionItem.setFlame_enabled(objOptionItem.getBoolean("flame_enabled"));
                optionItem.setNumber_flame(objOptionItem.getInt("number_flame"));
                optionItem.setHidden(objOptionItem.isNull("hidden") ? false : objOptionItem.getBoolean("hidden"));
                optionItem.setHidden_online(objOptionItem.isNull("hidden_online") ? false : objOptionItem.getBoolean("hidden_online"));
                optionItem.setHidden_ubereat(objOptionItem.isNull("hidden_ubereat") ? false : objOptionItem.getBoolean("hidden_ubereat"));
                optionItem.setSupplement_item_ubereat(objOptionItem.isNull("supplement_item_ubereat") ? false : objOptionItem.getBoolean("supplement_item_ubereat"));
                optionItem.setSold_out(objOptionItem.isNull("sold_out") ? false : objOptionItem.getBoolean("sold_out"));
                optionItem.setHidden_in_kitchen(objOptionItem.isNull("hidden_in_kitchen") ? false : objOptionItem.getBoolean("hidden_in_kitchen"));
                optionItem.setCookable(objOptionItem.isNull("cookable") ? false : objOptionItem.getBoolean("cookable"));
                if (!objOptionItem.isNull("idGlobal")) {
                    optionItem.setId_global(objOptionItem.getString("idGlobal"));
                }
                if ((id_product = objOptionItem.get("id_product")) instanceof Integer) {
                    optionItem.setId_product(objOptionItem.getInt("id_product"));
                } else {
                    optionItem.setId_product_global(objOptionItem.getString("id_product"));
                }
                optionItem.setRateTaxe(objOptionItem.isNull("rate_taxe") ? -1.0 : objOptionItem.getDouble("rate_taxe"));
                optionItem.setPrice_already_included(objOptionItem.isNull("price_already_included") ? 0.0 : objOptionItem.getDouble("price_already_included"));
                if (!objOptionItem.isNull("campagneDates")) {
                    JSONObject campagneDates = objOptionItem.getJSONObject("campagneDates");
                    String dateDebut = campagneDates.getString("dateDebut");
                    String dateFin = campagneDates.getString("dateFin");
                    Date startDisplay = null;
                    Date endDisplay = null;
                    try {
                        startDisplay = dateDebut.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateDebut);
                        endDisplay = dateFin.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateFin);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                    optionItem.setDateStartDisplay(startDisplay);
                    optionItem.setDateEndDisplay(endDisplay);
                }
                optionItem.setImageUrl(!objOptionItem.isNull("imageURL") ? objOptionItem.getString("imageURL") : null);
                if (!objOptionItem.isNull("translation")) {
                    JSONArray multiLanguageTexts = objOptionItem.getJSONArray("translation");
                    for (int h3 = 0; h3 < multiLanguageTexts.length(); ++h3) {
                        JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(h3);
                        MultiLanguageSupplementItem multiLanguageSupplementItem = new MultiLanguageSupplementItem();
                        multiLanguageSupplementItem.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                        multiLanguageSupplementItem.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                        optionItem.getMultiLanguageTexts().add(multiLanguageSupplementItem);
                    }
                }
                if (!objOptionItem.isNull("allergens")) {
                    JSONArray allergenArray = objOptionItem.getJSONArray("allergens");
                    ArrayList<AllergeneSupplement> allergeneList = new ArrayList<AllergeneSupplement>();
                    for (int idx = 0; idx < allergenArray.length(); ++idx) {
                        String allergenName = allergenArray.getString(idx);
                        System.out.println("********allergenOptionName :" + allergenName);
                        if (allergenName == null || allergenName.trim().isEmpty()) continue;
                        AllergeneSupplement allergene = new AllergeneSupplement();
                        allergene.setName(allergenName.trim());
                        allergeneList.add(allergene);
                    }
                    optionItem.setAllergenes(allergeneList);
                }
                optionItems.add(optionItem);
            }
            SupplementInfo gOption = new SupplementInfo(idGOption, nameGOption, has_options, min_items, max_items, is_ingredient, order_supplement, colorOption, number_click, multiple_category, optionItems, removedSupp);
            gOption.setOrder_name(objGOption.getBoolean("alphabetical_order"));
            gOption.setPrepared(objGOption.getBoolean("prepared"));
            gOption.setPrinter(objGOption.getInt("printer"));
            gOption.setShift_option(objGOption.getInt("shift_option"));
            gOption.setDisplay_screen_sorti(objGOption.getBoolean("display_screen_sorti"));
            gOption.setHidden_borne(objGOption.isNull("hidden_borne") ? false : objGOption.getBoolean("hidden_borne"));
            gOption.setOrder_name(objGOption.getBoolean("order_name"));
            gOption.setRemoved_by_admin(objGOption.getBoolean("removed_by_admin"));
            gOption.setNo_printable(objGOption.getBoolean("no_printable"));
            gOption.setIsBold(objGOption.getBoolean("is_bold"));
            gOption.setHidden_online(objGOption.isNull("hidden_online") ? false : objGOption.getBoolean("hidden_online"));
            gOption.setHidden_ubereat(objGOption.isNull("hidden_ubereat") ? false : objGOption.getBoolean("hidden_ubereat"));
            gOption.setSupplement_ubereat(objGOption.isNull("supplement_ubereat") ? false : objGOption.getBoolean("supplement_ubereat"));
            gOption.setDisplay_free(objGOption.isNull("display_free") ? false : objGOption.getBoolean("display_free"));
            if (!objGOption.isNull("path")) {
                gOption.setPath(objGOption.getString("path"));
            }
            gOption.setPrint_black_background(objGOption.isNull("print_black_background") ? false : objGOption.getBoolean("print_black_background"));
            JSONArray optionScreens = objGOption.getJSONArray("screens");
            for (int j = 0; j < optionScreens.length(); ++j) {
                JSONObject objoptionScreen = optionScreens.getJSONObject(j);
                ScreenSupplementInfo screenOption = new ScreenSupplementInfo();
                screenOption.setId(objoptionScreen.getInt("id"));
                screenOption.setId_supplement(objoptionScreen.getInt("id_supplement"));
                screenOption.setId_screen(objoptionScreen.getInt("id_screen"));
                screenOption.setName_screen(objoptionScreen.getString("name_screen"));
                gOption.getScreens().add(screenOption);
            }
            if (!objGOption.isNull("idGlobal")) {
                gOption.setId_global(objGOption.getString("idGlobal"));
            }
            if (!objGOption.isNull("campagneDates")) {
                JSONObject campagneDates = (JSONObject)objGOption.get("campagneDates");
                String dateDebut = campagneDates.getString("dateDebut");
                String dateFin = campagneDates.getString("dateFin");
                Date startDisplay = null;
                Date endDisplay = null;
                try {
                    startDisplay = dateDebut.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateDebut);
                    endDisplay = dateFin.equals("") ? null : new SimpleDateFormat("yyyy-MM-dd").parse(dateFin);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
                gOption.setDateStartDisplay(startDisplay);
                gOption.setDateEndDisplay(endDisplay);
            }
            if (!objGOption.isNull("translation")) {
                JSONArray multiLanguageTexts = objGOption.getJSONArray("translation");
                for (int h = 0; h < multiLanguageTexts.length(); ++h) {
                    JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(h);
                    MultiLanguageSupplement multiLanguageSupplement = new MultiLanguageSupplement();
                    multiLanguageSupplement.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                    multiLanguageSupplement.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                    gOption.getMultiLanguageTexts().add(multiLanguageSupplement);
                }
            }
            options.add(gOption);
        }
        for (i = 0; i < dataCartes.length(); ++i) {
            JSONObject objCarte = dataCartes.getJSONObject(i);
            int idCarte = objCarte.getInt("id");
            String nameCarte = objCarte.getString("name");
            String sizecarte = null;
            if (!objCarte.isNull("size_carte")) {
                sizecarte = objCarte.getString("size_carte");
            }
            boolean removedCarte = objCarte.getBoolean("removed");
            boolean removed_by_admin = objCarte.getBoolean("removed_by_admin");
            CarteInfo carte = new CarteInfo(idCarte, nameCarte, sizecarte, removedCarte, null, removed_by_admin);
            JSONArray dataCarteItems = objCarte.getJSONArray("items");
            for (int j = 0; j < dataCarteItems.length(); ++j) {
                JSONObject objCarteItem = dataCarteItems.getJSONObject(j);
                CarteItemInfo carteItemInfo = new CarteItemInfo();
                Object id_carte = objCarteItem.get("id_carte");
                if (id_carte instanceof Integer) {
                    carteItemInfo.setId_carte(objCarteItem.getInt("id_carte"));
                } else {
                    carteItemInfo.setId_global_carte(objCarteItem.getString("id_carte"));
                }
                Object id_item = objCarteItem.get("id_item");
                if (id_item instanceof Integer) {
                    carteItemInfo.setId_item(objCarteItem.getInt("id_item"));
                } else {
                    carteItemInfo.setId_global_item(objCarteItem.getString("id_item"));
                }
                carteItemInfo.setPrice(objCarteItem.getDouble("price"));
                carteItemInfo.setOrder_item(objCarteItem.isNull("order_item") ? 0 : objCarteItem.getInt("order_item"));
                carte.getCarteItems().add(carteItemInfo);
            }
            if (!objCarte.isNull("idGlobal")) {
                carte.setId_global(objCarte.getString("idGlobal"));
            }
            if (!objCarte.isNull("translation")) {
                JSONArray multiLanguageTexts = objCarte.getJSONArray("translation");
                for (int j = 0; j < multiLanguageTexts.length(); ++j) {
                    JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(j);
                    MultiLanguageCarte multiLanguageCarte = new MultiLanguageCarte();
                    multiLanguageCarte.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                    multiLanguageCarte.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                    carte.getMultiLanguageTexts().add(multiLanguageCarte);
                }
            }
            cartes.add(carte);
        }
        for (i = 0; i < dataPrinters.length(); ++i) {
            JSONObject objPrinter = dataPrinters.getJSONObject(i);
            int idPrinter = objPrinter.getInt("idPrinter");
            String name = objPrinter.getString("name");
            String type = objPrinter.getString("type");
            String ip_address = null;
            if (!objPrinter.isNull("ip_address")) {
                ip_address = objPrinter.getString("ip_address");
            }
            int width_ticket = objPrinter.getInt("width_ticket");
            int number_ticket = objPrinter.getInt("number_ticket");
            String type_printer = null;
            if (!objPrinter.isNull("type_printer")) {
                type_printer = objPrinter.getString("type_printer");
            }
            String model = null;
            if (!objPrinter.isNull("model")) {
                model = objPrinter.getString("model");
            }
            PrinterInfo printer = new PrinterInfo(idPrinter, name, type, ip_address, width_ticket, number_ticket, type_printer, model);
            printer.setRef_synchro(String.valueOf(idPrinter));
            printers.put(idPrinter, printer);
        }
        result[0] = categories;
        result[1] = options;
        result[2] = cartes;
        result[3] = printers;
        if (!obj.isNull("groups_sub_options")) {
            ArrayList<GroupSubSupplementInfo> groupsSubOption = new ArrayList<GroupSubSupplementInfo>();
            JSONArray arrayGroupsSubOption = obj.getJSONArray("groups_sub_options");
            for (int i2 = 0; i2 < arrayGroupsSubOption.length(); ++i2) {
                JSONObject objgroupSubOption = arrayGroupsSubOption.getJSONObject(i2);
                GroupSubSupplementInfo groupSubSupplementInfo = new GroupSubSupplementInfo();
                groupSubSupplementInfo.setId(objgroupSubOption.getInt("id"));
                groupSubSupplementInfo.setName_group(objgroupSubOption.getString("name_group"));
                groupSubSupplementInfo.setTitle_group(objgroupSubOption.getString("title_group"));
                groupSubSupplementInfo.setRemoved(objgroupSubOption.getBoolean("removed"));
                groupSubSupplementInfo.setHas_limit_options(objgroupSubOption.isNull("has_limit_options") ? false : objgroupSubOption.getBoolean("has_limit_options"));
                groupSubSupplementInfo.setMin_options(objgroupSubOption.isNull("min_option") ? 0 : objgroupSubOption.getInt("min_option"));
                groupSubSupplementInfo.setMax_options(objgroupSubOption.isNull("max_option") ? 0 : objgroupSubOption.getInt("max_option"));
                groupSubSupplementInfo.setOption_free(objgroupSubOption.isNull("option_free") ? 0 : objgroupSubOption.getInt("option_free"));
                groupSubSupplementInfo.setNumber_click(objgroupSubOption.isNull("number_click") ? 0 : objgroupSubOption.getInt("number_click"));
                JSONArray sub_supplements = objgroupSubOption.getJSONArray("sub_supplements");
                for (int j = 0; j < sub_supplements.length(); ++j) {
                    Object idSubSupplement = sub_supplements.get(j);
                    SupplementItemInfo supplementItemInfo = new SupplementItemInfo();
                    if (idSubSupplement instanceof Integer) {
                        supplementItemInfo.setiD(sub_supplements.getInt(j));
                    } else {
                        supplementItemInfo.setId_global(sub_supplements.getString(j));
                    }
                    supplementItemInfo.setRef_web(supplementItemInfo.getiD() != 0 ? String.valueOf(supplementItemInfo.getiD()) : null);
                    groupSubSupplementInfo.getSupplements().add(supplementItemInfo);
                }
                if (!objgroupSubOption.isNull("idGlobal")) {
                    groupSubSupplementInfo.setId_global(objgroupSubOption.getString("idGlobal"));
                }
                if (!objgroupSubOption.isNull("translation")) {
                    JSONArray multiLanguageTexts = objgroupSubOption.getJSONArray("translation");
                    for (int j = 0; j < multiLanguageTexts.length(); ++j) {
                        JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(j);
                        MultiLanguageGSS multiLanguageGSS = new MultiLanguageGSS();
                        multiLanguageGSS.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                        multiLanguageGSS.setName(objMultiLanguageText.isNull("name") ? "" : objMultiLanguageText.getString("name"));
                        multiLanguageGSS.setTitle_group(objMultiLanguageText.isNull("title_group") ? "" : objMultiLanguageText.getString("title_group"));
                        groupSubSupplementInfo.getMultiLanguageTexts().add(multiLanguageGSS);
                    }
                }
                groupsSubOption.add(groupSubSupplementInfo);
            }
            result[4] = groupsSubOption;
        } else {
            result[4] = null;
        }
        if (!obj.isNull("promotions")) {
            ArrayList<PromotionInfo> promotions = new ArrayList<PromotionInfo>();
            JSONArray arrayPromotions = obj.getJSONArray("promotions");
            for (int i3 = 0; i3 < arrayPromotions.length(); ++i3) {
                JSONObject objPromotion = arrayPromotions.getJSONObject(i3);
                PromotionInfo promotion = new PromotionInfo();
                promotion.setId(objPromotion.getInt("id"));
                promotion.setName_promotion(objPromotion.getString("name_promotion"));
                promotion.setType_order(objPromotion.isNull("type_order") ? null : objPromotion.getString("type_order"));
                promotion.setSize_product(objPromotion.isNull("size_product") ? null : objPromotion.getString("size_product"));
                promotion.setQuantity(objPromotion.getDouble("quantity"));
                promotion.setDiscount(objPromotion.getDouble("discount"));
                promotion.setRemoved(objPromotion.getBoolean("removed"));
                promotion.setRemoved_by_admin(objPromotion.getBoolean("removed_by_admin"));
                promotion.setLabel_size_product(objPromotion.isNull("label_size_product") ? null : objPromotion.getString("label_size_product"));
                promotion.setLabel_discount(objPromotion.isNull("label_discount") ? null : objPromotion.getString("label_discount"));
                promotion.setDescription(objPromotion.isNull("description") ? null : objPromotion.getString("description"));
                promotion.setText_promo(objPromotion.isNull("text_promo") ? null : objPromotion.getString("text_promo"));
                if (!objPromotion.isNull("idGlobal")) {
                    promotion.setId_global(objPromotion.getString("idGlobal"));
                }
                if (!objPromotion.isNull("translation")) {
                    JSONArray multiLanguageTexts = objPromotion.getJSONArray("translation");
                    for (int j = 0; j < multiLanguageTexts.length(); ++j) {
                        JSONObject objMultiLanguageText = multiLanguageTexts.getJSONObject(j);
                        MultiLanguagePromotion multiLanguagePromotion = new MultiLanguagePromotion();
                        multiLanguagePromotion.setLanguage(objMultiLanguageText.isNull("langue") ? "" : objMultiLanguageText.getString("langue"));
                        multiLanguagePromotion.setName(objMultiLanguageText.isNull("name_promotion") ? "" : objMultiLanguageText.getString("name_promotion"));
                        multiLanguagePromotion.setDescription(objMultiLanguageText.isNull("description") ? "" : objMultiLanguageText.getString("description"));
                        multiLanguagePromotion.setText_promo(objMultiLanguageText.isNull("text_promo") ? "" : objMultiLanguageText.getString("text_promo"));
                        promotion.getMultiLanguageTexts().add(multiLanguagePromotion);
                    }
                }
                promotions.add(promotion);
            }
            result[5] = promotions;
        } else {
            result[5] = null;
        }
        if (!obj.isNull("screens")) {
            ArrayList<LocalScreen> screens = new ArrayList<LocalScreen>();
            JSONArray arrayScreens = obj.getJSONArray("screens");
            for (int i4 = 0; i4 < arrayScreens.length(); ++i4) {
                JSONObject objScreen = arrayScreens.getJSONObject(i4);
                System.out.println("objScreen : " + objScreen);
                LocalScreen screen = new LocalScreen();
                screen.setId(objScreen.getInt("idScreen"));
                screen.setName(objScreen.getString("name_screen"));
                screen.setNumber(objScreen.getInt("number_screen"));
                screens.add(screen);
            }
            result[6] = screens;
        } else {
            result[6] = null;
        }
        if (!obj.isNull("tags")) {
            ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
            JSONArray arrayTags = obj.getJSONArray("tags");
            for (int i5 = 0; i5 < arrayTags.length(); ++i5) {
                JSONObject objTag = arrayTags.getJSONObject(i5);
                TagInfo mTagInfo = new TagInfo();
                mTagInfo.setId(objTag.getInt("idTag"));
                mTagInfo.setName(objTag.getString("name_tag"));
                mTagInfo.setNumber(objTag.getInt("number_tag"));
                mTagInfo.setDeleted(objTag.getBoolean("deleted"));
                mTagInfo.setLogo_tag(!objTag.isNull("logo_tag") ? objTag.getString("logo_tag") : null);
                mTagInfo.setBackground_catalog(!objTag.isNull("background_catalog") ? objTag.getString("background_catalog") : null);
                mTagInfo.setEnabled(!objTag.isNull("enabled") ? objTag.getBoolean("enabled") : true);
                mTagInfo.setClosed(!objTag.isNull("closed") ? objTag.getBoolean("closed") : false);
                tags.add(mTagInfo);
            }
            result[7] = tags;
        } else {
            result[7] = null;
        }
        if (!obj.isNull("zones")) {
            ArrayList<ZoneInfo> zones = new ArrayList<ZoneInfo>();
            JSONArray arrayZones = obj.getJSONArray("zones");
            for (int i6 = 0; i6 < arrayZones.length(); ++i6) {
                Object element = arrayZones.get(i6);
                if (element instanceof JSONObject) {
                    JSONObject objZone = (JSONObject)element;
                    ZoneInfo mZoneInfo = new ZoneInfo();
                    mZoneInfo.setId(objZone.getInt("id"));
                    mZoneInfo.setName(objZone.getString("name_zone"));
                    mZoneInfo.setPosition(objZone.getInt("position_zone"));
                    mZoneInfo.setColor(Color.decode(objZone.getString("color")));
                    zones.add(mZoneInfo);
                    continue;
                }
                System.err.println("Unexpected non-JSONObject at index " + i6 + ": " + element);
            }
            result[8] = zones;
        } else {
            result[8] = null;
        }
        if (!obj.isNull("nutritional_info")) {
            JSONObject nutritionalInfo = obj.getJSONObject("nutritional_info");
            Iterator keys = nutritionalInfo.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONObject nutrient = nutritionalInfo.getJSONObject(key);
                String imageURL = null;
                String image = nutrient.optString("image", "");
                String color = nutrient.optString("color", "");
                if (nutrient.has("imageURL") && !nutrient.isNull("imageURL")) {
                    imageURL = nutrient.optString("imageURL", "");
                }
                NutrientData mNutrientData = new NutrientData(image, color, key);
                nutrientDatas.add(mNutrientData);
                if (imageURL == null || imageURL.isEmpty()) continue;
                CarteParser.downloadNutriPicture(imageURL, image);
            }
            result[9] = nutrientDatas;
        } else {
            result[9] = null;
        }
        return result;
    }

    public static List<LanguageInfo> parseLanguages(JSONObject obj) {
        if (!obj.isNull("listeLanguages")) {
            ArrayList<LanguageInfo> languages = new ArrayList<LanguageInfo>();
            JSONArray arrayLanguages = obj.getJSONArray("listeLanguages");
            for (int i = 0; i < arrayLanguages.length(); ++i) {
                JSONObject objLanguage = arrayLanguages.getJSONObject(i);
                LanguageInfo language = new LanguageInfo();
                language.setLabel_language(objLanguage.getString("label"));
                language.setCode_language(objLanguage.getString("code"));
                language.setEnabled(objLanguage.getBoolean("isActive"));
                language.setDefault_language(objLanguage.getBoolean("isDefault"));
                languages.add(language);
            }
            return languages;
        }
        return null;
    }

    public static List<String> getPathList(JSONObject obj) {
        int i;
        ArrayList<String> pathList = new ArrayList<String>();
        JSONArray dataCategories = obj.getJSONArray("categories");
        JSONArray dataProducts = obj.getJSONArray("items");
        JSONArray dataOptions = obj.getJSONArray("options");
        for (i = 0; i < dataCategories.length(); ++i) {
            JSONObject objCategory = dataCategories.getJSONObject(i);
            if (!objCategory.isNull("path")) {
                pathList.add(prefix_categories + objCategory.getString("path"));
            }
            if (objCategory.isNull("path_category_moment")) continue;
            pathList.add(prefix_categories + objCategory.getString("path_category_moment"));
        }
        for (i = 0; i < dataProducts.length(); ++i) {
            JSONObject objProduct = dataProducts.getJSONObject(i);
            if (!objProduct.isNull("path")) {
                pathList.add(prefix_products + objProduct.getString("path"));
            }
            if (!objProduct.isNull("path_product_moment")) {
                pathList.add(prefix_products + objProduct.getString("path_product_moment"));
            }
            if (objProduct.isNull("path_platform")) continue;
            pathList.add(prefix_products + objProduct.getString("path_platform"));
        }
        for (i = 0; i < dataOptions.length(); ++i) {
            JSONObject objGOption = dataOptions.getJSONObject(i);
            JSONArray dataOptionItems = objGOption.getJSONArray("items");
            boolean is_ingredient = objGOption.getBoolean("is_ingredient");
            for (int j = 0; j < dataOptionItems.length(); ++j) {
                JSONObject objOptionItem = dataOptionItems.getJSONObject(j);
                if (objOptionItem.isNull("path")) continue;
                if (is_ingredient) {
                    pathList.add(prefix_ingredients + objOptionItem.getString("path"));
                    continue;
                }
                pathList.add(prefix_supplements + objOptionItem.getString("path"));
            }
        }
        return pathList;
    }

    private static Double parseDouble(String value) {
        try {
            return value != null ? Double.valueOf(Double.parseDouble(value)) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void downloadNutriPicture(String link, String path) {
        boolean download = link != null && !link.isEmpty() && path != null && !path.isEmpty();
        try {
            FirebaseService mFirebaseService = FirebaseService.getInstance();
            if (download) {
                mFirebaseService.saveNutriImage(link, path);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }
}

