/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.panels;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializableRead;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.StringUtils;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.DataRead;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.StaticSentence;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PaymentsModel {
    private String m_sHost;
    private int m_iSeq;
    private Date m_dDateStart;
    private Date m_dDateEnd;
    private Date rDate;
    private Integer m_iPayments;
    private Double m_dPaymentsTotal;
    private List<PaymentsLine> m_lpayments;
    private Integer m_iCategorySalesRows;
    private Double m_dCategorySalesTotalUnits;
    private Double m_dCategorySalesTotal;
    private List<CategorySalesLine> m_lcategorysales;
    private Integer m_iProductSalesRows;
    private Double m_dProductSalesTotalUnits;
    private Double m_dProductSalesTotal;
    private List<ProductSalesLine> m_lproductsales;
    private List<RemovedProductLines> m_lremovedlines;
    private static final String[] PAYMENTHEADERS = new String[]{"Label.Payment", "label.Money"};
    private Integer m_iSales;
    private Double m_dSalesBase;
    private Double m_dSalesTaxes;
    private Double m_dSalesTaxNet;
    private List<TaxLineInfo> m_lsales;
    private List<UserCaisseInfo> m_users;
    private static final String[] SALEHEADERS = new String[]{"label.taxcategory", "label.totaltax", "label.totalnet"};

    private PaymentsModel() {
    }

    public static PaymentsModel emptyInstance() {
        PaymentsModel p = new PaymentsModel();
        p.m_iPayments = 0;
        p.m_dPaymentsTotal = 0.0;
        p.m_lpayments = new ArrayList<PaymentsLine>();
        p.m_iCategorySalesRows = 0;
        p.m_dCategorySalesTotalUnits = 0.0;
        p.m_dCategorySalesTotal = 0.0;
        p.m_lcategorysales = new ArrayList<CategorySalesLine>();
        p.m_iSales = null;
        p.m_dSalesBase = null;
        p.m_dSalesTaxes = null;
        p.m_dSalesTaxNet = null;
        p.m_iProductSalesRows = 0;
        p.m_dProductSalesTotalUnits = 0.0;
        p.m_dProductSalesTotal = 0.0;
        p.m_lproductsales = new ArrayList<ProductSalesLine>();
        p.m_lremovedlines = new ArrayList<RemovedProductLines>();
        p.m_lsales = new ArrayList<TaxLineInfo>();
        p.m_users = new ArrayList<UserCaisseInfo>();
        return p;
    }

    public static PaymentsModel loadInstance(AppView app) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        Object[] valcategorysales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(TICKETLINES.UNITS), SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXCATEGORIES.RATE ) * TICKETLINES.UNITS) FROM TICKETLINES, TICKETS, RECEIPTS, TAXCATEGORIES WHERE TICKETLINES.TICKET = TICKETS.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND TICKETLINES.PRODUCT IS NOT NULL AND RECEIPTS.MONEY = ? GROUP BY RECEIPTS.MONEY", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE, Datas.DOUBLE})).find((Object)app.getActiveCashIndex());
        if (valcategorysales == null) {
            p.m_iCategorySalesRows = 0;
            p.m_dCategorySalesTotalUnits = 0.0;
            p.m_dCategorySalesTotal = 0.0;
        } else {
            p.m_iCategorySalesRows = (Integer)valcategorysales[0];
            p.m_dCategorySalesTotalUnits = (Double)valcategorysales[1];
            p.m_dCategorySalesTotal = (Double)valcategorysales[2];
        }
        List categorys = new StaticSentence(app.getSession(), "SELECT a.NAME, sum(c.UNITS), sum(c.UNITS * (c.PRICE + (c.PRICE * d.RATE))) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TAXES as d on c.TAXID = d.ID LEFT JOIN RECEIPTS as e on c.TICKET = e.ID WHERE e.MONEY = ? GROUP BY a.NAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(CategorySalesLine.class)).list((Object)app.getActiveCashIndex());
        p.m_lcategorysales = categorys == null ? new ArrayList<CategorySalesLine>() : categorys;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.MONEY = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)app.getActiveCashIndex());
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.MONEY = ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)app.getActiveCashIndex());
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETLINES WHERE RECEIPTS.ID = TICKETLINES.TICKET AND RECEIPTS.MONEY = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)app.getActiveCashIndex());
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        Object[] rectaxes = (Object[])new StaticSentence(app.getSession(), "SELECT SUM(TAXLINES.AMOUNT), SUM(TAXLINES.BASE) FROM RECEIPTS, TAXLINES WHERE RECEIPTS.ID = TAXLINES.RECEIPT AND RECEIPTS.MONEY = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.DOUBLE})).find((Object)app.getActiveCashIndex());
        if (rectaxes == null) {
            p.m_dSalesTaxes = null;
            p.m_dSalesTaxNet = null;
        } else {
            p.m_dSalesTaxes = (Double)rectaxes[0];
            p.m_dSalesTaxNet = (Double)rectaxes[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TAXLINES.AMOUNT), SUM(TAXLINES.BASE), SUM(TAXLINES.BASE + TAXLINES.AMOUNT) FROM RECEIPTS, TAXLINES, TAXES, TAXCATEGORIES WHERE RECEIPTS.ID = TAXLINES.RECEIPT AND TAXLINES.TAXID = TAXES.ID AND TAXES.CATEGORY = TAXCATEGORIES.ID AND RECEIPTS.MONEY = ?GROUP BY TAXCATEGORIES.NAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(TaxLineInfo.class)).list((Object)app.getActiveCashIndex());
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        SimpleDateFormat ndf = DateUtils.SDF_FULL_DATE_TIME;
        String startDateFormatted = ndf.format(app.getActiveCashDateStart());
        List removedLines = new StaticSentence(app.getSession(), "SELECT LINEREMOVED.NAME, LINEREMOVED.TICKETID, LINEREMOVED.PRODUCTNAME, SUM(LINEREMOVED.UNITS) AS TOTAL_UNITS  FROM LINEREMOVED WHERE LINEREMOVED.REMOVEDDATE > ? GROUP BY LINEREMOVED.NAME, LINEREMOVED.TICKETID, LINEREMOVED.PRODUCTNAME", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(RemovedProductLines.class)).list((Object)startDateFormatted);
        p.m_lremovedlines = removedLines == null ? new ArrayList<RemovedProductLines>() : removedLines;
        Object[] valproductsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(TICKETLINES.UNITS), SUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) FROM TICKETLINES, TICKETS, RECEIPTS, TAXES WHERE TICKETLINES.TICKET = TICKETS.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETLINES.TAXID = TAXES.ID AND TICKETLINES.PRODUCT IS NOT NULL AND RECEIPTS.MONEY = ? GROUP BY RECEIPTS.MONEY", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE, Datas.DOUBLE})).find((Object)app.getActiveCashIndex());
        if (valproductsales == null) {
            p.m_iProductSalesRows = 0;
            p.m_dProductSalesTotalUnits = 0.0;
            p.m_dProductSalesTotal = 0.0;
        } else {
            p.m_iProductSalesRows = (Integer)valproductsales[0];
            p.m_dProductSalesTotalUnits = (Double)valproductsales[1];
            p.m_dProductSalesTotal = (Double)valproductsales[2];
        }
        List products = new StaticSentence(app.getSession(), "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE, TAXES.RATE FROM TICKETLINES, TICKETS, RECEIPTS, PRODUCTS, TAXES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETLINES.TAXID = TAXES.ID AND RECEIPTS.MONEY = ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXES.RATE", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSalesLine.class)).list((Object)app.getActiveCashIndex());
        p.m_lproductsales = products == null ? new ArrayList<ProductSalesLine>() : products;
        return p;
    }

    public static PaymentsModel loadBydate(AppView app, final Date dateStart, final Date dateEnd) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        List categorys = new StaticSentence(app.getSession(), "SELECT a.NAME, sum(c.UNITS), sum(c.UNITS * c.PRICE) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TAXCATEGORIES as d on c.TAXID = d.ID LEFT JOIN TICKETS as t on c.TICKET = t.ID LEFT JOIN RECEIPTS as e on c.TICKET = e.ID LEFT JOIN caisse as f on t.caisse = f.ID WHERE f.token = ? AND t.paid = 1 AND e.DATENEW >= ? AND e.DATENEW <= ? AND c.nextElement = 0 GROUP BY a.NAME", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(CategorySalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        p.m_lcategorysales = categorys == null ? new ArrayList<CategorySalesLine>() : categorys;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETS, caisse, TICKETLINES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID  AND TICKETS.ID = TICKETLINES.TICKET AND caisse.token = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TICKETLINES.taxAmount) FROM RECEIPTS, TICKETS, caisse, TICKETLINES, TAXCATEGORIES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TAXCATEGORIES.RATE <> 0 AND TICKETLINES.nextElement = 0 AND TICKETS.paid = 1 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY TAXCATEGORIES.NAME", SerializerWriteParams.INSTANCE, TaxLineInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        List products = new StaticSentence(app.getSession(), "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE, TAXCATEGORIES.RATE FROM TICKETLINES, TICKETS, caisse, RECEIPTS, PRODUCTS, TAXCATEGORIES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETS.caisse = caisse.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXCATEGORIES.RATE", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        p.m_lproductsales = products == null ? new ArrayList<ProductSalesLine>() : products;
        List users = new StaticSentence(app.getSession(), "SELECT TICKETS.PERSON, SUM(TICKETS.total) FROM RECEIPTS, TICKETS, caisse WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.paid = 1 AND caisse.token = ? AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY TICKETS.PERSON", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        if (users == null) {
            p.m_users = new ArrayList<UserCaisseInfo>();
        } else {
            for (UserCaisseInfo user : users) {
                user.setM_sName(PaymentsModel.getUserById(app, user.getId()).getName());
            }
            p.m_users = users;
        }
        return p;
    }

    public static PaymentsModel loadBydateUser(AppView app, final Date dateStart, final Date dateEnd, final String user) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        List categorys = new StaticSentence(app.getSession(), "SELECT a.NAME, sum(c.UNITS), sum(c.UNITS * c.PRICE) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TAXCATEGORIES as d on c.TAXID = d.ID LEFT JOIN TICKETS as t on c.TICKET = t.ID LEFT JOIN RECEIPTS as e on c.TICKET = e.ID LEFT JOIN caisse as f on t.caisse = f.ID WHERE f.token = ? AND t.PERSON = ?  AND t.paid = 1 AND c.nextElement = 0 AND e.DATENEW >= ? AND e.DATENEW <= ? GROUP BY a.NAME", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(CategorySalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        p.m_lcategorysales = categorys == null ? new ArrayList<CategorySalesLine>() : categorys;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETS, caisse, TICKETLINES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID  AND TICKETS.ID = TICKETLINES.TICKET AND caisse.token = ? AND TICKETS.PERSON = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TICKETLINES.taxAmount) FROM RECEIPTS, TICKETS, caisse, TICKETLINES, TAXCATEGORIES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND TAXCATEGORIES.RATE <> 0 AND TICKETS.paid = 1 AND  TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY TAXCATEGORIES.NAME", SerializerWriteParams.INSTANCE, TaxLineInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        List products = new StaticSentence(app.getSession(), "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE, TAXCATEGORIES.RATE FROM TICKETLINES, TICKETS, caisse, RECEIPTS, PRODUCTS, TAXCATEGORIES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETS.caisse = caisse.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? AND RECEIPTS.DATENEW <= ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXCATEGORIES.RATE", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        p.m_lproductsales = products == null ? new ArrayList<ProductSalesLine>() : products;
        return p;
    }

    public static PaymentsModel loadByMonth(AppView app, final int year, final int month) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        List categorys = new StaticSentence(app.getSession(), "SELECT a.NAME, sum(c.UNITS), sum(c.UNITS * c.PRICE) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TAXCATEGORIES as d on c.TAXID = d.ID LEFT JOIN TICKETS as t on c.TICKET = t.ID LEFT JOIN RECEIPTS as e on c.TICKET = e.ID LEFT JOIN caisse as f on t.caisse = f.ID WHERE f.token = ? AND t.paid = 1 AND c.nextElement = 0 AND YEAR(e.DATENEW) = ? AND MONTH(e.DATENEW) = ? GROUP BY a.NAME", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(CategorySalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        p.m_lcategorysales = categorys == null ? new ArrayList<CategorySalesLine>() : categorys;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID  AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETS, caisse, TICKETLINES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND caisse.token = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement =0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TICKETLINES.taxAmount) FROM RECEIPTS, TICKETS, caisse, TICKETLINES, TAXCATEGORIES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TAXCATEGORIES.RATE <> 0 AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY TAXCATEGORIES.NAME", SerializerWriteParams.INSTANCE, TaxLineInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        List products = new StaticSentence(app.getSession(), "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE, TAXCATEGORIES.RATE FROM TICKETLINES, TICKETS, caisse, RECEIPTS, PRODUCTS, TAXCATEGORIES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXCATEGORIES.RATE", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        p.m_lproductsales = products == null ? new ArrayList<ProductSalesLine>() : products;
        List users = new StaticSentence(app.getSession(), "SELECT TICKETS.PERSON, SUM(TICKETS.total) FROM RECEIPTS, TICKETS, caisse WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.paid = 1 AND caisse.token = ? AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY TICKETS.PERSON", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setInt(2, year);
                this.setInt(3, month);
            }
        });
        if (users == null) {
            p.m_users = new ArrayList<UserCaisseInfo>();
        } else {
            for (UserCaisseInfo user : users) {
                user.setM_sName(PaymentsModel.getUserById(app, user.getId()).getName());
            }
            p.m_users = users;
        }
        return p;
    }

    public static PaymentsModel loadByMonthUser(AppView app, final int year, final int month, final String user) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        List categorys = new StaticSentence(app.getSession(), "SELECT a.NAME, sum(c.UNITS), sum(c.UNITS * c.PRICE) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TAXCATEGORIES as d on c.TAXID = d.ID LEFT JOIN TICKETS as t on c.TICKET = t.ID LEFT JOIN RECEIPTS as e on c.TICKET = e.ID LEFT JOIN caisse as f on t.caisse = f.ID WHERE f.token = ? AND t.PERSON = ? AND t.paid = 1 AND c.nextElement = 0 AND YEAR(e.DATENEW) = ? AND MONTH(e.DATENEW) = ? GROUP BY a.NAME", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(CategorySalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        p.m_lcategorysales = categorys == null ? new ArrayList<CategorySalesLine>() : categorys;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID  AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETS, caisse, TICKETLINES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND caisse.token = ? AND TICKETS.PERSON = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TICKETLINES.taxAmount) FROM RECEIPTS, TICKETS, caisse, TICKETLINES, TAXES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND TAXCATEGORIES.RATE <> 0 AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY TAXCATEGORIES.NAME", SerializerWriteParams.INSTANCE, TaxLineInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        List products = new StaticSentence(app.getSession(), "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE, TAXCATEGORIES.RATE FROM TICKETLINES, TICKETS, caisse, RECEIPTS, PRODUCTS, TAXCATEGORIES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = RECEIPTS.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND YEAR(RECEIPTS.DATENEW) = ? AND MONTH(RECEIPTS.DATENEW) = ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXCATEGORIES.RATE", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(ProductSalesLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setString(2, user);
                this.setInt(3, year);
                this.setInt(4, month);
            }
        });
        p.m_lproductsales = products == null ? new ArrayList<ProductSalesLine>() : products;
        return p;
    }

    public static PaymentsModel loadBydateOpen(AppView app, final Date dateOpen) throws BasicException {
        PaymentsModel p = new PaymentsModel();
        p.m_sHost = app.getProperties().getHost();
        p.m_iSeq = app.getActiveCashSequence();
        p.m_dDateStart = app.getActiveCashDateStart();
        p.m_dDateEnd = null;
        Object[] valtickets = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(*), SUM(PAYMENTS.TOTAL) FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND RECEIPTS.DATENEW >= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateOpen);
            }
        });
        if (valtickets == null) {
            p.m_iPayments = 0;
            p.m_dPaymentsTotal = 0.0;
        } else {
            p.m_iPayments = (Integer)valtickets[0];
            p.m_dPaymentsTotal = (Double)valtickets[1];
        }
        List l = new StaticSentence(app.getSession(), "SELECT PAYMENTS.PAYMENT, SUM(PAYMENTS.TOTAL)FROM PAYMENTS, RECEIPTS, TICKETS, caisse WHERE PAYMENTS.RECEIPT = RECEIPTS.ID AND RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND caisse.token = ? AND RECEIPTS.DATENEW >= ? GROUP BY PAYMENTS.PAYMENT", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadClass(PaymentsLine.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateOpen);
            }
        });
        p.m_lpayments = l == null ? new ArrayList<PaymentsLine>() : l;
        Object[] recsales = (Object[])new StaticSentence(app.getSession(), "SELECT COUNT(DISTINCT RECEIPTS.ID), SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) FROM RECEIPTS, TICKETS, caisse, TICKETLINES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID  AND TICKETS.ID = TICKETLINES.TICKET AND caisse.token = ? AND TICKETS.paid = 1 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateOpen);
            }
        });
        if (recsales == null) {
            p.m_iSales = null;
            p.m_dSalesBase = null;
        } else {
            p.m_iSales = (Integer)recsales[0];
            p.m_dSalesBase = (Double)recsales[1];
        }
        List asales = new StaticSentence(app.getSession(), "SELECT TAXCATEGORIES.NAME, SUM(TICKETLINES.taxAmount)FROM RECEIPTS, TICKETS, caisse, TICKETLINES, TAXCATEGORIES WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.ID = TICKETLINES.TICKET AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND caisse.token = ? AND TAXCATEGORIES.RATE <> 0 AND TICKETLINES.nextElement = 0 AND RECEIPTS.DATENEW >= ? GROUP BY TAXCATEGORIES.NAME", SerializerWriteParams.INSTANCE, TaxLineInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateOpen);
            }
        });
        p.m_lsales = asales == null ? new ArrayList<TaxLineInfo>() : asales;
        List users = new StaticSentence(app.getSession(), "SELECT TICKETS.PERSON, SUM(TICKETS.total) FROM RECEIPTS, TICKETS, caisse WHERE RECEIPTS.ID = TICKETS.ID AND TICKETS.caisse = caisse.ID AND TICKETS.paid = 1 AND caisse.token = ? AND RECEIPTS.DATENEW >= ? GROUP BY TICKETS.PERSON", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateOpen);
            }
        });
        if (users == null) {
            p.m_users = new ArrayList<UserCaisseInfo>();
        } else {
            for (UserCaisseInfo user : users) {
                user.setM_sName(PaymentsModel.getUserById(app, user.getId()).getName());
            }
            p.m_users = users;
        }
        return p;
    }

    public int getPayments() {
        return this.m_iPayments;
    }

    public static UserInfo getUserById(AppView app, String userID) throws BasicException {
        UserInfo user = (UserInfo)new StaticSentence(app.getSession(), "SELECT P.ID, P.NAME,C.ID AS CODEUSERFROM PEOPLE P LEFT JOIN COUNTER_USER C ON P.ID = C.ID_USER WHERE ID = ? ", SerializerWriteString.INSTANCE, UserInfo.getSerializerRead()).find((Object)userID);
        return user;
    }

    public double getTotal() {
        return this.m_dPaymentsTotal;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public int getSequence() {
        return this.m_iSeq;
    }

    public Date getDateStart() {
        return this.m_dDateStart;
    }

    public void setDateEnd(Date dValue) {
        this.m_dDateEnd = dValue;
    }

    public Date getDateEnd() {
        return this.m_dDateEnd;
    }

    public String getDateStartDerby() {
        SimpleDateFormat ndf = DateUtils.SDF_FULL_DATE_TIME;
        return ndf.format(this.m_dDateStart);
    }

    public String printHost() {
        return StringUtils.encodeXML(this.m_sHost);
    }

    public String printSequence() {
        return Formats.INT.formatValue(this.m_iSeq);
    }

    public Double getTaxTotal() {
        Double sum = 0.0;
        for (TaxLineInfo m_lsale : this.m_lsales) {
            sum = sum + m_lsale.getAmount();
        }
        return sum;
    }

    public String printTaxTotal() {
        return Formats.CURRENCY.formatValue(this.getTaxTotal());
    }

    public String printDateStart() {
        return Formats.TIMESTAMP.formatValue(this.m_dDateStart);
    }

    public String printDateEnd() {
        return Formats.TIMESTAMP.formatValue(this.m_dDateEnd);
    }

    public String printPayments() {
        return Formats.INT.formatValue(this.m_iPayments);
    }

    public String printPaymentsTotal() {
        return Formats.CURRENCY.formatValue(this.m_dPaymentsTotal);
    }

    public List<PaymentsLine> getPaymentLines() {
        return this.m_lpayments;
    }

    public int getSales() {
        return this.m_iSales == null ? 0 : this.m_iSales;
    }

    public String printSales() {
        return Formats.INT.formatValue(this.m_iSales);
    }

    public String printSalesTotal() {
        return Formats.CURRENCY.formatValue(this.m_dSalesBase);
    }

    public Double getPrintSalesTotal() {
        return this.m_dSalesBase;
    }

    public Double getSalesBase() {
        return this.m_dSalesBase - this.getTaxTotal();
    }

    public String printSalesBase() {
        return Formats.CURRENCY.formatValue(this.getSalesBase());
    }

    public String printSalesTaxes() {
        return Formats.CURRENCY.formatValue(this.m_dSalesTaxes);
    }

    public List<TaxLineInfo> getSaleLines() {
        return this.m_lsales;
    }

    public double getCategorySalesRows() {
        return this.m_iCategorySalesRows.intValue();
    }

    public String printCategorySalesRows() {
        return Formats.INT.formatValue(this.m_iCategorySalesRows);
    }

    public double getCategorySalesTotalUnits() {
        return this.m_dCategorySalesTotalUnits;
    }

    public String printCategorySalesTotalUnits() {
        return Formats.DOUBLE.formatValue(this.m_dCategorySalesTotalUnits);
    }

    public double getCategorySalesTotal() {
        Double sum = 0.0;
        for (CategorySalesLine m_lcategorysale : this.m_lcategorysales) {
            sum = sum + m_lcategorysale.getCategorySum();
        }
        return sum;
    }

    public String printCategorySalesTotal() {
        return Formats.CURRENCY.formatValue(this.getCategorySalesTotal());
    }

    public List<CategorySalesLine> getCategorySalesLines() {
        return this.m_lcategorysales;
    }

    public double getProductSalesRows() {
        return this.m_iProductSalesRows.intValue();
    }

    public String printProductSalesRows() {
        return Formats.INT.formatValue(this.m_iProductSalesRows);
    }

    public double getProductSalesTotalUnits() {
        return this.m_dProductSalesTotalUnits;
    }

    public String printProductSalesTotalUnits() {
        return Formats.DOUBLE.formatValue(this.m_dProductSalesTotalUnits);
    }

    public double getProductSalesTotal() {
        return this.m_dProductSalesTotal;
    }

    public String printProductSalesTotal() {
        return Formats.CURRENCY.formatValue(this.m_dProductSalesTotal);
    }

    public List<ProductSalesLine> getProductSalesLines() {
        return this.m_lproductsales;
    }

    public Double getProductTotalPrice() {
        Double sum = 0.0;
        for (ProductSalesLine m_lproductsale : this.m_lproductsales) {
            sum = sum + m_lproductsale.getProductPriceTotal();
        }
        return sum;
    }

    public String printProductTotalPrice() {
        return Formats.CURRENCY.formatValue(this.getProductTotalPrice());
    }

    public Double getCategoryTotalPrice() {
        Double sum = 0.0;
        for (CategorySalesLine m_lcategorysale : this.m_lcategorysales) {
            sum = sum + m_lcategorysale.getCategorySum();
        }
        return sum;
    }

    public String printCategoryTotalPrice() {
        return Formats.CURRENCY.formatValue(this.getCategoryTotalPrice());
    }

    public List<RemovedProductLines> getRemovedProductLines() {
        return this.m_lremovedlines;
    }

    public List<UserCaisseInfo> getM_users() {
        return this.m_users;
    }

    public AbstractTableModel getPaymentsModel() {
        return new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return AppLocal.getIntString(PAYMENTHEADERS[column]);
            }

            @Override
            public int getRowCount() {
                return PaymentsModel.this.m_lpayments.size();
            }

            @Override
            public int getColumnCount() {
                return PAYMENTHEADERS.length;
            }

            @Override
            public Object getValueAt(int row, int column) {
                PaymentsLine l = PaymentsModel.this.m_lpayments.get(row);
                switch (column) {
                    case 0: {
                        return l.getType();
                    }
                    case 1: {
                        return l.getValue();
                    }
                }
                return null;
            }
        };
    }

    public static class CategorySalesLine
    implements SerializableRead {
        private String m_CategoryName;
        private Double m_CategoryUnits;
        private Double m_CategorySum;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_CategoryName = dr.getString(1);
            this.m_CategoryUnits = dr.getDouble(2);
            this.m_CategorySum = dr.getDouble(3);
        }

        public String printCategoryName() {
            return this.m_CategoryName;
        }

        public String printCategoryUnits() {
            return Formats.DOUBLE.formatValue(this.m_CategoryUnits);
        }

        public Double getCategoryUnits() {
            return this.m_CategoryUnits;
        }

        public String printCategorySum() {
            return Formats.CURRENCY.formatValue(this.m_CategorySum);
        }

        public Double getCategorySum() {
            return this.m_CategorySum;
        }
    }

    public static class PaymentsLine
    implements SerializableRead {
        private String m_PaymentType;
        private Double m_PaymentValue;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_PaymentType = dr.getString(1);
            this.m_PaymentValue = dr.getDouble(2);
        }

        public String printType() {
            return this.m_PaymentType;
        }

        public String getType() {
            return this.m_PaymentType;
        }

        public String printValue() {
            return Formats.CURRENCY.formatValue(this.m_PaymentValue);
        }

        public Double getValue() {
            return this.m_PaymentValue;
        }
    }

    public static class RemovedProductLines
    implements SerializableRead {
        private String m_Name;
        private String m_TicketId;
        private String m_ProductName;
        private Double m_TotalUnits;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_Name = dr.getString(1);
            this.m_TicketId = dr.getString(2);
            this.m_ProductName = dr.getString(3);
            this.m_TotalUnits = dr.getDouble(4);
        }

        public String printWorkerName() {
            return StringUtils.encodeXML(this.m_Name);
        }

        public String printTicketId() {
            return StringUtils.encodeXML(this.m_TicketId);
        }

        public String printProductName() {
            return StringUtils.encodeXML(this.m_ProductName);
        }

        public String printTotalUnits() {
            return Formats.DOUBLE.formatValue(this.m_TotalUnits);
        }
    }

    public static class ProductSalesLine
    implements SerializableRead {
        private String m_ProductName;
        private Double m_ProductUnits;
        private Double m_ProductPrice;
        private Double m_TaxRate;
        private Double m_ProductPriceTotal;

        @Override
        public void readValues(DataRead dr) throws BasicException {
            this.m_ProductName = dr.getString(1);
            this.m_ProductUnits = dr.getDouble(2);
            this.m_ProductPrice = dr.getDouble(3);
            this.m_TaxRate = dr.getDouble(4);
            this.m_ProductPriceTotal = this.m_ProductPrice * this.m_ProductUnits;
        }

        public String printProductName() {
            return StringUtils.encodeXML(this.m_ProductName);
        }

        public String printProductUnits() {
            return Formats.DOUBLE.formatValue(this.m_ProductUnits);
        }

        public Double getProductUnits() {
            return this.m_ProductUnits;
        }

        public String printProductPrice() {
            return Formats.CURRENCY.formatValue(this.m_ProductPrice);
        }

        public Double getProductPrice() {
            return this.m_ProductPrice;
        }

        public String printTaxRate() {
            return Formats.PERCENT.formatValue(this.m_TaxRate);
        }

        public Double getTaxRate() {
            return this.m_TaxRate;
        }

        public String printProductPriceTax() {
            return Formats.CURRENCY.formatValue(this.m_ProductPrice);
        }

        public Double getProductPriceTotal() {
            return this.m_ProductPriceTotal;
        }

        public String printProductSubValue() {
            return Formats.CURRENCY.formatValue(this.m_ProductPriceTotal);
        }

        public String printProductPriceNet() {
            return Formats.CURRENCY.formatValue(this.m_ProductPrice);
        }
    }
}

