/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.panels;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.gui.TableRendererBasic;
import com.openbravo.data.loader.SerializerWrite;
import com.openbravo.data.loader.SerializerWriteBasic;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.printer.TicketParser;
import com.openbravo.pos.scripting.ScriptEngine;
import com.openbravo.pos.scripting.ScriptFactory;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.StaticSentence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class JPanelCloseMoney
extends JPanel
implements JPanelView,
BeanFactoryApp {
    private AppView m_App;
    private DataLogicSystem m_dlSystem;
    private PaymentsModel m_PaymentsToClose = null;
    private TicketParser m_TTP;
    private final DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private Session s;
    private Connection con;
    private Statement stmt;
    private Integer result;
    private String SQL;
    private ResultSet rs;
    private AppUser m_User;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelBottom;
    private JPanel jPanelTop;
    private JSeparator jSeparator1;
    private JTextField m_jCash;
    private JButton m_jCloseCash;
    private JButton m_jCloseCashTop;
    private JTextField m_jCount;
    private JTextField m_jMaxDate;
    private JTextField m_jMinDate;
    private JTextField m_jNoCashSales;
    private JButton m_jPrintCash;
    private JButton m_jPrintCashTop;
    private JTextField m_jSales;
    private JTextField m_jSalesSubtotal;
    private JTextField m_jSalesTaxes;
    private JTextField m_jSalesTotal;
    private JScrollPane m_jScrollSales;
    private JScrollPane m_jScrollTableTicket;
    private JTextField m_jSequence;
    private JTable m_jTicketTable;
    private JTable m_jsalestable;

    public JPanelCloseMoney() {
        this.initComponents();
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.m_dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.m_TTP = new TicketParser(this.m_App.getDeviceTicket(), this.m_dlSystem);
        this.m_jTicketTable.setDefaultRenderer(Object.class, new TableRendererBasic(new Formats[]{new FormatsPayment(), Formats.CURRENCY}));
        this.m_jTicketTable.setAutoResizeMode(0);
        this.m_jScrollTableTicket.getVerticalScrollBar().setPreferredSize(new Dimension(25, 25));
        this.m_jTicketTable.getTableHeader().setReorderingAllowed(false);
        this.m_jTicketTable.setRowHeight(25);
        this.m_jTicketTable.getSelectionModel().setSelectionMode(0);
        this.m_jsalestable.setDefaultRenderer(Object.class, new TableRendererBasic(new Formats[]{Formats.STRING, Formats.CURRENCY, Formats.CURRENCY, Formats.CURRENCY}));
        this.m_jsalestable.setAutoResizeMode(0);
        this.m_jScrollSales.getVerticalScrollBar().setPreferredSize(new Dimension(25, 25));
        this.m_jsalestable.getTableHeader().setReorderingAllowed(false);
        this.m_jsalestable.setRowHeight(25);
        this.m_jsalestable.getSelectionModel().setSelectionMode(0);
        this.jPanelTop.setVisible(false);
        if (this.m_App.getProperties().getProperty("screen.600800") != null) {
            if (Boolean.valueOf(this.m_App.getProperties().getProperty("screen.600800")).booleanValue()) {
                this.jPanelTop.setVisible(true);
                this.jPanelBottom.setVisible(false);
            } else {
                this.jPanelTop.setVisible(false);
                this.jPanelBottom.setVisible(true);
            }
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.CloseTPV");
    }

    @Override
    public void activate() throws BasicException {
        this.loadData();
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    private void loadData() throws BasicException {
        this.m_jSequence.setText(null);
        this.m_jMinDate.setText(null);
        this.m_jMaxDate.setText(null);
        this.m_jPrintCash.setEnabled(false);
        this.m_jCloseCash.setEnabled(false);
        this.m_jPrintCashTop.setEnabled(false);
        this.m_jCloseCashTop.setEnabled(false);
        this.m_jCount.setText(null);
        this.m_jCash.setText(null);
        this.m_jSales.setText(null);
        this.m_jSalesSubtotal.setText(null);
        this.m_jSalesTaxes.setText(null);
        this.m_jSalesTotal.setText(null);
        this.m_jTicketTable.setModel(new DefaultTableModel());
        this.m_jsalestable.setModel(new DefaultTableModel());
        this.m_PaymentsToClose = PaymentsModel.loadInstance(this.m_App);
        this.m_jSequence.setText(this.m_PaymentsToClose.printSequence());
        this.m_jMinDate.setText(this.m_PaymentsToClose.printDateStart());
        this.m_jMaxDate.setText(this.m_PaymentsToClose.printDateEnd());
        if (this.m_PaymentsToClose.getPayments() != 0 || this.m_PaymentsToClose.getSales() != 0) {
            this.m_jPrintCash.setEnabled(true);
            this.m_jCloseCash.setEnabled(true);
            this.m_jPrintCashTop.setEnabled(true);
            this.m_jCloseCashTop.setEnabled(true);
            this.m_jCount.setText(this.m_PaymentsToClose.printPayments());
            this.m_jCash.setText(this.m_PaymentsToClose.printPaymentsTotal());
            this.m_jSales.setText(this.m_PaymentsToClose.printSales());
            this.m_jSalesSubtotal.setText(this.m_PaymentsToClose.printSalesBase());
            this.m_jSalesTaxes.setText(this.m_PaymentsToClose.printSalesTaxes());
            this.m_jSalesTotal.setText(this.m_PaymentsToClose.printSalesTotal());
        }
        this.m_jTicketTable.setModel(this.m_PaymentsToClose.getPaymentsModel());
        TableColumnModel jColumns = this.m_jTicketTable.getColumnModel();
        jColumns.getColumn(0).setPreferredWidth(178);
        jColumns.getColumn(0).setResizable(false);
        jColumns.getColumn(1).setPreferredWidth(80);
        jColumns.getColumn(1).setResizable(false);
        jColumns = this.m_jsalestable.getColumnModel();
        jColumns.getColumn(0).setPreferredWidth(108);
        jColumns.getColumn(0).setResizable(false);
        jColumns.getColumn(1).setPreferredWidth(75);
        jColumns.getColumn(1).setResizable(false);
        jColumns.getColumn(2).setPreferredWidth(75);
        jColumns.getColumn(2).setResizable(false);
        try {
            this.result = 0;
            this.s = this.m_App.getSession();
            this.con = this.s.getConnection();
            String sdbmanager = this.m_dlSystem.getDBVersion();
            this.SQL = "PostgreSQL".equals(sdbmanager) ? "SELECT * FROM DRAWEROPENED WHERE TICKETID = 'No Sale' AND OPENDATE > '" + this.m_PaymentsToClose.printDateStart() + "'" : "SELECT * FROM DRAWEROPENED WHERE TICKETID = 'No Sale' AND OPENDATE > {fn TIMESTAMP('" + this.m_PaymentsToClose.getDateStartDerby() + "')}";
            this.stmt = this.con.createStatement();
            this.rs = this.stmt.executeQuery(this.SQL);
            while (this.rs.next()) {
                Integer n = this.result;
                this.result = this.result + 1;
            }
            this.rs = null;
            this.con = null;
            this.s = null;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_jNoCashSales.setText(this.result.toString());
    }

    private void printPayments(String report) {
        String sresource = this.m_dlSystem.getResourceAsXML(report);
        if (sresource == null) {
            MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"));
            msg.show(this);
        } else {
            try {
                ScriptEngine script = ScriptFactory.getScriptEngine("velocity");
                script.put("payments", this.m_PaymentsToClose);
                script.put("nosales", this.result.toString());
                this.m_TTP.printTicket(script.eval(sresource).toString());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.cannotprintticket"), ex);
                msg.show(this);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel11 = new JLabel();
        this.m_jSequence = new JTextField();
        this.jLabel2 = new JLabel();
        this.m_jMinDate = new JTextField();
        this.jLabel3 = new JLabel();
        this.m_jMaxDate = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel5 = new JPanel();
        this.m_jScrollTableTicket = new JScrollPane();
        this.m_jTicketTable = new JTable();
        this.jLabel1 = new JLabel();
        this.m_jCount = new JTextField();
        this.jLabel4 = new JLabel();
        this.m_jCash = new JTextField();
        this.jLabel5 = new JLabel();
        this.m_jSales = new JTextField();
        this.jLabel6 = new JLabel();
        this.m_jSalesSubtotal = new JTextField();
        this.m_jScrollSales = new JScrollPane();
        this.m_jsalestable = new JTable();
        this.m_jSalesTaxes = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel7 = new JLabel();
        this.m_jSalesTotal = new JTextField();
        this.jLabel8 = new JLabel();
        this.m_jNoCashSales = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanelTop = new JPanel();
        this.m_jCloseCashTop = new JButton();
        this.m_jPrintCashTop = new JButton();
        this.jPanelBottom = new JPanel();
        this.m_jCloseCash = new JButton();
        this.m_jPrintCash = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setFont(new Font("Tahoma", 0, 10));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, AppLocal.getIntString("label.datestitle"), 0, 0, AppLocal.FONT_ARIAL_BOLD_14));
        this.jLabel11.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel11.setText(AppLocal.getIntString("label.sequence"));
        this.m_jSequence.setEditable(false);
        this.m_jSequence.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jSequence.setHorizontalAlignment(4);
        this.jLabel2.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(AppLocal.getIntString("Label.StartDate"));
        this.m_jMinDate.setEditable(false);
        this.m_jMinDate.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jMinDate.setHorizontalAlignment(4);
        this.jLabel3.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(AppLocal.getIntString("Label.EndDate"));
        this.m_jMaxDate.setEditable(false);
        this.m_jMaxDate.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jMaxDate.setHorizontalAlignment(4);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap(48, Short.MAX_VALUE).addComponent(this.jLabel11, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jSequence, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jMinDate, -2, 160, -2).addGap(10, 10, 10).addComponent(this.jLabel3, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jMaxDate, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler1, -2, 0, -2).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11, -2, 25, -2).addComponent(this.m_jSequence, -2, 25, -2).addComponent(this.jLabel2, -2, 25, -2).addComponent(this.m_jMinDate, -2, 25, -2).addComponent(this.jLabel3, -2, 25, -2).addComponent(this.m_jMaxDate, -2, 25, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.filler1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, AppLocal.getIntString("label.paymentstitle"), 0, 0, AppLocal.FONT_ARIAL_BOLD_14));
        this.m_jScrollTableTicket.setBorder(null);
        this.m_jScrollTableTicket.setFont(new Font("Arial", 0, 11));
        this.m_jScrollTableTicket.setMinimumSize(new Dimension(350, 140));
        this.m_jScrollTableTicket.setPreferredSize(new Dimension(350, 140));
        this.m_jTicketTable.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jTicketTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.m_jTicketTable.setFocusable(false);
        this.m_jTicketTable.setIntercellSpacing(new Dimension(0, 1));
        this.m_jTicketTable.setRequestFocusEnabled(false);
        this.m_jTicketTable.setShowVerticalLines(false);
        this.m_jScrollTableTicket.setViewportView(this.m_jTicketTable);
        this.jLabel1.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel1.setText(AppLocal.getIntString("Label.Tickets"));
        this.m_jCount.setEditable(false);
        this.m_jCount.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jCount.setHorizontalAlignment(4);
        this.jLabel4.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.jLabel4.setText(AppLocal.getIntString("label.Money"));
        this.m_jCash.setEditable(false);
        this.m_jCash.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.m_jCash.setHorizontalAlignment(4);
        this.jLabel5.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel5.setText(AppLocal.getIntString("label.sales"));
        this.m_jSales.setEditable(false);
        this.m_jSales.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jSales.setHorizontalAlignment(4);
        this.jLabel6.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel6.setText(AppLocal.getIntString("label.totalnet"));
        this.m_jSalesSubtotal.setEditable(false);
        this.m_jSalesSubtotal.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jSalesSubtotal.setHorizontalAlignment(4);
        this.m_jScrollSales.setBorder(null);
        this.m_jScrollSales.setFont(new Font("Arial", 0, 11));
        this.m_jsalestable.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jsalestable.setFocusable(false);
        this.m_jsalestable.setIntercellSpacing(new Dimension(0, 1));
        this.m_jsalestable.setRequestFocusEnabled(false);
        this.m_jsalestable.setShowVerticalLines(false);
        this.m_jScrollSales.setViewportView(this.m_jsalestable);
        this.m_jSalesTaxes.setEditable(false);
        this.m_jSalesTaxes.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jSalesTaxes.setHorizontalAlignment(4);
        this.jLabel12.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel12.setText(AppLocal.getIntString("label.taxes"));
        this.jLabel7.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.jLabel7.setText(AppLocal.getIntString("label.total"));
        this.m_jSalesTotal.setEditable(false);
        this.m_jSalesTotal.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.m_jSalesTotal.setHorizontalAlignment(4);
        this.m_jSalesTotal.setPreferredSize(new Dimension(6, 21));
        this.jLabel8.setFont(new Font("Arial", 1, 11));
        this.jLabel8.setHorizontalAlignment(4);
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jLabel8.setText(bundle.getString("label.nocashsales"));
        this.m_jNoCashSales.setEditable(false);
        this.m_jNoCashSales.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jNoCashSales.setHorizontalAlignment(4);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.m_jScrollTableTicket, -2, 260, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jScrollSales, -2, 260, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.m_jCash, -2, 101, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.m_jNoCashSales, -2, 100, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, GroupLayout.Alignment.LEADING, -1, 74, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel7, -2, 74, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_jSalesTotal, -1, -1, Short.MAX_VALUE).addComponent(this.m_jSalesSubtotal).addComponent(this.m_jCount).addComponent(this.m_jSalesTaxes, -1, 100, Short.MAX_VALUE).addComponent(this.m_jSales, -1, 100, Short.MAX_VALUE)))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(17, 17, 17).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 25, -2).addComponent(this.m_jCount, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jSales, -2, 25, -2).addComponent(this.jLabel5, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, 25, -2).addComponent(this.m_jSalesSubtotal, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12, -2, 25, -2).addComponent(this.m_jSalesTaxes, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jSalesTotal, -2, 25, -2).addComponent(this.jLabel7, -2, 25, -2)).addGap(18, 18, 18).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jCash, -2, 25, -2).addComponent(this.jLabel4, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addGap(1, 1, 1).addComponent(this.jLabel8, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jNoCashSales, -2, 25, -2)).addComponent(this.m_jScrollSales, -2, 301, -2).addComponent(this.m_jScrollTableTicket, -2, 301, -2)).addGap(0, 14, Short.MAX_VALUE)));
        this.jPanelTop.setEnabled(false);
        this.m_jCloseCashTop.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jCloseCashTop.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/calculator.png")));
        this.m_jCloseCashTop.setText(AppLocal.getIntString("Button.CloseCash"));
        this.m_jCloseCashTop.setHorizontalAlignment(2);
        this.m_jCloseCashTop.setIconTextGap(2);
        this.m_jCloseCashTop.setInheritsPopupMenu(true);
        this.m_jCloseCashTop.setMaximumSize(new Dimension(85, 33));
        this.m_jCloseCashTop.setMinimumSize(new Dimension(85, 33));
        this.m_jCloseCashTop.setPreferredSize(new Dimension(85, 33));
        this.m_jCloseCashTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCloseMoney.this.m_jCloseCashTopActionPerformed(evt);
            }
        });
        this.m_jPrintCashTop.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jPrintCashTop.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/printer.png")));
        this.m_jPrintCashTop.setText(AppLocal.getIntString("Button.PrintCash"));
        this.m_jPrintCashTop.setHorizontalAlignment(2);
        this.m_jPrintCashTop.setIconTextGap(2);
        this.m_jPrintCashTop.setMaximumSize(new Dimension(85, 33));
        this.m_jPrintCashTop.setMinimumSize(new Dimension(85, 33));
        this.m_jPrintCashTop.setPreferredSize(new Dimension(85, 33));
        this.m_jPrintCashTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCloseMoney.this.m_jPrintCashTopActionPerformed(evt);
            }
        });
        GroupLayout jPanelTopLayout = new GroupLayout(this.jPanelTop);
        this.jPanelTop.setLayout(jPanelTopLayout);
        jPanelTopLayout.setHorizontalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTopLayout.createSequentialGroup().addComponent(this.m_jPrintCashTop, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jCloseCashTop, -2, 140, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelTopLayout.setVerticalGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelTopLayout.createSequentialGroup().addGroup(jPanelTopLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_jPrintCashTop, -2, 45, -2).addComponent(this.m_jCloseCashTop, -2, 45, -2)).addContainerGap()));
        this.m_jCloseCash.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jCloseCash.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/calculator.png")));
        this.m_jCloseCash.setText(AppLocal.getIntString("Button.CloseCash"));
        this.m_jCloseCash.setHorizontalAlignment(2);
        this.m_jCloseCash.setIconTextGap(2);
        this.m_jCloseCash.setInheritsPopupMenu(true);
        this.m_jCloseCash.setMaximumSize(new Dimension(85, 33));
        this.m_jCloseCash.setMinimumSize(new Dimension(85, 33));
        this.m_jCloseCash.setPreferredSize(new Dimension(85, 33));
        this.m_jCloseCash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCloseMoney.this.m_jCloseCashActionPerformed(evt);
            }
        });
        this.m_jPrintCash.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jPrintCash.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/printer.png")));
        this.m_jPrintCash.setText(AppLocal.getIntString("Button.PrintCash"));
        this.m_jPrintCash.setHorizontalAlignment(2);
        this.m_jPrintCash.setIconTextGap(2);
        this.m_jPrintCash.setMaximumSize(new Dimension(85, 33));
        this.m_jPrintCash.setMinimumSize(new Dimension(85, 33));
        this.m_jPrintCash.setPreferredSize(new Dimension(85, 33));
        this.m_jPrintCash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCloseMoney.this.m_jPrintCashActionPerformed(evt);
            }
        });
        GroupLayout jPanelBottomLayout = new GroupLayout(this.jPanelBottom);
        this.jPanelBottom.setLayout(jPanelBottomLayout);
        jPanelBottomLayout.setHorizontalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelBottomLayout.createSequentialGroup().addContainerGap().addComponent(this.m_jPrintCash, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jCloseCash, -2, 140, -2).addContainerGap(55, Short.MAX_VALUE)));
        jPanelBottomLayout.setVerticalGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBottomLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_jCloseCash, -2, 45, -2).addComponent(this.m_jPrintCash, -2, 45, -2)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelBottom, -2, -1, -2).addComponent(this.jPanelTop, -2, -1, -2).addComponent(this.jPanel4, -2, -1, -2).addComponent(this.jPanel5, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jPanelTop, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanelBottom, -2, -1, -2).addContainerGap()));
        this.add((Component)this.jPanel1, "Center");
    }

    private void m_jPrintCashTopActionPerformed(ActionEvent evt) {
        this.printPayments("Printer.PartialCash");
    }

    private void m_jCloseCashTopActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannaclosecash"), AppLocal.getIntString("message.title"), 0, 3);
        if (res == 0) {
            MessageInf msg;
            Date dNow = new Date();
            try {
                if (this.m_App.getActiveCashDateEnd() == null) {
                    new StaticSentence(this.m_App.getSession(), "UPDATE CLOSEDCASH SET DATEEND = ?, NOSALES = ? WHERE HOST = ? AND MONEY = ?", (SerializerWrite)new SerializerWriteBasic(Datas.TIMESTAMP, Datas.INT, Datas.STRING, Datas.STRING)).exec(dNow, this.result, this.m_App.getProperties().getHost(), this.m_App.getActiveCashIndex());
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), ex);
                msg.show(this);
            }
            try {
                this.m_App.setActiveCash(UUID.randomUUID().toString(), this.m_App.getActiveCashSequence() + 1, dNow, null);
                this.m_dlSystem.execInsertCash(new Object[]{this.m_App.getActiveCashIndex(), this.m_App.getProperties().getHost(), this.m_App.getActiveCashSequence(), this.m_App.getActiveCashDateStart(), this.m_App.getActiveCashDateEnd(), 0});
                this.m_dlSystem.execDrawerOpened(new Object[]{this.m_App.getAppUserView().getUser().getName(), "Close Cash"});
                this.m_PaymentsToClose.setDateEnd(dNow);
                this.printPayments("Printer.CloseCash");
                JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.closecashok"), AppLocal.getIntString("message.title"), 1);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), ex);
                msg.show(this);
            }
            try {
                this.loadData();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("label.noticketstoclose"), ex);
                msg.show(this);
            }
        }
    }

    private void m_jCloseCashActionPerformed(ActionEvent evt) {
        int res = JOptionPane.showConfirmDialog(this, AppLocal.getIntString("message.wannaclosecash"), AppLocal.getIntString("message.title"), 0, 3);
        if (res == 0) {
            MessageInf msg;
            Date dNow = new Date();
            try {
                if (this.m_App.getActiveCashDateEnd() == null) {
                    new StaticSentence(this.m_App.getSession(), "UPDATE CLOSEDCASH SET DATEEND = ?, NOSALES = ? WHERE HOST = ? AND MONEY = ?", (SerializerWrite)new SerializerWriteBasic(Datas.TIMESTAMP, Datas.INT, Datas.STRING, Datas.STRING)).exec(dNow, this.result, this.m_App.getProperties().getHost(), this.m_App.getActiveCashIndex());
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), ex);
                msg.show(this);
            }
            try {
                this.m_App.setActiveCash(UUID.randomUUID().toString(), this.m_App.getActiveCashSequence() + 1, dNow, null);
                this.m_dlSystem.execInsertCash(new Object[]{this.m_App.getActiveCashIndex(), this.m_App.getProperties().getHost(), this.m_App.getActiveCashSequence(), this.m_App.getActiveCashDateStart(), this.m_App.getActiveCashDateEnd(), 0});
                this.m_dlSystem.execDrawerOpened(new Object[]{this.m_App.getAppUserView().getUser().getName(), "Close Cash"});
                this.m_PaymentsToClose.setDateEnd(dNow);
                this.printPayments("Printer.CloseCash");
                JOptionPane.showMessageDialog(this, AppLocal.getIntString("message.closecashok"), AppLocal.getIntString("message.title"), 1);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("message.cannotclosecash"), ex);
                msg.show(this);
            }
            try {
                this.loadData();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                msg = new MessageInf(-67108864, AppLocal.getIntString("label.noticketstoclose"), ex);
                msg.show(this);
            }
        }
    }

    private void m_jPrintCashActionPerformed(ActionEvent evt) {
        this.printPayments("Printer.PartialCash");
    }

    private class FormatsPayment
    extends Formats {
        private FormatsPayment() {
        }

        @Override
        protected String formatValueInt(Object value) {
            return AppLocal.getIntString("transpayment." + (String)value);
        }

        @Override
        protected Object parseValueInt(String value) throws ParseException {
            return value;
        }

        @Override
        public int getAlignment() {
            return 2;
        }
    }
}

