/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.notify;

import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.ScreenDimension;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;

public class NotifyWindow
extends JDialog
implements ActionListener,
MouseListener,
ScreenDimension {
    private static final long serialVersionUID = 1L;
    private NotifyType panneau_principal = null;
    private Timer timerPrint = null;
    private Timer timerExit = null;
    private int width = 360;
    private int height = 80;
    private NPosition position = NPosition.CENTER;
    private Color type = NotifyType.DEFAULT_NOTIFICATION;
    public static final int SHORT_DELAY = 1500;
    public static final int VERY_SHORT_DELAY = 750;
    public static final int NORMAL_DELAY = 2500;
    public static final int LONG_DELAY = 4000;
    public static final int VERY_LONG_DELAY = 10000;

    public NotifyWindow(JFrame frame, Color notification, String message, int delay, NPosition position) {
        super((Frame)frame, false);
        this.position = position;
        this.type = notification;
        this.init(this.type, message, delay, this.position);
        if (notification.equals(NotifyType.ERROR_NOTIFICATION)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public NotifyWindow(Color notification, String message, int delay) {
        this.type = notification;
        this.init(this.type, message, delay, this.position);
    }

    public NotifyWindow(Color notification, String message, int delay, NPosition position) {
        this.type = notification;
        this.position = position;
        this.init(this.type, message, delay, this.position);
    }

    public NotifyWindow(Color notification, String message) {
        this.type = notification;
        this.init(this.type, message, 2500, this.position);
    }

    public NotifyWindow(String message) {
        this.init(this.type, message, 2500, this.position);
    }

    public NotifyWindow(String message, NPosition position) {
        this.position = position;
        this.init(this.type, message, 2500, this.position);
    }

    private void init(Color notiColor, String message, int delay, NPosition position) {
        this.panneau_principal = new NotifyType(notiColor, message);
        this.setSize(new Dimension(this.width, this.height));
        this.setUndecorated(true);
        this.setResizable(false);
        this.setOpacity(0.9f);
        this.setLocation(position.getPosition(this));
        this.setContentPane(this.panneau_principal);
        this.setVisible(true);
        this.addMouseListener(this);
        this.setAlwaysOnTop(true);
        this.timerPrint = new Timer(delay, this);
        this.timerExit = new Timer(300, this);
        this.timerPrint.setRepeats(false);
        this.timerPrint.start();
    }

    public NPosition getPosition() {
        return this.position;
    }

    public void setPosition(NPosition position) {
        this.position = position;
    }

    public void clear(NPosition position) {
        if (position == NPosition.TOP_LEFT) {
            NotifyWindow.topLeftInsets.y = NotifyWindow.topLeftInsets.y - this.getHeight() - 4;
        } else if (position == NPosition.TOP_RIGHT) {
            NotifyWindow.topRightInsets.y = NotifyWindow.topRightInsets.y - this.getHeight() - 4;
        } else if (position == NPosition.BOTTOM_LEFT) {
            NotifyWindow.bottomLeftInsets.y = NotifyWindow.bottomLeftInsets.y - this.getHeight() - 4;
        } else if (position == NPosition.BOTTOM_RIGHT) {
            NotifyWindow.bottomRightInsets.y = NotifyWindow.bottomRightInsets.y - this.getHeight() - 4;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timerPrint) {
            this.timerExit.start();
        }
        if (e.getSource() == this.timerExit) {
            if ((double)this.getOpacity() > 0.1) {
                this.setOpacity((float)((double)this.getOpacity() - 0.1));
            } else {
                if (this.timerExit.isRunning()) {
                    this.timerExit.stop();
                }
                this.clear(this.getPosition());
                this.dispose();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.timerExit.isRunning()) {
            this.timerExit.stop();
            this.timerPrint.restart();
            if (this.timerPrint.isRunning()) {
                this.setOpacity(0.9f);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public Point getPosition(JDialog window) {
        return this.getLocation();
    }

    public NotifyWindow(Color notification, String message, int delay, NPosition position, int width, int height) {
        this.type = notification;
        this.position = position;
        this.init(this.type, message, delay, this.position, width, height, true);
    }

    private void init(Color notiColor, String message, int delay, NPosition position, int width, int height, boolean withDelay) {
        this.panneau_principal = new NotifyType(notiColor, message, "");
        this.setSize(new Dimension(width, height));
        this.setUndecorated(true);
        this.setResizable(false);
        this.setOpacity(0.9f);
        this.setLocation(position.getPosition(this));
        this.setContentPane(this.panneau_principal);
        this.setVisible(true);
        this.addMouseListener(this);
        this.setAlwaysOnTop(true);
        if (withDelay) {
            this.timerPrint = new Timer(delay, this);
            this.timerExit = new Timer(300, this);
            this.timerPrint.setRepeats(false);
            this.timerPrint.start();
        }
    }

    public NotifyWindow(Color notification, String message, NPosition position, int width, int height) {
        this.type = notification;
        this.position = position;
        this.init(this.type, message, 999999999, this.position, width, height, false);
    }
}

