/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSynchronisation;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.SynchroService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.comtel2000.keyboard.control.VkProperties;

public class SynchronisationPanel
extends JPanel
implements JPanelView,
BeanFactoryApp,
VkProperties {
    protected AppView m_App;
    private DataLogicSynchronisation dlSync;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JLabel labelMessage;
    private JPanel panelCenter;
    private JPanel panelNorth;
    private JPanel panelSouth;
    private JCheckBox synch_params;
    private JCheckBox synch_products;
    private JCheckBox synch_users;

    public SynchronisationPanel() {
        this.initComponents();
    }

    @Override
    public String getTitle() {
        return "Gestion des produits";
    }

    @Override
    public void activate() throws BasicException {
        if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null && !"0".equals(this.m_App.getAppUserView().getUser().getRole())) {
            this.synch_users.setVisible(false);
            this.synch_params.setVisible(false);
        } else {
            this.synch_users.setVisible(true);
            this.synch_params.setVisible(true);
        }
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSync = (DataLogicSynchronisation)this.m_App.getBean("com.openbravo.dao.DataLogicSynchronisation");
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelNorth = new JPanel();
        this.synch_products = new JCheckBox();
        this.synch_users = new JCheckBox();
        this.synch_params = new JCheckBox();
        this.panelCenter = new JPanel();
        this.labelMessage = new JLabel();
        this.panelSouth = new JPanel();
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.panelNorth.setPreferredSize(new Dimension(10, 150));
        this.panelNorth.setLayout(new FlowLayout(0));
        this.synch_products.setText("Synchroniser le point de vente");
        this.synch_products.setPreferredSize(new Dimension(700, 30));
        this.panelNorth.add(this.synch_products);
        this.synch_users.setText("Synchroniser les utilisateurs");
        this.synch_users.setPreferredSize(new Dimension(700, 30));
        this.synch_users.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynchronisationPanel.this.synch_usersActionPerformed(evt);
            }
        });
        this.panelNorth.add(this.synch_users);
        this.synch_params.setText("Synchroniser les parametres");
        this.synch_params.setPreferredSize(new Dimension(700, 30));
        this.synch_params.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynchronisationPanel.this.synch_paramsActionPerformed(evt);
            }
        });
        this.panelNorth.add(this.synch_params);
        this.add((Component)this.panelNorth, "First");
        this.panelCenter.setPreferredSize(new Dimension(10, 200));
        this.panelCenter.setLayout(new BorderLayout());
        this.labelMessage.setFont(new Font("Tahoma", 1, 18));
        this.labelMessage.setForeground(new Color(0, 153, 204));
        this.labelMessage.setHorizontalAlignment(0);
        this.labelMessage.setPreferredSize(new Dimension(34, 100));
        this.panelCenter.add((Component)this.labelMessage, "Center");
        this.add((Component)this.panelCenter, "Center");
        this.panelSouth.setPreferredSize(new Dimension(400, 100));
        this.panelSouth.setLayout(new BorderLayout());
        this.jButton1.setBackground(new Color(129, 207, 224));
        this.jButton1.setFont(new Font("Tahoma", 1, 18));
        this.jButton1.setText("Synchroniser le point de vente");
        this.jButton1.setBorderPainted(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynchronisationPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.panelSouth.add((Component)this.jButton1, "Center");
        this.add((Component)this.panelSouth, "South");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.synch_products.isSelected() || this.synch_users.isSelected() || this.synch_params.isSelected()) {
            this.labelMessage.setText("En cours de synchronisation ...");
            String ip_address = AppLocal.IP_MASTER;
            if (ip_address != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SynchroService mSynchroService = SynchroService.getInstance();
                            mSynchroService.synchronize(SynchronisationPanel.this.synch_products.isSelected(), SynchronisationPanel.this.synch_users.isSelected(), SynchronisationPanel.this.synch_params.isSelected());
                            SynchronisationPanel.this.labelMessage.setText("Synchronisation faite avec succ\u00e8s.");
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                        }
                    }
                }).start();
            }
        }
    }

    private void synch_usersActionPerformed(ActionEvent evt) {
    }

    private void synch_paramsActionPerformed(ActionEvent evt) {
    }
}

