/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.openbravo.basic.BasicException;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.data.user.EditorRecord;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import java.awt.Component;
import java.util.UUID;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class LocationsView
extends JPanel
implements EditorRecord {
    private String m_sID;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField m_jAddress;
    private JTextField m_jName;

    public LocationsView(DirtyManager dirty) {
        this.initComponents();
        this.m_jName.getDocument().addDocumentListener(dirty);
        this.m_jAddress.getDocument().addDocumentListener(dirty);
        this.writeValueEOF();
    }

    @Override
    public void writeValueEOF() {
        this.m_sID = null;
        this.m_jName.setText(null);
        this.m_jAddress.setText(null);
        this.m_jName.setEnabled(false);
        this.m_jAddress.setEnabled(false);
    }

    @Override
    public void writeValueInsert() {
        this.m_sID = UUID.randomUUID().toString();
        this.m_jName.setText(null);
        this.m_jAddress.setText(null);
        this.m_jName.setEnabled(true);
        this.m_jAddress.setEnabled(true);
    }

    @Override
    public void writeValueDelete(Object value) {
        Object[] location = (Object[])value;
        this.m_sID = Formats.STRING.formatValue(location[0]);
        this.m_jName.setText(Formats.STRING.formatValue(location[1]));
        this.m_jAddress.setText(Formats.STRING.formatValue(location[2]));
        this.m_jName.setEnabled(false);
        this.m_jAddress.setEnabled(false);
    }

    @Override
    public void writeValueEdit(Object value) {
        Object[] location = (Object[])value;
        this.m_sID = Formats.STRING.formatValue(location[0]);
        this.m_jName.setText(Formats.STRING.formatValue(location[1]));
        this.m_jAddress.setText(Formats.STRING.formatValue(location[2]));
        this.m_jName.setEnabled(true);
        this.m_jAddress.setEnabled(true);
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] location = new Object[]{this.m_sID, this.m_jName.getText(), this.m_jAddress.getText()};
        return location;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void refresh() {
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.m_jName = new JTextField();
        this.jLabel3 = new JLabel();
        this.m_jAddress = new JTextField();
        this.setLayout(null);
        this.jLabel2.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel2.setText(AppLocal.getIntString("label.locationname"));
        this.add(this.jLabel2);
        this.jLabel2.setBounds(20, 20, 80, 25);
        this.m_jName.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.add(this.m_jName);
        this.m_jName.setBounds(100, 20, 260, 25);
        this.jLabel3.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLabel3.setText(AppLocal.getIntString("label.locationaddress"));
        this.add(this.jLabel3);
        this.jLabel3.setBounds(20, 50, 80, 25);
        this.m_jAddress.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.add(this.m_jAddress);
        this.m_jAddress.setBounds(100, 50, 260, 25);
    }
}

