/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.CarteService;
import com.openbravo.service.DeliveroService;
import com.openbravo.service.DishopService;
import com.openbravo.service.OtterService;
import com.openbravo.service.RusHourService;
import com.openbravo.service.SiteConfigService;
import com.openbravo.service.UberService;
import com.procaisse.db.connection.firebase.FirebaseService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JUploadDownLoadCarte
extends JDialog {
    private double discountReturn;
    private Object[] result;
    private double total;
    private String type;
    private String currency;
    private Date selectedDate;
    private DataLogicSales dlSales;
    private AppView app;
    private DataLogicItems dlItems;
    Component parent;
    private Calendar mCalendar = Calendar.getInstance();
    private final String MESSAGE_ERROR_SOTREID_EMPTY = "Merci d'introduire le store id.";
    private final String SUCCESS = "OK";
    private final String MESSAGE_USER_NOT_ALLOWED = "L'utilisateur n'est pas autoris\u00e9 \u00e0 acc\u00e9der au store";
    private final String MESSAGE_UNAUTHORIZED = "unauthorized";
    private final String MESSAGE_ERROR_DB_EMPTY = "Carte vide.";
    private boolean is_full_downlaoded = false;
    private String operation_download = "";
    private JLabel jLabel1;
    private JLabel labelMessage;
    private JPanel panelMessage;

    private JUploadDownLoadCarte(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[3];
    }

    private JUploadDownLoadCarte(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[3];
    }

    private void init(DataLogicSales dlSales, DataLogicItems dlItems, AppView app, String operation) throws BasicException {
        this.initComponents();
        this.setResizable(false);
        this.dlSales = dlSales;
        this.dlItems = dlItems;
        this.app = app;
        switch (operation) {
            case "upload": {
                this.setTitle("Upload  de la carte ");
                this.uploadCarte();
                break;
            }
            case "download": {
                System.out.println("download ");
                this.setTitle("T\u00e9l\u00e9charegement  de la carte ");
                this.downloadCarte();
                break;
            }
            case "upload_uberEat": {
                this.setTitle("Upload  de la carte Uber Eat");
                this.uploadCarteUberEat();
                break;
            }
            case "deliveroo": {
                this.setTitle("Upload  de la carte Deliveroo");
                this.uploadCarteDeliveroo();
                break;
            }
            case "upload_otter": {
                this.setTitle("Upload  de la carte Otter");
                this.uploadCarteOtter();
                break;
            }
            case "upload_rusHour": {
                this.setTitle("Upload  de la carte RusHour");
                this.uploadCarteRusHour();
                break;
            }
            case "upload_dishop": {
                this.setTitle("Upload  de la carte Dishop");
                this.uploadCarteDishop();
            }
        }
        this.setVisible(true);
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JUploadDownLoadCarte.getWindow(parent.getParent());
    }

    public static void showMessage(Component parent, DataLogicSales dlSales, DataLogicItems dlItems, AppView app, String operation) throws BasicException, IOException {
        Window window = JUploadDownLoadCarte.getWindow(parent);
        JUploadDownLoadCarte myMsg = window instanceof Frame ? new JUploadDownLoadCarte((Frame)window, true) : new JUploadDownLoadCarte((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(1000, 500));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        myMsg.init(dlSales, dlItems, app, operation);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.panelMessage = new JPanel();
        this.labelMessage = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.POPUP);
        this.panelMessage.setLayout(new BorderLayout());
        this.labelMessage.setFont(new Font("Tahoma", 0, 14));
        this.labelMessage.setHorizontalAlignment(0);
        this.panelMessage.add((Component)this.labelMessage, "Center");
        this.getContentPane().add((Component)this.panelMessage, "Center");
        this.setSize(new Dimension(358, 173));
        this.setLocationRelativeTo(null);
    }

    private void uploadCarte() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CarteService mCarteService = new CarteService(JUploadDownLoadCarte.this.dlSales, JUploadDownLoadCarte.this.dlItems, JUploadDownLoadCarte.this.app);
                    mCarteService.uploadCarte();
                    boolean upload = mCarteService.uploadPicture();
                    SiteConfigService mSiteConfigService = SiteConfigService.getInstance();
                    mSiteConfigService.uploadParamsSite();
                    JUploadDownLoadCarte.this.dispose();
                    if (upload) {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void downloadCarte() {
        this.labelMessage.setText("T\u00e9l\u00e9chargement carte en cours ...");
        this.is_full_downlaoded = false;
        this.operation_download = "";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CarteService mCarteService = new CarteService(JUploadDownLoadCarte.this.dlSales, JUploadDownLoadCarte.this.dlItems, JUploadDownLoadCarte.this.app);
                    boolean result_images = mCarteService.downloadPicture();
                    boolean result_download = mCarteService.downloadCarte();
                    JUploadDownLoadCarte.this.is_full_downlaoded = result_images && result_download;
                    JUploadDownLoadCarte.this.dispose();
                    if (result_images && result_download) {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est telecharg\u00e9e.", 4000, NPosition.BOTTOM_RIGHT);
                        JUploadDownLoadCarte.this.operation_download = "download";
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.BOTTOM_RIGHT);
                        JUploadDownLoadCarte.this.operation_download = "error";
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.BOTTOM_RIGHT);
                    JUploadDownLoadCarte.this.operation_download = "error";
                }
                if (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre")) {
                    System.out.println("*********operation_download :" + JUploadDownLoadCarte.this.operation_download);
                    JUploadDownLoadCarte.this.uploadInfoDownloadedCarte(JUploadDownLoadCarte.this.is_full_downlaoded, JUploadDownLoadCarte.this.operation_download);
                }
            }
        }).start();
    }

    private void uploadCarteUberEat() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UberService mUberService = UberService.getInstance();
                    String result = mUberService.uploadMenu(true);
                    JUploadDownLoadCarte.this.dispose();
                    if (result != null && !result.isEmpty()) {
                        switch (result) {
                            case "Merci d'introduire le store id.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci d'introduire le store id.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "Carte vide.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Carte vide.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "OK": {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                                break;
                            }
                            case "unauthorized": {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'utilisateur n'est pas autoris\u00e9 \u00e0 acc\u00e9der au store", 1500, NPosition.CENTER);
                                break;
                            }
                            default: {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, result, 1500, NPosition.CENTER);
                                break;
                            }
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void uploadCarteRusHour() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RusHourService mRusHourService = RusHourService.getInstance();
                    int result = mRusHourService.uploadMenu();
                    JUploadDownLoadCarte.this.dispose();
                    switch (result) {
                        case -1: {
                            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci d'introduire le store id.", 1500, NPosition.CENTER);
                            break;
                        }
                        case 1: {
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                            break;
                        }
                        default: {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void uploadCarteOtter() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OtterService mOtterService = OtterService.getInstance();
                    String result = mOtterService.uploadMenu();
                    JUploadDownLoadCarte.this.dispose();
                    if (result != null && !result.isEmpty()) {
                        switch (result) {
                            case "Merci d'introduire le store id.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci d'introduire le store id.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "OK": {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                                break;
                            }
                            case "unauthorized": {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'utilisateur n'est pas autoris\u00e9 \u00e0 acc\u00e9der au store", 1500, NPosition.CENTER);
                                break;
                            }
                            default: {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, result, 1500, NPosition.CENTER);
                                break;
                            }
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void uploadCarteDeliveroo() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DeliveroService mDeliveroService = DeliveroService.getInstance();
                    String result = mDeliveroService.uploadMenu();
                    JUploadDownLoadCarte.this.dispose();
                    if (result != null && !result.isEmpty()) {
                        switch (result) {
                            case "Merci d'introduire le store id.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci d'introduire le store id.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "Carte vide.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Carte vide.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "OK": {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                                break;
                            }
                            case "unauthorized": {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'utilisateur n'est pas autoris\u00e9 \u00e0 acc\u00e9der au store", 1500, NPosition.CENTER);
                                break;
                            }
                            default: {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, result, 1500, NPosition.CENTER);
                                break;
                            }
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void uploadCarteDishop() {
        this.labelMessage.setText("Upload carte en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CarteService mCarteService = new CarteService(JUploadDownLoadCarte.this.dlSales, JUploadDownLoadCarte.this.dlItems, JUploadDownLoadCarte.this.app);
                    DishopService mDeliverooDishopService = DishopService.getInstance();
                    String result = mDeliverooDishopService.uploadMenu();
                    JUploadDownLoadCarte.this.dispose();
                    if (result != null && !result.isEmpty()) {
                        switch (result) {
                            case "Merci d'introduire le store id.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci d'introduire le store id.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "Carte vide.": {
                                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Carte vide.", 1500, NPosition.CENTER);
                                break;
                            }
                            case "OK": {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                                break;
                            }
                            default: {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, result, 1500, NPosition.CENTER);
                                break;
                            }
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    JUploadDownLoadCarte.this.dispose();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    private void uploadInfoDownloadedCarte(final boolean is_full_downlaoded, final String operation) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FirebaseService mFirebaseService = FirebaseService.getInstance();
                    mFirebaseService.uploadInfoDownloadedCarte(is_full_downlaoded, operation);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }).start();
    }
}

