/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.ticket.ProductInfoExt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class JPriceProduct
extends JDialog {
    Component parent;
    List<ProductInfoExt> products;
    private int height_pane_product = 50;
    private int width_pane_product = 500;
    private Object[] result;
    private JButton jButton1;
    private JPanel jPanelProduct;
    private JScrollPane jScrollPane1;

    private JPriceProduct(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[2];
    }

    private JPriceProduct(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[2];
    }

    private Object[] init(List<ProductInfoExt> productsPlat) throws BasicException {
        this.initComponents();
        this.setSize(new Dimension(650, 500));
        this.setTitle("Les prix \u00e0 modifier");
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(30, 35));
        this.products = productsPlat;
        this.loadPaneProducts();
        this.result[0] = this.products;
        this.result[1] = false;
        this.setVisible(true);
        return this.result;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JPriceProduct.getWindow(parent.getParent());
    }

    public static Object[] showMessage(Component parent, List<ProductInfoExt> productsPlat) throws BasicException, IOException {
        Window window = JPriceProduct.getWindow(parent);
        JPriceProduct myMsg = window instanceof Frame ? new JPriceProduct((Frame)window, true) : new JPriceProduct((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(650, 500));
        return myMsg.init(productsPlat);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelProduct = new JPanel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(700, 600));
        this.setType(Window.Type.POPUP);
        this.jScrollPane1.setPreferredSize(new Dimension(650, 500));
        this.jPanelProduct.setMinimumSize(new Dimension(500, 500));
        this.jPanelProduct.setPreferredSize(new Dimension(500, 500));
        this.jScrollPane1.setViewportView(this.jPanelProduct);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jButton1.setBackground(new Color(129, 207, 224));
        this.jButton1.setText("Valider");
        this.jButton1.setPreferredSize(new Dimension(700, 40));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPriceProduct.this.jButton1ActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.jButton1, "South");
        this.setSize(new Dimension(650, 500));
        this.setLocationRelativeTo(null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.result[0] = this.products;
        this.result[1] = true;
        this.dispose();
    }

    private void loadPaneProducts() {
        this.jPanelProduct.removeAll();
        for (final ProductInfoExt product : this.products) {
            JPanel paneProduct = new JPanel();
            JLabel name_product = new JLabel(product.getName());
            final JTextField price_product = new JTextField(String.valueOf(product.getPriceSell()));
            JButton button_product = new JButton("X");
            paneProduct.setPreferredSize(new Dimension((int)((double)this.width_pane_product * 0.9), this.height_pane_product));
            name_product.setPreferredSize(new Dimension((int)((double)this.width_pane_product * 0.3), (int)((double)this.height_pane_product * 0.9)));
            price_product.setPreferredSize(new Dimension((int)((double)this.width_pane_product * 0.3), (int)((double)this.height_pane_product * 0.9)));
            button_product.setPreferredSize(new Dimension((int)((double)this.width_pane_product * 0.1), (int)((double)this.height_pane_product * 0.9)));
            button_product.setBackground(new Color(240, 240, 240));
            button_product.setForeground(Color.red);
            button_product.setFont(new Font("Monaco", 0, 20));
            price_product.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ke) {
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                }

                @Override
                public void keyReleased(KeyEvent ke) {
                    product.setPriceSell(Double.parseDouble(price_product.getText().isEmpty() ? "0.0" : price_product.getText()));
                }
            });
            button_product.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JPriceProduct.this.deleteProduct(product);
                }
            });
            paneProduct.add(name_product);
            paneProduct.add(price_product);
            paneProduct.add(button_product);
            this.jPanelProduct.add(paneProduct);
        }
        double height_pane_products = (double)(this.products.size() * this.height_pane_product) * 1.1;
        this.jPanelProduct.setPreferredSize(new Dimension((int)((double)this.width_pane_product * 0.95), (int)height_pane_products));
        this.jPanelProduct.revalidate();
        this.jPanelProduct.repaint();
    }

    private void deleteProduct(ProductInfoExt product) {
        this.products.remove(product);
        this.loadPaneProducts();
    }
}

