/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.inventory;

import com.openbravo.pos.ticket.SupplementItemInfo;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class IngredientTableModel
extends AbstractTableModel {
    private final String[] columns = new String[]{"Nom", "Cuisinable", "Quantit\u00e9", "Supprimer"};
    private List<SupplementItemInfo> itemIngredients;
    private Map<Integer, Integer> itemIngredientsQuantities;

    IngredientTableModel() {
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.itemIngredients != null ? this.itemIngredients.size() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SupplementItemInfo itemIngredient = this.itemIngredients.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return itemIngredient.getName();
            }
            case 1: {
                return itemIngredient.isCookable();
            }
            case 2: {
                return this.itemIngredientsQuantities.getOrDefault(itemIngredient.getiD(), 1);
            }
            case 3: {
                return this.columns[3];
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        SupplementItemInfo itemIngredient = this.itemIngredients.get(rowIndex);
        boolean updated = false;
        switch (columnIndex) {
            case 0: {
                String newName = (String)value;
                if (itemIngredient.getName().equals(newName)) break;
                itemIngredient.setName(newName);
                updated = true;
                break;
            }
            case 1: {
                boolean newCookable = (Boolean)value;
                if (itemIngredient.isCookable() == newCookable) break;
                itemIngredient.setCookable(newCookable);
                updated = true;
                break;
            }
            case 2: {
                int newQuantity = (Integer)value;
                this.itemIngredientsQuantities.put(itemIngredient.getiD(), newQuantity);
            }
        }
        if (updated) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    public final void setItemIngredients(List<SupplementItemInfo> itemIngredients, Map<Integer, Integer> itemIngredientsQuantities) {
        this.itemIngredients = itemIngredients;
        this.itemIngredientsQuantities = itemIngredientsQuantities;
    }

    public void addIngredient(SupplementItemInfo ingredient) {
        this.itemIngredients.add(ingredient);
        this.fireTableRowsInserted(this.itemIngredients.size() - 1, this.itemIngredients.size() - 1);
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.itemIngredients.size()) {
            this.itemIngredients.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void clear() {
        this.itemIngredients = null;
        this.itemIngredientsQuantities = null;
    }
}

