/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.imports;

import fr.protactile.procaisse.dao.entities.CityInfo;
import fr.protactile.procaisse.dao.entities.ZipCodeInfo;
import fr.protactile.procaisse.services.CityService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ImportCities {
    private CityService mCityService = CityService.getInstance();

    public void importCities() throws IOException, URISyntaxException {
        System.out.println("+++++++++++ import cities");
        String path = "";
        InputStream inputStream = this.getClass().getResourceAsStream("/files/villes_france.csv");
        File cityFile = new File("src/main/resources/targetFile.tmp");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)cityFile);
        if (cityFile.exists()) {
            System.out.println("start import cities");
            List allDatas = FileUtils.readLines((File)cityFile, (String)"UTF-8");
            if (allDatas != null && !allDatas.isEmpty()) {
                for (int i = 0; i < allDatas.size(); ++i) {
                    String[] columns = new String[27];
                    columns = ((String)allDatas.get(i)).split(",");
                    String city = columns[4];
                    String zipCode = columns[8];
                    city = city.replaceAll("\"", "");
                    zipCode = zipCode.replaceAll("\"", "");
                    String[] tabe_zipCode = zipCode.split("-");
                    CityInfo mCityInfo = new CityInfo(city != null ? city : "");
                    ArrayList<ZipCodeInfo> listZipCode = new ArrayList<ZipCodeInfo>();
                    if (tabe_zipCode.length > 0) {
                        for (String zipCode_value : tabe_zipCode) {
                            listZipCode.add(new ZipCodeInfo(zipCode_value));
                        }
                    } else {
                        listZipCode.add(new ZipCodeInfo(zipCode));
                    }
                    this.mCityService.save(mCityInfo, listZipCode);
                }
            }
            System.out.println("end import cities");
        }
    }
}

