/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.FCCClient;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootFrame;
import com.openbravo.pos.forms.JRootKiosk;
import com.openbravo.pos.forms.ServiceLoader;
import com.openbravo.pos.instance.InstanceQuery;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SignatureGenerator;
import fr.protactile.procaisse.system.MemoryWarningSystem;
import fr.protactile.procaisse.tasks.AppTimerTask;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.grizzly.http.server.HttpServer;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import se.walkercrou.places.AddressFinderHelper;

public class StartPOS {
    private static Log logger = LogFactory.getFactory().getInstance(StartPOS.class);
    public static String caisseIdentifier;
    public static String pathto;

    private StartPOS() {
    }

    static boolean registerApp() throws BackingStoreException {
        try {
            StartPOS.loadProcaisseProperties();
            InstanceQuery i = new InstanceQuery();
            i.getAppMessage().restoreWindow();
            return false;
        }
        catch (IOException | NotBoundException e) {
            return true;
        }
    }

    private static void checkLocalization(String address) {
        if (address != null && !address.isEmpty() && (AppLocal.lat == null || AppLocal.lat.isEmpty() || AppLocal.lon == null || AppLocal.lon.isEmpty())) {
            AddressFinderHelper.localizationAddressResto(address);
        }
    }

    static void loadProcaisseProperties() throws IOException {
        File clairPropertiesFile = FilerUtils.getInstance().getFileProperties();
        File encFile = new File(AppVarUtils.PROCAISSE_PROPERTIES_ENCRYPTED);
        if (encFile.exists()) {
            String decrypted = SignatureGenerator.decryptAES(encFile, clairPropertiesFile);
            if (decrypted == null) {
                try {
                    Journal.writeToJET(new Event(999, "Fonction \u00e9diteur", "", "Description", new Date().getTime(), "Fichier des propri\u00e9t\u00e9s endommag\u00e9"));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                if (clairPropertiesFile.exists()) {
                    try {
                        Journal.writeToJET(new Event(999, "Fonction \u00e9diteur", "", "Description", new Date().getTime(), "Importation du fichier des propri\u00e9t\u00e9s"));
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    SignatureGenerator.getGenerator();
                    SignatureGenerator.encryptFileWithAES(clairPropertiesFile, encFile);
                }
            }
        } else {
            File lastclairPropertiesFile = FilerUtils.getInstance().getLastFileProperties();
            if (!clairPropertiesFile.exists() && lastclairPropertiesFile != null && lastclairPropertiesFile.exists()) {
                FileUtils.copyFile((File)lastclairPropertiesFile, (File)clairPropertiesFile);
            }
            if (clairPropertiesFile.exists()) {
                try {
                    Journal.writeToJET(new Event(999, "Fonction \u00e9diteur", "", "Description", new Date().getTime(), "Importation du fichier des propri\u00e9t\u00e9s"));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                System.out.println("++++++++++++++ encryptFileWithAES 2 **********");
                SignatureGenerator.getGenerator();
                SignatureGenerator.encryptFileWithAES(clairPropertiesFile, encFile);
            }
        }
    }

    static void memoryPrint() {
        System.out.println("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
        System.out.println("Free memory (bytes): " + Runtime.getRuntime().freeMemory());
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.println("Maximum memory (bytes): " + (Serializable)(maxMemory == Long.MAX_VALUE ? "no limit" : Long.valueOf(maxMemory)));
        System.out.println("Total memory (bytes): " + Runtime.getRuntime().totalMemory());
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.setProperty("com.sun.prism.order", "j2d");
        final FilerUtils m_FilerUtils = FilerUtils.getInstance();
        try {
            Journal.writeToJET(new Event(80, "D\u00e9marage de l'application", "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block19: {
                    try {
                        if (StartPOS.registerApp()) break block19;
                        try {
                            Journal.writeToJET(new Event(40, "Arret de l'application", "", "", new Date().getTime(), ""));
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        System.exit(1);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
                AppConfig config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
                config.initAppLocal();
                AppLocal.setCodeLnaguages();
                try {
                    config.initFirebase();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                AppLocal.loadLanguages();
                StartPOS.checkLocalization(AppLocal.addressResto);
                Formats.setIntegerPattern(config.getProperty("format.integer"));
                Formats.setDoublePattern(config.getProperty("format.double"));
                Formats.setQttPattern("#0.000");
                Formats.setCurrencyPattern(config.getProperty("format.currency"));
                Formats.setPercentPattern(config.getProperty("format.percent"));
                Formats.setDatePattern(config.getProperty("format.date"));
                Formats.setTimePattern(config.getProperty("format.time"));
                Formats.setDateTimePattern(config.getProperty("format.datetime"));
                if (AppLocal.GLORY_ENABLED) {
                    StartPOS.initFCCCConst();
                }
                try {
                    Object laf = Class.forName(config.getProperty("swing.defaultlaf")).newInstance();
                    if (laf instanceof LookAndFeel) {
                        UIManager.setLookAndFeel((LookAndFeel)laf);
                    } else if (laf instanceof SubstanceSkin) {
                        SubstanceLookAndFeel.setSkin((SubstanceSkin)((SubstanceSkin)laf));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    LogToFile.log("severe", "Cannot set Look and Feel", e);
                }
                String hostname = config.getStringProperty("machine.hostname");
                TicketInfo.setHostname(hostname);
                boolean master = config.getStringProperty("model.caisse").equals("Maitre");
                boolean remoteSync = config.getBooleanProperty("remote.sync");
                if (master || remoteSync) {
                    HttpServer serverOld = ServiceLoader.startOldServer();
                    HttpServer httpServer = ServiceLoader.startServer();
                }
                if ("fullscreen".equals(config.getStringProperty("machine.screenmode"))) {
                    JRootKiosk rootkiosk = new JRootKiosk();
                    try {
                        rootkiosk.initFrame(config);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    JRootFrame rootframe = new JRootFrame();
                    try {
                        rootframe.initFrame(config);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
                StartPOS.memoryPrint();
            }
        });
        MemoryWarningSystem.setPercentageUsageThreshold(0.8);
        MemoryWarningSystem mws = new MemoryWarningSystem();
        mws.addListener(new MemoryWarningSystem.Listener(){

            @Override
            public void memoryUsageLow(long usedMemory, long maxMemory) {
                double percentageUsed = (double)usedMemory / (double)maxMemory;
                try {
                    System.out.println("+++++++++++++++ usedMemory : " + usedMemory);
                    System.out.println("+++++++++++ maxMemory : " + maxMemory);
                    AppTimerTask.forceGarbageCollector();
                    MemoryWarningSystem.traceOutMemory(percentageUsed);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", "", ex);
                }
            }
        });
    }

    public static void initFCCCConst() {
        BrueBoxServiceStub.AdjustTimeRequest req = new BrueBoxServiceStub.AdjustTimeRequest();
        FCCClient.DEVICES_STATUS = new HashMap();
        FCCClient.DEVICES_STATUS.put(0, "STATE_INITIALIZE");
        FCCClient.DEVICES_STATUS.put(1000, "STATE_IDLE");
        FCCClient.DEVICES_STATUS.put(1500, "STATE_IDLE_OCCUPY");
        FCCClient.DEVICES_STATUS.put(2000, "STATE_DEPOSIT_BUSY");
        FCCClient.DEVICES_STATUS.put(2050, "STATE_DEPOSIT_COUNTING");
        FCCClient.DEVICES_STATUS.put(2055, "STATE_DEPOSIT_END");
        FCCClient.DEVICES_STATUS.put(2100, "STATE_WAIT_STORE");
        FCCClient.DEVICES_STATUS.put(2200, "STATE_STORE_BUSY");
        FCCClient.DEVICES_STATUS.put(2300, "STATE_STORE_END");
        FCCClient.DEVICES_STATUS.put(2500, "STATE_WAIT_RETURN");
        FCCClient.DEVICES_STATUS.put(2600, "STATE_COUNT_BUSY");
        FCCClient.DEVICES_STATUS.put(2610, "STATE_COUNT_COUNTING");
        FCCClient.DEVICES_STATUS.put(2700, "STATE_REPLENISH_BUSY");
        FCCClient.DEVICES_STATUS.put(3000, "STATE_DISPENSE_BUSY");
        FCCClient.DEVICES_STATUS.put(3100, "STATE_WAIT_DISPENSE");
        FCCClient.DEVICES_STATUS.put(4000, "STATE_REFILL");
        FCCClient.DEVICES_STATUS.put(4050, "STATE_REFILL_COUNTING");
        FCCClient.DEVICES_STATUS.put(4055, "STATE_REFILL_END");
        FCCClient.DEVICES_STATUS.put(5000, "STATE_RESET");
        FCCClient.DEVICES_STATUS.put(6000, "STATE_COLLECT_BUSY");
        FCCClient.DEVICES_STATUS.put(6500, "STATE_VERIFY_BUSY");
        FCCClient.DEVICES_STATUS.put(6600, "STATE_VERIFYCOLLECT_BUSY");
        FCCClient.DEVICES_STATUS.put(7100, "STATE_INVENTORY_ADJUST");
        FCCClient.DEVICES_STATUS.put(8000, "STATE_DOWNLOAD_BUSY");
        FCCClient.DEVICES_STATUS.put(8100, "STATE_LOG_READ_BUSY");
        FCCClient.DEVICES_STATUS.put(9100, "STATE_BUSY");
        FCCClient.DEVICES_STATUS.put(9200, "STATE_ERROR");
        FCCClient.DEVICES_STATUS.put(9300, "STATE_COM_ERROR");
        FCCClient.DEVICES_STATUS.put(9400, "STATE_WAIT_FOR_RESET");
        FCCClient.DEVICES_STATUS.put(9500, "STATE_CONFIG_ERROR");
        FCCClient.DEVICES_STATUS.put(50000, "STATE_CONFIG_ERROR");
    }

    static {
        pathto = "W33kCzcHSO/I8Yzw918ch8c7hKEryu5+em3ah0rZT8kkVp5hLvHvu64mjKvE4wg4YglH\nucdG1taS/xcCgYEA0kxUgamlt5omzCjKhGiDClaiwzAunwr4raNEGdKAZyTd1tsfJloSeP7z52Z8\nqpKXJOG6Bal73dB6SIN8y6SdLYKHs0yZptZG/RvOUIZI2gSULsx6iTfAUGeco6Ip/hfm2wP85Kp0\nuBmiaT4yMmFGsRip4Y0X0Bm+cL0ScHbYCHUCgYAKv0UaSAZz26CtM8ktumGz1EU/79uvnhwtLBun\nDpd2ZL/9WBFYMwYUxCyDmc/HOaxBjJBx0ar3xdsylONyNcS2JvtuozhwCbC7RBUJybtmn1PARf0D\nD2Brso52riTCysdWGR//6FLd+dAhv4+v/t2BaJIKS5L8QPr1BGUAydrZYwKBgApR1JPIT2mDFwRN\nvCJjPorzVWleo+sKDsn2iRD7U3G8TWaNuimXofBuEmn4jYWRS/lzWj2M45cu89E7IpSbr1rcXOxf\nheq5+SHSi31IGasZLmxdfGXfZoCLlRQykPz3D00QFQjjlHa0S1P+yVfPjjiCjVOUKOb9XGsL3CvI\nqTFBAoGBAKBfTC59tmwrYAuvOtYF/qPqzUDFS8uKQOb0151Np+RgVGDE3Q8ulEY+JseILy+OrWTi\n4KSwuoXzS8RPmJki/EQnu1KqXy5kqTYLYyyAB+61IIHViMxw+gCsnsJSnaGrmpfE1l4Aq9QuqZe6\nNywxE8NVSbHhHcebgZWpxkVG5b7f";
    }
}

