/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.cashlogy.services.CashLogyServices;
import com.openbravo.filters.CORSFilter;
import com.openbravo.uploads.items.ItemsIO;
import com.openbravo.uploads.items.NewItemsIO;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class ServiceLoader {
    public static final String DEFAULT_PROTOCOL = "http://";
    public static final String DEFAULT_PROTOCOL_SECURED = "https://";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    public static String BASE_URI_OLD = "http://0.0.0.0:9095";
    public static boolean isSecured = false;
    public static final String PATH_KEYSOTRE_FILE = "/crts/keystore_server";
    public static final String PATH_TRUSTSOTRE_FILE = "/crts/truststore_server";
    public static final String PATH_KEYSOTRE_PASSWORD = "sponjac";
    public static final String PATH_TRUSTSOTRE_PASSWORD = "sponjac";
    public static String BASE_URI_CASHLOGY = "http://0.0.0.0:8092";
    public static String BASE_URI = "http://0.0.0.0:9097";

    private static String getCurrentDirectory() {
        File f = ServiceLoader.getJarDir(ServiceLoader.class);
        return f.getAbsolutePath();
    }

    public static File getJarDir(Class aclass) {
        URL url;
        try {
            url = aclass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = aclass.getResource(aclass.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        if (extURL.endsWith(".jar")) {
            extURL = extURL.substring(0, extURL.lastIndexOf("/"));
        } else {
            String suffix = "/" + aclass.getName().replace(".", "/") + ".class";
            if ((extURL = extURL.replace(suffix, "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
                extURL = extURL.substring(4, extURL.lastIndexOf("/"));
            }
        }
        try {
            url = new URL(extURL);
        }
        catch (MalformedURLException suffix) {
            // empty catch block
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    public static HttpServer startOldServer() {
        ResourceConfig rc = new ResourceConfig().registerClasses(new Class[]{ItemsIO.class});
        rc.register((Object)new CORSFilter());
        rc.property("jersey.config.server.provider.packages", (Object)"com.openbravo.uploads.items,com.fasterxml.jackson.jaxrs.json");
        return GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(BASE_URI_OLD), (ResourceConfig)rc);
    }

    public static HttpServer startServer() {
        ResourceConfig rc = new ResourceConfig().registerClasses(new Class[]{NewItemsIO.class});
        rc.register((Object)new CORSFilter());
        rc.property("jersey.config.server.provider.packages", (Object)"com.openbravo.uploads.newItems,com.fasterxml.jackson.jaxrs.json");
        return GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(BASE_URI), (ResourceConfig)rc);
    }

    public static HttpServer startSecuredServer() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"fr.protactile"});
        rc.register((Object)new CORSFilter());
        rc.property("jersey.config.server.provider.packages", (Object)"fr.protactile,com.fasterxml.jackson.jaxrs.json");
        SSLContextConfigurator sslCon = new SSLContextConfigurator();
        sslCon.setKeyStoreFile(ServiceLoader.getCurrentDirectory() + PATH_KEYSOTRE_FILE);
        sslCon.setKeyStorePass("sponjac");
        sslCon.setTrustStoreFile(ServiceLoader.getCurrentDirectory() + PATH_TRUSTSOTRE_FILE);
        sslCon.setTrustStorePass("sponjac");
        SSLEngineConfigurator sslConfiguration = new SSLEngineConfigurator(sslCon, false, false, false);
        HttpHandler h = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)rc);
        GrizzlyHttpContainer hand = (GrizzlyHttpContainer)ContainerFactory.createContainer(GrizzlyHttpContainer.class, (Application)rc);
        HttpServer secure = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(BASE_URI), (GrizzlyHttpContainer)hand, (boolean)true, (SSLEngineConfigurator)sslConfiguration, (boolean)false);
        return secure;
    }

    public static HttpServer startServerCashLogy() {
        System.out.println("******************* Start Server Cashlogy ********************");
        ResourceConfig rc = new ResourceConfig().registerClasses(new Class[]{CashLogyServices.class});
        rc.register((Object)new CORSFilter());
        rc.property("jersey.config.server.provider.packages", (Object)"com.openbravo.cashlogy.services,com.fasterxml.jackson.jaxrs.json");
        return GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(BASE_URI_CASHLOGY), (ResourceConfig)rc);
    }
}

