/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.controllers.PopUpLoadingController;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.util.AppVarUtils;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class PopupLoading {
    private Scene principal_scene;
    private static Stage modalStage;
    private PopUpLoadingController controller;
    private AppView mAppView;

    public PopupLoading(Scene scene, Stage modalStage) {
        this.principal_scene = scene;
        PopupLoading.modalStage = modalStage;
    }

    public void init() throws IOException {
        if (this.principal_scene != null && modalStage != null) {
            String fxmlFile = "/fxml/popup_loading";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            Scene scenePop = new Scene(rootNode, 400.0, 400.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            this.controller = (PopUpLoadingController)loader.getController();
            modalStage.setScene(scenePop);
            modalStage.initOwner(this.principal_scene.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UTILITY);
            modalStage.setAlwaysOnTop(true);
            this.controller.setPopUpLoading(this);
            this.controller.init();
        }
    }

    public Stage getModalStage() {
        return modalStage;
    }

    public void setModalStage(Stage modalStage) {
        PopupLoading.modalStage = modalStage;
    }

    public AppView getmAppView() {
        return this.mAppView;
    }

    public void setmAppView(AppView mAppView) {
        this.mAppView = mAppView;
    }

    public boolean isShowing() {
        return modalStage != null && modalStage.isShowing();
    }

    public void show() {
        if (!(this.isShowing() && AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT > 0 || modalStage == null || AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT <= 0)) {
            modalStage.show();
        }
    }

    public void hide() {
        if (modalStage != null && modalStage.isShowing()) {
            modalStage.hide();
        }
    }
}

