/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicStorage;
import com.openbravo.pos.config.JFrmConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.forms.MarqueAndLicenseDialogue;
import com.openbravo.pos.instance.AppMessage;
import com.openbravo.pos.instance.InstanceManager;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.OSValidator;
import com.openbravo.service.OrderOnLineService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFrame;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.control.KeyBoardWindow;
import org.comtel2000.swing.control.KeyBoardWindowBuilder;
import org.comtel2000.swing.robot.AWTRobotHandler;
import org.comtel2000.swing.ui.KeyboardUIManagerTool;

public class JRootKiosk
extends JFrame
implements AppMessage {
    private MarqueAndLicenseDialogue licenseKeyGUI;
    private InstanceManager m_instmanager = null;
    private JRootApp m_rootapp;
    private AppProperties m_props;
    private OSValidator m_OS;

    public JRootKiosk() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.initComponents();
        if (AppLocal.window == null) {
            AppLocal.window = KeyBoardWindowBuilder.create().initLocale(Locale.FRENCH).addIRobot((IRobot)new AWTRobotHandler()).layer(DefaultLayer.NUMBLOCK).build();
        }
        KeyboardUIManagerTool.installKeyboardDefaults((KeyBoardWindow)AppLocal.window);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                JRootKiosk.this.formWindowOpened(evt);
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                try {
                    Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                JRootKiosk.this.m_rootapp.tryToClose();
                System.out.println(" formWindowClosed ");
            }
        });
        this.licenseKeyGUI = new MarqueAndLicenseDialogue(this, true);
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    public void initFrame(AppProperties props) throws IOException {
        this.m_OS = new OSValidator();
        this.m_props = props;
        this.m_rootapp = new JRootApp();
        try {
            if (this.m_rootapp.initApp(this.m_props)) {
                this.add((Component)this.m_rootapp, "Center");
                this.setTitle("BIBORNE - 10.0.1.27");
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                this.setBounds(0, 0, d.width, d.height);
                this.setVisible(true);
                BasicStorage.pushObject("APP_ROOT_INSTANCE", this.m_rootapp);
                if (AppLocal.ORDER_ONLINE_ENABLED && AppLocal.SUIVI_ONLINE_ORDER) {
                    OrderOnLineService onLineService = OrderOnLineService.getInstance(null);
                    onLineService.connect();
                }
            } else {
                new JFrmConfig(props).setVisible(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void restoreWindow() {
        EventQueue.invokeLater(() -> {
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            this.requestFocus();
        });
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JRootKiosk.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                JRootKiosk.this.formWindowClosing(evt);
            }
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        this.m_rootapp.tryToClose();
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.exit(0);
    }
}

