/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicStorage;
import com.openbravo.pos.config.JFrmConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.forms.MarqueAndLicenseDialogue;
import com.openbravo.pos.instance.AppMessage;
import com.openbravo.pos.instance.InstanceManager;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.OrderOnLineService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.control.KeyBoardWindow;
import org.comtel2000.swing.control.KeyBoardWindowBuilder;
import org.comtel2000.swing.robot.AWTRobotHandler;
import org.comtel2000.swing.ui.KeyboardUIManagerTool;

public class JRootFrame
extends JFrame
implements AppMessage {
    private MarqueAndLicenseDialogue licenseKeyGUI;
    private InstanceManager m_instmanager = null;
    private JRootApp m_rootapp;
    private AppProperties m_props;

    public JRootFrame() {
        this.initComponents();
        if (AppLocal.window == null) {
            AppLocal.window = KeyBoardWindowBuilder.create().initLocale(Locale.FRENCH).addIRobot((IRobot)new AWTRobotHandler()).layer(DefaultLayer.NUMBLOCK).build();
        }
        KeyboardUIManagerTool.installKeyboardDefaults((KeyBoardWindow)AppLocal.window);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                JRootFrame.this.formWindowOpened(evt);
            }
        });
        this.licenseKeyGUI = new MarqueAndLicenseDialogue(this, true);
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    public void initFrame(AppProperties props) throws IOException {
        block6: {
            try {
                this.m_props = props;
                this.m_rootapp = new JRootApp();
                if (this.m_rootapp.initApp(this.m_props)) {
                    this.add((Component)this.m_rootapp, "Center");
                    try {
                        this.setIconImage(ImageIO.read(JRootFrame.class.getResourceAsStream("/com/openbravo/images/favicon.png")));
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    this.setTitle("BIBORNE - 10.0.1.27");
                    this.pack();
                    this.setLocationRelativeTo(null);
                    this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension frameSize = this.getSize();
                    int x = (screenSize.width - frameSize.width) / 2;
                    int y = (screenSize.height - frameSize.height) / 2;
                    this.setLocation(x, y);
                    this.setVisible(true);
                    BasicStorage.pushObject("APP_ROOT_INSTANCE", this.m_rootapp);
                    System.out.println("++++++++++++++  (AppView) BasicStorage.getObject(BasicStorage.APP_ROOT_INSTANCE); : " + (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE"));
                    if (AppLocal.ORDER_ONLINE_ENABLED && AppLocal.SUIVI_ONLINE_ORDER) {
                        OrderOnLineService onLineService = OrderOnLineService.getInstance(null);
                        onLineService.connect();
                    }
                    System.out.println("+++++++++++++++++ message 7");
                    break block6;
                }
                new JFrmConfig(props).setVisible(true);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void restoreWindow() throws RemoteException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JRootFrame.this.getExtendedState() == 1) {
                    JRootFrame.this.setExtendedState(0);
                }
                JRootFrame.this.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JRootFrame.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                JRootFrame.this.formWindowClosing(evt);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_rootapp.tryToClose();
    }

    private void formWindowClosed(WindowEvent evt) {
        System.out.println(" formWindowClosed ");
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.m_rootapp.tryToClose();
    }
}

