/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.glory.fcc.service.FCCClient;
import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.cashlogy.services.CashLogyServices;
import com.openbravo.controllers.ConnectAppController;
import com.openbravo.controllers.DownLoadJsonDBItemController;
import com.openbravo.controllers.LicenceKeyController;
import com.openbravo.controllers.MessageToBeBlockedController;
import com.openbravo.controllers.RootAppController;
import com.openbravo.controllers.borne.BorneMaintenanceController;
import com.openbravo.controllers.borne.MainController;
import com.openbravo.controllers.borne.MessageBorneController;
import com.openbravo.controllers.selfCheckout.LoginSelfCheckoutController;
import com.openbravo.controllers.selfCheckout.SelfCheckoutController;
import com.openbravo.dao.DataLogicDK;
import com.openbravo.dao.DataLogicEmployees;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.dao.DataLogicSynchronisation;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.AppUserView;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.AppViewConnection;
import com.openbravo.pos.forms.BeanFactory;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.BeanFactoryObj;
import com.openbravo.pos.forms.BeanFactoryScript;
import com.openbravo.pos.forms.JPrincipalApp;
import com.openbravo.pos.imports.ImportCities;
import com.openbravo.pos.printer.DeviceTicket;
import com.openbravo.pos.printer.DisplayCustomer;
import com.openbravo.pos.printer.TicketParser;
import com.openbravo.pos.printer.screen.DeviceDisplayWindow;
import com.openbravo.pos.scale.DeviceScale;
import com.openbravo.pos.scanpal2.DeviceScanner;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.BackupUtils;
import com.openbravo.pos.util.DateEncryptor;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Hashcypher;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.BackupService;
import com.openbravo.service.ClientService;
import com.openbravo.service.ClotureService;
import com.openbravo.service.DeliveroService;
import com.openbravo.service.DishopService;
import com.openbravo.service.ItemService;
import com.openbravo.service.NotificationClientService;
import com.openbravo.service.OtterService;
import com.openbravo.service.RusHourService;
import com.openbravo.service.TicketService;
import com.openbravo.service.UberService;
import com.procaisse.db.connection.Session;
import com.procaisse.db.connection.firebase.FirebaseService;
import com.procaisse.db.connection.hibernate.DBUtils;
import com.procaisse.db.sql.BatchSentenceResource;
import com.utils.NetworkUtils;
import fr.biborne.jobqueue.ManagerJobQueue;
import fr.biborne.jobqueue.SortedJobQueue;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.procaisse.dao.config.HibernateUtils;
import fr.protactile.procaisse.dao.entities.BlockingCheck;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.CityInfo;
import fr.protactile.procaisse.dao.entities.LicenceInfo;
import fr.protactile.procaisse.dao.entities.SecurityCheck;
import fr.protactile.procaisse.services.BlockingCheckService;
import fr.protactile.procaisse.services.CityService;
import fr.protactile.procaisse.services.InfoLicenceGeneratedService;
import fr.protactile.procaisse.services.SecurityCheckService;
import fr.protactile.procaisse.tpeCB.CloverService;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import fr.protactile.procaisse.tpeCmi.TPECmi;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRootApp
extends JPanel
implements AppView {
    private static Log logger = LogFactory.getFactory().getInstance(JRootApp.class);
    private AppProperties m_props;
    private Session session;
    private AppUser user;
    private DataLogicSystem m_dlSystem;
    private DataLogicSales m_dlSales;
    private DataLogicStats m_dlStats;
    private DataLogicSynchronisation dlSync;
    private DataLogicItems m_dlItems;
    private DataLogicDK dlDK;
    private Properties m_propsdb = null;
    private String m_sActiveCashIndex;
    private int m_iActiveCashSequence;
    private Date m_dActiveCashDateStart;
    private Date m_dActiveCashDateEnd;
    protected DisplayCustomer displyCustomer;
    private String m_sInventoryLocation;
    private StringBuilder inputtext;
    private DeviceScale m_Scale;
    private DeviceScanner m_Scanner;
    private DeviceTicket m_TP;
    private TicketParser m_TTP;
    private final int TIMER_INTERVAL_SYNCHRONIZE = 60000;
    private Timer m_timer;
    private static String message_update = "<html>Une version ant\u00e9rieure de la base de donn\u00e9es a \u00e9t\u00e9 d\u00e9tect\u00e9. La base de donn\u00e9es va \u00eatre mise \u00e0 jour.<br>ASSUREZ-VOUS DE DISPOSER D'UNE SAUVEGARDE DES DONNEES<br>Voulez-vous continuer ?";
    private static String message_create = "<html>Base de donnees non d\u00e9tect\u00e9e. Une base de donn\u00e9es par d\u00e9faut sera cr\u00e9e.<br>Voulez-vous continuer ?";
    private static String message_ScriptWarning = "Le script de creation de la base de donn\u00e9es a rencontr\u00e9 une erreur.";
    private static String message_noupdatescript = "<html>Une base de donn\u00e9es d'une version ant\u00e9rieure a \u00e9t\u00e9 d\u00e9tect\u00e9 mais il est impossible de mettre \u00e0 jour la base de donn\u00e9es automatiquement.<br>Openbravo ERP va se terminer.";
    private Map<String, BeanFactory> m_aBeanFactories = new HashMap<String, BeanFactory>();
    private String pwd;
    private String pwdManager;
    private String pwdCaissier;
    private JPrincipalApp m_principalapp = null;
    private static HashMap<String, String> m_oldclasses;
    private Connection con;
    private JScrollPane jScrollPane1;
    private JFXPanel fxPanel;
    private Scene currentScene;
    private boolean softUpgraded = false;
    private DataLogicEmployees dlEmployees;
    private DataLogicAdmin dlAdmin;
    private String VERSION_UPGRADE_PERMISSION_LOCK = "3.92.52";
    private String VERSION_UPGRADE_PERMISSION_PAID = "3.92.64";
    private String VERSION_UPGRADE_MIN_MAX_OPTION = "3.92.71";
    private String VERSION_UPGRADE_FREE_OPTION = "3.92.66";
    private String ID_PERMISSION_LOCK = "7";
    private String ID_PERMISSION_PAID = "10";
    private String ID_PERMISSION_RAPPEL_TICKET = "11";
    private Scene scene_home_borne;
    private Scene scene_home_self_checkout;
    public MainController mMainController;
    public SelfCheckoutController mSelfCheckoutController;
    public boolean SHOW_FIRST_VIEW_BORNE;
    public boolean SHOW_FIRST_VIEW_SELF_CHECKOUT;
    private String VERSION_UPGRADE_PERMISSION_RAPPEL_TICKET = "3.92.81";
    private String ID_PERMISSION_ADD_FREE_OPTIONS = "12";
    private String VERSION_UPGRADE_PERMISSION_ADD_FREE_OPTIONS = "3.92.84";
    private String ID_PERMISSION_DELETE_LINES = "14";
    private String VERSION_UPGRADE_PERMISSION_DELETE_LINES = "3.93.18";
    private String VERSION_UPGRADE_LOCAL_SCREEN = "3.93.30";
    private String VERSION_UPGRADE_PRODUCT_PRICES = "3.93.42";
    private String VERSION_UPGRADE_NUMBER_ORDERS = "3.93.71";
    private String VERSION_UPGRADE_PAYMENTS_GTP = "3.93.92";
    private String VERSION_UPGRADE_TAXES_GLOBAL = "3.93.97";
    private ItemService mItemService;
    private TicketService mTicketService;
    private String VERSION_UPGRADE_SHIFTS = "3.93.93";
    private Scene scene_view_key;
    private Scene scene_view_connect_app;
    public LicenceKeyController mLicenceKeyController;
    public ConnectAppController mConnectAppController;
    private final String connectAppFxml = "/fxml/popUp_ConnectApp.fxml";
    private final String licenceKeyFxml = "/fxml/popUp_licence.fxml";
    private SecurityCheckService securityCheckService;
    private PostgreService mPostgreService = null;
    private boolean FIRST_LOAD_APP;
    private Scene scene_view_download_items;
    private final String downloadItemsFxml = "/fxml/DownLoadJsonDBItems.fxml";
    private DownLoadJsonDBItemController downLoadJsonDBItemController;
    private FirebaseService mFirebaseService;
    private boolean FIRST_INSTALL;
    private BlockingCheckService blockingCheckService;
    private Scene scene_view_message_to_be_blocekd;
    public MessageToBeBlockedController messageToBeBlockedController;
    private final String messageToBeBlockedFxml = "/fxml/messageToBeBlocked.fxml";
    private TPECmi mTPECmi;
    private Scene scene_login_backOffice_Cashlogy;
    public LoginSelfCheckoutController mLoginSelfCheckoutController;
    public BorneMaintenanceController maintenanceController;
    private JPanel m_jPanelContainer;
    private JPanel m_jPanelLogin;

    public void showBorne() {
        this.showBorne(false);
    }

    public void showBorne(boolean maintenanceReason) {
        try {
            if (this.scene_home_borne == null || maintenanceReason) {
                FXMLLoader loader;
                if (AppLocal.BORNE_IN_MAINTENANCE) {
                    loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/BorneMaintenanceTemplate.fxml"));
                    Parent rootNode = (Parent)loader.load();
                    this.maintenanceController = (BorneMaintenanceController)loader.getController();
                    this.scene_home_borne = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                    this.scene_home_borne.getStylesheets().add((Object)"/styles/styles.css");
                    this.scene_home_borne.getStylesheets().add((Object)"/styles/app.css");
                    this.maintenanceController.initialize(this, this.scene_home_borne);
                } else {
                    loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/first_page.fxml"));
                    Parent rootNode = (Parent)loader.load();
                    this.mMainController = (MainController)loader.getController();
                    this.scene_home_borne = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                    this.scene_home_borne.getStylesheets().add((Object)"/styles/styles.css");
                    this.scene_home_borne.getStylesheets().add((Object)"/styles/app.css");
                    this.mMainController.initialize(this, this.scene_home_borne, this.fxPanel);
                }
            }
            this.SHOW_FIRST_VIEW_BORNE = true;
            AppLocal.LOAD_ESPACE_MANAGER = false;
            if (AppLocal.CASHLOGY_ENABLED) {
                System.out.println("+++++++++ here 1");
                CashLogyServices mCashLogyServices = CashLogyServices.getInstance();
                mCashLogyServices.initMachine();
            }
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_home_borne));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void showCaisse() {
        try {
            this.mItemService = ItemService.getInstance();
            this.mItemService.updateImages();
            String fxmlFileRoot = "/fxml/login/rootApp.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFileRoot));
            Parent rootNode = (Parent)loader.load();
            this.currentScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            this.currentScene.getStylesheets().add((Object)"/styles/styles.css");
            RootAppController controller = (RootAppController)loader.getController();
            controller.init(this, this.currentScene, this.fxPanel);
            Platform.runLater(() -> this.fxPanel.setScene(this.currentScene));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadFirstView() {
        try {
            InfoLicenceGeneratedService infoLicenceGeneratedService;
            boolean first_activation;
            this.securityCheckService = SecurityCheckService.getInstance();
            if (this.fxPanel == null) {
                this.fxPanel = new JFXPanel();
                this.m_jPanelLogin.add((Component)this.fxPanel, "Center");
            }
            boolean bl = first_activation = !(infoLicenceGeneratedService = InfoLicenceGeneratedService.getInstance()).checkIfKeenioSiretExist();
            if (first_activation) {
                String errorMsg = "\u00c9quipement non-activ\u00e9";
                this.showViewKey(errorMsg, infoLicenceGeneratedService.getMarqueNF(), infoLicenceGeneratedService.getKeenio(), this.fxPanel);
            } else {
                LicenceInfo licence = infoLicenceGeneratedService.checkLicence();
                if (licence != null) {
                    boolean blocked = licence.isBlocked();
                    this.blockingCheckService = BlockingCheckService.getInstance();
                    BlockingCheck blockingCheck = this.blockingCheckService.getBlockedCheckInfoAftercheck();
                    if (blockingCheck != null && (blockingCheck.isBlocked() || blockingCheck.isToBeBlocked())) {
                        System.out.println("step 1");
                        if (blockingCheck.isBlocked()) {
                            System.out.println("step 2");
                            String errorMsg = "Cher client, votre acc\u00e8s \u00e0 l'application a \u00e9t\u00e9 suspendu. Pour r\u00e9soudre cette situation, veuillez contacter notre \u00e9quipe de support client au plus vite au 0972663873 ";
                            this.showViewConnectApp(errorMsg, false, this.fxPanel, blocked);
                        } else if (blockingCheck.isToBeBlocked()) {
                            System.out.println("step 2");
                            if (!licence.isActive()) {
                                System.out.println("step 3");
                                String errorMsg = licence.getErrorMsg();
                                this.showViewKey(errorMsg, infoLicenceGeneratedService.getMarqueNF(), infoLicenceGeneratedService.getKeenio(), this.fxPanel);
                            } else {
                                System.out.println("step 4");
                                String errorMsg = "Cher client, votre acc\u00e8s \u00e0 l'application sera suspendu en raison de probl\u00e8mes de paiement dans " + blockingCheck.getRemainsDays() + " jours. Pour r\u00e9soudre cette situation, veuillez contacter notre \u00e9quipe de support client au plus vite au 0972663873 ";
                                this.showViewMessageToBeBlocked(errorMsg, this.fxPanel);
                            }
                        }
                    } else if (!licence.isActive()) {
                        System.out.println("step 5");
                        String errorMsg = licence.getErrorMsg();
                        this.showViewKey(errorMsg, infoLicenceGeneratedService.getMarqueNF(), infoLicenceGeneratedService.getKeenio(), this.fxPanel);
                    } else {
                        System.out.println("step 6");
                        this.securityCheckService.setDateValidation(licence.getDailyDate(), licence.getTemporaryUsePeriod());
                        this.loadFirstViewAfterCheckKeyLicence();
                        if (!AppLocal.FTP_CONFIG_VALUE) {
                            String keen_id = infoLicenceGeneratedService.getKeenio();
                            this.initSetupFTP(keen_id);
                        }
                    }
                } else {
                    CaisseInfo mCaisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
                    this.blockingCheckService = BlockingCheckService.getInstance();
                    BlockingCheck blockingCheck = this.blockingCheckService.getBlockedCheckInfoAftercheck();
                    if (blockingCheck != null && (blockingCheck.isBlocked() || blockingCheck.isToBeBlocked())) {
                        if (blockingCheck.isBlocked()) {
                            String errorMsg = "Cher client, votre acc\u00e8s \u00e0 l'application a \u00e9t\u00e9 suspendu en raison de probl\u00e8mes de paiement en cours. Pour r\u00e9soudre cette situation, veuillez contacter notre \u00e9quipe de support client au plus vite au 0972663873 ";
                            this.showViewConnectApp(errorMsg, false, this.fxPanel, true);
                        } else if (blockingCheck.isToBeBlocked()) {
                            if (mCaisseInfo != null && !mCaisseInfo.isActive().booleanValue()) {
                                String errorMsg = "\u00c9quipement non-activ\u00e9";
                                this.showViewKey(errorMsg, infoLicenceGeneratedService.getMarqueNF(), infoLicenceGeneratedService.getKeenio(), this.fxPanel);
                            } else {
                                String errorMsg = "Cher client, votre acc\u00e8s \u00e0 l'application sera suspendu en raison de probl\u00e8mes de paiement en cours apres " + blockingCheck.getRemainsDays() + " Pour r\u00e9soudre cette situation, veuillez contacter notre \u00e9quipe de support client au plus vite au 0972663873 ";
                                this.showViewMessageToBeBlocked(errorMsg, this.fxPanel);
                            }
                        }
                    } else if (mCaisseInfo != null && (mCaisseInfo.isBlocked().booleanValue() || !mCaisseInfo.isActive().booleanValue())) {
                        if (!mCaisseInfo.isActive().booleanValue()) {
                            String errorMsg = "\u00c9quipement non-activ\u00e9";
                            this.showViewKey(errorMsg, infoLicenceGeneratedService.getMarqueNF(), infoLicenceGeneratedService.getKeenio(), this.fxPanel);
                        }
                    } else {
                        SecurityCheck mSecurity = this.securityCheckService.getLastSecurityCheck();
                        if (mSecurity != null) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            String lastValidationDateCrypted = mSecurity.getLastValidationDateCrypted();
                            Date lastValidationDate = dateFormat.parse(DateEncryptor.decryptDate(lastValidationDateCrypted));
                            int daysUsed = this.calculateDaysUsed(lastValidationDate, new Date());
                            if (daysUsed >= mSecurity.getTemporary_use_period()) {
                                int daysWithoutValidation = mSecurity.getTemporary_use_period();
                                boolean verification_valid = false;
                                if (mSecurity.getLastVerificationCodeDateCrypted() != null && !mSecurity.getLastVerificationCodeDateCrypted().isEmpty() && mSecurity.getUnlock_period() > 0) {
                                    Date dateVerificationCode = dateFormat.parse(DateEncryptor.decryptDate(mSecurity.getLastVerificationCodeDateCrypted()));
                                    int daysVerificationUsed = this.calculateDaysUsed(dateVerificationCode, new Date());
                                    if (daysVerificationUsed < mSecurity.getUnlock_period()) {
                                        verification_valid = true;
                                    } else {
                                        daysWithoutValidation = mSecurity.getUnlock_period();
                                    }
                                }
                                if (verification_valid) {
                                    this.loadFirstViewAfterCheckKeyLicence();
                                } else {
                                    String errorMessage = mSecurity.isTemporaryPasswordUsed() ? "Votre appareil ne s'est pas connect\u00e9 \u00e0 Internet depuis plus de " + daysWithoutValidation + " Jours. Pour des raisons de s\u00e9curit\u00e9, une validation est n\u00e9cessaire et obligatoire. Merci de connecter l'appareil \u00e0 Internet puis appuyer sur le bouton suivant :" : "Votre appareil n\u00e9cessite une validation de s\u00e9curit\u00e9, car il n'a pas \u00e9t\u00e9 connect\u00e9 \u00e0 Internet depuis plus" + daysWithoutValidation + ". Si vous pouvez actuellement le connecter \u00e0 Internet, appuyez simplement sur le bouton 'J'AI CONNECT\u00c9 L'APPAREIL'. Si ce n'est pas possible, veuillez contacter le support au 0972663873 pour obtenir un code de d\u00e9verrouillage temporaire, puis saisissez ce code en appuyant sur 'JE SAISIS LE CODE'";
                                    System.out.println("showViewConnectApp");
                                    this.showViewConnectApp(errorMessage, mSecurity.isTemporaryPasswordUsed(), this.fxPanel, false);
                                }
                            } else {
                                this.loadFirstViewAfterCheckKeyLicence();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showFirstViewBorne() throws BasicException, IOException {
        boolean blocked = this.m_dlSystem.borneDisbled();
        if (blocked) {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/message_borne.fxml"));
            Parent rootNode = (Parent)loader.load();
            MessageBorneController controller = (MessageBorneController)loader.getController();
            Scene scene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            scene.getStylesheets().add((Object)"/styles/styles.css");
            scene.getStylesheets().add((Object)"/styles/app.css");
            controller.initialize();
            this.fxPanel.setScene(scene);
        } else {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/first_page.fxml"));
            Parent rootNode = (Parent)loader.load();
            MainController controller = (MainController)loader.getController();
            Scene scene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            scene.getStylesheets().add((Object)"/styles/styles.css");
            scene.getStylesheets().add((Object)"/styles/app.css");
            controller.initialize(this, scene, this.fxPanel);
            this.fxPanel.setScene(scene);
        }
    }

    private void importCities() {
        CityService mCityService = CityService.getInstance();
        List<CityInfo> cities = mCityService.getCities();
        if (cities == null || cities.isEmpty()) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImportCities mImportCities = new ImportCities();
                        mImportCities.importCities();
                    }
                    catch (IOException | URISyntaxException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    private void deleteOldLogApplication() {
        try {
            Date lastdelete = this.m_dlSystem.getDateDeleteLogs();
            boolean delete = false;
            boolean add_delete_date = false;
            if (lastdelete == null) {
                delete = true;
                add_delete_date = true;
            } else {
                LocalDate date = DateUtils.asLocalDate(lastdelete);
                date.plusDays(7L);
                LocalDate date_today = LocalDate.now();
                delete = date_today.isAfter(date);
            }
            if (delete) {
                File log_folder = new File(new File(SystemUtils.SYS_USER_HOME), "log");
                if (log_folder != null && log_folder.exists()) {
                    FilerUtils m_FilerUtils = FilerUtils.getInstance();
                    m_FilerUtils.deleteFolder(log_folder);
                }
                this.m_dlSystem.saveLastDelete(add_delete_date);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private String getLineTimer() {
        return Formats.HOURMIN.formatValue(new Date());
    }

    private String getLineDate() {
        return Formats.SIMPLEDATE.formatValue(new Date());
    }

    public AppUser getUser() {
        return this.user;
    }

    public void setUser(AppUser user) {
        this.user = user;
    }

    public JRootApp() {
        this.initComponents();
    }

    public boolean initApp(AppProperties props) throws IOException, SQLException {
        String sWareHouse;
        this.m_props = props;
        this.pwd = Hashcypher.hashString("123888");
        this.pwdManager = Hashcypher.hashString("1234");
        this.pwdCaissier = Hashcypher.hashString("0000");
        System.out.println("pwd : " + this.pwd);
        System.out.println("Hashcypher.hashString(\"123888\") : " + Hashcypher.hashString("123666"));
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        HibernateUtils.init(props);
        if (AppLocal.KITCHEN_COMPOSITE) {
            TicketSharedService mTicketSharedService;
            DBUtils.initDB();
            if (AppLocal.KITCHEN_COMPOSITE && AppLocal.MODULE_TABLETTO && (mTicketSharedService = TicketSharedService.getInstance()) != null) {
                mTicketSharedService.deleteOrderTabletto();
            }
        }
        try {
            this.session = AppViewConnection.createSession(this.m_props);
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
            JMessageDialog.showMessage(new JFrame(), new MessageInf(-16777216, e.getMessage(), e));
            return false;
        }
        this.m_dlSystem = (DataLogicSystem)this.getBean("com.openbravo.dao.DataLogicSystem");
        this.m_dlSales = (DataLogicSales)this.getBean("com.openbravo.dao.DataLogicSales");
        this.m_dlItems = (DataLogicItems)this.getBean("com.openbravo.dao.DataLogicItems");
        this.dlDK = (DataLogicDK)this.getBean("com.openbravo.dao.DataLogicDK");
        this.m_dlStats = (DataLogicStats)this.getBean("com.openbravo.dao.DataLogicStats");
        this.dlSync = (DataLogicSynchronisation)this.getBean("com.openbravo.dao.DataLogicSynchronisation");
        this.dlEmployees = (DataLogicEmployees)this.getBean("com.openbravo.dao.DataLogicEmployees");
        AppLocal.dlProduct = (DataLogicProduct)this.getBean("com.openbravo.dao.DataLogicProduct");
        AppLocal.dlOrders = (DataLogicOrder)this.getBean("com.openbravo.dao.DataLogicOrder");
        AppLocal.dlItems = this.m_dlItems;
        AppLocal.dlDK = this.dlDK;
        AppLocal.dlSync = this.dlSync;
        AppLocal.dlSystem = this.m_dlSystem;
        AppLocal.dlUser = (DataLogicAdmin)this.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        AppLocal.dlSales = this.m_dlSales;
        AppLocal.dlStats = this.m_dlStats;
        AppLocal.dlSales.setDlItems(AppLocal.dlItems);
        String sDBVersion = this.readDataBaseVersion();
        String softVersion = this.readSoftVersion();
        Integer iDBVersion = NumericUtils.decodeAppVersionNumber(sDBVersion);
        System.out.println("sDBVersion : " + sDBVersion);
        System.out.println("softVersion : " + softVersion);
        System.out.println("iDBVersion : " + iDBVersion);
        if (iDBVersion != null) {
            System.out.println("upgrade database");
            this.doUpgradeDB();
        } else if (!"3.94.47".equals(sDBVersion)) {
            String sScript;
            String string = sScript = sDBVersion == null ? this.m_dlSystem.getInitScript() + "-create.sql" : this.m_dlSystem.getInitScript() + "-upgrade-" + sDBVersion + ".sql";
            if (JRootApp.class.getResource(sScript) == null) {
                JMessageDialog.showMessage(new JFrame(), new MessageInf(-16777216, (String)(sDBVersion == null ? "Base de donnees " + this.session.DB.getName() + " non support\u00e9e." : message_noupdatescript)));
                this.session.close();
                return false;
            }
            try {
                System.out.println("JRootApp.initApp BEFORE >>>> " + AppLocal.token + " <<<<");
                if (AppLocal.token == null) {
                    AppLocal.token = StringUtils.getToken();
                    System.out.println("JRootApp.initApp AFTER >>>> " + AppLocal.token + " <<<<");
                }
                System.out.println("JRootApp.initApp >>>> " + AppLocal.token);
                BatchSentenceResource bsentence = new BatchSentenceResource(this.session, sScript);
                bsentence.putParameter("APP_ID", Matcher.quoteReplacement("procaisse"));
                bsentence.putParameter("APP_NAME", Matcher.quoteReplacement("Procaisse"));
                bsentence.putParameter("APP_VERSION", Matcher.quoteReplacement("3.94.47"));
                bsentence.putParameter("token", Matcher.quoteReplacement(AppLocal.token));
                bsentence.putParameter("pwd", Matcher.quoteReplacement(this.pwd));
                bsentence.putParameter("pwdManager", Matcher.quoteReplacement(this.pwdManager));
                bsentence.putParameter("pwdCaissier", Matcher.quoteReplacement(this.pwdCaissier));
                List l = bsentence.list();
                if (l.size() > 0) {
                    JMessageDialog.showMessage(new JFrame(), new MessageInf(-33554432, message_ScriptWarning, l.toArray(new Throwable[l.size()])));
                }
                this.m_dlSystem.upgradeSoftware(sDBVersion);
                this.softUpgraded = true;
                Journal.writeToJET(new Event(260, "Initialisation des donn\u00e9es", " ", "Cr\u00e9ation de la base de donn\u00e9es ", new Date().getTime(), "3.94.47"));
            }
            catch (BasicException e) {
                LogToFile.log("severe", e.getMessage(), e);
                this.session.close();
                return false;
            }
            System.out.println("create database 0 ***********");
            this.FIRST_INSTALL = true;
        }
        try {
            List<CategoryInfo> categories = AppLocal.dlSales.getCategories();
            this.FIRST_LOAD_APP = categories == null || categories.isEmpty();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        try {
            this.createTableArchiv();
            this.m_dlSystem.createTablePRODUCTS_SIZE();
            this.m_dlSystem.createTableTAGS_WORKSHIFT();
        }
        catch (SQLException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (softVersion == null) {
            Journal.writeToJET(new Event(250, "Nouvelle version majeure du logiciel", "", "Num\u00e9ro de version", new Date().getTime(), "10.0.1.27"));
        }
        System.out.println("softVersion test : " + softVersion);
        System.out.println("AppLocal.SOFT_VERSION test : 10.0.1.27");
        if (softVersion != null && !softVersion.equals("10.0.1.27")) {
            if (Integer.valueOf(softVersion.replace(".", "")) <= Journal.MEGRATION_JET) {
                Journal.extarctProtectedfile();
                File srcFile = FileUtils.getFile((String[])new String[]{AppLocal.JOURNAL_FILE});
                File dstFile = FileUtils.getFile((String[])new String[]{(AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME) + File.separator + "procaisse-properties" + File.separator + "JET_" + softVersion + ".csv"});
                FileUtils.copyFile((File)srcFile, (File)dstFile);
                PrintWriter writer = new PrintWriter(srcFile);
                writer.print("");
                writer.close();
                Journal.protectFile(2);
                Journal.protectFile(2, "JET_" + softVersion + ".zip", dstFile);
            }
            AppLocal.UPGRADESERVER = true;
            this.addEventNewVersion(softVersion, "10.0.1.27");
            if (!this.softUpgraded) {
                try {
                    this.m_dlSystem.upgradeSoftware("3.94.47");
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        try {
            AppLocal.photos = this.m_dlSales.getAllPhoto();
            AppLocal.printerCaisse = this.m_dlSales.getPrinterByID(1);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        String sDBToken = this.readToken();
        String lastToken = null;
        if (sDBToken == null) {
            lastToken = this.lastToken();
            if (lastToken != null) {
                AppLocal.token = lastToken;
                this.saveToken();
            } else {
                String sScript = this.m_dlSystem.getInitScript() + "-upgrade.sql";
                if (JRootApp.class.getResource(sScript) == null) {
                    JMessageDialog.showMessage(new JFrame(), new MessageInf(-16777216, message_noupdatescript));
                    this.session.close();
                    return false;
                }
                try {
                    BatchSentenceResource bsentence = new BatchSentenceResource(this.session, sScript);
                    bsentence.putParameter("token", Matcher.quoteReplacement(AppLocal.token));
                    List l = bsentence.list();
                    if (l.size() > 0) {
                        JMessageDialog.showMessage(new JFrame(), new MessageInf(-33554432, message_ScriptWarning, l.toArray(new Throwable[l.size()])));
                    }
                }
                catch (BasicException e) {
                    LogToFile.log("severe", e.getMessage(), e);
                    this.session.close();
                    return false;
                }
            }
        }
        if (this.countUser() == 0) {
            this.addCountUser();
        }
        if (AppLocal.CMI_TPE_PAYMENT) {
            try {
                this.mTPECmi = TPECmi.getInstance();
                this.mTPECmi.initCmi();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        this.m_propsdb = this.m_dlSystem.getResourceAsProperties(this.m_props.getHost() + "/properties");
        try {
            String sActiveCashIndex = this.m_propsdb.getProperty("activecash");
            System.out.println("sActiveCashIndex : " + sActiveCashIndex);
            Object[] valcash = sActiveCashIndex == null ? null : this.m_dlSystem.findActiveCash(sActiveCashIndex);
            System.out.println("valcash : " + valcash);
            if (valcash == null || !this.m_props.getHost().equals(valcash[0])) {
                this.setActiveCash(UUID.randomUUID().toString(), this.m_dlSystem.getSequenceCash(this.m_props.getHost()) + 1, new Date(), null);
                this.m_dlSystem.execInsertCash(new Object[]{this.getActiveCashIndex(), this.m_props.getHost(), this.getActiveCashSequence(), this.getActiveCashDateStart(), this.getActiveCashDateEnd()});
            } else {
                this.setActiveCash(sActiveCashIndex, (Integer)valcash[1], (Date)valcash[2], (Date)valcash[3]);
            }
            System.out.println("m_sActiveCashIndex :" + this.m_sActiveCashIndex);
            AppLocal.m_sActiveCashIndex = this.m_sActiveCashIndex;
        }
        catch (BasicException e) {
            e.printStackTrace();
            MessageInf msg = new MessageInf(-67108864, "Impossible de cl\u00f4turer la caisse.", e);
            msg.show(this);
            this.session.close();
            return false;
        }
        if (AppLocal.TYPE_DISPLAY != null && !AppLocal.TYPE_DISPLAY.isEmpty() && AppLocal.TYPE_DISPLAY.startsWith("window")) {
            AppLocal.displayDualScreen = new DeviceDisplayWindow();
        }
        try {
            this.m_TP = new DeviceTicket(this, this.m_props);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        try {
            sWareHouse = this.m_dlSystem.findLocationName(this.m_sInventoryLocation);
        }
        catch (BasicException e) {
            sWareHouse = null;
        }
        try {
            AppLocal.user_maintenance = this.m_dlSales.getUserById("0");
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        BasicStorage.pushObject("APP_ROOT_INSTANCE", this);
        this.setInfoLicence();
        if ((AppLocal.modeCaisse == null || AppLocal.modeCaisse.equalsIgnoreCase("Caisse")) && AppLocal.licence != null && AppLocal.licence.equals("livraison")) {
            this.importCities();
        }
        if (AppLocal.MODULE_UBER_EATS) {
            try {
                UberService mUberService = UberService.getInstance();
                mUberService.connect();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.MODULE_DELIVERO) {
            try {
                DeliveroService mDeliveroService = DeliveroService.getInstance();
                mDeliveroService.connect();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.MODULE_OTTER) {
            try {
                OtterService mOtterService = OtterService.getInstance();
                mOtterService.connect();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.MODULE_RUSHOUR) {
            try {
                RusHourService mRusHourService = RusHourService.getInstance();
                mRusHourService.connect();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        ClientService mClientService = new ClientService();
        mClientService.updatePOSVersion();
        try {
            this.loadFirstView();
        }
        catch (Exception e) {
            LogToFile.log("sever", e.getMessage(), e);
        }
        this.displyCustomer = new DisplayCustomer(this.getDeviceTicket());
        this.printerDisplay();
        if (AppLocal.CREDIT_EMPLOYEE && new Date().getDate() >= AppLocal.DAY_RECHARGE) {
            try {
                int last_month_updated = this.dlEmployees.getMonthUpdated();
                if (last_month_updated != new Date().getMonth() + 1) {
                    this.dlEmployees.incrementeCredit();
                }
            }
            catch (BasicException e) {
                LogToFile.log("sever", e.getMessage(), e);
            }
        }
        this.deleteOldLogApplication();
        NotificationClientService mNotificationClientService = NotificationClientService.getInstance();
        mNotificationClientService.connect();
        if (AppLocal.NEPTING_AUTOMATE) {
            final PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this);
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (facade.isActivated()) {
                            facade.doLogin();
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
        if (AppLocal.MODULE_DISHOP) {
            try {
                DishopService mDeliverooDishopService = DishopService.getInstance();
                mDeliverooDishopService.connect();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.MODULE_CLOVER) {
            try {
                CloverService mCloverService = CloverService.getInstance();
                mCloverService.checkCodeAuthorization();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.MODULE_MEV) {
            SortedJobQueue jobOqueue = new SortedJobQueue();
            AppLocal.managerJobQueue = new ManagerJobQueue(jobOqueue);
            AppLocal.managerJobQueue.handleJobs();
        }
        if (AppLocal.GENERATE_ID_GLOBAL_ITEMS) {
            if (this.mItemService == null) {
                this.mItemService = ItemService.getInstance(this);
            }
            this.mItemService.setIdGlobalItems();
        }
        try {
            AppLocal.globalTaxes = this.m_dlSales.getGloablTaxes();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.UpdateOldUserMaintain();
        final boolean is_master_pos = AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equals("Maitre");
        try {
            this.mFirebaseService = FirebaseService.getInstance();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS && is_master_pos) {
                            JRootApp.this.mFirebaseService.UploadCarteToFireBase();
                        }
                        JRootApp.this.mFirebaseService.uploadProcaisseProperties();
                        JRootApp.this.mFirebaseService.uploadAllNF525Archives();
                        JRootApp.this.mFirebaseService.uploadJetCsvFromZip();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return true;
    }

    private String readDataBaseVersion() {
        try {
            return this.m_dlSystem.findVersion();
        }
        catch (Exception ed) {
            return null;
        }
    }

    private String readSoftVersion() {
        try {
            return this.m_dlSystem.findSoftVersion();
        }
        catch (Exception ed) {
            return null;
        }
    }

    private String readToken() {
        try {
            return this.m_dlSystem.findToken();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String lastToken() {
        try {
            return this.m_dlSystem.lastToken();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void tryToClose() {
        if (this.closeAppView()) {
            this.m_TP.getDeviceDisplay().clearVisor();
            this.session.close();
            if (AppLocal.GLORY_ENABLED && !FCCClient.isInstanceNull()) {
                FCCClient.getFccInstance().stopLestening();
            }
            NotificationClientService mNotificationClientService = NotificationClientService.getInstance();
            mNotificationClientService.stop();
            if (AppLocal.NEPTING_AUTOMATE) {
                System.out.println("++++++++++ tryToClose step 1");
                PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this);
                try {
                    if (facade.isActivated()) {
                        facade.logout();
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            SwingUtilities.getWindowAncestor(this).dispose();
        }
        System.exit(0);
    }

    @Override
    public DeviceTicket getDeviceTicket() {
        return this.m_TP;
    }

    @Override
    public DeviceScale getDeviceScale() {
        return this.m_Scale;
    }

    @Override
    public DeviceScanner getDeviceScanner() {
        return this.m_Scanner;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    @Override
    public String getInventoryLocation() {
        return this.m_sInventoryLocation;
    }

    @Override
    public String getActiveCashIndex() {
        return this.m_sActiveCashIndex;
    }

    @Override
    public int getActiveCashSequence() {
        return this.m_iActiveCashSequence;
    }

    @Override
    public Date getActiveCashDateStart() {
        return this.m_dActiveCashDateStart;
    }

    @Override
    public Date getActiveCashDateEnd() {
        return this.m_dActiveCashDateEnd;
    }

    @Override
    public void setActiveCash(String sIndex, int iSeq, Date dStart, Date dEnd) {
        this.m_sActiveCashIndex = sIndex;
        this.m_iActiveCashSequence = iSeq;
        this.m_dActiveCashDateStart = dStart;
        this.m_dActiveCashDateEnd = dEnd;
        this.m_propsdb.setProperty("activecash", this.m_sActiveCashIndex);
        this.m_dlSystem.setResourceAsProperties(this.m_props.getHost() + "/properties", this.m_propsdb);
    }

    @Override
    public AppProperties getProperties() {
        return this.m_props;
    }

    @Override
    public Object getBean(String beanfactory) throws BeanFactoryException {
        BeanFactory bf = this.m_aBeanFactories.get(beanfactory = JRootApp.mapNewClass(beanfactory));
        if (bf == null) {
            if (beanfactory.startsWith("/")) {
                bf = new BeanFactoryScript(beanfactory);
            } else {
                try {
                    Class<?> bfclass = Class.forName(beanfactory);
                    if (BeanFactory.class.isAssignableFrom(bfclass)) {
                        bf = (BeanFactory)bfclass.newInstance();
                    } else {
                        Constructor<?> constMyView = bfclass.getConstructor(AppView.class);
                        Object bean = constMyView.newInstance(this);
                        bf = new BeanFactoryObj(bean);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new BeanFactoryException(e);
                }
            }
            this.m_aBeanFactories.put(beanfactory, bf);
            if (bf instanceof BeanFactoryApp) {
                ((BeanFactoryApp)bf).init(this);
            }
        }
        return bf.getBean();
    }

    private static String mapNewClass(String classname) {
        String newclass = m_oldclasses.get(classname);
        return newclass == null ? classname : newclass;
    }

    private static void initOldClasses() {
        m_oldclasses = new HashMap();
        m_oldclasses.put("com.openbravo.pos.reports.JReportCustomers", "/com/openbravo/reports/customers.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportCustomersB", "/com/openbravo/reports/customersb.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportClosedPos", "/com/openbravo/reports/closedpos.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportClosedProducts", "/com/openbravo/reports/closedproducts.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JChartSales", "/com/openbravo/reports/chartsales.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportInventory", "/com/openbravo/reports/inventory.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportInventory2", "/com/openbravo/reports/inventoryb.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportInventoryBroken", "/com/openbravo/reports/inventorybroken.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportInventoryDiff", "/com/openbravo/reports/inventorydiff.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportPeople", "/com/openbravo/reports/people.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportTaxes", "/com/openbravo/reports/taxes.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportUserSales", "/com/openbravo/reports/usersales.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportProducts", "/com/openbravo/reports/products.bs");
        m_oldclasses.put("com.openbravo.pos.reports.JReportCatalog", "/com/openbravo/reports/productscatalog.bs");
        m_oldclasses.put("com.openbravo.pos.panels.JPanelTax", "com.openbravo.pos.inventory.TaxPanel");
    }

    @Override
    public void waitCursorBegin() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void waitCursorEnd() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public AppUserView getAppUserView() {
        return this.m_principalapp;
    }

    private void printerDisplay() {
        this.displyCustomer.display(AppLocal.messageWelcome, "", null, null);
    }

    public AppUser login(String password, boolean fingerPrint) throws BasicException {
        AppUser user = fingerPrint ? this.m_dlSales.getUserByFingerPrint(password) : this.m_dlSales.getUserByPassword(Hashcypher.hashString(password));
        AppLocal.user = user;
        return user;
    }

    public CaisseInfo getCaisse() throws BasicException {
        CaisseInfo caisse = this.m_dlSales.getCaisse(AppLocal.token);
        return caisse;
    }

    private void showView(String view) {
        CardLayout cl = (CardLayout)this.m_jPanelContainer.getLayout();
        cl.show(this.m_jPanelContainer, view);
    }

    public void openAppView(AppUser user) {
        if (this.closeAppView()) {
            this.m_principalapp = new JPrincipalApp(this, user, 1);
            this.m_jPanelContainer.add((Component)this.m_principalapp, "_" + this.m_principalapp.getUser().getId());
            this.showView("_" + this.m_principalapp.getUser().getId());
            this.m_principalapp.activate();
        }
    }

    public void openAppView(AppUser user, int role, boolean modeCaisse) {
        if (this.closeAppView()) {
            this.m_principalapp = new JPrincipalApp(this, user, role);
            this.m_jPanelContainer.add((Component)this.m_principalapp, "_" + this.m_principalapp.getUser().getId());
            this.showView("_" + this.m_principalapp.getUser().getId());
            this.m_principalapp.activate();
        }
    }

    public void exitToLogin() {
        this.closeAppView();
        this.showLogin();
    }

    @Override
    public boolean closeAppView() {
        if (this.m_principalapp == null) {
            return true;
        }
        if (!this.m_principalapp.deactivate()) {
            return false;
        }
        this.m_jPanelContainer.remove(this.m_principalapp);
        this.m_principalapp = null;
        return true;
    }

    private void showLogin() {
        this.showView("login");
        this.inputtext = new StringBuilder();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private void processKey(char c) {
        if (c == '\n' || c == '?') {
            AppUser user = null;
            try {
                user = this.m_dlSystem.findPeopleByCard(this.inputtext.toString());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            if (user == null) {
                MessageInf msg = new MessageInf(-33554432, AppLocal.getIntString("message.nocard"));
                msg.show(this);
            } else {
                this.openAppView(user);
            }
            this.inputtext = new StringBuilder();
        } else {
            this.inputtext.append(c);
        }
    }

    private void initComponents() {
        this.m_jPanelContainer = new JPanel();
        this.m_jPanelLogin = new JPanel();
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(1024, 768));
        this.setLayout(new BorderLayout());
        this.m_jPanelContainer.setLayout(new CardLayout());
        this.m_jPanelLogin.setLayout(new BorderLayout());
        this.m_jPanelContainer.add((Component)this.m_jPanelLogin, "login");
        this.add((Component)this.m_jPanelContainer, "Center");
    }

    public JFXPanel getFxPanel() {
        return this.fxPanel;
    }

    public void setFxPanel(JFXPanel fxPanel) {
        this.fxPanel = fxPanel;
    }

    public Scene getCurrentScene() {
        return this.currentScene;
    }

    public void setCurrentScene(Scene currentScene) {
        this.currentScene = currentScene;
    }

    public JPanel getPanelLogin() {
        return this.m_jPanelLogin;
    }

    public DataLogicSales getM_dlSales() {
        return this.m_dlSales;
    }

    public void setM_dlSales(DataLogicSales m_dlSales) {
        this.m_dlSales = m_dlSales;
    }

    public DataLogicItems getM_dlItems() {
        return this.m_dlItems;
    }

    public void setM_dlItems(DataLogicItems m_dlItems) {
        this.m_dlItems = m_dlItems;
    }

    public DataLogicStats getM_dlStats() {
        return this.m_dlStats;
    }

    public void setM_dlStats(DataLogicStats m_dlStats) {
        this.m_dlStats = m_dlStats;
    }

    public void createTableArchiv() throws SQLException {
        this.con = this.session.getConnection();
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getTables(null, "APP", "ARCHIV_PERIODE", null);
        if (!rs.next()) {
            this.con.createStatement().execute("CREATE TABLE ARCHIV_PERIODE(    id VARCHAR(256) NOT NULL,    grand_total DOUBLE PRECISION,    grand_total_Perpetual DOUBLE PRECISION,    signature VARCHAR(2000) DEFAULT  NULL,    TVA_5_5 DOUBLE PRECISION,    TVA_10 DOUBLE PRECISION,    TVA_20 DOUBLE PRECISION,    timestampGDH timestamp,    chemin  VARCHAR(256) default NULL,    type_PERIODE VARCHAR(20) DEFAULT 'j' NOT NULL,    PRIMARY KEY (id))");
        }
    }

    public boolean isDatabaseCorrumpu() throws SQLException {
        this.con = this.session.getConnection();
        DatabaseMetaData dbmd = this.con.getMetaData();
        ResultSet rs = dbmd.getTables(null, "APP", "APPLICATIONS", null);
        if (!rs.next()) {
            return true;
        }
        ResultSet rs1 = dbmd.getTables(null, "APP", "CAISSE", null);
        if (!rs1.next()) {
            return true;
        }
        ResultSet rs2 = dbmd.getTables(null, "APP", "DOCUMENT", null);
        if (!rs2.next()) {
            return true;
        }
        ResultSet rs3 = dbmd.getTables(null, "APP", "ENTETE", null);
        if (!rs3.next()) {
            return true;
        }
        ResultSet rs4 = dbmd.getTables(null, "APP", "TICKETS", null);
        return !rs4.next();
    }

    public void DropTableTaxes() {
        try {
            DatabaseMetaData dbmd;
            ResultSet rs;
            this.con = this.session.getConnection();
            DatabaseMetaData dbmd2 = this.con.getMetaData();
            ResultSet rs2 = dbmd2.getTables(null, "APP", "TAXLINES", null);
            if (rs2.next()) {
                this.con.createStatement().execute("Drop TABLE TAXLINES ");
            }
            if ((rs = (dbmd = this.con.getMetaData()).getTables(null, "APP", "TAXES", null)).next()) {
                this.con.createStatement().execute(" Drop TABLE TAXES ");
            }
        }
        catch (SQLException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void saveToken() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        config.setProperty("machine.token", AppLocal.token);
        config.save();
    }

    private void rappelBackupUSB() {
        if (AppLocal.isBackupRecomended.booleanValue()) {
            int dialogResult = JOptionPane.showConfirmDialog(null, "Voulez vous faire une sauvegarde externe ?", "Sauvegarde externe", 0);
            if (dialogResult == 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DirectoryChooser chooser = new DirectoryChooser();
                        chooser.setInitialDirectory(new File("."));
                        chooser.setTitle("Disque externe des backups");
                        File selectedFile = chooser.showDialog(null);
                        if (selectedFile != null) {
                            try {
                                new BackupService().doBackup(selectedFile);
                                AppLocal.isBackupRecomended = false;
                            }
                            catch (IOException ex) {
                                LogToFile.log("severe", null, ex);
                            }
                        }
                    }
                });
            } else {
                logger.info((Object)"No Selection");
            }
        }
    }

    public boolean doUpgradeDB() {
        String sDBVersion = this.readDataBaseVersion();
        String softVersion = this.readSoftVersion();
        Integer iDBVersion = NumericUtils.decodeAppVersionNumber(sDBVersion);
        Integer cAppVersion = NumericUtils.decodeAppVersionNumber("3.94.47");
        System.out.println("+++++++++++ cAppVersion : " + cAppVersion);
        LinkedHashMap<String, CallSite> array_scripts = new LinkedHashMap<String, CallSite>();
        if (iDBVersion <= AppLocal.UPGRADE_VERSION_DB) {
            String sScript = this.m_dlSystem.getInitScript() + "-upgrade-" + NumericUtils.encodeAppVersionNumber(iDBVersion) + ".sql";
            if (JRootApp.class.getResource(sScript) != null) {
                array_scripts.put(NumericUtils.encodeAppVersionNumber(iDBVersion), (CallSite)((Object)sScript));
            }
            for (int x = AppLocal.UPGRADE_VERSION_DB.intValue(); x <= cAppVersion; ++x) {
                String sVersion = NumericUtils.encodeAppVersionNumber(x);
                sScript = this.m_dlSystem.getInitScript() + "-upgrade-" + sVersion + ".sql";
                if (JRootApp.class.getResource(sScript) == null) continue;
                array_scripts.put(sVersion, (CallSite)((Object)sScript));
            }
        } else {
            for (int x = iDBVersion + 1; x <= cAppVersion; ++x) {
                String sVersion = NumericUtils.encodeAppVersionNumber(x);
                String sScript = this.m_dlSystem.getInitScript() + "-upgrade-" + sVersion + ".sql";
                if (JRootApp.class.getResource(sScript) == null) continue;
                array_scripts.put(sVersion, (CallSite)((Object)sScript));
            }
        }
        if (array_scripts.size() > 0) {
            boolean add_permission_lock = false;
            boolean add_permission_paid = false;
            boolean add_min_max_option = false;
            boolean add_free_option = false;
            boolean add_permission_rappel_ticket = false;
            boolean add_permission_add_free_options = false;
            boolean add_permission_delete_lines = false;
            boolean add_local_screens = false;
            boolean add_product_prices = false;
            boolean add_number_orders = false;
            boolean add_payments_to_old_gtp = false;
            boolean add_taxes_global = false;
            boolean add_shifts = false;
            this.DropTableTaxes();
            for (Map.Entry entry : array_scripts.entrySet()) {
                String version_app = (String)entry.getKey();
                String sScript = (String)entry.getValue();
                try {
                    System.out.println("JRootApp.doUpgradeDB >>>>>> Preparing SQL : <<" + sScript + ">>");
                    BatchSentenceResource bsentence = new BatchSentenceResource(this.session, sScript);
                    bsentence.putParameter("APP_ID", Matcher.quoteReplacement("procaisse"));
                    bsentence.putParameter("APP_NAME", Matcher.quoteReplacement("Procaisse"));
                    bsentence.putParameter("APP_VERSION", Matcher.quoteReplacement(version_app));
                    bsentence.putParameter("pwd", Matcher.quoteReplacement(this.pwd));
                    bsentence.putParameter("pwdManager", Matcher.quoteReplacement(this.pwdManager));
                    bsentence.putParameter("pwdCaissier", Matcher.quoteReplacement(this.pwdCaissier));
                    List l = bsentence.list();
                    if (l.size() > 0) {
                        JMessageDialog.showMessage(new JFrame(), new MessageInf(-33554432, message_ScriptWarning, l.toArray(new Throwable[l.size()])));
                    }
                }
                catch (BasicException e) {
                    LogToFile.log("severe", e.getMessage(), e);
                    this.session.close();
                    return false;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PERMISSION_LOCK)) {
                    add_permission_lock = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PERMISSION_PAID)) {
                    add_permission_paid = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_MIN_MAX_OPTION)) {
                    add_min_max_option = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_FREE_OPTION)) {
                    add_free_option = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PERMISSION_RAPPEL_TICKET)) {
                    add_permission_rappel_ticket = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PERMISSION_ADD_FREE_OPTIONS)) {
                    add_permission_add_free_options = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PERMISSION_DELETE_LINES)) {
                    add_permission_delete_lines = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_LOCAL_SCREEN)) {
                    add_local_screens = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PRODUCT_PRICES)) {
                    add_product_prices = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_NUMBER_ORDERS)) {
                    add_number_orders = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_PAYMENTS_GTP) && AppLocal.MODULE_MEV) {
                    add_payments_to_old_gtp = true;
                }
                if (version_app.equalsIgnoreCase(this.VERSION_UPGRADE_TAXES_GLOBAL) && AppLocal.MODULE_MEV) {
                    add_taxes_global = true;
                }
                if (!version_app.equalsIgnoreCase(this.VERSION_UPGRADE_SHIFTS)) continue;
                add_shifts = true;
            }
            if (add_permission_lock) {
                this.addPermission(this.ID_PERMISSION_LOCK);
            }
            if (add_permission_paid) {
                this.addPermission(this.ID_PERMISSION_PAID);
            }
            if (add_min_max_option) {
                this.getTheOldInfoOptions();
            }
            if (add_free_option) {
                this.getTheOldInfoFreeOption();
            }
            if (add_permission_rappel_ticket) {
                this.addPermission(this.ID_PERMISSION_RAPPEL_TICKET);
            }
            if (add_permission_add_free_options) {
                this.addPermission(this.ID_PERMISSION_ADD_FREE_OPTIONS);
            }
            if (add_permission_delete_lines) {
                this.addPermission(this.ID_PERMISSION_DELETE_LINES);
            }
            if (add_local_screens) {
                this.addScreens();
            }
            if (add_product_prices) {
                this.addSizesProduct();
            }
            if (add_number_orders) {
                try {
                    ClotureService mClotureService = ClotureService.getInstance(this.m_dlSales, this);
                    mClotureService.updateNumberPlatform();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (add_shifts) {
                this.addShifts();
            }
            System.out.println("add_payments_to_old_gtp #############################. " + add_payments_to_old_gtp);
            if (add_payments_to_old_gtp) {
                this.addPaymentsToOldGTP();
            }
            if (add_taxes_global) {
                this.generateTotalTax();
            }
            try {
                this.m_dlSystem.upgradeSoftware(sDBVersion);
                this.softUpgraded = true;
                if (AppLocal.modeCaisse == null || AppLocal.modeCaisse != null && "yes".equals(AppLocal.modeCaisse)) {
                    Journal.writeToJET(new Event(260, "Initialisation des donn\u00e9es", " ", "Cr\u00e9ation de la base de donn\u00e9es ", new Date().getTime(), "3.94.47"));
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return true;
    }

    private int countUser() {
        try {
            return this.m_dlSystem.getCountUser();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return -1;
        }
    }

    private void addCountUser() {
        try {
            List<User> users = this.m_dlSystem.getAllUsers();
            for (User user : users) {
                this.m_dlSystem.addCounteruser(user.getId());
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void addPermission(String id_permission) {
        try {
            this.dlAdmin = (DataLogicAdmin)this.getBean("com.openbravo.pos.admin.DataLogicAdmin");
            List<User> users = this.m_dlSystem.getAllUsers();
            for (User user_permission : users) {
                this.dlAdmin.addPermission(user_permission.getId(), id_permission);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void getTheOldInfoOptions() {
        this.m_dlItems.getTheOldInfoOptions();
    }

    private void getTheOldInfoFreeOption() {
        this.m_dlItems.getTheOldInfoFreeOption();
    }

    public void hidePopUp() {
        for (Stage stage : AppLocal.listPopUp) {
            if (stage == null || !stage.isShowing()) continue;
            stage.close();
        }
        for (Alert alert : AppLocal.listAlert) {
            if (alert == null || !alert.isShowing()) continue;
            alert.close();
        }
        AppLocal.listPopUp.clear();
        AppLocal.listAlert.clear();
    }

    private void addScreens() {
        if (this.mItemService == null) {
            this.mItemService = ItemService.getInstance(this);
        }
        this.mItemService.updateIDsScreens();
    }

    private void setInfoLicence() {
        InfoLicenceGeneratedService mInfoLicenceGeneratedService = InfoLicenceGeneratedService.getInstance();
        mInfoLicenceGeneratedService.setInfoLicenceGenerated();
        if (AppLocal.getLicenceId() != null) {
            AppLocal.licence = AppLocal.MODULE_DELIVERY ? "livraison" : "restauration";
        }
    }

    private void addSizesProduct() {
        try {
            if (this.mItemService == null) {
                this.mItemService = ItemService.getInstance(this);
            }
            this.mItemService.addSizesProduct();
            this.mItemService.addPricesProduct();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void addPaymentsToOldGTP() {
        try {
            if (this.mTicketService == null) {
                this.mTicketService = TicketService.getInstance();
            }
            this.mTicketService.addPaymentsToOldGTP();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void generateTotalTax() {
        try {
            this.m_dlSales.generateTotalTax();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public Scene getScene_home_borne() {
        return this.scene_home_borne;
    }

    public void setScene_home_borne(Scene scene_home_borne) {
        this.scene_home_borne = scene_home_borne;
    }

    public Scene getHomeScene() {
        return this.currentScene != null ? this.currentScene : this.scene_home_borne;
    }

    private void addShifts() {
        this.m_dlItems.addShifts();
    }

    private void bulkDataInsertPostgre() {
        this.mPostgreService = PostgreService.getInstance();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JRootApp.this.mPostgreService.bulkDataInsert();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void showLoginManagerCashlogy() {
        System.out.println("++++++++++++showLoginManagerCashlogy+++++++++++");
        try {
            if (this.scene_login_backOffice_Cashlogy == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/selfcheckout/login.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mLoginSelfCheckoutController = (LoginSelfCheckoutController)loader.getController();
                this.scene_login_backOffice_Cashlogy = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_login_backOffice_Cashlogy.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_login_backOffice_Cashlogy.getStylesheets().add((Object)"/styles/app.css");
                this.mLoginSelfCheckoutController.initialize(this, this.scene_login_backOffice_Cashlogy);
            }
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_login_backOffice_Cashlogy));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void UpdateOldUserMaintain() {
        try {
            AppUser user = this.m_dlSales.getUserByPassword(Hashcypher.hashString("123666"));
            this.m_dlSales.UpdateOldUserMaintain(user, Hashcypher.hashString("123888"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showViewKey(String message_error, MarqueNFC marqueNFC, String keenio, JFXPanel fxPanel) {
        System.out.println("message_error : " + message_error);
        try {
            if (this.scene_view_key == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/popUp_licence.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mLicenceKeyController = (LicenceKeyController)loader.getController();
                this.scene_view_key = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_view_key.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_view_key.getStylesheets().add((Object)"/styles/app.css");
                this.mLicenceKeyController.initialize(this, message_error, marqueNFC, keenio);
            }
            Platform.runLater(() -> fxPanel.setScene(this.scene_view_key));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadFirstViewAfterCheckKeyLicence() {
        try {
            System.out.println("FIRST_INSTALL *********************: " + this.FIRST_INSTALL);
            if (this.FIRST_INSTALL) {
                this.saveValueDownloadOnlineJsonItemsAndParams();
            } else if (!AppLocal.GENERATE_ID_GLOBAL_ITEMS && AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone"))) {
                this.saveValueGenerateIdGlobal();
            }
            boolean is_master_conf = AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS && AppLocal.FRANCHISE_ID != null && !AppLocal.FRANCHISE_ID.isEmpty() && (AppLocal.MODEL_CAISSE == null || !AppLocal.MODEL_CAISSE.equalsIgnoreCase("Esclave"));
            boolean online_force_download = false;
            if (is_master_conf) {
                this.mFirebaseService = FirebaseService.getInstance();
                online_force_download = this.mFirebaseService.getStatusForceDownload();
            }
            System.out.println("********online_force_download :" + online_force_download);
            if (this.FIRST_LOAD_APP && is_master_conf || online_force_download && is_master_conf) {
                this.showViewDownloadDBItems();
            } else {
                this.showFirstViewAfterDownloadDBItems();
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void checkbeforeshowborne() {
        try {
            this.loadFirstView();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showViewConnectApp(String message_error, boolean isusedpassword, JFXPanel fxPanel, boolean blocked) {
        try {
            if (this.scene_view_connect_app == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/popUp_ConnectApp.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mConnectAppController = (ConnectAppController)loader.getController();
                this.scene_view_connect_app = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_view_connect_app.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_view_connect_app.getStylesheets().add((Object)"/styles/app.css");
                this.mConnectAppController.initialize(this, message_error, isusedpassword, blocked);
            }
            Platform.runLater(() -> fxPanel.setScene(this.scene_view_connect_app));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private Integer calculateDaysUsed(Date startDate, Date endDate) {
        long diff = endDate.getTime() - startDate.getTime();
        return (int)(diff / 86400000L);
    }

    public void dailycheckCaisse() {
        try {
            this.loadFirstView();
            this.clearM_jPanelContainer();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void clearM_jPanelContainer() {
        this.m_jPanelContainer.removeAll();
        this.m_jPanelContainer.add((Component)this.m_jPanelLogin, "");
        this.m_jPanelContainer.revalidate();
        this.m_jPanelContainer.repaint();
    }

    private boolean initBackup(String key_value) {
        boolean is_backup_task_created = false;
        String cleanedKeenIo = key_value.replaceAll("[^0-9]", "");
        String userName = Hashcypher.hashAccessBackUp(cleanedKeenIo);
        String userPassword = Hashcypher.hashAccessBackUp(cleanedKeenIo + "pa42");
        System.out.println("userName ******************: " + userName);
        System.out.println("userPassword ***************** : " + userPassword);
        BackupUtils backupUtils = new BackupUtils();
        boolean result = backupUtils.createUserFTP(userName, userPassword);
        System.out.println("result : " + result);
        if (result) {
            backupUtils.addInfosAccessToConfig(userName, userPassword);
            backupUtils.createBackupTask();
            is_backup_task_created = true;
        }
        return is_backup_task_created;
    }

    private boolean createTaskAutoRestart() {
        boolean is_created = false;
        System.out.println("AppLocal.modeCaisse : " + AppLocal.modeCaisse);
        if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equalsIgnoreCase("Borne")) {
            SystemUtils.createAutoStartTask();
            SystemUtils.createAutoStart();
            is_created = true;
        }
        return is_created;
    }

    private void saveConfigurationFTP(boolean is_configured) {
        System.out.println("*******************  saveConfigurationFTP() ************* " + is_configured);
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        if (is_configured) {
            config.setProperty("ftp.account.configured", "yes");
        } else {
            config.setProperty("ftp.account.configured", "no");
        }
        config.save();
    }

    public void initSetupFTP(final String key_value) {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean is_backup_task_created = JRootApp.this.initBackup(key_value);
                    boolean is_created = JRootApp.this.createTaskAutoRestart();
                    if (is_backup_task_created && (is_created || AppLocal.modeCaisse == null || !AppLocal.modeCaisse.equalsIgnoreCase("Borne"))) {
                        JRootApp.this.saveConfigurationFTP(true);
                    } else {
                        JRootApp.this.saveConfigurationFTP(false);
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showViewDownloadDBItems() {
        try {
            if (this.scene_view_download_items == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/DownLoadJsonDBItems.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.downLoadJsonDBItemController = (DownLoadJsonDBItemController)loader.getController();
                this.scene_view_download_items = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_view_download_items.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_view_download_items.getStylesheets().add((Object)"/styles/app.css");
                this.downLoadJsonDBItemController.initialize(this, true, null, null, null);
            }
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_view_download_items));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void showFirstViewAfterDownloadDBItems() {
        System.out.println("here we are 6");
        System.out.println("AppLocal.modeCaisse : " + AppLocal.modeCaisse);
        if (AppLocal.modeCaisse != null) {
            switch (AppLocal.modeCaisse) {
                case "Caisse": {
                    this.showCaisse();
                    break;
                }
                case "Borne": {
                    this.showBorne();
                    break;
                }
                case "Self-checkout": {
                    this.showSelfcheckout();
                    break;
                }
                default: {
                    this.showCaisse();
                    break;
                }
            }
        } else {
            this.showCaisse();
        }
        if (AppLocal.GENERATE_ID_GLOBAL_ITEMS && !AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS && AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone"))) {
            if (this.mItemService == null) {
                this.mItemService = ItemService.getInstance(this);
            }
            this.mItemService.setIdGlobalItems();
        }
        if (AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone"))) {
            try {
                this.mFirebaseService = FirebaseService.getInstance();
                this.mFirebaseService.uploadInfoMachine();
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void saveValueDownloadOnlineJsonItemsAndParams() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        config.setProperty("download.online.json.items", "yes");
        config.setProperty("synchro.param.firebase", "yes");
        config.setProperty("use.new.pop.up.options", "yes");
        config.setProperty("show.pop.up.choose.design.options", "no");
        config.save();
        AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS = true;
        AppLocal.SYNCHRO_PARAM_FIREBASE = true;
        AppLocal.USE_NEW_POP_UP_OPTIONS = true;
        AppLocal.SHOW_POP_UP_CHOOSE_DESIGN_OPTIONS = false;
    }

    private void saveValueGenerateIdGlobal() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        config.setProperty("generate.id.global.items", "yes");
        config.save();
        AppLocal.GENERATE_ID_GLOBAL_ITEMS = true;
    }

    private void showViewMessageToBeBlocked(String message_error, JFXPanel fxPanel) {
        try {
            if (this.scene_view_message_to_be_blocekd == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/messageToBeBlocked.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.messageToBeBlockedController = (MessageToBeBlockedController)loader.getController();
                this.scene_view_message_to_be_blocekd = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_view_message_to_be_blocekd.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_view_message_to_be_blocekd.getStylesheets().add((Object)"/styles/app.css");
                this.messageToBeBlockedController.initialize(this, message_error);
            }
            Platform.runLater(() -> fxPanel.setScene(this.scene_view_message_to_be_blocekd));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void addEventNewVersion(String oldVersion, String newVersion) throws IOException {
        boolean isMajorVersion = false;
        String[] oldVersionArray = oldVersion.split("\\.");
        String[] newVersionArray = newVersion.split("\\.");
        if (oldVersionArray != null && oldVersionArray.length > 0 && newVersionArray != null && newVersionArray.length > 0) {
            try {
                int oldVersionMajor = Integer.parseInt(oldVersionArray[0]);
                int newVersionMajor = Integer.parseInt(newVersionArray[0]);
                isMajorVersion = oldVersionMajor < newVersionMajor;
            }
            catch (NumberFormatException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (isMajorVersion) {
            Journal.writeToJET(new Event(250, "Nouvelle version majeure du logiciel", "", "Num\u00e9ro de version", new Date().getTime(), oldVersion + " => 10.0.1.27"));
        } else {
            Journal.writeToJET(new Event(255, "Nouvelle version mineure du logiciel", "", "Num\u00e9ro de version", new Date().getTime(), oldVersion + " => 10.0.1.27"));
        }
    }

    public void showSelfcheckout() {
        DateUtils.START_DATE = new Date();
        System.out.println("++++++++++++showSelfcheckout+++++++++++");
        try {
            if (this.scene_home_self_checkout == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/selfcheckout/self_checkout.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mSelfCheckoutController = (SelfCheckoutController)loader.getController();
                this.scene_home_self_checkout = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_home_self_checkout.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_home_self_checkout.getStylesheets().add((Object)"/styles/app.css");
                this.mSelfCheckoutController.initialize(this, this.scene_home_self_checkout);
            }
            this.SHOW_FIRST_VIEW_SELF_CHECKOUT = true;
            AppLocal.LOAD_ESPACE_MANAGER = false;
            AppLocal.page_home_selfcheckout = this.scene_home_self_checkout;
            AppLocal.SCAN_QR = true;
            if (AppLocal.CASHLOGY_ENABLED) {
                System.out.println("+++++++++ here 1");
                CashLogyServices mCashLogyServices = CashLogyServices.getInstance();
                mCashLogyServices.initMachine();
            }
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_home_self_checkout));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void showSelfcheckoutWithoutCashlogy() {
        System.out.println("++++++++++++showSelfcheckoutWithoutCashlogy+++++++++++");
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/selfcheckout/self_checkout.fxml"));
            Parent rootNode = (Parent)loader.load();
            this.mSelfCheckoutController = (SelfCheckoutController)loader.getController();
            this.scene_home_self_checkout = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
            this.scene_home_self_checkout.getStylesheets().add((Object)"/styles/styles.css");
            this.scene_home_self_checkout.getStylesheets().add((Object)"/styles/app.css");
            this.mSelfCheckoutController.initialize(this, this.scene_home_self_checkout);
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_home_self_checkout));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void showBorneWithoutCashlogy() {
        try {
            if (this.scene_home_borne == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/first_page.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMainController = (MainController)loader.getController();
                this.scene_home_borne = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.scene_home_borne.getStylesheets().add((Object)"/styles/styles.css");
                this.scene_home_borne.getStylesheets().add((Object)"/styles/app.css");
                this.mMainController.initialize(this, this.scene_home_borne, this.fxPanel);
            }
            this.SHOW_FIRST_VIEW_BORNE = true;
            AppLocal.LOAD_ESPACE_MANAGER = false;
            Platform.runLater(() -> this.fxPanel.setScene(this.scene_home_borne));
            this.bulkDataInsertPostgre();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected("www.google.com", 80, 5000);
    }

    static {
        JRootApp.initOldClasses();
    }

    private class PrintTimeAction
    implements ActionListener {
        private PrintTimeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }
}

